# $Id: TclScript.tcl,v 1.1 2001/10/13 18:52:49 Administrator Exp $

package require tcom
::tcom::import [file join [file dirname [info script]] TclScript.tlb]

namespace eval ::TclScriptEngine {
    # flags passed into AddNamedItem method
    array set SCRIPTITEM {
	ISVISIBLE       0x0002
	ISSOURCE        0x0004
	GLOBALMEMBERS	0x0008
	ISPERSISTENT    0x0040
	CODEONLY        0x0200
	NOCODE          0x0400
    }

    # log file handle
    variable file

    # SCRIPTSTATE
    variable scriptState

    # IActiveScriptSite
    variable scriptSite

    # code to execute
    variable code {}

    # list of names of items added
    variable namedItems {}

    # array that maps global member name to named item
    variable globalMemberToNamedItemMap

    proc constructor {} {
	upvar ::TclScript::tagSCRIPTSTATE SCRIPTSTATE
	variable file
	variable scriptState

	set file [open "c:/tclscript.txt" "w"]
	set scriptState $SCRIPTSTATE(SCRIPTSTATE_UNINITIALIZED)
    }

    proc destructor {} {
	close $::TclScriptEngine::file
    }

    proc createInstance {} {
	constructor
	return ::TclScriptEngine::servant
    }

    proc log {msg} {
	variable file

	if {[info exists file]} {
	    puts $file $msg
	    flush $file
	}
    }

    proc dumpInterface {obj} {
	set interface [::tcom::info interface $obj]

	set properties [$interface properties]
	foreach property $properties {
	    log "property $property"
	}

	set methods [$interface methods]
	foreach method $methods {
	    log "method [lrange $method 0 2] \{"
	    set parameters [lindex $method 3]
	    foreach parameter $parameters {
		log "    \{$parameter\}"
	    }
	    log "\}"
	}
    }

    proc servant {method args} {
	if {[catch {eval $method $args} result]} {
	    log $::errorInfo
	    error $result
	}
	return $result
    }

    proc evaluateCode {code} {
	variable scriptSite

	$scriptSite OnEnterScript
	uplevel #0 $code
	$scriptSite OnLeaveScript
    }

    proc changeScriptState {newState} {
	upvar ::TclScript::tagSCRIPTSTATE SCRIPTSTATE
	variable scriptSite

	set ::TclScriptEngine::scriptState $newState
	if {[info exists scriptSite]} {
	    $scriptSite OnStateChange $newState
	}

	switch -- $newState \
	    $SCRIPTSTATE(SCRIPTSTATE_STARTED) {
		evaluateCode $::TclScriptEngine::code
		set ::TclScriptEngine::code {}
	    }
    }

    # Request an IDispatch interface from the COM object.
    proc getDispatch {unknown} {
	return [::tcom::ref queryinterface $unknown \
	    {00020400-0000-0000-C000-000000000046}]
    }

    # IActiveScript implementation

    proc SetScriptSite {site} {
	log "IActiveScript::SetScriptSite"

	set ::TclScriptEngine::scriptSite [::TclScript::IActiveScriptSite $site]
    }

    proc GetScriptSite {iid ppvObject} {
	log "IActiveScript::GetScriptSite $iid"
	upvar $ppvObject pvObject 
	set pvObject $scriptSite
    }

    proc SetScriptState {newState} {
	upvar ::TclScript::tagSCRIPTSTATE SCRIPTSTATE
	variable scriptState

	log "IActiveScript::SetScriptState $newState"

	switch -- $newState \
	    $SCRIPTSTATE(SCRIPTSTATE_STARTED) {
		if {$scriptState != $SCRIPTSTATE(SCRIPTSTATE_INITIALIZED)} {
		    error "must be in INITIALIZED state to go to STARTED state"
		}
	    }

	if {$newState != $scriptState} {
	    changeScriptState $newState
	}
    }

    proc GetScriptState {pState} {
	log "IActiveScript::GetScriptState"
	upvar $pState state 
	set state $::TclScriptEngine::scriptState
    }

    proc Close {} {
	variable namedItems

	log "IActiveScript::Close"

	foreach name $namedItems {
	    upvar #0 $name item
	    unset item
	}
    }

    proc AddNamedItem {name flags} {
	variable SCRIPTITEM
	variable namedItems
	variable globalMemberToNamedItemMap

	log "IActiveScript::AddNamedItem $name $flags"

	set unknown [getiteminfo $::TclScriptEngine::scriptSite $name]

	if {[expr $flags & $SCRIPTITEM(GLOBALMEMBERS)] != 0} {
	    set interface [::tcom::info interface $unknown]

	    set properties [$interface properties]
	    foreach propertyDesc $properties {
		set propertyName [lindex $propertyDesc 3]
		log "global member $propertyName"
		set globalMemberToNamedItemMap($propertyName) $name
	    }
	}

	# Use IDispatch because passing parameters of type SAFEARRAY(VARIANT)
	# is broken.
	set unknown [getDispatch $unknown]

	if {[expr $flags & $SCRIPTITEM(ISVISIBLE)] != 0} {
	    upvar #0 $name item
	    set item $unknown
	    lappend namedItems $name
	}
    }

    proc AddTypeLib {libid major minor flags} {
	log "IActiveScript::AddTypeLib"
    }

    proc GetScriptDispatch {name ppDispatch} {
	log "IActiveScript::GetScriptDispatch $name"
	error "not implemented"
	upvar $ppDispatch pDispatch 
	set pDispatch [::tcom::object create ::TclScript::IActiveScript $name]
    }

    proc GetCurrentScriptThreadID {pScriptThreadId} {
	log "IActiveScript::GetCurrentScriptThreadID"
	upvar $pScriptThreadId scriptThreadId 
	set scriptThreadId 0
    }

    proc GetScriptThreadID {win32ThreadId pScriptThreadId} {
	log "IActiveScript::GetScriptThreadID"
	upvar $pScriptThreadId scriptThreadId 
	set scriptThreadId 0
    }

    proc GetScriptThreadState {scriptThreadId pScriptThreadState} {
	log "IActiveScript::GetScriptThreadState"
    }

    proc InterruptScriptThread {scriptThreadId excepInfo flags} {
	log "IActiveScript::InterruptScriptThread"
    }

    proc Clone {ppScript} {
	log "IActiveScript::Clone"
	upvar $ppScript pScript
	# set pScript [::tcom::object find ::TclScriptEngine::servant]
    }

    # IActiveScriptParse implementation

    proc InitNew {} {
	upvar ::TclScript::tagSCRIPTSTATE SCRIPTSTATE

	log "IActiveScriptParse::InitNew"

	changeScriptState $SCRIPTSTATE(SCRIPTSTATE_INITIALIZED)
    }

    proc AddScriptlet {
	defaultName code itemName subItemName eventName delimiter
	sourceContextCookie startingLineNumber flags pName pExcepInfo
    } {
	log "IActiveScriptParse::AddScriptlet $code"
    }

    proc ParseScriptText {
	code itemName pContext delimiter
	sourceContextCookie startingLineNumber flags pVarResult pExcepInfo
    } {
	upvar ::TclScript::tagSCRIPTSTATE SCRIPTSTATE

	set code [string map { \r\n \n } $code]
	log "IActiveScriptParse::ParseScriptText $code"

	switch -- $::TclScriptEngine::scriptState \
	    $SCRIPTSTATE(SCRIPTSTATE_INITIALIZED) {
		append ::TclScriptEngine::code $code
	    } \
	    $SCRIPTSTATE(SCRIPTSTATE_STARTED) - \
	    $SCRIPTSTATE(SCRIPTSTATE_CONNECTED) - \
	    $SCRIPTSTATE(SCRIPTSTATE_DISCONNECTED) {
		evaluateCode $code
	    } \
	    default {
		error "invalid script state $::TclScriptEngine::scriptState"
	    }
    }
}

::tcom::object registerfactory ::TclScript::Engine \
    {::TclScriptEngine::createInstance} {::TclScriptEngine::destructor}
