# Tcl package index file - handcrafted
#
# $Id: pkgIndex.tcl.in,v 1.9 2002/08/30 07:52:16 balls Exp $

package ifneeded xml::c 2.3 [list load [file join $dir .. .. bin tclxml20.dll]]
package ifneeded xml::tcl 2.3 [list source [file join $dir xml__tcl.tcl]]
package ifneeded xml::expat 2.3 [list load [file join $dir .. .. bin tclexpat20.dll]]
#package ifneeded xml::xerces 2.0 [list load [file join $dir .. .. bin 20.dll]]
package ifneeded sgmlparser 1.1 [list source [file join $dir sgmlparser.tcl]]

package ifneeded xpath 1.0 [list source [file join $dir xpath.tcl]]
package ifneeded xmldep 1.0 [list source [file join $dir xmldep.tcl]]

namespace eval ::xml {}

# Requesting a specific package means we want it to be the default parser class.
# This is achieved by loading it last.

# expat and xerces packages must have xml::c package loaded
package ifneeded expat 2.3 {
    package require xml::c 2.3
    package require xmldefs
    package require xml::tclparser 2.3
    package require xml::expat 2.3
    package provide expat 2.3
}

# tclparser works with either xml::c or xml::tcl
package ifneeded tclparser 2.3 {
    if {[catch {package require xml::c 2.3}]} {
	# No point in trying to load expat
	package require xml::tcl 2.3
	package require xmldefs
	package require xml::tclparser 2.3
    } else {
	package require xmldefs
	catch {package require xml::expat 2.3}
	package require xml::tclparser
    }
    package provide tclparser 2.3
}

# use tcl only (mainly for testing)
package ifneeded puretclparser 2.3 {
    package require xml::tcl 2.3
    package require xmldefs
    package require xml::tclparser 2.3
    package provide puretclparser 2.3
}                                        

# Requesting the generic package leaves the choice of default parser automatic

package ifneeded xml 2.3 {
    if {[catch {package require xml::c 2.3}]} {
	package require xml::tcl 2.3
	package require xmldefs
	# Only choice is tclparser
	package require xml::tclparser 2.3
    } else {
	package require xmldefs
	package require xml::tclparser 2.3
	catch {package require xml::expat 2.3}
    }
    package provide xml 2.3
}

if {[info tclversion] <= 8.0} {
    package ifneeded sgml 1.9 [list source [file join $dir sgml-8.0.tcl]]
    package ifneeded xmldefs 2.3 [list source [file join $dir xml-8.0.tcl]]
    package ifneeded xml::tclparser 2.3 [list source [file join $dir tclparser-8.0.tcl]]
} else {
    package ifneeded sgml 1.9 [list source [file join $dir sgml-8.1.tcl]]
    package ifneeded xmldefs 2.3 [list source [file join $dir xml-8.1.tcl]]
    package ifneeded xml::tclparser 2.3 [list source [file join $dir tclparser-8.1.tcl]]
}


