      program main
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C                                                                      %
C Copyright (C) 1996, The Board of Trustees of the Leland Stanford     %
C Junior University.  All rights reserved.                             %
C                                                                      %
C The programs in GSLIB are distributed in the hope that they will be  %
C useful, but WITHOUT ANY WARRANTY.  No author or distributor accepts  %
C responsibility to anyone for the consequences of using them or for   %
C whether they serve any particular purpose or work at all, unless he  %
C says so in writing.  Everyone is granted permission to copy, modify  %
C and redistribute the programs in GSLIB, but only under the condition %
C that this notice and the above copyright notice remain intact.       %
C                                                                      %
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c-----------------------------------------------------------------------
c
c                          Plot Variograms
c                          ***************
c
c This is the driver program for GSLIB's "vargplt" subroutine.  The
c input data is in the format of the output generated by the gam,
c gamv, or vmodel programs.
c
c The program is executed with no command line arguments.  The user
c will be prompted for the name of a variogram file and optional scaling
c parameters:
c
c
c
c-----------------------------------------------------------------------
      parameter (MAXLAG=250, BIGNUM=1.0e21,EPSLON=.00001, VERSION=2.000)

      character  datafl*80,rootnam*80,outfl*80,title*80,str*80,dum*4
      real       ar1(MAXLAG),ar2(MAXLAG)
      logical    testfl,reset,first,finish
c
c Common variables for Postscript Plotting:
c
      common /psdata/ lpsout,pscl,pxmin,pxmax,pymin,pymax,xmin,
     +                xmax,ymin,ymax
      common /olddat/ xvmn,xvmx,yvmn,yvmx
c
c Hardwire many of the plot parameters:
c
      data lin/1/,lpsout/2/,pscl/0.24/,pxmin/0.0/,pxmax/288.0/
     +     pymin/0.0/,pymax/216.0/,xmin/-10.0/,xmax/60.0/,
     +     ymin/-10.0/,ymax/60.0/,vpxmin/1.0/,vpxmax/59.5/,
     +     vpymin/0.0/,vpymax/58.0/,lostr/80/,finish/.false./,
     +     first/.true./
c
c Note VERSION number:
c
      write(*,9999) VERSION
 9999 format(/' VARGPLT Version: ',f5.3/)
c
c Get the name of the input file:
c
      write(*,*) ' Which input variogram file do you want?'
      read (*,'(a80)') datafl
      inquire(file=datafl,exist=testfl)
      if(.not.testfl) then
            write(*,*) 'ERROR - the variogram file does not exist,'
            write(*,*) '        check for the file and try again  '
            stop
      endif
      open(lin,file=datafl,status='OLD')
      write(*,*)
c
c Get the root name of the output file:
c
      write(*,*) ' Please enter a root file name (the output will be'
      write(*,*) '    put in files ending with .001 .002 and so on):'
      read (*,'(a80)') rootnam
      call rmtrail(rootnam,lostr,lost)
      lost4 = lost + 4
 600  format('.',i3.3)
c
c Loop through the variogram file:
c
      read(lin,'(a80)',end=31) str
      xvmin =  0.0
      xvmax = -BIGNUM
      yvmin =  BIGNUM
      yvmax = -BIGNUM
      iv  = 0
 1    np  = 0
      title = str(1:80)
 2    read(lin,'(a80)',end=31) str
c
c Kludge:
c
      go to 41
 31   finish=.true.
      str(1:1) = 'a'
 41   continue
c
c Process this line of input from variogram file:
c
      if(str(1:1).ne.' ') then
            if(np.eq.0) go to 1
            iv = iv + 1
c
c Figure out a file name for the variogram, are these box plots?
c
            if(title(1:3).eq.'BOX') then
                  read(title,'(3x,7f10.3)') dist,zmin,zlq,zmed,
     +                                           zmen,zuq,zmax
                  call boxplt(vpxmin,vpxmax,vpymin,vpymax,xvmn,xvmx,
     +                 yvmn,yvmx,zmin,zlq,zmed,zmen,zuq,zmax,dist)
                  if(finish) then
                        write(lpsout,999)
                        close(lpsout)
                        close(lin)
                        go to 9997
                  end if
                  go to 1
            end if
c
c Append this variogram to the current file?
c
            if(first) then
                  ivo   = 1
                  write(dum,600) ivo
                  outfl = rootnam(1:lost)//dum(1:4)
                  open(lpsout,file=outfl(1:lost4),status='UNKNOWN')
                  write(lpsout,998) str(1:40)
            endif
            write(*,*) '  '
            write(*,*) 'NOW: variogram number    ',iv
            write(*,*) '     variogram title     ',title
            write(*,*) '     current output file ',outfl(1:20)
            if(first) then
                  first = .false.
                  reset = .true.
            else
                  write(*,*) 'KEEP the current file? (y/n/q)'
                  read(*,'(a1)') dum(1:1)
                  if(dum(1:1).eq.'Y'.or.dum(1:1).eq.'y') then
                        reset = .false.
                  else if(dum(1:1).eq.'q') then
                        write(lpsout,999)
                        close(lpsout)
                        go to 9997
                  else
                       write(lpsout,999)
                       close(lpsout)
                       reset = .true.
                       ivo   = ivo + 1
                       write(dum,600) ivo
                       outfl = rootnam(1:lost)//dum(1:4)
                       open(lpsout,file=outfl(1:lost4),status='UNKNOWN')
                       write(*,*) '     opening ',outfl(1:20)
                       write(lpsout,998) str(1:40)
                  endif
            endif
c
c See if the user wants to set the scale and then plot the varigoram:
c
            if(reset) then
                  if(yvmin.gt.0.0) yvmin = 0.0
                  write(*,*) 'CHANGE scaling parameters? (y/n/q)'
                  read(*,'(a1)') dum(1:1)
                  if(dum(1:1).eq.'Y'.or.dum(1:1).eq.'y') then
                  write(*,*) 'Distance scaling: ',xvmin,xvmax
                  write(*,*) 'Enter new values:'
                  read(*,*)   xvmin,xvmax
                  write(*,*) 'Variogram scaling: ',yvmin,yvmax
                  write(*,*) 'Enter new values:'
                  read(*,*)   yvmin,yvmax
                  else if(dum(1:1).eq.'q') then
                        write(lpsout,999)
                        close(lpsout)
                        go to 9997
                  endif
            endif
            call vargplt(np,ar1,ar2,vpxmin,vpxmax,vpymin,vpymax,
     +                   xvmin,xvmax,yvmin,yvmax,title,reset)
            xvmin =  0.0
            xvmax = -BIGNUM
            yvmin =  BIGNUM
            yvmax = -BIGNUM
            if(finish) then
                  write(lpsout,999)
                  close(lpsout)
                  close(lin)
                  go to 9997
            endif
            go to 1
      else
            np = np + 1
            backspace lin
            read(lin,*) ii,ar1(np),ar2(np)
            if(ar1(np).lt.EPSLON) then
                  np = np - 1
            else
                  xvmin = min(xvmin,ar1(np))
                  xvmax = max(xvmax,ar1(np))
                  yvmin = min(yvmin,ar2(np))
                  yvmax = max(yvmax,ar2(np))
            endif
            go to 2
      endif
 998  format('%!PS                                 %    Remove     ',
     +    /, '90 234 translate 1.5 1.5 scale       %  these lines  ',
     +    /, '                                     % for EPSF file ',
     +    /, '%!PS-Adobe-3.0 EPSF-3.0',
     +    /, '%%BoundingBox: 0 0 288 216',
     +    /, '%%Creator: GSLIB',
     +    /, '%%Title:   ',a40,
     +    /, '%%CreationDate: ',
     +    /, '%%EndComments',/,/,/,'%',/,'%',/,'%',/,
     +    /, '/m {moveto} def /l {lineto} def /r {rlineto} def',
     +    /, '/s {stroke} def /n {newpath} def /c {closepath} def',
     +    /, '/rtext{ dup stringwidth pop -1 div 0 rmoveto show } def',
     +    /, '/ctext{ dup stringwidth pop -2 div 0 rmoveto show } def',
     +    /, '/ltext{show} def /gr{grestore} def /gs{gsave} def',
     +    /, '/tr{translate} def /setc{setrgbcolor} def',
     +    /, '/bullet{ 6 0 360 arc c fill } def',/,/,
     +    /, '%72 72 translate',/,/,
     +    /, '0.240000 0.240000 scale')
 999  format('%END OF POSTSCRIPT FILE',/,'4.166667 4.166667 scale',/,/,
     +       '%%EOF',/,'showpage')
c
c Finished:
c
 9997 write(*,9998) VERSION
 9998 format(/' VARGPLT Version: ',f5.3, ' Finished'/)
      stop
      end



      subroutine vargplt(np,ar1,ar2,vpxmin,vpxmax,vpymin,vpymax,
     +                   xvmin,xvmax,yvmin,yvmax,title,reset)
c-----------------------------------------------------------------------
c
c                          Variogram Plotting
c                          ******************
c
c
c PARAMETERS:
c      np      The number of pairs to plot
c      ar1     The distance (x axis)
c      ar2     The variogram value
c      vpxmin  minimum X to use for variogram plotting
c      vpxmax  maximum X to use for variogram plotting
c      vpymin  minimum Y to use for variogram plotting
c      vpymax  maximum Y to use for variogram plotting
c
c
c
c-----------------------------------------------------------------------
      real      ar1(*),ar2(*),xx(250),yy(250)
      character title*80
      logical   reset
      save      idash,xvmn,xvmx,yvmn,yvmx
c
c Common variables for Postscript Plotting:
c
      common /psdata/ lpsout,pscl,pxmin,pxmax,pymin,pymax,wxmin,
     +                  wxmax,wymin,wymax
c     common /olddat/ xvmn,xvmx,yvmn,yvmx
c
c Label the axes and write the title if reset is true:
c
      xrange = vpxmax - vpxmin
      yrange = vpymax - vpymin
      if(reset) then
            ts   = 7.5
            xvmn = xvmin
            xvmx = xvmax
            yvmn = yvmin
            yvmx = yvmax
            write(lpsout,100)
 100        format('gsave /Symbol findfont 100 scalefont setfont ',
     +             '0 501 m (g) rtext grestore')
            xloc = vpxmin + 0.50*xrange
            yloc = vpymin - 0.15*yrange
            call pstext(xloc,yloc,8,'Distance',ts,1,0.0,1)
            xloc = vpxmin
            yloc = vpymax + 0.01*(vpxmax-vpxmin)
            call pstext(xloc,yloc,80,title,9.0,3,0.0,0)
            idash = -1
            ilog = 0
            i45  = 0
c
c Scale and Draw the axes:
c
            call scal(xvmin,xvmax,yvmin,yvmax,vpxmin,vpxmax,
     +                vpymin,vpymax,ilog,i45)
      endif
c
c Now mark all the points:
c
      if(title(1:2).ne.'Mo') then
            do i=1,np
                  xloc = resc(xvmn,xvmx,vpxmin,vpxmax,ar1(i))
                  yloc = resc(yvmn,yvmx,vpymin,vpymax,ar2(i))
                  ix = int((resc(wxmin,wxmax,pxmin,pxmax,xloc))/pscl)
                  iy = int((resc(wymin,wymax,pymin,pymax,yloc))/pscl)
                  if(ix.lt.0)    ix = 0
                  if(iy.lt.0)    iy = 0
                  if(ix.gt.2000) ix = 2000
                  if(iy.gt.2000) iy = 2000
                  write(lpsout,32) ix,iy
            end do
      endif
 32   format('n ',i4.4,1x,i4.4,' bullet')
c
c Draw a light dashed line connecting the experimental variogram points:
c
      idash = idash + 1
      do i=1,np
            xx(i) = resc(xvmn,xvmx,vpxmin,vpxmax,ar1(i))
            yy(i) = resc(yvmn,yvmx,vpymin,vpymax,ar2(i))
      end do
      call psline(np,xx,yy,0.3,idash)
c
c Return to calling program:
c
      return
      end



      subroutine rmtrail(str,lostr,lost)
c-----------------------------------------------------------------------
c
c Find out how much of character string is non-blank - return length
c
c-----------------------------------------------------------------------
      character  str*80
      lost = lostr
      do i=1,lostr
            ix = lostr - i + 1
            if(str(ix:ix).ne.' ') return
            lost = lost - 1
      end do
      return
      end



      subroutine boxplt(vpxmin,vpxmax,vpymin,vpymax,xvmin,xvmax,
     +                  yvmin,yvmax,zmin,zlq,zmed,zmen,zuq,zmax,dist)
c-----------------------------------------------------------------------
c
c                          Box Plot of Variograms
c                          **********************
c
c PARAMTERS:
c      vpxmin,vpxmax    X limits for variogram on plot
c      vpymin,vpymax    Y limits for variogram on plot
c      xvmin,xvmax      Distance limits established from file
c      yvmin,yvmax      Variogram limits established from file
c      zmin,zlu,zmed,zmen,zuq,zmax      Box plot parameters from file
c      dist             Distance for box plot.
c
c
c
c-----------------------------------------------------------------------
      real xx(6),yy(6)
c
c Common variables for Postscript Plotting:
c
      common /psdata/ lpsout,pscl,pxmin,pxmax,pymin,pymax,wxmin,
     +                wxmax,wymin,wymax
      write(lpsout,100)
 100  format('%',/,'% BOX PLOT:',/,'%')
c
c Draw a light line connecting the minimum and maximum:
c
      np   = 6
      disl = dist - 0.010*(xvmax-xvmin)
      dish = dist + 0.010*(xvmax-xvmin)
      xx(1) = resc(xvmin,xvmax,vpxmin,vpxmax,disl)
      xx(2) = resc(xvmin,xvmax,vpxmin,vpxmax,dish)
      xx(3) = resc(xvmin,xvmax,vpxmin,vpxmax,dist)
      xx(4) = resc(xvmin,xvmax,vpxmin,vpxmax,dist)
      xx(5) = resc(xvmin,xvmax,vpxmin,vpxmax,disl)
      xx(6) = resc(xvmin,xvmax,vpxmin,vpxmax,dish)
      yy(1) = resc(yvmin,yvmax,vpymin,vpymax,zmax)
      yy(2) = resc(yvmin,yvmax,vpymin,vpymax,zmax)
      yy(3) = resc(yvmin,yvmax,vpymin,vpymax,zmax)
      yy(4) = resc(yvmin,yvmax,vpymin,vpymax,zmin)
      yy(5) = resc(yvmin,yvmax,vpymin,vpymax,zmin)
      yy(6) = resc(yvmin,yvmax,vpymin,vpymax,zmin)
      call psline(np,xx,yy,0.3,0)
c
c Draw the box at the quartiles:
c
      np   = 5
      xx(1) = resc(xvmin,xvmax,vpxmin,vpxmax,disl)
      xx(2) = resc(xvmin,xvmax,vpxmin,vpxmax,disl)
      xx(3) = resc(xvmin,xvmax,vpxmin,vpxmax,dish)
      xx(4) = resc(xvmin,xvmax,vpxmin,vpxmax,dish)
      xx(5) = resc(xvmin,xvmax,vpxmin,vpxmax,disl)
      yy(1) = resc(yvmin,yvmax,vpymin,vpymax,zlq )
      yy(2) = resc(yvmin,yvmax,vpymin,vpymax,zuq )
      yy(3) = resc(yvmin,yvmax,vpymin,vpymax,zuq )
      yy(4) = resc(yvmin,yvmax,vpymin,vpymax,zlq )
      yy(5) = resc(yvmin,yvmax,vpymin,vpymax,zlq )
      call psfill(np,xx,yy,0.3,0.93)
c
c Draw the line at the median:
c
      np   = 2
      xx(1) = resc(xvmin,xvmax,vpxmin,vpxmax,disl)
      xx(2) = resc(xvmin,xvmax,vpxmin,vpxmax,dish)
      yy(1) = resc(yvmin,yvmax,vpymin,vpymax,zmed)
      yy(2) = resc(yvmin,yvmax,vpymin,vpymax,zmed)
      call psline(np,xx,yy,1.0,0)
c
c Now mark the mean:
c
      xloc = resc(xvmin,xvmax,vpxmin,vpxmax,dist)
      yloc = resc(yvmin,yvmax,vpymin,vpymax,zmen)
      ix = int((resc(wxmin,wxmax,pxmin,pxmax,xloc))/pscl)
      iy = int((resc(wymin,wymax,pymin,pymax,yloc))/pscl)
      write(lpsout,32) ix,iy
 32   format('n ',i4.4,1x,i4.4,' bullet')
c
c Return to calling program:
c
      return
      end
