# $Id: server.tcl,v 1.2 2001/08/17 02:09:15 cthuang Exp $
package provide Banking 1.0

package require tcom
::tcom::import [file join [file dirname [info script]] Banking.tlb]

proc account {method args} {
    global balance

    switch -- $method {
	_get_balance {
	    return $balance
	}

	deposit {
	    set amount [lindex $args 0]
	    set balance [expr $balance + $amount]
	}

	withdraw {
	    set amount [lindex $args 0]
	    set balance [expr $balance - $amount]
	}
	
	default {
	    error "unknown method $method $args"
	}
    }
}

proc bank {method args} {
    global balance

    switch -- $method {
	create {
	    set balance 0
	    return [::tcom::object create ::Banking::Account account]
	}
	
	default {
	    error "unknown method $method $args"
	}
    }
}

::tcom::object registerfactory ::Banking::Bank {list bank}
