function mesh = genBisectionMesh(mesh, mode)
%GENBISECTIONMESH    Generates a mesh, which is valid for adaptive bisection.
%   MESH = GENBISECTIONMESH(MESH) makes the mesh valid for bisection. In
%   the 1D and 2D case this does not change the mesh, we only store the
%   number of initial coordinates as to not coarsen those, in case of a
%   call to bisectionCoarsen. For the 3D-case a compatible mesh is
%   generated by refinement via GENBISECTIONMESH3D. For the 2D-case you can
%   force a compatibility-refinement of the initial mesh, via 
%   MESH = GENBISECTIONMESH(MESH, 'forceRefine');
%   This will result in a mesh, that can be coarsened back to its original
%   form, without this option this is not necessarily true. For more
%   information see the example in BISECTIONCOARSEN2D.
%
%   Works for 1 and 2 dimensional meshes in R^d and 3-dimensional meshes in
%   R^3 only.
%
%   See also:
%   BISECTIONREFINE
%   BISECTIONCOARSEN
%
% Author: Josef Kemetmueller - 20.03.13

assert(dimMesh(mesh)<=3, 'Sorry, there is no bisection for d=%d',dimMesh(mesh));

switch dimMesh(mesh)
    case 1
        mesh.N0 = size(mesh.coordinates,1);
    case 2
        mesh.N0 = size(mesh.coordinates,1);
        if exist('mode', 'var')
            assert(strcmpi(mode,'forcerefine'), 'Unknown option %s',mode);
            mesh = genBisectionMesh2D(mesh);
        end
    case 3
        mesh = genBisectionMesh3D(mesh);
end