function CtrlVar=CtrlVarValidityCheck(CtrlVar)

%  Performs some basic validity checks on CtrlVar


fn = fieldnames(CtrlVar.MustBe);
for I=1:numel(fn)
    CheckUaCtrlVarFields(CtrlVar,fn{I})
end

%% is user still using doDiagnosti/doPrognostic, set TimeDependentRun accordingly
if isfield(CtrlVar,'doDiagnostic')
    if CtrlVar.doDiagnostic
        CtrlVar.TimeDependentRun=0 ;
    else
        CtrlVar.TimeDependentRun=1 ;
    end
end


if isfield(CtrlVar,'doPrognostic')
    if CtrlVar.doPrognostic
        CtrlVar.TimeDependentRun=1 ;
    else
        CtrlVar.TimeDependentRun=0 ;
    end
end

if isfield(CtrlVar,'doInverseStep')
    if CtrlVar.doInverseStep
        CtrlVar.InverseRun=1;
    else
        CtrlVar.InverseRun=0;
    end
end




%%

if CtrlVar.TimeDependentRun
    CtrlVar.doDiagnostic=0  ;
    CtrlVar.doPrognostic=1 ;
else
    CtrlVar.doDiagnostic=1  ;
    CtrlVar.doPrognostic=0 ;
end

if CtrlVar.InverseRun
    CtrlVar.doInverseStep=1 ;
else
    CtrlVar.doInverseStep=0 ;
end

if ~ismember(CtrlVar.TriNodes,[3 6 10])
    fprintf(CtrlVar.fidlog,'CtrlVar.Trinodes=%-i but must be either 3, 6 or 10 \n',CtrlVar.TriNodes);
    error('Ua:CtrlVarValidityCheck:Trinodes','CtrlVar not valid')
end


%% if user requires an inverse step, set prognostic and diagnostic flags to zero
if CtrlVar.InverseRun    % inverse step takes precedence over prognostic and diagnostic, if conflict
    CtrlVar.doDiagnostic=0  ;
    CtrlVar.doPrognostic=0 ;
    CtrlVar.AdaptMesh=0;
    CtrlVar.MUA.MassMatrix=true;
    CtrlVar.MUA.StiffnessMatrix=true;
end


if CtrlVar.InverseRun  && contains(CtrlVar.SlidingLaw,["Coulomb","-C-"])
    fprintf("Inversion using %s sliding law is not possible!\n",CtrlVar.SlidingLaw)
    error('Ua:CtrlVarValidityCheck:InverseAdapt','CtrlVar not valid')
end

%%

if CtrlVar.ForwardTimeIntegration==""  %  "-uvh-" , "-uv-h-" ,  "-uv-" , "-h-" ;

    if  CtrlVar.TimeDependentRun
        CtrlVar.ForwardTimeIntegration="-uvh-";
    else
        CtrlVar.ForwardTimeIntegration="-uv-";
    end

else

    if CtrlVar.ForwardTimeIntegration=="-uv-"  || CtrlVar.ForwardTimeIntegration=="-phi-"
        CtrlVar.TimeDependentRun=0;
    else
        CtrlVar.TimeDependentRun=1;
    end

end

% Again, if inverse run, the modify accordingly
if CtrlVar.InverseRun    % inverse step takes precedence over prognostic and diagnostic, if conflict
    CtrlVar.doDiagnostic=0  ;
    CtrlVar.doPrognostic=0 ;
    CtrlVar.TimeDependentRun=0;
end

%%




if CtrlVar.doplots==0 ; CtrlVar.PlotMesh=0; end

if CtrlVar.StandartOutToLogfile
    CtrlVar.fidlog=fopen(CtrlVar.Logfile,'w');
else
    CtrlVar.fidlog=1;
end

% make sure that Cmin is zero in the SSHEET and the Hybrid flow approximation
if strcmpi(CtrlVar.FlowApproximation,'ssheet') || strcmpi(CtrlVar.FlowApproximation,'hybrid')
    if CtrlVar.Cmin>0
        fprintf('In the SSHEET and the Hybrid flow approximations Cmin must be zero. Cmin set to zero.\n')
        CtrlVar.Cmin=0;
    end
end

if CtrlVar.TimeDependentRun &&  ~CtrlVar.Restart
    CtrlVar.InitialDiagnosticStep=1;  % Always do an initial diagnostic step when starting a transient run. But if a restart run, then do not change this value from that set by the user.
    % An initial diagnostic step is therefore done if:
    % 1) so asked by the user, ie if the user sets CtrlVar.InitialDiagnosticStep=1, and
    % 2) at the beginning of an implicit uvh transient run.
    % Unless asked by the user, no initial diagnostic step is done at the beginning of an implicit uvh transient restart run.
end

% AdaptMesh not allowed in combination with an inverse run

if CtrlVar.AdaptMesh && CtrlVar.InverseRun
    fprintf('UaError: Both CtrlVar.AdaptMesh and CtrlVar.InverseRun are set to true!\n')
    fprintf('As adaptive meshing can only be done in a combination with a forward run this combination is not allowed.\')
    error('Ua:CtrlVarValidityCheck:InverseAdapt','CtrlVar not valid')
    
end


if isfield(CtrlVar,'nTimeSteps')
    warning('Ua:CtrlVarValidityCheck:nTimeSteps','The field nTimeSteps in the strucure array CtlrVar no longer used. Use the TotalNumberOfForwardRunSteps field instead')
    CtrlVar.TotalNumberOfForwardRunSteps=CtrlVar.nTimeSteps;
end

if isfield(CtrlVar,'GmeshFile')
    error('Ua:CtrlVarValidyCheck','The field CtrlVar.GmeshFile no longer used. Replace with CtrlVar.GmshFile.')
end


if isfield(CtrlVar,'GmeshMeshingAlgorithm')
    error('Ua:CtrlVarValidyCheck','The field CtrlVar.GmeshMeshingAlgorithm no longer used. Replace with CtrlVar.GmshMeshingAlgorithm.')
end

%% adapt

if isfield(CtrlVar,'AdaptMeshIterations')
    
    fprintf('Note: CtrlVar.AdaptMeshIterations is no longer used.\n')
    fprintf('Use   CtrlVar.AdaptMeshMaxIterations instead.\n')
    error('Ua:CtrlVarValidyCheck','The field CtrlVar.AdaptMeshIterations is no longer used. Replace with CtrlVar.AdaptMeshMaxIterations')
    
end





%% inverse

if CtrlVar.InverseRun
    
    % First make sure that CtrlVar.Inverse.InvertFor and CtrlVar.Inverse.Regularize.Field
    % only contain some combinations of "-C-","-logC-","-AGlen-","-logAGlen-" and
    % "-B-"
    %
    % for example : "-A-C-"  -> "-AGlen-C-"
    
    [CtrlVar.Inverse.InvertFor,status]=SearchAndReplaceInverseFieldsInCtrlVar(CtrlVar.Inverse.InvertFor);
    
    if ~status
        fprintf(" CtrlVar.Inverse.InvertFor does not appear to have a valid value.\n")
        fprintf(" CtrlVar.Inverse.InvertFor=%s \n",CtrlVar.Inverse.InvertFor)
        error("CtrlVarValidityCheck:CtrlVar.Inverse.InvertForInvalid")
    end
    
    
    
    [CtrlVar.Inverse.Regularize.Field,status]=SearchAndReplaceInverseFieldsInCtrlVar(CtrlVar.Inverse.Regularize.Field);
    
    if ~status
        fprintf(" CtrlVar.Inverse.Regularize.Field does not appear to have a valid value.\n")
        fprintf(" CtrlVar.Inverse.Regularize.Field=%s \n",CtrlVar.Inverse.Regularize.Field);
        error("CtrlVarValidityCheck:CtrlVar.Inverse.Regularize.Field")
    end
    
    if strcmpi(CtrlVar.Inverse.DataMisfit.GradientCalculation,"fixpoint")
        
        % if fixpoint, then only c inversion is possible
        CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"logAGlen","");
        CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"Aglen","");
        CtrlVar.Inverse.InvertFor=replace(CtrlVar.Inverse.InvertFor,"logAGlen","");
        CtrlVar.Inverse.InvertFor=replace(CtrlVar.Inverse.InvertFor,"AGlen","");
        
        
        
    end
    
    % Don't regularize A if not inverting for A, so
    if ~contains(CtrlVar.Inverse.InvertFor,"AGlen")
        
        CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"-logAGlen-","-");
        CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"-AGlen-","-");
        
        
    end
    
    % Don't regularize C if not inverting for C
    if ~contains(CtrlVar.Inverse.InvertFor,"C")
        
        CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"-logC-","-");
        CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"-C-","-");


    end

    CtrlVar.Inverse.Regularize.Field=replace(CtrlVar.Inverse.Regularize.Field,"--","-");
    CtrlVar.Inverse.InvertFor=replace(CtrlVar.Inverse.InvertFor,"--","-");

    if ~contains(lower(CtrlVar.Inverse.DataMisfit.GradientCalculation),["fixpoint","adjoint"])
        fprintf('the string CtrlVar.Inverse.DataMisfit.GradientCalculation must contain either ''fixpoint'' or ``adjoint` \n')
        error('Invalid inputs.')
    end

    % create a string with letters indicating which fields are being inverted for
    % e.g "ABC" if inverting for AGlen, B and C.
    CtrlVar.Inverse.InvertForField=string(sort(char(replace(replace(replace(string(CtrlVar.Inverse.InvertFor),"log","") ,"-",""),"AGlen","A")))) ;


    if contains(CtrlVar.Inverse.MinimisationMethod,"MatlabOptimization")

        if CtrlVar.Inverse.MinimisationMethod=="MatlabOptimization"
            fprintf("Inversion is HessianBased, ie provides a Hessian approximation. \n")
            CtrlVar.Inverse.MinimisationMethod="MatlabOptimization-HessianBased";
        end

    end

    if CtrlVar.Inverse.MinimisationMethod=="MatlabOptimization-HessianBased" && CtrlVar.TriNodes>3


        fprintf("Using CtrlVar.Inverse.MinimisationMethod=%s for other then linear elements (ie for CtrlVar.TriNodes>3) is not recommended. \n",CtrlVar.Inverse.MinimisationMethod)
        fprintf('Consider setting CtrlVar.Inverse.MinimisationMethod="MatlabOptimization-GradientBased" or using linear elements. \n')
        warning("UaInputs:ParameterCombinationNotRecommended","ParameterCombinationNotRecommented")

    end



    if contains(CtrlVar.Inverse.MinimisationMethod,'Hessian')

        CtrlVar.Inverse.AdjointGradientPreMultiplier='I';

    end

    if contains(CtrlVar.Inverse.InvertFor,"logA")

        if isempty(CtrlVar.Inverse.Regularize.logAGlen.ga)

            fprintf("\n\n ======> The variable CtrlVar.Inverse.Regularize.logAGlen.ga is empty, but needs to be defined in a logA inversion.\n")
            error("CtrlVarValidityCheck: missing input ")

        end

        if isempty(CtrlVar.Inverse.Regularize.logAGlen.gs)

            fprintf("\n\n ======> The variable CtrlVar.Inverse.Regularize.logAGlen.gs is empty, but needs to be defined in a logA inversion.\n")
            error("CtrlVarValidityCheck: missing input ")

        end
    end

    if contains(CtrlVar.Inverse.InvertFor,"logC")

        if isempty(CtrlVar.Inverse.Regularize.logC.ga)

            fprintf("\n\n ======> The variable CtrlVar.Inverse.Regularize.logC.ga is empty, but needs to be defined in a logC inversion.\n")
            error("CtrlVarValidityCheck: missing input ")

        end

        if isempty(CtrlVar.Inverse.Regularize.logC.gs)

            fprintf("\n\n ======> The variable CtrlVar.Inverse.Regularize.logC.gs is empty, but needs to be defined in a logC inversion.\n")
            error("CtrlVarValidityCheck: missing input ")

        end
    end


end

%%

if isfield(CtrlVar,'AdaptMeshInterval')

    fprintf(' Note: CtrlVar.AdaptMeshInterval no longer used. Use CtrlVar.AdaptMeshRunStepInterval instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
    
end


if isfield(CtrlVar,'RefineCriteria')
    
    fprintf(' Note: CtrlVar.RefineCriteria no longer used. Use CtrlVar.ExplicitMeshRefinementCriteria instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
    
end


if isfield(CtrlVar,'RefineCriteriaWeights')
    
    fprintf(' Note: CtrlVar.RefineCriteriaWeights no longer used. Use CtrlVar.ExplicitMeshRefinementCriteria instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
    
end

if isfield(CtrlVar,'DefineOceanSurfaceAtEachTimeStep')
    
    fprintf(' Note: CtrlVar.DefineOceanSurfaceAtEachTimeStep no longer used.\n')
    fprintf('       Use CtrlVar.GeometricalVarsDefinedEachTransienRunStepByDefineGeometry instead.\n')
    fprintf('       For example: CtrlVar.GeometricalVarsDefinedEachTransienRunStepByDefineGeometry="S".\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
    
end


if isfield(CtrlVar,'InDiagnosticRunsDefineIceGeometryAtEveryRunStep')
    
    fprintf(' Note: CtrlVar.InDiagnosticRunsDefineIceGeometryAtEveryRunStep no longer used.\n')
    fprintf('       Use CtrlVar.GeometricalVarsDefinedEachDiagnosticRunStepByDefineGeometry instead.\n')
    fprintf('       For example: CtrlVar.GeometricalVarsDefinedEachDiagnosticRunStepByDefineGeometry="sbSB".\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
    
end

if isfield(CtrlVar,'ATStimeStepTarget')
    fprintf(' Note: CtrlVar.ATStimeStepTarget no longer used.\n')
    fprintf('       Use CtrlVar.ATSdtMax instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
end

if isfield(CtrlVar,'UaOutputsDt')
    fprintf(' Note: CtrlVar.UaOutputsDt no longer used.\n')
    fprintf('       Use CtrlVar.DefineOutputsDt instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
end

if isfield(CtrlVar.Inverse.TestAdjoint,'FiniteDifferenceType')
    fprintf(' Note: CtrlVar.Inverse.TestAdjoint.FiniteDifferenceType no longer used.\n')
    fprintf('       Use CtrlVar.TestAdjointFiniteDifferenceType instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
end


if isfield(CtrlVar,"InfoLevelAdjoint")
    fprintf(' Note: CtrlVar.InfoLevelAdjoint no longer used.\n')
    fprintf('       Use CtrlVar.InfoLevelInverse instead.\n')
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
end

if isfield(CtrlVar.Inverse,"MatlabOptimisationParameters")
    fprintf(' Note: CtrlVar.Inverse.MatlabOptimisationParameters no longer used.\n')
    fprintf("       Use \t CtrlVar.Inverse.MatlabOptimisationHessianParameters \n ")
    fprintf("        or \t CtrlVar.Inverse.MatlabOptimisationGradientParameters \n ")
    fprintf("        instead. \n")
    error('Ua:CtrlVarValidityCheck','CtrlVar not valid')
end



if ~isfield(CtrlVar,"StartTime")  || isnan(CtrlVar.StartTime)
    CtrlVar.StartTime=CtrlVar.time;
end

CtrlVar.time=CtrlVar.StartTime ;


if ~isfield(CtrlVar,"EndTime")  || isnan(CtrlVar.EndTime)
    CtrlVar.EndTime=CtrlVar.TotalTime;
end

if isnan(CtrlVar.TotalTime)
    CtrlVar.TotalTime=CtrlVar.EndTime;
end


if CtrlVar.TimeDependentRun
    if isnan(CtrlVar.StartTime)

        fprintf(" The variable  CtrlVar.StartTime needs to be defined. Do this in DefineInitialInputs.m \n")
        error('Ua:CtrlVarValidityCheck','CtrlVar not valid')

    end


    if isnan(CtrlVar.EndTime)

        fprintf(" The variable  CtrlVar.EndTime needs to be defined. Do this in DefineInitialInputs.m \n")
        error('Ua:CtrlVarValidityCheck','CtrlVar not valid')

    end


end



%% Parallel options: Make sure to run off parallel options if there is no pool open

if ( CtrlVar.Parallel.uvAssembly.spmd.isOn ...
        || CtrlVar.Parallel.uvhAssembly.spmd.isOn ...
        ||  CtrlVar.Parallel.Distribute ...
        || CtrlVar.Parallel.uvhAssembly.parfor.isOn ...
        || CtrlVar.Parallel.uvAssembly.parfeval.isOn ...
        || CtrlVar.Parallel.hAssembly.parfor.isOn ...
        || CtrlVar.Parallel.LSFAssembly.parfor.isOn)

    poolobj = gcp('nocreate');  % check if parpool exists, but do not create one if it does not exist already



    if isempty(poolobj)

        
        fprintf("\n ======= No parallel pool is open. To run %ca using parallel options, a parallel pool must be opened ahead of a call to %ca.\n",218,218)
        fprintf(" ======= Parallel options are turned off.\n")

        CtrlVar.Parallel.uvhAssembly.parfor.isOn=false;
        CtrlVar.Parallel.uvhAssembly.spmd.isOn=false;
        CtrlVar.Parallel.uvhAssembly.spmd.nWorkers=[];   

        CtrlVar.Parallel.uvAssembly.spmd.isOn=false;
        CtrlVar.Parallel.uvAssembly.parfeval.isOn=false;

        CtrlVar.Parallel.uvAssembly.spmd.nWorkers=[];

        CtrlVar.Parallel.isTest=false;

        CtrlVar.Parallel.hAssembly.parfor.isOn=false ;
        CtrlVar.Parallel.LSFAssembly.parfor.isOn=0;

        CtrlVar.Parallel.Distribute=false;  


    end


end

if isfield(CtrlVar,"LevelSetMethodAutomaticallyDeactivateElementsRunStepInterval")

    fprintf(" The variable CtrlVar.LevelSetMethodAutomaticallyDeactivateElementsRunStepInterval is no longer used")
    fprintf(" This interval is now determined by mesh adapt variables. See: Ua2D_DefaultParameters.m \n ")
    error("CtrlVarValidityCheck:ParameterNoLongerUsed"," The variable CtrlVar.LevelSetMethodAutomaticallyDeactivateElementsRunStepInterval is no longer used")

end

if isfield(CtrlVar,"ThicknessBarrierMassBalanceFeedbackCoeffLin")

    fprintf(" The variable CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffLin had been renamed to CtrlVar.ThicknessPenaltyMassBalanceFeedbackCoeffLin. \n")
    CtrlVar.ThicknessPenaltyMassBalanceFeedbackCoeffLin=CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffLin;

end

if isfield(CtrlVar,"ThicknessBarrierMassBalanceFeedbackCoeffQuad")

    fprintf(" The variable CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffQuad had been renamed to CtrlVar.ThicknessPenaltyMassBalanceFeedbackCoeffQuad. \n")
    CtrlVar.ThicknessPenaltyMassBalanceFeedbackCoeffQuad=CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffQuad;

end

if isfield(CtrlVar,"ThicknessBarrierMassBalanceFeedbackCoeffCubic")

    fprintf(" The variable CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffCubic had been renamed to CtrlVar.ThicknessPenaltyMassBalanceFeedbackCoeffCubic. \n")
    CtrlVar.ThicknessPenaltyMassBalanceFeedbackCoeffCubic=CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffCubic;

end




end






