


function [UserVar,MUA,BCs,F,l,InvStartValues,Priors,Meas,BCsAdjoint,RunInfo]=...
    GetInputsForInverseRestartRun(UserVar,CtrlVar,RunInfo)

narginchk(3,3) 
nargoutchk(10,10)

fprintf(CtrlVar.fidlog,' Inverse run: loading restart file: %s \t ',CtrlVar.Inverse.NameOfRestartInputFile);

load(CtrlVar.Inverse.NameOfRestartInputFile,...
    'CtrlVarInRestartFile','UserVarInRestartFile','MUA','BCs','F','l','RunInfo',...
    'InvStartValues','Priors','Meas','BCsAdjoint','InvFinalValues');

fprintf(CtrlVar.fidlog,' done \n ');

InvStartValues=InvFinalValues;


[InvStartValues.AGlen,InvStartValues.n]=TestAGlenInputValues(CtrlVar,MUA,InvStartValues.AGlen,InvStartValues.n);
[InvStartValues.C,InvStartValues.m,InvStartValues.q,InvStartValues.muk,InvStartValues.V0]=TestSlipperinessInputValues(CtrlVar,MUA,InvStartValues.C,InvStartValues.m,InvStartValues.q,InvStartValues.muk,InvStartValues.V0);

%[Priors.AGlen,Priors.n]=TestAGlenInputValues(CtrlVar,MUA,Priors.AGlen,Priors.n);
%[Priors.C,Priors.m]=TestSlipperinessInputValues(CtrlVar,MUA,Priors.C,Priors.m);
%[Priors.rho,Priors.rhow]=TestDensityInputValues(CtrlVar,MUA,Priors.rho,Priors.rhow);


if isempty(Priors.AGlenmax) 
    Priors.AGlenmax=CtrlVar.AGlenmax;
end

if isempty(Priors.AGlenmin)
    Priors.AGlenmin=CtrlVar.AGlenmin;
end

if isempty(Priors.Cmax)
    Priors.Cmax=CtrlVar.Cmax;
end


if isempty(Priors.Cmin)
    Priors.Cmin=CtrlVar.Cmin;
end

if isempty(Priors.Bmax)
    Priors.Bmax=Meas.s-CtrlVar.ThickMin;
end


if isempty(Priors.Bmin)
    Priors.Bmin=-1e10;
end




isCorrectDimensions=DoPriorsHaveCorrectDimensions(CtrlVar,MUA,Priors);


if ~isCorrectDimensions
    
    [UserVar,~,Priors,~,BCsAdjoint,RunInfo]=DefineInputsForInverseRun(UserVar,CtrlVar,MUA,BCs,F,l,F.GF,InvStartValues,Priors,Meas,BCsAdjoint,RunInfo);

    
end

isCorrectDimensions=DoPriorsHaveCorrectDimensions(CtrlVar,MUA,Priors);
if ~isCorrectDimensions
    fprintf(' Priors do not have right dimensions at restart. \n')
    fprintf(' Modify DefineInputsForInverseRun to ensure that dimensions are correct.\n')
    error('Ua:GetInputForInverseRestartRun:incorrectdimensions','incorrect dimensions')
    
end

[UserVar,MUA,BCs,F,l,InvStartValues,Priors,Meas,BCsAdjoint,RunInfo]=DefineModificationsToInverseRestartRunInputs(UserVar,CtrlVar,MUA,BCs,F,l,InvStartValues,Priors,Meas,BCsAdjoint,RunInfo) ;

end