

function  [UserVar,RunInfo,F,l,Kuv,Ruv,L]=SSTREAM2dNR2(UserVar,RunInfo,CtrlVar,MUA,BCs,F,l)
    
    
    % Solves SSA/SSTREAM for u and v


    nargoutchk(7,7)
    narginchk(7,7)
    
    
    tStart=tic;
    RunInfo.Forward.uvConverged=1; 
 
    
    
    if isempty(CtrlVar.CurrentRunStepNumber) || CtrlVar.CurrentRunStepNumber==0 
        CtrlVar.CurrentRunStepNumber=1;
    end

   % RunInfo.Forward.uvIterations(CtrlVar.CurrentRunStepNumber)=NaN;  
   % RunInfo.Forward.Residual=NaN; BackTrackInfo.iarm=NaN;
    
    Kuv=[] ; Ruv=[]; 
   
    
    % MLC=BCs2MLC(CtrlVar,MUA,BCs);
    % L=MLC.ubvbL;
    % cuv=MLC.ubvbRhs;
    
    [L,cuv]=AssembleLuvSSTREAM(CtrlVar,MUA,BCs) ;
    
    
    if isempty(cuv)
        l.ubvb=[];
    elseif numel(l.ubvb)~=numel(cuv)
        l.ubvb=zeros(numel(cuv),1) ;
    end
    
    
    if anynan(F.C)
        save TestSave ;
        warning('SSTREAM2NR:CisNaN',' nan in C. Returning with NaN in solution.\n ') ;
        F.ub=F.ub+NaN;
        F.vb=F.vb+NaN;
        return
    end
    
    if anynan(F.AGlen)
        save TestSave
        warning('SSTREAM2NR:CisNaN',' nan in A. Returning with NaN in solution.\n ') ;
        F.ub=F.ub+NaN;
        F.vb=F.vb+NaN;
        return
    end
    
    
    
    if anynan(F.S) ; save TestSave ; error( ' S nan ') ; end
    if anynan(F.h) ; save TestSave  ; error( ' h nan ') ; end
    if anynan(F.ub) ; save TestSave ; error( ' ub nan ') ; end
    if anynan(F.vb) ; save TestSave ; error( ' vb nan ') ; end
    if anynan(l.ubvb) ; save TestSave ; error( ' ubvbLambda nan ') ; end
    if anynan(F.rho) ; save TestSave  ; error( ' rho nan ') ; end
    if any(F.h<0) ; warning('MATLAB:SSTREAM2dNR:hnegative',' thickness negative ') ; end
    
    
    
    %%
    
    
    % Solves the SSTREAM equations in 2D (sparse and vectorized version) using Newton-Raphson iteration
    
    % lambda are the Lagrange parameters used to enforce the boundary conditions
    
    % Newton-Raphson is:
    % K \Delta x_i = -R ; x_{i+1}= x_{i}+ \Delta x_i
    % R=T-F
    % T : internal nodal forces
    % F : external nodal forces
    % K : tangent matrix, where K is the directional derivative of R in the direction (Delta u, \Delta v)
    
    % I need to solve
    %
    % [Kxu Kxv Luv'] [du]        =  [ -Ru ] - Luv' lambdauv
    % [Kyu Kyv     ] [dv]        =  [ -Rv ]
    % [  Luv      0] [dlambdauv]    [ Lrhsuv-Luv [u ;v ]
    %
    % All matrices are Nnodes x Nnodes, apart from:
    % Luv is #uv constraints x 2 Nnodes
    %
    
    % I write the system as
    % [Kuv  Luv^T ]  [duv]  =  [ -R(uv) - Luv^T l]
    % [Luv   0    ]  [dl]      [cuv-Luv uv]
    %
    

    %% Make sure iterate is feasible, at least with respect to directs BCs
    if CtrlVar.uvMakeInitialIterateFeasible
        F.ub(BCs.ubFixedNode)=BCs.ubFixedValue;
        F.vb(BCs.vbFixedNode)=BCs.vbFixedValue;
    end
    %%


    dub=zeros(MUA.Nnodes,1) ; dvb=zeros(MUA.Nnodes,1) ; dl=zeros(numel(l.ubvb),1);
    
    
    % diffVector=zeros(CtrlVar.NRitmax+1,1)+NaN;
    rVector.gamma=zeros(CtrlVar.NRitmax+1,1)+NaN;
    rVector.rDisp=zeros(CtrlVar.NRitmax+1,1)+NaN;
    rVector.rWork=zeros(CtrlVar.NRitmax+1,1)+NaN;
    rVector.rForce=zeros(CtrlVar.NRitmax+1,1)+NaN;
    
    Kuv=[] ; 
    
     
    
 
    CtrlVar.uvAssembly.ZeroFields=true;   CtrlVar.uvMatrixAssembly.Ronly=true ; 
    % fext0=KRTFgeneralBCs(CtrlVar,MUA,F);            % RHS with velocities set to zero, i.e. only external forces
    [RunInfo,fext0]=uvMatrixAssembly(RunInfo,CtrlVar,MUA,F,BCs);   % RHS with velocities set to zero, i.e. only external forces
    %% New normalization idea, 10 April 2023
    % set (ub,vb) to zero, except where BCs imply otherwise, ie make the iterate feasible 
    % then calculate the const function for this value and use as normalisation
    % gamma=0; fext0=1; 
    % ubStart=F.ub; vbStart=F.vb; 
    % F.ub=zeros(MUA.Nnodes,1); F.vb=zeros(MUA.Nnodes,1); 
    % F.ub(BCs.ubFixedNode)=BCs.ubFixedValue; F.vb(BCs.vbFixedNode)=BCs.vbFixedValue; % Make sure iterate is feasible
    % fNOrm=CalcCostFunctionNR(UserVar,RunInfo,CtrlVar,MUA,gamma,F,fext0,L,l,cuv,dub,dvb,dl) ;
    % fext0=sqrt(fNOrm); 
    % F.ub=ubStart ; F.vb=vbStart ; 
    %%

    
    CtrlVar.uvAssembly.ZeroFields=false;   CtrlVar.uvMatrixAssembly.Ronly=true ; 
    % Ruv=KRTFgeneralBCs(CtrlVar,MUA,F);     
    [RunInfo,Ruv]=uvMatrixAssembly(RunInfo,CtrlVar,MUA,F,BCs);  % RHS with calculated velocities, i.e. difference between external and internal forces

    RunInfo.CPU.Solution.uv=0;

 

    % The initial estimate must be based on residuals as both displacements and work
    % requires solving the Newton system.
    % gamma=0 ; [r,UserVar,RunInfo,rForce,rWork] = CalcCostFunctionNR(UserVar,RunInfo,CtrlVar,MUA,gamma,F,fext0,L,l,cuv,dub,dvb,dl) ;
    Func=@(gamma) CalcCostFunctionNR(UserVar,RunInfo,CtrlVar,MUA,gamma,F,fext0,L,l,cuv,dub,dvb,dl) ;
    gamma=0 ; [r,UserVar,RunInfo,rForce]=Func(gamma);
    rWork=0 ; % I set rWork to zero to disable it as initial criterion
    gamma=1;
    
    iteration=0;  ResidualReduction=1e10; 

    BackTrackInfo.iarm=nan;
    while true

        
        ResidualsCriteria=uvResidualsCriteria(CtrlVar,rForce,rWork,iteration,gamma) ; 

        

        if ResidualsCriteria
            
            tEnd=toc(tStart);
            if CtrlVar.InfoLevelNonLinIt>=1
                fprintf(' SSTREAM(uv) (time|dt)=(%g|%g): Converged with rForce=%-g and rWork=%-g in %-i iterations and in %-g  sec \n',...
                    CtrlVar.time,CtrlVar.dt,rForce,rWork,iteration,tEnd) ;
            end
            RunInfo.Forward.uvConverged=1;
            break
            
        end

        
        if iteration > CtrlVar.NRitmax
            
            if CtrlVar.InfoLevelNonLinIt>=1
                fprintf(' SSTREAM(uv) (time|dt)=(%g|%g): Maximum number of non-linear iterations reached. uv iteration did not converge! \n',CtrlVar.time,CtrlVar.dt)
                fprintf(' Exiting uv iteration after %-i iterations with r=%-g \n',iteration,r)
            end
            
       
            RunInfo.Forward.uvConverged=0; 
            break
        end
        
        
        iteration=iteration+1;
        
        %% Newton step
        % If I want to use the Newton Decrement (work) criterion I must calculate the Newton
        % step ahead of the cost function

        CtrlVar.NRuvIncomplete=0;
        if rem(iteration-1,CtrlVar.ModifiedNRuvIntervalCriterion)==0  || ResidualReduction> CtrlVar.ModifiedNRuvReductionCriterion
            
          
            CtrlVar.uvAssembly.ZeroFields=false;   CtrlVar.uvMatrixAssembly.Ronly=false;
            % [Ruv,Kuv,~,~]=KRTFgeneralBCs(CtrlVar,MUA,F);
            [RunInfo,Ruv,Kuv]=uvMatrixAssembly(RunInfo,CtrlVar,MUA,F,BCs);
            dAtilde=[]; 

        else
          
            CtrlVar.uvAssembly.ZeroFields=false;   CtrlVar.uvMatrixAssembly.Ronly=1; 
            % Ruv=KRTFgeneralBCs(CtrlVar,MUA,F);
            [RunInfo,Ruv]=uvMatrixAssembly(RunInfo,CtrlVar,MUA,F,BCs);
            
             CtrlVar.NRuvIncomplete=1;
            
        end

        
        if CtrlVar.TestAdjointFiniteDifferenceType=="complex step differentiation"
            CtrlVar.TestForRealValues=false;
        end
        
        if CtrlVar.TestForRealValues
            if ~isreal(Kuv) ; save TestSave Kuv ; error('SSTREAM2dNR: K not real') ;  end
            if ~isreal(L) ; save TestSave L ; error('SSTREAM2dNR: L not real') ;  end
        end
        
        if anynan(Kuv) ; save TestSave Kuv ; error('SSTREAM2dNR: K nan') ;  end
        if anynan(L) ; save TestSave L ; error('SSTREAM2dNR: L nan') ;  end
        
        CtrlVar.Solver.isUpperLeftBlockMatrixSymmetrical=issymmetric(Kuv) ;

        
        % [Kuv  Luv' ]  [duv]  =  [ -R(uv) - Luv' l]
        % [Luv   0    ]  [dl]      [ cuv-Luv uv      ]
        
        if ~isempty(L)
            frhs=-Ruv-L'*l.ubvb;
            grhs=cuv-L*[F.ub;F.vb];
        else
            frhs=-Ruv;
            grhs=[];
        end
   
        tSolution=tic;
        
        if CtrlVar.Solver.isUpperLeftBlockMatrixSymmetrical
            [sol,dl,dAtilde]=solveKApeSymmetric(Kuv,L,frhs,grhs,[dub;dvb],dl,CtrlVar,dAtilde);
        else
            [sol,dl,dAtilde]=solveKApe(Kuv,L,frhs,grhs,[dub;dvb],dl,CtrlVar,dAtilde);
        end
        
        RunInfo.CPU.Solution.uv=toc(tSolution)+RunInfo.CPU.Solution.uv;
        
        
        if CtrlVar.TestForRealValues
            dub=real(sol(1:MUA.Nnodes)) ; dvb=real(sol(MUA.Nnodes+1:2*MUA.Nnodes));
        else
            dub=sol(1:MUA.Nnodes) ; dvb=sol(MUA.Nnodes+1:2*MUA.Nnodes);
        end

        %% Residuals , at gamma=0;
        Func=@(gamma) CalcCostFunctionNR(UserVar,RunInfo,CtrlVar,MUA,gamma,F,fext0,L,l,cuv,dub,dvb,dl) ;
        gamma=0 ; [r0,UserVar,RunInfo,rForce0,rWork0,D20]=Func(gamma);
        
        if iteration==1
%           special case to check if initial state was already within tolerance 
            ResidualsCriteria=uvResidualsCriteria(CtrlVar,rForce0,rWork0,iteration,1) ;  % here I set gamma as an input to one, i.e. as if I had take a full step
            
            % save the first r value for plotting, etc
            rVector.gamma(1)=gamma;
            rVector.rDisp(1)=NaN;
            rVector.rWork(1)=rWork0;
            rVector.rForce(1)=rForce0 ;
            if ResidualsCriteria
                iteration=iteration-1 ; % reset to zero as the iteration was never performed 
                tEnd=toc(tStart);
                if CtrlVar.InfoLevelNonLinIt>=1
                    fprintf(' SSTREAM(uv) (time|dt)=(%g|%g): Converged with rForce=%-g and rWork=%-g in %-i iterations and in %-g  sec \n',...
                        CtrlVar.time,CtrlVar.dt,rForce0,rWork0,iteration,tEnd) ;
                end
                RunInfo.Forward.uvConverged=1;

                break
            end
        end



        %% calculate  residuals at full Newton step, i.e. at gamma=1
        gamma=1 ; [r1,UserVar,RunInfo,rForce1,rWork1,D21]=Func(gamma);

        if r1/r0 < CtrlVar.NewtonAcceptRatio

            r=r1 ; rForce=rForce1 ; rWork=rWork1 ; D2=D21 ;
            du=dub ; dv=dvb ;
            BackTrackInfo.Infovector=[0 r0 ; 1 r1] ;
            BackTrackInfo.Converged=1; BackTrackInfo.iarm=0; 

        else


            func=@(gamma,Du,Dv,Dl) CalcCostFunctionNR(UserVar,RunInfo,CtrlVar,MUA,gamma,F,fext0,L,l,cuv,Du,Dv,Dl) ;
            dh=[] ; dJdh=[] ;
            dJdu=frhs(1:MUA.Nnodes);
            dJdv=frhs(MUA.Nnodes+1:2*MUA.Nnodes);
            dJdl=grhs ;
            Normalisation=fext0'*fext0+1000*eps;
            % CtrlVar.InfoLevelBackTrack=1000;  CtrlVar.InfoLevelNonLinIt=10 ;
            [gamma,r,du,dv,dh,dl,BackTrackInfo,rForce,rWork,D2] = rLineminUa(CtrlVar,UserVar,func,r0,r1,Kuv,L,dub,dvb,dh,dl,dJdu,dJdv,dJdh,dJdl,Normalisation,MUA.M) ;


        end


        RunInfo.BackTrack=BackTrackInfo;

        rVector.gamma(iteration+1)=gamma;
        rVector.rDisp(iteration+1)=NaN;
        rVector.rWork(iteration+1)=rWork;
        rVector.rForce(iteration+1)=rForce ;



        if BackTrackInfo.Converged==0
            fprintf(CtrlVar.fidlog,' SSTREAM2dNR backtracking step did not converge \n ') ;
            warning('SSTREAM2NR:didnotconverge',' SSTREAM2dNR backtracking step did not converge \n ')
            RunInfo.Forward.uvConverged=0; 
            break
        end


    
        %%

        %% If requested, plot residual as function of step-length
        if CtrlVar.InfoLevelNonLinIt>=10 && CtrlVar.doplots==1
            nnn=50;
            rForceTestvector=zeros(nnn,1); rWorkTestvector=zeros(nnn,1); rD2Testvector=zeros(nnn,1);
            
            Upper=2; Lower=-0.5 ; 
            if gamma>0.7*Upper ; Upper=2*gamma; end

            gammaTestVector=linspace(Lower,Upper,nnn);
            for I=1:nnn
                gammaTest=gammaTestVector(I);
                [rTest,~,~,rForceTest,rWorkTest,D2Test]=Func(gammaTest);
                rForceTestvector(I)=rForceTest; rWorkTestvector(I)=rWorkTest; rD2Testvector(I)=D2Test; 
            end
            
            [gammaTestVector,ind]=unique(gammaTestVector) ; rForceTestvector=rForceTestvector(ind) ; rWorkTestvector=rWorkTestvector(ind) ;  rD2Testvector=rD2Testvector(ind) ;
            [gammaTestVector,ind]=sort(gammaTestVector) ; rForceTestvector=rForceTestvector(ind) ; rWorkTestvector=rWorkTestvector(ind) ; rD2Testvector=rD2Testvector(ind) ;
            
            SlopeForce=-2*rForce0;   
            SlopeWork=-2*rWork0;
            SlopeD2=-D20;
            CtrlVar.MinimisationQuantity=CtrlVar.uvMinimisationQuantity;
            PlotCostFunctionsVersusGamma(CtrlVar,RunInfo,gamma,r,iteration,"-uv-",...
                gammaTestVector,rForceTestvector,rWorkTestvector,rD2Testvector,...
                SlopeForce,SlopeWork,SlopeD2,rForce,rWork,D2);
            
        end

        % Need to update all primary (u,v,l) and dependent variables.
        % Here I have no dependent variables
        % F.ub=F.ub+gamma*dub ;
        % F.vb=F.vb+gamma*dvb;
        % l.ubvb=l.ubvb+gamma*dl;

        F.ub=F.ub+du ;
        F.vb=F.vb+dv;
        l.ubvb=l.ubvb+dl;
        
        ResidualReduction=r/r0;
        
        if CtrlVar.InfoLevelNonLinIt>100  && CtrlVar.doplots==1
            %PlotForceResidualVectors2('uv',Ruv,L,l.ubvb,MUA.coordinates,CtrlVar) ; axis equal tight
            PlotForceResidualVectors2(CtrlVar,MUA,F,'uv',Ruv,L,l.ubvb,iteration);
        end
        
        if CtrlVar.NRuvIncomplete
            stri='i';
        else
            stri=[];
        end
        
        if CtrlVar.InfoLevelNonLinIt>=1
            
            fprintf(CtrlVar.fidlog,'%sNR-SSTREAM(uv):%3u/%-2u g=%-14.7g , r/r0=%-14.7g ,  r0=%-14.7g , r=%-14.7g , rForce=%-14.7g , rWork=%-14.7g , fSlope0=%-14.7g \n ',...
                stri,iteration,RunInfo.BackTrack.iarm,gamma,r/r0,r0,r,rForce,rWork,2*rForce0);
        end
        
    
        
    end
    
    if CtrlVar.InfoLevelNonLinIt>=5 && iteration >= 2 && CtrlVar.doplots==1
  
            
            figruv=FindOrCreateFigure("NR-uv r"); clf(figruv) ;
            yyaxis left
            semilogy(0:iteration,rVector.rForce(1:iteration+1),'x-') ;
            ylabel('rResiduals^2')
            yyaxis right
            semilogy(0:iteration,rVector.rWork(1:iteration+1),'o-') ;
            ylabel('rWork^2')
            
            title('Force and Work residuals (NR uv diagnostic step)') ; xlabel('Iteration') ;
            
  
    end
    
    if isnan(r)
        fprintf(CtrlVar.fidlog,' SSTREAM2dNR returns NAN as residual!!! \n') ;
        warning('uvSSTREAM:didnotconverge',' SSTREAM2dNR did not converge to a solution. Saving all variables in TestSaveNR.mat \n ')
        save TestSaveNR
        
    end

    RunInfo=ExtendAllocations(RunInfo,CtrlVar,CtrlVar.CurrentRunStepNumber);

    
    RunInfo.Forward.uvIterations(CtrlVar.CurrentRunStepNumber)=iteration;  
    RunInfo.Forward.uvResidual(CtrlVar.CurrentRunStepNumber)=r;
    RunInfo.Forward.uvBackTrackSteps(CtrlVar.CurrentRunStepNumber)=BackTrackInfo.iarm ; 
    RunInfo.Forward.time(CtrlVar.CurrentRunStepNumber)=CtrlVar.time;


    
    if anynan(F.ub) || anynan(F.vb)  ; save TestSaveNR  ;  error(' nan in ub vb ') ; end
    
    
    
end

