








function   [Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh,taux,tauy,etaint,Heint]=...
    uvhAssemblyIntPointImplicitSUPG(Iint,ndim,MUA,...
    bnod,hnod,unod,vnod,AGlennod,nnod,Cnod,mnod,qnod,muknod,V0nod,h0nod,u0nod,v0nod,as0nod,ab0nod,as1nod,ab1nod,dadhnod,Bnod,Snod,rhonod,...
    Henod,deltanod,Hposnod,dnod,Dddhnod,...
    LSFMasknod,hBCsMasknod,...
    uonod,vonod,Conod,monod,uanod,vanod,Canod,manod,...
    CtrlVar,rhow,g,Ronly,ca,sa,dt,...
    Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh)

narginchk(62,62)
nargoutchk(15,19)

% I've added here the rho terms in the mass-conservation equation
%
%  despite their names,  unod and Cnod can be either nodal or element variables
%

theta=CtrlVar.theta;

% SUPG weight
% fun(Inod)
% tau=l/ (2 |v|)


if ~CtrlVar.IncludeMelangeModelPhysics
    uoint=[];
    voint=[];
    Coint=[];
    moint=[];
    uaint=[];
    vaint=[];
    Caint=[];
    maint=[];
end

fun=shape_fun(Iint,ndim,MUA.nod,MUA.points) ; % nod x 1   : [N1 ; N2 ; N3] values of form functions at integration points


% if isfield(MUA,'Deriv') && isfield(MUA,'DetJ') && ~isempty(MUA.Deriv) && ~isempty(MUA.DetJ)
Deriv=MUA.Deriv(:,:,:,Iint);
detJ=MUA.DetJ(:,Iint);
% else
% [Deriv,detJ]=derivVector(MUA.coordinates,MUA.connectivity,MUA.nip,Iint);
% end

%Deriv=MeshProp.Deriv{Iint} ; detJ=MeshProp.detJ{Iint};
% Deriv : MUA.Nele x dof x nod
%  detJ : MUA.Nele

% values at integration this point
% Hnod=Snod-Bnod;

hint=hnod*fun;
uint=unod*fun;
vint=vnod*fun;


if CtrlVar.IncludeMelangeModelPhysics
    
    uoint=uonod*fun;
    voint=vonod*fun;
    
    uaint=uanod*fun;
    vaint=vanod*fun;
    
end


Cint=Cnod*fun;
% Cint(Cint<CtrlVar.Cmin)=CtrlVar.Cmin;
mint=mnod*fun;

if ~isempty(qnod)
    qint=qnod*fun;
else
    qint=[];
end


if ~isempty(muknod)
    mukint=muknod*fun;
else
    mukint=[];
end

if ~isempty(V0nod)
    V0int=V0nod*fun;
else
    V0int=[];
end


if CtrlVar.IncludeMelangeModelPhysics
    Coint=Conod*fun;
    moint=monod*fun;

    Caint=Canod*fun;
    maint=manod*fun;
end

AGlenint=AGlennod*fun;
% AGlenint(AGlenint<CtrlVar.AGlenmin)=CtrlVar.AGlenmin;
nint=nnod*fun;



h0int=h0nod*fun;
u0int=u0nod*fun;
v0int=v0nod*fun;

as0int=as0nod*fun;
ab0int=ab0nod*fun;
as1int=as1nod*fun;
ab1int=ab1nod*fun;
a1int=as1int+ab1int;
a0int=as0int+ab0int;
dadhint=dadhnod*fun;






if CtrlVar.LevelSetMethod  &&  CtrlVar.LevelSetMethodAutomaticallyApplyMassBalanceFeedback

    % Here an implicit mass-balance forcing is added to cause the ice thickness downstream of the calving front to
    % approach the prescribed minimum ice thickness CtrlVar.LevelSetMinIceThickness.
  
 
    LM=LSFMasknod*fun;
    [abLSF,dadhLSF]=LevelSetMethodMassBalanceFeedback(CtrlVar,LM,hint) ;
    a1int=a1int+abLSF; 
    dadhint=dadhint+dadhLSF ;

else
    LM=0; % Level set mask for melt not applied
end

h1barr=0 ; h0barr=0; lambda_h=1;

hBC=[];
if isfield(CtrlVar,"ThicknessPenalty")  && CtrlVar.ThicknessPenalty

    %%  New simpler implementation of a thickness penalty term.
    % Similar to the implementation of the LevelSetMethodAutomaticallyApplyMassBalanceFeedback the idea here is to directly
    % modify the mass-balance, a, and the da/dh rather than adding in new separate terms to the mass balance equation
    %
      
    hBC=hBCsMasknod*fun; % hBC is zero where there are no thickness constraints applied
    [aPenalty1,daPenaltydh1]=ThicknessPenaltyMassBalanceFeedback(CtrlVar,hint) ;
    a1int=a1int+aPenalty1;
    dadhint=dadhint+daPenaltydh1 ;


    % UaPlots(CtrlVar,MUA,[],aPenalty1,GetRidOfValuesDownStreamOfCalvingFronts=false,FigureTitle="a1 penalty",logColorbar=true)
    % FindOrCreateFigure("Penalty versus thickness") ; semilogx(hint,aPenalty1,".") ; xlabel("thickness"); ylabel("penalty mass balance") ; xline(CtrlVar.ThickMin,"r") ; xline(2*CtrlVar.ThickMin,"r--")


end


if isfield(CtrlVar,"ThicknessBarrier")  &&  isfield(CtrlVar,"ThicknessBarrierMassBalanceFeedbackCoeffLog") && CtrlVar.ThicknessBarrier
   
    if isempty(hBC)
        hBC=hBCsMasknod*fun;  % about 1 if h BC applied
    end
    hBarrier=CtrlVar.ThickMin+eps(CtrlVar.ThickMin) ;  % Barrier is applied above this thickness. I need to make it a bit bigger because otherwise I'll run the risk of log(0)

    % Barrier is only applied where thickness is above the thickness barrier (hBarrier)
    % and where no thickness boundary conditions are applied (hBC \approx 0) and where the level-set mass-balance feedback is not
    % applied.
    BarrierMask= hint > hBarrier & hBC < 0.1 & LM <0.1 ;
    p=CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffLog;
      

    if p < 0
        fprintf(" CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffLog must be positive. \n ")
        fprintf(" The sign of CtrlVar.ThicknessBarrierMassBalanceFeedbackCoeffLog is changed. \n ")
        p=-p;
    end

    aBarrier=zeros(MUA.Nele,1) ;
    daBarrierdh=zeros(MUA.Nele,1) ;
    aBarrier(BarrierMask)=-p*log(hint(BarrierMask)-hBarrier) ;
    daBarrierdh(BarrierMask)=-p./(hint(BarrierMask)-hBarrier);

    %any(isnan(aBarrier))

    a1int=a1int+aBarrier;
    dadhint=dadhint+daBarrierdh;
% UaPlots(CtrlVar,MUA,[],aBarrier,GetRidOfValuesDownStreamOfCalvingFronts=false,FigureTitle="a barrier")

end



Bint=Bnod*fun;
Sint=Snod*fun;
rhoint=rhonod*fun;
Hint=Sint-Bint;

hfint=rhow*Hint./rhoint;  % this is linear, so fine to evaluate at int in this manner


if CtrlVar.uvhGroupAssembly


    Heint=Henod*fun;  %
   % HEint=HEnod*fun;  %

    deltaint=deltanod*fun;
   % Deltaint=Deltanod*fun;

    Hposint=Hposnod*fun;

    dint=dnod*fun;        % dnod=HeavisideApprox(CtrlVar.kH,Hnod,CtrlVar.Hh0).*(Snod-bnod);  % draft
    Dddhint=Dddhnod*fun;  % Here I am interpolating the derivative calculated at nodes, to the int points


else

    % calculate He and DiracDelta from integration point values of thickness
 

    Heint = HeavisideApprox(CtrlVar.kH,hint-hfint,CtrlVar.Hh0);  % important to calculate Heint and deltaint in a consistent manner
    HEint = HeavisideApprox(CtrlVar.kH,hfint-hint,CtrlVar.Hh0);
    
    deltaint=DiracDelta(CtrlVar.kH,hint-hfint,CtrlVar.Hh0);      % i.e. deltaint must be the exact derivative of Heint
    Deltaint=DiracDelta(CtrlVar.kH,hfint-hint,CtrlVar.Hh0);      %  although delta is an even function...

    Hposint = HeavisideApprox(CtrlVar.kH,Hint,CtrlVar.Hh0).*Hint;

    dint=HEint.*rhoint.*hint/rhow+Heint.*Hposint ;  % definition of d
    Dddhint=HEint.*rhoint/rhow-Deltaint.*hint.*rhoint/rhow+deltaint.*Hposint; % derivative of dint with respect to hint

end


dhdx=zeros(MUA.Nele,1); dhdy=zeros(MUA.Nele,1);
%dHdx=zeros(MUA.Nele,1); dHdy=zeros(MUA.Nele,1);
dBdx=zeros(MUA.Nele,1); dBdy=zeros(MUA.Nele,1);
dh0dx=zeros(MUA.Nele,1); dh0dy=zeros(MUA.Nele,1);



exx0=zeros(MUA.Nele,1);
eyy0=zeros(MUA.Nele,1);

exx=zeros(MUA.Nele,1);
eyy=zeros(MUA.Nele,1);
exy=zeros(MUA.Nele,1);

dbdx=zeros(MUA.Nele,1); dbdy=zeros(MUA.Nele,1);
drhodx=zeros(MUA.Nele,1); drhody=zeros(MUA.Nele,1);


% derivatives at integration points

% Deriv1=squeeze(Deriv(:,1,:)) ; % turned out that if only one element is handed to a worker, this squeeze command gets rid of the
                                 % first-dimension as well, causing errors further down. 
% Deriv2=squeeze(Deriv(:,2,:)) ;

for Inod=1:MUA.nod
    
    dhdx=dhdx+Deriv(:,1,Inod).*hnod(:,Inod);
    dhdy=dhdy+Deriv(:,2,Inod).*hnod(:,Inod);
    
    %    dHdx=dHdx+Deriv(:,1,Inod).*Hnod(:,Inod);
    %    dHdy=dHdy+Deriv(:,2,Inod).*Hnod(:,Inod);
    
    dBdx=dBdx+Deriv(:,1,Inod).*Bnod(:,Inod);
    dBdy=dBdy+Deriv(:,2,Inod).*Bnod(:,Inod);
    
    dh0dx=dh0dx+Deriv(:,1,Inod).*h0nod(:,Inod);
    dh0dy=dh0dy+Deriv(:,2,Inod).*h0nod(:,Inod);
    
    exx0=exx0+Deriv(:,1,Inod).*u0nod(:,Inod);  % exx0
    eyy0=eyy0+Deriv(:,2,Inod).*v0nod(:,Inod);
    
    dbdx=dbdx+Deriv(:,1,Inod).*bnod(:,Inod);
    dbdy=dbdy+Deriv(:,2,Inod).*bnod(:,Inod);
    
    drhodx=drhodx+Deriv(:,1,Inod).*rhonod(:,Inod);
    drhody=drhody+Deriv(:,2,Inod).*rhonod(:,Inod);
    
    exx=exx+Deriv(:,1,Inod).*unod(:,Inod);
    eyy=eyy+Deriv(:,2,Inod).*vnod(:,Inod);
    exy=exy+0.5*(Deriv(:,1,Inod).*vnod(:,Inod) + Deriv(:,2,Inod).*unod(:,Inod));
    
    
end



[etaint,Eint]=EffectiveViscositySSTREAM(CtrlVar,AGlenint,nint,exx,eyy,exy);

%uoint=[];voint=[];Coint=[] ;moint=[] ;uaint=[] ;vaint=[] ;Caint=[]; maint=[];
[taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh] = ...
    BasalDrag(CtrlVar,MUA,Heint,deltaint,hint,Bint,Hint,rhoint,rhow,uint,vint,Cint,mint,uoint,voint,Coint,moint,uaint,vaint,Caint,maint,qint,g,mukint,V0int);

if CtrlVar.OnlyCalcBasalDragAndEffectiveViscosity

    Tx=NaN; Fx=NaN; Ty=NaN ; Fy=NaN ; Th=NaN ; Fh=NaN ; Kxu=NaN ; Kxv=NaN ; Kyu=NaN ; Kyv=NaN ; Kxh=NaN ; Kyh=NaN ; Khu=NaN ; Khv=NaN ; Khh = NaN ;
    return

end



%% u=1 ; dt =1 ; l=1 ; tau=1/(u/l+l/(u*dt^2))



l=sqrt(2*MUA.EleAreas);  % this I could take outside the int loop

speed0=sqrt(u0int.*u0int+v0int.*v0int+CtrlVar.SpeedZero^2);
% speed1=sqrt(uint.*uint+vint.*vint+CtrlVar.SpeedZero^2);

%
% The SUPG adds a term to the weighting function on the form
%
%  N -> N+ N'
%
%  where
%
%   N'=tau \bm{u} \cdot \grad N
%     = tau (u dNdx + v dNdy)
%
% where tau is a parameter having the dimension time. In a transient run a
% possible choice for tau is simply dt However we would like the additional SUPG
% term to go to zero as u->0 and as h->0, in fact we expect the `element Courant
% number' ECN defined as
%
%               ECN = dt |\bm{u}|/L,
%
% where u is some typical velocity and L a scale for element size to be of relevance.
%
%  Typical suggestions in the literature are on the form
%
%  N'= kappa (L/2) u/|u| dNdx
%
% for a 1D situation on a regular grid, with]%
%
% kappa=cosh(Pe) -1/Pe
%
% and Pe=U L / (2 k)  , where k is the diffusivity constant.
%
% Hughes et al suggest
%
%          tau= \frac{L}{2 |\bm{u}|}    (coth ( Pe) - 1/Pe )
%
% with Pe=|bm{u}| L / 2 k,  where k is the diffusion coefficient.
% It is unclear what the diffusion coefficient will be. In the hyperbolic
% limit of a k->0, kappa=cosh(Pe)-1/Pe -> 1 and the SUPG becomes
%
%  N'=   (L/2|u|)  \bm{u} \cdot \grad N
%
% This terms goes to zero with decreasing element size.
%
%
% Heuristic arguments
% suggest \alpha=ECN as this gives plausible limits, i.e. 1 for ECN->\infty and
% 0 for ECN-> 0.
%
%
% (L/speed)* coth( speed dt/L)  * (u dN/dx + v dN/dy)
% _
% Note: ((coth(x)-1/x)/x -> 1/3 for x ->0
%       ((coth(1/x)-x) x -> 1/3 for x -> infty
%       ((coth(x)-1/x)  -> 0 for x ->0
%       ((coth(x)-1/x)  -> 1 for x -> infty
%
% this term is zero for L->0, or speed->0, or dt-> 0
%
%       dN/dX for u-> infty ,  dt-> infty
%  1/3  dN/dX for L -> infty
%

% This is done within the integration-point loop.
tau=SUPGtau(CtrlVar,speed0,l,dt,CtrlVar.uvh.SUPG.tau,CtrlVar.uvh.SUPG.tauMultiplier) ;
tau0=CtrlVar.SUPG.beta0*tau;




detJw=detJ*MUA.weights(Iint);
nod=MUA.nod ;

switch lower(CtrlVar.FlowApproximation)

    case "sstream"

       
        UseMex=~Ronly && CtrlVar.UseMexFiles ;

        if ~UseMex


            [Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh]=...
                uvhNodalLoopSSTREAM(detJw,nod,theta,tau0,Ronly,...
                CtrlVar,Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh, ...
                Deriv,fun,...
                exx,eyy,exy,exx0,eyy0,...
                dhdx,dhdy,dh0dx,dh0dy,drhodx,drhody,dbdx,dbdy,dBdx,dBdy,Hposint,Dddhint,...
                ca,sa,g,dt,...
                etaint,Eint,...
                h0barr,h1barr,...
                taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh,...
                Heint,deltaint,rhoint,rhow,uint,vint,u0int,v0int,dint,...
                hint,h0int,a1int,a0int,dadhint,lambda_h) ;

        else

            if CtrlVar.UseMexFilesCPUcompare
                Tx2=Tx ; Fx2=Fx ; Ty2=Ty ; Fy2=Fy ; Th2=Th; Fh2=Fh ;
                Kxu2=Kxu ;  Kxv2=Kxv ; Kyu2= Kyu;
                Kyv2=Kyv ;  Kxh2=Kxh ; Kyh2=Kyh ;
                Khu2= Khu ; Khv2=Khv ; Khh2=Khh;
            end

            CV=1; Ronly=double(Ronly) ;

            tStart = cputime;

            [Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh]=...
                uvhNodalLoopSSTREAM_mex(detJw,nod,theta,tau0,Ronly,...
                CV,Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh, ...
                Deriv,fun,...
                exx,eyy,exy,exx0,eyy0,...
                dhdx,dhdy,dh0dx,dh0dy,drhodx,drhody,dbdx,dbdy,dBdx,dBdy,Hposint,Dddhint,...
                ca,sa,g,dt,...
                etaint,Eint,...
                h0barr,h1barr,...
                taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh,...
                Heint,deltaint,rhoint,rhow,uint,vint,u0int,v0int,dint,...
                hint,h0int,a1int,a0int,dadhint,lambda_h) ;

            tEndMex = cputime - tStart ; %fprintf("    MEX file %f \n",tEndMex)

            if CtrlVar.UseMexFilesCPUcompare
                tStart = cputime;
                [Tx2,Fx2,Ty2,Fy2,Th2,Fh2,Kxu2,Kxv2,Kyu2,Kyv2,Kxh2,Kyh2,Khu2,Khv2,Khh2]=...
                    uvhNodalLoopSSTREAM(detJw,nod,theta,tau0,Ronly,...
                    CtrlVar,Tx2,Fx2,Ty2,Fy2,Th2,Fh2,Kxu2,Kxv2,Kyu2,Kyv2,Kxh2,Kyh2,Khu2,Khv2,Khh2, ...
                    Deriv,fun,...
                    exx,eyy,exy,exx0,eyy0,...
                    dhdx,dhdy,dh0dx,dh0dy,drhodx,drhody,dbdx,dbdy,dBdx,dBdy,Hposint,Dddhint,...
                    ca,sa,g,dt,...
                    etaint,Eint,...
                    h0barr,h1barr,...
                    taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh,...
                    Heint,deltaint,rhoint,rhow,uint,vint,u0int,v0int,dint,...
                    hint,h0int,a1int,a0int,dadhint,lambda_h) ;

                tEndm = cputime - tStart ; fprintf(" Mex %f sec \t   m-file %f sec \t m/Mex=%f \n",tEndMex,tEndm,tEndm/tEndMex)
                fprintf("Difference between solutions: %f %f %f %f \n",norm(Tx2-Tx),norm(Fx2-Fx),norm(Ty2-Ty),norm(Fy2-Fy))
            end

        end




    case "hybrid"


        [Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh]=...
            uvhNodalLoopHybrid(detJw,nod,theta,tau0,Ronly,...
            CtrlVar,Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh, ...
            Deriv,fun,...
            exx,eyy,exy,exx0,eyy0,...
            dhdx,dhdy,dh0dx,dh0dy,drhodx,drhody,dbdx,dbdy,dBdx,dBdy,Hposint,Dddhint,...
            ca,sa,g,dt,...
            etaint,Eint,...
            h0barr,h1barr,...
            taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh,...
            Heint,deltaint,rhoint,rhow,uint,vint,u0int,v0int,dint,...
            hint,h0int,a1int,a0int,dadhint,lambda_h) ;


    case "sstream-rho"

        [Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh]=...
            uvhNodalLoopSSTREAMrho(detJw,nod,theta,tau0,Ronly,...
            CtrlVar,Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh, ...
            Deriv,fun,...
            exx,eyy,exy,exx0,eyy0,...
            dhdx,dhdy,dh0dx,dh0dy,drhodx,drhody,dbdx,dbdy,dBdx,dBdy,Hposint,Dddhint,...
            ca,sa,g,dt,...
            etaint,Eint,...
            h0barr,h1barr,...
            taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh,...
            Heint,deltaint,rhoint,rhow,uint,vint,u0int,v0int,dint,...
            hint,h0int,a1int,a0int,dadhint,lambda_h) ;





    case "sstreamTest"
        error('not finalized')

        [Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh]=...
            uvhNodalLoopSSTREAMtest(detJw,nod,theta,tau0,Ronly,...
            CtrlVar,Tx,Fx,Ty,Fy,Th,Fh,Kxu,Kxv,Kyu,Kyv,Kxh,Kyh,Khu,Khv,Khh, ...
            Deriv,fun,...
            exx,eyy,exy,exx0,eyy0,...
            dhdx,dhdy,dh0dx,dh0dy,drhodx,drhody,dbdx,dbdy,dBdx,dBdy,Hposint,Dddhint,...
            ca,sa,g,dt,...
            etaint,Eint,...
            h0barr,h1barr,...
            taux,tauy,dtauxdu,dtauxdv,dtauydu,dtauydv,dtauxdh,dtauydh,...
            Heint,deltaint,rhoint,rhow,uint,vint,u0int,v0int,dint,...
            hint,h0int,a1int,a0int,dadhint,lambda_h) ;


    otherwise
        error("What case?")
end


end
