
function [UserVar,AB]=FE_outer_product(UserVar,CtrlVar,MUA,a,b)

%%
%
% Evaluates the matrix:
%
% $$ [AB]_[pq] = < a_r \phi_r   \phi_p |  \phi_q  b_s \phi_s >   $$
%
% Not sure if the name of this m-File really is a good description of what it does,
% But it generates something that I find similar to an outer product.
%
% In a similar way as the mass-matrix can be considered to the the outer-product
%
% $$ M= |\phi> <\phi| $$
%
%
% Note: If a and b are vectors which elements are all equal to 1, the outer product produced is equal to the mass matrix:
%
%   a=ones(MUA.Nnodes,1) ; b=ones(MUA.Nnodes,1) ;    
%   [~,AB]=FE_outer_product(UserVar,CtrlVar,MUA,a,b);
%   isequal(AB,MUA.M)
%
% The matrix is always symmetric:
%
%   a=rand(MUA.Nnodes,1) ; b=rand(MUA.Nnodes,1) ;    
%   [~,AB]=FE_outer_product(UserVar,CtrlVar,MUA,a,b);
%   all(all(abs(AB-AB')<eps(max(AB(:)))))
%
% apart from numerical rounding errors. To make it numerically symmetric I set:  AB=(AB+AB')/2; 
%
%% 

narginchk(4,5)

if nargin<5
   b=ones(MUA.Nnodes,1) ; 
end


ndim=2; dof=1; neq=dof*MUA.Nnodes;

a=a+zeros(MUA.Nnodes,1);
b=b+zeros(MUA.Nnodes,1);
anod=reshape(a(MUA.connectivity,1),MUA.Nele,MUA.nod);
bnod=reshape(b(MUA.connectivity,1),MUA.Nele,MUA.nod);


ElementMatrix=zeros(MUA.Nele,MUA.nod,MUA.nod);


% vector over all elements for each integration point
for Iint=1:MUA.nip
    
    fun=shape_fun(Iint,ndim,MUA.nod,MUA.points) ; % nod x 1   : [N1 ; N2 ; N3] values of form functions at integration points
    
    if isfield(MUA,'Deriv') && isfield(MUA,'DetJ') && ~isempty(MUA.Deriv) && ~isempty(MUA.DetJ)
        % Deriv=MUA.Deriv(:,:,:,Iint);
        detJ=MUA.DetJ(:,Iint);
    else
        [~,detJ]=derivVector(MUA.coordinates,MUA.connectivity,MUA.nip,MUA.points,Iint);
    end

    
    aint=anod*fun;
    bint=bnod*fun;
    
    detJw=detJ*MUA.weights(Iint);
    
    for Inod=1:MUA.nod
        
        
        for Jnod=1:MUA.nod

            ElementMatrix(:,Inod,Jnod)=ElementMatrix(:,Inod,Jnod)+...
                aint.*bint.*fun(Jnod).*fun(Inod).*detJw;
            
        end

    end
end

Iind=zeros(MUA.nod*MUA.nod*MUA.Nele,1); Jind=zeros(MUA.nod*MUA.nod*MUA.Nele,1);Xval=zeros(MUA.nod*MUA.nod*MUA.Nele,1);
istak=0;

for Inod=1:MUA.nod
    for Jnod=1:MUA.nod
        Iind(istak+1:istak+MUA.Nele)=MUA.connectivity(:,Inod);
        Jind(istak+1:istak+MUA.Nele)=MUA.connectivity(:,Jnod);
        Xval(istak+1:istak+MUA.Nele)=ElementMatrix(:,Inod,Jnod);
        istak=istak+MUA.Nele;
    end
end

AB=sparseUA(Iind,Jind,Xval,neq,neq);
AB=(AB+AB')/2 ; % make numerically symmetric


end