#ifndef _ESMFTRC_H
#define _ESMFTRC_H

/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2016 Philippe Proulx <pproulx@efficios.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *
 * The following C code was generated by barectf 2.2.1
 * on 2017-12-15T15:19:47.249580.
 *
 * For more details, see <http://barectf.org>.
 */

#include <stdint.h>

#include "esmftrc-bitfield.h"

#ifdef __cplusplus
extern "C" {
#endif






struct esmftrc_ctx;

uint32_t esmftrc_packet_size(void *ctx);
int esmftrc_packet_is_full(void *ctx);
int esmftrc_packet_is_empty(void *ctx);
uint32_t esmftrc_packet_events_discarded(void *ctx);
uint8_t *esmftrc_packet_buf(void *ctx);
void esmftrc_packet_set_buf(void *ctx, uint8_t *buf, uint32_t buf_size);
uint32_t esmftrc_packet_buf_size(void *ctx);
int esmftrc_packet_is_open(void *ctx);

/* barectf platform callbacks */
struct esmftrc_platform_callbacks {
	/* clock callbacks */
	uint64_t (*sys_clock_clock_get_value)(void *);

	/* is back-end full? */
	int (*is_backend_full)(void *);

	/* open packet */
	void (*open_packet)(void *);

	/* close packet */
	void (*close_packet)(void *);
};

/* common barectf context */
struct esmftrc_ctx {
	/* platform callbacks */
	struct esmftrc_platform_callbacks cbs;

	/* platform data (passed to callbacks) */
	void *data;

	/* output buffer (will contain a CTF binary packet) */
	uint8_t *buf;

	/* packet size in bits */
	uint32_t packet_size;

	/* content size in bits */
	uint32_t content_size;

	/* current position from beginning of packet in bits */
	uint32_t at;

	/* packet header + context size (content offset) */
	uint32_t off_content;

	/* events discarded */
	uint32_t events_discarded;

	/* current packet is opened */
	int packet_is_open;
};

/* context for stream "default" */
struct esmftrc_default_ctx {
	/* parent */
	struct esmftrc_ctx parent;

	/* config-specific members follow */
	uint32_t off_tph_magic;
	uint32_t off_tph_uuid;
	uint32_t off_spc_timestamp_begin;
	uint32_t off_spc_timestamp_end;
	uint32_t off_spc_packet_size;
	uint32_t off_spc_content_size;
	uint32_t off_spc_nodename;
	uint32_t off_spc_pet;
};

/* initialize context */
void esmftrc_init(
	void *vctx,
	uint8_t *buf,
	uint32_t buf_size,
	struct esmftrc_platform_callbacks cbs,
	void *data
);

/* open packet for stream "default" */
void esmftrc_default_open_packet(
	struct esmftrc_default_ctx *ctx,
	const char * spc_nodename,
	uint32_t spc_pet
);

/* close packet for stream "default" */
void esmftrc_default_close_packet(struct esmftrc_default_ctx *ctx);

/* trace (stream "default", event "prologue_enter") */
void esmftrc_default_trace_prologue_enter(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
);

/* trace (stream "default", event "epilogue_exit") */
void esmftrc_default_trace_epilogue_exit(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
);

/* trace (stream "default", event "phase_enter") */
void esmftrc_default_trace_phase_enter(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
);

/* trace (stream "default", event "phase_exit") */
void esmftrc_default_trace_phase_exit(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	uint8_t ep_method,
	uint8_t ep_phase
);

/* trace (stream "default", event "region_enter") */
void esmftrc_default_trace_region_enter(
	struct esmftrc_default_ctx *ctx,
	const char * ep_name
);

/* trace (stream "default", event "region_exit") */
void esmftrc_default_trace_region_exit(
	struct esmftrc_default_ctx *ctx,
	const char * ep_name
);

/* trace (stream "default", event "define_region") */
void esmftrc_default_trace_define_region(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_id,
	const char * ep_name
);

/* trace (stream "default", event "regionid_enter") */
void esmftrc_default_trace_regionid_enter(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_regionid
);

/* trace (stream "default", event "regionid_exit") */
void esmftrc_default_trace_regionid_exit(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_regionid
);

/* trace (stream "default", event "comp") */
void esmftrc_default_trace_comp(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_vmid,
	uint16_t ep_baseid,
	const char * ep_name,
	const char * ep_IPM,
	const char * ep_RPM,
	const char * ep_FPM
);

/* trace (stream "default", event "mem") */
void esmftrc_default_trace_mem(
	struct esmftrc_default_ctx *ctx,
	uint32_t ep_virtMem,
	uint32_t ep_physMem
);

/* trace (stream "default", event "clk") */
void esmftrc_default_trace_clk(
	struct esmftrc_default_ctx *ctx,
	uint16_t ep_year,
	uint8_t ep_month,
	uint8_t ep_day,
	uint8_t ep_hour,
	uint8_t ep_minute,
	uint8_t ep_second
);

#ifdef __cplusplus
}
#endif

#endif /* _ESMFTRC_H */
