// uzrect.C --- 2D water movement in a rectangular grid.
// 
// Copyright 2006 Per Abrahamsen and KVL.
//
// This file is part of Daisy.
// 
// Daisy is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
// 
// Daisy is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser Public License for more details.
// 
// You should have received a copy of the GNU Lesser Public License
// along with Daisy; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#define BUILD_DLL

#include "uzrect.h"
#include "block_model.h"
#include "librarian.h"

const char *const UZRect::component = "uzrect";

symbol
UZRect::library_id () const
{
  static const symbol id (component);
  return id;
}

void 
UZRect::summarize (Treelog&) const
{ }


bool 
UZRect::obey_surface ()
{ return true; }


UZRect::UZRect (const BlockModel& al)
  : ModelFramed (al)
{ }

UZRect::~UZRect ()
{ }

static struct UZRectInit : public DeclareComponent 
{
  UZRectInit ()
    : DeclareComponent (UZRect::component, "\
2D water movement in a rectangular grid.")
  { }
} UZRect_init;

// uzrect.C ends here.
