// =============================================================================
// The obligatory About box.

unit AboutFrm;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Buttons,
  ExtCtrls;

type
  TAboutForm = class(TForm)
    Panel: TPanel;
      ImageEPA: TImage;
      LabelTitle: TLabel;
      LabelVersion: TLabel;
      LabelBuildDate: TLabel;
    GroupBoxDevelopers: TGroupBox;
      GroupBoxDRI: TGroupBox;
        LabelJGW: TLabel;
        LabelNFR: TLabel;
      GroupBoxPES: TGroupBox;
        LabelVJK: TLabel;
        LabelRAW: TLabel;
      GroupBoxIS: TGroupBox;
        LabelRFA: TLabel;
        LabelIS: TLabel;
        LabelJVS: TLabel;
      GroupBoxEPA: TGroupBox;
        GroupBoxCTC: TGroupBox;
          LabelCTCOffice: TLabel;
          LabelCTCAddress: TLabel;
          LabelCTCPhone: TLabel;
          LabelCTCEmail: TLabel;
        GroupBoxCWL: TGroupBox;
          LabelCWLOffice: TLabel;
          LabelCWLAddress: TLabel;
          LabelCWLPhone: TLabel;
          LabelCWLEmail: TLabel;
    BitBtnOK: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure URLClick(Sender: TObject);
  private
    // Private declarations.
  public
    // Public declarations.
  end;

var
  AboutForm: TAboutForm;

implementation

{$R *.DFM}

uses
  ShellAPI;

procedure TAboutForm.FormCreate(Sender: TObject);
var
  BuildTimestamp: TDateTime;
  BuildDate: string;
begin
  Caption := 'About ' + Application.Title;
  Icon := Application.Icon;
  LabelVersion.Caption := Application.Title;
  BuildTimeStamp := FileDateToDateTime(FileAge(Application.ExeName));
  DateTimeToString(BuildDate, LongDateFormat, BuildTimestamp);
//  LabelBuildDate.Caption
//    := 'Built on ' + BuildDate + ' at ' + TimeToStr(BuildTimeStamp); // Just below Version!
  LabelCTCEmail.Hint := 'mailto:' + LabelCTCEmail.Caption;
  LabelCWLEmail.Hint := 'mailto:' + LabelCWLEmail.Caption;
end;

procedure TAboutForm.URLClick(Sender: TObject);
begin
  if Sender is TControl then
    with Sender as TControl do
      if Hint <> '' then
        ShellExecute(
          Handle,
          nil,
          PChar(Hint),
          nil,
          nil,
          SW_SHOWNORMAL);
end;

end.
