// =============================================================================
// Main application code.

program EPACMB82;

uses
  Forms,
  AboutFrm in 'AboutFrm.pas' {AboutForm},
  BLWarningFrm in 'BLWarningFrm.pas' {BLWarningForm},
  MainFrm in 'MainFrm.pas' {MainForm},
  PrintOptionsFrm in 'PrintOptionsFrm.pas' {PrintOptionsForm},
  SaveResultsFrm in 'SaveResultsFrm.pas' {SaveResultsForm},
  StartupFrm in 'StartupFrm.pas' {StartupForm},
  WaitFrm in 'WaitFrm.pas' {WaitForm},
  CMB82Internals in 'CMB82Internals.pas',
  Windows,
  Dialogs,
  SysUtils;

{$R *.RES}

const
  kDLLName      = 'CMB82.DLL';
  kFunctionName = 'CMB82c';

var
  LibHandle: THandle;
  DLLPath: string;
begin                       // Explicit DLL path added by RFA in 12/04/02 build.
  Application.Initialize;
  Application.Title := 'EPA-CMB8.2';
  Application.HelpFile := 'C:\CMB8\Delphi\Build 9\EPACMB82.hlp';
  DLLPath := ExtractFilePath(Application.ExeName) + kDLLName;

  // Load the DLL:
  LibHandle := LoadLibrary(PChar(DLLPath));
  if LibHandle = 0 then
  begin
    MessageDlg(
      'Can''t load ' + kDLLName + '; unable to continue.',
      mtInformation,
      [mbOK],
      0);
    Halt;
  end;

  try
    // Get the function address.
    @g_CMB82c := GetProcAddress(LibHandle, kFunctionName);
    if not Assigned(g_CMB82c) then
    begin
      MessageDlg(
        'Can''t locate CMB82c entry point; unable to continue.',
        mtInformation,
        [mbOK],
        0);
      Exit;
    end;
    Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TStartupForm, StartupForm);
  Application.Run;
  finally
    FreeLibrary(LibHandle);
  end;
end.
