// =============================================================================
// The main form: the bulk of the UI is found here.
// MainFrm.pas handles all file I/O functions for EPA-CMB8.2.          -TCoulter

unit MainFrm;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  DBCtrls,
  ToolWin,
  ComCtrls,
  DB,
  Menus,
  Grids,
  DBGrids,
  Mask,
  ExtCtrls,
  Buttons,
  DBClient,
  TeeProcs,
  TeEngine,
  Chart,
  Series,
  DBChart, AppEvnts;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
      MenuItemFile: TMenuItem;
        MenuItemFileSave: TMenuItem;
        MenuItemFilePrint: TMenuItem;
        N1: TMenuItem;
        MenuItemFileExit: TMenuItem;
      MenuItemHelp: TMenuItem;
        MenuItemHelpContents: TMenuItem;
        N2: TMenuItem;
        MenuItemHelpAbout: TMenuItem;

    OpenDialogAmbientData: TOpenDialog;
    OpenDialogAmbientDataSelection: TOpenDialog;
    OpenDialogCMBControlFile: TOpenDialog;
    OpenDialogSourceProfile: TOpenDialog;
    OpenDialogSourceProfileSelection: TOpenDialog;
    OpenDialogSpeciesSelection: TOpenDialog;

    SaveDialogControl: TSaveDialog;
    SaveDialogResults: TSaveDialog;
    SaveDialogSelection: TSaveDialog;

    PrintDialog: TPrintDialog;

    DataSourceSamples: TDataSource;
    DataSourceSources: TDataSource;
    DataSourceSpecies: TDataSource;
    DataSourceResults: TDataSource;

    CheckBoxBestFit: TCheckBox;
    CheckBoxBritt: TCheckBox;
    CheckBoxSource: TCheckBox;
    ComboBoxUnits: TComboBox;
    DBChartSamples: TDBChart;
    DBChartSources: TDBChart;
    DBCheckBoxBestFit: TDBCheckBox;
    DBCheckBoxBrittLuecke: TDBCheckBox;
    DBCheckBoxSourceElimination: TDBCheckBox;
    DBGridSamples: TDBGrid;
    DBGridSources: TDBGrid;
    DBGridSpecies: TDBGrid;
    DBMemoContributions: TDBMemo;
    DBMemoMPIN: TDBMemo;
    DBMemoSummary: TDBMemo;
    DBNavigator: TDBNavigator;
    DBTextChiSq: TDBText;
    DBTextDate: TDBText;
    DBTextDecimals: TDBText;
    DBTextDuration: TDBText;
    DBTextIteration: TDBText;
    DBTextMaxUnc: TDBText;
    DBTextMinProj: TDBText;
    DBTextPercent: TDBText;
    DBTextRSquare: TDBText;
    DBTextSite: TDBText;
    DBTextSize: TDBText;
    DBTextSourcesFit: TDBText;
    DBTextSpeciesFit: TDBText;
    DBTextStart: TDBText;
    DBTextUnits: TDBText;
    DBTextWtFraction: TDBText;
    EditAmbientData: TEdit;
    EditAmbientDataSelection: TEdit;
    EditControlFile: TEdit;
    EditSourceProfileSelection: TEdit;
    EditSourceProfiles: TEdit;
    EditSpeciesSelection: TEdit;
    LabelStartHour: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label3: TLabel;
    LabelSite: TLabel;
    LabelSample: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LabelAmbientData1: TLabel;
    LabelAmbientData2: TLabel;
    LabelBestFit: TLabel;
    LabelBritt: TLabel;
    LabelChiSquare: TLabel;
    LabelControlFile: TLabel;
    LabelCurSpeciesFit: TLabel;
    LabelDate: TLabel;
    LabelDecimals: TLabel;
    LabelDuration: TLabel;
    LabelFitMeasure: TLabel;
    LabelFraction: TLabel;
    LabelInputFiles: TLabel;
    LabelIterationDelta: TLabel;
    LabelOptional: TLabel;
    LabelPercentMass: TLabel;
    LabelProjection: TLabel;
    LabelRSquare: TLabel;
    LabelResult: TLabel;
    LabelSourceElimination: TLabel;
    LabelSourceProfiles1: TLabel;
    LabelSourceProfiles2: TLabel;
    LabelSpecies: TLabel;
    LabelUncertainty: TLabel;
    LabelUnits: TLabel;
    LableCurSourcesFit: TLabel;
    MaskEditChiSquare: TMaskEdit;
    MaskEditDecimals: TMaskEdit;
    MaskEditFraction: TMaskEdit;
    MaskEditIteration: TMaskEdit;
    MaskEditPercentMass: TMaskEdit;
    MaskEditProjection: TMaskEdit;
    MaskEditRSquare: TMaskEdit;
    MaskEditUncertainty: TMaskEdit;
    PageControlMain: TPageControl;
    PageControlResults: TPageControl;
    Panel10: TPanel;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    PanelControlFile: TPanel;
    PanelFiles: TPanel;
    PanelFilesDiv: TPanel;
    PanelSampleCount: TPanel;
    PanelSamples: TPanel;
    PanelSourceCount: TPanel;
    PanelSources: TPanel;
    PanelSpecieCount: TPanel;
    PrinterSetupDialog: TPrinterSetupDialog;
    SaveRangeDialog: TPrintDialog;
    ScrollBoxReportHeader: TScrollBox;
    ScrollBox2: TScrollBox;
    ScrollBoxFiles1: TScrollBox;
    ScrollBoxFiles2: TScrollBox;
    ScrollBoxOptions1: TScrollBox;
    ScrollBoxOptions2: TScrollBox;
    ScrollBoxResults: TScrollBox;
    ScrollBoxSamples1: TScrollBox;
    ScrollBoxSamples2: TScrollBox;
    ScrollBoxSources1: TScrollBox;
    ScrollBoxSources2: TScrollBox;
    ScrollBoxSpecies1: TScrollBox;
    ScrollBoxSpecies2: TScrollBox;
    Series1: TBarSeries;
    Series2: TBarSeries;
    SpeedButtonAmbientData: TSpeedButton;
    SpeedButtonAmbientDataSelection: TSpeedButton;
    SpeedButtonClearAllSamples: TSpeedButton;
    SpeedButtonClearAllSources: TSpeedButton;
    SpeedButtonClearAllSpecies: TSpeedButton;
    SpeedButtonDeleteAll: TSpeedButton;
    SpeedButtonDeleteCurrent: TSpeedButton;
    SpeedButtonIN8: TSpeedButton;
    SpeedButtonPrint: TSpeedButton;
    SpeedButtonResetToDefault: TSpeedButton;
    SpeedButtonRun: TSpeedButton;
    SpeedButtonSamplesGraph: TSpeedButton;
    SpeedButtonSamplesShowData: TSpeedButton;
    SpeedButtonSamplesViewAll: TSpeedButton;
    SpeedButtonSave: TSpeedButton;
    SpeedButtonSelectAllSamples: TSpeedButton;
    SpeedButtonSelectAllSources: TSpeedButton;
    SpeedButtonSelectAllSpecies: TSpeedButton;
    SpeedButtonSourceProfile: TSpeedButton;
    SpeedButtonSourceProfileSelection: TSpeedButton;
    SpeedButtonSourcesGraph: TSpeedButton;
    SpeedButtonSourcesShowData: TSpeedButton;
    SpeedButtonSourcesViewAll: TSpeedButton;
    SpeedButtonSpeciesSelection: TSpeedButton;
    SpeedButtonSpeciesViewAll: TSpeedButton;
    TabSheetContributions: TTabSheet;
    TabSheetInputFiles: TTabSheet;
    TabSheetMPIN: TTabSheet;
    TabSheetOptions: TTabSheet;
    TabSheetResults: TTabSheet;
    TabSheetSamples: TTabSheet;
    TabSheetSources: TTabSheet;
    TabSheetSpecies: TTabSheet;
    TabSheetSummary: TTabSheet;
    ToolBar: TToolBar;
    ToolButton: TToolButton;
    UpDownDecimals: TUpDown;
    UpDownIteration: TUpDown;
    UpDownUncertainty: TUpDown;

    ClientDataSetCurSam:  TClientDataSet;
    ClientDataSetCurSrc:  TClientDataSet;
    ClientDataSetSamples: TClientDataSet;
    ClientDataSetSpecies: TClientDataSet;
    ClientDataSetSources: TClientDataSet;
    ClientDataSetResults: TClientDataSet;

    ClientDataSetSpeciesSPECIE: TStringField;
    ClientDataSetSpeciesSPECIENAME: TStringField;
    ClientDataSetSpeciesFIT1: TStringField;
    ClientDataSetSpeciesFIT2: TStringField;
    ClientDataSetSpeciesFIT3: TStringField;
    ClientDataSetSpeciesFIT4: TStringField;
    ClientDataSetSpeciesFIT5: TStringField;
    ClientDataSetSpeciesFIT6: TStringField;
    ClientDataSetSpeciesFIT7: TStringField;
    ClientDataSetSpeciesFIT8: TStringField;
    ClientDataSetSpeciesFIT9: TStringField;
    ClientDataSetSpeciesFIT10: TStringField;
    ClientDataSetSpeciesCOMMENT: TStringField;

    ClientDataSetResultsSITE: TStringField;
    ClientDataSetResultsDATE: TStringField;
    ClientDataSetResultsDUR: TStringField;
    ClientDataSetResultsHOUR: TStringField;
    ClientDataSetResultsSTART: TStringField;
    ClientDataSetResultsSIZE: TStringField;
    ClientDataSetResultsWTRSQUARE: TFloatField;
    ClientDataSetResultsWTCHISQ: TFloatField;
    ClientDataSetResultsWTPERCENT: TFloatField;
    ClientDataSetResultsWTFRACTION: TFloatField;
    ClientDataSetResultsBRITT: TBooleanField;
    ClientDataSetResultsBEST: TBooleanField;
    ClientDataSetResultsELIM: TBooleanField;
    ClientDataSetResultsSUMMARY: TMemoField;
    ClientDataSetResultsCONTRIB: TMemoField;
    ClientDataSetResultsMPIN: TMemoField;
    ClientDataSetResultsITERATION: TFloatField;
    ClientDataSetResultsMAXUNC: TFloatField;
    ClientDataSetResultsMINPROJ: TFloatField;
    ClientDataSetResultsDECIMALS: TFloatField;
    ClientDataSetResultsUNITS: TStringField;
    ClientDataSetResultsSPECIESFIT: TStringField;
    ClientDataSetResultsSOURCESFIT: TStringField;
    ClientDataSetResultsCMBOUTDB: TMemoField; // - ???
    LabelOutputFileFormat: TLabel;
    ComboBoxOutputFileFormat: TComboBox;
    PanelOutputFileFormat: TPanel;
    DBRichCMBoutDB: TDBRichEdit;
    ApplicationEvents1: TApplicationEvents; // added 09/27/03 -TC

    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MenuItemFileSaveClick(Sender: TObject);
    procedure MenuItemFilePrintClick(Sender: TObject);
    procedure MenuItemFileExitClick(Sender: TObject);
    procedure MenuItemHelpContentsClick(Sender: TObject);
    procedure MenuItemHelpAboutClick(Sender: TObject);
    procedure CheckBoxBestFitClick(Sender: TObject);
    procedure CheckBoxBrittClick(Sender: TObject);
    procedure CheckBoxSourceClick(Sender: TObject);
    procedure ClientDataSetSamplesAfterScroll(DataSet: TDataSet);
    procedure ClientDataSetSourcesAfterScroll(DataSet: TDataSet);
    procedure ComboBoxUnitsChange(Sender: TObject);
    procedure ComboBoxUnitsExit(Sender: TObject);
    procedure DBChartSamplesGetLegendText(Sender: TCustomAxisPanel; LegendStyle: TLegendStyle; Index: Integer; var LegendText: string);
    procedure DBChartSourcesGetLegendText(Sender: TCustomAxisPanel; LegendStyle: TLegendStyle; Index: Integer; var LegendText: string);
    procedure DBGridSamplesCellClick(Column: TColumn);
    procedure DBGridSamplesColExit(Sender: TObject);
    procedure DBGridSourcesCellClick(Column: TColumn);
    procedure DBGridSourcesIndexClick(Column: TColumn);
    procedure DBGridSpeciesCellClick(Column: TColumn);
    procedure DBGridSpeciesIndexClick(Column: TColumn);
    procedure DataSourceResultsDataChange(Sender: TObject; Field: TField);
    procedure EditControlFileChange(Sender: TObject);

    procedure MaskEditIterationChange(Sender: TObject);
    procedure MaskEditIterationExit(Sender: TObject);
    procedure MaskEditUncertaintyChange(Sender: TObject);
    procedure MaskEditUncertaintyExit(Sender: TObject);
    procedure MaskEditProjectionChange(Sender: TObject);
    procedure MaskEditProjectionExit(Sender: TObject);
    procedure MaskEditDecimalsChange(Sender: TObject);
    procedure MaskEditDecimalsExit(Sender: TObject);
    procedure MaskEditChiSquareChange(Sender: TObject);
    procedure MaskEditChiSquareExit(Sender: TObject);
    procedure MaskEditRSquareChange(Sender: TObject);
    procedure MaskEditRSquareExit(Sender: TObject);
    procedure MaskEditPercentMassChange(Sender: TObject);
    procedure MaskEditPercentMassExit(Sender: TObject);
    procedure MaskEditFractionChange(Sender: TObject);
    procedure MaskEditFractionExit(Sender: TObject);

    procedure PageControlMainChange(Sender: TObject);
    procedure PageControlMainChanging(Sender: TObject; var AllowChange: Boolean);
    procedure PageControlMainDrawTab(Control: TCustomTabControl; TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure PageControlResultsDrawTab(Control: TCustomTabControl;TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure Series1GetMarkText(Sender: TChartSeries; ValueIndex: Integer; var MarkText: string);
    procedure Series2GetMarkText(Sender: TChartSeries; ValueIndex: Integer;var MarkText: string);
    procedure SpeedButtonAmbientDataClick(Sender: TObject);
    procedure SpeedButtonAmbientDataSelectionClick(Sender: TObject);
    procedure SpeedButtonDeleteAllClick(Sender: TObject);
    procedure SpeedButtonDeleteCurrentClick(Sender: TObject);
    procedure SpeedButtonIN8Click(Sender: TObject);
    procedure SpeedButtonPrintClick(Sender: TObject);
    procedure SpeedButtonResetToDefaultClick(Sender: TObject);
    procedure SpeedButtonRunClick(Sender: TObject);
    procedure SpeedButtonSamplesGraphClick(Sender: TObject);
    procedure SpeedButtonSamplesShowDataClick(Sender: TObject);
    procedure SpeedButtonSamplesViewAllClick(Sender: TObject);
    procedure SpeedButtonSaveClick(Sender: TObject);
    procedure SpeedButtonSelectAllSamplesClick(Sender: TObject);
    procedure SpeedButtonSelectAllSourcesClick(Sender: TObject);
    procedure SpeedButtonSelectAllSpeciesClick(Sender: TObject);
    procedure SpeedButtonSourceProfileClick(Sender: TObject);
    procedure SpeedButtonSourceProfileSelectionClick(Sender: TObject);
    procedure SpeedButtonSourcesGraphClick(Sender: TObject);
    procedure SpeedButtonSourcesShowDataClick(Sender: TObject);
    procedure SpeedButtonSourcesViewAllClick(Sender: TObject);
    procedure SpeedButtonSpeciesSelectionClick(Sender: TObject);
    procedure SpeedButtonSpeciesViewAllClick(Sender: TObject);
    procedure ComboBoxOutputFileFormatClick(Sender: TObject);
    function ApplicationEvents_OnHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
    procedure ApplicationEvents1ShortCut(var Msg: TWMKey;
      var Handled: Boolean);

  private
    FSampleCount, FSpecieCount, FSourceCount: Integer;
    FCurSpeciesFit, FCurSourcesFit, FCurrentControlFolder, FCurrentControlFile, FLastControlFile: string; // TC added FCurrentControlFolder 08/27/03; added FLastControlFile 9/7/03
    FLastADFileName, FLastPRFileName, FLastADSelFileName, FLastSPSelFileName, FLastPRSelFileName: String; // TC added 08/26/04
    FLastADFullPathName, FLastPRFullPathName, FLastADSelFullPathName, FLastSPSelFullPathName, FLastPRSelFullPathName: String; // TC added 09/09/03
    FSaveIn8, FSaveSamples, FSaveSpecies, FSaveSources, FFirstTimeRunning, FNewControlFile: Boolean;      // Scalco added FirstTimeRunning to kick-start NO Control File runs on 9/4/03;
                                                                                                          // TC added FNewControlFile on 9/9/03.
    FUseControlFile: Boolean; // Added 9/11/03; this flag is set in StartupFrm and is used in procs IN8Click & PageControlMainChanging
    FDichotomous: Boolean;    // TC added 10/30/04 for new func QC_Dichotomous

    procedure CreateSamplesDataset;
    procedure CreateSourcesDataset;
    procedure PruneSamples;
    procedure PruneSources;
    procedure ShowSampleCount;
    procedure ShowSpecieCount;
    procedure ShowSourceCount;
    procedure GetSampleCount;
    procedure GetSpecieCount;
    procedure GetSourceCount;
    function  SampleSizeRangeCountExceeded: Boolean;
    procedure GetCurSam;
    procedure GetCurSrc;
    procedure GetSpecies;
    procedure ReadIn8;
    procedure BestFit;
    procedure GetBarValue1;
    procedure GetBarValue2;
    procedure StartSession;
    procedure SaveInputToIN8File(const FileName: string);
    procedure SaveSamplesToTextFile(const FileName: string);
    procedure SaveSpeciesToTextFile(const FileName: string);
    procedure SaveSourcesToTextFile(const FileName: string);
    function  UserChangedInputFilesOnTheFly: Boolean;
    function  RunCMB: Boolean;
    procedure EnableRunCMBControls (const aRecordCount: integer); //JS 08/06/04
    function  VerifyCMBRunInputsValid: Boolean;                   //JS 08/06/04
    function  QC_Dichotomous: Integer;                            //TC 10/29/04
    procedure CheckToSaveFiles; // TC extracted from proc FormCloseQuery so it can
                                // be called from proc SpeedButtonIN8Click -11/15/04

  protected
  public
    function LoadIn8File : Boolean;
//  Declare switch - FUseControlFile - for use of Control File at Startup (tc; 9/11/03):
    Property UseControlFile: Boolean read FUseControlFile write FUseControlFile;

//  The following line facilitates procedure SetBatchFlag in CMB82Internals.  While MainFrm
//  is listed as one of its uses @135, this Property is necessary for the variable
//  FSampleCount to be accessible to this procedure, which determines (at any given time)
//  whether or not Batch Mode (tc; 3/03):
    Property SampleCount: integer read FSampleCount write FSampleCount;
  end;

var
  MainForm: TMainForm;
// Public globals:
  g_ADSelFullPathName: string;
  g_SPSelFullPathName: string;
  g_PRSelFullPathName: string;
  g_ADFullPathName:    string;
  g_PRFullPathName:    string;

  function  ParseStringIntoStringList(
    const Line, Separator: string):
    TStringList;

implementation

{$R *.DFM}

uses
  IniFiles,
  Math,
  Types,
  MidasLib,   // Reference to Windows' Midas.dll;
              // must be added manually when using TClientDataSets: go figure.
  CMB82Internals,
  AboutFrm,
  BLWarningFrm,
  PrintOptionsFrm,
  SaveResultsFrm,
  StartupFrm,
  WaitFrm;

const
  EXTRA_SAMPLE_FIELDS = 2;

procedure TMainForm.FormCreate(Sender: TObject);
begin

  FFirstTimeRunning := true; // This flag is only used for running withOUT a Control File.

  // Initialize the member variables which need to be initialized.
  FCurSpeciesFit := 'FIT1';
  FCurSourcesFit := 'FIT1';

  Application.HelpFile := ExtractFilePath(Application.ExeName) + 'EPACMB82.hlp';
  Caption := Application.Title;
  PanelOutputFileFormat.Caption := '   Output Format: ' + MainForm.ComboBoxOutputFileFormat.Text;

  ClientDataSetCurSam.CreateDataSet;
  ClientDataSetCurSrc.CreateDataSet;
  ClientDataSetSpecies.CreateDataSet;
  ClientDataSetResults.CreateDataSet;
  ClientDataSetResults.Open;

  // This allows attributes such as Color to be set.
  PageControlMain.OwnerDraw    := True;
  PageControlResults.OwnerDraw := True;

  PageControlResults.ActivePage := TabSheetSummary;
  PageControlMain.ActivePage    := TabSheetInputFiles;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  SpeedButtonClearAllSpecies.Caption  := 'Clear All Array 1';
  SpeedButtonSelectAllSpecies.Caption := 'Select All Array 1';
  SpeedButtonClearAllSources.Caption  := 'Clear All Array 1';
  SpeedButtonSelectAllSources.Caption := 'Select All Array 1';
end;

procedure TMainForm.FormShow(Sender: TObject);
var
  ResultOk: Boolean;
  lResult : TStartupResultType;

begin
  ResultOK := false;
  PageControlMain.Visible := False;   // Make the Main Form INvisible.

  while (ResultOK = false) do
  begin
    StartupForm.ShowModal;            // Display Startup dialog and allow user
                                      // to choose Control File mode or not.

    // Get the result from the form; there are a few different choices here:
    lResult := StartupForm.StartupResultType;

    case lResult of
      // User is in Control File mode and selected a file from input file dialog OR
      // user selected 'Select Control File mode'; either of these are good , so we're ready to Run CMB.
      srtOKControlFileOK, srtOKSelCtrlFile:
        begin
          ResultOK := true;
          PageControlMain.Visible := True;  // Now that Startup Form has finished,
                                            // we return and present the Main Form.
          PageControlMain.ActivePage := TabSheetInputFiles;
        end;

      // User clicked OK, but then cancelled; we'll need to display the dialog and prompt again:
      srtOKControlFileCancel:
        begin
          // resultOk value is still not true, so we're not done.
        end;

     // User Cancelled dialog (abort): just exit
      srtCancelled:
        exit;

      else
      //  Msg('invalid case... why?'); // Severe error - should never happen.
    end;
  end;
end;

procedure TMainForm.MenuItemFileSaveClick(Sender: TObject);
begin
  SpeedButtonSave.Click;
end;

procedure TMainForm.MenuItemFilePrintClick(Sender: TObject);
begin
  SpeedButtonPrint.Click;
end;

procedure TMainForm.MenuItemFileExitClick(Sender: TObject);
begin
  // File saving and other cleanup is handled by the OnCloseQuery event handler.
  Close;
end;

procedure TMainForm.MenuItemHelpContentsClick(Sender: TObject);
begin
  Application.HelpJump('Contents');
end;

procedure TMainForm.MenuItemHelpAboutClick(Sender: TObject);
var
  TheForm: TAboutForm;
begin
  TheForm := TAboutForm.Create(Self);
  try
    TheForm.ShowModal;
  finally
    FreeAndNil(TheForm);
  end;
end;

procedure TMainForm.CheckBoxBestFitClick(Sender: TObject);
var
  Color: TColor;
  Enabled: Boolean;
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;

  if CheckBoxBestFit.Checked then
  begin
    Color   := clNavy;
    Enabled := True;
  end
  else
  begin
    Color   := clGray;
    Enabled := False;
  end;
  LabelFitMeasure.Font.Color  := Color;
  LabelChiSquare.Font.Color   := Color;
  LabelRSquare.Font.Color     := Color;
  LabelPercentMass.Font.Color := Color;
  LabelFraction.Font.Color    := Color;
  MaskEditChiSquare.Enabled   := Enabled;
  MaskEditRSquare.Enabled     := Enabled;
  MaskEditPercentMass.Enabled := Enabled;
  MaskEditFraction.Enabled    := Enabled;
end;

procedure TMainForm.CheckBoxBrittClick(Sender: TObject);
var
  TheForm: TBLWarningForm;
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
  if CheckBoxBritt.Checked then
  begin
    // Display warning message for Britt-Luecke algorithm.
    TheForm := TBLWarningForm.Create(Self);
    try
      TheForm.ShowModal;
    finally
      FreeAndNil(TheForm);
    end;
  end;
end;

procedure TMainForm.CheckBoxSourceClick(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.ClientDataSetSamplesAfterScroll(DataSet: TDataSet);
var
  OldCursor: TCursor;
begin
  if DBChartSamples.Visible then
  begin
    OldCursor := Screen.Cursor;
    try
      Screen.Cursor := crHourGlass;
      PanelSamples.Caption
        := 'AMBIENT DATA SAMPLE - '
        + ClientDataSetSamples.FieldByName('SITE').Text
        + ' '
        + ClientDataSetSamples.FieldByName('DATE').Text;
      GetBarValue1;
    finally
      Screen.Cursor := OldCursor;
    end;
  end;
end;

procedure TMainForm.ClientDataSetSourcesAfterScroll(DataSet: TDataSet);
var
  OldCursor: TCursor;
begin
  if DBChartSources.Visible then
  begin
    OldCursor := Screen.Cursor;
    try
      Screen.Cursor := crHourGlass;
      PanelSources.Alignment := taCenter;
      PanelSources.Caption
        := 'PROFILE - '
        + ClientDataSetSources.FieldByName('PNO').Text
        + ' '
        + ClientDataSetSources.FieldByName('SID').Text;
      GetBarValue2;
    finally
      Screen.Cursor := OldCursor;
    end;
  end;
end;

procedure TMainForm.ComboBoxUnitsChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.ComboBoxUnitsExit(Sender: TObject);
begin
  if ComboBoxUnits.Text = '(specify unit)' then
  begin
    SpeedButtonRun.Enabled := False;
    MessageDlg(
      'You have elected to specify your own concentration unit.'
      + #13#10
      + 'Please enter the text for the concentration unit.',
      mtInformation,
      [mbOK],
      0);
    ComboBoxUnits.SetFocus;
  end
  else
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.DBChartSamplesGetLegendText(
  Sender: TCustomAxisPanel;
  LegendStyle: TLegendStyle;
  Index: Integer;
  var LegendText: string);
var
  Amount, Uncert: string;
begin
  with ClientDataSetCurSam do
  begin
    First;
    MoveBy(Index);
    Amount := FieldByName('AMOUNT').Text;
    Uncert := FieldByName('UNCERT').Text;
    LegendText
      := FieldByName('SPECIE').Text
      + '  '
      + Copy(Amount, 1, Pos('.', Amount) + 3)
      + '  '
      + Copy(Uncert, 1, Pos('.', Uncert) + 3);
  end;
end;

procedure TMainForm.DBChartSourcesGetLegendText(
  Sender: TCustomAxisPanel;
  LegendStyle: TLegendStyle;
  Index: Integer;
  var LegendText: string);
var
  Amount, Uncert: string;
begin
  with ClientDataSetCurSrc do
  begin
    First;
    MoveBy(Index);
    Amount := FieldByName('AMOUNT').Text;
    Uncert := FieldByName('UNCERT').Text;
    LegendText
      := FieldByName('SPECIE').Text
      + '  '
      + Copy(Amount, 1, Pos('.', Amount) + 3)
      + '  '
      + Copy(Uncert, 1, Pos('.', Uncert) + 3);
  end;
end;

procedure TMainForm.DBGridSamplesCellClick(Column: TColumn);
begin
  with ClientDataSetSamples do
  begin
    if SameText(Column.FieldName, 'SELECTED') then
    begin
      FSaveSamples := True;
      Edit;
      if FieldByName(Column.FieldName).Text <> '*' then
      begin
        FieldByName(Column.FieldName).Text := '*';
        Inc(FSampleCount);
        UpdateADCode('*'); // Call I to Task 7
      end
      else
      begin
        FieldByName(Column.FieldName).Text := '';
        Dec(FSampleCount);
        UpdateADCode(' '); // Call II to Task 7
      end;
      Post;
      SpeedButtonRun.Enabled := True;
    end;
  end;
  ShowSampleCount;
end;

procedure TMainForm.DBGridSamplesColExit(Sender: TObject);
begin
  with DBGridSamples do
    Columns.Items[SelectedIndex].Color := clWhite;
end;

procedure TMainForm.DBGridSourcesCellClick(Column: TColumn);
begin
  if SameText(Copy(Column.FieldName, 1, 3), 'FIT')
    and (Column.Color = clInfoBk)
    and (DataSourceSources.DataSet = ClientDataSetSources) then
  begin
    FSaveSources := True;
    with ClientDataSetSources do
    begin
      Edit;
      if FieldByName(Column.FieldName).Text <> '*' then
      begin
        FieldByName(Column.FieldName).Text := '*';
        Inc(FSourceCount);
        UpdatePRCodeUser('*');
      end
      else
      begin
        FieldByName(Column.FieldName).Text := '';
        Dec(FSourceCount);
        UpdatePRCodeUser(' ');
      end;
      Post;
      SpeedButtonRun.Enabled := True;
    end;
    ShowSourceCount;
  end;
end;

procedure TMainForm.DBGridSourcesIndexClick(Column: TColumn);
var
  I: Integer;
begin
  for I := 0 to DBGridSources.FieldCount - 1 do
  begin
    DBGridSources.Columns[I].Color := clWhite;
    if  (I = Column.Index)
      and SameText(Copy(Column.FieldName, 1, 3), 'FIT') then
    begin
      Column.Color := clInfoBk;
      Column.Font.Color := clInfoText;
      FCurSourcesFit := Copy(Column.FieldName, 1, 5);
      SpeedButtonSelectAllSources.Caption
        := 'Select All Array ' + Column.Field.DisplayLabel;
      SpeedButtonClearAllSources.Caption
        := 'Clear All Array ' + Column.Field.DisplayLabel;
      ClientDataSetSources.Filtered := False;
      ClientDataSetSources.Filter := Column.FieldName + ' = ''*''';
      SpeedButtonSourcesViewAll.Caption := 'View Selected';
      with ClientDataSetSources do
      begin
        DisableControls;
        First;
        while not EoF do
        begin
          if ClientDataSetSources.FieldByName(Column.FieldName).Text = '*' then
            UpdatePRCodeUser('*')
          else
            UpdatePRCodeUser(' ');
          Next;
        end;
        EnableControls;
      end;
    end;
  end;
  GetSourceCount;
  ShowSourceCount;
  SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.DBGridSpeciesCellClick(Column: TColumn);
begin
  if SameText(Copy(Column.FieldName, 1, 3), 'FIT')
    and (Column.Color = clInfoBk) then
  begin
    FSaveSpecies := True;
    with ClientDataSetSpecies do
    begin
      Edit;
      if FieldByName(Column.FieldName).Text <> '*' then //Add *
      begin
        FieldByName(Column.FieldName).Text := '*';
        Inc(FSpecieCount); // INcrement species count
        UpdateSPCodeUser('*');
      end
      else
      begin
        FieldByName(Column.FieldName).Text := '';       // Remove *
        Dec(FSpecieCount); // DEcrement species count
        UpdateSPCodeUser(' ');
      end;
      Post;
      SpeedButtonRun.Enabled := True;
    end;
    ShowSpecieCount;
  end;
end;

procedure TMainForm.DBGridSpeciesIndexClick(Column: TColumn);
var
  I: Integer;
begin
  for I := 0 to DBGridSpecies.FieldCount - 1 do
  begin
    DBGridSpecies.Columns[I].Color := clWhite;
    if (I = Column.Index) and SameText(Copy(Column.FieldName, 1, 3), 'FIT') then
    begin
      Column.Color := clInfoBk;
      Column.Font.Color := clInfoText;
      FCurSpeciesFit := Copy(Column.FieldName, 1, 5);
      SpeedButtonSelectAllSpecies.Caption
        := 'Select All Array ' + Column.Field.DisplayLabel;
      SpeedButtonClearAllSpecies.Caption
        := 'Clear All Array ' + Column.Field.DisplayLabel;
      SpeedButtonSpeciesViewAll.Caption := 'View Selected';
      with ClientDataSetSpecies do
      begin
        DisableControls;
        Filtered := False;                              // Scalco tried 03/01/05
        Filter := Column.FieldName + ' = ''*''';
        First;
        while not EoF do
        begin
          if FieldByName(Column.FieldName).Text = '*' then
            UpdateSPCodeUser('*')
          else
            UpdateSPCodeUser(' ');
          Next;
        end;
        First;
        EnableControls;
      end;
    end;
  end;
  GetSpecieCount;
  ShowSpecieCount;
  SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.DataSourceResultsDataChange(Sender: TObject; Field: TField);
var
  Enabled: Boolean;
begin
  if ClientDataSetResults.RecordCount = 0 then
    LabelResult.Caption := 'Result 0 of 0'
  else
  begin
    LabelResult.Caption
      := 'Result ' + IntToStr(ClientDataSetResults.RecNo)
      + ' of ' + IntToStr(ClientDataSetResults.RecordCount);
  end;

  // Enable/disable Fit Measure Weight display.
  Enabled := ClientDataSetResults.FieldByName('BEST').AsBoolean;
  Label21.Enabled          := Enabled;
  Label27.Enabled          := Enabled;
  DBTextChiSq.Enabled      := Enabled;
  Label26.Enabled          := Enabled;
  DBTextRSquare.Enabled    := Enabled;
  Label28.Enabled          := Enabled;
  DBTextPercent.Enabled    := Enabled;
  Label29.Enabled          := Enabled;
  DBTextWtFraction.Enabled := Enabled;

  // Flag failures in red.
  if (Pos('NO CONVERGENCE', DBMemoSummary.Lines[0]) > 0)
    or (Pos('AKT*VEFFIN*AK', DBMemoSummary.Lines[0]) > 0) then
  begin
    DBMemoSummary.Font.Color := clRed
  end
  else
    DBMemoSummary.Font.Color := clBlack;
end;

procedure TMainForm.EditControlFileChange(Sender: TObject);
begin
  PanelControlFile.Caption       // This displays Control File name on the dashboard.
    := '   Control File: ' + ExtractFileName(EditControlFile.Text);
  if EditControlFile.Text = '' then
    FSaveIn8 := True;
end;

procedure TMainForm.MaskEditIterationChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditIterationExit(Sender: TObject);
begin                                             // QC on Iteration Delta range
  if (StrToInt(MaskEditIteration.Text) < 0)
    or (StrToInt(MaskEditIteration.Text) > 20) then
  begin
    MessageDlg('Value must be between 0 and 20', mtInformation, [mbOK], 0);
    MaskEditIteration.SetFocus;
  end;
end;

procedure TMainForm.MaskEditUncertaintyChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditUncertaintyExit(Sender: TObject);
begin                                  // QC on Maximum Source Uncertainty range
  if (StrToInt(MaskEditUncertainty.Text) < 0)
    or (StrToInt(MaskEditUncertainty.Text) > 100) then
  begin
    MessageDlg('Value must be between 0 and 100', mtInformation, [mbOK], 0);
    MaskEditUncertainty.SetFocus;
  end;
end;

procedure TMainForm.MaskEditProjectionChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditProjectionExit(Sender: TObject);
begin                                   // QC on Minimum Source Projection range
  if (StrToFloat(MaskEditProjection.Text) < 0.0)
    or (StrToFloat(MaskEditProjection.Text) > 1.0) then
  begin
    MessageDlg('Value must be between 0.0 and 1.0', mtInformation, [mbOK], 0);
    MaskEditProjection.SetFocus;
  end;
end;

// This proc ensures the proper display of decimals displayed in the Main Report
// when a change is made on the Options screen:
procedure TMainForm.MaskEditDecimalsChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
//    g_DisplayDecimalPlaces := StrToInt(MaskEditDecimals.Text); This line is def. NOT good; makes edit box fault when making manual val. change
//    SetDisplayDecimals;                                        This line is not in parallel with other models (above); eliminate?
end;

procedure TMainForm.MaskEditDecimalsExit(Sender: TObject);
begin                                // QC on no. Decimal Places Displayed range
  if (StrToInt(MaskEditDecimals.Text) < 1)
    or (StrToInt(MaskEditDecimals.Text) > 6) then
  begin
    MessageDlg('Value must be between 1 and 6', mtInformation, [mbOK], 0);
    MaskEditDecimals.SetFocus;
  end;
end;

// 4 Coefficients for Best Fit:
procedure TMainForm.MaskEditChiSquareChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditChiSquareExit(Sender: TObject);
begin                                                  // QC on Chi Square range
  if (StrToFloat(MaskEditChiSquare.Text) < 0.0)
    or (StrToFloat(MaskEditChiSquare.Text) > 1.0) then
  begin
    MessageDlg('Value must be between 0.0 and 1.0', mtInformation, [mbOK], 0);
    MaskEditChiSquare.SetFocus;
  end;
end;

procedure TMainForm.MaskEditRSquareChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditRSquareExit(Sender: TObject);
begin                                                    // QC on R Square range
  if (StrToFloat(MaskEditRSquare.Text) < 0.0)
    or (StrToFloat(MaskEditRSquare.Text) > 1.0) then
  begin
    MessageDlg('Value must be between 0.0 and 1.0', mtInformation, [mbOK], 0);
    MaskEditRSquare.SetFocus;
  end;
end;

procedure TMainForm.MaskEditPercentMassChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditPercentMassExit(Sender: TObject);
begin                                                      // QC on % Mass range
  if (StrToFloat(MaskEditPercentMass.Text) < 0.0)
    or (StrToFloat(MaskEditPercentMass.Text) > 1.0) then
  begin
    MessageDlg('Value must be between 0.0 and 1.0', mtInformation, [mbOK], 0);
    MaskEditPercentMass.SetFocus;
  end;
end;

procedure TMainForm.MaskEditFractionChange(Sender: TObject);
begin
  if SpeedButtonRun.Enabled = False then
    SpeedButtonRun.Enabled := True;
end;

procedure TMainForm.MaskEditFractionExit(Sender: TObject);
begin                                         // QC on Fractional Estimate range
  if (StrToFloat(MaskEditFraction.Text) < 0.0)
    or (StrToFloat(MaskEditFraction.Text) > 1.0) then
  begin
    MessageDlg('Value must be between 0.0 and 1.0', mtInformation, [mbOK], 0);
    MaskEditFraction.SetFocus;
  end;
end;

procedure TMainForm.PageControlMainChange(Sender: TObject);
begin
  if PageControlMain.ActivePage = TabSheetInputFiles then
  begin
    DBNavigator.Enabled := False;
    MenuItemFileSave.Enabled := True;
    SpeedButtonSave.Enabled := True;
    SpeedButtonSave.Hint := 'Save input file names to IN8 file';
    MenuItemFilePrint.Enabled := False;
    SpeedButtonPrint.Enabled := False;
    SpeedButtonPrint.Hint := '';
  end
  else if PageControlMain.ActivePage = TabSheetOptions then
  begin
    DBNavigator.Enabled := False;
    MenuItemFileSave.Enabled := False;
    SpeedButtonSave.Enabled := False;
    SpeedButtonSave.Hint := '';
    MenuItemFilePrint.Enabled := False;
    SpeedButtonPrint.Enabled := False;
    SpeedButtonPrint.Hint := '';
  end
  else if PageControlMain.ActivePage = TabSheetSamples then
  begin
    DBNavigator.Enabled := True;
    DBNavigator.DataSource := DataSourceSamples;
    MenuItemFileSave.Enabled := True;
    SpeedButtonSave.Enabled := True;
    SpeedButtonSave.Hint := 'Save ambient data selection file';
    if DBGridSamples.Visible then
    begin
      MenuItemFilePrint.Enabled := False;
      SpeedButtonPrint.Enabled := False;
      SpeedButtonPrint.Hint := '';
      DBGridSamples.SetFocus;
    end
    else
    begin
      MenuItemFilePrint.Enabled := True;
      SpeedButtonPrint.Enabled := True;
      SpeedButtonPrint.Hint := 'Print graph';
    end;
  end
  else if PageControlMain.ActivePage = TabSheetSpecies then
  begin
    DBNavigator.Enabled := True;
    DBNavigator.DataSource := DataSourceSpecies;
    MenuItemFileSave.Enabled := True;
    SpeedButtonSave.Enabled := True;
    SpeedButtonSave.Hint := 'Save species selection file';
    MenuItemFilePrint.Enabled := False;
    SpeedButtonPrint.Enabled := False;
    SpeedButtonPrint.Hint := '';
    if DBGridSpecies.Visible then
      DBGridSpecies.SetFocus;
  end
  else if PageControlMain.ActivePage = TabSheetSources then
  begin
    DBNavigator.Enabled := True;
    DBNavigator.DataSource := DataSourceSources;
    MenuItemFileSave.Enabled := True;
    SpeedButtonSave.Enabled := True;
    SpeedButtonSave.Hint := 'Save source profile selection file';
    if DBGridSources.Visible then
    begin
      MenuItemFilePrint.Enabled := False;
      SpeedButtonPrint.Enabled := False;
      SpeedButtonPrint.Hint := '';
      DBGridSources.SetFocus;
    end
    else
    begin
      MenuItemFilePrint.Enabled := True;
      SpeedButtonPrint.Enabled := True;
      SpeedButtonPrint.Hint := 'Print graph';
    end;
  end
  else if PageControlMain.ActivePage = TabSheetResults then
  begin
    if ClientDataSetResults.RecordCount = 0 then
    begin
      MenuItemFileSave.Enabled := False;
      SpeedButtonSave.Enabled := False;
      SpeedButtonSave.Hint := '';
      MenuItemFilePrint.Enabled := False;
      SpeedButtonPrint.Enabled := False;
      SpeedButtonPrint.Hint := '';
      MessageDlg('Press RUN to generate results.', mtInformation, [mbOK], 0);
    end
    else
    begin
      DBNavigator.Enabled := True;
      DBNavigator.DataSource := DataSourceResults;
      MenuItemFileSave.Enabled := True;
      SpeedButtonSave.Enabled := True;
      SpeedButtonSave.Hint := 'Save "spreadsheet" - type results to file';
      MenuItemFilePrint.Enabled := True;
      SpeedButtonPrint.Enabled := True;
      SpeedButtonPrint.Hint := 'Print or save report of results';
    end;
  end;
end;

procedure TMainForm.PageControlMainDrawTab(
  Control: TCustomTabControl;
  TabIndex: Integer;
  const Rect: TRect;
  Active: Boolean);
var
  TabCaption: string;
  TextSize: TSize;
  Center: TPoint;
begin
  with Control.Canvas do
  begin
    TabCaption := PageControlMain.Pages[TabIndex].Caption;
    Center := CenterPoint(Rect);
    if Active then
    begin
      Brush.Color := clInfoBk;
      Font.Style  := [fsBold];
      Font.Color  := clWindowText;
      Dec(Center.Y);
    end
    else
    begin
      Brush.Color := clSilver;
      Font.Style  := [];
      Font.Color  := clNavy;
    end;
    TextSize := TextExtent(TabCaption);
    TextRect(
      Rect,
      Center.X - (TextSize.cx div 2),
      Center.Y - (TextSize.cy div 2),
      TabCaption);
  end;
end;

procedure TMainForm.PageControlResultsDrawTab(
  Control: TCustomTabControl;
  TabIndex: Integer;
  const Rect: TRect;
  Active: Boolean);
var
  TabCaption: string;
  TextSize: TSize;
  Center: TPoint;
begin
  with Control.Canvas do
  begin
    TabCaption := PageControlResults.Pages[TabIndex].Caption;
    Center := CenterPoint(Rect);
    if Active then
    begin
      Brush.Color := clInfoBk;
      Font.Style  := [fsBold];
      Font.Color  := clWindowText;
      Dec(Center.Y);
    end
    else
    begin
      Brush.Color := clSilver;
      Font.Style  := [];
      Font.Color  := clNavy;
    end;
    TextSize := TextExtent(TabCaption);
    TextRect(
      Rect,
      Center.X - (TextSize.cx div 2),
      Center.Y - (TextSize.cy div 2),
      TabCaption);
  end;
end;

procedure TMainForm.Series1GetMarkText(
  Sender: TChartSeries;
  ValueIndex: Integer;
  var MarkText: string);
begin
  Series1.Marks.Positions.Automatic(ValueIndex);
  with ClientDataSetCurSam do
  begin
    First;
    MoveBy(ValueIndex);
    MarkText := '' + FieldByName('UNCERT').Text;
  end;
end;

procedure TMainForm.Series2GetMarkText(
  Sender: TChartSeries;
  ValueIndex: Integer;
  var MarkText: string);
begin
  Series2.Marks.Positions.Automatic(ValueIndex);
  with ClientDataSetCurSrc do
  begin
    First;
    MoveBy(ValueIndex);
    MarkText := '' + FieldByName('UNCERT').Text;
  end;
end;

procedure TMainForm.SpeedButtonDeleteAllClick(Sender: TObject);
begin
  ClientDataSetResults.EmptyDataSet;
  SpeedButtonDeleteAll.Enabled     := False;
  SpeedButtonDeleteCurrent.Enabled := False;
  MenuItemFileSave.Enabled         := False;
  SpeedButtonSave.Enabled          := False;
  MenuItemFilePrint.Enabled        := False;
  SpeedButtonPrint.Enabled         := False;
end;

procedure TMainForm.SpeedButtonDeleteCurrentClick(Sender: TObject);
begin
  with ClientDataSetResults do
  begin
    if RecordCount = 1 then
      SpeedButtonDeleteAllClick(Sender)
    else
      Delete;
  end;
end;

procedure TMainForm.SpeedButtonIN8Click(Sender: TObject);
begin
  LoadIn8File;
end;

// User could cancel out of the selection of the open file dialog,
// resulting in no file being chosen when this is called from StartupForm.
// We need to know if thre was a Cancel.  By calling the click handler above, we
// don't have an easy way of knowing.  But by calling this routine, we can return
// a Boolean result to know if cancel occurred or not.
//
function TMainForm.LoadIn8File : Boolean;
var
  IniFile: TIniFile; // This file, once established, holds the name of the
                     // folder that contains the last Control File used.
BEGIN
  Result := false;
  IF FUseControlFile THEN
  begin
    IniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
    try
      // CurrentControlFolder name is retrieved from IniFile.
      FCurrentControlFolder := IniFile.ReadString(
                                        'File Settings', 'CurrentControlFolder',
                                        ExtractFilePath(Application.ExeName)
                                        );

      if not DirectoryExists (FCurrentControlFolder) then
      begin
        FCurrentControlFile   := '';
        FCurrentControlFolder := ExtractFilePath(Application.ExeName);
      end;

      OpenDialogCMBControlFile.FileName := '';

      // For convenience, pass FCurrentControlFolder name to OpenDialogCMBControlFile.InitialDir
      // so that user can start in the last folder used:
      OpenDialogCMBControlFile.InitialDir := FCurrentControlFolder;

      // user could cancel though, so we handle that below
      if OpenDialogCMBControlFile.Execute then              // OpenDialogCMBControlFile.FileName set here.
      begin
        // Update Control File/Folder and check for a new Control File (vs. last one)"
        FCurrentControlFile   := OpenDialogCMBControlFile.FileName;    // (Full Path) FCurrentControlFile initially set here.
        FCurrentControlFolder := ExtractFilePath(FCurrentControlFile); // Control Folder set here but REset in SBSaveClick
        EditControlFile.Text  := ExtractFileName(FCurrentControlFile);

        // FLastControlFile being set guarantees that program has already initiated 1st pass ...
        if (FLastControlFile <> '') and (FCurrentControlFile <> FLastControlFile) then
        begin
            if MessageDlg(
                        'You have selected a new Control File.  Do you want to start a new CMB session?'
                        + #10
                        + '(This will purge any previous results and reload input files;  NO = cancel.)',
                        mtConfirmation,
                        [mbYes, mbNo], 0) = mrYes then
              begin
                FNewControlFile := true;
                CheckToSaveFiles; // Check to see if any files have been modified; allow option to save; TC 11/15/04
                PageControlMain.ActivePage := TabSheetInputFiles; // After saving, update view to Select Input Files
              end
            else // roll back to pervious Control File (reset conditions)
            begin
              FNewControlFile       := false;
              FCurrentControlFile   := FLastControlFile;
              FCurrentControlFolder := ExtractFilePath(FCurrentControlFile);
              EditControlFile.Text  := ExtractFileName(FCurrentControlFile);
            end;
        end;

        //  ReadIN8; update IniFile; and remember last Control File.
        begin
          ReadIn8;  // proc ReadIn8 immediately changes Current Directory!
                    // QC checks for input files are made in ReadIn8.
          PageControlMain.Refresh;
          IniFile.WriteString ('File Settings', 'CurrentControlFolder',
                                ExtractFilePath(FCurrentControlFile) );
          FLastControlFile := FCurrentControlFile;
          Result := true;
        end;
      end
      else
      begin
        Result := false;
        // ShowMessage ('Cancelled.');
        // user cancelled
      end;
    finally
      FreeAndNil(IniFile);
    end;
  end
  ELSE // User has opted NOT to use a Control File; none will be allowed this session.
     ShowMessage (
        'When you started this session, you opted NOT to use a Control File. ' + #10
      + 'If you now wish to use one, you must exit the program and restart.')
end;

procedure TMainForm.ReadIn8;
var
  In8File: TextFile;
  InputFileName: string;
begin

  EditSourceProfileSelection.Text := '';
  EditSpeciesSelection.Text       := '';
  EditAmbientDataSelection.Text   := '';
  EditAmbientData.Text            := '';
  EditSourceProfiles.Text         := '';

// Before the following ChDir, CurrentDir is ...\*.exe
  try
    ChDir(FCurrentControlFolder);
    AssignFile(In8File, FCurrentControlFile);
    Reset(In8File);

// N.B.- This is the 1st place where the global full-path filenames are set in EPA-CMB8.2.
// They are possibly changed in only 3 other places:
//    1) in proc UserChangedInputFilesOnTheFly
//    2) in the reset section at the bottom of proc PageControlMainChanging
//    3) if no Control File is used, they'll be set (& possibly reset) in
//       any of the applicable 5 SpeedButton****Click objects in this unit.
//
// *if FileExists* checks CurrentDir (presumably = FCurrentControlFolder) for
// the input file name read in the Control File.  Non-specification/Non-existence
// of (optional) SELection files does not stop execution.

  try
    ReadLn(In8File, InputFileName);             // SOURCE PROFILE SELECTION FILE
    if FileExists(InputFileName) then
      begin
        EditSourceProfileSelection.Text := InputFileName;             // This populates Edit Control box.
        FLastPRSelFileName              := InputFileName;             // Remember filename to detect changes; TC added 08/26/04
        g_PRSelFullPathName := FCurrentControlFolder + InputFileName; // This (re)sets full path to file name.
      end
    else
    begin
      g_PRSelFullPathName := '';      // Explicitly set global filename to null.
      MessageDlg(                     // If missing, allow selection 'on the fly':
        'The optional source profiles selection file' + ' ' + '"' + InputFileName + '"' + ' '
        + 'directed by the Control File does not exist.' + #13#10
        + 'If this result was not intended, correct the Control File '
        + 'or retrieve a selection file on the next screen.' + #13#10
        + 'Otherwise, source profile selection will not be initialized.',
        mtInformation,
        [mbOK],
        0);
        g_PRSelFullPathName := FCurrentControlFolder + InputFileName; // Provides a dummy name for echo in Main Report
    end;
  except
    begin
      ShowErrorMessage(
        'Error reading source profile selection filename.'
        + #10
        + 'Please refer to Section 4 of Users Manual for file naming convention.');
      Exit;
    end;
  end;

  try
    ReadLn(In8File, InputFileName);                    // SPECIES SELECTION FILE
    if FileExists(InputFileName) then
      begin
        EditSpeciesSelection.Text := InputFileName;                   // This populates Edit Control box.
        FLastSPSelFileName        := InputFileName;                   // Remember filename to detect changes; TC added 08/26/04
        g_SPSelFullPathName := FCurrentControlFolder + InputFileName; // This (re)sets full path to file name.
      end
    else
    begin
      g_SPSelFullPathName := '';      // Explicitly set global filename to null.
      MessageDlg(                     // If missing, allow selection 'on the fly':
        'The optional species selection file' + ' ' + '"' + InputFileName + '"' + ' '
        + 'directed by the Control File does not exist.' + #13#10 +
        'If this result was not intended, correct the Control File '
        + 'or retrieve a selection file on the next screen.' + #13#10
        + 'Otherwise, species selection will not be initialized.',
        mtInformation,
        [mbOK],
        0);
        g_SPSelFullPathName := FCurrentControlFolder + InputFileName; // Provides a dummy name for echo in Main Report
    end;
  except
    begin
      ShowErrorMessage(
        'Error reading species selection filename.'
        + #10
        + 'Please refer to Section 4 of Users Manual for file naming convention.');
      Exit;
    end;
  end;

  try
    ReadLn(In8File, InputFileName);               // AMBIENT DATA SELECTION FILE
    if FileExists(InputFileName) then
      begin
        EditAmbientDataSelection.Text := InputFileName;               // This populates Edit Control box.
        FLastADSelFileName            := InputFileName;               // Remember filename to detect changes; TC added 08/26/04
        g_ADSelFullPathName := FCurrentControlFolder + InputFileName; // This (re)sets full path to file name.
      end
    else
    begin
      g_ADSelFullPathName := '';      // Explicitly set global filename to null.
      MessageDlg(                     // If missing, allow selection 'on the fly':
        'The optional ambient data selection file' + ' ' + '"' + InputFileName + '"' + ' '
        + 'directed by the Control File does not exist.' + #13#10
        + 'If this result was not intended, correct the Control File '
        + 'or retrieve a selection file on the next screen.' + #13#10
        + 'Otherwise, ambient sample selection will not be initialized.',
        mtInformation,
        [mbOK],
        0);
        g_ADSelFullPathName := FCurrentControlFolder + InputFileName; // Provides a dummy name for echo in Main Report
    end;
  except
    begin
      ShowErrorMessage(
        'Error reading ambient data selection filename.'
        + #10
        + 'Please refer to Section 4 of Users Manual for file naming convention.');
      Exit;
    end;
  end;
  // Delphi's intrinsic FileExists ONLY pertains to the Current Directory (NOT
  // the entire hard drive), which in CMB8.2 = the Control File directory.
  // In the following 2 Try blocks, check that required input files actually exist in the Control File directory:

  try
    ReadLn(In8File, InputFileName);   // Required AMBIENT DATA (AD) File
    if FileExists(InputFileName) then // This check will NEVER raise an exception.
      begin
        EditAmbientData.Text := InputFileName;                     // This populates Edit Control box.
        FLastADFileName      := InputFileName;                     // Remember filename to detect changes; TC added 08/26/04
        g_ADFullPathName := FCurrentControlFolder + InputFileName; // This (re)sets full path to file name.
      end
    else
      // EditAmbientData.Text = null; this serves as a convenient flag for missing in proc PCMC.
  except
    On E:EInOutError do
    begin
      ShowErrorMessage('Error: ' + LookupEInOutErrorName(E.ErrorCode));
      Exit;
    end;
  end;

  try
    ReadLn(In8File, InputFileName);   // Required SOURCE PROFILES (PR) File
    if FileExists(InputFileName) then // This check is placed here cuz it'll NEVER raise an exception.
      begin
        EditSourceProfiles.Text := InputFileName;                  // This populates Edit Control box.
        FLastPRFileName         := InputFileName;                  // Remember filename to detect changes; TC added 08/26/04
        g_PRFullPathName := FCurrentControlFolder + InputFileName; // This (re)sets full path to file name.
      end
    else
      // EditSourceProfiles.Text = null; this serves as a convenient flag for missing in proc PCMC.
  except
    On E:EInOutError do
    begin
      ShowErrorMessage('Error: ' + LookupEInOutErrorName(E.ErrorCode));
      Exit;
    end;
  end;
  finally
    CloseFile(In8File);
  end;
end; // End of ReadIN8

procedure TMainForm.PageControlMainChanging(
  Sender: TObject;
  var AllowChange: Boolean);

// All initialization calls to proc StartSession are made from this procedure.
// This procedure is invoked whenever a different tab is been selected on the Main Form.
// Preferable would be if it was triggered by a move off the Input Files tab only!
begin
if PageControlMain.ActivePage = TabSheetInputFiles then // This condition's imperfect;
  // doesn't always know if we're OFF the Input Files tab.  The problem is that it
  // considers TabSheetInputFiles in terms of what is WAS, not what it IS (now).

  IF FUseControlFile then // FUseControlFile set in StartupFrm.
                          // User's chosen to use a Control File.
  begin
    // This QC module is retained here (in PCMC) in order to access vars like Edit*.Text and to
    // facilitate making file changed dynamically ('on the fly') via browse (e.g., AllowChange):
    // Check that the input file names have been set in proc ReadIn8:
    if (EditAmbientData.Text = '') or (EditSourceProfiles.Text = '') then

    begin       // Either AD file or PR file is not as directed in Control File.
      if (EditAmbientData.Text = '') and (EditSourceProfiles.Text = '') then
      begin                                           // BOTH files are missing.
        MessageDlg(
          'Required Ambient Data (AD*) and Source Profiles (PR*) input files directed by the Control File do not exist; browse to select them.',
          mtInformation,
          [mbOK],
          0);
      end
      else if (EditAmbientData.Text = '') then
      begin                                               // AD file is missing.
        MessageDlg(
          'Required Ambient Data (AD*) input file directed by the Control File does not exist; browse to select one.',
          mtInformation,
          [mbOK],
          0); // Once AD file is selected via proc SBAmbientDataClick, Full Path (g_...) is set.
        EditAmbientData.SetFocus; // Flashes cursor on AD input field in dialog.
      end
      else
      begin                                               // PR file is missing.
        MessageDlg(
          'Required Source Profiles (PR*) input file directed by the Control File does not exist; browse to select one.',
          mtInformation,
          [mbOK],
          0); // Once PR file is selected via proc SBSourceProfileClick, Full Path (g_...) is set.
        EditSourceProfiles.SetFocus; // Flashes cursor on PR input field in dialog.
      end;
      AllowChange := False; // CRITICAL: we DISallow moving OFF the Select Input
                            // Files screen until file selection is QC'd.
      Exit;                 // Must exit in order to make file selections ...
    end

    // This is the 1st pass of the 1st session, or a new Control File has been selected.
    // Required input files have been QC'd and we're ready to start the CMB session.
    // In this branch, we don't interrupt to query user about starting a new session because
    // only the Control File might be new, and Start New Session option was queried and set
    // upstream in SpeedButtonIN8Click(Sender...

    else if not UserChangedInputFilesOnTheFly then
    begin
      Application.ProcessMessages;
      StartSession;
      Application.ProcessMessages;
      AllowChange       := True;
      FNewControlFile   := false  // reset New Control file flag
    end

    // This is a subsequent pass w/ same Control File in which a new session is possible.
    // In this branch, it's NOT a new Control File but the user has selected one of more different
    // input files.  We check UserChangedInputFiles to see if a new session automatically triggered
    // because one or more input files has changed.

    else                    // same Control File but initially directed
                            // input file(s) have been changed during session
                            // regardless of whether a calculation has been made
      if (MessageDlg(
        'You are running with a Control File and one or more input files have changed.'
        + #10 + 'Do you want to start a new CMB session?' + #10#13#13
        + '(This will purge any previous results and reload with new input files; NO = cancel.)?',
        mtConfirmation,
        [mbYes, mbNo], 0) = mrYes) then
      begin                                          // Start a new CMB session.
        Application.ProcessMessages;
        StartSession;
        Application.ProcessMessages;
        AllowChange := True;
      end
      else // DON'T start a new CMB session; we revert to previous files dircted by the last Control File loaded.
   // Cancel; re-read the Control File to reset the Dashboard & Edit Control boxes.
      begin
        EditControlFile.Text := ExtractFileName(FCurrentControlFile);
        ReadIn8;
        PageControlMain.Refresh;
      end;
  end
  ELSE                                       // User's NOT using a Control File.
    begin
    // This QC module is retained here (in PCMC) in order to access vars like Edit*.Text and to
    // facilitate making file changed dynamically ('on the fly') via browse (e.g., AllowChange):
    // Check that the input file names have been set:
    if (EditAmbientData.Text = '') or (EditSourceProfiles.Text = '') then

    begin                // Either AD file or PR file has not been selected.
      if (EditAmbientData.Text = '') and (EditSourceProfiles.Text = '') then
      begin                             // BOTH files haven't been selected.
        MessageDlg(
          'Required Ambient Data (AD*) and Source Profiles (PR*) input files have not been selected; browse to select them.',
          mtInformation,
          [mbOK],
          0);
      end
      else if (EditAmbientData.Text = '') then
      begin                                     // AD file hasn't been selected.
        MessageDlg(
          'Required Ambient Data (AD*) input file has not been selected; browse to select one.',
          mtInformation,
          [mbOK],
          0); // Once AD file is selected via proc SBAmbientDataClick, Full Path (g_...) is set.
        EditAmbientData.SetFocus; // Flashes cursor on AD input field in dialog.
      end
      else
      begin                                     // PR file hasn't been selected.
        MessageDlg(
          'Required Source Profiles (PR*) input file has not been selected; browse to select one.',
          mtInformation,
          [mbOK],
          0); // Once PR file is selected via proc SBSourceProfileClick, Full Path (g_...) is set.
        EditSourceProfiles.SetFocus; // Flashes cursor on PR input field in dialog.
      end;
      AllowChange := False; // CRITICAL: we DISallow moving OFF the Select Input
                            // Files screen until file selection is QC'd.
      Exit;                 // Must exit in order to make file selections ...
    end

 // Required input files have been QC'd and we're ready to start the CMB session.
    else if not UserChangedInputFilesOnTheFly then
      begin                      // Nothing's changed; proceed thru the session.
        Application.ProcessMessages;
        StartSession;
        Application.ProcessMessages;
        AllowChange       := True;
        FFirstTimeRunning := false;    // Subsequently, it's NOT the first pass;
                                       // this is the only place FTR is cancelled.
      end
   // else check UserChangedInputFilesOnTheFly to see if a new session
   // automatically triggered because one of more input files has changed.
   // (again, regardless of whether a calculation has ben made);
   // This is a subsequent pass in which a new session IS possible.
      else              // User must have changed one or mre files on the fly...
        if (MessageDlg(
        'You are running without a Control File and one or more input files have changed this session.'
        + #10 + 'Do you want to start a new CMB session?'
        + #10#13#13
        + '(This will purge any previous results and reload with new input files; NO = cancel.)?',
        mtConfirmation,
        [mbYes, mbNo], 0) = mrYes) then
        begin
          Application.ProcessMessages;
          StartSession;
          Application.ProcessMessages;
          AllowChange := True;
        end
        else
     // Cancel; reset file names to what they were before any new selections were attempted.
        begin
          EditAmbientData.Text            := ExtractFileName(FLastADFullPathName);
          EditSourceProfiles.Text         := ExtractFileName(FLastPRFullPathName);
          EditAmbientDataSelection.Text   := ExtractFileName(FLastADSelFullPathName);
          EditSpeciesSelection.Text       := ExtractFileName(FLastSPSelFullPathName);
          EditSourceProfileSelection.Text := ExtractFileName(FLastPRSelFullPathName);

          g_ADFullPathName    := FLastADFullPathName;
          g_PRFullPathName    := FLastPRFullPathName;
          g_ADSelFullPathName := FLastADSelFullPathName;
          g_SPSelFullPathName := FLastSPSelFullPathName;
          g_PRSElFullPathName := FLastPRSelFullPathName;

     //   AllowChange := False;  // TC commented out 9/11/03; I see no reason here
                                 // to disallow change off the Input Files tab!
                                 // AllowChange works fine for NO use Control File.
                                 // In fact, if change is NOT allowed, this forces
                                 // another trip thru UserChangedInputFilesOnTheFly and
                                 // Result will be TRUE!  Thus, a sort of vicious circle ...
          AllowChange := True;
        end;
    end;
end; // END of PCMC

procedure TMainForm.StartSession;
// The main purpose of this proc is to initiate the session by shaking hands with
// proc PrepareCMB82Input & proc InitCMB82 in CMB82Internals (--> the C/Fortran dll),
// and to load any of the 3 selection files that are in use, which is essential
// to display the arrays on the Main Form.
var
  OldCursor: TCursor;
  TheWaitForm: TWaitForm;
  Line, SiteValue, DateValue, DurValue, StartValue, SizeValue, SpecieValue,
  SpecieNameValue, CommentValue, PNOValue, FieldName: string;
  CurrentSelectionFile: TextFile;
  I, J: Integer;
  RecordNumber: integer;
begin

  OldCursor := Screen.Cursor;
  TheWaitForm := TWaitForm.Create(Self);
  try
    Screen.Cursor := crHourGlass;
    begin
      TheWaitForm.Show;
      TheWaitForm.Update;

      // Reset some things:
      FSampleCount := 0;
      FSourceCount := 0;
      FSpecieCount := 0;
      FCurSpeciesFit := 'FIT1';
      FCurSourcesFit := 'FIT1';

      ClientDataSetResults.Open;
      ClientDataSetResults.EmptyDataSet;

      ClientDataSetSamples.Close;
      ClientDataSetSources.Close;
      ClientDataSetSpecies.Close;

      LoadTalkMem;

//    N.B. It seems that the following 2 calls could be made after the selection
//    files are loaded.  However, for some reason, if not called here, the following
//    3 selection-loading sections fail. -tc
      PrepareCMB82Input;                                               // Task 2
//    InitCMB82 initializes g_ADCode and the DLL reads the file and populates it! JS 07.21.2004
      InitCMB82;                                                       // Task 3

//    TC: Control comes here initially to get decimals displayed value.  Without
//    the following two lines the INITIAL values displayed in the Main Report
//    are truncated (no values beyond the decimals):

      g_DisplayDecimalPlaces := StrToInt(MaskEditDecimals.Text);
      SetDisplayDecimals; // Task 4

      CreateSamplesDataset;
      // CreateSamplesDataset is IRRESPECTIVE of any sample selection !
      // 1st sample in the AD* data file is queued.
      CreateSourcesDataset;

      GetCurSam;
      GetCurSrc;
      GetSpecies;

      ClientDataSetSpecies.Open;
      ClientDataSetSpecies.First;

      ClientDataSetCurSam.Open;
      ClientDataSetCurSrc.Open;

      //
      // RW 2000-07-21 -- Now we may have too many rows in the samples or
      // sources tables; if either of them contain rows that aren't in the
      // corresponding selection files (for example g_ADCode), then we remove them.
      // Species is already based on g_SPCodeUser.  We need to delete rows from
      // the samples table that are not matched in g_ADCode and from the sources
      // table that are not matched in g_PRCodeUser.
      PruneSamples;
      PruneSources;

//    Load Ambient Data SELection file if it has been selected.
      if FileExists(g_ADSelFullPathName) then // Check against full path
      begin
        AssignFile(CurrentSelectionFile, g_ADSelFullPathName); // Use full path.
        Reset(CurrentSelectionFile);

        // RW 2000-07-21 -- ignore unmatched lines in the data selection file.
        while not EoF(CurrentSelectionFile) do
        begin
          ReadLn(CurrentSelectionFile, Line);

          // Extract the 5 factors that identify the sample:
          SiteValue  := Trim(Copy(Line,  1,12));
          DateValue  := Trim(Copy(Line, 14, 8));
          DurValue   := Trim(Copy(Line, 23, 2)); // TC added 6/24/05
          StartValue := Trim(Copy(Line, 26, 2)); // TC added 6/24/05
          SizeValue  := Trim(Copy(Line, 29, 6)); // Size field is now 6 chars; 10/2004 !!

          // Try to find the matching row in the samples table.
          if ClientDataSetSamples.Locate(
            'SITE;DATE;DUR;START;SIZE',
            VarArrayOf([SiteValue, DateValue, DurValue, StartValue, SizeValue]),
            []) then
          begin
            // Check if there is an asterisk in the string in column 36.
            // Since size field 5-> 6, * are moved to Column 36 (vs. 35 as in CMB8.0).
            if Copy(Line, 36, 1) = '*' then
            begin
              // Mark the record as selected.
              with ClientDataSetSamples do
              begin
                Edit;
                FieldByName('SELECTED').Text := '*';
                Post;
              end;
            end;
          end;
        end;
        CloseFile(CurrentSelectionFile);
        ClientDataSetSamples.First;
      end;

//    JS 08/06/04 - Create a hidden RecordNumber field.  This is needed so that
//    'View All' and 'View Selected' samples works and maps to the RecordNumbers
//    correctly.  This is partially needed because the Apollo database of yore
//    (PES) counts records differently than the TClientDataset memory table,
//    which is currently used.
//
//    We renumber RecordNumber here, so that there are no gaps, because the pruning
//    above will remove some records and leave incorrect RecordNumbers - numbers
//    that may be so large that we'll read past the buffer and hopefully in nice case
//    a nasty exception thrown.  In worst case, we'll crash the machine eventually or
//    weird stuff may happen (worst case, that is.)
//
      RecordNumber := 0;
      ClientDataSetSamples.First;          // Make sure we are the first record.

//    Loop through all records in the dataset until we are at the end.
//    For each record, put it in edit mode, and put a RecordNumber (a simple
//    counter) in there; then save the record.  Again, this collapses the 'gaps'
//    and yields correct numbers.
//
      while (not ClientDatasetSamples.Eof) do
      begin
        ClientDataSetSamples.Edit;
        ClientDataSetSamples.FieldByName('_RECORD_NUMBER_').AsInteger := RecordNumber;
        ClientDataSetSamples.Post;
        ClientDataSetSamples.Next;
        inc(RecordNumber);
      end;

//    Load SPecies SELection file if it was listed in the Control File.
      if FileExists(g_SPSelFullPathName) then // Check against full path
      begin
        AssignFile(CurrentSelectionFile, g_SPSelFullPathName); // Use full path
        Reset(CurrentSelectionFile);

        // RW 2000-07-21 -- since SP*.sel file may include completely unselected
        // species that are not in g_SPCodeUser and therefore aren't in
        // ClientDataSetSpecies, we simply ignore all unmatched lines from the
        // selection file.
        while not EoF(CurrentSelectionFile) do
        begin
          ReadLn(CurrentSelectionFile, Line);
          SpecieValue := Trim(Copy(Line, 1, 6));
          if ClientDataSetSpecies.Locate('SPECIE', SpecieValue, []) then
          begin
            ClientDataSetSpecies.Edit;
            SpecieNameValue := Trim(Copy(Line, 9, 8));
            ClientDataSetSpecies.FieldByName('SPECIENAME').Text
              := SpecieNameValue;
            // Loop through all the fits.
            for I := 1 to 10 do
            begin
              J := 17 + (2 * I);
              if Copy(Line, J, 1) = '*' then
              begin
                FieldName := 'FIT' + IntToStr(I);
                ClientDataSetSpecies.FieldByName(FieldName).Text := '*';
              end;
            end;
            CommentValue := Trim(Copy(Line, 39, 200));
            ClientDataSetSpecies.FieldByName('COMMENT').Text := CommentValue;
            ClientDataSetSpecies.Post;
          end;
        end;
        CloseFile(CurrentSelectionFile);
        ClientDataSetSpecies.First;
      end;

//    Load source PRofile SELection file if it was listed in the Control File.
      if FileExists(g_PRSelFullPathName) then      // Check against full path...
      begin
        AssignFile(CurrentSelectionFile, g_PRSelFullPathName);  // Use full path
        Reset(CurrentSelectionFile);

        // RW 2000-07-21 -- ignore unmatched lines in the profile selection
        // file.
        while not EoF(CurrentSelectionFile) do
        begin
          ReadLn(CurrentSelectionFile, Line);

          // Try to find the matching row in the sources table.
          // RW 2000-08-23 -- the DRI version (CMB8.0) apparently uses only the profile
          // number as a key, so just match on the first field.
          PNOValue := Trim(Copy(Line, 1, 6));
          if ClientDataSetSources.Locate('PNO', PNOValue, []) then
          begin
            ClientDataSetSources.Edit;
            for I := 1 to 10 do
            begin
              J := 17 + (2 * I);
              if Copy(Line, J, 1) = '*' then
              begin
                FieldName := 'FIT' + IntToStr(I);
                ClientDataSetSources.FieldByName(FieldName).Text := '*';
              end;
            end;
            CommentValue := Trim(Copy(Line, 39, 200));
            ClientDataSetSources.FieldByName('COMMENT').Text := CommentValue;
            ClientDataSetSources.Post;
          end;
        end;
        CloseFile(CurrentSelectionFile);
        ClientDataSetSources.First;
      end;

      DBGridSpecies.Columns[2].Color := clInfoBk;
      DBGridSources.Columns[3].Color := clInfoBk;
      DBGridSpecies.Columns[2].Font.Color := clInfoText;
      DBGridSources.Columns[3].Font.Color := clInfoText;

      // Force the remaining fitting columns to reset to a white background when
      // starting a session.
      for I := 2 to 10 do
      begin
        DBGridSpecies.Columns[I + 1].Color := clWhite;
        DBGridSources.Columns[I + 2].Color := clWhite;
      end;

      GetSampleCount;
      GetSpecieCount;
      GetSourceCount;

      ShowSampleCount;
      ShowSpecieCount;
      ShowSourceCount;
    end;
  finally
    FreeAndNil(TheWaitForm);
    Screen.Cursor := OldCursor;
  end;
end; // end StartSession

function TMainForm.UserChangedInputFilesOnTheFly: Boolean;
// RFA removed this block from PageControlMainChanging and built as a function in 'C' (09-03-02).
// TC modified 09/11/03 to accomodate NO use Control File.
// Check to see if what's in the input textboxes still matches the global input filenames.
begin // Start checking for changes that will trigger a new session.
  Result := False;
  IF FUseControlFile then
    begin

  // 1/5 - Ambient Data         (AD*)
  // 2/5 - Source PRofiles Data (PR*)
  // If a control File is loaded, these required data input files are QC's in
  // respective SpeedButton*Click procs.

  // For the SELection files, since they must come from the same 'Control Folder',
  // a simple check on the file name (no path) is sufficient. - tc
  // We assume this check is reliable even if both strings are null.
  // If there is a change, set flag and load the new selection file(s).

  // 3/5 - Ambient Data SELection
    if not SameText(EditAmbientDataSelection.Text, // new file name just picked up in SBAmbientDataSelectionClick
                               FLastADSelFileName) then
    begin // update the global full-path filename
      FLastADSelFileName := EditAmbientDataSelection.Text;// Filename memory updated
      Result := True;
    end;
  // 4/5 - Species SELection
    if not SameText(EditSpeciesSelection.Text, // new file name just picked up in SBSpeciesSelectionClick
                           FLastSPSelFileName) then
    begin // update the global full-path filename and memory
      FLastSPSelFileName := EditSpeciesSelection.Text;// Filename memory updated
      Result := True;
    end;
  // 5/5 - Source Profiles SELection
    if not SameText(EditSourceProfileSelection.Text, // new file name just picked up in SBSourceProfileSelectionClick
                                 FLastPRSelFileName) then
    begin // update the global full-path filename
      FLastPRSelFileName := EditSourceProfileSelection.Text;// Filename memory updated
      Result := True;
    end;
  end
  ELSE // Flying without a Control File here ...
       // Full Path file name memories are initialized in respective SB*Clicks
       // so as not to trigger a difference detection on the first pass.
  begin

// 1/5 - Ambient Data
  if not SameText((g_ADFullPathName), FLastADFullPathName) then
    begin
      FLastADFullPathName := g_ADFullPathName;       // Update file name memory.
      Result := True;                                        // Flag the change.
    end;

// 2/5 - Source PRofiles Data
  if not SameText((g_PRFullPathName), FLastPRFullPathName) then
    begin
      FLastPRFullPathName := g_PRFullPathName;       // Udpate file name memory.
      Result := True;                                        // Flag the change.
    end;

// 3/5 - Ambient Data SELection
    if not SameText(g_ADSelFullPathName, FLastADSelFullPathName) then
    begin
      FLastADSelFullPathName := g_ADSelFullPathName; // Udpate file name memory.
      Result := True;                                        // Flag the change.
    end;

  // 4/5 - Species SELection
    if not SameText(g_SPSelFullPathName, FLastSPSelFullPathName) then
    begin
      FLastSPSelFullPathName := g_SPSelFullPathName; // Udpate file name memory.
      Result := True;                                        // Flag the change.
    end;

  // 5/5 - Source Profiles SELection
    if not SameText(g_PRSelFullPathName, FLastPRSelFullPathName) then
    begin
      FLastPRSelFullPathName := g_PRSelFullPathName; // Udpate file name memory.
      Result := True;                                        // Flag the change.
    end;
  end;
end;

procedure TMainForm.SpeedButtonPrintClick(Sender: TObject);
var
  OldCursor: TCursor;
  PrintDlg: TPrintOptionsForm;
begin
  PrintDlg := nil;
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    with PageControlMain do
    begin
      if ((ActivePage = TabSheetSamples) and (DBChartSamples.Visible))
        or ((ActivePage = TabSheetSources) and (DBChartSources.Visible)) then
      begin
        if PrinterSetupDialog.Execute then
        begin
          if (ActivePage = TabSheetSamples) and (DBChartSamples.Visible) then
          begin
            DBChartSamples.PrintMargins := Rect(5, 5, 5, 5);
            DBChartSamples.Title.Text.Clear;
            DBChartSamples.Title.Text.Add(
              'Ambient Data Sample - '
              + ClientDataSetSamples.FieldByName('SITE').Text
              + ' '
              + ClientDataSetSamples.FieldByName('DATE').Text);
            DBChartSamples.Title.Visible := True;
            DBChartSamples.PrintLandscape;
            DBChartSamples.Title.Visible := False;
          end
          else if (ActivePage = TabSheetSources)
            and (DBChartSources.Visible) then
          begin
            DBChartSources.PrintMargins := Rect(5, 5, 5, 5);
            DBChartSources.Title.Text.Clear;
            DBChartSources.Title.Text.Add(
              'Source Profile - '
              + ClientDataSetSources.FieldByName('PNO').Text
              + ' '
              + ClientDataSetSources.FieldByName('SID').Text);
            DBChartSources.Title.Visible := True;
            DBChartSources.PrintLandscape;
            DBChartSources.Title.Visible := False;
          end;
        end;
      end
      else if ActivePage = TabSheetResults then
      begin
        // Create a dialog in memory - not showing yet.
        PrintDlg := TPrintOptionsForm.Create(self);
        if ClientDataSetResults.RecordCount > 1 then // DO form that shows Print Range
          PrintDlg.PrintMode := kPrintRangeOfRecords // = 0
        else // There's only one result in the queue; only prompt for PrintToFile
          PrintDlg.PrintMode := kPrintOnly1Record;   // = 1

        // Show dialog to the user.
        if (PrintDlg.ShowModal = mrok) then // OK
        begin
          PrintDlg.PrintControl;
        end
        else
        begin;
           // Cancelled
        end;
      end;
    end; // With
  finally
    FreeAndNil(PrintDlg); // free this object
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonResetToDefaultClick(Sender: TObject);
begin
  MaskEditIteration.Text             := '20';
  MaskEditUncertainty.Text           := '20';
  MaskEditProjection.Text            := '0.95';
  MaskEditDecimals.Text              := '5';
  ComboBoxUnits.Text                 := 'g/m';
  ComboBoxOutputFileFormat.ItemIndex := 0; // added 092603 -TC
  MaskEditChiSquare.Text             := '1.000';
  MaskEditRSquare.Text               := '1.000';
  MaskEditPercentMass.Text           := '1.000';
  MaskEditFraction.Text              := '1.000';
  CheckBoxBritt.Checked              := False;
  CheckBoxSource.Checked             := False;
  CheckBoxBestFit.Checked            := False;
end;

procedure TMainForm.SpeedButtonRunClick(Sender: TObject);
begin
  g_BestFitFlag := False;
  SetMeasurementType(ComboBoxUnits.Text); // Task 10
  if CheckBoxBestFit.Checked then
    BestFit
  else
  begin
    // Added 10/30/2004 - so we can shut down completely.
    // Changed signature of RunCMB to be a function so that we can shutdown (using Delphi's
    // standard Close() method) if RunCMB returned false; this should only happen if we bail.
    if RunCMB = false then // we are bailing ...
    begin
      Close;  // Sends message to application to shutdown.
              // Not if there is FormCloseQuery() implemented, this will stop it.
    end;
  end;
end;

procedure TMainForm.SpeedButtonSamplesGraphClick(Sender: TObject);
var
  OldCursor: TCursor;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    if SpeedButtonSamplesGraph.Caption = 'View Grid' then
    begin
      PanelSamples.Caption := 'AMBIENT DATA SAMPLES';
      DBGridSamples.Show;
      DBChartSamples.Hide;
      SpeedButtonSamplesGraph.Caption := 'View Graph';
      SpeedButtonSelectAllSamples.Enabled := True;
      SpeedButtonClearAllSamples.Enabled := True;
      SpeedButtonSamplesViewAll.Enabled := True;
      SpeedButtonSamplesShowData.Enabled := True;
      MenuItemFilePrint.Enabled := False;
      SpeedButtonPrint.Enabled := False;
      DBGridSamples.SetFocus;
    end
    else
    begin
      PanelSamples.Caption
        := 'AMBIENT DATA SAMPLE - '
        + ClientDataSetSamples.FieldByName('SITE').Text
        + ' '
        + ClientDataSetSamples.FieldByName('DATE').Text;
      SpeedButtonSamplesGraph.Caption := 'View Grid';
      DBGridSamples.Hide;
      SpeedButtonSelectAllSamples.Enabled := False;
      SpeedButtonClearAllSamples.Enabled := False;
      SpeedButtonSamplesViewAll.Enabled := False;
      SpeedButtonSamplesShowData.Enabled := False;
      MenuItemFilePrint.Enabled := True;
      SpeedButtonPrint.Enabled := True;
      GetBarValue1;
      DBChartSamples.Show;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSamplesShowDataClick(Sender: TObject);
var
  I: Integer;
begin
  if SpeedButtonSamplesShowData.Caption = 'Show Data' then
  begin
    SpeedButtonSamplesShowData.Caption := 'Hide Data';
    // The "- 2" is so we don't ever show the _RECORD_NUMBER_ field: it's only
    // reason for being is to keep the client data set records in the same order
    // they were read from the file.
    for I := 6 to ClientDataSetSamples.FieldCount - 2 do
      ClientDataSetSamples.Fields[I].Visible := True;
  end
  else
  begin
    SpeedButtonSamplesShowData.Caption := 'Show Data';
    // The "- 2" is so we don't ever show the _RECORD_NUMBER_ field: it's only
    // reason for being is to keep the client data set records in the same order
    // they were read from the file.
    for I := 6 to ClientDataSetSamples.FieldCount - 2 do
      ClientDataSetSamples.Fields[I].Visible := False;
  end;
end;

procedure TMainForm.SpeedButtonSaveClick(Sender: TObject);
var
  OldCursor: TCursor;
  SaveResultsDlg: TSaveResultsForm;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    if PageControlMain.ActivePage = TabSheetInputFiles then
    begin
      SaveDialogSelection.DefaultExt := 'in8';
      SaveDialogSelection.FileName := EditControlFile.Text;
      SaveDialogSelection.Filter
        := 'EPA-CMB8.2 Control File (IN*.in8)|IN*.in8|All Files (*.*)|*.*';
      if SaveDialogControl.Execute then
      begin
        SaveInputToIN8File(SaveDialogControl.FileName);
        FCurrentControlFile := SaveDialogControl.FileName;            // TC added 08/27/04
        FLastControlFile := FCurrentControlFile; // Try this ???
        EditControlFile.Text := ExtractFileName(FCurrentControlFile); // If Control Files is changed during a session,
                                                                      // we update Edit Conrtrol box & dashboard
        FSaveIn8 := False;
      end;
    end
    else if PageControlMain.ActivePage = Self.TabSheetOptions then
    begin
      Assert(False); // This should never happen.
    end
    else if PageControlMain.ActivePage = TabSheetSamples then
    begin
      SaveDialogSelection.DefaultExt := 'sel';
      SaveDialogSelection.FileName := EditAmbientDataSelection.Text;
      SaveDialogSelection.Filter
        := 'Ambient Data Selection (AD*.sel)|AD*.sel|All Files (*.*)|*.*';
      if SaveDialogSelection.Execute then
      begin
        SaveSamplesToTextFile(SaveDialogSelection.FileName);
        FSaveSamples := False;
      end;
    end
    else if PageControlMain.ActivePage = TabSheetSpecies then
    begin
      SaveDialogSelection.DefaultExt := 'sel';
      SaveDialogSelection.FileName := EditSpeciesSelection.Text;
      SaveDialogSelection.Filter
        := 'Species Selection (SP*.sel)|SP*.sel|All Files (*.*)|*.*';
      if SaveDialogSelection.Execute then
      begin
        SaveSpeciesToTextFile(SaveDialogSelection.FileName);
        FSaveSpecies := False;
      end;
    end
    else if PageControlMain.ActivePage = TabSheetSources then
    begin
      SaveDialogSelection.DefaultExt := 'sel';
      SaveDialogSelection.FileName := EditSourceProfileSelection.Text;
      SaveDialogSelection.Filter
        := 'Source Profile Selection (PR*.sel)|PR*.sel|All Files (*.*)|*.*';
      if SaveDialogSelection.Execute then
      begin
        SaveSourcesToTextFile(SaveDialogSelection.FileName);
        FSaveSources := False;
      end;
    end
    else if PageControlMain.ActivePage = Self.TabSheetResults then
    begin
    // Allow saving current or all queued results IF > 1 result's in the queue.
      SaveResultsDlg := TSaveResultsForm.Create(Self);
      try
        SaveResultsDlg.SaveSomeControl; // in SaveResultsForm
      finally
        FreeAndNil(SaveResultsDlg);     // free this object
      end;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSelectAllSamplesClick(Sender: TObject);
var
  OldCursor: TCursor;
  FilterState: Boolean;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    FSaveSamples := True;
    with ClientDataSetSamples do
    begin
      DisableControls;
      FilterState := Filtered;
      Filtered := False;
      First;
      while not EoF do
      begin
        Edit;
        if Sender = SpeedButtonClearAllSamples then
        begin
          FieldByName('SELECTED').Text := '';
          UpdateADCode(' '); // Call III to Task 7
        end
        else
        begin
          FieldByName('SELECTED').Text := '*';
          UpdateADCode('*'); // Call IV to Task 7
        end;
        Post;
        Next;
      end;
      if Sender = SpeedButtonClearAllSamples then
        FSampleCount := 0
      else
        FSampleCount := RecordCount;
      First;
      Filtered := FilterState;
      EnableControls;
    end;
    ShowSampleCount;
    SpeedButtonRun.Enabled := True;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSelectAllSourcesClick(Sender: TObject);
var
  OldCursor: TCursor;
  ColumnIndex: Integer;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    FSaveSources := True;
    with ClientDataSetSources do
    begin
      DisableControls;
      ColumnIndex := StrToInt(Copy(FCurSourcesFit, 4, 2)) + 2;
      First;
      while not EoF do
      begin
        Edit;
        if Sender = SpeedButtonClearAllSources then
        begin
          DBGridSources.Columns[ColumnIndex].Field.Text := '';
          UpdatePRCodeUser(' ');
          FSourceCount := 0;
        end
        else
        begin
          DBGridSources.Columns[ColumnIndex].Field.Text := '*';
          UpdatePRCodeUser('*');
          FSourceCount := RecordCount;
        end;
        Post;
        Next;
      end;
      First;
      EnableControls;
    end;
    ShowSourceCount;
    SpeedButtonRun.Enabled := True;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSelectAllSpeciesClick(Sender: TObject);
var
  OldCursor: TCursor;
  ColumnIndex: Integer;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    FSaveSpecies := True;
    with ClientDataSetSpecies do
    begin
      DisableControls;
      ColumnIndex := StrToInt(Copy(FCurSpeciesFit, 4, 2)) + 1;
      First;
      while not EoF do
      begin
        Edit;
        if Sender = SpeedButtonClearAllSpecies then
        begin
          DBGridSpecies.Columns[ColumnIndex].Field.Text := '';
          FSpecieCount := 0;
          UpdateSPCodeUser(' ');
        end
        else
        begin
          DBGridSpecies.Columns[ColumnIndex].Field.Text := '*';
          FSpecieCount := RecordCount;
          UpdateSPCodeUser('*');
        end;
        Post;
        Next;
      end;
      First;
      EnableControls;
    end;
    ShowSpecieCount;
    SpeedButtonRun.Enabled := True;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonAmbientDataClick(Sender: TObject);
begin
  with OpenDialogAmbientData do
  begin
    FileName := '';
    InitialDir := ExtractFilePath(FCurrentControlFile); // This sets the initial directory when the Edit Control Dialog box appears.
    if Execute then
    begin
      // If a Control File has been loaded, don't allow the user to select a file
      // from a different directory.  This can easily be changed.
      IF FUseControlFile then
      Begin
        if (FCurrentControlFolder <> ExtractFilePath(FileName)) then
        begin
          Beep;
          ShowMessage('You cannot select an input file outside of the folder containing the current Control File.');
          Exit;
        end
        else
     // If a Control File has been loaded and then individual input files subsequently
     // changed, erase the name of the Control File from the DialogBox.
        if not SameText(ExtractFileName(FileName),    // new file name just picked up
                                 FLastADFileName) then
          if SameText(ChangeFileExt(ExtractFileName(FileName), ''),
                      ChangeFileExt(FLastADFileName, '')) then
            begin        // Only the format's different; load the new data file:
              EditAmbientData.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
              FLastADFileName      := ExtractFileName(FileName); // Update memory2.
              g_ADFullPathName     := FileName                   // Reset Full Path.
            end
        else
        begin                  // AD file is incompatible with Control File loaded
          MessageDlg(
            'The Ambient Data (AD*) input file you selected is possibly' + #10
            + 'incompatible with the PR* file directed by your Control file;'
            + #10 + 'browse to select another one.',
            mtInformation,
            [mbOK],
            0);
          EditAmbientData.Text := '';
          EditAmbientData.SetFocus; // Flashes cursor on AD input field in dialog.
        end;
      // If a Control File has NOT been loaded, set the current directory.
      // This is critical for reading this file in TMainForm.CreateSamplesDataset.
      End
      ELSE
        begin
          SetCurrentDirectory(PChar(ExtractFilePath(FileName)));
          EditAmbientData.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
          g_ADFullPathName := FileName;                      // Initialize full path file name when flying w/o Control File.
          if FFirstTimeRunning then
             FLastADFullPathName := Filename; // Update memory only on the 1st pass so as not to trigger diff. detection.
        end;
    end;
  end;
end;

procedure TMainForm.SpeedButtonSourceProfileClick(Sender: TObject);
begin
  with OpenDialogSourceProfile do
  begin
    FileName := '';
    InitialDir := ExtractFilePath(FCurrentControlFile);  // This sets the initial directory that appears when the Edit Control Dialog box appears.
    if Execute then
    begin
      // If a Control File has been loaded, don't allow the user to select a file
      // from a different directory.  This can easily be changed.
      IF FUseControlFile then
      Begin
        if (FCurrentControlFolder <> ExtractFilePath(FileName)) then
        begin
          Beep;
          ShowMessage('You cannot select an input file outside of the folder containing the current Control File.');
          Exit;
        end
        else
     // If a Control File has been loaded and then individual input files subsequently
     // changed, erase the name of the Control File from the Dialog box.
        if not SameText(ExtractFileName(FileName),   // new file name just picked up
                                 FLastPRFileName) then
          if SameText(ChangeFileExt(ExtractFileName(FileName), ''),
                      ChangeFileExt(FLastPRFileName, '')) then
            begin        // Only the format's different; load the new data file:
              EditSourceProfiles.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
              FLastPRFileName            := ExtractFileName(FileName); // Update memory2.
              g_PRFullPathName           := FileName                   // Reset Full Path.
            end
        else
        begin                // PR file is incompatible with Control File loaded
          MessageDlg(
            'The Source Profile (PR*) input file you selected is possibly' + #10
            + 'incompatible with the AD* file directed by your Control file;'
            + #10 + 'browse to select another one.',
            mtInformation,
            [mbOK],
            0);
          EditSourceProfiles.Text := '';
          EditSourceProfiles.SetFocus; // Flashes cursor on AD input field in dialog.
        end;
      End
      ELSE
        begin
          SetCurrentDirectory(PChar(ExtractFilePath(FileName)));
          EditSourceProfiles.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
          g_PRFullPathName           := FileName;               // Initialize full path file name when flying w/o Control File.
          if FFirstTimeRunning then
             FLastPRFullPathName := Filename; // Update memory only on the 1st pass so as not to trigger diff. detection.
        end;
    end;
  end;
end;

procedure TMainForm.SpeedButtonAmbientDataSelectionClick(Sender: TObject);
// This proc is invoked whenever the ambient data selection file browse box is clicked.
begin
  with OpenDialogAmbientDataSelection do
  begin
    FileName := 'AD*.sel';
    InitialDir := ExtractFilePath(FCurrentControlFile);  // This sets the initial directory when the Edit Control Dialog box appears.
    if Execute then
    begin
      // If a Control File has been loaded, don't allow the user to select a file
      // from a different directory.  This can easily be changed.
      IF FUseControlFile then
      Begin
        if (FCurrentControlFolder <> ExtractFilePath(FileName)) then
        begin
          Beep;
          ShowMessage('You cannot select an input file outside of the folder containing the current Control File.');
          Exit;
        end
        else
     // If a Control File has been loaded and then individual input files subsequently changed,
     // erase the name of the Control File from the Dialog box.
     // Remember last file name for use in UserChangedInputFilesOnTheFly.
        if (not SameText(                  // Of the 2,
          FLastADSelFilename,              // this one's the previous file name
          ExtractFileName(FileName))) then // (Full Path) FileName was just picked up
          if FuseControlFile then
            begin
              EditControlFile.Text := '';                                 // Clear Control File name.
              EditAmbientDataSelection.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
              g_ADSelFullPathName := FileName;                            // FileName is Full Path.
            end;
      End
      ELSE                                             // NOT using Control File
        begin
          EditAmbientDataSelection.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
          g_ADSelFullPathName := FileName;                            // FileName is Full Path.
          if FFirstTimeRunning then
             FLastADSelFullPathName := Filename; // Update memory only on the 1st pass so as not to trigger diff. detection.
        end;
    end;
  end;
end;

procedure TMainForm.SpeedButtonSpeciesSelectionClick(Sender: TObject);
// This proc is invoked whenever the species selection file browse box is clicked.
begin
  with OpenDialogSpeciesSelection do
  begin
    FileName := 'SP*.sel';
    InitialDir := ExtractFilePath(FCurrentControlFile);  // This sets the initial directory that appears when the Edit Control Dialog box appears.
    if Execute then
    begin
      // If a Control File has been loaded, don't allow the user to select a file
      // from a different directory.  This can easily be changed.
      IF FUseControlFile then
      Begin
        if (FCurrentControlFolder <> ExtractFilePath(FileName)) then
        begin
          Beep;
          ShowMessage('You cannot select an input file outside of the folder containing the current Control File.');
          Exit;
        end
        else
     // If a Control File has been loaded and then individual input files subsequently
     // changed, erase the name of the Control File from the Dialog box.
     // Remember last file name for use in UserChangedInputFilesOnTheFly.
        if (not SameText(                  // Of the 2,
          FLastSPSelFileName,              // this one's the previous file name
          ExtractFileName(FileName))) then // (Full Path) FileName was just picked up
          if FUseControlFile then
            begin
              EditControlFile.Text := '';                             // Clear Control File name.
              EditSpeciesSelection.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
              g_SPSelFullPathName := FileName;                        // FileName is Full Path.
            end;
      End
      ELSE                                             // NOT using Control File
        begin
          EditSpeciesSelection.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
          g_SPSelFullPathName := FileName;                        // FileName is Full Path.
          if FFirstTimeRunning then
             FLastSPSelFullPathName := Filename; // Update memory only on the 1st pass so as not to trigger diff. detection.
        end;
    end;
  end;
end;

procedure TMainForm.SpeedButtonSourceProfileSelectionClick(Sender: TObject);
// This proc is invoked whenever the source profiles selection file browse box is clicked.
begin
  with OpenDialogSourceProfileSelection do
  begin
    FileName := 'PR*.sel';
    InitialDir := ExtractFilePath(FCurrentControlFile);  // This sets the initial directory that appears when the Edit Control Dialog box appears.
    if Execute then
    begin
      // If a Control File has been loaded, don't allow the user to select a file from
      // a different directory.  This can easily be changed.
      IF FUseControlFile then
      Begin
        if (FCurrentControlFolder <> ExtractFilePath(FileName)) then
        begin
          Beep;
          ShowMessage('You cannot select an input file outside of the folder containing the current Control File.');
          Exit;
        end
        else
     // If a Control File has been loaded and then individual input files subsequently changed,
     // erase the name of the Control File from the Dialog box.
     // Remember last file name for use in UserChangedInputFilesOnTheFly.
        if (not SameText(                  // Of the 2,
          FLastPRSelFileName,              // this one's the previous file name
          ExtractFileName(FileName))) then // (Full Path) FileName was just picked up
          if FUseControlFile then
            begin
              EditControlFile.Text := '';                                   // Clear Control File name.
              EditSourceProfileSelection.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
              g_PRSelFullPathName := FileName;                              // FileName is Full Path.
            end;
      End
      ELSE                                             // NOT using Control File
        begin
          EditSourceProfileSelection.Text := ExtractFileName(FileName); // Re-populate Edit Control box.
          g_PRSelFullPathName := FileName;                              // FileName is Full Path.
          if FFirstTimeRunning then
             FLastPRSelFullPathName := Filename; // Update memory only on the 1st pass so as not to trigger diff. detection.
        end;
    end;
  end;
end;

procedure TMainForm.SpeedButtonSourcesGraphClick(Sender: TObject);
var
  OldCursor: TCursor;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    if SpeedButtonSourcesGraph.Caption = 'View Grid' then
    begin
      PanelSources.Caption
        := '                                            SOURCES FITTING ARRAY';
      DBGridSources.Show;
      DBChartSources.Hide;
      SpeedButtonSourcesGraph.Caption := 'View Graph';
      SpeedButtonSelectAllSources.Enabled := True;
      SpeedButtonClearAllSources.Enabled := True;
      SpeedButtonSourcesViewAll.Enabled := True;
      SpeedButtonSourcesShowData.Enabled := True;
      MenuItemFilePrint.Enabled := False;
      SpeedButtonPrint.Enabled := False;
      DBGridSources.SetFocus;
    end
    else
    begin
      PanelSources.Alignment := taCenter;
      PanelSources.Caption
        := 'PROFILE - '
        + ClientDataSetSources.FieldByName('PNO').Text
        + ' '
        + ClientDataSetSources.FieldByName('SID').Text;
      SpeedButtonSourcesGraph.Caption := 'View Grid';
      DBGridSources.Hide;
      SpeedButtonSelectAllSources.Enabled := False;
      SpeedButtonClearAllSources.Enabled := False;
      SpeedButtonSourcesViewAll.Enabled := False;
      SpeedButtonSourcesShowData.Enabled := False;
      MenuItemFilePrint.Enabled := True;
      SpeedButtonPrint.Enabled := True;
      GetBarValue2;
      DBChartSources.Show;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSourcesShowDataClick(Sender: TObject);
var
  OldCursor: TCursor;
  I: Integer;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    DataSourceSources.DataSet := ClientDataSetSources;
    for I := 0 to DBGridSources.FieldCount - 1 do
      if SameText(
        Copy(DBGridSources.Columns[I].FieldName, 1, 5),
        FCurSourcesFit) then
      begin
        DBGridSources.Columns[I].Color      := clInfoBk;
        DBGridSources.Columns[I].Font.Color := clInfoText;
      end;

    if SpeedButtonSourcesShowData.Caption = 'Show Data' then
    begin
      SpeedButtonSourcesShowData.Caption := 'Hide Data';
      for I := 14 to ClientDataSetSources.FieldCount - 1 do
        ClientDataSetSources.Fields[I].Visible := True;
    end
    else
    begin
      SpeedButtonSourcesShowData.Caption := 'Show Data';
      for I := 14 to ClientDataSetSources.FieldCount - 1 do
        ClientDataSetSources.Fields[I].Visible := False;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSamplesViewAllClick(Sender: TObject);
var
  OldCursor: TCursor;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    if ClientDataSetSamples.Filtered then
    begin
      SpeedButtonSamplesViewAll.Caption := 'View Selected';
      ClientDataSetSamples.Filtered := False;
    end
    else
    begin
      SpeedButtonSamplesViewAll.Caption := 'View All';
      ClientDataSetSamples.Filtered := True;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSourcesViewAllClick(Sender: TObject);
var
  OldCursor: TCursor;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    if SpeedButtonSourcesViewAll.Caption = 'View All' then
    begin
      SpeedButtonSourcesViewAll.Caption := 'View Selected';
      ClientDataSetSources.Filtered := False;
    end
    else
    begin
      SpeedButtonSourcesViewAll.Caption := 'View All';
      ClientDataSetSources.Filtered := True;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

procedure TMainForm.SpeedButtonSpeciesViewAllClick(Sender: TObject);
var
  OldCursor: TCursor;
begin
  OldCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourGlass;
    if SpeedButtonSpeciesViewAll.Caption = 'View All' then
    begin
      SpeedButtonSpeciesViewAll.Caption := 'View Selected';
      ClientDataSetSpecies.Filtered := False;
    end
    else
    begin
      SpeedButtonSpeciesViewAll.Caption := 'View All';
      ClientDataSetSpecies.Filtered := True;
    end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

// ========================================
// Custom (non-event-handling) code begins:
// ========================================

procedure TMainForm.CreateSamplesDataset;
var
  FieldNames, FieldValues: TStringList;
  TextFileName, HeaderLine, FieldName, DataLine: string;
  AmbientDataFile: TextFile;
  I, RecordNumber: Integer;
begin
  FieldNames  := nil;
  FieldValues := nil;
  try
    // Read the header from the text file, skipping over empty lines if necessary.
    TextFileName := ChangeFileExt(EditAmbientData.Text, '.txt');
    AssignFile(AmbientDataFile, TextFileName);
    Reset(AmbientDataFile);
    repeat
      ReadLn(AmbientDataFile, HeaderLine);
    until (HeaderLine <> '') or EoF(AmbientDataFile);
    Assert(HeaderLine <> '', 'The ambient sample data file is empty!');

    // Parse the header line into a list of field names.
    FieldNames := ParseStringIntoStringList(HeaderLine, ' ');

    // Sanity check.
    Assert(not ClientDataSetSamples.Active, 'The ambient sample data file is open!');

    // Start setting up the data set: the first field is always 'SELECTED'.
    ClientDataSetSamples.FieldDefs.Clear;
    ClientDataSetSamples.FieldDefs.Add('SELECTED', ftString, 1);
    for I := 0 to FieldNames.Count - 1 do
    begin
      FieldName := FieldNames[I];
      if SameText(FieldName, 'SITE') or SameText(FieldName, 'ID') then
        ClientDataSetSamples.FieldDefs.Add('SITE', ftString, 12)
      else if SameText(FieldName, 'DATE') then
        ClientDataSetSamples.FieldDefs.Add('DATE', ftString, 8)
      else if SameText(FieldName, 'DUR') then
        ClientDataSetSamples.FieldDefs.Add('DUR', ftString, 2)
      else if SameText(FieldName, 'HOUR')
        or SameText(FieldName, 'STHOUR')
        or SameText(FieldName, 'START') then
      begin
        ClientDataSetSamples.FieldDefs.Add('START', ftString, 2);
      end
      else if SameText(FieldName, 'SIZE') then
        ClientDataSetSamples.FieldDefs.Add('SIZE', ftString, 7)
      else
        ClientDataSetSamples.FieldDefs.Add(FieldName, ftFloat);
    end;
    ClientDataSetSamples.FieldDefs.Add('_RECORD_NUMBER_', ftInteger);

    // Now that the fields are all defined, create and open the data set and
    // start populating it with data.
    ClientDataSetSamples.CreateDataSet;
    ClientDataSetSamples.Open;
    RecordNumber := 0;
    while not EoF(AmbientDataFile) do
    begin
      // Read and trim a line of data.
      ReadLn(AmbientDataFile, DataLine);
      DataLine := Trim(DataLine);
      Assert(
        DataLine <> '',
        'Got an empty line of data from the ambient sample data file!');

      // Parse the data line into a list of data values.
      FieldValues := ParseStringIntoStringList(DataLine, ' ');
      Assert(
        FieldValues.Count
          = ClientDataSetSamples.FieldCount - (EXTRA_SAMPLE_FIELDS),
        'The number of data values for this sample is wrong!');

      // Add a new record and plug in the data.
      ClientDataSetSamples.Append;
      for I := 0 to FieldValues.Count - 1 do
      begin
        ClientDataSetSamples.Fields[I + 1].Text := FieldValues[I];
      end;

      // Plug a record number in the field.
      ClientDataSetSamples.FieldByName('_RECORD_NUMBER_').AsInteger := RecordNumber;
      Inc(RecordNumber);

      // Clear the value list for the next pass.
      FieldValues.Clear;
    end;
    Assert(
      ClientDataSetSamples.RecordCount > 0,
      'Didn''t get any data from the ambient sample data file!'); // 11/04/04 Are we sure what we're doing with this error trap?

    ClientDataSetSamples.First;
    ClientDataSetSamples.FieldByName('SELECTED').Alignment := taCenter;
    ClientDataSetSamples.FieldByName('_RECORD_NUMBER_').Visible := False;
    ClientDataSetSamples.IndexFieldNames := '_RECORD_NUMBER_';
  finally
    // Clean up:
    if Assigned(FieldValues) then
      FreeAndNil(FieldValues);
    if Assigned(FieldNames) then
      FreeAndNil(FieldNames);
    CloseFile(AmbientDataFile);
  end;
end;

procedure TMainForm.PruneSamples;
var
  I: Integer;
  SubString1, SubString2: string;
begin
  with ClientDataSetSamples do
  begin
    First;
    I := 0;
    SubString1 := Trim(Copy(g_ADCode, (I * lenADcode) +  1, 12));        // Site
    SubString2 := Trim(Copy(g_ADCode, (I * lenADcode) + 14,  8));        // Date
    while not EoF do
    begin
      // Match the site and date fields that are in the current row of the
      // ClientDataSetSamples row with that in the g_ADCode record string
      if (FieldByName('SITE').Text = SubString1)
        and (FieldByName('DATE').Text = SubString2) then
      begin
        Inc(I);
        SubString1 := Trim(Copy(g_ADCode, (I * lenADcode) +  1, 12));
        SubString2 := Trim(Copy(g_ADCode, (I * lenADcode) + 14,  8));
      end
      else
      begin // No match, so mark the current record/row for deletion.
        Edit;
        FieldByName('SELECTED').Text := 'D';
      end;
      Next;
    end;

    // Pack the dataset by removing all the records marked for deletion.
    // N.B.: once you pack, the records are deleted from the tables forever...
    First;
    while not EoF do
    begin
      if FieldByName('SELECTED').Text = 'D' then
        Delete
      else
        Next;
    end;
    First;
  end;
end;

procedure TMainForm.CreateSourcesDataset;
var
  FieldNames, FieldValues: TStringList;
  TextFileName, HeaderLine, FieldName, DataLine: string;
  SourceProfilesDataFile: TextFile;
  I: Integer;
begin
  FieldNames := nil;
  FieldValues := nil;
  try
    // Read the header from the text file, skipping over empty lines if necessary.
    TextFileName := ChangeFileExt(EditSourceProfiles.Text, '.txt');
    AssignFile(SourceProfilesDataFile, TextFileName);
    Reset(SourceProfilesDataFile);
    repeat
      ReadLn(SourceProfilesDataFile, HeaderLine);
    until (HeaderLine <> '') or EoF(SourceProfilesDataFile);
    Assert(HeaderLine <> '', 'The source profiles data file is empty!');

    // Delete everything from the header up to and including 'SIZE'.
    Assert(Pos('SIZE ', HeaderLine) > 0, 'Invalid header: SIZE is missing!');
    Delete(HeaderLine, 1, Pos('SIZE ', HeaderLine) + Length('SIZE'));

    // Parse the header line into a list of field names.
    FieldNames := ParseStringIntoStringList(HeaderLine, ' ');

    // Sanity check.
    Assert(not ClientDataSetSources.Active, 'The source profiles data file is open!');

    // Start setting up the data set: the first 14 fields are always as shown.
    ClientDataSetSources.FieldDefs.Clear;
    ClientDataSetSources.FieldDefs.Add('PNO', ftString, 6);
    ClientDataSetSources.FieldDefs.Add('SID', ftString, 8);
    ClientDataSetSources.FieldDefs.Add('SIZE', ftString, 5);
    ClientDataSetSources.FieldDefs.Add('FIT1', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT2', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT3', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT4', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT5', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT6', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT7', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT8', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT9', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('FIT10', ftString, 1);
    ClientDataSetSources.FieldDefs.Add('COMMENT', ftString, 43); // Widened from 25; 02/24/05 -TC
    for I := 0 to FieldNames.Count - 1 do
    begin
      FieldName := FieldNames[I];
      ClientDataSetSources.FieldDefs.Add(FieldName, ftFloat);
    end;

    // Now that the fields are all defined, create and open the data set and
    // start populating it with data.
    ClientDataSetSources.CreateDataSet;
    ClientDataSetSources.Open;
    while not EoF(SourceProfilesDataFile) do
    begin
      // Read and trim a line of data.
      ReadLn(SourceProfilesDataFile, DataLine);
      DataLine := Trim(DataLine);

      // If the line is not empty and doesn't have junk in it like a space.
      if (Length(DataLine) > 0) and (Pos('_ _', DataLine) = 0) then
      begin
        // Parse the data line into a list of data values.
        FieldValues := ParseStringIntoStringList(DataLine, ' ');
        Assert(
          FieldValues.Count = ClientDataSetSources.FieldCount - 11,
          'The number of data values for this source profile is wrong!');

        // Add a new record and plug in the data.
        ClientDataSetSources.Append;
        for I := 0 to 2 do
          ClientDataSetSources.Fields[I].Text := FieldValues[I];
        // Skip the FIT[1..10] and COMMENT fields: they're set by the user.
        for I := 14 to ClientDataSetSources.FieldCount - 1 do
          ClientDataSetSources.Fields[I].Value := FieldValues[I - 11];

        // Clear the value list for the next pass.
        FieldValues.Clear;
      end
      else
      begin
//      Assert(True); // First appeared in Build 'C': 09/03/02
      end;
    end;
    ClientDataSetSources.First;

    // Configure the grid(s).
    for I := 0 to 2 do
    begin
      DBGridSources.Columns[I].Title.Font.Size := 8;
      DBGridSources.Columns[I].Title.Font.Style := [];
      DBGridSources.Columns[I].Title.Color := clWhite;
    end;
    for I := 3 to 12 do
    begin
      // Set the display label for the fit columns.
      ClientDataSetSources.Fields[I].DisplayLabel := IntToStr(I - 2);
      ClientDataSetSources.Fields[I].DisplayWidth := 5;
      ClientDataSetSources.Fields[I].Alignment := taCenter;
      DBGridSources.Columns[I].Title.Alignment := taCenter;
      DBGridSources.Columns[I].Title.Font.Size := 10;
      DBGridSources.Columns[I].Title.Font.Style := [fsBold];
    end;
    for I := 13 to ClientDataSetSources.FieldCount - 1 do
    begin
      DBGridSources.Columns[I].Title.Font.Size := 8;
      DBGridSources.Columns[I].Title.Font.Style := [];
      DBGridSources.Columns[I].Title.Color := clWhite;
    end;
  finally
    // Clean up.
    if Assigned(FieldValues) then
      FreeAndNil(FieldValues);
    if Assigned(FieldNames) then
      FreeAndNil(FieldNames);
    CloseFile(SourceProfilesDataFile);
  end;
end;

procedure TMainForm.PruneSources;
var
  I: Integer;
  SubString: string;
begin
  with ClientDataSetSources do
  begin
    First;
    I := 0;
    SubString := Trim(Copy(g_PRCodeUser, (I * lenPRcode) + 1, 6));
    while not EoF do
    begin
      if FieldByName('PNO').Text = SubString then
      begin
        Inc(I);
        SubString := Trim(Copy(g_PRCodeUser, (I * lenPRcode) + 1, 6));
      end
      else
      begin
        // No match, so mark row for deletion.
        Edit;
        FieldByName('PNO').Text := 'DELETE';
      end;
      Next;
    end;
    // Pack the dataset by deleting all the records marked for deletion.
    First;
    while not EoF do
    begin
      if FieldByName('PNO').Text = 'DELETE' then
        Delete
      else
        Next;
    end;
    First;
  end;
end;

// This function was included with JS' 09-19-02 build.
// TC moved this function moved from CMB82Internals.pas on 10/24/04:
function ParseStringIntoStringList(const Line, Separator: string): TStringList;
var
  ScratchLine, StringToBeAdded: string;
  SeparatorOffset: Integer;
begin
  Result := TStringList.Create;
  ScratchLine := Trim(Line);
  SeparatorOffset := Pos(Separator, ScratchLine);
  while SeparatorOffset > 0 do
  begin
    StringToBeAdded := Trim(Copy(ScratchLine, 1, SeparatorOffset - 1));
    Result.Add(StringToBeAdded);
    ScratchLine := Trim(Copy(
      ScratchLine,
      SeparatorOffset + Length(Separator),
      Length(ScratchLine) - SeparatorOffset));
    SeparatorOffset := Pos(Separator, ScratchLine);
  end;
  Result.Add(Trim(ScratchLine));
end;

// NB: the follwing counting function is still based on component properties (e.g., Filtered);
//     it has not been revised to utilize a simple looping structure as have procs GetSpecieCount
//     & GetSourceCount and won't unless distortion trouble manifests as happened in the species
//     and sources arrays when individual cells were clicked.  -TC 03/03/05
procedure TMainForm.GetSampleCount;
var
  FilterState: Boolean;
begin
  with ClientDataSetSamples do
  begin
    DisableControls;
    FilterState  := Filtered;
    Filtered     := True;
    FSampleCount := RecordCount; // *****
    Filtered     := FilterState;
    EnableControls;
  end;
end;

procedure TMainForm.ShowSampleCount;
// This proc displays the current number of tagged samples determined by the
// previous proc and displays it on CMB8.2's dashboard AT ALL TIMES.
begin
  PanelSampleCount.Caption := '   Samples: ' + IntToStr(FSampleCount);
end;

procedure TMainForm.GetSpecieCount;                 // Proc revised 03/03/05 -TC
var
  lSpecieCount: integer;
begin
  with ClientDataSetSpecies do
  begin
    lSpecieCount := 0;            // Initialize the counter
    DisableControls;
//    First; // Seems UNnecessary for the Species counts ...
    while NOT EoF do
    begin
      if (FieldByName(FCurSpeciesFit).AsString = '*') then
        INC(lSpecieCount);        // INcrement the counter & accumulate
      Next;
    end;
    FSpecieCount := lSpecieCount; // Set FSpecieCount
    First;                        // Set pointer back to the top of the Array
    EnableControls;
  end;
end;

procedure TMainForm.ShowSpecieCount;
// This proc displays the current number of tagged species determined by the
// previous proc and displays it on CMB8.2's dashboard AT ALL TIMES:
begin
  PanelSpecieCount.Caption := '   Species: ' + IntToStr(FSpecieCount);
end;

procedure TMainForm.GetSourceCount;                 // Proc revised 03/03/05 -TC
var
  lSourceCount: integer;
begin
  with ClientDataSetSources do
  begin
    lSourceCount := 0;            // Initialize the counter
    DisableControls;
    First;                        // Here, this initialization seems to be necessary
    while NOT EoF do
    begin
      if (FieldByName(FCurSourcesFit).AsString = '*') then
        INC(lSourceCount);        // INcrement the counter & accumulate
      Next;
    end;
    FSourceCount := lSourceCount; // Set FSourceCount
    First;                        // Set pointer back to the top of the Array
    EnableControls;
  end;
end;

procedure TMainForm.ShowSourceCount;
// This proc displays the current number of tagged source profiles determined by
// the previous proc and displays it on CMB8.2's dashboard AT ALL TIMES:
begin
  PanelSourceCount.Caption := '   Sources: ' + IntToStr(FSourceCount);
end;

procedure TMainForm.ComboBoxOutputFileFormatClick(Sender: TObject);
// This proc - triggered via ComboBoxOutputFileFormat's OnClick - updates the Output
// File Format display (selected in Options) on CMB8.2's dashboard AT ALL TIMES:
begin
  PanelOutputFileFormat.Caption := 'Output Format: ' + MainForm.ComboBoxOutputFileFormat.Text;
end;

function TMainForm.SampleSizeRangeCountExceeded: Boolean;
var
  StringList: TStringList;
  CurrentRecordNumber, Count: Integer;
  Key, Value, Line: string;
  FilterState: Boolean;
//  FFirstTimeRunning: Boolean; // TC rem 10-17-04
begin
  Result := False; // No overflow.
  StringList := TStringList.Create;
  ClientDataSetSamples.DisableControls;
  CurrentRecordNumber := ClientDataSetSamples.RecNo;
  FilterState := ClientDataSetSamples.Filtered;
  try
    ClientDataSetSamples.Filtered := True;
    ClientDataSetSamples.First;
    while not ClientDataSetSamples.EoF do
    begin
      Key :=
        ClientDataSetSamples.FieldByName('SITE').AsString
        + ClientDataSetSamples.FieldByName('DATE').AsString;
      Value := StringList.Values[Key];
      if Value = '' then
        StringList.Add(Key + '=1')
      else
      begin
        // Delete the string from the list, increment the count, and then add
        // the new string to the list.
        Line := Key + '=' + Value;
        StringList.Delete(StringList.IndexOf(Line));
        Count := StrToInt(Value) + 1;
        if Count > 4 then
        begin
          // We've overflowed, so just bail and let the user fix it.
          Result := True;
          Exit;
        end;
        Line := Key + '=' + IntToStr(Count);
        StringList.Add(Line);
      end;
      ClientDataSetSamples.Next;
    end;
  finally
    ClientDataSetSamples.Filtered := FilterState;
    ClientDataSetSamples.RecNo := CurrentRecordNumber;
    ClientDataSetSamples.EnableControls;
    FreeAndNil(StringList);
  end;
end;

procedure TMainForm.GetCurSam;
var
  I: Integer;
begin
  with ClientDataSetCurSam do
  begin
    Open;
    EmptyDataSet;
    // The "- 2" is so we don't ever show the _RECORD_NUMBER_ field: its only
    // reason for being is to keep the client data set records in the same order
    // they were read from the file.
    for I := 6 to ClientDataSetSamples.FieldCount - 2 do
    begin
      if (I mod 2) = 0 then // Only even columns.
      begin
        Append;
        FieldByName('SPECIE').Text := ClientDataSetSamples.Fields[I].FieldName;
      end;
    end;
    Post;
    Close;
  end;
end;

procedure TMainForm.GetCurSrc;
var
  I: Integer;
begin
  with ClientDataSetCurSrc do
  begin
    Open;
    EmptyDataSet;
    for I := 14 to ClientDataSetSources.FieldCount - 1 do
    begin
      if (I mod 2) = 0 then // Only even columns.
      begin
        Append;
        FieldByName('SPECIE').Text := ClientDataSetSources.Fields[I].FieldName;
      end;
    end;
    Post;
    Close;
  end;
end;

procedure TMainForm.GetSpecies;
var
  I: Integer;
  Value: string;
begin
  with ClientDataSetSpecies do
  begin
    Open;
    EmptyDataSet;
    // RW 2000-07-21: instead of getting specie names from ClientDataSetSamples,
    // we need to extract them from g_SPCodeUser since the list may have been
    // reduced by UNselected rows in the SP*.sel file.
    for I := 1 to g_NspTot - 1 do     // Index '0' is TMAC field, which we skip.
    begin
      Append;
      Value := Trim(Copy(g_SPCodeUser, (I * lenSPcode) + 1, 6));
      FieldByName('SPECIE').Text := Value;
    end;
    Post;
    Close;
  end;
end;

procedure TMainForm.BestFit;
var
  BestFitArray: Integer;
begin
  GetSampleCount;
  if FSampleCount = 1 then
  begin
    g_BestFitFlag := True;
    BestFitArray := DoBestFit;
    if BestFitArray <> 0 then
    begin
      DBGridSpeciesIndexClick(DBGridSpecies.Columns[BestFitArray + 1]);
      DBGridSourcesIndexClick(DBGridSources.Columns[BestFitArray + 2]);
      g_BestFitFlag := False;
      RunCMB;
    end
    else
    begin
      // RFA - no best fit.  Should we tell the user?
    end;
  end
  else
  begin
    MessageDlg(
      'Exactly *ONE* sample must be selected for the Best Fit option.',
      mtInformation,
      [mbOK],
      0);
  end;
end;

procedure TMainForm.GetBarValue1;
var
  I: Integer;
begin
  with ClientDataSetCurSam do
  begin
    First;
    while not EoF do
    begin
      // The "- 2" is so we don't ever show the _RECORD_NUMBER_ field: its only
      // reason for being is to keep the client data set records in the same
      // order they were read from the file.                       JS - 08/06/04
      for I := 6 to ClientDataSetSamples.FieldCount - 2 do
      begin
        Edit;
        if (I mod 2) = 0 then
        begin // Even - concentrations.
          FieldByName('AMOUNT').Value := ClientDataSetSamples.Fields[I].Text;
          Post;
        end
        else
        begin // Odd - uncertainty.
          FieldByName('UNCERT').Value := ClientDataSetSamples.Fields[I].Text;
          Post;
          Next;
        end;
      end;
    end;
  end;

  with Series1 do
  begin
    Clear;
    ParentChart := DBChartSamples;
    XLabelsSource := 'Specie';
    YValues.ValueSource := 'Amount';
    DBChartSamples.LeftAxis.Title.Caption := ComboBoxUnits.Text;
    CheckDataSource;
    DBChartSamples.Repaint;
  end;
end;

procedure TMainForm.GetBarValue2; // This proc controls appearance of graph presentation:
var
  I: Integer;
  m: double;
  origRoundMode: TFPURoundingMode ; // = (rmNearest, rmDown, rmUp, rmTruncate);

  // Call this to change axis of the grid:
  procedure SetAxis (aMaxFloat: double; aMinfloat: double; aInc: double);
  var
    ser: TChartSeries;
    v : TchartAxis;
  begin
    ser := DBChartSources.Series[0];
    v := ser.GetVertAxis;
    v.Automatic := false;
    v.Maximum := aMaxFloat;
    v.Minimum := aMinFloat;
    v.Increment := aInc;
//    v.Logarithmic := true;
  end;

begin
  m := 0.0;
  with ClientDataSetCurSrc do
  begin
    First;
    while not EoF do
    begin
      for I := 14 to ClientDataSetSources.FieldCount - 1 do
      begin
        Edit;
        if (I mod 2) = 0 then
        begin // Even => measured values.
        (*
          FieldByName('AMOUNT').Value
            := FormatFloat('0.000000', ClientDataSetSources.Fields[I].Value);
          *)
          FieldByName('AMOUNT').Value
            := FormatFloat('0.0000', ClientDataSetSources.Fields[I].Value);

          // Return highest value between the 2; e.g., if m = 5, and FieldByname('Amount').value = 4,
          // then you get 5 for m
          m := Max(m, FieldByName('Amount').Value);
          Post;
        end
        else
        begin // Odd => uncertainty values.
        // This code sets the precision in the graph
        (*  FieldByName('UNCERT').Value
            := FormatFloat('0.000000', ClientDataSetSources.Fields[I].Value);
         *)
            FieldByName('UNCERT').Value
            := FormatFloat('0.0000', ClientDataSetSources.Fields[I].Value);
          Post;
          Next;
        end;
      end;
    end;
  end;

  with Series2 do
  begin
    Clear;
    ParentChart := DBChartSources;
    XLabelsSource := 'Specie';
    YValues.ValueSource := 'Amount';
    CheckDataSource;
    DBChartSources.Repaint;
  end;

  // Save the rounding mode that was set previously:
  origRoundMode := GetRoundMode();
  SetRoundMode (rmUp);
  // m is largest value
  m := RoundTo(m,-2); // see Delphi help for simpleRoundTo

  //JS added 11-18-04
  SetAxis(m, 0, m / 10);

//  TFPURoundingMode ; // = (rmNearest, rmDown, rmUp, rmTruncate);
  SetRoundMode (origRoundMode);
end;

function TMainForm.RunCMB: Boolean;
// Core function: runs the CMB model; returns success (True) or (False) bail.
var
  OldCursor: TCursor;
  CurrentRecordNumber, DichotFlag: Integer; // DichotFlag addeded on 10/26/04 - TC
  SamplesFilterState: Boolean;
  cdsr: TClientDataSet;
  atFirstCDSRecord: Boolean;

begin
  Result := true;            // RunCMB is successful and true, unless bail happens
  atFirstCDSRecord := False; // Compiler says this initialization is never used - TC
  FDichotomous := False;
  OldCursor := Screen.Cursor;

  try
    Screen.Cursor := crHourGlass;

    // Check that all the counts are all positive and that no more than four
    // size ranges are in the queue.
    GetSampleCount;
    SetBatchFlag; // TC added the this call 6-15-03; SetBatchFlag is CMB82Internals' Task 5
                  // (where its arguments are declared), and sends a flag to the DLL to reflect
                  // whether the latest sample selection(s) represent(s) Batch Mode.
//    GetSpecieCount; // Call removed 03/03/05; seems UNnecessary, if not problematic -TC
//    GetSourceCount; //  "      "        "

    // Check that inputs are valid; if not, then exit - note inside of this
    // function there is a message which displays whether input is bad.
    if VerifyCMBRunInputsValid() = false then
       exit;

      with ClientDataSetResults do
      begin
        Open;
        CurrentRecordNumber := RecordCount;

        // Save the filtered state which was in user prior to us working with
        // the records.  Whether it's true or false doesn't matter - after the
        // loop we restore it.
        //
        SamplesFilterState := ClientDataSetSamples.Filtered;

        // When we are done, the loop ClientDataSetSamples.Filtered is set back
        // to whatever it was prior, or whatever is the value in SamplesFilterState.
        //
        // We're doing this because the '*' are set in g_ADCode based on the number
        // of records in the result set.  If we filter them, then we don't have the
        // same number of records and the asterisks are set in the wrong place.

//      Check function QC_Dichotomous(); return 'True' if valid Dichot pair(s):
        IF SampleCount >1 then
        begin
        case QC_Dichotomous() of
          0: // Dichot samples are hopelessly incompatible; terminate the application.
          begin
            Result := false; // We need to bail!
            exit;
          end;
          -1: // re-load Select Samples screen and allow adjustment
          begin
            PageControlMain.ActivePage := TabSheetSamples; // Kick user back out to Select Samples screen
            exit;
          end;
          -2: // re-load Select Input Files screen and allow adjustment
          begin
            PageControlMain.ActivePage := TabSheetInputFiles; // Kick user back out to Select Input Files screen
            exit;
          end;
          1: // All is ok ...
          begin
            // maybe you do something here
          end;
        end; // case
        end;

        IF (FDichotomous = false ) then
            DichotFlag := 1  // We're NOT dichot.; pass integer to DLL
        else
            DichotFlag := 2; // We're dichot; pass integer to DLL
        SetDichotFlag(DichotFlag); // Added 10/25/04; call only if FDichotomous and pass 2

        cdsr := ClientDataSetResults; // a short-hand alias (less typing)
                                      // Simply copy the samples in ClientDataSetSamples:
        ClientDataSetSamples.First;   // Rewind ClientDataSetSamples !!
        atFirstCDSRecord := true;     // CDS = ClientDataSetSamples
                                      // This flag indicates 1st tagged sample (used in Task 15).
        while not ClientDataSetSamples.EoF do
        begin
          if ClientDataSetSAmples.FieldByName('SELECTED').Text = '*' then
          begin                    // This branch executed ONCE / tagged sample:
            cdsr.Append; // ... to the results table.

            cdsr.FieldByName('SITE').Value
              := ClientDataSetSamples.FieldByName('SITE').Value;
            cdsr.FieldByName('DATE').Value
              := ClientDataSetSamples.FieldByName('DATE').Value;
            cdsr.FieldByName('DUR').Value
              := ClientDataSetSamples.FieldByName('DUR').Value;
            cdsr.FieldByName('START').Value
              := ClientDataSetSamples.FieldByName('START').Value;
            FieldByName('SIZE').Value
              := ClientDataSetSamples.FieldByName('SIZE').Value;

            cdsr.FieldByName('ITERATION').Value := MaskEditIteration.Text;
            cdsr.FieldByName('MAXUNC').Value := MaskEditUncertainty.Text;
            cdsr.FieldByName('MINPROJ').Value := MaskEditProjection.Text;
            cdsr.FieldByName('DECIMALS').Value := MaskEditDecimals.Text;
            cdsr.FieldByName('UNITS').Value := ComboBoxUnits.Text;
            cdsr.FieldByName('WTCHISQ').Value := StrToFloat(MaskEditChiSquare.Text);
            cdsr.FieldByName('WTRSQUARE').Value := StrToFloat(MaskEditRSquare.Text);
            cdsr.FieldByName('WTPERCENT').Value := StrToFloat(MaskEditPercentMass.Text);
            cdsr.FieldByName('WTFRACTION').Value := StrToFloat(MaskEditFraction.Text);
            cdsr.FieldByName('BRITT').Value := CheckBoxBritt.Checked;
            cdsr.FieldByName('BEST').Value := CheckBoxBestFit.Checked;
            cdsr.FieldByName('ELIM').Value := CheckBoxSource.Checked;
            cdsr.FieldByName('SOURCESFIT').Text := Copy(FCurSourcesFit, 4, 2);
            cdsr.FieldByName('SPECIESFIT').Text := Copy(FCurSpeciesFit, 4, 2);

            // ToDo - This should be refactored; structure of how this is called
            //        I don't really care for.  091204 - JS
            // This branch is executed once/tagged sample!
            if CalculateSourceContributions > 0 then   // Task 12 in CMB82Internals;
                                                       // source contributions have
                                                       // been successfully generated
                                                       // NB: Task 12's call invokes CMB82.c's Step V,
                                                       // where (as now configured) tagged dichotomous
                                                       // samples are inverted. -TC (10/23/04)
            begin
              PresentContributionsBySpecies;                     // Call Task 13
              PresentNormalizedMPINMatrix;                       // Call Task 14
              WriteSFit2TempBuffer (atFirstCDSRecord); // Call Task 15 in CMB82Internals, passing file
                                                       // format selected in Options in case user
                                                       // wants to save spreadsheet-type output.
            end;

            DBMemoSummary.Field.Assign(DBMemoSummary.Lines);
            DBMemoContributions.Field.Assign(DBMemoContributions.Lines);
            DBMemoMPIN.Field.Assign(DBMemoMPIN.Lines);

            DBMemoSummary.Clear;
            DBMemoContributions.Clear;
            DBMemoMPIN.Clear;

            g_MPInShownFlag := False;
            g_ContributionsShownFlag := False;

            // Important note:  this call (Task 7) clears the * in g_ADCode, a
            // dynamic array of our samples, but it doesn't clear the * in the
            // grid (they are still there).  The following line does clear:
            UpdateADCode(' ');                                         // Task 7

          // The first time through we need to know we are at the first record
          // for WriteSFit2TempBuffer; now set it to false
            atFirstCDSRecord := false;
          end;

          // Move to the next record in the ClientDataSetSamples.
          // We go through all of them, but we only look at the ones with *'s
          ClientDataSetSamples.Next;                 // Move to the next sample.
        end;

        //  This code resets the g_ADCode back to what it was before
        //  it was cleared.  It looks like the loop above calls UpdateAdCode(' ')
        //  and effectively clears it.  The next time we call RunCMB, g_ADCode
        //  has no asterisks set, but they are in the UI, so there's a disconnect
        //  there.  So, we simply reset them.
        ClientDataSetSamples.First;     // Start back at first rec in the table.
        while not ClientDataSetSamples.EoF do
        begin
          // We're reading the dataset, which is linked to the grid, so the *'s
          // will still be there - collapsed or not.
          if ClientDataSetSamples.FieldByName('SELECTED').Text = '*' then
          begin
          // When we encounter a row in the grid which has an asterisk, we know
          // we have to reset the g_ADCode - the Fortran dll uses this and so it
          // must be reset here, otherwise, you'll be passing a list without *'s;
          // things just won't work.
            UpdateADCode('*');
          end;
          ClientDataSetSamples.Next;
        end;

        // We turn back on filtering here to restore things to whatever they looked
        // like before we worked with it.  This is necessary because the user will
        // expect the view to be the same.  And we can't traverse the dataset while
        // it is being filtered.
        ClientDataSetSamples.Filtered := SamplesFilterState;

        if CurrentRecordNumber = 0 then
          First
        else
          RecNo := CurrentRecordNumber + 1;

        ClientDataSetSources.Open;
        EnableRunCMBControls (RecordCount);
      end;
  finally
    Screen.Cursor := OldCursor;
  end;
end;

function TMainForm.VerifyCMBRunInputsValid: Boolean;
begin
  Result := false;
  if FSampleCount = 0 then
  begin
    MessageDlg(
      'No samples have been selected.',
      mtInformation,
      [mbOK],
      0);
    PageControlMain.ActivePage := TabSheetSamples;
  end
  else if FSpecieCount = 0 then
  begin
    MessageDlg(
      'No fitting species have been selected.',
      mtInformation,
      [mbOK],
      0);
    PageControlMain.ActivePage := TabSheetSpecies;
  end
  else if FSourceCount = 0 then
  begin
    MessageDlg(
      'No fitting sources have been selected.',
      mtInformation,
      [mbOK],
      0);
    PageControlMain.ActivePage := TabSheetSources;
  end
  else if FSpecieCount < FSourceCount then
  begin
//    As of 3/17/03, this is the ONLY message that triggers for this error condition !  All others are shunted ...
    MessageDlg(
      'The number of fitting species selected' + #10
      + 'must be greater than or equal to' + #10
      + 'the number of fitting sources selected.',
      mtInformation,
      [mbOK],
      0);
//    Return user back to Fitting Species selection screen to adjust:
    PageControlMain.ActivePage := TabSheetSpecies;
  end
  else if SampleSizeRangeCountExceeded then
  begin
    MessageDlg(
      'The number of size ranges in the selected samples' + #10
      + 'exceeds 4 for the same site and sampling period.',
      mtInformation,
      [mbOK],
      0);
    PageControlMain.ActivePage := TabSheetSamples;
  end
  else   // We have everything we need to run CMB at this point: all systems go!
  begin
    Result := true;
  end;
end;

function TMainForm.QC_Dichotomous: Integer; // Called from proc RunCMB once/Run:
var
  FineCount, CoarseCount: integer;
  FirstTaggedSample, Fine, Coarse: Boolean;
  SizeFrac, siteID1, siteID2, date1, date2, dur1, dur2, startHR1, startHR2: string;

Begin
// 1st Cut: scan the series of tagged samples to detect dichotomous samples:
// Initialize Booleans:
  Fine         := False;
  Coarse       := False;
  FDichotomous := False;

  result := 1;

  ClientDataSetSamples.First;
  FirstTaggedSample := True;
  While Not ClientDataSetSamples.EoF DO
  Begin
    if ClientDataSetSamples.FieldByName('SELECTED').Text = '*' then
    begin
      SizeFrac := ClientDataSetSamples.FieldByName('SIZE').Value;
      if SizeFrac = 'FINE' then
        begin
          Fine  := True;
          inc (FineCount);
        end;
      if SizeFrac = 'COARSE' then
        begin
          Coarse  := True;
          inc (CoarseCount);
        end;
      FirstTaggedSample := false;         // We've passed the 1st tagged sample.
    end; // all tagged samples have been checked
    ClientDataSetSamples.Next;
  End; // end While

// We've finished the 1st pass ...
  if Fine AND Coarse then FDichotomous := True; // => dichot samples are involved ...
  if (FDichotomous = True) AND (FineCount <> CoarseCount) then // We're UNpaired !!
    begin                  // re-load Select Samples screen and allow adjustment
      MessageDlg(
      'Dichotomous samples tagged are UNpaired!' + #10 +
      'They must be paired in a sequence either Fine/Coarse or Coarse/Fine.',
      mtInformation, [mbOK], 0);
      //ClientDataSetSamples.First; // 1st potential exit point; may need this rewind
      result := -1;
      exit;
    end;

// 2nd Cut - let's look a little closer ...
// We have dichotomous samples tagged and the're paired, but are they compatible?
// Rewind ClientDataSetSamples and read a pair at a time:

  IF (FDichotomous = True) then
  BEGIN
    ClientDataSetSamples.First;
    While not ClientDataSetSamples.EoF do
    Begin
      if (FDichotomous = True) AND (ClientDataSetSamples.FieldByName('SELECTED').Text = '*') then
      begin
      // Get attributes for this sample in the pair:
        siteID1  := ClientDataSetSamples.FieldByName('SITE').Value;
        date1    := ClientDataSetSamples.FieldByName('DATE').Value;
        dur1     := ClientDataSetSamples.FieldByName('DUR').Value;
        startHR1 := ClientDataSetSamples.FieldByName('START').Value;

        ClientDataSetSamples.Next; // Read the next sample in this dichot. pair; get attributes:

        siteID2  := ClientDataSetSamples.FieldByName('SITE').Value;
        date2    := ClientDataSetSamples.FieldByName('DATE').Value;
        dur2     := ClientDataSetSamples.FieldByName('DUR').Value;
        startHR2 := ClientDataSetSamples.FieldByName('START').Value;

        // Check correspondence of sample attributes:

        if (siteID1  <> siteID2) OR
          (date1     <> date2)   OR
          (dur1      <> dur2)    OR
          (startHR1  <> startHR2) then
        begin
          if MessageDlg(
            'Dichotomous samples are paired but incompatible!' + #10 +
            'The paired samples must correspond in site ID,'   + #10 +
            'sampling date, sampling duration and start hour.' + #10 + #10 +
            'Do you want to select other input file(s)?'       + #10 +
            '(NO will terminate EPA-CMB8.2)',
            mtConfirmation, [mbYes, mbNo], 0) = mrYes then
            begin      // re-load Select Input Files screen and allow adjustment
              //ClientDataSetSamples.First; // 2nd potential exit point; may need this rewind
              result := -2;
              exit;
            end
          else
            begin // Bail! - there is nothing we can do, just exit app.
              result := 0;
              exit;
            end;
        end;
      end; // all tagged pairs have been checked
      ClientDataSetSamples.Next; // Read the next sample in this dichot. pair.
    End; // end While
  END;
  //ClientDataSetSamples.First; // 3rd potential exit point; may need this rewind
End;

procedure TMainForm.EnableRunCMBControls (const aRecordCount: integer);
begin
  PageControlMain.ActivePage := TabSheetResults;
  PageControlMainChange(SpeedButtonRun);
  if aRecordCount <> 0 then
  begin
    SpeedButtonDeleteCurrent.Enabled := True;
    SpeedButtonDeleteAll.Enabled := True;
    MenuItemFileSave.Enabled := True;
    SpeedButtonSave.Enabled := True;
    MenuItemFilePrint.Enabled := True;
    SpeedButtonPrint.Enabled := True;
  end
  else
  begin
    SpeedButtonDeleteCurrent.Enabled := False;
    SpeedButtonDeleteAll.Enabled := False;
    MenuItemFileSave.Enabled := False;
    SpeedButtonSave.Enabled := False;
    MenuItemFilePrint.Enabled := False;
    SpeedButtonPrint.Enabled := False;
  end;
end;

procedure TMainForm.SaveSamplesToTextFile(const FileName: string);
// This proc updates or writes anew a samples selection file (AD*.sel).
// OutputFile is called FileName, which comes from the Edit Control box on the
// Select Input Files screen.
var
  OutputFile: TextFile;
  CurrentRecordNumber: Integer;
  OutputLine: string;
begin
  Assert(Length(FileName) > 0, 'Invalid filename!');
  if Length(FileName) > 0 then
  begin
    // Write the samples database to a text file.
    AssignFile(OutputFile, FileName);
    Rewrite(OutputFile);
    with ClientDataSetSamples do
    begin
      DisableControls;
      CurrentRecordNumber := RecNo;
      First;
      while not EoF do
      begin
        // Construct each line by concatenating each field trimmed to the
        // appropriate length.
        // %-5.5s changed to %-6.6s to support expanded (6-char) size field; TC 10-15-04
        OutputLine := Format(
          '%-12.12s %-8.8s %2.2s %2.2s %-6.6s %-1.1s',
          [FieldByName('SITE').Text,
          FieldByName('DATE').Text,
          FieldByName('DUR').Text,
          FieldByName('START').Text,
          FieldByName('SIZE').Text,
          FieldByName('SELECTED').Text]);
        WriteLn(OutputFile, OutputLine);
        Next;
      end;
      RecNo := CurrentRecordNumber;
      EnableControls;
    end;
    CloseFile(OutputFile);
  end;
end;

procedure TMainForm.SaveSpeciesToTextFile(const FileName: string);
// This proc updates or writes anew a species selection file (SP*.sel).
// OutputFile is called FileName, which comes from the Edit Control box on the
// Select Input Files screen.
var
  OutputFile: TextFile;
  CurrentRecordNumber: Integer;
  OutputLine: string;
begin
  Assert(Length(FileName) > 0, 'Invalid filename!');
  if Length(FileName) > 0 then
  begin
    // Write the species database to a text file.
    AssignFile(OutputFile, SaveDialogSelection.FileName);
    Rewrite(OutputFile);
    WriteLn(OutputFile, '  TOTAL                               TOTAL');
    with ClientDataSetSpecies do
    begin
      DisableControls;
      CurrentRecordNumber := RecNo;
      First;
      while not EoF do
      begin
        // Construct each line by concatenating each field trimmed to the
        // appropriate length.
        OutputLine := Format(
          '%6.6s  %-8.8s  %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s'
          + ' %1.1s %1.1s %s',
          [FieldByName('SPECIE').Text,
          FieldByName('SPECIENAME').Text,
          FieldByName('FIT1').Text,
          FieldByName('FIT2').Text,
          FieldByName('FIT3').Text,
          FieldByName('FIT4').Text,
          FieldByName('FIT5').Text,
          FieldByName('FIT6').Text,
          FieldByName('FIT7').Text,
          FieldByName('FIT8').Text,
          FieldByName('FIT9').Text,
          FieldByName('FIT10').Text,
          FieldByName('COMMENT').Text]);
        WriteLn(OutputFile, OutputLine);
        Next;
      end;
      RecNo := CurrentRecordNumber;
      EnableControls;
    end;
    CloseFile(OutputFile);
  end;
end;

procedure TMainForm.SaveSourcesToTextFile(const FileName: string);
// This proc updates or writes anew a source profiles selection file (PR*.sel).
// OutputFile is called FileName, which comes from the Edit Control box on the
// Select Input Files screen.
var
  OutputFile: TextFile;
  CurrentRecordNumber: Integer;
  OutputLine: string;
begin
  Assert(Length(FileName) > 0, 'Invalid filename!');
  if Length(FileName) > 0 then
  begin
    // Write the sources database to a text file.
    AssignFile(OutputFile, SaveDialogSelection.FileName);
    Rewrite(OutputFile);
    with ClientDataSetSources do
    begin
      DisableControls;
      CurrentRecordNumber := RecNo;
      First;
      while not EoF do
      begin
        // Construct each line by concatenating each field trimmed to the
        // appropriate length.
        OutputLine := Format(
          '%6.6s  %-8.8s  %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s %1.1s'
          + ' %1.1s %s',
          [FieldByName('PNO').Text,
          FieldByName('SID').Text,
          FieldByName('FIT1').Text,
          FieldByName('FIT2').Text,
          FieldByName('FIT3').Text,
          FieldByName('FIT4').Text,
          FieldByName('FIT5').Text,
          FieldByName('FIT6').Text,
          FieldByName('FIT7').Text,
          FieldByName('FIT8').Text,
          FieldByName('FIT9').Text,
          FieldByName('FIT10').Text,
          FieldByName('COMMENT').Text]);
        WriteLn(OutputFile, OutputLine);
        Next;
      end;
      RecNo := CurrentRecordNumber;
      EnableControls;
    end;
    CloseFile(OutputFile);
  end;
end;

procedure TMainForm.SaveInputToIN8File(const FileName: string);
// This proc invoked when Save Control File is elected on session exit.
// File was built using file names appearing in the Edit Control box on the Select
// Input Files screen; TC coded for direct load of global filenames - 9/6/03.
var
  OutputFile: TextFile;
begin
  Assert(Length(FileName) > 0, 'Invalid filename!');
  if Length(FileName) > 0 then
  begin
    AssignFile(OutputFile, FileName);
    Rewrite(OutputFile);

    // 1/3 Source profile selection - PR*.sel
    if EditSourceProfileSelection.Text <> '' then
      if FUseControlFile then
        WriteLn(OutputFile, EditSourceProfileSelection.Text)
      else
        WriteLn(OutputFile, g_PRSelFullPathName)
     else
        WriteLn(OutputFile, '**********');

    // 2/3 Specie selection - SP*.sel
    if EditSpeciesSelection.Text <> '' then
      if FUseControlFile then
        WriteLn(OutputFile, EditSpeciesSelection.Text)
      else
        WriteLn(OutputFile, g_SPSelFullPathName)
    else
      WriteLn(OutputFile, '**********');

    // 3/3 Ambient data selection - AD*.sel
    if EditAmbientDataSelection.Text <> '' then
      if FUseControlFile then
        WriteLn(OutputFile, EditAmbientDataSelection.Text)
      else
        WriteLn(OutputFile, g_ADSelFullPathName)
    else
      WriteLn(OutputFile, '**********');

    if FUseControlFile then
      WriteLn(OutputFile, EditAmbientData.Text)
    else
      WriteLn(OutputFile, g_ADFullPathName);

    if FUseControlFile then
      WriteLn(OutputFile, EditSourceProfiles.Text)
    else
      WriteLn(OutputFile, g_PRFullPathName);

    CloseFile(OutputFile);
  end;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
// Do we want call CheckToSaveFiles if the user has bad samples and we bailed?
(* Possible alternative approach: this would require a private variable called
  fBailCMB to be declared of Boolean type, and set in where RunCMB checks if
  successful fBailCMB := RunCMB()
 if fBailCMB then skip all this stuff
*)
  CheckToSaveFiles; // Check to see if any files have been modified; allow option to save; TC 11/15/04
// Purge ASCII scratch file left by CMB82Internals.pas's Task 15:
  if FileExists(g_CMB8ExeDir + '$TEMPOUT.txt') then
    DeleteFile(g_CMB8ExeDir  + '$TEMPOUT.txt');

  CMB82Internals.TerminateCMB82();                      // 06-03-03 added by RFA
  CanClose := True;
end;

procedure TMainForm.CheckToSaveFiles;
var
  MBResult: Integer;
Begin
// Do we want this code to execute if the user has bad samples and we bailed?
(* Possible alternative approach: this would require a private variable called
   fBailCMB to be declared of Boolean type, and set in where RunCMB checks if
   successful fBailCMB := RunCMB()
   if fBailCMB then skip all this stuff
*)
// Prompt to save the files which need to be saved.
  if FSaveIn8 then
  begin
    MBResult := MessageDlg(
      'Save Control File?',
      mtConfirmation,
      [mbYes, mbNo],
      0);
    if MBResult = mrYes then
    begin
      PageControlMain.ActivePage := TabSheetInputFiles;
      SpeedButtonSave.Click;
    end;
//  FSaveIn8 := false;
  end;

  if FSaveSamples then
  begin
    MBResult := MessageDlg(
      'Save samples selection file?',
      mtConfirmation,
      [mbYes, mbNo],
      0);
    if MBResult = mrYes then
    begin
      PageControlMain.ActivePage := TabSheetSamples;
      SpeedButtonSave.Click;
    end;
//  FSaveSamples := false;
  end;

  if FSaveSpecies then
  begin
    MBResult := MessageDlg(
      'Save species selection file?',
      mtConfirmation,
      [mbYes, mbNo],
      0);
    if MBResult = mrYes then
    begin
      PageControlMain.ActivePage := TabSheetSpecies;
      SpeedButtonSave.Click;
    end;
//  FSaveSpecies := false;
  end;

  if FSaveSources then
  begin
    MBResult := MessageDlg(
      'Save sources selection file?',
      mtConfirmation,
      [mbYes, mbNo],
      0);
    if MBResult = mrYes then
    begin
      PageControlMain.ActivePage := TabSheetSources;
      SpeedButtonSave.Click;
    end;
//  FSaveSources := false;
  end;
End;

function TMainForm.ApplicationEvents_OnHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
 //  might need
end;

procedure TMainForm.ApplicationEvents1ShortCut(var Msg: TWMKey;
  var Handled: Boolean);
begin
  // there is something special about these tabs in that
  // Delphi does not call the help on them correctly.
  // so this code below adds special handling for the tabs that don't work.
  // to make sure nothing else triggers F1 key press, we return Handled = true
  // this tells delphi "we've used it already , throw it away "
  // for other f1 help, if the tab page is not active as below,
  // Delphi will call the other help
  //

  if Msg.charCode = vk_f1 then  // F1 key was pressed
  begin
    if PageControlMain.ActivePage = TabSheetInputFiles then
    begin
      Application.HelpContext(10);
      Handled := true;
    end
    else if PageControlMain.ActivePage = TabSheetOptions then
    begin
      Application.HelpContext(20);
     Handled := true;
    end
    else if PageControlMain.ActivePage = TabSheetResults then
    begin
     Application.HelpContext(60);
     Handled := true;
    end


  end ;
end;

end.

