// =============================================================================
// The print options form.

unit PrintOptionsFrm;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Buttons,
  ExtCtrls,
  StdCtrls,
  ComCtrls;

// These constants are visible to any unit (including this unit) - like MainForm.
const
  kPrintRangeOfRecords : integer = 0;
  kPrintOnly1Record    : integer = 1;

type
  TPrintOptionsForm = class(TForm)
    PageControl1: TPageControl;
    TabSheetSeveralResults: TTabSheet;
    TabSheet1Result: TTabSheet;        // Added 10/31/03 per JScalco
    RadioGroupPrintRange: TRadioGroup;
    CheckBoxPrintToFile: TCheckBox;
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;
    BitBtnHelp: TBitBtn;
    BitBtn2OK: TBitBtn;
    BitBtn2Cancel: TBitBtn;
    BitBtn2Help: TBitBtn;
    CheckBox2PrintToFile: TCheckBox;
    PrinterSetupDlg: TPrinterSetupDialog;   // Added 10/31/03 per JScalco

    procedure BitBtnHelpClick(Sender: TObject);
    procedure BitBtnOKClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure BitBtnCancelClick(Sender: TObject);
  private
    // Private declarations.
    fCloseFormOk :boolean;
    fPrintMode : integer;
    procedure SetMode(const Value: integer); // Added 10/31/03 per JScalco
    procedure PrintResults(Range: Integer; ToFile: Boolean);
    procedure PrintCurrentResultRecord;
  public
    // Public declarations.
    property PrintMode: integer read fPrintMode write SetMode ; // Added 10/31/03 per JScalco
    procedure PrintControl;
  end;

var
  PrintOptionsForm: TPrintOptionsForm;

implementation

{$R *.DFM}

uses
  Printers,
  MainFrm;

var
  PrintText: TextFile;

procedure TPrintOptionsForm.SetMode(const Value: integer); // Added 10/31/03 per JScalco
begin
  fPrintMode := value;
  PageControl1.ActivePageIndex := value;
  if value = 0 then Caption := 'Print Options'                   // 1st TabSheet
  else Caption := 'Print Options - only 1 result';               // 2nd TabSheet
end;

procedure TPrintOptionsForm.BitBtnHelpClick(Sender: TObject);
begin
  Application.HelpJump('Print_page');
end;

// Controls the printing cycle, based on info from applicable TabSheet
procedure TPrintOptionsForm.PrintControl;
var
  PrintToFile: boolean;
begin
  if PrintMode = kPrintRangeOfRecords then
    PrintToFile := CheckBoxPrintToFile.Checked
  else
    PrintToFile := CheckBox2PrintToFile.Checked;

  if PrintToFile = true then
  begin // create a file
    // Main Report is only available in ASCII format
    MainForm.SaveDialogResults.Filter     := 'ASCII (*.txt) format ONLY';
    MainForm.SaveDialogResults.DefaultExt := 'txt';
    if MainForm.SaveDialogResults.Execute then
    begin
      PrintResults(RadioGroupPrintRange.ItemIndex,PrintToFile);
    end;
  end
  else
  begin // line printer
    PrintResults(RadioGroupPrintRange.ItemIndex,PrintToFile);
  end;
end;

procedure TPrintOptionsForm.PrintResults(Range: Integer; ToFile: Boolean);
var
  InitialRecord: Integer;
begin
  if ToFile then
    AssignFile(PrintText, MainForm.SaveDialogResults.FileName)
  else
    AssignPrn(PrintText);
  Rewrite(PrintText);

  Printer.Canvas.Font := MainForm.DBMemoSummary.Font;
  Printer.Canvas.Font.Size := MainForm.DBMemoSummary.Font.Size;

  if Range = 0 then
    // Print current result.
    PrintCurrentResultRecord
  else
  begin
    // Print all queued results.
    InitialRecord := MainForm.ClientDataSetResults.RecNo; // Note the record of the current Results view
    MainForm.ClientDataSetResults.First;
    while not MainForm.ClientDataSetResults.EoF do
    begin
      PrintCurrentResultRecord;
      MainForm.ClientDataSetResults.Next;
      if not ToFile then
      begin
        Write(PrintText, #12); // Page eject.
      end
      else if not MainForm.ClientDataSetResults.EoF then
        Write(PrintText, #13#10); // Carriage return-line feed.
    end;
    MainForm.ClientDataSetResults.RecNo := InitialRecord; // reset RecNo so Results view is restored
  end;
  System.Close(PrintText);
end;

Procedure TPrintOptionsForm.PrintCurrentResultRecord;
var
  I: Integer;
  Str1, Str2: string;
begin
  Printer.Canvas.Font.Color := clBlack;

  // Title.
  Printer.Canvas.Font.Style := [fsBold];
  WriteLn(
    PrintText,
    '                     Chemical Mass Balance Version EPA-CMB8.2');
  WriteLn(
    PrintText,
    '                              Report Date: ' + DateToStr(Date));
  WriteLn(PrintText, ' ');

  Write(PrintText, Format('%-15.15s', ['SAMPLE:']));
  Write(PrintText, Format('%-15.15s', ['  ']));
  Write(PrintText, Format('%-25.25s', ['OPTIONS:']));
  Write(PrintText, Format('%-10.10s', ['  ']));
  WriteLn(PrintText, Format('%-15.15s', ['INPUT FILES:']));

  WriteLn(PrintText, ' ');

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['SITE:']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [MainForm.ClientDataSetResults.FieldByName('SITE').Text]));
  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-25.25s', ['BRITT & LUECKE:']));
  Printer.Canvas.Font.Style := [];
  if MainForm.ClientDataSetResults.FieldByName('BRITT').AsBoolean then
    Str2 := 'Yes'
  else
    Str2 := 'No';
  Write(PrintText, Format('%-10.10s', [Str2]));
  Printer.Canvas.Font.Style := [];
  WriteLn(PrintText, Format('%15.15s', [MainForm.EditControlFile.Text])); // Echo ControlFile name.

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['SAMPLE DATE:']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [MainForm.ClientDataSetResults.FieldByName('DATE').Text]));
  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-25.25s', ['SOURCE ELIMINATION:']));
  Printer.Canvas.Font.Style := [];
  if MainForm.ClientDataSetResults.FieldByName('ELIM').AsBoolean then
    Str2 := 'Yes'
  else
    Str2 := 'No';
  Write(PrintText, Format('%-10.10s', [Str2]));
  Printer.Canvas.Font.Style := [];
//  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_AmbientFileName)]));
  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_PRSelFullPathName)])); // Echo PR selection file name.

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['DURATION:']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [MainForm.ClientDataSetResults.FieldByName('DUR').Text]));
  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-25.25s', ['BEST FIT:']));
  Printer.Canvas.Font.Style := [];
  if MainForm.ClientDataSetResults.FieldByName('BEST').AsBoolean then
    Str2 := 'Yes'
  else
    Str2 := 'No';
  Write(PrintText, Format('%-10.10s', [Str2]));
  Printer.Canvas.Font.Style := [];
//  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_ProfileFileName)]));
  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_SPSelFullPathName)])); // Echo SP selection file name.

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['START HOUR:']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [MainForm.ClientDataSetResults.FieldByName('START').Text]));
  Printer.Canvas.Font.Style := [fsBold];
  if MainForm.ClientDataSetResults.FieldByName('BEST').AsBoolean then
    Write(PrintText, Format('%-25.25s', ['FIT MEASURE WEIGHTS:']))
  else
    Write(PrintText, Format('%-25.25s', ['   ']));
  Write(PrintText, Format('%-10.10s', ['   ']));
  Printer.Canvas.Font.Style := [];
//  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_ADSelFileName)]));
  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_ADSelFullPathName)])); // Echo AD selection file name.

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['SIZE:']));
  Printer.Canvas.Font.Style := [];
  Str1 := MainForm.ClientDataSetResults.FieldByName('SIZE').Text;
  Write(PrintText, Format('%-15.15s', [Str1]));
  Printer.Canvas.Font.Style := [fsBold];
  if MainForm.ClientDataSetResults.FieldByName('BEST').AsBoolean then
  begin
    Write(PrintText, Format('%-25.25s', ['    R Square:']));
    Printer.Canvas.Font.Style := [];
    Write(PrintText, Format('%-10.10s', [MainForm.ClientDataSetResults.FieldByName('WTRSQUARE').Text]));
  end
  else
  begin
    Write(PrintText, Format('%-25.25s', ['    ']));
    Printer.Canvas.Font.Style := [];
    Write(PrintText, Format('%-10.10s', ['   ']));
  end;
  Printer.Canvas.Font.Style := [];
//  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_SPSelFileName)]));
  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_ADFullPathName)])); // Echo AD file name.

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', [' ']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [' ']));
  Printer.Canvas.Font.Style := [fsBold];
  if MainForm.ClientDataSetResults.FieldByName('BEST').AsBoolean then
  begin
    Write(PrintText, Format('%-25.25s', ['    Chi Square:']));
    Printer.Canvas.Font.Style := [];
    Write(PrintText, Format('%-10.10s', [MainForm.ClientDataSetResults.FieldByName('WTCHISQ').Text]));
  end
  else
  begin
    Write(PrintText, Format('%-25.25s', ['    ']));
    Printer.Canvas.Font.Style := [];
    Write(PrintText, Format('%-10.10s', ['    ']));
  end;
  Printer.Canvas.Font.Style := [];
//  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_PRSelFileName)]));
  WriteLn(PrintText, Format('%15.15s', [ExtractFileName(g_PRFullPathName)])); // Echo PR file name.

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['Species Array:']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [MainForm.ClientDataSetResults.FieldByName('SPECIESFIT').Text]));
  Printer.Canvas.Font.Style := [fsBold];
  if MainForm.ClientDataSetResults.FieldByName('BEST').AsBoolean then
  begin
    Write(PrintText, Format('%-25.25s', ['    % Mass:']));
    Printer.Canvas.Font.Style := [];
    WriteLn(PrintText, Format('%-10.10s', [MainForm.ClientDataSetResults.FieldByName('WTPERCENT').Text]));
  end
  else
  begin
    Write(PrintText, Format('%-25.25s', ['    ']));
    Printer.Canvas.Font.Style := [];
    WriteLn(PrintText, Format('%-10.10s', ['    ']));
  end;

  Printer.Canvas.Font.Style := [fsBold];
  Write(PrintText, Format('%-15.15s', ['Sources Array:']));
  Printer.Canvas.Font.Style := [];
  Write(PrintText, Format('%-15.15s', [MainForm.ClientDataSetResults.FieldByName('SOURCESFIT').Text]));
  Printer.Canvas.Font.Style := [fsBold];
  if MainForm.ClientDataSetResults.FieldByName('BEST').AsBoolean then
  begin
    Write(PrintText, Format('%-25.25s', ['    Fraction Estimate:']));
    Printer.Canvas.Font.Style := [];
    WriteLn(PrintText, Format('%-10.10s', [MainForm.ClientDataSetResults.FieldByName('WTFRACTION').Text]));
  end
  else
  begin
    Write(PrintText, Format('%-25.25s', ['    ']));
    Printer.Canvas.Font.Style := [];
    WriteLn(PrintText, Format('%-10.10s', ['   ']));
  end;

  // RW 7-21-2000 - added single separator line to replace 5 blank lines.
  Printer.Canvas.Font.Style := [];
  WriteLn(PrintText, ' ');

  // Each of the following 3 sections should be conditional on the active page.
  // RW 6-21-2000 - this is where the data from the left-most tab is printed.
  if MainForm.PageControlResults.ActivePage = MainForm.TabSheetSummary then
  begin
    // Use bold for section headings (normally); also for first 5 lines if
    // non-convergent.
    Printer.Canvas.Font.Style := [fsBold];

    for I := 0 to MainForm.DBMemoSummary.Lines.Count - 1 do
    begin
      if (Pos('SPECIES CONCENTRATIONS:', MainForm.DBMemoSummary.Lines[I]) > 0)
        or (Pos('FITTING STATISTICS', MainForm.DBMemoSummary.Lines[I]) > 0)
        or (Pos('SOURCE CONTRIBUTION ESTIMATES', MainForm.DBMemoSummary.Lines[I]) > 0) then
      begin
        Printer.Canvas.Font.Style := [fsBold];
      end;
      WriteLn(PrintText, MainForm.DBMemoSummary.Lines[I]);
      if (I > 4)
        or (Pos('SPECIES CONCENTRATIONS:', MainForm.DBMemoSummary.Lines[I]) > 0)
        or (Pos('FITTING STATISTICS', MainForm.DBMemoSummary.Lines[I]) > 0)
        or (Pos('SOURCE CONTRIBUTION ESTIMATES', MainForm.DBMemoSummary.Lines[I]) > 0) then
      begin
        Printer.Canvas.Font.Style := [];
      end;
    end;
  end
  else if MainForm.PageControlResults.ActivePage = MainForm.TabSheetContributions then
  begin
    // RW 6-21-2000 - this is where the data from the middle tab are printed.
    Printer.Canvas.Font.Style := [fsBold];
    WriteLn(PrintText, Format('%-35.35s', ['Contributions by Species:']));
    Printer.Canvas.Font.Style := [];
    for I := 2 to MainForm.DBMemoContributions.Lines.Count - 1 do
      WriteLn(PrintText, MainForm.DBMEMOcontributions.Lines[I]);
  end
  else if MainForm.PageControlResults.ActivePage = MainForm.TabSheetMPIN then
  begin
    // RW 6-21-2000 - this is where the data from the right-most tab are printed.
    Printer.Canvas.Font.Style := [fsBold];
    WriteLn(PrintText, Format('%-35.35s', ['MPIN Matrix:']));
    Printer.Canvas.Font.Style := [];
    for I := 2 to MainForm.DBMemoMPIN.Lines.Count - 1 do
      WriteLn(PrintText, Trim(MainForm.DBMemoMPIN.Lines[I]));
  end;
end;

procedure TPrintOptionsForm.BitBtnOKClick(Sender: TObject);
var
  printToFile:boolean;
begin
  // If either or both of the check boxes on either of the tabSheets is checked,
  // then user wants to print to file...
  printToFile := (CheckBoxPrintToFile.Checked = true) or
                  (CheckBox2PrintToFile.Checked = true);

  if printToFile = false then
  begin
    // Only display this dialog if the user is not printing to the file:
    if PrinterSetupDlg.Execute = false then
    begin
      ModalResult := mrCancel;
      fCloseFormOk := false;
      exit;
    end
    else
    begin
      ModalResult := mrOk;
      fCloseFormOk := true;
    end;
  end
  else
  begin
    ModalResult := mrOk;
    fCloseFormOk := true;
  end;
end;

procedure TPrintOptionsForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  // Enable dialog to close:
  CanClose := fCloseFormOk;
end;

procedure TPrintOptionsForm.FormCreate(Sender: TObject);
begin
  fCloseFormOk := true;
end;

procedure TPrintOptionsForm.BitBtnCancelClick(Sender: TObject);
begin
  fCloseFormOk := true;
  // Button has mrCancel set in its modalResult, which will
  // be reflected to forms modalResult, so no need to set.
end;

end.
