// =============================================================================
// A dialog which lets the user save either one result or many results.

unit SaveResultsFrm;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Buttons;

type
  TSaveResultsForm = class(TForm)
    RadioGroupRange: TRadioGroup;
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;

  private
    // Private declarations.
    FResultsFile: TextFile;
    procedure SaveResults(Option: Integer);
    procedure SaveCurrent;
  public
    // Public declarations.
    procedure SaveSomeControl;
  end;

var
  SaveResultsForm: TSaveResultsForm;

implementation

uses
  MainFrm,
  CMB82Internals;

{$R *.DFM}

// Save one or a suite of results.
procedure TSaveResultsForm.SaveSomeControl;
var
  OutputFileFormatIndex : integer;
  SaveTheOnlyResult: Boolean;
begin
  // JS 09-09-04 SaveOptionsDlg := TSaveResultsForm.Create(Self);
  OutputFileFormatIndex := MainForm.ComboBoxOutputFileFormat.ItemIndex; // added 9/27/03

  if MainForm.ClientDataSetResults.RecordCount = 1 then
    SaveTheOnlyResult := True
  else
  begin
    SaveTheOnlyResult := False; // a suite of results may be saved
    // This brings up Save Results|Range|Current Record or All Queued Records dialog
    ShowModal;
  end;

  // in either case - 1 result or a range:
  // JS 09-09-04  if SaveTheOnlyResult or (SaveOptionsDlg.ModalResult = mrOK) then
  if SaveTheOnlyResult or (ModalResult = mrOK) then
  begin // Set save dialog filter here:
    MainForm.SaveDialogResults.Filter := MainForm.ComboBoxOutputFileFormat.Text;
    MainForm.SaveDialogResults.FileName := ''; // Clear out the FileName pane in
                                               // case user selects a different
                                               // Output Format during the same session.
    case OutputFileFormatIndex of
      0: MainForm.SaveDialogResults.DefaultExt := 'txt';
      1: MainForm.SaveDialogResults.DefaultExt := 'csv';
    end;

    ShowMessage ('NOTE:  The Save Results dialog that appears next will reflect the' + #10 +
                 '             Output File Format selected on the Options tab ->' + #13#13
                 + MainForm.ComboBoxOutputFileFormat.Text + #13#13 +
                 'The appropriate extension will be appended automatically.');

    if MainForm.SaveDialogResults.Execute then // brings up Save Results DialogBox
    begin
      // Allow saving current or all queued results IF > 1 result's in the queue.
      if not SaveTheOnlyResult then
      begin
        //-JS 09/09/04 - SaveResults(SaveOptionsDlg.RadioGroupRange.ItemIndex)
        SaveResults(RadioGroupRange.ItemIndex)
      end
      else // There's only one result to save; ModalResult = 0
      begin
        SaveResults(0);
      end;
    end;
  end
  else
  begin
    // Cancel
  end;
end;

procedure TSaveResultsForm.SaveResults(Option: Integer);
var
  InitialRecord: Integer;
begin
  AssignFile(FResultsFile, MainForm.SaveDialogResults.FileName);
  ReWrite(FResultsFile);
  WriteLn(FResultsFile, g_Header); // Insert the header ToF
  // Option is set as ItemIndex, passed from Save Results Range dialog
  if Option = 0 then // Save current only.
    begin
      SaveCurrent;
    end
  else
  begin              // Save all.
    InitialRecord := MainForm.ClientDataSetResults.RecNo; // Note the record of the current Results view
    MainForm.ClientDataSetResults.First;
    while not MainForm.ClientDataSetResults.EoF do
    begin                                         // once for each queued record
      SaveCurrent;
      MainForm.ClientDataSetResults.Next;
    end;
    MainForm.ClientDataSetResults.RecNo := InitialRecord; // reset RecNo so Results view is restored
  end;
  CloseFile(FResultsFile);
end;

procedure TSaveResultsForm.SaveCurrent; // once for each retained sample
var
  I: Integer;
begin
  // MainForm.DBRichCMBoutDB.Lines.Count represents the count of the last line of the active record
  for I := 0 to MainForm.DBRichCMBoutDB.Lines.Count - 1 do
  begin
    Write(FResultsFile, MainForm.DBRichCMBoutDB.Lines[I]);
  end;
  WriteLn(FResultsFile); // Separate results from different samples. -TC 10/03
end;

end.
