// =============================================================================
// The first form shown when the application starts up.

unit StartupFrm;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Variants,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Buttons;

type
  TStartupResultType = (srtCancelled, srtOKControlFileOk, srtOKControlFileCancel, srtOKSelCtrlFile, srtCancelSelCtrlFile);
  TStartupForm = class(TForm)
    ImageIcon: TImage;
    LabelTitle: TLabel;
    RadioGroupStartupOptions: TRadioGroup;
    BitBtnOK: TBitBtn;
    BitBtnAbort: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure BitBtnOKClick(Sender: TObject);
    procedure BitBtnAbortClick(Sender: TObject);
  private
    // Private declarations.
    fStartupResultType: TStartupResultType;
  public
    // Public declarations.
    property StartupResultType: TStartupResultType read fStartupResultType;
  end;

var
  StartupForm: TStartupForm;

implementation

{$R *.DFM}

uses
  MainFrm;

procedure TStartupForm.FormCreate(Sender: TObject);
begin
  Caption := Application.Title + ' Startup';
end;

// FUseControlFile is a switch for whether a Control File is in use.
// It's used in MainFrm by procs IN8Click & PageControlMainChanging
procedure TStartupForm.BitBtnOKClick(Sender: TObject);
const
  kUseControlFile = 0;
  kSelectControlFile = 1;
var
  loadFileResult: boolean;
begin
  loadFileResult := false;
  Hide;

  case RadioGroupStartupOptions.ItemIndex of
    // user selected from radio button group to use a control file.
    kUseControlFile:
      begin                                          // Control File option selected
        MainForm.UseControlFile := true;
        // 09/13/04 - was this    MainForm.SpeedButtonIN8.Click // Stimulates a mouse click on the SpeedButton
        // Now using a function to return result to us:
        loadFileResult := MainForm.LoadIn8File;;
        if loadFileResult = true then
          fStartupResultType := srtOkControlFileOK
        else
          fStartupResultType := srtOKControlFileCancel;
      end;

    // user picked from radio button group to select their own control files
    kSelectControlFile:
      begin
        MainForm.UseControlFile := false;
        MainForm.PageControlMain.Visible := True; // This line is critical to enable the next line, so we retain it
        MainForm.ActiveControl := MainForm.EditAmbientData;
        MessageDlg(
          'You have opted NOT to use a Control File.' + #10#10 +
          'Careful judgement should be exercised in the selection of compatible input files.'
          + #10 +
          'Review Section 4 of the Users Manual for details on file compatibility issues.',
          mtWarning,
          [mbOK],
          0);
        fStartupResultType := srtOKSelCtrlFile;
      end;
    else
      ShowMessage ('Error in selection of StartupOptions index');
  end;

end;

procedure TStartupForm.BitBtnAbortClick(Sender: TObject);
begin
  fStartupResultType := srtCancelled;
  Hide;
  MainForm.MenuItemFileExitClick(Sender);
end;

end.