** $Id: rdminf.for 1.2 1997/10/02 15:20:32 LEM release $
      SUBROUTINE RDMINF (METINF, IU1, STNAMA, LATSTA, ALTSTA,
     &                   IMNST , INSTAT)

*     Reads in meteo.inf file and returns stations names, latitudes
*     and altitudes.

*     METINF - File name of index of reference weather file            I
*     IU1    - Unit number by which index file can be opened           I
*     STNAMA - Array with station names                                O
*     LATSTA - Array with latitudes                                    O
*     ALTSTA - Array with altitudes                                    O
*     IMNST  - Maximum number of stations that can be read             I
*     INSTAT - Number of stations found on index file                  O

*     Must be linked with object library TTUTIL.

*     Author: Daniel van Kraalingen
*     Date  : July 1992

*     formal parameters
      IMPLICIT REAL (A-Z)
      INTEGER IU1, IMNST, INSTAT
      REAL LATSTA(IMNST), ALTSTA(IMNST)
      CHARACTER*(*) METINF
      CHARACTER*8 STNAMA(IMNST)

**    local parameters
      INTEGER IL1, ILEN, IOS, IREC, IDUM
      CHARACTER LINE*80
      SAVE

*     open meteo.inf file
      CALL LOWERC (METINF)
      IL1 = ILEN (METINF)
      WRITE (*,'(2A)') ' Opening input file : ',METINF(1:IL1)
*     record length in bytes : 80
      CALL FOPENG  (IU1,METINF,'OLD','FD',80,' ')

*     read in meteostation data into arrays until end_of_file
      IOS  = 0
      IREC = 1
10    IF (IOS.EQ.0) THEN
         READ (IU1,'(A)',REC=IREC,IOSTAT=IOS) LINE
         IF (IOS.EQ.0) THEN
            STNAMA(IREC) = '000'//LINE(2:6)
            READ (LINE(41:46),'(F6.2)') LATSTA(IREC)
            READ (LINE(53:59),'(F7.1)') ALTSTA(IREC)
            IREC = IREC+1
            IF (IREC.GT.IMNST) CALL ERROR ('RDRFIN',
     &        'array sizes not sufficient to hold meteo station data')
         ELSE
            IREC = IREC-1
         END IF
      GOTO 10
      END IF

      CLOSE (IU1)
      INSTAT = IREC

      RETURN
      END
