** $Id: watpp.for 1.2 1997/10/02 15:20:36 LEM release $
      SUBROUTINE WATPP
     &             (ITASK , DELT, IAIRDU, EVWMX, EVSMX, TRA, SM)


*     In this routine the variables of the soil water balance in the
*     potential production situation are calculated. The purpose is to 
*     quantify the crop water requirements for continuous growth without 
*     drought stress. It is assumed that the soil is permanently at field 
*     capacity.


* VARIABLE TYPE Description                                      Units   I/O

*  ITASK   I*4  flag to control task to be performed                       I
*               1, initialization
*               2, rate calculation, save dynamic output
*               3, integration, summation
*               4, finish section, save final output
*  DELT    R*4  time step (= 1 day)                                d       I
*  IAIRDU  I*4  indicates presence(1) or absence(0) of airducts            I
*               in the roots. 1= can tolerate waterlogging 
*  SM0     R*4  soil porosity                                    cm3 cm-3  I
*  SMFCF   R*4  soil moisture content at field capacity          cm3 cm-3  I
*  SMW     R*4  soil moisture content at wilting point           cm3 cm-3  I
*  EVWMX   R*4  maximum evaporation rate from shaded water surface cm d-1  I
*  EVSMX   R*4  maximum evaporation rate from shaded soil surface  cm d-1  I
*  TRA     R*4  actual transpiration rate                          cm d-1  I
*               Note: TRA is calculated in EVTRA called by CROPSI
*  SM      R*4  actual soil moisture content                     cm3 cm-3  O

*     Author: C.A. van Diepen, February 1989, revised July 1990

*     Subroutine WATPP is derived from subroutine APPLE of WOFOST Version 4.1.
*     WATPP is called by WOFSIM.

*     declarations
      IMPLICIT REAL(A-Z)
      INTEGER IAIRDU, ITASK, ITOLD
*      CHARACTER SOFILE*(*)

*     Python COMMON block      
      COMMON /CWATPP/ TRAT,EVWT,EVST,EVS,EVW,ITOLD

*     Python COMMON block with soil specific variables
      COMMON /SOILVAR/ SM0, SMFCF, SMW, CRAIRC, SOPE, KSUB, K0
**
      SAVE

      DATA ITOLD /4/

Cf2py intent(in) ITASK, DELT, EVWMX, EVSMX, TRA
Cf2py intent(in,out) SM


*     immediate return of execution when previous task was initialization
      IF (ITASK.EQ.3.AND.ITOLD.EQ.1) THEN
         ITOLD = ITASK
         RETURN
      END IF

      IF (ITASK.EQ.1) THEN

*----------------------------------------------------------------------
*     initial section
*----------------------------------------------------------------------

         SM    = SMFCF

*        all summation variables of the water balance are set at zero.
         TRAT = 0.
         EVST = 0.
         EVWT = 0.

*        all rates are set at zero
         EVS = 0.
         EVW = 0.

      ELSE IF (ITASK.EQ.2) THEN

*-----------------------------------------------------------------------
*        rates of the water balance
*-----------------------------------------------------------------------

*        N.B.: transpiration rate is calculated in EVTRA called by CROPSI
*        evaporation rate from soil (non-rice) or water surface (rice)
         EVS = 0.
         EVW = 0.
         IF (IAIRDU.EQ.0) EVS = EVSMX*(SMFCF-SMW/3.)/(SM0-SMW/3.)
         IF (IAIRDU.EQ.1) EVW = EVWMX

      ELSE IF (ITASK.EQ.3) THEN

*-----------------------------------------------------------------------
*        dynamic calculations
*        integrals of the water balance:  summation and state variables
*-----------------------------------------------------------------------

*        total transpiration
         TRAT = TRAT + TRA*DELT
*        total evaporation from surface water layer and/or soil
         EVWT = EVWT + EVW*DELT
         EVST = EVST + EVS*DELT

*        soil permanently at field capacity under potential production :
         SM   = SMFCF

      ELSE IF (ITASK.EQ.4) THEN

*-----------------------------------------------------------------------
*        finish section
*-----------------------------------------------------------------------

      END IF

      ITOLD = ITASK

      RETURN
      END
