* $Id: fseopt.for 1.3 1998/06/18 16:22:09 unknown release $
* error op there geeft problemen (ilen toevoegen) !!

*-----         Program FSEOPT - january 1995
*                       version 2.1
*              - Willem Stol and Doug Rouse -
*                     
*          FORTRAN - Utility library TTUTIL: version 3.4
*         - D.W.G. van Kraalingen and C. Rappoldt -
*
*    +----------------------------------------------------------------+ 
*    | MODIFICATION                                                   |
*    | author:       Hendrik Boogaard                                 |
*    | date:         02-06-1998                                       |
*    | reason:       option running FSE (WOFOST) without FSEOPT       |
*    | modification: - read IOPT2 to know the mode (FSEOPT or not)    |
*    |               - IF/THEN/ELSE to run FSEOPT or only FSE         |
*    +----------------------------------------------------------------+

      PROGRAM FSEOPT
      IMPLICIT REAL (A-Z)

*-----Maximum number of parameter-sets in calibration procedure

*     WSt, 27/6/95, this value should be larger than, the
*     number of runs required in the initial phase; number
*     of sites times number of parameter sets
      INTEGER IMXNPS
      PARAMETER (IMXNPS=600)

*-----Maximum number of parameters in calibration procedure
      INTEGER IMXPAR
      PARAMETER (IMXPAR=20)

*-----Maximum number of output options in calibration procedure
      INTEGER IMXOUT
      PARAMETER (IMXOUT=4)

*-----Dimension of array with QT-values for each parameter-set
      DIMENSION QT(IMXNPS+1)

*-----Dimension of array with optional output switches
      INTEGER IOUT
      DIMENSION IOUT(IMXOUT)

*-----Character string PARNAM contains the parameter names, array
*     PARVAL the lower and upper bound of each parameter
      CHARACTER*31 PARNAM
      DIMENSION PARNAM(IMXPAR)
      DIMENSION PARVAL(2,IMXPAR)

*-----Dimension of array with pointers to the IMXPAR+1 (at maximum)
*     randomly choosen parameter-sets in the subset
      INTEGER PS(IMXPAR+1)

*-----Array RANGE contains the biological plausible range (upper
*     bound - lower bound) of each parameter
      DIMENSION RANGE(IMXPAR)

*-----Matrix with parameter space, IMXNPS+2 parameter-sets with
*     IMXPAR parameters
      DIMENSION V(IMXNPS+2,IMXPAR)

*-----Declaration of array with indexes of qt-values
      INTEGER INDX(IMXNPS)

*-----Character string with name of input datafile
      CHARACTER*12 OPTFIL

*-----Variables use as output of routine RDSINT
      INTEGER IMETHD

*-----Variables used as unit number for file I/O or counter in do-loops
      INTEGER IUNIT,IUL,I

c     * start adaption FSEOPT, Hendrik Boogaard: 29-05-1998    
      INTEGER   IL1, ILRUN, ILEN, IOPT2
	CHARACTER*80 DIRDAT,RUNDIR,TMPSTR
c     * end adaption FSEOPT, Hendrik Boogaard: 29-05-98  

*-----End of declarations


*     start adaption FSEOPT, Hendrik Boogaard: 29-05-1998
*     read specific directory name 
      DIRDAT = 'direct.dat'
      IL1 = ILEN(DIRDAT)
      CALL RDINIT (10,0,DIRDAT(1:IL1))
      CALL RDSCHA ('RUNDIR',RUNDIR)
      CLOSE (10)

      IF (ILEN(RUNDIR).EQ.0) THEN
	  CALL ERROR ('FSEOPT', 'RUNDIR is empty')
      ENDIF
*     read switch IOPT2 from runopt.dat
      ILRUN = ILEN (RUNDIR)
      TMPSTR = RUNDIR(1:ILRUN)//'runopt.dat'
      CALL LOWERC (TMPSTR)
      CALL RDINIT (10, 0, TMPSTR)
      CALL RDSINT ('IOPT2' , IOPT2 )
*     determine mode: FSEOPT or just FSE (WOFOST)
      IF (IOPT2.EQ.5) THEN
*     end adaption FSEOPT, Hendrik Boogaard: 29-05-1998


*        FSEOPT

*--------Initial section

*--------Unit numbers for file I/O
         IUNIT = 60

*--------Log file is inactive, if IUL equals 0
         IUL = 0

*--------Filename from file with definitions of optimization
*        algorithm
         OPTFIL = 'OPTIM.DEF'

*--------Read variables which defines the optimization method,
*        tolerance of QT-values and output options
         CALL RDINIT (IUNIT, IUL, OPTFIL)
         CALL RDSINT ('IMETHD',IMETHD)
         CALL RDSREA ('FTOL'  ,FTOL)
         CALL RDAINT ('IOUT'  ,IOUT ,IMXOUT,I)
         CLOSE (IUNIT, STATUS='DELETE')

*--------Optimization methods:
*        1:  Global random search algorithm according to Price
*        2:  Local optimization algorithm downhill-simplex
*            according to Nelder & Mead

         IF (IMETHD.EQ.1) THEN

            CALL PRICE (IMXNPS,IMXOUT,IMXPAR,QT,IOUT,
     $                  PARNAM,PARVAL,PS,RANGE,V,FTOL,INDX)

         END IF


*     start adaption FSEOPT, Hendrik Boogaard: 29-05-1998
      ELSE IF (IOPT2.NE.5) THEN
         CALL FSE
      END IF 
*     end adaption FSEOPT, Hendrik Boogaard: 29-05-1998


      END

      SUBROUTINE PRICE (IMXNPS,IMXOUT,IMXPAR,QT,IOUT,
     $                  PARNAM,PARVAL,PS,RANGE,V,FTOL,INDX)
      IMPLICIT REAL (A-Z)

*-----Declaration of variables in parameter list
      INTEGER   IMXNPS,IMXOUT,IMXPAR
      DIMENSION QT(IMXNPS+1)
      INTEGER   IOUT
      DIMENSION IOUT(IMXOUT)
      CHARACTER*31 PARNAM
      DIMENSION PARNAM(IMXPAR)
      DIMENSION PARVAL(2,IMXPAR)
      INTEGER   PS
      DIMENSION PS(IMXPAR+1)
      DIMENSION RANGE(IMXPAR)
      DIMENSION V(IMXNPS+2,IMXPAR)

*-----Declaration of array with indexes of qt-values
      INTEGER INDX(IMXNPS)

*-----Integer variables output of FUNC
      INTEGER INFND,INPS,INT,IBOUND,INRR

*-----Variables used as pointer in array with QT-values
      INTEGER IPNT1,IPNT2,PST

*-----Variable ITASK specifies tasks to modules
      INTEGER ITASK

*-----Variables used as counter in do-loops
      INTEGER I,ITER,J,K

*-----Logical variables which check whether new parameter-sets
*     are within or outside BPR's (Biological Plausible Range)
      LOGICAL MORE,LESS

*-----End of declarations

      SAVE

*-----Section in which:
*
*     * parameter-sets are generated
*
*     * FSE is instructed to perform model calculations
*       with these parameter-sets
*
*     * Model-output is compared to experimental data

*-----Execute initial runs and compare with experimental data
      ITASK = 1
      DUMMY = FUNC (ITASK,IMXNPS,IMXPAR,IBOUND,INT,INPS,INFND,
     $              INRR,QT,PARNAM,PARVAL,RANGE,V,INDX)

*-----Write initial parameter-sets and corresponding QT-values to
*     output-file
      IF (IOUT(1).EQ.1) THEN
         ITASK = 4
         DUMMY = FUNC (ITASK,IMXNPS,IMXPAR,IBOUND,INT,INPS,INFND,
     $                 INRR,QT,PARNAM,PARVAL,RANGE,V,INDX)
      END IF

*-----Section in which iterative new parameter-sets are generated and
*     FSE is instructed to perform model calculations with the new
*     parameter-set.

*-----Write message to screen to monitor program execution
      WRITE (*,'(/,A,I5,A)') ' Price algorithm, execution of ',
     $       INT*(INRR/INPS),' (iterative) runs'

*-----number of iterations of optimization algorithm
      DO 100 ITER = 1,INT

10    CONTINUE
      PS(1) = NINT(UNIFL()*INPS+0.5)
      I = 2
15    IF (I.LE.(INFND+1)) THEN
20       PST = NINT(UNIFL()*INPS+0.5)
         DO J = 1,I-1
            IF (PST.EQ.PS(J)) GO TO 20
         END DO
         PS(I) = PST
         I = I + 1
      GO TO 15
      END IF

*-----Calculate new parameter set
      MORE = .FALSE.
      LESS = .FALSE.

*-----Calculate average values of each parameter for the INFND
*     randomly choosen parameter sets
      DO I = 1,INFND
         PSUM = 0.
         DO K = 1,INFND
            J = PS(K)
            PSUM = PSUM + V(J,I)
         END DO
         V(IMXNPS+2,I) = PSUM/INFND
      END DO

*-----Use formula: V(J,I) = 2.0 * V(IMXNPS+2,I) - V(PS(INFND+1),I),
*     where V(PS(INFND+1),I) is a parameter set choosen from the
*     INPS-INFND remaining unchoosen sets. PS(INFND+1) is the
*     INFND+1 parameter set selected at random in array PS

      DO I = 1,INFND
*        value is lower bound value plus range*unifl()
         V(IMXNPS+1,I) = 2.0 * V(IMXNPS+2,I) - V(PS(INFND+1),I)

*        Set logical names to false if the calculated parameter
*        value falls outside parameter bounds
         LESS = V(IMXNPS+1,I).LT.PARVAL(1,I)
         MORE = V(IMXNPS+1,I).GT.PARVAL(2,I)

*        Check to see if parameter sets with parameter values
*        out of bounds are going to be discarded (IBOUND=0) or
*        set to the bound (IBOUND<>0)
         IF (IBOUND.EQ.0) THEN
            IF (MORE.OR.LESS) GO TO 10
         ELSE IF (LESS) THEN
            V(IMXNPS+1,I) = PARVAL(1,I)
         ELSE IF (MORE) THEN
            V(IMXNPS+1,I) = PARVAL(2,I)
         END IF
      END DO

      ITASK = 3
      DUMMY = FUNC (ITASK,IMXNPS,IMXPAR,IBOUND,INT,INPS,INFND,
     $              INRR,QT,PARNAM,PARVAL,RANGE,V,INDX)

*-----Search all the parameter sets for the set with the highest QT-value
      CALL HIGHLO (IMXNPS,INPS,IPNT1,IPNT2,QT,QTLOW,QTHIGH)

*-----Discard the parameter set with the highest QT-value with the new
*     QT-value, if better, the old parameter-values with the new ones
*     and the accompanying simulation-output in matrix SIM
      IF (QT(IMXNPS+1).LE.QT(IPNT1)) THEN
         QT(IPNT1) = QT(IMXNPS+1)
         DO I = 1,INFND
            V(IPNT1,I) = V(IMXNPS+1,I)
         END DO
         ITASK = 8
         DUMMY = FUNC (ITASK,IMXNPS,IMXPAR,IBOUND,INT,INPS,INFND,
     $                 INRR,QT,PARNAM,PARVAL,RANGE,V,INDX)
      END IF

      RTOL = 2. * ABS(QTHIGH-QTLOW)/(ABS(QTHIGH)+ABS(QTLOW)+1E-20)

*      IF (MOD(ITER,25).EQ.0) THEN
      IF (MOD(ITER,10).EQ.0) THEN
          CALL WRSTAT (ITER,RTOL,QTLOW,QTHIGH)
      ELSE IF (RTOL.LE.FTOL) THEN
          WRITE (*,'(/,1X,A)')
     $      ' Tolerance of QT-values met criterion: Optimization stops'
          CALL WRSTAT (ITER,RTOL,QTLOW,QTHIGH)
          GO TO 110
      END IF

100   CONTINUE

      CALL WRSTAT (ITER,RTOL,QTLOW,QTHIGH)

110   CONTINUE

*-----Write final parameter-sets and corresponding qt-values to
*     output-file
      IF (IOUT(2).EQ.1) THEN
         ITASK = 5
         DUMMY = FUNC (ITASK,IMXNPS,IMXPAR,IBOUND,INT,INPS,INFND,
     $                 INRR,QT,PARNAM,PARVAL,RANGE,V,INDX)
      END IF

      RETURN
      END

      REAL FUNCTION FUNC (ITASK,IMXNPS,IMXPAR,
     $                    IBOUND,INT,INPS,INFND,INRR,
     $                    QT,PARNAM,PARVAL,RANGE,V,INDX)
      IMPLICIT REAL (A-Z)

*-----Declaration of variables in parameter list
      INTEGER ITASK,IMXNPS,IMXPAR,IBOUND
      INTEGER INT,INPS,INFND

*-----MICROSOFT FORTRAN V 5.1 / VAX FORTRAN V 5.6-199
      INCLUDE 'DIMENS.INC'

*-----Dimension of array with values of model performance for each
*     rerun
      DIMENSION QT(IMXNPS+1)

*-----Dimensions of parameter space, IMXNPS+1 parameter-sets
*     with IMXPAR parameters
      DIMENSION V(IMXNPS+2,IMXPAR)

*-----Array with names of parameters are stored in the variable
*     PARNAM the corresponding BPR's (Biological Plausible Ranges)
*     in array PARVAL
      CHARACTER*31 PARNAM
      DIMENSION PARNAM(IMXPAR)
      DIMENSION PARVAL(2,IMXPAR)
      DIMENSION RANGE(IMXPAR)

*-----Arrays with number of weather stations, number of year,
*     start and harvest data and number of harvest per dataset
      INTEGER INRR

*-----Declaration of array with indexes of qt-values
      INTEGER INDX(IMXNPS)

*-----Parameter in calculation method model performance
      INTEGER IQT

*-----Number of experimental sites taken into account
*     in the calibration procedure
      INTEGER NSITES

*-----Dimension of array with aggregated values of model
*     performance for each measured variable
      DIMENSION MPF(IMXNDP)

*-----Dimension of array with sums of observed data and
*     residuals between observed and measured data
      DIMENSION SUM(2,IMXNDP)

*-----Variables used as counter in do-loops
      INTEGER I,J,K,M

*-----Logical variables which check whether new parameter-sets
*     are within or outside BPR's (Biological Plausible Range)
      LOGICAL MORE,LESS

      LOGICAL INIT

*-----Dimension of array in common block with plant-module
      DIMENSION SIM(IMXNRR+IMXNDS,IMXHVS,IMXNDP)
      DIMENSION OBSERV(IMXNRR+IMXNDS,IMXHVS,IMXNDP)

*-----Integer declaration for variables in common block
      INTEGER II

*-----Common block common with submodule under FSE-driver
*     SIM is an matrix with the simulated data and has the
*     dimension number of datasets, number of harvests,
*     number of replicates, number of datapoints
      COMMON /SUB/ SIM, OBSERV, II

*-----End of declarations

      SAVE

      DATA INIT /.FALSE./

      IF (.NOT.INIT) THEN

         DO J = 1,IMXNRR+IMXNDS
            DO K = 1,IMXHVS
               DO M = 1,IMXNDP
                  SIM(J,K,M) = 0.
               END DO
            END DO
         END DO

      INIT = .TRUE.
      END IF

      IF (ITASK.EQ.1) THEN

*-----   Write rerun-file with the appropriate parameter-values
         CALL WRRRUN (ITASK,IMXHVS,IMXNDS,IMXNPS,IMXPAR,
     $                INFND,INPS,INRR,
     $                IBOUND,INT,
     $                PARNAM,PARVAL,RANGE,
     $                V,IQT,OBSERV,IMXNDP,
     $                IMXNRR,NSITES)

*-----   Write message to screen to monitor program execution
         WRITE (*,'(/,A,I6,A)') ' Price algorithm, execution of ',
     $                            INRR, ' (initial) runs'

*-----   Calculate QT for each parameter set
         II = 1

         CALL FSE

*-----   Instruct COMP to read experimental data from file, to ini-
*        tialize a matrix with them and this calculate the performance
*        of the initial model-runs against the experimental data
         CALL COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $              II,QT,MPF,OBSERV,SIM,SUM,IQT,NSITES)

      ELSE IF (ITASK.EQ.2) THEN

*-----   Write rerun-file with the appropriate parameter-values
         CALL WRRRUN (ITASK,IMXHVS,IMXNDS,IMXNPS,IMXPAR,
     $                INFND,INPS,INRR,IBOUND,INT,
     $                PARNAM,PARVAL,RANGE,V,IQT,OBSERV,IMXNDP,
     $                IMXNRR,NSITES)

*-----   Write message to screen to monitor program execution
         WRITE (*,'(/,A,I4,A)') ' Simplex algorithm, execution of ',
     $                            INRR, ' (initial) runs'

*-----   Execute a simulation run with the calculated parameter-sets
*        simulated data are filled on pointers 1:INFND+1
         II = 1

         CALL FSE

*-----   Calculate the model performance against the experimental data
         INPS = INFND+1
         ITASK = 1
         CALL COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $              II,QT,MPF,OBSERV,SIM,SUM,IQT,NSITES)
         ITASK = 2

      ELSE IF (ITASK.EQ.3) THEN

*        Check to see if the calculated parameter value is out of
*        bounds of possible values, if so set logical names to false
         DO I = 1,INFND
            LESS = V(IMXNPS+1,I).LT.PARVAL(1,I)
            MORE = V(IMXNPS+1,I).GT.PARVAL(2,I)
            IF (MORE.OR.LESS) THEN
               FUNC = 1.0E+3
               RETURN
            END IF
         END DO

*-----   Write rerun-file with the appropriate parameter-values
         II = IMXNPS+1

         CALL WRRRUN (ITASK,IMXHVS,IMXNDS,IMXNPS,IMXPAR,
     $                INFND,INPS,INRR,
     $                IBOUND,INT,
     $                PARNAM,PARVAL,RANGE,
     $                V,IQT,OBSERV,IMXNDP,
     $                IMXNRR,NSITES)

*-----   Execute a simulation run with the calculated parameter-set
*        simulated data are filled on pointer IMXNPS+1
         CALL FSE

*-----   Calculate the model performance against the experimental data
         ITASK = 2

*-----   After the run of the model the pointer II is reset to IMXNPS+1
         II = IMXNPS+1
         CALL COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $              II,QT,MPF,OBSERV,SIM,SUM,IQT,NSITES)
         ITASK = 3
         FUNC = QT(IMXNPS+1)

      ELSE IF (ITASK.EQ.4) THEN

         ITASK = 1
         CALL OUTPUT (ITASK,INFND,INPS,QT,PARNAM,V,IMXNPS,IMXPAR,
     $                INDX)

      ELSE IF (ITASK.EQ.5) THEN

         ITASK = 2
         CALL OUTPUT (ITASK,INFND,INPS,QT,PARNAM,V,IMXNPS,IMXPAR,
     $                INDX)

      ELSE IF (ITASK.EQ.6) THEN

         ITASK = 4
         CALL COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $              II,QT,MPF,OBSERV,SIM,SUM,IQT,NSITES)
         ITASK = 3
         CALL OUTPUT (ITASK,INFND,INPS,QT,PARNAM,V,IMXNPS,IMXPAR,
     $                INDX)

      ELSE IF (ITASK.EQ.7) THEN

         ITASK = 4
         CALL COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $              II,QT,MPF,OBSERV,SIM,SUM,IQT,NSITES)
         CALL OUTPUT (ITASK,INFND,INPS,QT,PARNAM,V,IMXNPS,IMXPAR,
     $                INDX)

      ELSE IF (ITASK.EQ.8) THEN

         II = IMXNPS+1
         ITASK = 3
         CALL COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $              II,QT,MPF,OBSERV,SIM,SUM,IQT,NSITES)

      END IF

      RETURN
      END

      SUBROUTINE WRRRUN (ITASK,IMXHVS,IMXNDS,IMXNPS,IMXPAR,
     $                   INFND,INPS,INRR,
     $                   IBOUND,INT,
     $                   PARNAM,PARVAL,RANGE,
     $                   V,IQT,OBSERV,IMXNDP,
     $                   IMXNRR,NSITES)
*    +----------------------------------------------------------------+ 
*    | MODIFICATION                                                   |
*    | author:       Hendrik Boogaard                                 |
*    | date:         02-06-1998                                       |
*    | reason:       coupling WOFOST with FSEOPT                      |
*    | modification: - read name + directory rerun file from other    |
*    |                 input files of WOFOST							|
*    +----------------------------------------------------------------+


      IMPLICIT REAL (A-Z)

*-----Declaration of variables in parameter list
      INTEGER ITASK,IMXHVS,IMXNDS,IMXNPS,IMXPAR,INFND
      INTEGER INPS,INRR,IBOUND,INT,IQT,IMXNDP
      INTEGER IMXNRR   

*-----Variables with names of datafiles
      CHARACTER*12 OPTFIL, PARFIL, OBSFIL

*-----Variable used as parameter in RDSINT
      INTEGER IMETHD

*-----Number of experimental sites taken into account
*     in the calibration procedure
      INTEGER NSITES

*-----Dimensions of parameter space, IMXNPS+1 parameter-sets
*     with IMXPAR parameters
      DIMENSION V(IMXNPS+2,IMXPAR)

*-----Character string PARNAM contains the parameter names, array
*     PARVAL the lower and upper bound of each parameter
      CHARACTER*31 PARNAM
      DIMENSION PARNAM(IMXPAR)
      DIMENSION PARVAL(2,IMXPAR)
      DIMENSION RANGE(IMXPAR)

*-----Variables used as unit number
      INTEGER IUNIT,IUL,IUNITR

*-----Variables used as unit number for file I/O or counter in do-loops
      INTEGER I,J,K,L

*-----Variables used as argument to subroutine RDFREA
      INTEGER IREQ

*-----Logical variable to check existence of file
      LOGICAL THERE

*-----Logical variable to check status of subroutine
      LOGICAL INIT

*-----Array with character string with names of treatment files
      CHARACTER*80 EXPERIMENTS
      DIMENSION EXPERIMENTS(50)

*-----Name of variables that holds message
      CHARACTER*132 MESSAGE

*-----Array with observed data
      DIMENSION OBSERV(IMXNRR+IMXNDS,IMXHVS,IMXNDP)

*     machine constants and buffer length
*      INCLUDE 'RDMACHIN.INC'

*     Declarations for RD routine data
      INTEGER   ILNDAT,INFDAT
      PARAMETER (ILNDAT=400)
      CHARACTER DATLIS(ILNDAT)*31

c     * start adaption FSEOPT, Hendrik Boogaard: 27-05-98    
c     read directory and filename of the rerun file from
c     input files of WOFOST (FSE)       
      INTEGER   IL1, ILRUN, ILEN
	CHARACTER*80 DIRDAT,RUNDIR,TMPSTR,WOFRER,FILRER
c     * end adaption FSEOPT, Hendrik Boogaard: 27-05-98

*-----End of declarations

      SAVE

      DATA INIT /.FALSE./
      
      IF (.NOT.INIT) THEN

*-----   Unit numbers for file I/O
         IUNIT = 70

*-----   Log file is inactive, if IUL equals 0
         IUL = 0

*-----   Filename from file which defines the optimization
*        characteristics
         OPTFIL = 'OPTIM.DEF'

*-----   Read variables with optimization characteristics
         CALL RDINIT (IUNIT, IUL, OPTFIL)
         CALL RDSINT ('IMETHD' ,IMETHD)
         CALL RDSINT ('IQT'    ,IQT)
         CALL RDSINT ('IBOUND' ,IBOUND)
         CALL RDSINT ('INPS'   ,INPS)
         CALL RDSINT ('INT'    ,INT)
         CLOSE (IUNIT, STATUS='DELETE')

*-----   Filename from parameter definition file
         PARFIL = 'PARAM.DEF'

*-----   Analyse file with parameter-names and BPR's, get
*        names and number of parameters in the file
         CALL RDINIT (IUNIT, IUL, PARFIL)

*        start a loop to test the name of every variable from the
*        input file
         CALL RDINLV (.FALSE.,DATLIS,ILNDAT,INFDAT)

         IREQ = 2
         INFND = INFDAT
         DO I = 1,INFND
            CALL RDFREA (DATLIS(I),PARVAL(1,I),IREQ,IREQ)
            IF (PARVAL(1,I).GT.PARVAL(2,I)) CALL ERROR ('WRRRUN',
     $         'Lower bound exceeds upper bound in PARAM.DEF.')
            PARNAM(I) = DATLIS(I)
         END DO
         CLOSE (IUNIT, STATUS='DELETE')

*-----   Create array containing the multiplication factor used to change
*        the uniform random deviate on the interval 0-1 into a value on
*        the range of the parameter
         DO I = 1,INFND
            RANGE(I) = PARVAL(2,I)-PARVAL(1,I)
         END DO

*-----   Filename from observation definition file
         OBSFIL = 'OBSERV.DEF'

*-----   Input section ; analyse input file
         CALL RDINIT (IUNIT, IUL, OBSFIL)

*-----   Get values from file
         CALL RDACHA ('EXPERIMENTS' , EXPERIMENTS , IMXNDS, NSITES)

         CLOSE (IUNIT,STATUS='DELETE')

         DO J = 1,IMXNRR+IMXNDS
            DO K = 1,IMXHVS
               DO L = 1,IMXNDP
                  OBSERV(J,K,L) = -99.
               END DO
            END DO
         END DO

*-----   check if file with data-set specific constants
*        of first data-set does exist

         DO I = 1,NSITES
            THERE = .FALSE.
            INQUIRE (FILE=EXPERIMENTS(I),EXIST=THERE)
            IF (.NOT.THERE) THEN
               WRITE (MESSAGE,'(3A)')
     &         'Experiment file ',EXPERIMENTS(I),' does not exist !'
               CALL ERROR ('FSEOPT 2.1a',MESSAGE)
            END IF 
         END DO

*-----Set logical variable init to true
         INIT = .TRUE.

      END IF

*-----Write reruns file to enable multiple runs with FSE
c     IUNITR = 80
c     CALL FOPENS(IUNITR,'RERUNS.DAT','NEW','DEL')

c     * start adaption FSEOPT, Hendrik Boogaard: 27-05-98    
c     read directory and filename of the rerun file from
c     input files of WOFOST (FSE)
c     log file is inactive while opening direct.dat and runopt.dat

      DIRDAT = 'direct.dat'
      IL1 = ILEN(DIRDAT)
      CALL RDINIT (10,0,DIRDAT(1:IL1))
      CALL RDSCHA ('RUNDIR',RUNDIR)
      CLOSE (10)

      IF (ILEN(RUNDIR).EQ.0) THEN
	  CALL ERROR ('FSEOPT', 'RUNDIR is empty')
      ENDIF

      ILRUN = ILEN (RUNDIR)
      TMPSTR = RUNDIR(1:ILRUN)//'runopt.dat'
      CALL LOWERC (TMPSTR)
      CALL RDINIT (10, 0, TMPSTR)
      CALL RDSCHA ('WOFRER' , WOFRER )
      CLOSE (10)

      FILRER = RUNDIR(1:ILEN(RUNDIR))//WOFRER
      CALL LOWERC (FILRER)

      IUNITR = 82
      CALL FOPENS(IUNITR,FILRER,'NEW','DEL')

c     * end of adaptation FSEOPT, Hendrik Boogaard: 27-05-98 

*-----Price initial runs
      IF (ITASK.EQ.1) THEN

*-----Number of rerun-sets is n experimental data-sets times
*     n parameter-sets
      INRR = NSITES * INPS

*-----Write headerfile in reruns file
      WRITE (IUNITR,'(A,I4,A)') '*-----Reruns-file: ',INRR,
     $      ' parameter-sets generated by FSEOPT'

*-----Create INRR parameter-sets with INFND parameters
      DO J = 1,INPS

         DO I = 1,INFND
*           value is lower bound value plus range*unifl()
            V(J,I) = PARVAL(1,I)+RANGE(I)*UNIFL()
         END DO

         DO K = 1,NSITES
*           copy dataset specific constants, initial values or
*           functions from file with constants to reruns file
            CALL COPFIL (90,EXPERIMENTS(K),IUNITR)

*           write section with parameter names and values
            WRITE (IUNITR,'(6(1X,4(A7,''='',G13.6,'' ; ''),/))')
     $      (PARNAM(I),V(J,I),I=1,INFND)
         END DO

      END DO

      CLOSE (IUNITR)

*-----Rerun with model within iterative optimization loop
      ELSE IF (ITASK.EQ.3) THEN

*-----Write headerfile in reruns file
      WRITE (IUNITR,'(2A)')  '*-----Reruns-file: 1',
     $      ' parameter-set generated by FSEOPT'

*-----Create for each experimental dataset in the optimization
*     1 parameterset with INFND parameters, get parameter-values
*     at pointer IMXNPS+1 from matrix with parameter-values
      J = IMXNPS+1

      DO K = 1,NSITES
*        copy dataset specific constants, initial values or
*        functions from file with constants to reruns file
         IF (THERE) CALL COPFIL (90,EXPERIMENTS(K),IUNITR)

*        write section with parameter names and values
         WRITE (IUNITR,'(6(1X,4(A7,''='',G13.6,'' ; ''),/))')
     $   (PARNAM(I),V(J,I),I=1,INFND)
      END DO

      END IF
      CLOSE (IUNITR)

      RETURN
      END

      SUBROUTINE COMP (ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR,
     $                 II,QT,MPF,OBSERV,SIM,
     $                 SUM,IQT,NSITES)
      IMPLICIT REAL (A-Z)

*-----Declaration of variables in parameter list
      INTEGER ITASK,IMXHVS,IMXNDP,IMXNDS,IMXNPS,IMXNRR
      INTEGER II,IQT

      DIMENSION QT(IMXNPS+1)

*-----Dimension of array with sums of observed data and
*     residuals between observed and measured data
      DIMENSION SUM(2,IMXNDP)

*-----Dimension of array with aggregated values of model
*     performance for each measured variable
      DIMENSION MPF(IMXNDP)

*-----Array with observed data
      DIMENSION OBSERV(IMXNRR+IMXNDS,IMXHVS,IMXNDP)

*-----Dimension of array in common block with submodule
      DIMENSION SIM(IMXNRR+IMXNDS,IMXHVS,IMXNDP)

      INTEGER NSITES,ITMP,ITMPO

      INTEGER ICOUNT(10)

*-----Variables used as unit number for file I/O or counter in do-loops
      INTEGER I,J,K,L

*-----End of declarations

      SAVE

      IF (ITASK.EQ.1) THEN

*-----calculate sum of differences between experimental and simulated
*     data according to the method choosen in definition file.

         ITMPO = 0

*        reset goodness of fit values for initial parameter sets
         DO J = 1, IMXNPS+1
            QT(J) = 0.
         END DO

         J = 1
         DO WHILE (NINT(OBSERV(J,1,1)).NE.-99.AND.J.LE.IMXNRR+IMXNDS)

            L = 1
            DO WHILE (NINT(OBSERV(J,1,L)).NE.-99.AND.L.LE.IMXNDP)

*              pointer to actual parameterset
               ITMP = ((J-1)/NSITES)+1

*              new parameterset; reset sum of residuals
               IF (ITMP.EQ.ITMPO+1) THEN
                  DO I = 1,IMXNDP
                     SUM(1,I) = 0.
                  END DO
                  ITMPO = ITMP
               END IF

               ICOUNT(L) = 0

               K = 1
               DO WHILE (NINT(OBSERV(J,K,L)).NE.-99.AND.K.LE.IMXHVS)

                  DK = OBSERV(J,K,L)
                  MK = SIM(J,K,L)

                  IF (DK.LT.1.) THEN
                     SUM(1,L) = SUM(1,L)+ABS(DK-MK)**IQT
                  ELSE
*                    SUM(1,L) = SUM(1,L)+ABS((DK-MK)/(DK+1E-8))**IQT
                     SUM(1,L) = SUM(1,L)+ABS(DK-MK)**IQT
                     ICOUNT(L) = ICOUNT(L) + 1
                  END IF

                K = K + 1
                END DO

*               apply the appropriate factor to normalize residuals
                IF (IQT.EQ.1) THEN
                   MPF(L) = SUM(1,L) / REAL(ICOUNT(L))
                ELSE IF (IQT.EQ.2) THEN
                   MPF(L) = SQRT(SUM(1,L)) / REAL(ICOUNT(L))
                END IF

*               pointer to actual parameterset
                ITMP = ((J-1)/NSITES)+1

*               find the maximum of residuals
                QT(ITMP) = AMAX1 (MPF(L),QT(ITMP))

            L = L + 1
            END DO

         J = J + 1
         END DO

      ELSE IF (ITASK.EQ.2) THEN

*-----calculate sum of differences between experimental and simulated
*     data according to the method choosen in definition file.

*        reset sum of residuals of previous parameter set
         DO I = 1,IMXNDP
            SUM(1,I) = 0.
         END DO

*        reset goodness of fit value of parameter set previous tested
         QT(IMXNPS+1) = 0.

         J = II
         DO WHILE (NINT(OBSERV(J,1,1)).NE.-99.AND.J.LE.IMXNRR+IMXNDS)

            L = 1
            DO WHILE (NINT(OBSERV(J,1,L)).NE.-99.AND.L.LE.IMXNDP)

               K = 1
               DO WHILE (NINT(OBSERV(J,K,L)).NE.-99.AND.K.LE.IMXHVS)

                  DK = OBSERV(J,K,L)
                  MK = SIM(J,K,L)

                  IF (DK.LT.1.) THEN
                     SUM(1,L) = SUM(1,L)+ABS(DK-MK)**IQT
                  ELSE
*                     SUM(1,L) =SUM(1,L)+ABS((DK-MK)/(DK+1E-8))**IQT
                     SUM(1,L) =SUM(1,L)+ABS(DK-MK)**IQT
                  END IF

                K = K + 1
                END DO

*               apply the appropriate factor to normalize residuals
                IF (IQT.EQ.1) THEN
                   MPF(L) = SUM(1,L) / REAL(ICOUNT(L))
                ELSE IF (IQT.EQ.2) THEN
                   MPF(L) = SQRT(SUM(1,L)) / REAL(ICOUNT(L))
                END IF

*               find the maximum of residuals
                QT(IMXNPS+1) = AMAX1 (MPF(L),QT(IMXNPS+1))

            L = L + 1
            END DO

         J = J + 1
         END DO

      END IF

      RETURN
      END

      SUBROUTINE OUTPUT (ITASK,INFND,INPS,QT,PARNAM,V,IMXNPS,IMXPAR,
     $                   INDX)
      IMPLICIT REAL (A-Z)

      INTEGER ITASK,INFND,INPS,IMXNPS,IMXPAR
      DIMENSION QT(IMXNPS+1)
      CHARACTER*31 PARNAM
      DIMENSION PARNAM(IMXPAR)
      DIMENSION V(IMXNPS+2,IMXPAR)
     
*-----Character string with name of input datafile
      CHARACTER*14 OPTFIL

*-----Variables used as unit number for file I/O or counter
*     in do-loops
      INTEGER IUNIT,I,J

      INTEGER ILEN,ITMP

*-----Name of character string
      CHARACTER*80 TEXT

*-----Declaration of array with indexes of qt-values
      INTEGER INDX(IMXNPS)

*-----End of declarations

      SAVE

*-----Unit number for file I/O
      IUNIT = 92

      IF (ITASK.EQ.1) THEN

*-----   Write output-file with initial parameter sets and QT-values
         OPTFIL = 'PAR_INIT.DAT'
         CALL FOPENS (IUNIT,OPTFIL,'NEW','DEL')

         CALL OUTDAT (1,IUNIT,'SET-i',0.)

         DO I = 1,INPS
            CALL OUTDAT (2,IUNIT,'SET-i',FLOAT(I))
            DO J = 1,INFND
               ITMP = MAX(1,ILEN(PARNAM(J)))
               CALL OUTDAT (2,IUNIT,PARNAM(J)(1:ITMP),V(I,J))
            END DO
            CALL OUTDAT (2,IUNIT,'QT',QT(I))
         END DO

         TEXT =
     $   'FSEOPT - calibration: (unsorted) initial sets and QT-values'
         CALL OUTDAT (4,IUNIT,TEXT,0.)

         CALL INDEXX (INPS,QT,INDX)
         CALL OUTDAT (1,IUNIT,'SET-i',0.)

         DO I = 1,INPS
            CALL OUTDAT (2,IUNIT,'SET-i',FLOAT(INDX(I)))
            DO J = 1,INFND
               ITMP = MAX(1,ILEN(PARNAM(J)))
               CALL OUTDAT (2,IUNIT,PARNAM(J)(1:ITMP),V(INDX(I),J))
            END DO
            CALL OUTDAT (2,IUNIT,'QT',QT(INDX(I)))
         END DO

         TEXT =
     $   'FSEOPT - calibration: (sorted) initial sets and QT-values'
         CALL OUTDAT (4,IUNIT,TEXT,0.)
         CALL OUTDAT (99, 0, ' ', 0.)
         CLOSE (IUNIT)

      ELSE IF (ITASK.EQ.2) THEN

*-----   Write final parameter-sets and QT-values to output file
         OPTFIL = 'PAR_TERM.DAT'
         CALL FOPENS (IUNIT,OPTFIL,'NEW','DEL')
         CALL OUTDAT (1,IUNIT,'SET-i',0.)

         DO I = 1,INPS
            CALL OUTDAT (2,IUNIT,'SET-i',FLOAT(I))
            DO J = 1,INFND
               ITMP = MAX(1,ILEN(PARNAM(J)))
               CALL OUTDAT (2,IUNIT,PARNAM(J)(1:ITMP),V(I,J))
            END DO
            CALL OUTDAT (2,IUNIT,'QT',QT(I))
         END DO

         TEXT =
     $  'FSEOPT - calibration: (unsorted) final sets and QT-values'
         CALL OUTDAT (4,IUNIT,TEXT,0.)

         CALL INDEXX (INPS,QT,INDX)
         CALL OUTDAT (1,IUNIT,'SET-i',0.)

         DO I = 1,INPS
            CALL OUTDAT (2,IUNIT,'SET-i',FLOAT(INDX(I)))
            DO J = 1,INFND
               ITMP = MAX(1,ILEN(PARNAM(J)))
               CALL OUTDAT (2,IUNIT,PARNAM(J)(1:ITMP),V(INDX(I),J))
            END DO
            CALL OUTDAT (2,IUNIT,'QT',QT(INDX(I)))
         END DO

         TEXT =
     $   'FSEOPT - calibration: (sorted) final sets and QT-values'
         CALL OUTDAT (4,IUNIT,TEXT,0.)
         CALL OUTDAT (99, 0, ' ', 0.)
         CLOSE (IUNIT)

      END IF

      RETURN
      END

      SUBROUTINE HIGHLO (IMXNPS,INPS,IPNT1,IPNT2,QT,QTLOW,QTHIGH)
      IMPLICIT REAL (A-Z)

*-----Variables in parameter-list
      INTEGER IMXNPS,INPS,IPNT1,IPNT2
      DIMENSION QT(IMXNPS+1)

*-----Integer variable used in do-loops
      INTEGER I

*-----End of declarations

      SAVE

      QTLOW  = 1.0E+8
      QTHIGH = -1.0E+8

      DO I = 1,INPS
         IF (QT(I).LT.QTLOW) THEN
            IPNT2 = I
            QTLOW = QT(I)
         END IF
         IF (QT(I).GT.QTHIGH) THEN
            IPNT1 = I
            QTHIGH = QT(I)
         END IF
      END DO

      RETURN
      END

      SUBROUTINE WRSTAT (ITER,RTOL,QTLOW,QTHIGH)
      IMPLICIT REAL (A-Z)

      INTEGER ITER

      SAVE

      WRITE (*,'(/,1X,A,I10,3(/,1X,A,G10.5))')
     $  '        Iteration-n: ' , ITER,
     $  '          Tolerance: ' , RTOL,
     $  '  Qt-value best-set: ' , QTLOW,
     $  ' Qt-value worst-set: ' , QTHIGH

      RETURN
      END

      SUBROUTINE INDEXX (N,ARRIN,INDX)
      IMPLICIT REAL(A-Z)

      INTEGER I,J,N,IR,L
      DIMENSION ARRIN(N)
      INTEGER INDXT,INDX(N)
      SAVE

      DO 11 J=1,N
        INDX(J)=J
11    CONTINUE
      L=N/2+1
      IR=N
10    CONTINUE
        IF (L.GT.1) THEN
          L=L-1
          INDXT=INDX(L)
          Q=ARRIN(INDXT)
        ELSE
          INDXT=INDX(IR)
          Q=ARRIN(INDXT)
          INDX(IR)=INDX(1)
          IR=IR-1
          IF (IR.EQ.1) THEN
            INDX(1)=INDXT
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF (J.LE.IR) THEN
          IF (J.LT.IR) THEN
            IF (ARRIN(INDX(J)).LT.ARRIN(INDX(J+1)))J=J+1
          ENDIF
          IF (Q.LT.ARRIN(INDX(J))) THEN
            INDX(I)=INDX(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        INDX(I)=INDXT
      GO TO 10
      END
