** $Id: rootd.for 1.2 1997/10/02 15:20:33 LEM release $
      SUBROUTINE ROOTD
     &   (ITASK, DELT , IWB , FR, ZT, RDM, RD)

*     In this routine the depth of the root zone is calculated for each
*     day of the crop cycle
*     Called by WOFOST
*     ITASK = 1, initialization
*     ITASK = 2, rate calculation
*     ITASK = 3, integration
*     ITASK = 4, finish section

*     Author: C.A. van Diepen, September 1988

*-----------------------------------------------------------------------
*     declarations
*-----------------------------------------------------------------------

      IMPLICIT REAL(A-Z)
      INTEGER IAIRDU, IZT, ITASK, DELT, IWB
      INTEGER ILAMAX,ILSSA, ILEFF, ILKDIF
      INTEGER ILDTSM,ILFL,ILFO,ILFR,ILFS,ILRDRR,ILRDRS,ILRFSE
      INTEGER ILSLA,ILTMNF,ILTMPF,ITOLD

*     declarations
      REAL AMAXTB(30), DTSMTB(30), FRTB(30), FLTB(30)
      REAL FSTB(30), FOTB(30), RDRRTB(30), RDRSTB(30)
      REAL RFSETB(30), SLATB(30), TMNFTB(30), TMPFTB(30)
      REAL DVSI
      REAL SSATB(30), KDIFTB(30), EFFTB(30)

**
      SAVE

*     Python COMMON block with variables related to ROOTD routine.
      COMMON /CROOTD/ ITOLD, RR

*     Python COMMON block with crop specific variables
      COMMON /CROPVAR/ RRI,IDSL, DLO, DLC, TSUM1, TSUM2, DTSMTB, ILDTSM,
     &         DVSI, DVSEND, TDWI, RGRLAI, SLATB, ILSLA,  
     &         SPA, SSATB, ILSSA, SPAN, TBASE, KDIFTB, ILKDIF,
     &         EFFTB, ILEFF, AMAXTB, ILAMAX, TMPFTB, ILTMPF,
     &         TMNFTB, ILTMNF, CVL, CVO, CVR, CVS, Q10, RML,
     &         RMO, RMR, RMS, RFSETB, ILRFSE, FRTB, ILFR,
     &         FLTB, ILFL, FSTB, ILFS, FOTB, ILFO, PERDL, 
     &         RDRRTB, ILRDRR, RDRSTB, ILRDRS, CFET, DEPNR,
     &         IAIRDU, RDI, RDMCR, TBASEM, TEFFMX, TSUMEM

*     Python COMMON block with site variables
      COMMON /SITEVAR/ IFUNRN, SSMAX, RDMSOL, NOTINF, SSI, WAV

      DATA ITOLD /4/

Cf2py intent(in) ITASK, DELT , IWB , FR
Cf2py intent(in,out) ZT, RDM, RD 


*     return immediately when previous task was initialization

      IF (ITASK.EQ.3.AND.ITOLD.EQ.1) THEN
         ITOLD = ITASK
         RETURN
      END IF

      IF (ITASK.EQ.1) THEN

*        initial and maximum rooting depth
         RD = RDI
         IF (IWB.EQ.0) RDM = MAX (RDI, RDMCR)
         IF (IWB.EQ.1) RDM = MAX (RDI, MIN(RDMSOL,RDMCR))

*        Influence of ground water (IZT) removed for PyWofost	 
*         IF (IZT.EQ.0) ZT = 999.
*         IF (IZT.EQ.1) ZT = ZTI
         ZT = 999.

      ELSE IF (ITASK.EQ.2) THEN

*        root growth RR in cm (is not considered as a rate!)
         RR = MIN (RDM-RD,RRI*DELT)
         IF (FR.LE.0.) RR=0.
*        with groundwater, root growth zero nearby groundwater
         IF (IAIRDU.EQ.0 .AND. ZT-RD.LT.10.) RR=0.

      ELSE IF (ITASK.EQ.3) THEN

*        new depth of rootzone
         RD = RD+RR

      ELSE IF (ITASK.EQ.4) THEN

*        save final rooting depth under potential production
*        needed for calculation water-limited production.

*        Note: This was removed by Allard de Wit in order to
*        avoid that a potential production run always needed
*        to be carried out before a water-limited run could
*        be done
      END IF

      ITOLD = ITASK

      RETURN
      END
