** $Id: watfd.for 1.3 1998/06/18 16:22:11 unknown release $
      SUBROUTINE WATFD (ITASK , DELT  , IAIRDU , IDEM  , IDHALT,
     &                  RDM   , RD    , EVWMX  , EVSMX , TRA  ,
     &                  SM    , RAIN)

*     In routine WATFD the simulation of the soil water balance is
*     performed for FREELY DRAINING soils in the water-limited
*     production situation.

* VARIABLE TYPE Description                                      Units   I/O
*  ITASK   I*4  flag to control task to be performed                       I
*               1, initialization
*               2, rate calculation, save dynamic output
*               3, integration, summation
*               4, finish section, save final output
*  DELT    R*4  time step = 1 day                                  d       I
*  IAIRDU  I*4  indicates presence(1) or absence(0) of airducts            I
*               in the roots. 1= can tolerate waterlogging 
*  IDEM    I*4  day of emergence (date 1-366)                              I
*  IDHALT  I*4  day that simulation is halted (date 1-366)                 I
*  RDM     R*4  maximum rooting depth                              cm      I
*  RD      R*4  rooting depth                                      cm      I
*  EVWMX   R*4  maximum evaporation rate from shaded water surface cm d-1  I
*  EVSMX   R*4  maximum evaporation rate from shaded soil surface  cm d-1  I
*  TRA     R*4  actual transpiration rate                          cm d-1  I
*               Note: TRA is calculated in EVTRA called by CROPSI
*  SM      R*4  actual soil moisture content                     cm3 cm-3  O
*  RAIN    R*4  daily rainfall                                     cm d-1  I

*     The following parameters have been removed from the interface and are
*     now filled from python through the COMMON block SITEVAR:
*  IFUNRN  I*4  flag indicating the way to calculate the                   I
*               non-infiltrating fraction of rainfall:
*               0. fraction is fixed at NOTINF 
*               1. fraction depends on NOTINF and on daily rainfall 
*               as given by NINFTB.
*  SSMAX   R*4  maximum surface storage                            cm      I
*  NOTINF  R*4  if FUNRAI=0 non-infiltrating fraction of rainfall          I
*               if FUNRAI=1 maximum non-infiltrating fraction 
*  SSI     R*4  initial surface storage                            cm      I
*  WAV     R*4  initial (at emergence) amount of water in excess of        I
*               wilting point, but not exceeding field capacity    cm

*     The following parameters have been removed from the interface and are
*     now filled from python through the COMMON block SOILVAR:
*  SM0     R*4  soil porosity                                    cm3 cm-3  I
*  SMFCF   R*4  soil moisture content at field capacity          cm3 cm-3  I
*  SMW     R*4  soil moisture content at wilting point           cm3 cm-3  I
*  CRAIRC  R*4  critical air content                             cm3 cm-3  I
*  SOPE    R*4  Maximum percolation rate root zone                 cm d-1  I
*  KSUB    R*4  Maximum percolation rate of water to subsoil       cm d-1  I
*  K0      R*4  Hydraulic conductivity of saturated soil           cm d-1  I

*     The following parameters are obsolete:
*  SMLIM   R*4  max. initial soil moisture in topsoil              cm      I


*     Author: C.A. van Diepen, February 1989, revised July 1990

*     Subroutine WATFD is derived from subroutine APPLE of WOFOST Version 4.1.

*     The purpose of the soil water balance calculations is to estimate the 
*     daily value of the soil moisture content. The soil moisture content 
*     influences soil moisture uptake and crop transpiration.
*     In the initial section soil physical data are read from file SOFILE, 
*     and all rates and sum totals are set at zero.
*     The dynamic calculations are carried out in two sections, one for the 
*     calculation of rates of change per timestep (delt = 1 day) and one 
*     for the calculation of summation variables and state variables.
*     The water balance is driven by rainfall, possibly buffered as surface 
*     storage, and evapotranspiration.
*     The processes considered are infiltration, soil water retention, 
*     percolation (here conceived as downward water flow from rooted zone 
*     to second layer), and the loss of water beyond the maximum root zone. 

*     The textural profile of the soil is conceived as homogeneous.
*     Initially the soil profile consists of two layers, the actually rooted 
*     soil and the soil immediately below the rooted zone until the maximum
*     rooting depth (soil and crop dependent). The extension of the root zone 
*     from initial rooting depth to maximum rooting depth is described in 
*     subroutine ROOTD. Its effect on the soil moisture content is accounted 
*     for in this subroutine WATFD.
*     From the moment that the maximum rooting depth is reached the soil 
*     profile is described as a one layer system.

*     +-----------------------------------------------------------------+
*     | Version:      1.2                                               |
*     | Date:         24 July 1997                                      |
*     | Author:       Tamme van der Wal                                 |
*     |               Group Software Engineering                        |
*     | Reason:       Adaptation of soil water balance calculations     |
*     | Modification: Addition of 2 new variables in site.dat           |
*     |               which need to be passed to WATFD and WATGW through|
*     |               WOFSIM. Variable SSI was already passed, variable |
*     |               SMLIM is added to parameter list                  |
*     |               Changed lines indicated with *!!                  |
*     +-----------------------------------------------------------------+ 
*     | MODIFICATION													  |
*     | Date:         15-06-1998										  |
*     | Author:       Hendrik Boogaard								  |
*     | Reason:       Error determination WLOW + limit on determination |
*     |               on amount of water in root zone                   |
*     | 1) limits of WLOW between 0.0 and SM0 in stead of 0.0 and SMFCF |
*     | 2) control whether W is less then 0.0 in integration            |
*     |    only can happen in dry start conditions; if W less than 0.0  |
*     |    then w = 0.0 and EVST is adapted                             |
*     +-----------------------------------------------------------------+ 
*     | MODIFICATION
*     | Date:        05-04-2006
*     | Author:      Allard de Wit
*     | Reason:      Initial available water WAV is now distributed over
*     |              the whole root zone first instead of applying it to
*     |              the rooted and unrooted zone first. We assume a  
*     |              uniform distribution of soil moisture throughout the
*     |              at the start.
*     +-----------------------------------------------------------------+ 

*     declarations
      IMPLICIT REAL(A-Z)
      INTEGER IAIRDU, IDHALT, IFUNRN, ITASK
      INTEGER IDEM,ITOLD
      REAL SSI, SMLIM

*     python COMMON block
      COMMON/CWATFD/ ITOLD,RDOLD,SS,W,WI,DSLR,WLOW,WLOWI,WWLOW,
     &               TRAT,EVST,EVWT,TSR,RAINT,WDRT,TOTINF,TOTIRR,
     &               SUMSM,PERCT,LOSST, SSPRE, W_NEW, EVSJ, WDR, 
     &               EVS,EVW,RIN,RIRR,DW,PERC,LOSS,DWLOW, 
     &               WE, PERC1, WELOW, PERC2, EVSMXT, RINPRE, AVAIL

*     Python COMMON block with soil specific variables
      COMMON /SOILVAR/ SM0, SMFCF, SMW, CRAIRC, SOPE, KSUB, K0

*     Python COMMON block with site variables
      COMMON /SITEVAR/ IFUNRN, SSMAX, RDMSOL, NOTINF, SSI, WAV

*     multiplier for non-infiltrating fraction of rainfall as a function 
*     of daily rainfall
      REAL NINFTB(20)
**
*     help variable in integration
      REAL W_NEW

      SAVE

*     infiltration parameters WOFOST41
*     DATA NINFTB/0.0,0.00, 0.5,0.12, 1.0,0.29,
*     &              2.0,0.71, 3.0,0.91, 7.0,1.00, 8*0./
*     infiltration parameters WOFOST_WRR
      DATA NINFTB/0.0,0.0, 0.5,0.0, 1.5,1.0, 14*0./

      DATA ITOLD /4/

Cf2py intent(in) ITASK,DELT,IDEM,IDHALT,RDM,RD,EVWMX,EVSMX,TRA,RAIN
Cf2py intent(in,out) SM

*     immediate return of execution when previous task was initialization
      IF (ITASK.EQ.3.AND.ITOLD.EQ.1) THEN
         ITOLD = ITASK
         RETURN
      END IF

      IF (ITASK.EQ.1) THEN

*-----------------------------------------------------------------------
*     initial section
*-----------------------------------------------------------------------

*        old rooting depth
         RDOLD = RD

*        initial surface storage
         SS = SSI

*        initial maximum moisture content in initial root zone
         SMLIM = SM0
         IF (IAIRDU.EQ.1) SMLIM = SM0

*        initial amount of soil moisture in total rootable zone based on
*        the value of WAV, scale between wilting point and saturation
         WWLOW = LIMIT (SMW*RDM, SM0*RDM, SMW*RDM+WAV)
         WLOW = WWLOW*(RDM-RD)/RDM
         W = WWLOW*(RD/RDM)

*        initial moisture content in initial root zone
         SM = LIMIT (SMW, SMLIM, W/RD)

*        Store initial values
         WI = W
         WLOWI = WLOW

*        soil evaporation, days since last rain
         DSLR = 1.
         IF (SM.LE.(SMW+0.5*(SMFCF-SMW))) DSLR=5.

*        all summation variables of the water balance are set at zero.
         TRAT   = 0.
         EVST   = 0.
         EVWT   = 0.
         TSR    = 0.
         RAINT  = 0.
         WDRT   = 0.
         TOTINF = 0.
         TOTIRR = 0.
         SUMSM  = 0.
         PERCT  = 0.
         LOSST  = 0.

*        all rates are set at zero
         EVS   = 0.
         EVW   = 0.
         RAIN  = 0.
         RIN   = 0.
         RIRR  = 0.
         DW    = 0.
         PERC  = 0.
         LOSS  = 0.
         DWLOW = 0.

      ELSE IF (ITASK.EQ.2) THEN

*-----------------------------------------------------------------------
*     rates of the water balance
*-----------------------------------------------------------------------

*        actual transpiration rate
*        N.B.: transpiration rate is calculated in EVTRA called by CROPSI
*        actual evaporation rates ...
         EVW = 0.
         EVS = 0.
*        ... from surface water if surface storage more than 1 cm, ...
         IF (SS.GT.1.) THEN
            EVW = EVWMX
*           ... else from soil surface
         ELSE
*!!in oude WOFOST:   evs = evsmx * limit(0.,1.,(sm-smw/3.)/(sm0-smw/3.))
            IF (RIN.GE.1.) THEN
               EVS  = EVSMX
               DSLR = 1.
            ELSE
               DSLR   = DSLR+1.
               EVSMXT = EVSMX*(SQRT (DSLR)-SQRT(DSLR-1.))
               EVS    = MIN (EVSMX, EVSMXT+RIN)
            END IF
         END IF

*        preliminary infiltration rate
         IF (SS.LE.0.1) THEN
*           without surface storage
            IF (IFUNRN.EQ.0) RINPRE = (1.-NOTINF)*RAIN+RIRR+SS/DELT
            IF (IFUNRN.EQ.1) RINPRE = (1.-NOTINF*AFGEN
     &         (NINFTB,20,RAIN))*RAIN+RIRR+SS/DELT
         ELSE
*           with surface storage, infiltration limited by SOPE
*!!         Next line replaced TvdW 24-jul-97
*!!            AVAIL  = SS+(RAIN+RIRR-EVW)*DELT
            AVAIL = SS + (RAIN * (1.-NOTINF)+RIRR-EVW) * DELT

            RINPRE = MIN (SOPE*DELT, AVAIL)/DELT
         END IF


*        percolation

*        equilibrium amount of soil moisture in rooted zone
         WE = SMFCF * RD
*        percolation from rooted zone to subsoil equals amount of
*        excess moisture in rooted zone (not to exceed conductivity)
         PERC1 = LIMIT (0., SOPE, (W - WE)/DELT - TRA - EVS)

*        loss of water at the lower end of the maximum root zone
*        equilibrium amount of soil moisture below rooted zone
         WELOW = SMFCF * (RDM - RD)
         LOSS  = LIMIT (0., KSUB, (WLOW - WELOW)/DELT + PERC1 )
*        for rice water losses are limited to K0/20
         IF (IAIRDU.EQ.1) LOSS = MIN (LOSS, 0.05*K0)

*        percolation not to exceed uptake capacity of subsoil
         PERC2 = ((RDM -RD) * SM0 - WLOW) / DELT + LOSS
         PERC  = MIN (PERC1,PERC2)

*        adjustment of infiltration rate
         RIN = MIN (RINPRE,(SM0-SM)*RD/DELT + TRA + EVS + PERC)

*        rates of change in amounts of moisture W and WLOW
         DW    = - TRA - EVS - PERC + RIN
         DWLOW = PERC - LOSS


      ELSE IF (ITASK.EQ.3) THEN

*-----------------------------------------------------------------------
*       dynamic calculations
*       integrals of the water balance:  summation and state variables
*-----------------------------------------------------------------------

*        total transpiration
         TRAT = TRAT + TRA*DELT
*        total evaporation from surface water layer and/or soil
         EVWT = EVWT + EVW*DELT
         EVST = EVST + EVS*DELT

*        totals for rainfall, irrigation and infiltration
         RAINT  = RAINT + RAIN*DELT
         TOTINF = TOTINF + RIN*DELT
         TOTIRR = TOTIRR + RIRR*DELT

*        surface storage and runoff
         SSPRE = SS + (RAIN+RIRR-EVW-RIN)*DELT
         SS    = MIN (SSPRE, SSMAX)
         TSR   = TSR + (SSPRE-SS)

*        amount of water in rooted zone
         W_NEW = W + DW*DELT
      IF (W_NEW.LT.0.0) THEN
           EVST = EVST + W_NEW
           W = 0.1
      ELSE
	   W = W_NEW
      END IF

*        total percolation and loss of water by deep leaching
         PERCT = PERCT + PERC*DELT
         LOSST = LOSST + LOSS*DELT

*        amount of water in unrooted, lower part of rootable zone
         WLOW = WLOW + DWLOW*DELT
*        total amount of water in the whole rootable zone
         WWLOW = W + WLOW

         IF (W_NEW.LT.0.0) THEN
           EVSJ = EVSJ - W_NEW
	   END IF

*----------------------------------------------
*        change of rootzone subsystem boundary
*----------------------------------------------
*        calculation of amount of soil moisture in new rootzone
         IF (RD-RDOLD.GT.0.001) THEN
*           water added to root zone by root growth, in cm
            WDR  = WLOW*(RD-RDOLD)/(RDM-RDOLD)
            WLOW = WLOW - WDR

*           total water addition to rootzone by root growth
            WDRT = WDRT + WDR
*           amount of soil moisture in extended rootzone
            W = W + WDR
         END IF

*        mean soil moisture content in rooted zone
         SM = W/RD
*        calculating mean soil moisture content over growing period
         SUMSM = SUMSM + SM*DELT
*        save rooting depth
         RDOLD = RD

      ELSE IF (ITASK.EQ.4) THEN

*-----------------------------------------------------------------------
*     finish section
*-----------------------------------------------------------------------

*        mean water content rooting zone during crop growth and total
*        water content of the potentially rooted zone at end of simulation
         MWC = SUMSM/MAX(1.,REAL (MOD((365+IDHALT-IDEM),365)))
         TWE = W+WLOW

*        checksums waterbalance for system without groundwater
         WBALRT = TOTINF + WI + WDRT - EVST - TRAT - PERCT - W
         WBALTT = SSI + RAINT + TOTIRR + WI - W + WLOWI - WLOW - TRAT
     &     - EVWT - EVST - TSR - LOSST - SS

      END IF

      ITOLD = ITASK

      RETURN
      END
