#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#undef toupper

#include "screen.h"
#include "extkeys.h"
#include "ero1.h"
#include "erofunc.h"


static EROSION *e_list;

struct screen *(*foot_list)[19][10];
extern struct screen *english_list[19][10];

struct limit_type (*limits)[19];
extern struct limit_type english_limits[19];
int units=ENGLISH;


struct c_scheme clr;
struct vcfg cfg;
static SMALL_WINDOW *w_ptr;
struct file_position pos;
char fname[40];

char *greatest_composer_ever = "W. A. Mozart, 1756-1791";

main( argc, argv )
int argc;
char * argv[];
{
int c, stop;
EROSION *first, *last, *tmp;
WINDOW_CONTROL wc;
char *tname = "Temporary file";

   stop = FALSE;
   w_ptr = NULL;
   foot_list = &english_list;
   limits = &english_limits;
   wc.beg_vrow = 0;
   wc.max_rows = 16;
   wc.d_col    = 5;
   wc.d_row    = 3;
   wc.offset   = 0;
   wc.field    = 0;
   wc.v_row = wc.r_row = 0;
   wc.view     = VLEFT;
   get_vcfg( );
   if (argc > 1) {
      c = init_from_file( &e_list, argv[1], wc );
      strcpy( fname, argv[1] );
      if (c == FALSE) {
         init_all_cards( &e_list );
         strcpy( fname, tname );
      }
   } else {
      init_all_cards( &e_list );
      strcpy( fname, tname );
   }
   first = e_list;
   for (tmp=e_list; tmp != NULL; tmp=tmp->n)
      last = tmp;
   tmp = first;
   intro( );
   pd( );
   pos.display = TRUE;
   pos.d_row = 24;
   pos.d_col = 72;
   pos.color = cfg.f_bar;
   pos.f_row = wc.r_row + 1;
   pos.f_col = 0;
   work_screen( tmp, wc, argv[1], c );
   show_footer( tit_foot, wc);
   write_filename( fname );
   c = 0;
   while (stop != TRUE) {
      switch (tmp->type) {
         case 1 :
         case 2 :
         case 3 :
            wc.field = 0;
            get_title( tmp, wc, &c );
            break;
         case 4 :
         case 5 :
         case 6 :
         case 7 :
         case 8 :
         case 9 :
         case 10 :
         case 11 :
         case 12 :
         case 13 :
         case 14 :
         case 15 :
         case 16 :
         case 17 :
         case 18 :
         case 19 :
         case 20 :
         case 21 :
         case 22 :
         case 23 :
         case 24 :
            get_card4_24( tmp, &wc, &c );
            break;
         default :
            c = UP;
            break;
      }
      link_list_editor( &tmp, &wc, c );
      pos.f_row = wc.r_row + 1;
      switch (c) {
         case ALTF  :
         case ALTD  :
         case ALTC  :
         case ALTU  :
         case ALTH  :
            lite_bar_menu( &first, &tmp, &wc, &stop, &c );
            break;
         case ALTS  :
            save( first );
            break;
         case ALTX  :
            quit( first, &stop );
            break;
      }
   }
   cls( );
   set_cur( 1, 1 );
}


int init_from_file( e_list, path, wc )
EROSION **e_list;
char *path;
WINDOW_CONTROL wc;
{
EROSION *a, *b;
int rc;
FILE *infile;
char line[100];
struct card_parse crd;

   rc = FALSE;
   if ( (infile = fopen( path, "r" )) != NULL)   {

      crd.flgseq    = 0;
      crd.num_chans = 0;
      crd.nptso     = 0;
      crd.seen1_9   = FALSE;
      crd.seen2_9   = FALSE;
      crd.nyears    = 0;
      crd.ncdates   = 0;
      crd.nxf       = 0;
      crd.over_set  = 0;
      crd.seen19    = 0;
      crd.nxc       = 0;
      crd.chan_set  = 0;
      crd.eof       = FALSE;

      fseek( infile, 0L, SEEK_SET );
      for (crd.c_no=0; fgets( line, 90, infile ) != NULL && crd.eof != TRUE;) {
         if (crd.c_no == 0) {
            crd.c_no = 1;
            *e_list = (EROSION *)malloc( sizeof(EROSION) );
            (*e_list)->n = (*e_list)->p = NULL;
            a = *e_list;
         } else {
            b = (EROSION *)malloc( sizeof(EROSION) );
            a->n = b;
            b->p = a;
            b->n = NULL;
            a = b;
         }
         add_a_line( a, line, &crd );
         if (a->type == 4)
            check_card4_units( a, &wc );
      }
      fclose( infile );
      rc = TRUE;
   } else
      rc = FALSE;
   return( rc );
}


void init_all_cards( e_list )
EROSION **e_list;
{
int i;
EROSION *a, *b;

   for (i=1; i<19; i++) {
      if (i>=9 && i<= 12)
         continue;
      if (i == 1) {
         *e_list = (EROSION *)malloc( sizeof(EROSION) );
         (*e_list)->n = (*e_list)->p = NULL;
         (*e_list)->type = i;
         a = *e_list;
      } else {
         b = (EROSION *)malloc( sizeof(EROSION) );
         a->n = b;
         b->p = a;
         b->n = NULL;
         b->type = i;
         a = b;
      }
      blank_line( a );
      if (i == 4) {
         set_field_value( a, "1", 3, TRUE );
         a->num[8] = 1.0;
      } else if (i == 8) {
         set_field_value( a, "1", 0, TRUE );
         set_field_value( a, "1.0", 1, TRUE );
      } else if (i == 13) {
         set_field_value( a, "1", 0, TRUE );
         a->num[1] = 1.0;
      } else if (i == 14)
         set_field_value( a, "001", 0, TRUE );
      else if (i == 15) {
         set_field_value( a, "1", 0, TRUE );
         a->num[5] = 1.0;
         set_field_value( a, "1.0", 1, TRUE );
      }
   }
}


void blank_line( a )
EROSION *a;
{
int i;

   memset( a->line, ' ', 80 );
   a->line[80] = '\0';
   for (i=0; i<10; i++) {
      a->num[i] = 0.0;
      a->apd[i] = FALSE;
   }
}


void intro( )
{
int c;

   c_off( );
   cls( );
   write_to_window( ero_intro, 0, 0, NORMAL );
   c = (c = getch( )) ? c : 0x100 | getch( );
   c_on( );
   cls( );
}


void work_screen( tmp, wc, path, c )
EROSION *tmp;
WINDOW_CONTROL wc;
char *path;
int c;
{
   write_to_window( ero_work, 0, 0, NORMAL );
   show_list( tmp, &wc );
   if (units == ENGLISH)
      fast_write( 63, 1, "English units", NORMAL );
   else
      fast_write( 63, 1, "Metric units ", NORMAL );
}


void show_list( tmp, wc )
EROSION *tmp;
WINDOW_CONTROL *wc;
{
int r;
char t[82], s[10];

   scroll_window( 0, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (r=wc->d_row; tmp!=NULL && r<wc->max_rows+wc->d_row; tmp=tmp->n,r++) {
      if (tmp->type >= 1 && tmp->type <=3)
         fast_write( 0, r, tmp->line, NORMAL );
      else {
         if (wc->view == VLEFT)
            strncpy( t, tmp->line, 72 );
         else if (wc->view == VRIGHT)
            strncpy( t, tmp->line+8, 72 );
         t[72] = '\0';
         strcpy( s, itoa( tmp->type, s, 10 ) );
         fast_write( wc->d_col, r, t, NORMAL );
         if (strlen( s ) == 1)
            fast_write( wc->d_col-2, r, s, NORMAL );
         else
            fast_write( wc->d_col-3, r, s, NORMAL );
      }
   }
}


void get_title( tmp, wc, c )
EROSION *tmp;
WINDOW_CONTROL wc;
int *c;
{
int append, cntinue, cell_r, cell_c;
char t[82];

   pos.f_col = 1;
   cell_r = wc.v_row + wc.d_row;
   cell_c = 0;
   if (*c == UP && wc.r_row == 2)
      show_footer( tit_foot, wc );
   append = tmp->apd[0];
   if (append)
      strcpy( t, tmp->line );
   cntinue = TRUE;
   while (cntinue) {
      field_editor( t, 'A', 80, cell_r, cell_c, append, c, 7, pos );
      strcpy( tmp->line, t );
      if (*t != '\0')
         tmp->apd[0] = TRUE;
      else
         tmp->apd[0] = FALSE;
      switch (*c) {
         case UP        :
         case DOWN      :
         case RTURN     :
         case PGUP      :
         case PGDN      :
         case ALTF      :
         case ALTD      :
         case ALTC      :
         case ALTU      :
         case ALTH      :
         case ALTS      :
         case ALTX      :
            cntinue = FALSE;
            break;
   }  }
}


void link_list_editor( tmp, wc, c )
EROSION **tmp;
WINDOW_CONTROL *wc;
int c;
{
EROSION *a, *b;
int i, k, vr, rr;
char t[82], s[10];

   rr = wc->r_row;
   vr = wc->v_row;
   switch (c) {
      case UP :
         if ( (*tmp)->p != NULL) {
            *tmp = (*tmp)->p;
            if (vr > wc->beg_vrow) {
               --vr;
               --rr;
            } else if (vr == wc->beg_vrow) {
               --rr;
               scroll_window( -1, wc->d_row, 0, wc->d_row+wc->max_rows, 79, NORMAL );
               if ((*tmp)->type >= 1 && (*tmp)->type <= 3)
                  fast_write( 0, vr+wc->d_row, (*tmp)->line, NORMAL );
               else {
                  i = 0 + 8 * wc->view;
                  strncpy( t, (*tmp)->line+i, 72 );
                  t[72] = '\0';
                  fast_write( wc->d_col, vr+wc->d_row, t, NORMAL );
                  strcpy( s, itoa( (*tmp)->type, s, 10) );
                  if (strlen(s) == 1)
                     fast_write( wc->d_col-2, vr+wc->d_row, s, NORMAL );
                  else
                     fast_write( wc->d_col-3, vr+wc->d_row, s, NORMAL );
               }
            }
         }
         break;
      case DOWN  :
      case RTURN :
         if (*tmp != NULL && (*tmp)->n != NULL) {
            *tmp = (*tmp)->n;
            if (vr + wc->offset < wc->max_rows-1) {
               ++vr;
               ++rr;
            } else if (vr + wc->offset == wc->max_rows - 1) {
               ++rr;
               scroll_window( 1, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
               if ((*tmp)->type >= 1 && (*tmp)->type <= 3)
                  fast_write( 0, vr+wc->d_row, (*tmp)->line, NORMAL );
               else {
                  i = 0 + 8 * wc->view;
                  strncpy( t, (*tmp)->line+i, 72 );
                  t[72] = '\0';
                  fast_write( wc->d_col, vr+wc->d_row, t, NORMAL );
                  strcpy( s, itoa( (*tmp)->type, s, 10) );
                  if (strlen( s ) == 1)
                     fast_write( wc->d_col-2, vr+wc->d_row, s, NORMAL );
                  else
                     fast_write( wc->d_col-3, vr+wc->d_row, s, NORMAL );
               }
            }
         } else if ((*tmp)->n == NULL && vr > 0) {
            --vr;
            scroll_window( 1, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
         }
         break;
      case PGDN  :
         for (i=0, k=wc->v_row, a=*tmp; a->n != NULL && i < wc->max_rows;
                                                          a=a->n, i++, k++);
         if (k >= wc-> max_rows) {
            b = a;
            for (i=wc->v_row; i>0 && a->p != NULL; i--, a=a->p);
            show_list( a, wc );
            rr = rr + k - vr;
            *tmp = b;
         }
         break;
      case PGUP  :
         if (rr != vr) {
            i = rr - vr;
            if ( i < wc->max_rows) {
               for (a=*tmp; i>0 && a->p!=NULL; i--, a=a->p);
               for (b=a; a->p != NULL; a=a->p);
               rr = vr + wc->max_rows;
            } else {
               for (i=0, a=*tmp; i<wc->max_rows; i++, a=a->p);
               for (b=a, i=vr; i>0 && a->p!=NULL; i--, a=a->p);
            }
            show_list( a, wc );
            rr = rr - wc->max_rows;
            *tmp = b;
         }
         break;
   }
   wc->r_row = rr;
   wc->v_row = vr;
}


void format_output( in, out, field )
char *in, *out;
int field;
{
   memset( out+field*8, ' ', 8 );
   strncpy( out+field*8+(8-strlen( in )), in, strlen( in ) );
}


int  range_not_ok( t, low, high )
char *t;
double low, high;
{
int rc;
double num;

   if (*t == '\0')
      rc = 1;
   else {
      num = atof( t );
      if (num < (low - .0001) || num > (high + .0001))
         rc = 1;
      else
         rc = 0;
   }
   return( rc );
}


void show_footer( p, wc )
struct screen *p;
WINDOW_CONTROL wc;
{
int row;

   row = wc.d_row + wc.max_rows + 1;
   scroll_window( 0, row, 0, row+3, 79, NORMAL );
   while (p->text != NULL && p->row != 24) {
      fast_write( p->col, p->row, p->text, NORMAL );
      p++;
   }
   if (p->text != NULL)
      fast_write( p->col, p->row, p->text, cfg.f_bar );
}


void write_filename( char *string )
{
char line[82];
int j;

   memset( line, 205, 80 );
   line[80] = '\0';
   fast_write( 0, 2, line, NORMAL );
   strcpy( line, string );
   j = strlen( line );
   insert( line, j, 198 );
   insert( line, 0, 181 );
   j += 2;
   j = 39 - (j >> 1);
   fast_write( j, 2, line, NORMAL );
}


void check_card7_values( tmp, wc, row, t, c )
EROSION *tmp;
WINDOW_CONTROL *wc;
char *t;
int row, *c;
{
EROSION *a;
int i, j, ok, state, next, prev;

   if (wc->field % 2 == 0) {
      ok = TRUE;
      if (wc->field > 0 || (wc->field == 0 && tmp->p->type != 6)) {
         if (tmp->apd[wc->field] == TRUE)        /* only 1 value can be zero */
            if (tmp->num[wc->field] == 0.)
               ok = FALSE;
      }
      state = 0;
      i = wc->field - 2;
      for (j=0; j<2; j++) {
         a = tmp;
         prev = TRUE;
         if (i < 0) {
            if (tmp->p->type == 7) {
               i = 8;
               a = tmp->p;
            } else
               prev = FALSE;
         }
         if (prev == TRUE) {
            if (a->apd[i] == TRUE)
               if (a->num[i] == tmp->num[wc->field])
                  ++state;
         }
         i -= 2;
      }
      i = wc->field + 2;
      for (j=0; j<2; j++) {
         a = tmp;
         next = TRUE;
         if (i > 8) {
            if (tmp->n->type == 7) {
               i = 0;
               a = tmp->n;
            } else
               next = FALSE;
         }
         if (next == TRUE) {
            if (a->apd[i] == TRUE)
               if (a->num[i] == tmp->num[wc->field])
                  ++state;
         }
         i += 2;
      }
      if (ok == FALSE || state > 1) {
         *t = '\0';
         *c = 0;
         set_field_value( tmp, " ", wc->field, FALSE );
      }
   }
}


void view_lft_rgt( tmp, wc )
EROSION *tmp;
WINDOW_CONTROL *wc;
{
EROSION *a;
int row, i;
char t[82];

   for (a=tmp, row=wc->v_row; a->p->type > 3 && row>0; a=a->p, row--);
   row += wc->d_row;
   scroll_window( 0, row, wc->d_col, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (; a!=NULL && row<wc->d_row+wc->max_rows; a=a->n,row++) {
      i = 0 + 8 * wc->view;
      strncpy( t, a->line+i, 72 );
      t[72] = '\0';
      fast_write( wc->d_col, row, t, NORMAL );
   }
}


void quit( EROSION *first, int *stop )
{
EROSION *tmp;

   while (first != NULL) {
      tmp = first;
      first = first->n;
      free( tmp );
   }
   *stop = TRUE;
}


void save( EROSION *first )
{
EROSION *p;
char  *p1, *p2, temp[100], *head="Saving file:";
FILE *outfile;
int col, row, wid, hgt, i, j, k;

   if (strncmp( fname, "Temporary", 9 ) != 0) {
      if ((outfile = fopen( fname, "w" )) != NULL) {
         k = ((i=strlen( head )) > (j=strlen( fname ))) ? i : j;
         wid = k+4;
         col = 40 - wid / 2;
         row = 10;
         hgt = 4;
         window_control( &w_ptr, SAVE, col, row, wid, hgt );
         no_buf_make_window( col, row, wid, hgt, clr.w_outline );
         i = (k - i) / 2;
         fast_write( col+2+i, row+1, head, NORMAL );
         j = (k - j) / 2;
         fast_write( col+2+j, row+2, fname, NORMAL );
         for (i=0; i<hgt-2; i++)
            hlight_line( col+1, row+1+i, wid-2, clr.w_list );
         fseek( outfile, 0L, SEEK_SET );
         for (p=first; p != NULL; p=p->n) {
            strcpy( temp, p->line );
            p1 = p2 = temp;
            for (; *p1 != '\0'; p1++);
            for (--p1; *p1 == ' ' && p1 >= p2; p1--)
               *p1 = '\0';
            fprintf( outfile, "%s\n", temp );
         }
         fclose( outfile );
         window_control( &w_ptr, RESTORE, col, row, wid, hgt );
      }
   }
}
