#include <conio.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "e4.h"
#include "erofunc.h"


extern struct vcfg cfg;
extern struct file_position pos;
extern struct screen *(*foot_list)[19][10];
extern struct limit_type (*limits)[19];

extern int units;

int c5_table_index=0;


void get_card4_24( tmp, wc, c )
EROSION *tmp;
WINDOW_CONTROL *wc;
int *c;
{
int cntinue, ftype, wid, append, row, col, cell_r;
double high, low, x;
char t[82], s[20];
int min_fields, max_fields;
EROSION *a;

                /* card 13 has only one field -- can't see it if VRIGHT */
   if (tmp->type == 7) {
      for (a=tmp; a->type == 7; a=a->p);
      if (a->apd[0] == FALSE)
         return;
   }
   if (tmp->type == 5 && wc->view == VRIGHT)
      return;
   if (tmp->type == 9 && (wc->field == 2 || wc->field == 3))
      wc->field = 1;
   if (tmp->type == 13 && wc->view == VRIGHT)
      return;
   cell_r = tmp->type - 4;                  /* make cell_r start at 0 */
   if (tmp->type == 14)
      reset_card14_limits( );
   change_min_max_limits( tmp, wc, &min_fields, &max_fields );
   row = wc->v_row + wc->d_row;
   cntinue = TRUE;
   while (cntinue) {
      change_field_info_structs( tmp, wc, &min_fields, &max_fields );
      show_footer( (*foot_list)[cell_r][wc->field], *wc );
      wid = (*limits)[cell_r].width[wc->field];
      low = (*limits)[cell_r].range[wc->field].lo;
      high = (*limits)[cell_r].range[wc->field].hi;
      ftype = (*limits)[cell_r].field_type[wc->field];
      memset( s, ' ', wid );
      s[wid] = '\0';

        /*  to find the column for a given field
         *  1. start with display column
         *  2. add 8 times field number  - gives the starting column of field
         +  3. add 8 - field width   - adds offset to right justify
         *  4. subtract 8 times wc->view   --  view left and right columns
        */
      col = wc->d_col + wc->field * 8 + 8 - wid - 8 * wc->view;
      pos.f_col = wc->field * 8 + 8 - wid + 1;
      append = tmp->apd[wc->field];
      if (append) {
         setup_field( tmp, wc->field, wid, t );
         if (tmp->num[wc->field] > high) {
            (*limits)[cell_r].range[wc->field].hi = tmp->num[wc->field];
            high = tmp->num[wc->field];
         } else if (tmp->num[wc->field] < low) {
            (*limits)[cell_r].range[wc->field].lo = tmp->num[wc->field];
            low = tmp->num[wc->field];
         }
      }
      field_editor( t, ftype, wid, row, col, append, c, cfg.hi_i, pos );
      while (*t!='\0' && range_not_ok( t, low, high ) && *c!=ALT_F1)
         field_editor( t, ftype, wid, row, col, FALSE, c, cfg.hi_i, pos );

      if (*c == ALTM)
         show_mozart( );
      else if (*c == F1)
         get_ero_help( tmp, wc, t, c );
      else if (*c == F2 && ( (tmp->type > 15 && tmp->type < 19) ||
                         tmp->type > 19 && tmp->type < 23) )
         repeat_last_field( tmp, wc, t, max_fields );
      else if (*c == ALT_F1 && *t != '\0') {
         x = atof( t );
         if (x < low)
            (*limits)[cell_r].range[wc->field].lo = x;
         else if (x > high)
            (*limits)[cell_r].range[wc->field].hi = x;
      }

           /* ************* IMPORTANT ***************** */
           /* let card 4  contain old FLGSEQ in field 9 */
           /* let card 9  contain old NNSC in field 7   */
           /* let card 13 contain old NYEAR in field 1  */
           /* let card 15 contain old NXF in field 5    */
           /* let card 19 contain old NXC in field 5    */
           /* ************* IMPORTANT ***************** */

      if (*t != '\0') {
         fast_write( col, row, s, NORMAL );
         fast_write( col+wid-strlen( t ), row, t, NORMAL );
         set_field_value( tmp, t, wc->field, TRUE );
      } else
         set_field_value( tmp, " ", wc->field, FALSE );
      /*  special cases on card 4 */
      if (tmp->type == 4 && wc->field == 3)
         check_seqnc( tmp, wc, row );             /* adjust ero sequence */
      if (tmp->type == 4 && wc->field == 4)
         check_card4_units( tmp, wc );
      if (tmp->type == 6 && wc->field == 0)
         check_card7( tmp, wc, row );         /* number of overland points */
      if (tmp->type == 7)
         check_card7_values( tmp, wc, row, t, c );  /* points on overland curve */
      if (tmp->type == 9 && wc->field == 0)
         check_card10( tmp, wc, row );          /* nsc fields */
      if (tmp->type == 9 && wc->field == 1)
         check_card9( tmp, wc, row );           /* rating curve fields */
      if (tmp->type == 13)
         check_card13( tmp, wc, row );          /* adjust over and chan seq */
      if (tmp->type == 15 || tmp->type == 19)
         check_card15_19( tmp, wc, row );       /* adjust either over or chan */

      switch (*c) {
         case UP    :
         case DOWN  :
         case PGUP  :
         case PGDN  :
         case ALTF  :
         case ALTD  :
         case ALTU  :
         case ALTC  :
         case ALTH  :
         case ALTS  :
         case ALTX  :
            cntinue = FALSE;
            break;
         case CNTL_LEFT :
         case SHIFT_TAB :
            if (tmp->type == 9 && wc->field == 4) {
               if (tmp->apd[1] == TRUE  &&  (int)tmp->num[1] == 4)
                  --wc->field;
               else
                  wc->field = 1;
            } else {
               if (wc->view == VLEFT) {
                  if (wc->field == min_fields)
                     wc->field = max_fields;
                  else
                     --wc->field;
               } else if (wc->view == VRIGHT) {
                  if (wc->field == min_fields) {
                     wc->view = VLEFT;
      /*            change_min_max_limits( tmp, wc, &min_fields, &max_fields ); */
                     wc->field = min_fields;
                     view_lft_rgt( tmp, wc );
                  } else
                     --wc->field;
               }
            }
            break;
         case CNTL_RGHT :
         case RTURN     :
         case TAB       :
         case ALT_F1    :
            if (tmp->type == 9 && wc->field == 1) {
               if (tmp->apd[1] == TRUE  &&  (int)tmp->num[1] == 4)
                  ++wc->field;
               else
                  wc->field = 4;
            } else {
               if (wc->view == VLEFT) {
                  if (wc->field == max_fields) {
                     if (max_fields >= 8) {
                        wc->view = VRIGHT;
                        change_min_max_limits( tmp, wc, &min_fields, &max_fields );
                        if (max_fields > 8) {
                           wc->field = max_fields;
                           view_lft_rgt( tmp, wc );
                        } else {
                           if (*c == RTURN)
                              cntinue = FALSE;
                           wc->view = VLEFT;
                           change_min_max_limits( tmp, wc, &min_fields, &max_fields );
                           wc->field = min_fields;
                        }
                     } else {
                        wc->field = min_fields;
                        if (*c == RTURN)
                           cntinue = FALSE;
                     }
                  } else
                     ++wc->field;
               } else if (wc->view == VRIGHT) {
                  if (wc->field == max_fields) {
                     if (*c == RTURN)
                        cntinue = FALSE;
                     wc->view = VLEFT;
                     change_min_max_limits( tmp, wc, &min_fields, &max_fields );
                     view_lft_rgt( tmp, wc );
                     wc->field = min_fields;
                  } else
                     ++wc->field;
               }
            }
            break;
      }
   }
}


void setup_field( tmp, field, wid, t )
EROSION *tmp;
int field, wid;
char *t;
{
int i, j, k;

   for (i=0,j=field*8+8-wid, k=0; i<wid; i++) {
      if (tmp->line[j+i] != ' ') {
         t[k]=tmp->line[j+i];
         k++;
      }
   }
   t[k] = '\0';
}


void change_min_max_limits( tmp, wc, min_fields, max_fields )
EROSION *tmp;
WINDOW_CONTROL *wc;
int *min_fields, *max_fields;
{
EROSION *a;
int i, j, k, new_max, nyears, cell_r;
char t[82], s[20];

   cell_r = tmp->type - 4;
   *max_fields = (*limits)[cell_r].max_cells;
   if (wc->field > *max_fields)
      wc->field = *max_fields;
   switch (tmp->type) {
      case 7  :
         for (i=0,a=tmp; a->type != 6; a=a->p,i++);
         k = a->num[0];
         if (i == 1  &&  k >= 5)
            *max_fields = 9;
         else
            *max_fields = ((k - 1) % 5) * 2 + 1;
         break;
      case 10 :
         for (a=tmp; a->type != 9; a=a->p);
         if (a->apd[0] == TRUE)
            j = a->num[0];
         else
            j = 1;
         *max_fields = (j << 1) - 1;
         break;
      case 16 :
      case 17 :
      case 18 :
         get_year_and_seg( tmp, 15, &nyears, &j, s, 0 );
         *max_fields = get_14_dates( tmp, nyears );
         break;
      case 15 :
      case 19 :
         set_relative_end( tmp, wc, min_fields, max_fields );
         break;
      case 20 :
      case 21 :
      case 22 :
         get_year_and_seg( tmp, 19, &nyears, &j, s, 0 );
         *max_fields = get_14_dates( tmp, nyears );
         break;
   }
   *min_fields = wc->view;
   if (wc->view == VLEFT && *max_fields > 8)
      *max_fields = 8;
   if (wc->field > *max_fields)
      wc->field = *max_fields;
   else if (wc->field < *min_fields)
      wc->field = *min_fields;
}


void change_field_info_structs( tmp, wc, min_fields, max_fields )
EROSION *tmp;
WINDOW_CONTROL *wc;
int *min_fields, *max_fields;
{
EROSION *a;
int i, j, k, count_16, nyears, cell_r, min_day;
int max_day, foot_row, foot_col, wid;
char t[82], s[20], cdate[10];
float min_val, max_val;

   cell_r = tmp->type - 4;
   if (wc->field > *max_fields)
      wc->field = *max_fields;
   setup_field( tmp, wc->field, 8, t );
   wid = (*limits)[cell_r].width[wc->field];
   i = strlen( t );
   if (i > wid)
      (*limits)[cell_r].width[wc->field] = i;
   switch (tmp->type) {
      case 4  :
        set_card4_limits( tmp );
        break;
      case 7  :
         for (i=0,a=tmp; a->type != 6; a=a->p,i++);
         j = ((i - 1) * 5) + (wc->field / 2 + 1);
         strcpy( t, itoa( j, t, 10 ) );
         if ((wc->field & 1) == 0)
            foot_row = 3;
         else
            foot_row = 2;
         foot_col = 8;
         memset( s, ' ', 2 );
         s[2] = '\0';
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( t, cell_r, wc->field, foot_row, foot_col );
         if ((wc->field & 1) == 0) {
            k = wc->field+2;
            max_val = units == ENGLISH ? 3000. : 915;
            for (j=FALSE; k<=*max_fields && j != TRUE; k+=2) {
               if (tmp->apd[k] == TRUE) {
                  max_val = tmp->num[k];
                  j = TRUE;
               }
            }
            if (j == FALSE && tmp->n->type == 7) {
               k = 0;
               a = tmp->n;
               for (; k<=10 && j != TRUE; k+=2) {
                  if (a->apd[k] == TRUE) {
                     max_val = a->num[k];
                     j = TRUE;
                  }
               }
            }
            k = wc->field-2;
            for (min_val=0.,j=FALSE; k>=0 && j != TRUE; k-=2) {
               if (tmp->apd[k] == TRUE) {
                  min_val = tmp->num[k];
                  j = TRUE;
               }
            }
            if (j == FALSE && tmp->p->type == 8) {
               k = 8;
               a = tmp->p;
               for (; k>0 && j != TRUE; k-=2) {
                  if (a->apd[k] == TRUE) {
                     min_val = a->num[k];
                     j = TRUE;
                  }
               }
            }
            (*limits)[cell_r].range[wc->field].lo = min_val;
            (*limits)[cell_r].range[wc->field].hi = max_val;
            foot_row = 2;
            foot_col = 8;
            ftoa( min_val, 1, t );
            j = strlen( t );
            for (i=j; i<6; i++)
               insert( t, 0, ' ' );
            memset( s, ' ', 6 );
            s[6] = '\0';
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
            change_footer( t, cell_r, wc->field, foot_row, foot_col );
            foot_col = 17;
            ftoa( max_val, 1, t );
            j = strlen( t );
            for (i=j; i<6; i++)
               insert( t, 0, ' ' );
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
            change_footer( t, cell_r, wc->field, foot_row, foot_col );
         }
         break;
      case 8  :
         if (tmp->apd[0] == FALSE)
            j = 3;
         else
            j = tmp->num[0] * 2 + 1;
         *max_fields = j - 1;
         for (i=1; i < *max_fields; i+=2) {
            if (tmp->apd[i] == TRUE && tmp->num[i] == 1.0)
               set_field_value( tmp, " ", i, FALSE );
         }
         set_field_value( tmp, "1.0", *max_fields-1, TRUE );
         for (i=j; i < 9; i++)
            set_field_value(tmp, " ", i, FALSE);
         i = 0 + 8 * wc->view;
         strncpy( t, tmp->line+i, 72 );
         t[72] = '\0';
         fast_write( wc->d_col, wc->d_row+wc->v_row, t, NORMAL );
         break;
      case 10 :
         j = (wc->field >> 1) + 1;
         foot_row = wc->field % 2 == 0 ? 3 : 2;
         foot_col = 51;
         change_footer( " ", cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa(j, t, 10), cell_r, wc->field, foot_row, foot_col );
         if ((wc->field % 2) == 0) {
            max_val = units == ENGLISH ? 10000.0 : 3050.0;
            k = wc->field+2;
            for (j=FALSE; k<=*max_fields && j != TRUE; k+=2) {
               if (tmp->apd[k] == TRUE) {
                  max_val = tmp->num[k];
                  j = TRUE;
               }
            }
            min_val = units == ENGLISH ? 1.0 : 0.3;
            k = wc->field - 2;
            for (min_val=1.,j=FALSE; k >= 0  &&  j != TRUE; k-=2) {
               if (tmp->apd[k] == TRUE) {
                  min_val = tmp->num[k];
                  j = TRUE;
               }
            }
            (*limits)[cell_r].range[wc->field].lo = min_val;
            (*limits)[cell_r].range[wc->field].hi = max_val;
            foot_row = 2;
            foot_col = 8;
            ftoa( min_val, 1, t );
            j = strlen( t );
            for (i=j; i<7; i++)
               insert( t, 0, ' ' );
            memset( s, ' ', 7 );
            s[7] = '\0';
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
            change_footer( t, cell_r, wc->field, foot_row, foot_col );
            foot_col = 17;
            ftoa( max_val, 1, t );
            j = strlen( t );
            for (i=j; i<7; i++)
               insert( t, 0, ' ' );
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
            change_footer( t, cell_r, wc->field, foot_row, foot_col );
         }
         break;
      case 14 :
         for (i=0, min_day=1; i<wc->field; i++) {
            if (tmp->apd[i] == TRUE)
               if (min_day <= tmp->num[i])
                  min_day = tmp->num[i] + 1;
         }
         for (i=0; i<10; i++)
            (*limits)[cell_r].range[i].lo = min_day;
         memset( t, ' ', 31 );
         t[31] = '\0';
         change_footer( t, cell_r, wc->field, 2, 8 );
         if (min_day >= 366) {
            strcpy( t, "Days beyond 366 are not allowed" );
            change_footer( t, cell_r, wc->field, 2, 8 );
         } else {
            s[0] = '-';
            s[1] = '\0';
            change_footer( s, cell_r, wc->field, 2, 12 );
            itoa( min_day, t, 10 );
            for (i=strlen(t); i<3; i++)
               insert( t, 0, ' ' );
            change_footer( t, cell_r, wc->field, 2, 8 );
            for (i=wc->field+1, max_day=366; i<10; i++) {
               if (tmp->apd[i] == TRUE)
                  if (max_day > tmp->num[i])
                     max_day = tmp->num[i] - 1;
            }
            for (i=0; i<10; i++)
               (*limits)[cell_r].range[i].hi = max_day;
            itoa( max_day, t, 10 );
            change_footer( t, cell_r, wc->field, 2, 14 );
            for (a=tmp; a->type != 13; a=a->p);
            nyears = a->num[0] * 10;
            nyears = nyears < 10 ? 10 : nyears > 40 ? 40 : nyears;
            for (a=a->n, count_16=0; a->type == 14; a=a->n) {
               for (i=0; i<10; i++)
                  if (a->apd[i] == TRUE)
                     ++count_16;
            }
            count_16 = nyears - count_16;
            change_footer( itoa( nyears/10, t, 10 ), cell_r, wc->field, 1, 28 );
            memset( s, ' ', 2 );
            s[2] = '\0';
            change_footer( s, cell_r, wc->field, 3, 31 );
            change_footer( itoa( count_16, t, 10 ), cell_r, wc->field, 3, 31 );
            for (a=tmp,i=0; a->type != 13; a=a->p)
               if (a->type == 14)
                  i++;
            memset( s, ' ', 2 );
            s[2] = '\0';
            change_footer( s, cell_r, wc->field, 3, 7 );
            itoa( i, t, 10 );
            change_footer( t, cell_r, wc->field, 3, 7 );
         }
         break;
      case 15 :
      case 19 :
         set_relative_end( tmp, wc, min_fields, max_fields );
         break;
      case 16 :
      case 17 :
      case 18 :
         get_year_and_seg( tmp, 15, &nyears, &j, cdate, wc->field );
         memset( s, ' ', 2 );
         s[2] = '\0';
         if (tmp->type == 16 || tmp->type == 17)
            foot_col = 18;
         else
            foot_col = 31;
         foot_row = 3;
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa(nyears,t,10), cell_r, wc->field, foot_row, foot_col);
         if (tmp->type == 16 || tmp->type == 17)
            foot_col = 27;
         else
            foot_col = 40;
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa(j, t, 10), cell_r, wc->field, foot_row, foot_col );
         if (tmp->type == 16 || tmp->type == 17)
            foot_col = 38;
         else
            foot_col = 51;
         memset( s, ' ', 3 );
         s[3] = '\0';
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( cdate, cell_r, wc->field, foot_row, foot_col );
         break;
      case 20 :
      case 21 :
      case 22 :
         get_year_and_seg( tmp, 19, &nyears, &j, cdate, wc->field );
         if (tmp->type == 20)
            foot_row = 2;
         else
            foot_row = 3;
         memset( s, ' ', 2 );
         s[2] = '\0';
         if (tmp->type == 20)
            foot_col = 31;
         else
            foot_col = 18;
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa(nyears, t, 10), cell_r, wc->field, foot_row, foot_col);
         if (tmp->type == 20)
            foot_col = 40;
         else
            foot_col = 27;
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa(j, t, 10), cell_r, wc->field, foot_row, foot_col );
         if (tmp->type == 20)
            foot_col = 51;
         else
            foot_col = 38;
         memset( s, ' ', 3 );
         s[3] = '\0';
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         change_footer( cdate, cell_r, wc->field, foot_row, foot_col );
         break;
   }
   memset( t, ' ', 55 );
   t[55] = '\0';
   fast_write( 0, 24, t, cfg.f_bar );
}


void get_year_and_seg( tmp, ovr_or_chn, year, seg, cdate, field )
EROSION *tmp;
int ovr_or_chn, *year, *seg, field;
char *cdate;
{
EROSION *a;
int i, max_segs;

   for (a=tmp; a->type != ovr_or_chn; a=a->p);
   max_segs = get_field_value( a, 0 );
   for (; a->type != ovr_or_chn+1; a=a->n);
   for (*seg = *year = 1; a != tmp->n; a=a->n) {
      if (a->type == ovr_or_chn+1 && a->p->type != ovr_or_chn)
         ++*seg;
      if (*seg > max_segs) {
         *seg = 1;
         ++*year;
      }
   }
   for (a=tmp; a->type != 13; a=a->p);
   for (a=a->n,i=1; i<*year; a=a->n,i++);
   get_string_field_value( a, cdate, field );
}


void change_footer( t, type, field, foot_num, col )
char *t;
int type, field, foot_num, col;
{
int i, j;

   j = strlen( t );
   for (i=0; i < j; i++)
     (*foot_list)[type][field][foot_num].text[col+i] = t[i];
}


int  get_14_dates( tmp, nyears )
EROSION *tmp;
int nyears;
{
EROSION *a;
int i;

   for (a=tmp; a->type != 13; a=a->p);
   for (i=0; i<nyears; i++, a=a->n);
   for (i=0; (a->apd[i] != FALSE) && i < 10; i++);
   i = i == 0 ? i : --i;
   return( i );
}


void set_card4_limits( tmp )
EROSION *tmp;
{
int cell_r;

   cell_r = 4 - 4;
   if (tmp->apd[1] == TRUE)
      (*limits)[cell_r].range[0].hi = tmp->num[1];
   else
      (*limits)[cell_r].range[0].hi = 3000;
   if (tmp->apd[0] == TRUE)
      (*limits)[cell_r].range[1].lo = tmp->num[0];
   else
      (*limits)[cell_r].range[1].lo = 1582;
}


void reset_card14_limits( )
{
int i, cell_r;

   cell_r = 14 - 4;
   for (i=0; i<10; i++)
      (*limits)[cell_r].range[i].lo = 1.0;
}


void set_relative_end( tmp, wc, min_fields, max_fields )
EROSION *tmp;
WINDOW_CONTROL *wc;
int *min_fields, *max_fields;
{
int i, j, cell_r;
char t[82];

   cell_r = tmp->type - 4;
   if (tmp->apd[0] == FALSE) {
      j = 1;                    /* j = number of fields to blank */
      *max_fields = wc->view;
   } else {
      j = tmp->num[0] + 1;   /* j = number of fields to blank */
      *max_fields = j - 1;
      for (i=1; i < *max_fields; i++) {
         if (tmp->apd[i] == TRUE && tmp->num[i] == 1.0)
            set_field_value(tmp, " ", i, FALSE);
      }
      set_field_value( tmp, "1.0", *max_fields, TRUE );
   }
   for (i=j; i < 5; i++)
      set_field_value( tmp, " ", i, FALSE );
   i = 0 + 8 * wc->view;
   strncpy( t, tmp->line+i, 72 );
   t[72] = '\0';
   fast_write( wc->d_col, wc->d_row+wc->v_row, t, NORMAL );
}


void scroll_and_show( b, wc, row )
EROSION *b;
WINDOW_CONTROL *wc;
int row;
{
int i, j;
char t[82], s[10];

   scroll_window( 0, row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (j=row; b != NULL  && j < wc->max_rows + wc->d_row; b=b->n,j++) {
      if (b->type >= 1 && b->type <=3)
         fast_write( 0, j, b->line, NORMAL );
      else {
         i = 0 + 8 * wc->view;
         strncpy( t, b->line+i, 72 );
         t[72] = '\0';
         fast_write( wc->d_col, j, t, NORMAL );
         strcpy( s, itoa( b->type, s, 10 ) );
         if (strlen( s ) == 1)
            fast_write( wc->d_col-2, j, s, NORMAL );
         else
            fast_write( wc->d_col-3, j, s, NORMAL );
      }
   }
}


void refresh_screen( a, wc )
EROSION *a;
WINDOW_CONTROL *wc;
{
int i, row;

   for (i=wc->v_row; a->p!=NULL && i>0; a=a->p)
      i--;
   row = wc->d_row;
   scroll_and_show( a, wc, row );
}


void check_card4_units( tmp, wc )
EROSION *tmp;
WINDOW_CONTROL *wc;
{

   if (tmp->num[4] != units) {
      if (tmp->num[4] == ENGLISH) {
         fast_write( 63, 1, "English units", NORMAL );
         foot_list = &english_list;
         limits = &english_limits;
      } else {
         fast_write( 63, 1, "Metric units ", NORMAL );
         foot_list = &metric_list;
         limits = &metric_limits;
      }
      units = tmp->num[4];
   }
}


void check_card7( tmp, wc, row )
EROSION *tmp;
WINDOW_CONTROL *wc;
int row;
{
EROSION *a;
int diff, card_count;

   diff = 0;
   for (a=tmp->n, card_count=0; a->type == 7; a=a->n)
      ++card_count;
      /* need 1 card7 if have between 0 - 5 points,
         need 2 card7 if have between 6 - 10 points. */
   if (tmp->apd[0] == FALSE || (tmp->num[0] >= 1 && tmp->num[0] <= 5)) {
      if (card_count > 1)
         diff = -1;
   } else if (tmp->apd[0] == TRUE && tmp->num[0] >= 6 && tmp->num[0] <= 10) {
      if (card_count < 2)
         diff = 1;
   }
   if (diff != 0) {
         for (a=tmp; a->type != 8; a=a->n);
         add_remove_diff( a, diff, 7 );
         scroll_and_show( tmp, wc, row );
   }
}


void check_card9( tmp, wc, row )
EROSION *tmp;
WINDOW_CONTROL *wc;
int row;
{
int a, i, j;
char t[82];

   j = tmp->num[1];
   a = tmp->apd[1];
   if (a == FALSE || (a == TRUE && (j == 1 || j == 2 || j == 3)) ) {
      for (i=2; i < 4; i++)
         set_field_value( tmp->n, " ", i, FALSE );
      i = 0 + 8 * wc->view;
      strncpy( t, tmp->n->line+i, 72 );
      t[72] = '\0';
      ++row;
      if (row < wc->d_row + wc->max_rows)
         fast_write( wc->d_col, row, t, NORMAL );
   }
}


void check_card10( tmp, wc, row )
EROSION *tmp;
WINDOW_CONTROL *wc;
int row;
{
EROSION *a;
int i, apd, nsc, old_nsc;
char t[10];

   old_nsc = get_field_value( tmp, 7 );
   nsc = get_field_value( tmp, 0 );
   if (nsc != old_nsc) {
      old_nsc = (old_nsc << 1) - 1;
      old_nsc = old_nsc <= 0 ? 0 : old_nsc - 1;
      nsc = (nsc << 1) - 1;
      nsc = nsc <= 0 ? 0 : nsc - 1;
      for (a=tmp; a->type != 11; a=a->n);
      if (a->apd[0] == TRUE) {
         get_string_field_value( a, t, 0 );
         apd = TRUE;
      } else {
         strcpy( t, " " );
         apd = FALSE;
      }
      for (a=tmp; a->type != 10; a=a->n);
      old_nsc = old_nsc > nsc ? nsc : old_nsc;
      for (i=old_nsc; i < 10; i++)
         set_field_value( a, " ", i, FALSE );
      set_field_value( a, t, nsc, apd );
      scroll_and_show( tmp, wc, row );
      tmp->num[7] = tmp->num[0];
   }
}


void check_card13( tmp, wc, row )
EROSION *tmp;
WINDOW_CONTROL *wc;
int row;
{
EROSION *a;
int diff;
int seq, rot_years, old_rot_years, num_segs;

   if (tmp->num[0] != tmp->num[1]) {

      diff = tmp->num[0] - tmp->num[1];
              /* "a" points to first card 16 when loop is exited */
      for (a=tmp->n; a->type == 14; a=a->n);
      add_remove_diff( a, diff, 14 );
         /* if card 14 exists make 1st value 001 */
      if (tmp->n->type == 14)
         set_field_value( tmp->n, "001", 0, TRUE );

      rot_years = get_field_value( tmp, 0 );
      old_rot_years = get_field_value( tmp, 1 );

      for (a=tmp->p; a->type != 4; a=a->p);
      seq = get_field_value( a, 3 );

      for (a=tmp->n; a->type != 15; a=a->n);
      num_segs = get_field_value( a, 0 );

      diff = rot_years * num_segs - old_rot_years * num_segs;
      for (a=tmp; a->n != NULL && a->type != 19; a=a->n);
      if (a->type == 19)
         a = a->p;
      add_remove_overupdates( a, diff, 3, 16, 18 );
      if (seq >= 3 && seq <= 6) {
         for (a=tmp->n; a->type != 19; a=a->n);
         num_segs = get_field_value( a, 0 );
         diff = rot_years * num_segs - old_rot_years * num_segs;

         for (a=a->n; a->n != NULL && a->type != 19; a=a->n);
         if (a->type == 19 && (seq == 4 || seq == 6))
            a = a->p;
         add_remove_overupdates( a, diff, 3, 20, 22 );

         if (seq == 4 || seq == 6) {
            for (a=tmp; a->n != NULL; a=a->n);
            for (; a->type != 19; a=a->p);
            num_segs = get_field_value( a, 0 );
            diff = rot_years * num_segs - old_rot_years * num_segs;

            for (; a->n != NULL; a=a->n);
            add_remove_overupdates( a, diff, 3, 20, 22 );
         }
      }
      scroll_and_show( tmp, wc, row );
      tmp->num[1] = tmp->num[0];
   }
}


void check_card15_19( tmp, wc, row )
EROSION *tmp;
WINDOW_CONTROL *wc;
int row;
{
EROSION *a;
int diff;
int seq, rot_years, num_segs, old_num_segs;

   if (tmp->num[0] != tmp->num[5]) {
      for (a=tmp->p; a->type != 4; a=a->p);
      seq = get_field_value( a, 3 );

      for (a=tmp; a->type != 13; a=a->p);
      rot_years = get_field_value( a, 0 );

      num_segs = get_field_value( tmp, 0 );
      old_num_segs = get_field_value( tmp, 5 );

      diff = rot_years * num_segs - rot_years * old_num_segs;

      if (tmp->type == 15) {
         for (a=tmp; a->n != NULL && a->type != 19; a=a->n);
         if (a->type == 19)
            a = a->p;
         add_remove_overupdates( a, diff, 3, 16, 18 );
      } else {
         for (a=tmp->n; a->n != NULL && a->type != 19; a=a->n);
         if (a->type == 19 && (seq == 4 || seq == 6))
            a = a->p;
         add_remove_overupdates( a, diff, 3, 20, 22 );
      }
      scroll_and_show( tmp, wc, row );
      tmp->num[5] = tmp->num[0];
   }
}


int  get_field_value( a, field )
EROSION *a;
int field;
{
int rc;

   if (a->num[field] != 0.0)
      rc = a->num[field];
   else {
      if (a->type == 10)
         rc = 0;
      else
         rc = 1;
   }
   return( rc );
}


void set_field_value( a, t, field, t_or_f )
EROSION *a;
char *t;
int field, t_or_f;
{

   a->apd[field] = t_or_f;
   format_output( t, a->line, field );
   a->num[field] = atof( t );
}


void get_string_field_value( tmp, t, field )
EROSION *tmp;
char *t;
int field;
{
   strncpy( t, tmp->line+field*8, 8 );
   t[8] = '\0';
   while (t[0] && (t[0] == ' '))
      delete( t, 0 );
}


void add_remove_diff( a, diff, card_no )
int diff, card_no;
EROSION *a;
{
EROSION *b;
int j;

   if (diff < 0) {
      b = a->p->p;     /* back pointer b two cards and remove b->n */
      for (a=a->p, j=diff; j<0; b=b->p,j++) {
         b->n = a->n;
         a->n->p = b;
         free( a );
         a=b;
      }
   } else if (diff > 0) {
             /* back pointer b one card and add diff cards to list */
      for (b=a->p, j=diff; j>0; j--) {
         a = (EROSION *)malloc( sizeof(EROSION) );
         blank_line( a );
         a->type = card_no;
         b->n->p = a;
         a->n = b->n;
         a->p = b;
         b->n = a;
      }
   }
}


void add_remove_overupdates( a, diff, num_cards, begin, end )
int diff, num_cards, begin, end;
EROSION *a;
{
EROSION *b;
int i, j;

   if (diff < 0) {
      b = a->p;
      for (i=diff; i<0; i++) {
         for (j=0; j<num_cards; b=b->p,j++) {
            b->n = a->n;
            if (a->n != NULL)
               a->n->p = b;
            free( a );
            a=b;
         }
      }
   } else if (diff > 0) {
      for (i=diff; i>0; i--) {
         for (j=end; j>=begin; j--) {
            b = (EROSION *)malloc( sizeof(EROSION) );
            blank_line( b );
            b->type = j;
            if (a->n != NULL)
               a->n->p = b;
            b->n = a->n;
            b->p = a;
            a->n = b;
         }
      }
   }
}


                /*  This routine is bitch to follow but i'll try to explain
                 *
                 *  three general steps.
                 *  1. find the sequence already in linked list.
                 *  2. find out whut needs to be added or deleted to
                 *     make new ero sequence.
                 *  3. add new sequence cards if needed.
                 */
#define NONE  0
#define UPDAT_CHAN1 1
#define UPDAT_CHAN2 2
#define BOTH  3

void check_seqnc( tmp, wc, row )
EROSION *tmp;
WINDOW_CONTROL *wc;
int row;
{
EROSION *a, *b, *d, *e;
int diff, i, j, k, wnd_upd, old_diff, chan1, chan2, impd, updatable;
int rotation_years;
static int imp_status[6]  ={ FALSE, TRUE,  FALSE, FALSE, TRUE,  TRUE};
static int chan1_status[6]={ FALSE, FALSE, TRUE,  TRUE,  TRUE,  TRUE};
static int chan2_status[6]={ FALSE, FALSE, FALSE, TRUE,  FALSE, TRUE};

   wnd_upd = FALSE;
   updatable = NONE;
   diff = get_field_value( tmp, 3 );
   old_diff = get_field_value( tmp, 9 );
   for (b=tmp; b->type != 8 && b != NULL; b=b->n);
   if (old_diff != diff) {
      i = old_diff-1;
      impd  = imp_status[i];
      chan1 = chan1_status[i];
      chan2 = chan2_status[i];
      wnd_upd = TRUE;
      switch (diff) {
         case 1 :
            if (chan1 || chan2 || impd) {
               free_initial_parm( b, 8, 13 );
                         /* delete chan parms */
               if (chan1 || chan2) {
                  for (a=tmp; a->type != 19; a=a->n);
                  free_updatable_parm( a );
               }
            }
            j = k = 0;
            break;
         case 2 :
            if (chan1 || chan2) {
               free_initial_parm( b, 8, 12 );
                     /* delete chan parms */
               for (a=tmp; a->type != 19; a=a->n);
               free_updatable_parm( a );
            }
            if (impd)
               j = k = 0;
            else {
               j = 12;
               k = 12;
            }
            break;
         case 3:
            if (chan2 || impd) {
               d = b;
               if (chan1)
                  for (d=b->n; d->type != 11; d=d->n);
               free_initial_parm( d, 8, 13 );
               if (chan2) {      /* delete 2 channel parms */
                            /* find first chan */
                  for (a=tmp; a->type != 19; a=a->n);
                            /* find secon chan */
                  for (a=a->n; a->type != 19; a=a->n);
                            /* delete second chan */
                  free_updatable_parm( a );
               }
            }
            if (chan1)
               j = k = 0;
            else {
               j = 9;
               k = 11;
               updatable = UPDAT_CHAN1;
            }
            break;
         case 4:
            if (!chan1 && !chan2)
               updatable = BOTH;
            else if (!chan2)
               updatable = UPDAT_CHAN2;
            if (impd) {
               for (d=b; d->n->type != 12; d=d->n);
               free_initial_parm( d, 11, 13 );
            }
            if (chan1 && chan2)
               j = k = 0;
            else {
               if (!chan1)
                  chan1 = TRUE;
               else if (!chan2)
                  chan2 = TRUE;
               j = 9;
               k = 11;
            }
            break;
         case 5:
            if (!chan1)
               updatable = UPDAT_CHAN1;
            if (chan2) {
               for (d=b->n; d->type != 11; d=d->n);
               free_initial_parm( d, 8, 12 );
                         /* find first chan */
               for (a=tmp; a != NULL && a->type != 19; a=a->n);
                         /* find secon chan */
               for (a=a->n; a != NULL && a->type != 19; a=a->n);
                         /* delete second chan */
               free_updatable_parm( a );
            }
            if (chan1 && impd)
               j = k = 0;
            else if (!chan1 && impd) {
               j = 9;
               k = 11;
            } else if (chan1 && !impd) {
               for (b=b->n; b->type != 11; b=b->n);
               j = 12;
               k = 12;
            } else if (!chan1 && !impd) {
               j = 9;
               k = 12;
            }
            break;
         case 6:
            if (!chan1 && !chan2)
               updatable = BOTH;
            else if (!chan2)
               updatable = UPDAT_CHAN2;
            if (!impd) {
               if (!chan1 || !chan2) {
                  if (chan1)
                     for (b=b->n; b->type != 11; b=b->n);
                  if (!chan1)
                     chan1 = TRUE;
                  else if (!chan2)
                     chan2 = TRUE;
                  j = 9;
                  k = 12;
               } else {
                  for (b=b->n; b->n->type != 13; b=b->n);
                  j = 12;
                  k = 12;
               }
            } else {
               if (!chan1 || !chan2) {
                  if (!chan1)
                     chan1 = TRUE;
                  else if (!chan2)
                     chan2 = TRUE;
                  j = 9;
                  k = 11;
               }
            }
         break;
      }
      d = e = NULL;
      if (j != 0) {
         for (i=j; i<=k; i++) {
            a = (EROSION *)malloc( sizeof(EROSION) );
            blank_line( a );
            a->type = i;
            a->n = NULL;
            if (i == 9) {
               a->apd[0] = TRUE;
               format_output( "1", a->line, 0 );
               a->num[0] = 1.0;
               a->num[7] = 1.0;
            }
            if (i == j)
               d = e = a;
            else {
               e->n = a;
               a->p = e;
               e = a;
            }
         }
         a = b->n;
         b->n = d;
         d->p = b;
         e->n = a;
         a->p = e;
         if (diff == 4 || diff == 6) {
            if (!chan1 || !chan2) {
               for (i=9; i<=11; i++) {
                  a = (EROSION *)malloc( sizeof(EROSION) );
                  blank_line( a );
                  a->type = i;
                  a->n = NULL;
                  if (i == 9) {
                     a->apd[0] = TRUE;
                     format_output( "1", a->line, 0 );
                     a->num[0] = 1.0;
                     a->num[4] = 1.0;
                  }
                  if (i == 9)
                     d = e = a;
                  else {
                     e->n = a;
                     a->p = e;
                     e = a;
                  }
               }
               a = b->n;
               b->n = d;
               d->p = b;
               e->n = a;
               a->p = e;
            }
         }
      }

      if (updatable != NONE) {
                         /* find number of years */
         for (a=tmp; a->type != 13; a=a->n);
         rotation_years = get_field_value( a, 0 );
                      /* find first chan */
         for (; a->n != NULL && a->type != 19; a=a->n);
         if (updatable == UPDAT_CHAN1)
            fix_updatable( &a, rotation_years );
         else if (updatable == UPDAT_CHAN2) {
                      /* find secon chan */
            for (a=a->n; a->n != NULL; a=a->n);
            fix_updatable( &a, rotation_years );
         } else if (updatable == BOTH) {
            fix_updatable( &a, rotation_years );
            fix_updatable( &a, rotation_years );
         }
      }
   }
   if (wnd_upd) {
      b = tmp;
      scroll_and_show( b, wc, row );
   }
   tmp->num[9] = diff;
}


void free_initial_parm( list, start, end )
EROSION *list;
int start, end;
{
EROSION *a;

   for (a=list->n; a->type > start && a->type < end; a=list->n) {
      list->n = a->n;
      if (a->n != NULL)
         a->n->p = list;
      free( a );
   }
}


void free_updatable_parm( list )
EROSION *list;
{
EROSION *a;

   for (; list != NULL; list = list->n) {
      a = list->p;
      a->n = list->n;
      if (list->n != NULL)
         list->n->p = a;
         free( list );
      list = a;
   }
}


void fix_updatable( aa, rt )
EROSION **aa;
int rt;
{
EROSION *bb;
int i, j;

   bb = (EROSION *)malloc( sizeof(EROSION) );
   blank_line( bb );
   bb->type = 19;
   set_field_value( bb, "1", 0, TRUE );
   set_field_value( bb, "1.0", 1, TRUE );
   if ((*aa)->n != NULL)
      (*aa)->n->p = bb;
   bb->n = (*aa)->n;
   bb->p = *aa;
   (*aa)->n = bb;
   *aa = (*aa)->n;
   for (j=0; j<rt; j++) {
      for (i=20; i<23; i++) {
         bb = (EROSION *)malloc( sizeof(EROSION) );
         blank_line( bb );
         bb->type = i;
         if ((*aa)->n != NULL)
            (*aa)->n->p = bb;
         bb->n = (*aa)->n;
         bb->p = *aa;
         (*aa)->n = bb;
         *aa = (*aa)->n;
      }
   }
}
