#define VLEFT    0
#define VRIGHT   1

#define ENGLISH  0
#define METRIC   1


char *mon_names[12] = {
   "January",
   "February",
   "March",
   "April",
   "May",
   "June",
   "July",
   "August",
   "September",
   "October",
   "November",
   "December"
};


struct limit_type english_limits[32] = {
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 4 */
     0.0, 2099365.0,  0.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 1.0,
     0.0, 0.0,      0.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 3.0,
     7, 1, 1, 1, 1, 1, 1, 1, 1, 1,         9},
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 5 */
     1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,
     1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'R', 'R', 'R', 'R', 'I', 'R', 'R', 'R', 'N', 'N',   /* card 6 */
     0.00001, 10000.0,  0.0, 0.50,    0.0, 1.0,  3.3, 5.5,          0.0, 100.0,
     0.0001, 1.0,       0.0, 1000.0,  1.0, 60.0, -1000.0, 50000.0, -90.0, 90.0,
     7, 4, 3, 4, 3, 7, 7, 5, 7, 7,         9},
   { 'W', 'W', 'R', 'R', 'R', 'R', 'R', 0, 0, 0,         /* card 7 */
     0.0, 3.0,   1.0, 5.0,  1.0, 60.0,  1.0, 60.0,  1.0, 60.0,
     1.0, 60.0,  1.0, 60.0,  0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     1, 1, 5, 5, 5, 6, 6, 0, 0, 0,         6},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 8 */
     0.3, 0.65,  0.3, 0.65,  0.3, 0.65,  0.3, 0.65,  0.3, 0.65,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 9 */
     0.10, 0.45,  0.10, 0.45,  0.10, 0.45,  0.10, 0.45,  0.10, 0.45,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 10 */
     0.01, 0.45,  0.01, 0.45,  0.01, 0.45,  0.01, 0.45,  0.01, 0.45,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 11 */
     0.01, 6.0,  0.01, 6.0,  0.01, 6.0,  0.01, 6.0,  0.01, 6.0,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 12 */
     0.01, 10.0,  0.01, 10.0,  0.01, 10.0,  0.01, 10.0,  0.01, 10.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 13 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 14 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 15 */
     0.0, 14.0,  0.0, 14.0,  0.0, 14.0,  0.0, 14.0,  0.0, 14.0,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 16 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 17 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',   /* card 18 */
     0.0, 130.0,  0.0, 130.0,  0.0, 130.0,  0.0, 130.0,  0.0, 130.0,
     0.0, 130.0,  0.0, 130.0,  0.0, 130.0,  0.0, 130.0,  0.0, 130.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 19 */
     0.0, 130.0,  0.0, 130.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',   /* card 20 */
     -40.0, 90.0, -40.0, 90.0, -40.0, 90.0, -40.0, 90.0, -40.0, 90.0,
     -40.0, 90.0, -40.0, 90.0, -40.0, 90.0, -40.0, 90.0, -40.0, 90.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'N', 'N', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 21 */
    -40.0, 90.0, -40.0, 90.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',   /* card 22 */
     5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,
     5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 23 */
     5.0,1100.0,  5.0,1100.0,  0.0,0.0,  0.0,0.0,  0.0,0.0,
     0.0,0.0,      0.0,0.0,      0.0,0.0,  0.0,0.0,  0.0,0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',   /* card 24 */
     1.0, 1000.0,  1.0, 1000.0,  1.0, 1000.0,  1.0, 1000.0,  1.0, 1000.0,
     1.0, 1000.0,  1.0, 1000.0,  1.0, 1000.0,  1.0, 1000.0,  1.0, 1000.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 25 */
     1.0, 1000.0,  1.0, 1000.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',   /* card 26 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 27 */
     0.0, 100.0,  0.0, 100.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'W', 'W', 'W', 'W', 0, 0, 0, 0, 0, 0,                 /* card 28 */
     1582.0, 2100.0,  1582.0, 2100.0,  1.0, 50.0,  0.0, 50.0,  0.0, 0.0,
     0.0, 0.0,        0.0, 0.0,        0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     4, 4, 2, 0, 0, 0, 0, 0, 0, 0,         3},
   { 'W', 'W', 'W', 'W', 'R', 'R', 'W', 'W', 'W', 0,     /* card 29 */
     0.0, 90.0,    0.0, 50366.0,  0.0, 50366.0,  0.0, 50366.0,  1.0, 60.0,
     0.01, 100.0,  0.0, 1.0,      1.0, 366.0,    1.0, 366.0,    0.0, 0.0,
     2, 5, 5, 5, 5, 5, 1, 3, 3, 0,         8},
   { 'W', 'W', 'W', 'W', 'R', 'R', 'R', 0, 0, 0,         /* card 30 */
     0.0, 1.0,  0.0, 50366.0,  0.0, 50366.0,  0.0, 50366.0,  0.0, 10.0,
     0.0, 1.0,  0.0, 1.25,     0.0, 0.0,      0.0, 0.0,      0.0, 0.0,
     1, 5, 5, 5, 5, 4, 4, 0, 0, 0,         6},
   { 'W', 'W', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 31 */
     79.0, 90.0,  2.0, 50.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 2, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 32 */
     0.0, 1.0,  0.0, 7.5,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     5, 5, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'I', 'W', 'W', 'W', 0, 0, 0, 0, 0, 0,               /* card 33 */
     -1.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 1, 1, 1, 0, 0, 0, 0, 0, 0,         3},
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 34 */
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3,         9},
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 35 */
     25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,
     25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3,         9}
};


struct limit_type metric_limits[32] = {
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 4 */
     0.0, 2099365.0,  0.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 1.0,
     0.0, 0.0,      0.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 3.0,
     7, 1, 1, 1, 1, 1, 1, 1, 1, 1,         9},
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 5 */
     1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,
     1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,  1.0, 50000.0,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'R', 'R', 'R', 'R', 'I', 'R', 'R', 'R', 'N', 'N',   /* card 6 */
     0.00001, 10000.0,  0.0, 1.30,    0.0, 1.0,    3.3, 5.5,        0.0, 100.0,
     0.0001, 1.0,       0.0, 1000.0,  2.54, 152.4, -100.0, 1000.0, -90.0, 90.0,
     7, 4, 3, 4, 3, 7, 7, 6, 7, 7,         9},
   { 'W', 'W', 'R', 'R', 'R', 'R', 'R', 0, 0, 0,         /* card 7 */
     1.0, 3.0,     1.0, 5.0,     2.54, 152.4,  2.54, 152.4,  2.54, 152.4,
     2.54, 152.4,  2.54, 152.4,  0.0, 0.0,     0.0, 0.0,     0.0, 0.0,
     1, 1, 5, 5, 6, 6, 6, 0, 0, 0,         6},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 8 */
     0.3, 0.65,  0.3, 0.65,  0.3, 0.65,  0.3, 0.65,  0.3, 0.65,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 9 */
     0.10, 0.45,  0.10, 0.45,  0.10, 0.45,  0.10, 0.45,  0.10, 0.45,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 10 */
     0.01, 0.45,  0.01, 0.45,  0.01, 0.45,  0.01, 0.45,  0.01, 0.45,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 11 */
     0.01, 16.0,  0.01, 16.0,  0.01, 16.0,  0.01, 16.0,  0.01, 16.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 12 */
     0.01, 10.0,  0.01, 10.0,  0.01, 10.0,  0.01, 10.0,  0.01, 10.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     4, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 13 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 14 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 15 */
     0.0, 14.0,  0.0, 14.0,  0.0, 14.0,  0.0, 14.0,  0.0, 14.0,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 16 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,             /* card 17 */
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',   /* card 18 */
     -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,
     -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'N', 'N', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 19 */
     -20.0, 50.0,  -20.0, 50.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',   /* card 20 */
     -40.0, 35.0, -40.0, 35.0, -40.0, 35.0, -40.0, 35.0, -40.0, 35.0,
     -40.0, 35.0, -40.0, 35.0, -40.0, 35.0, -40.0, 35.0, -40.0, 35.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'N', 'N', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 21 */
    -40.0, 35.0, -40.0, 35.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',   /* card 22 */
     5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,
     5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,  5.0,1100.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 23 */
     5.0,1100.0,  5.0,1100.0,  0.0,0.0,  0.0,0.0,  0.0,0.0,
     0.0,0.0,      0.0,0.0,      0.0,0.0,  0.0,0.0,  0.0,0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',   /* card 24 */
     1.0, 1500.0,  1.0, 1500.0,  1.0, 1500.0,  1.0, 1500.0,  1.0, 1500.0,
     1.0, 1500.0,  1.0, 1500.0,  1.0, 1500.0,  1.0, 1500.0,  1.0, 1500.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 25 */
     1.0, 1500.0,  1.0, 1500.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,    0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',   /* card 26 */
     -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,
     -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,  -20.0, 50.0,
     6, 6, 6, 6, 6, 6, 6, 6, 6, 6,         9},
   { 'N', 'N', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 27 */
     -20.0, 50.0,  -20.0, 50.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     6, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'W', 'W', 'W', 'W', 0, 0, 0, 0, 0, 0,                 /* card 28 */
     1582.0, 2100.0,  1582.0, 2100.0,  1.0, 50.0,  0.0, 50.0,  0.0, 0.0,
     0.0, 0.0,        0.0, 0.0,        0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     4, 4, 2, 0, 0, 0, 0, 0, 0, 0,         3},
   { 'W', 'W', 'W', 'W', 'R', 'R', 'W', 'W', 'W', 0,     /* card 29 */
     0.0, 90.0,   0.0, 50366.0,  0.0, 50366.0,  0.0, 50366.0,  0.0, 152.0,
     0.01, 50.0,  0.0, 1.0,      1.0, 366.0,    1.0, 366.0,    0.0, 0.0,
     2, 5, 5, 5, 5, 5, 1, 3, 3, 0,         8},
   { 'W', 'W', 'W', 'W', 'R', 'R', 'R', 0, 0, 0,          /* card 30 */
     0.0, 1.0,  0.0, 50366.0,  0.0, 50366.0,  0.0, 50366.0,  0.0, 25.0,
     0.0, 1.0,  0.0, 1.25,     0.0, 0.0,      0.0, 0.0,      0.0, 0.0,
     1, 5, 5, 5, 5, 4, 4, 0, 0, 0,         6},
   { 'W', 'W', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 31 */
     79.0, 90.0,  2.0, 50.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,    0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 2, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                   /* card 32 */
     0.0, 1.0,  0.0, 7.5,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     5, 5, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'I', 'W', 'W', 'W', 0, 0, 0, 0, 0, 0,               /* card 33 */
     -1.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 1.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 1, 1, 1, 0, 0, 0, 0, 0, 0,         3},
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 34 */
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3,         9},
   { 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W',   /* card 35 */
     25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,
     25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,  25.0, 100.0,
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3,         9}
};



#define  WC_BEG_VROW   0
#define  WC_MAX_ROWS   2
#define  WC_D_COL      4
#define  WC_D_ROW      6
#define  WC_OFFSET     8
#define  WC_V_ROW      10
#define  WC_R_ROW      12
#define  WC_FIELD      14
#define  WC_VIEW       16


#define   TMP_LINE   0
#define   TMP_NUM    1*82
#define   TMP_APD    TMP_NUM+4*10
#define   TMP_TYPE   TMP_APD+1*10
#define   TMP_N      TMP_TYPE+2
#define   TMP_P      TMP_N+4


struct screen hbdate[] = {
  {20,0,"HBDATE  Beginning date (year and Julian day) for hydrology simulation."},
  {21,8,"Range : 0 - 2099365 "},
  {0,0,NULL}
};

struct screen hydout[] = {
  {20,0,"HYDOUT  0 for annual summary hydrology output."},
  {21,8,"1 for storm-by-storm hydrology output."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen flgpen[] = {
  {20,0,"FLGPEN  0  Priestly-Taylor ET  --  forest and humid climates."},
  {21,8,"1  Penman-Monteith ET  --   arid climates."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen flgnut[] = {
  {20,0,"FLGNUT  0 nutrients are *NOT* run in this simulation."},
  {21,8,"1  nutrients simulation is to be made."},
  {22,8,"Range : 0 - 1 "},
  {0,0,NULL}
};

struct screen flgpst[] = {
  {20,0,"FLGPST  0 pesticides are *NOT* to be simulated."},
  {21,8,"1 pesticides are to be simulated."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen flggen[] = {
  {20,0,"FLGGEN  Weather generator flag."},
  {21,8,"Range : 0 - 0"},
  {0,0,NULL}
};

struct screen flgmet[] = {
  {20,0,"FLGMET  0 climate and paramater data are in English units."},
  {21,8,"1 climate and paramater data are in metric units."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen flgtmp[] = {
  {20,0,"FLGTMP  0 do not read in mean daily temperature file."},
  {21,8,"1 open mean daily temperature file to determine rain/snow."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen bckend[] = {
  {20,0,"BCKEND  0 no selected variables output file created."},
  {21,8,"1 create selected variables output file."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen bckout[] = {
  {20,0,"BCKOUT  up to 20 variables can be written to output file."},
  {21,8,"Range : 1 - 50000"},
  {24,0," F1 = Help"}
};

struct screen forest[] = {
  {20,0,"FOREST  agricultural or forest application."},
  {21,8,"Range : 0 - 3"},
  {24,0," F1 = Help"}
};

struct screen darea[] = {
  {20,0,"DAREA   Total drainage area of the field, acres."},
  {21,8,"Range : 0.00001  -  10000.0"},
  {0,0,NULL}
};

struct screen mdarea[] = {
  {20,0,"DAREA   Total drainage area of the field, hectares."},
  {21,8,"Range : 0.00001  -  10000.0"},
  {0,0,NULL}
};


struct screen rc[] = {
  {20,0,"RC      Effective saturated conductivity of the soil horizon"},
  {21,8,"immediately below the root zone, in/hr."},
  {22,8,"Range : .0 - .50"},
  {24,0," F1 = Help"}
};

struct screen mrc[] = {
  {20,0,"RC      Effective saturated conductivity of the soil horizon"},
  {21,8,"immediately below the root zone, cm/hr."},
  {22,8,"Range : .0 - 1.30"},
  {24,0," F1 = Help"}
};


struct screen bst[] = {
  {20,0,"BST     Fraction of plant available water in the soil when simulation"},
  {21,8,"begins."},
  {22,8,"Range : 0.0 - 1.0"},
  {0,0,NULL}
};

struct screen cona[] = {
  {20,0,"CONA    Soil evaporation parameter, dependent upon soil texture."},
  {21,8,"Range : 3.3 - 5.5"},
  {24,0," F1 = Help"}
};

struct screen fcona[] = {
  {20,0,"CONA    Soil evaporation parameter, dependent upon soil texture."},
  {21,8,"3.0 is recommended for forest simulations."},
  {22,8,"Range : 3.0 - 5.5"},
  {24,0," F1 = Help"}
};

struct screen cn2[] = {
  {20,0,"CN2     SCS curve number for moisture condition II."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

/*
struct screen cn2[] = {
  {20,0,"CN2     SCS curve number for moisture condition II."},
  {21,8,"-1 add card 34 and 35 for CN2 updates within year."},
  {22,8,"-2 slope adjust CN2 updates on card 34 and 35."},
  {23,8,"Range : -2 - 100"},
  {0,0,NULL}
};
*/
struct screen chs[] = {
  {20,0,"CHS     Hydraulic slope of the field, ft/ft."},
  {21,8,"Range : 0.0001 - 1.0"},
  {24,0," F1 = Help"}
};

struct screen mchs[] = {
  {20,0,"CHS     Hydraulic slope of the field, m/m."},
  {21,8,"Range : 0.0001 - 1.0"},
  {24,0," F1 = Help"}
};


struct screen wlw[] = {
  {20,0,"WLW     Ratio of field length to field width."},
  {21,8,"Range : 0.0 - 1000.0"},
  {24,0," F1 = Help"}
};


struct screen rd[] = {
  {20,0,"RD      Effective rooting depth, inches."},
  {21,8,"Range : 1.0 - 60.0"},
  {0,0,NULL}
};

struct screen mrd[] = {
  {20,0,"RD      Effective rooting depth, centimeters."},
  {21,8,"Range : 2.54 - 152.4"},
  {0,0,NULL}
};


struct screen elev[] = {
  {20,0,"ELEV    Elevation of site above mean sea level, feet."},
  {21,8,"Range : -1000.0 - 50000.0"},
  {0,0,NULL}
};


struct screen elevm[] = {
  {20,0,"ELEV    Elevation of site above mean sea level, meters."},
  {21,8,"Range : -100.0 - 10000.0"},
  {0,0,NULL}
};


struct screen lat[] = {
  {20,0,"LAT     Latitude of site, degrees (negative south of equator.)"},
  {21,8,"Range : -90.0 - 90.0"},
  {0,0,NULL}
};


struct screen isoil[] = {
  {20,0,"ISOIL  Code for soil phosphorus sorption."},
  {21,8,"Range : 0 - 3"},
  {24,0," F1 = Help"}
};

struct screen nosohz[] = {
  {20,0,"NOSOHZ  Number of soil horizons in the rootzone."},
  {21,8,"Range : 1 - 5"},
  {0,0,NULL}
};

struct screen bothor[] = {
  {20,0,"BOTHOR  Depth to the bottom of each soil horizon, inches."},
  {21,8,"Range :  1.0 - 60.0 "},
  {24,41,"Horizon =   "}
};

struct screen mbothor[] = {
  {20,0,"BOTHOR  Depth to the bottom of each soil horizon, cm."},
  {21,8,"Range :   2.54 - 152.4  "},
  {24,41,"Horizon =   "}
};


struct screen por[] = {
  {20,0,"POR     Porosity for each soil horizon, in**3 / in**3."},
  {21,8,"Range : 0.3  - 0.65"},
  {24,0," F1 = Help                               Horizon =  "}
};

struct screen mpor[] = {
  {20,0,"POR     Porosity for each soil horizon, cc**3 / cc**3."},
  {21,8,"Range : 0.3  - 0.65"},
  {24,0," F1 = Help                               Horizon =  "}
};


struct screen fc[] = {
  {20,0,"FC      Field capacity of each soil horizon, in/in."},
  {21,8,"Range : 0.10 - 0.45  "},
  {24,0," F1 = Help                               Horizon =  "}
};

struct screen mfc[] = {
  {20,0,"FC      Field capacity of each soil horizon, cm/cm."},
  {21,8,"Range : 0.10 - 0.45  "},
  {24,0," F1 = Help                               Horizon =  "}
};


struct screen br15[] = {
  {20,0,"BR15    Wilting point (immobile soil water content) of each soil"},
  {21,8,"horizon, in/in."},
  {22,8,"Range : 0.01 - 0.45  "},
  {24,0," F1 = Help                               Horizon =  "}
};

struct screen mbr15[] = {
  {20,0,"BR15    Wilting point (immobile soil water content) of each soil"},
  {21,8,"horizon, cm/cm."},
  {22,8,"Range : 0.01 - 0.45  "},
  {24,0," F1 = Help                               Horizon =  "}
};


struct screen satk[] = {
  {20,0,"SATK    Effective saturated conductivity for each soil"},
  {21,8,"horizon, in/hr."},
  {22,8,"Range : 0.01 - 6.0 "},
  {24,0," F1 = Help                               Horizon =  "}
};

struct screen msatk[] = {
  {20,0,"SATK    Effective saturated conductivity for each soil"},
  {21,8,"horizon, cm/hr."},
  {22,8,"Range : 0.01 - 16.0 "},
  {24,0," F1 = Help                               Horizon =  "}
};


struct screen om[] = {
  {20,0,"OM      Organic matter content of each soil horizon (percent of soil mass)."},
  {21,8,"Range : 0.01 - 10.0"},
  {24,41,"Horizon =   "}
};


struct screen clay[] = {
  {20,0,"CLAY    Percent of soil mass in this horizon with particle size qual to"},
  {21,8,"or less than 0.002 mm, e.g. 10.0."},
  {22,8,"Range : 0.0 - 100.0"},
  {24,0," F1 = Help                               Horizon =  "}
};


struct screen silt[] = {
  {20,0,"SILT    Percent of soil mass in this horizon with particle size greater"},
  {21,8,"than 0.002 mm and less than 0.05 mm, e.g. 15.0."},
  {22,8,"Range : 0.0 - 100.0"},
  {24,0," F1 = Help                               Horizon =  "}
};


struct screen ph[] = {
  {20,0,"PH      Soil pH in this horizon, e.g. 7.0."},
  {21,8,"Range : 0.0 - 14.0"},
  {24,41,"Horizon =   "}
};


struct screen bsat[] = {
  {20,0,"BSAT    Base saturation, percent, in this horizon, e.g. 37.2."},
  {21,8,"Range : 0.0 - 100.0"},
  {24,41,"Horizon =   "}
};


struct screen caco3[] = {
  {20,0,"CACO3   Calcium carbonate content, percent, in this horizon, e.g. 4.0."},
  {21,8,"Range : 0.0 - 100.0"},
  {24,41,"Horizon =   "}
};


struct screen tempx[] = {
  {20,0,"TEMPX   Mean monthly maximum temperature for each month, degrees F."},
  {21,8,"Range :   0.0 - 130.0"},
  {24,35,"                  "}
};

struct screen mtempx[] = {
  {20,0,"TEMPX   Mean monthly maximum temperature for each month, degrees C."},
  {21,8,"Range : -20.0 - 50.0"},
  {24,35,"                  "}
};


struct screen tempn[] = {
  {20,0,"TEMPN   Mean monthly minimum temperature for each month, degrees F."},
  {21,8,"Range :  -40.0 - 90.0 "},
  {24,35,"                  "}
};

struct screen mtempn[] = {
  {20,0,"TEMPN   Mean monthly minimum temperature for each month, degrees C."},
  {21,8,"Range :  -40.0 - 35.0 "},
  {24,35,"                  "}
};


struct screen rad[] = {
  {20,0,"RAD     Mean monthly solar radiation for each month, Langleys (MJ/sq. cm)."},
  {21,8,"Range :  5.0 - 1100.0  "},
  {24,35,"                  "}
};

struct screen wind[] = {
  {20,0,"WIND    Mean monthly wind movement for each month, miles/day."},
  {21,8,"Range :  1.0 - 1000.0  "},
  {24,35,"                  "}
};

struct screen mwind[] = {
  {20,0,"WIND    Mean monthly wind movement for each month, km/day."},
  {21,8,"Range :  1.0 - 1500.0  "},
  {24,35,"                  "}
};

struct screen dewpt[] = {
  {20,0,"DEWPT   Mean monthly dew point for each month, degrees F."},
  {21,8,"Range :  0.0 - 100.0  "},
  {24,35,"                  "}
};

struct screen mdewpt[] = {
  {20,0,"DEWPT   Mean monthly dew point for each month, degrees C."},
  {21,8,"Range :  -20.0 - 50.0  "},
  {24,35,"                  "}
};

struct screen hbyr[] = {
  {20,0,"HBYR    Beginning year of hydrology simulation."},
  {21,8,"Range :    0 -    0  "},
  {24,0,"                                   "}
};

struct screen heyr[] = {
  {20,0,"HEYR    Ending year of hydrology simulation."},
  {21,8,"Range :    0 -    0  "},
  {24,0,"                                   "}
};

struct screen irot[] = {
  {20,0,"IROT    Number of years in rotation cycle."},
  {21,8,"Range : 1 - 50"},
  {24,0,"                                   "}
};

struct screen nyrfor[] = {
  {20,0,"NYRFOR    Beginning year of forest simulation cycle."},
  {21,8,"Range : 0 - 50"},
  {24,0,"                                   "}
};

struct screen crop[] = {
  {20,0,"ICROP   Crop code.   Press F2 to add a crop."},
  {21,8,"Range : 1 - 90  "},
  {24,0," F1 = Help   F2 = Add   F3 = Delete"}
};

struct screen plant[] = {
  {20,0,"DPLANT  Planting date (Julian)."},
  {21,8,"Range : 1 - 50366     "},
  {24,0," F1 = Help   F2 = Add   F3 = Delete"}
};

struct screen harvst[] = {
  {20,0,"DHRVST  Harvest date (Julian)."},
  {21,8,"Range : 1 - 50366     "},
  {24,0," F1 = Help   F2 = Add   F3 = Delete"}
};

struct screen truncd[] = {
  {20,0,"DTRUNC  Date, if any, that crop is plowed under (Julian)."},
  {21,8,"Range : 1 - 50366     "},
  {24,0," F1 = Help   F2 = Add   F3 = Delete"}
};

struct screen ccrd[] = {
  {20,0,"CCRD    Current crop (ICROP) rooting depth, inches, e. g. 12.0."},
  {21,8,"Range : 1 - 60    "},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen mccrd[] = {
  {20,0,"CCRD    Current crop (ICROP) rooting depth, cm, e. g. 30.0."},
  {21,8,"Range : 1 - 152   "},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen crphtx[] = {
  {20,0,"CRPHTX  Maximun crop height, feet, e. g. 6.0."},
  {21,8,"Range : .01 - 100    "},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen mcrphtx[] = {
  {20,0,"CRPHTX  Maximum crop height, meters, e. g. 1.5."},
  {21,8,"Range : .01 - 50   "},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen pernnl[] = {
  {20,0,"PERNNL  Code to designate perennial crops."},
  {21,8,"0  for annual (non-perennial crop"},
  {22,8,"1  for perennial crop"},
  {23,8,"Range : 0 - 1"},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen beggro[] = {
  {20,0,"BEGGRO  Julian day for beginning of growth for hardwood or pine-hardwood"},
  {21,8,"mixture, or perennial agricultural crop such as grass."},
  {22,8,"Range :   1 - 366  "},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen endgro[] = {
  {20,0,"ENDGRO  Julian day for end of growth of forest or perennial."},
  {21,8,"Range :   1 - 366  "},
  {24,0,"             F2 = Add   F3 = Delete"}
};

struct screen iropt[] = {
  {20,0,"IROPT   0 if irrigation is not to be applied by the model."},
  {21,8,"1 if irrigation is to be applied on demand by the model."},
  {22,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen ibdate[] = {
  {20,0,"DBIRR   Date, if any, to begin considering irrigation, year of rotation"},
  {21,8,"cycle and Julian day."},
  {22,8,"Range : 1 - 50366          "},
  {24,0," F1 = Help                         "}
};

struct screen iedate[] = {
  {20,0,"DEIRR   Date, if any, to stop considering irrigation, year of rotation"},
  {21,8,"cycle and Julian day."},
  {22,8,"Range : 1 - 50366          "},
  {24,0," F1 = Help                         "}
};

struct screen dpreir[] = {
  {20,0,"DPREIR  Date, if any, to consider preplant irrigation, year of rotation"},
  {21,8,"cycle and Julian day."},
  {22,8,"Range : 1 - 50366          "},
  {24,0," F1 = Help                         "}
};

struct screen preirr[] = {
  {20,0,"PREIRR  Equivalent depth of preplanting irrigation to be applied, in, e.g. 6.0"},
  {21,8,"Range : 0.0 - 10.0"},
  {0,0,NULL}
};

struct screen mpreirr[] = {
  {20,0,"PREIRR  Equivalent depth of preplanting irrigation to be applied, cm, e.g. 15.0"},
  {21,8,"Range : 0.0 - 25.0"},
  {0,0,NULL}
};

struct screen basei[] = {
  {20,0,"BASEI   Fraction of plant available water content in the rootzone when"},
  {21,8,"the model is to apply irrigation."},
  {22,8,"Range : 0.0 - 1.0"},
  {0,0,NULL}
};

struct screen topi[] = {
  {20,0,"TOPI    Fraction of plant available water content in the rootzone"},
  {21,8,"desired after irrigation."},
  {22,8,"Range : 0.0 - 1.25"},
  {0,0,NULL}
};


struct screen icrop[] = {
  {20,0,"ICROP   For this crop code, the LAI curve will be specified by the"},
  {21,8,"user."},
  {22,8,"Range : 79 - 90"},
  {0,0,NULL}
};

struct screen nolai[] = {
  {20,0,"NOLAI   Number of points in the growing season needed to define"},
  {21,8,"the LAI curve."},
  {22,8,"Range : 2 - 50"},
  {0,0,NULL}
};

struct screen usrfrc[] = {
  {20,0,"USRFRC  Fraction of the growing season defined by LAI point."},
  {21,8,"Range : 0.0 - 1.0       "},
  {0,0,NULL}
};

struct screen usrlai[] = {
  {20,0,"USRLAI  Leaf area index (LAI) at fraction of growing season (sq. m of"},
  {21,8,"leaf area/ sq m of soil)."},
  {22,8,"Range : 0.0 - 7.5  "},
  {0,0,NULL}
};

struct screen area[] = {
  {20,0,"AREA    Leaf area index (sq. m of leaf area/sq m of soil)."},
  {21,8,"Range : 0 - 7.5 "},
  {24,0," F1 = Help   F2 = Add   F3 = Delete"}
};


struct screen newt[] = {
  {20,0,"NEWT    0  use same temperature values from previous year."},
  {21,8,"1  read two new set of 12 monthly maximum and minimum temperature."},
  {22,8,"Range : 0 - 1 "},
  {24,0,"                                            Year =   "}
};

struct screen newr[] = {
  {20,0,"NEWR    0 use the same radiation values from previous year."},
  {21,8,"1 read a new set of 12 monthly radiation values."},
  {22,8,"Range : 0 - 1"},
  {24,0,"                                            Year =   "}
};


struct screen neww[] = {
  {20,0,"NEWW    0 use the same wind values from previous year."},
  {21,8,"1 read a new set of 12 monthly wind values."},
  {22,8,"Range : 0 - 1"},
  {24,0,"                                            Year =   "}
};


struct screen newd[] = {
  {20,0,"NEWD    0 use the same dew point values from previous year."},
  {21,8,"1 read a new set of 12 monthly dew point values."},
  {22,8,"Range : 0 - 1"},
  {24,0,"                                            Year =   "}
};


struct screen julrcn[] = {
  {20,0,"JULRCN  Julian date to update curve number."},
  {21,8,"Range :   1 - 366 "},
  {24,0,"                                            Year =   "}
};


struct screen newrcn[] = {
  {20,0,"NEWRCN  New curve number to take effect on JULRCN."},
  {21,8,"Range :   25 - 100"},
  {24,0,"                                            Year =   "}
};


struct screen *english_list[32][10] = {
 {hbdate, hydout, flgpen, flgnut, flgpst, flggen, flgmet, flgtmp,bckend,forest},
 {bckout, bckout, bckout, bckout, bckout, bckout, bckout, bckout,bckout,bckout},
 {darea,  rc,     bst,    cona,   cn2,    chs,    wlw,    rd,    elev,  lat},
 {isoil,  nosohz, bothor, bothor, bothor, bothor, bothor, NULL,  NULL,  NULL},
 {por,    por,    por,    por,    por,    NULL,   NULL,   NULL,  NULL,  NULL},
 {fc,     fc,     fc,     fc,     fc,     NULL,   NULL,   NULL,  NULL,  NULL},
 {br15,   br15,   br15,   br15,   br15,   NULL,   NULL,   NULL,  NULL,  NULL},
 {satk,   satk,   satk,   satk,   satk,   NULL,   NULL,   NULL,  NULL,  NULL},
 {om,     om,     om,     om,     om,     NULL,   NULL,   NULL,  NULL,  NULL},
 {clay,   clay,   clay,   clay,   clay,   NULL,   NULL,   NULL,  NULL,  NULL},
 {silt,   silt,   silt,   silt,   silt,   NULL,   NULL,   NULL,  NULL,  NULL},
 {ph,     ph,     ph,     ph,     ph,     NULL,   NULL,   NULL,  NULL,  NULL},
 {bsat,   bsat,   bsat,   bsat,   bsat,   NULL,   NULL,   NULL,  NULL,  NULL},
 {caco3,  caco3,  caco3,  caco3,  caco3,  NULL,   NULL,   NULL,  NULL,  NULL},
 {tempx,  tempx,  tempx,  tempx,  tempx,  tempx,  tempx,  tempx, tempx, tempx},
 {tempx,  tempx,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {tempn,  tempn,  tempn,  tempn,  tempn,  tempn,  tempn,  tempn, tempn, tempn},
 {tempn,  tempn,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {rad,    rad,    rad,    rad,    rad,    rad,    rad,    rad,   rad,   rad},
 {rad,    rad,    NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {wind,   wind,   wind,   wind,   wind,   wind,   wind,   wind,  wind,  wind},
 {wind,   wind,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {dewpt,  dewpt,  dewpt,  dewpt,  dewpt,  dewpt,  dewpt,  dewpt, dewpt, dewpt},
 {dewpt,  dewpt,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {hbyr,   heyr,   irot,   nyrfor, NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {crop,   plant,  harvst, truncd, ccrd,   crphtx, pernnl, beggro,endgro,NULL},
 {iropt,  ibdate, iedate, dpreir, preirr, basei,  topi,   NULL,  NULL,  NULL},
 {icrop,  nolai,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {usrfrc, usrlai, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {newt,   newr,   neww,   newd,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {julrcn, julrcn, julrcn, julrcn, julrcn, julrcn, julrcn, julrcn,julrcn,julrcn},
 {newrcn, newrcn, newrcn, newrcn, newrcn, newrcn, newrcn, newrcn,newrcn,newrcn}
};


struct screen *metric_list[32][10] = {
 {hbdate, hydout, flgpen, flgnut, flgpst, flggen, flgmet, flgtmp,bckend,forest},
 {bckout, bckout, bckout, bckout, bckout, bckout, bckout, bckout,bckout,bckout},
 {mdarea, mrc,    bst,    cona,   cn2,    mchs,   wlw,    mrd,   elevm, lat},
 {isoil,  nosohz, mbothor,mbothor,mbothor,mbothor,mbothor,NULL,  NULL,  NULL},
 {mpor,   mpor,   mpor,   mpor,   mpor,   NULL,   NULL,   NULL,  NULL,  NULL},
 {mfc,    mfc,    mfc,    mfc,    mfc,    NULL,   NULL,   NULL,  NULL,  NULL},
 {mbr15,  mbr15,  mbr15,  mbr15,  mbr15,  NULL,   NULL,   NULL,  NULL,  NULL},
 {msatk,  msatk,  msatk,  msatk,  msatk,  NULL,   NULL,   NULL,  NULL,  NULL},
 {om,     om,     om,     om,     om,     NULL,   NULL,   NULL,  NULL,  NULL},
 {clay,   clay,   clay,   clay,   clay,   NULL,   NULL,   NULL,  NULL,  NULL},
 {silt,   silt,   silt,   silt,   silt,   NULL,   NULL,   NULL,  NULL,  NULL},
 {ph,     ph,     ph,     ph,     ph,     NULL,   NULL,   NULL,  NULL,  NULL},
 {bsat,   bsat,   bsat,   bsat,   bsat,   NULL,   NULL,   NULL,  NULL,  NULL},
 {caco3,  caco3,  caco3,  caco3,  caco3,  NULL,   NULL,   NULL,  NULL,  NULL},
 {mtempx, mtempx, mtempx, mtempx, mtempx, mtempx, mtempx, mtempx,mtempx,mtempx},
 {mtempx, mtempx, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {mtempn, mtempn, mtempn, mtempn, mtempn, mtempn, mtempn, mtempn,mtempn,mtempn},
 {mtempn, mtempn, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {rad,    rad,    rad,    rad,    rad,    rad,    rad,    rad,   rad,   rad},
 {rad,    rad,    NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {mwind,  mwind,  mwind,  mwind,  mwind,  mwind,  mwind,  mwind, mwind, mwind},
 {mwind,  mwind,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {mdewpt, mdewpt, mdewpt, mdewpt, mdewpt, mdewpt, mdewpt, mdewpt,mdewpt,mdewpt},
 {mdewpt, mdewpt, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {hbyr,   heyr,   irot,   nyrfor, NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {crop,   plant,  harvst, truncd, mccrd,  mcrphtx,pernnl, beggro,endgro,NULL},
 {iropt,  ibdate, iedate, dpreir, mpreirr,basei,  topi,   NULL,  NULL,  NULL},
 {icrop,  nolai,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {usrfrc, usrlai, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {newt,   newr,   neww,   newd,   NULL,   NULL,   NULL,   NULL,  NULL,  NULL},
 {julrcn, julrcn, julrcn, julrcn, julrcn, julrcn, julrcn, julrcn,julrcn,julrcn},
 {newrcn, newrcn, newrcn, newrcn, newrcn, newrcn, newrcn, newrcn,newrcn,newrcn}
};
