#define VLEFT    0
#define VRIGHT   1

typedef struct {
   int  beg_vrow;
   int  max_rows;
   int  d_col;
   int  d_row;
   int  offset;
   int  v_row;
   int  r_row;
   int  field;
   int  view;
} WINDOW_CONTROL;

struct card_parse {
  int c_no;
  int flgseq;
  int num_chans;
  int nptso;
  int seen1_9;
  int seen2_9;
  int nyears;
  int ncdates;
  int nxf;
  int over_set;
  int seen19;
  int nxc;
  int chan_set;
  int eof;
};


struct screen set_colors_screen[] = {
			  {1, 25, "Foreground      Background"},
   {2, 2,  "Menu Bar            [             ]     [       ]"},
   {3, 2,  "Menu Key            [             ]     [       ]"},
   {4, 2,  "Menu Bar Selection  [             ]     [       ]"},
   {6, 2,  "Window Border       [             ]     [       ]"},
   {7, 2,  "Window List         [             ]     [       ]"},
   {8, 2,  "Window Selection    [             ]     [       ]"},
  {10, 2,  "Worksheet Field     [             ]     [       ]"},
  {11, 2,  "Help Table Field    [             ]     [       ]"},
  {13, 2,  "Function-key Bar    [             ]     [       ]"},
  {15, 25, "<Ok>   <Cancel>"},
   {0, 0,  NULL}
};


struct color_posn {
   int f_col, f_row, b_col, b_row;
} c_posn[] = {
   { 23, 2, 43, 2 },
   { 23, 3, 43, 3 },
   { 23, 4, 43, 4 },
   { 23, 6, 43, 6 },
   { 23, 7, 43, 7 },
   { 23, 8, 43, 8 },
   { 23, 10, 43, 10 },
   { 23, 11, 43, 11 },
   { 23, 13, 43, 13 }
};


#define FOREGROUND   0
#define BACKGROUND   1

#define FORE_LENGTH 13
#define BACK_LENGTH  7


typedef struct ero_node {
   char   line[82];
   float  num[10];
   char   apd[10];
   int    type;
   struct ero_node *n;
   struct ero_node *p;
}EROSION;


#define   TMP_LINE   0
#define   TMP_NUM    1*82
#define   TMP_APD    TMP_NUM+4*10
#define   TMP_TYPE   TMP_APD+1*10
#define   TMP_N      TMP_TYPE+2
#define   TMP_P      TMP_N+4


struct screen help_keys[] = {
   {1, 2,  "Left             Move cursor left one character"},
   {2, 2,  "Right            Move cursor right one character"},
   {3, 2,  "Home             Move cursor to beginning of field"},
   {4, 2,  "End              Move cursor to end of field"},
   {5, 2,  "Up               Move cursor to line above"},
   {6, 2,  "Down             Move cursor to line below"},
   {7, 2,  "Return (Enter)   Move cursor right one field"},
   {8, 2,  "Control + Left   Move cursor left one field"},
   {9, 2,  "Shift + Tab      Move cursor left one field"},
  {10, 2,  "Control + Right  Move cursor right one field"},
  {11, 2,  "Tab              Move cursor right one field"},
  {12, 2,  "Insert           Toggle insert mode on and off"},
  {13, 2,  "Delete           Delete character under cursor"},
  {14, 2,  "Backspace        Move cursor left and Delete"},
  {15, 2,  "Page Up          Scroll screen up one page"},
  {16, 2,  "Page Down        Scroll screen down one page"},
  {17, 2,  "Alt + F1         Expert key - Override range checking"},
  {19, 25, "<Ok>"},
   {0, 0,  NULL}
};


struct screen help_rot[] = {
   {1, 2,  "GLEAMS has two options when specifying the"},
   {2, 2,  "erosion input parameters.  Option 0 reuses the"},
   {3, 2,  "parameters after the period of rotation is"},
   {4, 2,  "completed.  Option 1 expects annual updates of"},
   {5, 2,  "the parameters after the initial period of"},
   {6, 2,  "erosion is completed.  At present, the parameter"},
   {7, 2,  "editor only supports Option 0 - the rotation"},
   {8, 2,  "option."},
  {10, 25, "<Ok>"},
   {0, 0,  NULL}
};

struct screen load_screen[] = {
   {1, 15, "Load worksheet from a file"},
   {3, 2,  "WARNING:  Results are unpredictable if file is not"},
   {4, 5,  "in GLEAMS 2.0 erosion parameter format!"},
   {6, 2,  "Enter file name : "},
   {8, 23, "<Cancel>"},
   {0, 0,  NULL}
};
