/****************   global structure definitions  ***************/

typedef struct {
   int  beg_vrow;
   int  max_rows;
   int  d_col;
   int  d_row;
   int  offset;
   int  v_row;
   int  r_row;
   int  field;
   int  view;
} WINDOW_CONTROL;


typedef struct nut_node {
   char   line[82];
   float  num[10];
   char   apd[10];
   int    type;
   struct nut_node *n;
   struct nut_node *p;
} NUTRIENT;




typedef struct {
   int dply_col;
   int dply_row;
   int line_length;
   int avail_lines;
   int v_row;
   int select;
   int num_entries;
   int ulft_col;
   int ulft_row;
   int total_col;
   int total_row;
} HELP_WINDOW;


struct card_parse {
  int c_no;
  int isoil;
  int nf;
  int ntil;
  int eof;
};


struct win_vars {
   int wid;
   int hgt;
   int d_col;
   int d_row;
   int fld;
   int max_fld;
   int c;
   int r;
   int f_b;
   int f_clr;
   int b_clr;
};


struct temp_c_scheme {
   int m_bar;
   int m_alt;
   int m_select;
   int w_outline;
   int w_list;
   int w_select;
   int cursor;
   int help_tbl;
   int f_bar;
};


struct sample_vars {
   int left_bar_c;
   int left_bar_r;
   int left_alt_c;
   int left_alt_r;
   int head_c;
   int head_r;
   int right_bar_c;
   int right_bar_r;
   int right_alt_c;
   int right_alt_r;
   int win_c;
   int win_r;
   int win_wid;
   int win_hgt;
   int list1_c;
   int list1_r;
   int select_c;
   int select_r;
   int list2_c;
   int list2_r;
   int cursor_c;
   int cursor_r;
   int help_tbl_c;
   int help_tbl_r;
   int f_bar_c;
   int f_bar_r;
};


struct dir_struct {
   int row, col, wid, hgt;
   int num_cols, num_lines;
   int flist_col[4];
};


typedef struct {
   char *line;
   char *value;
} TABLE_TYPE;


/************** function prototypes for nutrient editor  **************/
/*************** functions in nut1.c ******************/
int  init_from_file( NUTRIENT **, char * );
void init_all_cards( NUTRIENT ** );
void blank_line( NUTRIENT * );
void intro( void );
void work_screen( NUTRIENT *, WINDOW_CONTROL );
void show_list( NUTRIENT *, WINDOW_CONTROL * );
void get_title( NUTRIENT **, NUTRIENT **, WINDOW_CONTROL *, int *, int * );
void link_list_editor( NUTRIENT **, WINDOW_CONTROL *, int );
void format_output( char *, char *, int, int );
int  range_not_ok( char *, double, double );
void show_footer( struct screen *, WINDOW_CONTROL );
void write_filename( char * );
void quit( NUTRIENT *, int * );
void save( NUTRIENT * );
/*************** functions in nut4.c ******************/
void get_card4_24( NUTRIENT **, NUTRIENT **, WINDOW_CONTROL *, int *, int * );
void setup_field( NUTRIENT *, int, int, char * );
void change_min_max_limits( NUTRIENT *, WINDOW_CONTROL *, int *, int * );
void change_field_info_structs( NUTRIENT *, WINDOW_CONTROL * );
void change_footer( char *, int, int, int, int );
void change_nopest_footer( int, int, int, int );
void scroll_and_show( NUTRIENT *, WINDOW_CONTROL *, int );
void refresh_screen( NUTRIENT *, WINDOW_CONTROL * );
int  check_date( char * );
void check_card6( NUTRIENT *, WINDOW_CONTROL * );
void check_card13( NUTRIENT *, WINDOW_CONTROL *, int *, char * );
void check_card14_nf( NUTRIENT *, WINDOW_CONTROL * );
void check_card14_ntil( NUTRIENT *, WINDOW_CONTROL * );
void check_card16_mfert( NUTRIENT *, WINDOW_CONTROL * );
void check_card16_mtype( NUTRIENT *, WINDOW_CONTROL * );
int  get_field_value( NUTRIENT *, int );
void set_field_value( NUTRIENT *, char *, int, int );
void get_string_field_value( NUTRIENT *, char *, int );
void insert_card( NUTRIENT *, NUTRIENT * );
void delete_card( NUTRIENT *, NUTRIENT * );
void add_remove_c13( NUTRIENT **, WINDOW_CONTROL *, char *, int * );
void add_remove_diff( NUTRIENT **, int, int );
void view_lft_rgt( NUTRIENT *, WINDOW_CONTROL * );
/*************** functions in n4h.c ******************/
void get_nut_help( NUTRIENT *, WINDOW_CONTROL *, char *, int * );
void fill_card18( NUTRIENT *tmp, WINDOW_CONTROL *wc, HELP_WINDOW hw );
void fill_card19( NUTRIENT *, WINDOW_CONTROL *, HELP_WINDOW );
void show_help_list( HELP_WINDOW *, TABLE_TYPE *, int );
void position_cursor( HELP_WINDOW *, TABLE_TYPE *, int *, int *, int * );
void master_help( HELP_WINDOW *, TABLE_TYPE *, struct screen *, char *,
                  int * );
void save_and_draw( HELP_WINDOW *, struct screen *, SMALL_WINDOW ** );
void show_mozart( void );
/*************** functions in pd.c ******************/
void pd( void );
int  lite_bar_menu( NUTRIENT **, NUTRIENT **, WINDOW_CONTROL *,
                    int *, int *, char * );
int  pull_down( NUTRIENT **, NUTRIENT **, WINDOW_CONTROL *, int,
                int *, int *, char * );
void demo( void );
void draw_lite_bar( int, int );
void get_bar_spacing( int, int *, int * );
void draw_lite_head( int, int [] );
void draw_lite_alt( int, int [] );
void set_colors( int, int, int, int, int );
void change_color_name( struct win_vars * );
void toggle_hilite( struct win_vars );
void update_sample( struct win_vars, struct sample_vars,
                    struct temp_c_scheme );
void make_change_perm( struct temp_c_scheme, int *, int *, int, int, int,
                       int, int );
void init_tmp_color( struct temp_c_scheme * );
void init_win_vars( struct win_vars * );
void init_sample_vars( struct win_vars, struct sample_vars * );
void get_color_name_posn( struct win_vars * );
void setup_set_colors( struct win_vars, struct sample_vars,
                       struct temp_c_scheme );
void decompose_color( int, int *, int *, struct temp_c_scheme );
void compose_color( int, int, int, struct temp_c_scheme * );
void give_current_colors( int, int, struct temp_c_scheme );
int  load_file( NUTRIENT **, NUTRIENT **, WINDOW_CONTROL *, char * );
void add_a_line( NUTRIENT *, char *, struct card_parse * );
int  save_file( NUTRIENT *, char * );
void stop( NUTRIENT **, int * );
void help( void );
void help_card8( void );
int  help_conversion( char * );
/******************************************************/

/*************** functions in getfns.c ******************/
void do_dir( void );
int  path_not_ok( char far *, int, int );
int  get_directory( struct OUTBUF *, struct OUTBUF *, char *, int * );
char last_ch( char * );
int  fatal( char *, int );
int  getdrive( void );
void drvpath( char far * );
int  drive( char );
void list_files( struct OUTBUF *, int, struct dir_struct );
void write_list( struct OUTBUF *, int, int, int, struct dir_struct );
void select_file( struct OUTBUF *, int, struct dir_struct, int * );
void get_boundaries( int, int *, int *, int *, int *, int *, struct dir_struct );
int  fname_compare( struct OUTBUF *, struct OUTBUF * );
/********************************************************************/
