c$DEBUG
       REAL FUNCTION SEDDIA(SPG,VS,KINVIS,AGRAV)
       COMMON /FALL/ RE(9),CDRE2(9),CDDRE(9)
       REAL KINVIS
       save
       RTSID  = 1.3333*AGRAV*(SPG-1.0)*KINVIS/(VS**3)
       IF (RTSID.GT.2.0E+06) GO TO 10
       RTSID  = ALOG(RTSID)
       CALL TABLE(3,9,RE,CDDRE,RTSID,REY)
       REY    = EXP(REY)
       SEDDIA = REY*KINVIS/VS
       RETURN
  10   CONTINUE
       SEDDIA = SQRT(18.0*VS*KINVIS/((SPG-1.0)*AGRAV))
       RETURN
       END
       SUBROUTINE SEGOUT(ELEM,NPART,GTOP,GBOT,X,DX,DLAT,METFLG)
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       REAL NET,GTOP(20),GBOT(20),DLAT(20)
       INTEGER ELEM,SDATE
       save
       CON    = RUNOFF/EXRAIN
       IF (ELEM.EQ.1) THEN
          CON = (43560.0/2000.0)*CON
          IF (METFLG .EQ. 0) THEN
             WRITE (LUN08,4000) X
          ELSE
             DIST=X/3.281
             WRITE (LUN08,5000) DIST
          ENDIF
       ELSE
C         IF (ELEM.GT.1) THEN
          IF (METFLG .EQ. 0) THEN
             WRITE (LUN08,4001) X
          ELSE
             XD=X/3.281
             WRITE (LUN08,5001) XD
          ENDIF
       ENDIF
       STOT   = 0.0
       DTOT   = 0.0
       DO 10 K=1,NPART
           NET    = (GBOT(K)-GTOP(K))*CON/DX
           STOT   = STOT+NET
           DETFLO = (GBOT(K)-GTOP(K))*CON/DX-DLAT(K)*CON
           DTOT   = DTOT+DETFLO
           IF (METFLG .EQ. 0) THEN
              WRITE (LUN08,4002) K,NET,DETFLO
           ELSE
              TEN=NET*2.242
              FLODET=DETFLO*2.242
              WRITE (LUN08,4002) K,TEN,FLODET
           ENDIF
  10   CONTINUE
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4003) STOT,DTOT
       ELSE
          STOTM=STOT*2.242
          DTOTM=DTOT*2.242
          WRITE (LUN08,4003) STOTM,DTOTM
       ENDIF
       RETURN
4000   FORMAT(//,12X,'SOIL LOSS FOR THE SEGMENT ',F6.1,' FT. FROM ',
     1                'THE PROFILE TOP',/,
     1            19X,'PARTICLE     NET SOIL LOSS    RILL SOIL LOSS',/,
     1            19X,'  TYPE            (TONS/ACRE OF SEGMENT)'/,
     1            19X,'  ----          -------           -------')
4001   FORMAT(//,12X,'SOIL LOSS FOR THE SEGMENT ',F6.1,' FT. FROM ',
     1                'THE CHANNEL TOP',/,
     1            19X,'PARTICLE     NET SOIL LOSS    CHAN SOIL LOSS',/,
     1            19X,'  TYPE         (LBS/FT OF CHANNEL SEGMENT)'/,
     1            19X,'  ----          -------           -------')
4002   FORMAT(22X,I2,9X,F9.2,9X,F9.2)
4003   FORMAT(/,21X,'TOTAL',7X,F9.2,9X,F9.2)
5000   FORMAT(//,12X,'SOIL LOSS FOR THE SEGMENT ',F6.1,' M   FROM ',
     1                'THE PROFILE TOP',/,
     1            19X,'PARTICLE     NET SOIL LOSS    RILL SOIL LOSS',/,
     1            19X,'  TYPE          (TONNES/HECTARE OF SEGMENT)'/,
     1            19X,'  ----          -------           -------')
5001   FORMAT(//,12X,'SOIL LOSS FOR THE SEGMENT ',F6.1,' M   FROM ',
     1                'THE CHANNEL TOP',/,
     1            19X,'PARTICLE     NET SOIL LOSS    CHAN SOIL LOSS',/,
     1            19X,'  TYPE          (KG/M OF CHANNEL SEGMENT)'/,
     1            19X,'  ----          -------           -------')
       END
c * * * original segout for glms modified for fred and george t/a
c       SUBROUTINE SEGOUT(ELEM,NPART,GTOP,GBOT,X,DX,DLAT,METFLG)
       REAL FUNCTION SHDIST(X)
       IF (X.LT.0.02) GO TO 10
       SHDIST = EXP(0.12692-0.51634*ALOG(X)-
     1          0.40825*ALOG(X)**2-0.03442*
     1          ALOG(X)**3)
       RETURN
  10   CONTINUE
       SHDIST = 0.13*X/0.02
       RETURN
       END
       REAL FUNCTION SHIELD(REYN)
       REAL Y(8),R(8)
       save
       DATA Y /0.0772,0.0579,0.04,0.035,0.034,0.045,0.055,0.057/
       DATA R /1.0,2.0,4.0,8.0,12.0,100.0,400.0,1000.0/
       IF (REYN.LT.R(1)) GO TO 30
       IF (REYN.GT.R(8)) GO TO 40
       DO 10 I=2,8
           IF (R(I-1).LE.REYN.AND.R(I).GE.REYN) GO TO 20
  10   CONTINUE
  20   CONTINUE
       SLOPE  = (ALOG(Y(I))-ALOG(Y(I-1)))/(ALOG(R(I))-
     1          ALOG(R(I-1)))
       YCR    = ALOG(Y(I-1))+SLOPE*(ALOG(REYN)-ALOG(R(I-1)))
       GO TO 50
  30   CONTINUE
       I      = 2
       SLOPE  = (ALOG(Y(I))-ALOG(Y(I-1)))/(ALOG(R(I))-
     1          ALOG(R(I-1)))
       YCR    = ALOG(Y(1))-SLOPE*(ALOG(R(1))-ALOG(REYN))
       GO TO 50
  40   CONTINUE
       I      = 8
       SLOPE  = (ALOG(Y(I))-ALOG(Y(I-1)))/(ALOG(R(I))-
     1          ALOG(R(I-1)))
       YCR    = Y(8)+SLOPE*(ALOG(REYN)-ALOG(R(8)))
  50   CONTINUE
       SHIELD = EXP(YCR)
       RETURN
       END
       SUBROUTINE SHOVR(Q,SF,NMANOV,EFFSH)
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       REAL NMANOV,NBAROV,MSDH2O,KINVIS,KCH,NBARCH
       save
       R     = (Q*NBAROV/(1.49*SQRT(SF)))**0.6
       EFFSH = WTDH2O*R*SF*((NBAROV/NMANOV)**0.9)
       RETURN
       END
       SUBROUTINE SPREAD(INIT,FLAG,ND,NC,NIN,XIN,YIN,NOUT,XOUT,YOUT)
       REAL XIN(4),YIN(4,40),XOUT(40),YOUT(2,40)
       INTEGER FLAG
       save
       IIN = 1
       Y   = YIN(IIN,ND)
       IF (INIT.EQ.0) Y = ABS(Y)
       DO 20 IOUT=1,NOUT
           IF (IIN.EQ.NIN) GO TO 10
           IF (XOUT(IOUT).LT.XIN(IIN)) GO TO 10
           IF (FLAG.EQ.1.AND.Y.GT.0) YOUT(NC,IOUT) = Y
           IIN = IIN+1
           Y   = YIN(IIN,ND)
           IF (INIT.EQ.0) Y = ABS(Y)
           IF (FLAG.EQ.2.AND.Y.GT.0) YOUT(NC,IOUT) = Y
           GO TO 20
  10       CONTINUE
           IF (Y.GT.0) YOUT(NC,IOUT) = Y
  20   CONTINUE
       RETURN
       END
       SUBROUTINE STROUT(ELEM,EROOUT,NPART,GS,CONC,DAREA,ENRICH,METFLG)
       COMMON /FLOW/ FLAGS,QB,QE,YCR,YNOR,YE,SFE,RUNPND
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       common /bckero/ elmlos(4), elmmon(4), elmann(4), elmenr(4),      be
     &                 enrmon(4), enrann(4)                             be
       REAL GS(NPART),CONC(NPART),MSDH2O,KINVIS,KCH,NBAROV,NBARCH
       INTEGER ELEM,EROOUT,FLAGS
       save
       IF (EROOUT.LT.4) GO TO 10
       IF (ELEM.EQ.1) WRITE (LUN08,4003)
       IF (ELEM.EQ.2) WRITE (LUN08,4004)
       IF (ELEM.EQ.3) WRITE (LUN08,4005)
       IF (ELEM.EQ.4) WRITE (LUN08,4006)
       IF (EROOUT.EQ.4) GO TO 10
       IF (ELEM.EQ.4) THEN
          RUNPND = 12.0*RUNPND
          IF (METFLG .EQ. 0) THEN
             WRITE (LUN08,4007) RUNPND
          ELSE
             QPND=RUNPND*2.54
             WRITE (LUN08,5007) QPND
          ENDIF
       ENDIF
       IF (ELEM.EQ.1.OR.ELEM.EQ.4) GO TO 10
       IF (FLAGS.EQ.1) WRITE (LUN08,4008)
       IF (FLAGS.EQ.2.AND.YE.LE.YNOR) WRITE (LUN08,4009)
       IF (FLAGS.EQ.2.AND.YE.GT.YNOR) WRITE (LUN08,4010)
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4011) QB,QE,YCR,YNOR,YE,SFE
       ELSE
          QBM = QB * 0.02831
          QEM = QE * 0.02831
          YCRM= YCR / 3.281
          YNORM=YNOR / 3.281
          YEM = YE / 3.281
          WRITE (LUN08,5011) QBM,QEM,YCRM,YNORM,YEM,SFE
       ENDIF
  10   CONTINUE
       TGS    = 0.0
       DO 20 K=1,NPART
           TGS = TGS+GS(K)
  20   CONTINUE
       SOLOSS = 43560.0/2000.0*TGS/DAREA                                be
       IF (METFLG .EQ. 0) THEN                                           be
          elmlos(elem) = soloss                                         be
       ELSE                                                             be
          EROSM=SOLOSS*2.242                                            be
          elmlos(elem) = erosm                                          be
       ENDIF                                                            be
       IF (TGS.LE.0.0) GO TO 50
       IF (EROOUT.LT.4) GO TO 60
       IF (EROOUT.EQ.4) GO TO 40
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4000)
       ELSE
          WRITE (LUN08,5000)
       ENDIF
       TCONC  = 0.0
       TCNCPC = 0.0
       TPPM   = 0.0
       DO 30 K=1,NPART
           CONCPC = CONC(K)/WTDH2O
           PPM    = CONCPC*1.0E+06
           FRAC   = GS(K)/TGS
           IF (METFLG .EQ. 0) THEN
              WRITE (LUN08,4001) K,FRAC,GS(K),CONC(K),CONCPC,PPM
           ELSE
              GSM=GS(K)/2.205
              CONCM=CONC(K)*16.01
              WRITE (LUN08,4001) K,FRAC,GSM,CONCM,CONCPC,PPM
           ENDIF
           TCONC  = TCONC+CONC(K)
           TCNCPC = TCNCPC+CONCPC
           TPPM   = TPPM+PPM
  30   CONTINUE
  40   CONTINUE
       IF (EROOUT.EQ.4) GO TO 60
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4002) TGS,TCONC,TCNCPC,TPPM,SOLOSS
       ELSE
          EROSM=SOLOSS*2.242
          TGSM=TGS/2.205
          TCONCM=TCONC*16.01
          WRITE (LUN08,5002) TGSM,TCONCM,TCNCPC,TPPM,EROSM
       ENDIF
       CALL ENRCMP(2,CONC,ENRICH)
       elmenr(elem) = enrich                                            be
       WRITE (LUN08,4013)
       RETURN
  50   CONTINUE
       IF (EROOUT.LT.4) RETURN
       WRITE (LUN08,4014)
       RETURN
  60   CONTINUE
       CALL ENRCMP(1,CONC,ENRICH)
       elmenr(elem) = enrich                                            be
       IF (EROOUT.LT.4) RETURN
       IF (METFLG .EQ. 0) THEN
          WRITE (LUN08,4012) SOLOSS,ENRICH
       ELSE
          EROSM=SOLOSS*2.242
          WRITE (LUN08,5012) EROSM,ENRICH
       ENDIF
       RETURN
4000   FORMAT(/,21X,'THE QUANTITY OF ERODED SEDIMENT IN RUNOFF',//,
     1            6X,'PART.   FRAC. IN   SOIL LOSS  ',
     1               '       CONCENTRATIONS (SOIL/WATER)',/,
     1            6X,'TYPE   SED. LOAD      LBS.    ',
     1               '  LBSF/FT**3    LBSF/LBSF     PPM (WT)',/,
     1            6X,'----     -----      -------   ',
     1               '    ------        -----       --------')
4001   FORMAT(7X,I2,6X,F5.2,4X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0)
4002   FORMAT(/,10X,'TOTAL',9X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0,//,
     1            19X,'AVERAGE SOIL LOSS FOR AREA ',F6.2,
     1                ' TONS/ACRE')
4003   FORMAT(/,28X,'VALUES FROM OVERLAND FLOW',/,
     1          28X,'-------------------------')
4004   FORMAT(/,29X,'VALUES FROM CHANNEL ONE',/,
     1          29X,'-----------------------')
4005   FORMAT(/,29X,'VALUES FROM CHANNEL TWO',/,
     1          29X,'-----------------------')
4006   FORMAT(/,29X,'VALUES FROM IMPOUNDMENT',/,
     1          29X,'-----------------------')
4007   FORMAT(/,24X,'RUNOFF FROM IMPOUNDMENT',F8.2,' IN')
4008   FORMAT(20X,'FRICTION SLOPE FROM ENERGY GRADLINE CURVES',/)
4009   FORMAT(26X,'FRICTION SLOPE = CHANNEL SLOPE',/)
4010   FORMAT(19X,'FRICTION SLOPE = CHANNEL SLOPE EXCEPT AT END',/)
4011   FORMAT(20X,'PEAK DISCHARGE UPPER END',F8.3,' FT**3/SEC',/,
     1        20X,'PEAK DISCHARGE LOWER END',F8.3,' FT**3/SEC',/,
     1        20X,'CRITICAL DEPTH          ',F8.3,' FT',/,
     1        20X,'NORMAL DEPTH            ',F8.3,' FT',/,
     1        20X,'CONTROL DEPTH           ',F8.3,' FT',/,
     1        20X,'FRICTION SLOPE AT END   ',F9.4)
4012   FORMAT(24X,'AVERAGE SOIL LOSS ',F6.2,' TONS/ACRE',/,
     1        24X,'ENRICHMENT RATIO  ',F7.3)
4013   FORMAT(//)
4014   FORMAT(/,31X,'*** NO SOIL LOSS ***')
5000   FORMAT(/,21X,'THE QUANTITY OF ERODED SEDIMENT IN RUNOFF',//,
     1            6X,'PART.   FRAC. IN   SOIL LOSS  ',
     1               '       CONCENTRATIONS (SOIL/WATER)',/,
     1            6X,'TYPE   SED. LOAD       KG     ',
     1               '    KG/M**3       KG/KG       PPM (WT)',/,
     1            6X,'----     -----      -------   ',
     1               '    ------        -----       --------')
5002   FORMAT(/,10X,'TOTAL',9X,F9.0,4X,F9.4,4X,F9.4,4X,F10.0,//,
     1            19X,'AVERAGE SOIL LOSS FOR AREA ',F6.2,
     1                ' TONNES/HECTARE')
5007   FORMAT(/,24X,'RUNOFF FROM IMPOUNDMENT',F8.2,' CM')
5011   FORMAT(20X,'PEAK DISCHARGE UPPER END',F8.3,'  M**3/SEC',/,
     1        20X,'PEAK DISCHARGE LOWER END',F8.3,'  M**3/SEC',/,
     1        20X,'CRITICAL DEPTH          ',F8.3,'  M',/,
     1        20X,'NORMAL DEPTH            ',F8.3,'  M',/,
     1        20X,'CONTROL DEPTH           ',F8.3,'  M',/,
     1        20X,'FRICTION SLOPE AT END   ',F9.4)
5012   FORMAT(24X,'AVERAGE SOIL LOSS ',F6.2,' TONNES/HECTARE',/,
     1        24X,'ENRICHMENT RATIO  ',F7.3)
       END
       SUBROUTINE TABLE(FLAG,LENGTH,COLMN1,COLMN2,GIVEN,FOUND)
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       REAL INTRPL,COLMN1(LENGTH),COLMN2(LENGTH)
       INTEGER FLAG
       save
       IF (FLAG.EQ.2) GO TO 20
       IF (FLAG.EQ.3) GO TO 40
       IF (FLAG.EQ.4) GO TO 60
       DO 10 I=1,LENGTH
           NPOS = I
           IF (COLMN1(I).LT.GIVEN) GO TO 80
           if ((i.eq.length) .and. (colmn1(i) .eq. given)) go to 80
  10   CONTINUE
       GO TO 100
  20   CONTINUE
       DO 30 I=1,LENGTH
           NPOS = I
           IF (COLMN1(I).GT.GIVEN) GO TO 80
           if ((i.eq.length).and.(colmn1(i).eq.given))go to 80
  30   CONTINUE
       GO TO 100
  40   CONTINUE
       DO 50 I=1,LENGTH
           NPOS = I
           IF (COLMN2(I).LT.GIVEN) GO TO 90
           if ((i.eq.length).and.(colmn2(i).eq.given))go to 90
  50   CONTINUE
       GO TO 100
  60   CONTINUE
       DO 70 I=1,LENGTH
           NPOS = I
           IF (COLMN2(I).GT.GIVEN) GO TO 90
           if ((i.eq.length).and.(colmn2(i).eq.given))go to 90
  70   CONTINUE
       GO TO 100
  80   CONTINUE
       IF (NPOS.EQ.1) GO TO 100
       FOUND = INTRPL(COLMN1(NPOS-1),COLMN2(NPOS-1),COLMN1(NPOS),
     1                COLMN2(NPOS),GIVEN)
       RETURN
  90   CONTINUE
       IF (NPOS.EQ.1) GO TO 100
       FOUND = INTRPL(COLMN2(NPOS-1),COLMN1(NPOS-1),COLMN2(NPOS),
     1                COLMN1(NPOS),GIVEN)
       RETURN
 100   CONTINUE
       WRITE (*,4000) FLAG,GIVEN,COLMN1(3),COLMN2(3)
       WRITE (LUN08,4000) FLAG,GIVEN,COLMN1(3),COLMN2(3)
       STOP
4000   FORMAT(/,12X,'GIVEN IS OUTSIDE THE RANGE OF THE TABLE',//,
     1             1X,'USE THIS INFO TO IDENTIFY THE FUNCTION WHERE',
     1                ' THE PROBLEM OCCURED',//,
     1             4X,'FLAG: 1 - GIVEN COLUMN 1 FIND COLUMN 2 ',
     1                '(COLUMN 1 DECREASES)',/,
     1             4X,'      2 - GIVEN COLUMN 1 FIND COLUMN 2 ',
     1                '(COLUMN 1 INCREASES)',//,
     1             4X,'      3 - GIVEN COLUMN 2 FIND COLUMN 1 ',
     1                '(COLUMN 2 DECREASES)',/,
     1             4X,'      4 - GIVEN COLUMN 2 FIND COLUMN 1 ',
     1                '(COLUMN 2 INCREASES)',//,
     1            12X,'THE FLAG                  = ',I2,/,
     1            12X,'GIVEN VALUE               = ',E10.3,/,
     1            12X,'THIRD VALUE FROM COLUMN 1 = ',E10.3,/,
     1            12X,'THIRD VALUE FROM COLUMN 2 = ',E10.3)
       END
       SUBROUTINE TRNCAP(EFFSH,TC,QS)
       COMMON /PASS/ SDATE,RNFALL,RUNOFF,EXRAIN,EI
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /PART/NPART,DIA(10),SPGR(10),FRAC(10),FALL(10),EQSAND(10),
     1               SOLCLY,SOLSLT,SOLSND,SOLORG,SSCLY,SSSLT,SSSND,
     1               SSORG,SSSOIL,FRCLY(10),FRSLT(10),FRSND(10),
     1               FRORG(10),DCL(11),DDCL(10)                         out
       REAL QS(10),NBAROV,WS(10),WSQRAT(10),KINVIS,MSDH2O,TC(10),
     1      COEF(10),YCRIT(10),DELTA(10),SIGMA(10),P(10),DLTRAT(10),
     1      KCH,NBARCH
       INTEGER SNDX,FLAGD1,FLAGD2,FLAGD3,SDATE                          out
       save
       VSTAR       = SQRT(EFFSH/MSDH2O)
       COEF(NPART) = VSTAR*AGRAV*MSDH2O
       fmd         = coef(npart)
       T           = 0.0
       DO 10 K=1,NPART
           fmd     = COEF(NPART)*DIA(K)*SPGR(K)
           COEF(K) = COEF(NPART)*DIA(K)*SPGR(K)
  10   CONTINUE
       DO 40 K=1,NPART
           fmd = qs(k)
           IF (QS(K).EQ.0.0) QS(K) = 1.0E-20
           REYN     = VSTAR*DIA(K)/KINVIS
           YCRIT(K) = SHIELD(REYN)
           DELTA(K) = (VSTAR**2/(SPGR(K)-1.0)/AGRAV/
     1                DIA(K)/YCRIT(K))-1.0
           fmd      = delta(k)
           IF (DELTA(K).GT.0.0) GO TO 20
           DELTA(K) = 0.0
           P(K)     = 0.0
           GO TO 30
  20       CONTINUE
           SIGMA(K) = DELTA(K)*2.45*SPGR(K)**(-0.4)*
     1                SQRT(YCRIT(K))
           P(K)     = YALCON*DELTA(K)*(1.0-1.0/
     1                SIGMA(K)*ALOG(1.0+SIGMA(K)))
  30       CONTINUE
           fmds     = sigma(k)
           fmdp     = p(k)
           T        = T+DELTA(K)
  40   CONTINUE
       IF (T.EQ.0.0) T = 1000.0
       DO 50 K=1,NPART
           DLTRAT(K) = DELTA(K)/T
           WS(K)     = P(K)*DLTRAT(K)*COEF(K)
  50   CONTINUE
  60   CONTINUE
       FLAGD1 = 0
       FLAGD2 = 0
       FLAGD3 = 0
       DO 70 K=1,NPART
           WSQRAT(K) = WS(K)/QS(K)
           IF (WSQRAT(K).GT.1.0) FLAGD3 = FLAGD3+1
           IF (WSQRAT(K).GE.1.0) FLAGD1 = FLAGD1+1
           IF (WSQRAT(K).LE.1.0) FLAGD2 = FLAGD2+1
  70   CONTINUE
       IF (FLAGD2.EQ.NPART) GO TO 80
       IF (FLAGD3.EQ.NPART) GO TO 80
       IF (FLAGD1.EQ.NPART) GO TO 140
       GO TO 100
  80   CONTINUE
       DO 90 K=1,NPART
           TC(K) = WS(K)
  90   CONTINUE
       RETURN
 100   CONTINUE
       SMDRQT = 0.0
       SMDRAT = 0.0
       DO 120 K=1,NPART
           IF (WSQRAT(K).LT.1.0) GO TO 110
           fmdq   = qs(k)
           fmdc   = coef(k)
           fmdp   = p(k)
           SMDRQT = SMDRQT+QS(K)/COEF(K)/P(K)
           WS(K)  = QS(K)
           GO TO 120
 110       CONTINUE
           IF (WSQRAT(K).LT.1.0) SMDRAT = SMDRAT+DLTRAT(K)
 120   CONTINUE
       EXCAP = 1.0-SMDRQT
       DO 130 K=1,NPART
           IF (SMDRAT.EQ.0.0) SMDRAT = 1000000.0
           IF (WSQRAT(K).LT.1.0) WS(K) = DLTRAT(K)/SMDRAT*EXCAP*P(K)*
     1                                  COEF(K)
 130   CONTINUE
       GO TO 60
 140   CONTINUE
       SMDRAT = 0.0
       DO 150 K=1,NPART
           SMDRAT = SMDRAT+QS(K)/(COEF(K)*P(K))
 150   CONTINUE
       A = 1.0/SMDRAT
       DO 160 K=1,NPART
           TC(K) = A*QS(K)
 160   CONTINUE
       RETURN
       END
       SUBROUTINE UNDFLO(COEFF,FACTOR,EXPON)
       save
       DATA POWER /30.0/
       IF (FACTOR.EQ.0.0) RETURN
       EXP10  = EXPON*ALOG10(FACTOR)
       IF (ABS(EXP10).GT.POWER) GO TO 10
       IF (COEFF.EQ.0.0) RETURN
       EXPROD = EXP10+ALOG10(COEFF)
       IF (ABS(EXPROD).GT.POWER) GO TO 10
       RETURN
  10   CONTINUE
       FACTOR = 0.0
       RETURN
       END
       REAL FUNCTION UNIFOR(SLOPE,Z,N,Q)
       REAL N
       C1     = (Z**2.5/(2.0*SQRT(Z**2+1.0)))**(2.0/3.0)
       UNIFOR = (Q*N/(C1*1.49*SQRT(SLOPE)))**0.375
       RETURN
       END
       SUBROUTINE UPDPAR(FLGINI,FLGSEQ,NDATES,CDATE,NYEARS,DNYEAR,
     1                   NPTSO,XPOVR,SPOVR,NPTSC1,XPCHN1,SPCHN1,
     1                   NPTSC2,XPCHN2,SPCHN2,METFLG)
       COMMON /CONS/ AGRAV,MSDH2O,WTDH2O,WTDSOI,KINVIS,KCH,YALCON,BETA,
     1               NBAROV,NBARCH
       COMMON /ROUT/ NXK,XSOIL(4),KSOIL(4),NXF,XFACT(4),CFACT(4,40),
     1               PFACT(4,40),NFACT(4,40),DAOVR,SLNGTH,
     1               NXC1,XCHN1(4),NCHN1(4,40),CCHN1(4,40),SCHN1(4,40),
     1               DCHN1(4,40),WCHN1(4,40),FLAGC1,FLAGS1,CTLO1,
     1               CTLZ1,CTLN1,CTLSL1,RA1,RN1,YBASE1,DACHU1,
     1               DACHL1,Z1,LNGTH1,LEFF1,
     1               NXC2,XCHN2(4),NCHN2(4,40),CCHN2(4,40),SCHN2(4,40),
     1               DCHN2(4,40),WCHN2(4,40),FLAGC2,FLAGS2,CTLO2,
     1               CTLZ2,CTLN2,CTLSL2,RA2,RN2,YBASE2,DACHU2,
     1               DACHL2,Z2,LNGTH2,LEFF2                             out
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       REAL KSOIL,NFACT,NCHN1,NCHN2,XPOVR(40),SPOVR(40),XPCHN1(40),
     1      NBARCH,SPCHN1(40),XPCHN2(40),SPCHN2(40),LNGTH1,LEFF1,LNGTH2,
     1      LEFF2,MSDH2O,KINVIS,KCH,NBAROV
       INTEGER FLGINI,FLGSEQ,CDATE(41),DNYEAR(40),DATBEG,DATEND,        out
     1         FLAGC1,FLAGS1,CTLO1,FLAGC2,FLAGS2,CTLO2
       CHARACTER SPACE*4,STARS*4
       CHARACTER *4 MARKER(20)
       save
       SPACE  = '    '
       STARS  = '****'
       IF (FLGINI.GT.0) WRITE(LUN08,4003)
C
C      READ AND ECHO THE NUMBER OF YEARS IN A CROP ROTATION
C
c       NCARD  = 16
       NCARD  = 14
       READ (LUN03,2000) NYEARS
       IF (NYEARS.LE.0) RETURN
       WRITE (LUN08,4000) NCARD,NYEARS
       NDATES = 0
       DO 20 NYEAR=1,NYEARS
           DNYEAR(NYEAR) = 0
           DATBEG        = NDATES+1
           DATEND        = DATBEG+9
           IF (DATEND.GT.40) DATEND = 40
C
C          READ AND ECHO THE DATES FOR ONE YEAR
C
c           NCARD  = 17
           NCARD  = 15
           READ (LUN03,2000) (CDATE(IDATE),IDATE=DATBEG,DATEND)
           WRITE (LUN08,4000) NCARD,(CDATE(IDATE),IDATE=DATBEG,DATEND)
           DO 10 IDATE=DATBEG,DATEND
               IF (CDATE(IDATE).LE.0) GO TO 20
               CDATE(IDATE)  = CDATE(IDATE)+1000*NYEAR
               NDATES        = NDATES+1
               DNYEAR(NYEAR) = DNYEAR(NYEAR)+1
  10       CONTINUE
  20   CONTINUE
       CDATE(NDATES+1) = 400+1000*NYEARS
       IF (FLGINI.GT.0) GO TO 50
C
C      READ AND ECHO THE DISTANCE VALUES FOR OVERLAND FLOW PARAMETERS
C      THAT WILL CHANGE WITH RESPECT TO TIME
C
c       NCARD  = 18
       NCARD  = 16
       READ (LUN03,2002) NXF,(XFACT(I),I=1,NXF)
       WRITE (LUN08,4002) NCARD,NXF,(XFACT(I),I=1,NXF)
C
C      ADJUST THE DIMENSIONLESS X VALUES WITH THE OVERLAND SLOPE LENGTH,
C      SET UP THE X ARRAY FOR EACH POINT ALONG THE OVERLAND PROFILE AND
C      THEN ADJUST THE SLOPE AT EACH POINT
C
       DO 30 I=1,NXF
           XFACT(I) = SLNGTH*XFACT(I)
  30   CONTINUE
       CALL ADDPTS(NXF,XFACT,NPTSO,XPOVR,SPOVR)
       DO 40 I=1,NPTSO
           SPOVR(I) = SIN(ATAN(SPOVR(I)))
  40   CONTINUE
  50   CONTINUE
C
C      READ AND ECHO THE OVERLAND FLOW PARAMETERS THAT WILL
C      CHANGE WITH RESPECT TO TIME
C
       DATBEG = 1
       DO 70 NYEAR=1,NYEARS
           DATEND = DATBEG+DNYEAR(NYEAR)-1
           DO 60 IXF=1,NXF
c               NCARD  = 19
               NCARD  = 17
               READ (LUN03,2001) (CFACT(IXF,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(CFACT(IXF,IDATE),IDATE=DATBEG,
     1                       DATEND)
               NCARD  = NCARD+1
               READ (LUN03,2001) (PFACT(IXF,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(PFACT(IXF,IDATE),IDATE=DATBEG,
     1                       DATEND)
               NCARD  = NCARD+1
               READ (LUN03,2001) (NFACT(IXF,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(NFACT(IXF,IDATE),IDATE=DATBEG,
     1                       DATEND)
  60       CONTINUE
           DATBEG = DATBEG+DNYEAR(NYEAR)
  70   CONTINUE
       IF (FLGSEQ.LE.2) RETURN
       IF (FLGINI.GT.0) GO TO 100
C
C      READ AND ECHO THE DISTANCE VALUES FOR CHANNEL ONE PARAMETERS
C      THAT WILL CHANGE WITH RESPECT TO TIME
C
c       NCARD  = 22
       NCARD  = 20
       READ (LUN03,2002) NXC1,(XCHN1(I),I=1,NXC1)
       WRITE (LUN08,4002) NCARD,NXC1,(XCHN1(I),I=1,NXC1)
C
C      ADJUST THE DIMENSIONLESS X VALUES WITH THE EFFECTIVE CHANNEL
C      LENGTH, SET UP THE X ARRAY FOR EACH POINT ALONG THE CHANNEL AND
C      THEN ADJUST THE SLOPE AT EACH POINT
C
       DO 80 I=1,NXC1
           XCHN1(I) = LNGTH1*XCHN1(I)+LEFF1-LNGTH1
  80   CONTINUE
       CALL ADDPTS(NXC1,XCHN1,NPTSC1,XPCHN1,SPCHN1)
       DO 90 I=1,NPTSC1
           SPCHN1(I) = SIN(ATAN(SPCHN1(I)))
  90   CONTINUE
 100   CONTINUE
C
C      READ AND ECHO THE CHANNEL ONE PARAMETERS THAT WILL
C      CHANGE WITH RESPECT TO TIME
C
       DATBEG = 1
       NDAY   = 0
       DO 150 NYEAR=1,NYEARS
           DATEND = DATBEG+DNYEAR(NYEAR)-1
           DO 140 IXC1=1,NXC1
c              NCARD  = 23
              NCARD  = 21
              READ (LUN03,2001) (NCHN1(IXC1,IDATE),IDATE=DATBEG,DATEND)
              WRITE (LUN08,4001) NCARD,(NCHN1(IXC1,IDATE),IDATE=DATBEG,
     1                       DATEND)
               IF (FLAGC1.LT.3) GO TO 130
               NBAD = 0
               DO 120 IDATE=DATBEG,DATEND
                   MARK = 2*(IDATE-DATBEG+1)
                   IF (NCHN1(IXC1,IDATE).GE.NBARCH) GO TO 110
                   NBAD = NBAD+1
                   NCHN1(IXC1,IDATE) = NBARCH
                   MARKER(MARK-1)    = STARS
                   MARKER(MARK)      = STARS
                   GO TO 120
 110               CONTINUE
                   MARKER(MARK-1)    = SPACE
                   MARKER(MARK)      = SPACE
 120           CONTINUE
               IF (NBAD.EQ.0) GO TO 130
               WRITE (LUN08,4333) (MARKER(I),I=1,MARK)
               WRITE (LUN08,4334)
 130           CONTINUE
               NCARD  = NCARD+1
              READ (LUN03,2001) (DCHN1(IXC1,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(DCHN1(IXC1,IDATE),IDATE=DATBEG,
     1                       DATEND)
               NCARD  = NCARD+1
              READ (LUN03,2001) (WCHN1(IXC1,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(WCHN1(IXC1,IDATE),IDATE=DATBEG,
     1                       DATEND)
                DO 132 IDATE=DATBEG,DATEND
                   IF (IDATE .EQ. 1) THEN
                      IF (DCHN1(IXC1,1) .LT. 0.) THEN
                         CCHN1(IXC1,1) = 0.20
                         NDAY = 30
                      ELSE
                         CCHN1(IXC1,1) = 0.05
                         NDAY = 0
                      ENDIF
                   ELSE
                      IF (DCHN1(IXC1,IDATE) .GT. 0.0) THEN
                         CCHN1(IXC1,IDATE) = 0.05
                         NDAY = 0
                      ELSE
                         NDAY = NDAY + (CDATE(IDATE) - CDATE(IDATE-1))
                         IF (NDAY .GE. 150) THEN
                            CCHN1(IXC1,IDATE) = 0.60
                         ELSE
                            CCHN1(IXC1,IDATE) = 0.10 + 0.003333*NDAY
                         ENDIF
                      ENDIF
                   ENDIF
 132            CONTINUE
                DO 135 JDATE=DATBEG,DATEND
                       SCHN1(IXC1,JDATE) = DCHN1(IXC1,JDATE)
                       IF (JDATE .EQ. 1) THEN
                          SCHN1(IXC1,JDATE)=ABS(SCHN1(IXC1,JDATE))
                       ELSE
                          NK=JDATE-1
                       ENDIF
        IF (NK .GE. DATBEG) THEN
           IF (SCHN1(IXC1,JDATE) .LT. 0.) THEN
              SCHN1(IXC1,JDATE)=SCHN1(IXC1,NK)
           ENDIF
        ELSE
           IF (SCHN1(IXC1,JDATE) .LT. 0.) THEN
              IF (METFLG .EQ. 1) THEN
              SCHN1(IXC1,JDATE) = SCHN1(IXC1,NK)/3.281
              ELSE
              SCHN1(IXC1,JDATE) = SCHN1(IXC1,NK)
              ENDIF
           ENDIF
        ENDIF
 135            CONTINUE
                IF (METFLG .EQ. 1) THEN
                   DO 138 MDATE=DATBEG,DATEND
                      SCHN1(IXC1,MDATE)=SCHN1(IXC1,MDATE)*3.281
                      DCHN1(IXC1,MDATE)=DCHN1(IXC1,MDATE)*3.281
                      WCHN1(IXC1,MDATE)=WCHN1(IXC1,MDATE)*3.281
 138               CONTINUE
                ENDIF
 140       CONTINUE
           DATBEG = DATBEG+DNYEAR(NYEAR)
 150   CONTINUE
       IF (FLGSEQ.EQ.3.OR.FLGSEQ.EQ.5) RETURN
       IF (FLGINI.GT.0) GO TO 180
C
C      READ AND ECHO THE DISTANCE VALUES FOR CHANNEL TWO PARAMETERS
C      THAT WILL CHANGE WITH RESPECT TO TIME
C
c       NCARD  = 22
       NCARD  = 20
       READ (LUN03,2002) NXC2,(XCHN2(I),I=1,NXC2)
       WRITE(LUN08,4002) NCARD,NXC2,(XCHN2(I),I=1,NXC2)
C
C      ADJUST THE DIMENSIONLESS X VALUES WITH THE EFFECTIVE CHANNEL
C      LENGTH, SET UP THE X ARRAY FOR EACH POINT ALONG THE CHANNEL AND
C      THEN ADJUST THE SLOPE AT EACH POINT
C
       DO 160 I=1,NXC2
           XCHN2(I) = LNGTH2*XCHN2(I)+LEFF2-LNGTH2
 160   CONTINUE
       CALL ADDPTS(NXC2,XCHN2,NPTSC2,XPCHN2,SPCHN2)
       DO 170 I=1,NPTSC2
           SPCHN2(I) = SIN(ATAN(SPCHN2(I)))
 170   CONTINUE
 180   CONTINUE
C
C      READ AND ECHO THE CHANNEL TWO PARAMETERS THAT WILL
C      CHANGE WITH RESPECT TO TIME
C
       DATBEG = 1
       DO 230 NYEAR=1,NYEARS
           DATEND = DATBEG+DNYEAR(NYEAR)-1
           DO 220 IXC2=1,NXC2
c               NCARD  = 23
               NCARD  = 21
              READ (LUN03,2001) (NCHN2(IXC2,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(NCHN2(IXC2,IDATE),IDATE=DATBEG,
     1                       DATEND)
               IF (FLAGC2.LT.3) GO TO 210
               NBAD = 0
               DO 200 IDATE=DATBEG,DATEND
                   MARK = 2*(IDATE-DATBEG+1)
                   IF (NCHN2(IXC2,IDATE).GE.NBARCH) GO TO 190
                   NBAD = NBAD+1
                   NCHN2(IXC2,IDATE) = NBARCH
                   MARKER(MARK-1)    = STARS
                   MARKER(MARK)      = STARS
                   GO TO 200
 190               CONTINUE
                   MARKER(MARK-1)    = SPACE
                   MARKER(MARK)      = SPACE
 200           CONTINUE
               IF (NBAD.EQ.0) GO TO 210
               WRITE (LUN08,4333) (MARKER(I),I=1,MARK)
               WRITE (LUN08,4334)
 210           CONTINUE
               NCARD  = NCARD+1
              READ (LUN03,2001) (DCHN2(IXC2,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(DCHN2(IXC2,IDATE),IDATE=DATBEG,
     1                       DATEND)
               NCARD  = NCARD+1
              READ (LUN03,2001) (WCHN2(IXC2,IDATE),IDATE=DATBEG,DATEND)
               WRITE (LUN08,4001) NCARD,(WCHN2(IXC2,IDATE),IDATE=DATBEG,
     1                       DATEND)
                        DO 215 IDATE=DATBEG,DATEND
                               SCHN2(IXC2,IDATE)=DCHN2(IXC2,IDATE)
                       IF (IDATE .EQ. 1) THEN
                          SCHN2(IXC2,IDATE)=ABS(SCHN2(IXC2,IDATE))
                       ENDIF
                       IF (IDATE .GT. 1) NK=IDATE-1
        IF (SCHN2(IXC2,IDATE) .LT. 0.)SCHN2(IXC2,IDATE)=SCHN2(IXC2,NK)
 215                    CONTINUE
                DO 218 IDATE=DATBEG,DATEND
                   IF (IDATE .EQ. 1) THEN
                      IF (DCHN2(IXC2,1) .LT. 0.) THEN
                         CCHN2(IXC2,1) = 0.20
                         NDAY = 30
                      ELSE
                         CCHN2(IXC2,1) = 0.05
                         NDAY = 0
                      ENDIF
                   ELSE
                      IF (DCHN2(IXC2,IDATE) .GT. 0.0) THEN
                         CCHN2(IXC2,IDATE) = 0.05
                         NDAY = 0
                      ELSE
                         NDAY = NDAY + (CDATE(IDATE) - CDATE(IDATE-1))
                         IF (NDAY .GE. 150) THEN
                            CCHN2(IXC2,IDATE) = 0.60
                         ELSE
                            CCHN2(IXC2,IDATE) = 0.10 + 0.003333*NDAY
                         ENDIF
                      ENDIF
                   ENDIF
 218            CONTINUE
                DO 217 JDATE=DATBEG,DATEND
                       SCHN2(IXC2,JDATE) = DCHN2(IXC2,JDATE)
                       IF (JDATE .EQ. 1) THEN
                          SCHN2(IXC2,JDATE)=ABS(SCHN2(IXC2,JDATE))
                       ELSE
                          NK=JDATE-1
                       ENDIF
        IF (NK .GE. DATBEG) THEN
           IF (SCHN2(IXC2,JDATE) .LT. 0.) THEN
              SCHN2(IXC2,JDATE)=SCHN2(IXC2,NK)
           ENDIF
        ELSE
           IF (SCHN2(IXC2,JDATE) .LT. 0.) THEN
              IF (METFLG .EQ. 1) THEN
              SCHN2(IXC2,JDATE) = SCHN2(IXC2,NK)/3.281
              ELSE
              SCHN2(IXC2,JDATE) = SCHN2(IXC2,NK)
              ENDIF
           ENDIF
        ENDIF
 217            CONTINUE
                IF (METFLG .EQ. 1) THEN
                   DO 219 MDATE=DATBEG,DATEND
                      SCHN2(IXC2,MDATE)=SCHN2(IXC2,MDATE)*3.281
                      DCHN2(IXC2,MDATE)=DCHN2(IXC2,MDATE)*3.281
                      WCHN2(IXC2,MDATE)=WCHN2(IXC2,MDATE)*3.281
 219               CONTINUE
                ENDIF
 220       CONTINUE
           DATBEG = DATBEG+DNYEAR(NYEAR)
 230   CONTINUE
       RETURN
2000   FORMAT(10I8)
2001   FORMAT(10F8.0)
2002   FORMAT(I8,8F8.0)
4000   FORMAT(' CARD',I4,':',10I8,/,10X,10I8)
4001   FORMAT(' CARD',I4,':',10F8.3,/,10X,10F8.3)
4002   FORMAT(' CARD',I4,':',I8,8F8.3)
4003   FORMAT(//)
4333   FORMAT(10X,20A4)
4334   FORMAT(10X,'NATURALLY ERODED CHANNEL - THE MANNINGS N ',
     1              'MUST EQUAL THAT FOR BARE SOIL')
       END
       INTEGER FUNCTION WCHMON(DATE)
       INTEGER CAL(12),DATE,DAY,YEAR
       save
       DATA CAL /31,60,91,121,152,182,213,244,274,305,335,366/
       IF (DATE.LE.0) GO TO 30
       DAY         =MOD(DATE,1000)
       YEAR        =DATE/1000
c       IF (DAY.GT.CAL(1).AND.MOD(YEAR,4).GT.0) DAY=DAY+1               y2k
       IF (DAY.GT.CAL(1).AND. i2kyr(year).eq.365) DAY=DAY+1              y2k
       DO 10 WCHMON=1,12
           IF (DAY.LE.CAL(WCHMON)) GO TO 20
  10   CONTINUE
       WCHMON      =1
  20   CONTINUE
       RETURN
  30   CONTINUE
       WCHMON      =13
       RETURN
       END
