#define VLEFT    0
#define VRIGHT   1


struct hilo {
   double lo;
   double hi;
};


struct limit_type {
   int field_type[10];
   struct hilo range[10];
   int width[10];
   int max_cells;
} limits[16] = {
   { 'W', 'W', 'W', 'W', 'W', 0, 0, 0, 0, 0,             /* card 4 */
     1582.0, 2100.0,  1582.0, 2100.0,  0.0, 3.0,  1.0, 50.0,  0.0, 1.0,
     1.0, 3.0,        0.0, 0.0,        0.0, 0.0,  0.0, 0.0,   0.0, 0.0,
     4, 4, 1, 2, 1, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0, 0,                 /* card 5 */
     0.0, 100000.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  0.0, 0.0,
     0.0, 0.0,       0.0, 0.0,    0.0, 0.0,    0.0, 0.0,    0.0, 0.0,
     8, 5, 5, 5, 0, 0, 0, 0, 0, 0,         3},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 6 tn */
     0.0, 10.0,  0.0, 10.0,  0.0, 10.0,  0.0, 10.0,  0.0, 10.0,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     5, 5, 5, 5, 5, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 7 cnit */
     0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,
     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,
     6, 6, 6, 6, 6, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 8 potmn */
     0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,
     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,
     6, 6, 6, 6, 6, 0, 0, 0, 0, 0,         4},
   { 'R', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 9 orgnw */
     0.0, 10.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     5, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 10 tp */
     0.0, 10.0,  0.0, 10.0,  0.0, 10.0,  0.0, 10.0,  0.0, 10.0,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,   0.0, 0.0,
     6, 6, 6, 6, 6, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 11 clab */
     0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,       
     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,          
     6, 6, 6, 6, 6, 0, 0, 0, 0, 0,         4},                                  
   { 'R', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 12 orgpw */
     0.0, 10.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     5, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'W', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 18 13 */
     0.0, 50366.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,      0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     5, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'W', 'W', 'W', 0, 0, 0, 0, 0, 0, 0,                   /* card 19 14 */
     0.0, 10.0,  0.0, 10.0,  1001.0, 50366.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,   0.0, 0.0,         0.0, 0.0,  0.0, 0.0,
     2, 2, 5, 0, 0, 0, 0, 0, 0, 0,         2},
   { 'W', 'W', 'R', 'N', 'R', 'R', 'R', 'N', 0, 0,        /* card 20 15 */
     1.0, 90.0,   0.0, 1.0,   0.0, 500000.0,  -1.0, 10.0,  0.0, 500.0,
     0.0, 100.0,  0.0, 10.0,  -10.0, 0.0,      0.0, 1.0,   0.0, 0.0,
     2, 1, 8, 4, 4, 4, 4, 5, 0, 0,         7},
   { 'W', 'W', 'W', 'W', 0, 0, 0, 0, 0, 0,                 /* card 21 16 */
     1.0, 50366.0,  0.0, 1.0,  0.0, 4.0,  1.0, 15.0,  0.0, 0.0,
     0.0, 0.0,      0.0, 0.0,  0.0, 0.0,  0.0, 0.0,   0.0, 0.0,
     5, 5, 6, 6, 0, 0, 0, 0, 0, 0,         3},
   { 'R', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 22 17 */
     0.0, 1000.0,  0.0, 1000.0,  0.0, 1000.0,  0.0, 150.0,  0.0, 15.0,
     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,     0.0, 0.0,    0.0, 0.0,
     6, 6, 6, 5, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'W', 0,       /* card 23 18 */
     0.0, 100.0,  0.0, 150.0,  0.0, 100.0,  0.0, 100.0,  0.0, 100.0,
     0.0, 100.0,  0.0, 100.0,  0.0, 100.0,  1.0, 3.0,    0.0, 0.0,
     6, 6, 6, 6, 6, 6, 6, 6, 1, 0,         8},
   { 'W', 'W', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 24  19 */
     1.0, 50366.0,   1.0, 50.0,  0.0, 150.0,  0.0, 1.0,  0.0, 1.0,
     0.0, 0.0,       0.0, 0.0,   0.0, 0.0,    0.0, 0.0,  0.0, 0.0,
     5, 2, 4, 4, 4, 0, 0, 0, 0, 0,         4}
};

struct screen nbyr[] = {
  {20,0,"NBYR    Beginning year of plant nutrient simulation, e.g. 36."},
  {21,8,"Range :  1582 - 2100 "},
  {0,0,NULL}
};

struct screen neyr[] = {
  {20,0,"NEYR    Ending year of plant nutrient simulation, e.g. 85."},
  {21,8,"Range :  1582 - 2100 "},
  {0,0,NULL}
};

struct screen nutout[] = {
  {20,0,"NUTOUT  Code to designate level of printed nutrient output."},
  {21,8,"Range : 0 - 3"},
  {24,0," F1 = Help"}
};

struct screen flgrot[] = {
  {20,0,"FLGROT  Number of years in a rotation cycle.  Use 1 for a continuous"},
  {21,8,"crop (monoculture)."},
  {22,8,"Range : 0 - 50"},
  {0,0,NULL}
};

struct screen flgbal[] = {
  {20,0,"FLGBAL  Code for output of N and P balance at the end of each year."},
  {21,8,"0  No N and P balance output."},
  {22,8,"1  Output N and P at end of each year of simulation."},
  {23,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen resdw[] = {
  {20,0,"RESDW   Crop residue, kg/ha, on the ground surface when simulation"},
  {21,8,"begins, e.g. 550.0."},
  {22,8,"Range : 0 - 100000"},
  {0,0,NULL}
};

struct screen rcn[] = {
  {20,0,"RCN     Nitrogen concentration in rainfall, ppm, e.g. 1.2."},
  {21,8,"Range :  0 - 100"},
  {0,0,NULL}
};

struct screen cni[] = {
  {20,0,"CNI     Concentration of nitrate-nitrogen in irrigation, ppm, e.g. 5.0."},
  {21,8,"Range :  0 - 100"},
  {0,0,NULL}
};

struct screen cpi[] = {
  {20,0,"CPI     Concentration of labile-phosphorus in irrigation, ppm, e.g. 1.2."},
  {21,8,"Range :  0 - 100"},
  {0,0,NULL}
};

struct screen tn[] = {
  {20,0,"TN      Total nitrogen, percent, in soil horizon \"J\", e.g. 1.2."},
  {21,8,"Range : 0 - 10"},
  {24,0," Horizon =    "}
};

struct screen cnit[] = {
  {20,0,"CNIT    Nitrate concentration, g/g (ppm), in soil horizon \"J\", e.g. 200."},
  {21,8,"Nitrate is highly dynamic and will change significantly from day to"},
  {22,8,"day; not very sensitive."},
  {23,8,"Range : 0 - 1000"},
  {24,0," Horizon =    "}
};

struct screen orgnw[] = {
  {20,0,"ORGNW   Organic nitrogen (from animal waste) content, percent,"},
  {21,8,"in soil horizon \"J\", e.g. 0.40"},
  {22,8,"Range : 0 - 10"},
  {24,0," Horizon =    "}
};

struct screen potmn[] = {
  {20,0,"POTMN   Potentially mineralizable nitrogen, kg/ha, in soil horizon \"J\","},
  {21,8,"e.g. 130.0."},
  {22,8,"Range : 0 - 1000"},
  {24,0," Horizon =    "}
};

struct screen tp[] = {
  {20,0,"TP      Total phosphorus, percent, in soil horizon \"J\", e.g. 0.25"},
  {21,8,"Range : 0 - 10"},
  {24,0," Horizon =    "}
};

struct screen clab[] = {
  {20,0,"CLAB    Labile phosphorus concentration, g/g (ppm), in soil horizon \"J\","},
  {21,8,"e.g. 10.0"},
  {22,8,"Range : 0 - 1000"},
  {24,0," Horizon =    "}
};

struct screen orgpw[] = {
  {20,0,"ORGPW   Organic phosphorus content (from animal waste), percent,"},
  {21,8,"in soil horizon \"J\", e.g. 0.10"},
  {22,8,"Range : 0 - 10"},
  {24,0," Horizon =    "}
};

struct screen pdate[] = {
  {20,0,"PDATE   Date that the following parameters are valid, year of the"},
  {21,8,"rotation cycle and Julian day, e.g. 1091."},
  {22,8,"Range : 0 - 0            "},
  {24,0,"            F2 = Add  F3 = Delete "}
};

struct screen nf[] = {
  {20,0,"NF      Number of fertilizer and animal waste application, during the"},
  {21,8,"cropping period, between planting and harvest, e.g. 4."},
  {22,8,"Range : 0 - 10"},
  {0,0,NULL}
};

struct screen ntil[] = {
  {20,0,"NTIL    Number of tillage operations during the cropping period, between"},
  {21,8,"planting and harvest, e.g. 5."},
  {22,8,"Range : 0 - 10"},
  {0,0,NULL}
};

struct screen dhrvst[] = {
  {20,0,"DHRVST  Rotation year and Julian day of crop harvest, e.g. 1274."},
  {21,8,"Range : 1001 - 50366"},
  {0,0,NULL}
};

struct screen icrop[] = {
  {20,0,"ICROP   Identification number of the crop during this cropping period,"},
  {21,8,"e.g. 7."},
  {22,8,"Range : 1 - 90"},
  {24,0," F1 = Help"}
};

struct screen leg[] = {
  {20,0,"LEG     Legume crop code, e.g. 1.  If ICROP < 79, LEG may be left blank"},
  {21,8,"as LEG is specified in the model for those crops listed in the index."},
  {22,8,"If ICROP > 78, LEG must be input here."},
  {23,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen py[] = {
  {20,0,"PY      Potential yield, kg/ha, for the harvestable portion of the crop,"},
  {21,8,"e.g. 45000.  If the default (appendix table) value is accepted, leave"},
  {22,8,"PY blank; otherwise, enter the value."},
  {23,8,"Range : 0 - 500000"},
  {0,0,NULL}
};

struct screen dmy[] = {
  {20,0,"DMY     Dry matter ratio, the ratio of total dry matter production to"},
  {21,8,"harvestable portion of the crop, e.g. 2.5.  If ICROP < 79, DMY may"},
  {22,8,"be left blank."},
  {23,8,"Range : -1 - 10"},
  {0,0,NULL}
};

struct screen cnr[] = {
  {20,0,"CNR     Carbon:nitrogen ratio for the crop, e.g. 80."},
  {21,8,"Range : 0 - 500"},
  {0,0,NULL}
};

struct screen rnp[] = {
  {20,0,"RNP     Nitrogen:phosphorus ratio for the crop, e.g. 7.6."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen c1[] = {
  {20,0,"C1      Coefficient in the exponential relation to estimate nitrogen"},
  {21,8,"content of the crop, e.g. 1.60.  If ICROP < 79, C1 may be left blank."},
  {22,8,"Range : 0 - 10"},
  {0,0,NULL}
};

struct screen c2[] = {
  {20,0,"C2      Exponent in the exponential relation to estimate nitrogen content"},
  {21,8,"of the crop, e.g. -0.247.  If ICROP < 79, C1 may be left blank."},
  {22,8,"Range : 0 - -10"},
  {0,0,NULL}
};

struct screen df[] = {
  {20,0,"DF      Date of fertilizer application, e.g. 1121.  The first digit"},
  {21,8,"indicates the year of the rotation, and 121 is the Julian day of the"},
  {22,8,"year."},
  {23,8,"Range :     1 - 50366"},
  {0,0,NULL}
};

struct screen mfert[] = {
  {20,0,"MFERT   Code for method of fertilization:"},
  {21,8,"0 for inorganic (commercial) fertilizer;"},
  {22,8,"1 for organic (animal waste or sewage sludge)."},
  {23,8,"Range : 0 - 1"},
  {0,0,NULL}
};

struct screen methap[] = {
  {20,0,"METHAP  Code for method of fertilizer application"},
  {21,8,"Range : 0 - 4"},
  {24,0," F1 = Help"}
};

struct screen mtype[] = {
  {20,0,"MTYPE   Code for animal solid/liquid waste type.  Leave blank if"},
  {21,8,"MFERT = 0."},
  {22,8,"Range : 1 - 15"},
  {24,0," F1 = Help"}
};


struct screen frtwat[] = {
  {20,0,"FRTWAT  Depth of water applied for fertigation, cm, e.g. 0.5"},
  {21,8,"Range : 1 - 15"},
  {0,0,NULL}
};

struct screen depin[] = {
  {20,0,"DEPIN   Depth of incorporation, cm, e.g. 10.0."},
  {21,8,"For surface application use 0.0."},
  {22,8,"Range : 0 - 150"},
  {0,0,NULL}
};

struct screen fn[] = {
  {20,0,"FN      Fertilizer nitrate, kg/ha, eg. 115.0."},
  {21,8,"Range : 0 - 1000"},
  {0,0,NULL}
};

struct screen fnh[] = {
  {20,0,"FNH     Fertilizer ammonia, kg/ha, eg. 60.0."},
  {21,8,"Range : 0 - 1000"},
  {0,0,NULL}
};

struct screen fp[] = {
  {20,0,"FP      Fertilizer phosphorus, kg/ha, eg. 45.0."},
  {21,8,"Range : 0 - 1000"},
  {0,0,NULL}
};

struct screen rate[] = {
  {20,0,"RATE    Application rate for animal waste: if liquid is applied, RATE"},
  {21,8,"is equivalent depth, cm, e.g. 0.50; if solid waste is applied, RATE is"},
  {22,8,"tn/ha, e.g. 8.5."},
  {23,8,"Range : 0 - 150"},
  {0,0,NULL}
};

struct screen atn[] = {
  {20,0,"ATN     Total nitrogen content, %, in animal waste, e.g. 1.45."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen aporgn[] = {
  {20,0,"APORGN  Organic nitrogen content, %, in animal waste, e.g. 1.45."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen anh[] = {
  {20,0,"ANH     Ammonia content, %, in animal waste, e.g. 0.75."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen aphos[] = {
  {20,0,"APHOS   Phosphorus content, %, in animal waste, e.g. 0.50."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen aporgp[] = {
  {20,0,"APORGP  Organic phosphorus content, %, in animal waste, e.g. 0.50."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen aom[] = {
  {20,0,"AOM     Organic matter content, %, in animal waste, e.g. 7.0."},
  {21,8,"Range : 0 - 100"},
  {0,0,NULL}
};

struct screen wastyp[] = {
  {20,0,"WASTYP  Waste type:  1 = solid, 2 = slurry, 3 = liquid."},
  {21,8,"Range : 1 - 3"},
  {0,0,NULL}
};

struct screen ntday[] = {
  {20,0,"NTDAY   Date of tillage, year of rotation cycle plus the Julian day,"},
  {21,8,"e.g. 1205."},
  {22,8,"Range :     1 - 50366 "},
  {0,0,NULL}
};

struct screen ltil[] = {
  {20,0,"LTIL    Code to designate the tillage implement."},
  {21,8,"Range : 1 - 50"},
  {24,0," F1 = Help"}
};

struct screen dtil[] = {
  {20,0,"DTIL    Depth of tillage, cm, e.g. 7.5."},
  {21,8,"Range : 0 - 150"},
  {0,0,NULL}
};

struct screen effinc[] = {
  {20,0,"EFFINC  Efficiency of incorporation of surface residue, e.g. 0.85."},
  {21,8,"May be left blank if LTIL < 23."},
  {22,8,"Range : 0 - 1.0"},
  {0,0,NULL}
};

struct screen fmix[] = {
  {20,0,"FMIX    Tillage mixing efficiency, e.g. 0.05."},
  {21,8,"May be left blank if LTIL < 23."},
  {22,8,"Range : 0 - 1.0"},
  {0,0,NULL}
};


struct screen *foot_list[16][10] = {
 {nbyr,   neyr,   nutout, flgrot, flgbal, NULL,  NULL,   NULL, NULL,   NULL},
 {resdw,  rcn,    cni,    cpi,    NULL,   NULL,  NULL,   NULL, NULL,   NULL},
 {tn,     tn,     tn,     tn,     tn,     NULL,  NULL,   NULL, NULL,   NULL},
 {cnit,   cnit,   cnit,   cnit,   cnit,   NULL,  NULL,   NULL, NULL,   NULL},
 {potmn,  potmn,  potmn,  potmn,  potmn,  NULL,  NULL,   NULL, NULL,   NULL},
 {orgnw,  NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL, NULL,   NULL},
 {tp,     tp,     tp,     tp,     tp,     NULL,  NULL,   NULL, NULL,   NULL},
 {clab,   clab,   clab,   clab,   clab,   NULL,  NULL,   NULL, NULL,   NULL},
 {orgpw,  NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL, NULL,   NULL},
 {pdate,  NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL, NULL,   NULL},
 {nf,     ntil,   dhrvst, NULL,   NULL,   NULL,  NULL,   NULL, NULL,   NULL},
 {icrop,  leg,    py,     dmy,    cnr,    rnp,   c1,     c2,   NULL,   NULL},
 {df,     mfert,  methap, mtype,  NULL,   NULL,  NULL,   NULL, NULL,   NULL},
 {fn,     fnh,    fp,     depin,  frtwat, NULL,  NULL,   NULL, NULL,   NULL},
 {rate,   depin,  atn,    aporgn, anh,    aphos, aporgp, aom,  wastyp, NULL},
 {ntday,  ltil,   dtil,   effinc, fmix,   NULL,  NULL,   NULL, NULL,   NULL}
};

/* table of pointers - pointer takes 2 bytes. so 10 * 2 = 20 */
#define FOOT_PTRS 20

