#include <conio.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "n4.h"
#include "nutfunct.h"


extern struct vcfg cfg;
extern struct file_position pos;

/*
 *   master control loop for editing fields in cards 4-24.
 */
void get_card4_24( NUTRIENT **first, NUTRIENT **tmp, WINDOW_CONTROL *wc,
                   int *c, int *stop )
{
int cntinue, ftype, wid, append, row, col, cell_r;
double high, low, x;
char t[82], s[82];
int rc = 0;
int min_fields;
int max_fields;

   change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
   row = wc->v_row + wc->d_row;
   cell_r = (*tmp)->type - 4;
   cntinue = TRUE;
   while (cntinue) {

      /*
       * show the field description at the bottom of the screen.  call
       * change_field_info_structs to may any changes in the description.
       * show changes in horizon, Fkey functions, min and max, etc...
       */
      change_field_info_structs( *tmp, wc );
      change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
      show_footer( foot_list[cell_r][wc->field], *wc );

      /*
       * set up some scratch variables for the field we're working on.
       */
      wid = limits[cell_r].width[wc->field];
      low = limits[cell_r].range[wc->field].lo;
      high = limits[cell_r].range[wc->field].hi;
      ftype = limits[cell_r].field_type[wc->field];
      memset( s, ' ', wid );
      s[wid] = '\0';

      /*
       * calculate the cursor position in the field.
       */
      col = wc->d_col + wc->field * 8 + 8 - wid - 8 * wc->view;
      pos.f_col = wc->field * 8 + 8 - wid + 1;

      /*
       * if the user has already entered a value for this field, we
       * need to copy the original answer to the scratch field so that
       * the user may append more data in the field.
       */
      if (rc != 0) {
         append = TRUE;
         rc = 0;
      } else {
         append = (*tmp)->apd[wc->field];
         if (append) {
            setup_field( *tmp, wc->field, wid, t );
            if ((*tmp)->num[wc->field] > high) {
               limits[cell_r].range[wc->field].hi = (*tmp)->num[wc->field];
               high = (*tmp)->num[wc->field];
            } else if ((*tmp)->num[wc->field] < low) {
               limits[cell_r].range[wc->field].lo = (*tmp)->num[wc->field];
               low = (*tmp)->num[wc->field];
            }
         }
      }

      /*
       * let the field_editor routine handle all the min and max ranges,
       * data type, length, etc...
       */
      field_editor( t, ftype, wid, row, col, append, c, cfg.hi_i, pos );

      /*
       * we got an answer from the user.  it's either: 1) blank  2) wrong
       * or 3) acceptable.  Let the user override the ranges by pressing
       * the Alt+F1 key.
       */
      if (*c == ALTU) {
         rc = lite_bar_menu( first, tmp, wc, stop, c, s );
         if (rc == RTURN) {
            rc = 1;
            *c = 0;
            strcpy( t, s );
         }
      }
      while (*t!='\0' && range_not_ok( t, low, high ) && *c != ALT_F1) {
         field_editor( t, ftype, wid, row, col, FALSE, c, cfg.hi_i, pos );
         if (*c == ALTU) {
            rc = lite_bar_menu( first, tmp, wc, stop, c, s );
            if (rc == RTURN) {
               rc = 1;
               *c = 0;
               strcpy( t, s );
            }
         }
      }

      /*
       * let's see if there are any special cases to take care of.  check
       * for adding or subbing card.  check for the help key.
       */
      if (*c == ALTM)
         show_mozart( );
      else if (*c == F1)
         get_nut_help( *tmp, wc, t, c );
      else if ((*c == F2 || *c == F3) && (*tmp)->type == 13)
         add_remove_c13( tmp, wc, t, c );
      else if (*c == ALT_F1 && *t != '\0') {
         x = atof( t );
         if (x < low)
            limits[cell_r].range[wc->field].lo = x;
         else if (x > high)
            limits[cell_r].range[wc->field].hi = x;
      }

      /*
       * now, after the user 1) entered a valid field or 2) got an
       * answer from the help table or 3) overrode the range checking
       * or 4) entered a blank field,  put a value for the field in
       * the card.
       */
      if (*t != '\0') {
         fast_write( col, row, s, NORMAL );
         fast_write( col+wid-strlen( t ), row, t, NORMAL );
         set_field_value( *tmp, t, wc->field, TRUE );
      } else
         set_field_value( *tmp, " ", wc->field, FALSE );

      /********************************************************/
      /*                 IMPORTANT                            */
      /* on card 14 - let field 4 and 5 contain old nf, ntil  */
      /* on card 16 - let field 4 contain old mfert           */
      /*                                                      */
      /********************************************************/

      /*
       * on some cards we have to check if values in one field affect
       * other values on the same or other cards.
       */
      if ((*tmp)->type == 13)
         check_card13( *tmp, wc, c, t );
      else if ((*tmp)->type == 14 && wc->field == 0)
         check_card14_nf( *tmp, wc );
      else if ((*tmp)->type == 14 && wc->field == 1)
         check_card14_ntil( *tmp, wc );
      else if ((*tmp)->type == 16 && wc->field == 1)
         check_card16_mfert( *tmp, wc );
      else if ((*tmp)->type == 16 && wc->field == 3)
         check_card16_mtype( *tmp, wc );

      /*
       * implement a little editor routine.
       */
      switch (*c) {

         case ALTF  :
/*         case ALTU  :  */
         case ALTC  :
         case ALTO  :
         case ALTH  :
            rc = lite_bar_menu( first, tmp, wc, stop, c, t );
            if (rc == RTURN) {
               rc = 1;
               *c = 0;
            } else
               rc = 0;
/*            if (*stop == TRUE) */
               cntinue = FALSE;
            break;

         case UP    :
         case DOWN  :
         case PGDN  :
         case PGUP  :
         case ALTS  :
         case ALTX  :
            cntinue = FALSE;
            break;
         case CNTL_LEFT :
         case SHIFT_TAB :
            if (wc->view == VLEFT) {
               if (wc->field == min_fields)
                  wc->field = max_fields;
               else
                  --wc->field;
            } else if (wc->view == VRIGHT) {
               if (wc->field == min_fields) {
                  wc->view = VLEFT;
      /*          change_min_max_limits( *tmp, wc, &min_fields, &max_fields); */
                  wc->field = min_fields;
                  view_lft_rgt( *tmp, wc );
               } else
                  --wc->field;
            }
            break;
         case CNTL_RGHT :
         case RTURN     :
         case TAB       :
         case ALT_F1    :
            if (wc->view == VLEFT) {
               if (wc->field == max_fields) {
                  if (max_fields >= 8) {
                     wc->view = VRIGHT;
                     change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
                     if (max_fields > 8) {
                        wc->field = max_fields;
                        view_lft_rgt( *tmp, wc );
                     } else {
                        if (*c == RTURN)
                           cntinue = FALSE;
                        wc->view = VLEFT;
                        change_min_max_limits( *tmp, wc, &min_fields, &max_fields);
                        wc->field = min_fields;
                     }
                  } else {
                     wc->field = min_fields;
                     if (*c == RTURN)
                        cntinue = FALSE;
                  }
               } else
                  ++wc->field;
            } else if (wc->view == VRIGHT) {
               if (wc->field == max_fields) {
                  if (*c == RTURN)
                     cntinue = FALSE;
                  wc->view = VLEFT;
                  change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
                  view_lft_rgt( *tmp, wc );
                  wc->field = min_fields;
               } else
                  ++wc->field;
            }
            break;
      }
   }
}


/*
 *   copy contents of field into a scratch array for editing
 */
void setup_field( NUTRIENT *tmp, int field, int wid, char *t )
{
int i, j, k;

   for (i=0,j=field*8+8-wid, k=0; i<wid; i++)
      if (tmp->line[j+i] != ' ') {
         t[k]=tmp->line[j+i];
         k++;
      }
   t[k] = '\0';
}


/*
 *   set maximum fields cursor can access on a card.
 */
void change_min_max_limits( NUTRIENT *tmp, WINDOW_CONTROL *wc,
                            int *min_fields, int *max_fields )
{
int cell_r;

   cell_r = tmp->type - 4;
   *max_fields = limits[cell_r].max_cells;
   *min_fields = wc->view;
   if (wc->view == VLEFT && *max_fields > 8)
      *max_fields = 8;
   if (wc->field > *max_fields)
      wc->field = *max_fields;
   else if (wc->field < *min_fields)
      wc->field = *min_fields;
}


/*
 *   change information that is displayed at bottom of screen as needed
 *   for each field.
 */
void change_field_info_structs( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
int i, cell_r, foot_row, foot_col, wid;
float begin, end;
char s[82], t[82];
NUTRIENT *a;

   cell_r = tmp->type - 4;
   setup_field( tmp, wc->field, 8, t );
   wid = limits[cell_r].width[wc->field];
   i = strlen( t );
   if (i > wid)
      limits[cell_r].width[wc->field] = i;

   /*
    * change the horizon on the soil characteristic cards.  the horizon
    * is wc->field + 1.
    */
   switch (tmp->type) {
      case 6  :
      case 7  :
      case 8  :
      case 9  :
      case 10 :
      case 11 :
      case 12 :
         switch (tmp->type) {
            case 8  :
            case 9  :
            case 11 :
            case 12 :
               foot_row = 3;
               break;
            case 6  :
            case 10  :
               foot_row = 2;
               break;
            case 7  :
               foot_row = 4;
               break;
         }
         foot_col = 11;
         change_footer( " ", cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa( wc->field+1, t, 10 ), cell_r, wc->field,
                                                     foot_row, foot_col );
         break;
      case 13 :
         if (tmp->n == NULL)
            strcpy( s, "F2 = Add             " );
         else
            strcpy( s, "F2 = Add  F3 = Delete" );
         foot_row = 3;
         foot_col = 12;
         change_footer( s, cell_r, wc->field, foot_row, foot_col );
         foot_row = 2;
         foot_col = 8;
         memset( t, ' ', 13 );
         t[13] = '\0';
         change_footer( t, cell_r, wc->field, foot_row, foot_col );
         if (tmp->n == NULL) {
            begin = 0.0;
            end   = 0.0;
            strcpy( s, "0 - 0" );
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
         } else {
            begin = 1001.0;
            end   = 50365.0;
            for (i=TRUE, a=tmp->p; a->type > 12 && i == TRUE; a=a->p) {
               if (a->type == 13 && a->apd[0] == TRUE) {
                  begin = a->num[0];
                  i = FALSE;
               }
            }
            ltoa( begin, s, 10 );
            wid = strlen( s );
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
            change_footer( "-", cell_r, wc->field, foot_row, foot_col+wid+1 );
            for (i=TRUE, a=tmp->n; a->n!=NULL && i==TRUE; a=a->n) {
               if (a->type == 13 && a->apd[0] == TRUE) {
                  end = a->num[i];
                  i = FALSE;
               }
            }
            ltoa( end, s, 10 );
            change_footer( s, cell_r, wc->field, foot_row, foot_col+wid+3 );
         }
         limits[cell_r].range[wc->field].hi = end;
         limits[cell_r].range[wc->field].lo = begin;
         break;
      case 18 :
         a = tmp->p;
         if (a->apd[3] == TRUE) {
            if (a->num[3] < 15)
               limits[cell_r].max_cells = 1;
            else
               limits[cell_r].max_cells = 8;
         }
         break;
   }
   memset( s, ' ', 80 );
   s[80] = '\0';
   fast_write( 0, 24, s, cfg.f_bar );
}


/*
 *   put the string "t" into the "footer" given the card type, field,
 *   row, and column.
 */
void change_footer( char *t, int type, int field, int foot_row, int foot_col )
{
int i, j;

   j = strlen( t );
   for (i=0; i < j; i++)
      foot_list[type][field][foot_row].text[foot_col+i] = t[i];
}


/*
 *   scroll the list of cards down 1 line.
 */
void scroll_and_show( NUTRIENT *b, WINDOW_CONTROL *wc, int row )
{
int i, j;
char t[82], s[10];

   scroll_window( 0, row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (j=row; b != NULL  && j < wc->max_rows + wc->d_row; b=b->n,j++) {

      /*
       * if this is card 1-3, just show the whole line.
       */
      if (b->type >= 1 && b->type <=3)
         fast_write( 0, j, b->line, NORMAL );

      /*
       * if this is a card greater than 3 then we may not be able to see
       * field 1 or field 10 becasue we can only display 9 fields on
       * a line at a time.
       */
      else {
         i = 0 + 8 * wc->view;
         strncpy( t, b->line+i, 72 );
         t[72] = '\0';
         fast_write( wc->d_col, j, t, NORMAL );
         strcpy( s, itoa( b->type, s, 10 ) );
         if (strlen( s ) == 1)
            fast_write( wc->d_col-2, j, s, NORMAL );
         else
            fast_write( wc->d_col-3, j, s, NORMAL );
      }
   }
}


/*
 *   redraw the card window - useful when big changes occur in card sequence.
 */
void refresh_screen( NUTRIENT *a, WINDOW_CONTROL *wc )
{
int i, row;

   for (i=wc->v_row; a->p!=NULL && i>0; a=a->p)
      i--;
   row = wc->d_row;
   scroll_and_show( a, wc, row );
}


/*
 *   given a julian date - check range of days in year.
 */
int  check_date( char *t )
{
int rc, y, d, i, j, leap;
char yr[8], day[8];

   for (i=0; i<8; i++) {
      yr[i] = '\0';
      day[i] = '\0';
   }

   /*
    * get the 3 days from a julian date.
    */
   for (i=strlen( t )-1, j=0; i>=0 && j<3; i--,j++)
      insert( day, 0, t[i] );

   /*
    * put what's left in the year.
    */
   for (; i>=0; i--)
      insert( yr, 0, t[i] );

   /*
    * convert to integers and check for leap years and days out of range.
    */
   d = atoi( day );
   y = atoi( yr );
   /* leap = y % 4 == 0; */
   leap = (y % 4 == 0) && ((y % 100 != 0) || (y % 400 == 0));
   if (leap) {
      if (d < 0 || d > 366)
         rc = FALSE;
      else
         rc = TRUE;
   } else {
      if (d < 0 || d > 365)
         rc = FALSE;
      else
         rc = TRUE;
   }
   return( rc );
}

/*
 *   on card 13, the last pdate MUST be 0.  pdates must be ascending order.
 */
void check_card13( NUTRIENT *tmp, WINDOW_CONTROL *wc, int *c, char *t )
{
NUTRIENT *a;
long num, prev_pdate, next_pdate;


   /*
    * if this is last card 13 - we MUST have 0 in pdate
    */
   if (tmp->n == NULL) {
      if (wc->field == 0) {
         if (strcmp( t, "0" )) {
            strcpy( t, "0" );
            set_field_value( tmp, t, wc->field, TRUE );
            *c = 0;
         }
      }

   /*
    * else just make sure card 13's are in ascending order
    */
   } else {

      /*
       * let's only worry about pdate or wc->field == 0
       */
      if (wc->field == 0) {

         if (*t != '\0') {

            /*
             * if there is a pdate, make sure it is ok.  if it's not
             * ok, then there is no use checking - set it to blank and
             * make the user enter a valid pdate.
             */
            if (check_date( t ) == FALSE) {
               *t = '\0';
               *c = 0;
               set_field_value( tmp, " ", wc->field, FALSE );

            /*
             * now make sure current pdate is greater than the previous
             * pdate and less than the next pdate.
             */
            } else {
               a = tmp;
               num = atol( t );

               /*
                * make sure pdate is not less than previous pdates
                */
               while (a->p->type >= 13) {

                  /*
                   * find prev pdate if it exists and make sure current
                   * pdate is greater than previous.
                   */
                  for (a=a->p; a->type != 13; a=a->p);
                  if (a->apd[0] == TRUE) {
                     prev_pdate = a->num[0];
                     if (num <= prev_pdate) {
                        *t = '\0';
                        *c = 0;
                        set_field_value( tmp, " ", wc->field, FALSE );
                     }
                  }
               }

               /*
                * make sure pdate is not greater than next pdate
                */
               a = tmp;

               /*
                * find next pdate if it exists.
                */
               for (a=a->n; a->type != 13; a=a->n);

               /*
                * if this is the last card 13, then don't check.
                * the last pdate on card 13 MUST be 0.
                */
               while (a != NULL) {
                  if (a->apd[0] == TRUE && a->num[0] != 0) {
                     next_pdate = a->num[0];
                     if (num > next_pdate) {
                        *t = '\0';
                        *c = 0;
                        set_field_value( a, " ", wc->field, FALSE );
                     }
                  }

                  /*
                   * let's look at all the pdates because there may be
                   * some blank pdates between the current pdate and the
                   * end of the data set.
                   */
                  for (a=a->n; a != NULL  &&  a->type != 13; a=a->n);
               }
            }
         }
      }
   }
}


/*
 * if the user enters or changes the number of fertilizations, make sure
 * the fertilization cards are correct.
 *
 * the old fertilization number for this crop is kept in field 4.
 */
void check_card14_nf( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
int diff, i;
NUTRIENT *a;

   diff = tmp->num[0] - tmp->num[4];
   if (diff != 0) {

      /*
       * if diff is zero then we need to delete some ferts.
       */
      if (diff < 0) {

         /*
          * go to the end of the fertilizations and remove move the
          * last ones first.
          */
         for (a=tmp; a->type != 16; a=a->n);
         for (i=tmp->num[0]; i<0; i--)
            a=a->n->n;

         /*
          * since there are two fert cards for each application, multiply
          * the number of app's by two to get the number of cards to
          * delete.
          */
         i = abs( diff ) * 2;
         diff = -1;
         for (; i > 0; i--)
            add_remove_diff( &a, diff, 16 );
      } else {

         /*
          * we need to add some ferts.  put in a card 16 and assume a
          * fertilizer app. (card 17).  the user can always chage to
          * an animal waste later on.
          */
         for (a=tmp; a->type != 15; a=a->n);
         for (i=tmp->num[4]; i>0; i--)
            a=a->n->n;
         for (i=diff; i > 0; i--) {
            add_remove_diff( &a, 1, 17 );
            add_remove_diff( &a, 1, 16 );
            set_field_value( a->n, "0", 1, TRUE );
         }
      }
      scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
      tmp->num[4] = tmp->num[0];
   }
}


/*
 * if the user enters or changes the number of tillages, make sure
 * the tillage cards are correct.
 *
 * the old tillage number for this crop is kept in field 5.
 */
void check_card14_ntil( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
int diff, i;
NUTRIENT *a;

   /*
    * if old number of tills minus new number of tills are not zero then
    * we need to add or subtract tillage cards.
    */
   diff = tmp->num[1] - tmp->num[5];
   if (diff != 0) {

      /*
       * go to the ICROP card
       */
      for (a=tmp; a->type != 15; a=a->n);

      /*
       * go to the end of the ferts.
       */
      for (i=tmp->num[0]; i>0; i--)
         a=a->n->n;

      /*
       * if diff is negative, we need to delete some tills.
       */
      if (diff < 0) {
         /*
          * now go to the last valid till
          */
         for (i=tmp->num[1], a=a->n; i>0; i--)
            a=a->n;

         /*
          * delete the tills
          */
         for (i=diff; i<0; i++)
            add_remove_diff( &a, -1, 19 );
      } else {

         /*
          * go to last valid till
          */
         for (i=tmp->num[5]; i>0; i--)
            a=a->n;

         /*
          * add the tills
          */
         for (i=diff; i > 0; i--)
            add_remove_diff( &a, 1, 19 );
      }
      scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
      tmp->num[5] = tmp->num[1];
   }
}


void check_card16_mfert( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
int diff, card_no;
NUTRIENT *a;

   diff = tmp->num[1] - tmp->num[4];
   if (diff != 0 && tmp->apd[1] == TRUE) {
      a = tmp->n;
      add_remove_diff( &a, -1, 17 );
      if (tmp->num[1] == 0)
         card_no = 17;
      else
         card_no = 18;
      a = tmp;
      add_remove_diff( &a, 1, card_no );
      scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
      tmp->num[4] = tmp->num[1];
   }
}


/*
 *  user has selected a manure from built in data base.  fill in
 *  card 18 with manure info.
 */
void check_card16_mtype( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
HELP_WINDOW hw;

   if (tmp->n->type == 18) {
      if (tmp->apd[3] == TRUE) {
         if (tmp->num[1] > 0  && tmp->num[3] <= 14) {
            hw.select = tmp->num[3] - 1;
            fill_card18( tmp, wc, hw );
         }
      }
   }
}


/*
 *   given a card and a field return the integer value of the field.
 *   if the field is 0 then return 1.
 */
int  get_field_value( NUTRIENT *a, int field )
{
int rc;

   if (a->num[field] != 0.0)
      rc = a->num[field];
   else
      rc = 1;
   return( rc );
}


/*
 *   put the scratch array in the display line. convert the scratch array to
 *   numeric and store it in the num field.
 */
void set_field_value( NUTRIENT *a, char *t, int field, int t_or_f )
{
   a->apd[field] = t_or_f;
   format_output( t, a->line, field, 8 );
   a->num[field] = atof( t );
}


/*
 *   build the scratch array from the display line.
 */
void get_string_field_value( NUTRIENT *tmp, char *t, int field )
{
int i;

   for (i=0; i < 8 && (t[i] = tmp->line[field*8 + i]); i++);
   t[i] = '\0';
   while (t[0] && (t[0] == ' '))
      delete( t, 0 );
}


   /*  next two functions assume
    *  a->card
    *       
    *  b->card
    */

void insert_card( NUTRIENT *a, NUTRIENT *b )    /* insert b after a */
{
   a->n->p = b;
   b->n = a->n;
   b->p = a;
   a->n = b;
}


void delete_card( NUTRIENT *a, NUTRIENT *b )    /* delete b */
{
   a->n = b->n;
   if (b->n != NULL)
      b->n->p = a;
   free( b );
}


/*
 *   if user pressed F2 or F3 then add or delete card 13 as needed.
 */
void add_remove_c13( NUTRIENT **tmp, WINDOW_CONTROL *wc, char *t, int *c )
{
int diff, card_no;
NUTRIENT *b;

   card_no = 13;
   if (*c == F3 && (*tmp)->n == NULL)
      diff = 0;
   else {
      if (*c == F2 && (*tmp)->n == NULL) {
                 /* EXCEPTION -- add before the 0 card  */
         diff = 1;
         b = (*tmp)->p;        /* add x between *tmp and (*tmp)->p */
         add_remove_diff( &b, diff, 15 );
         add_remove_diff( &b, diff, 14 );
         add_remove_diff( &b, diff, 13 );
         *tmp = b->n;
      } else {
         if (*c == F2) {
            diff = 1;
            for (b=(*tmp)->n; b->type != 13; b=b->n);
            b=b->p;
            add_remove_diff( &b, diff, 15 );
            add_remove_diff( &b, diff, 14 );
            add_remove_diff( &b, diff, 13 );
         } else if (*c == F3) {
            diff = -1;
            add_remove_diff( tmp, diff, card_no );
            while ((*tmp)->type != 13 && (*tmp)->n != NULL)
               add_remove_diff( tmp, diff, card_no );
         }
      }
      scroll_and_show( *tmp, wc,  wc->v_row + wc->d_row );
      get_string_field_value( *tmp, t, wc->field );
   }
}


/*
 *   add or delete linked nodes
 */
void add_remove_diff( NUTRIENT **a, int diff, int card_no )
{
NUTRIENT *b, *c;
int j;

   if (diff < 0) {
      b = (*a)->p;     /* back pointer b one card and remove b->n */
      for (j=diff; j<0; j++) {
         delete_card( b, *a );      /* remove card *a */
         *a=b->n;
      }
   } else if (diff > 0) {
             /* add diff cards to list */
      for (b=*a, j=diff; j>0; j--) {
         c = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
         blank_line( c );
         c->type = card_no;
         insert_card( b, c );       /* insert card c after card b  */
      }
   }
}


/*
 *   view fields 1-8 or 2-9 as needed.
 */
void view_lft_rgt( NUTRIENT *tmp, WINDOW_CONTROL *wc )
{
NUTRIENT *a;
int row, i;
char t[82];

   for (a=tmp, row=wc->v_row; a->p->type > 3 && row>0; a=a->p, row--);
   row += wc->d_row;
   scroll_window( 0, row, wc->d_col, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (; a!=NULL && row<wc->d_row+wc->max_rows; a=a->n,row++) {
      i = 0 + 8 * wc->view;
      strncpy( t, a->line+i, 72 );
      t[72] = '\0';
      fast_write( wc->d_col, row, t, NORMAL );
   }
}
