#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#undef toupper

#include "screen.h"
#include "extkeys.h"
#include "hydfunc.h"
#include "hyd1.h"


static HYDROLOGY *h_list;


struct screen *(*foot_list)[32][10];        /* point to array of pointers */
extern struct screen *english_list[32][10];

struct limit_type (*limits)[32];
extern struct limit_type english_limits[32];


struct vcfg cfg;
int units=ENGLISH;
static SMALL_WINDOW *w_ptr;
struct file_position pos;
char fname[40];

char *greatest_composer_ever = "W. A. Mozart, 1756-1791";

main( int argc, char *argv[] )
{
int c, stop;
HYDROLOGY *first, *last, *tmp;
WINDOW_CONTROL wc;
char *tname = "Temporary";

   stop = FALSE;
   w_ptr = NULL;
/*
   *foot_list = english_list;
   *limits = english_limits;
*/
   foot_list = &english_list;
   limits = &english_limits;
   wc.beg_vrow = 0;
   wc.max_rows = 16;
   wc.d_col    = 5;
   wc.d_row    = 3;
   wc.offset   = 0;
   wc.field    = 0;
   wc.v_row = wc.r_row = 0;
   wc.view     = VLEFT;
   get_vcfg( );
   if (argc > 1) {
      c = init_from_file( &h_list, argv[1] );
      strcpy( fname, argv[1] );
      if (c == FALSE) {
         init_all_cards( &h_list );
         strcpy( fname, tname );
      }
   } else {
      init_all_cards( &h_list );
      strcpy( fname, tname );
   }
   first = h_list;
   for (tmp=h_list; tmp != NULL; tmp=tmp->n)
      last = tmp;
   tmp = first;
   intro( );
   pd( );
   pos.display = TRUE;
   pos.d_row = 24;
   pos.d_col = 72;
   pos.color = cfg.f_bar;
   pos.f_row = wc.r_row + 1;
   pos.f_col = 0;
   work_screen( tmp, wc );
   show_footer( tit_foot, wc );
   write_filename( fname );
   c = 0;
   while (stop != TRUE) {
      switch (tmp->type) {
         case 1 :
         case 2 :
         case 3 :
            wc.field = 0;
            get_title( tmp, wc, &c );
            break;
         case 4 :
         case 5 :
         case 6 :
         case 7 :
         case 8 :
         case 9 :
         case 10 :
         case 11 :
         case 12 :
         case 13 :
         case 14 :
         case 15 :
         case 16 :
         case 17 :
         case 18 :
         case 19 :
         case 20 :
         case 21 :
         case 22 :
         case 23 :
         case 24 :
         case 25 :
         case 26 :
         case 27 :
         case 28 :
         case 29 :
         case 30 :
         case 31 :
         case 32 :
         case 33 :
         case 34 :
         case 35 :
            get_card4_33( &tmp, &wc, &c );
            break;
         default :
            c = UP;
            break;
      }
      link_list_editor( &tmp, &wc, c );
      pos.f_row = wc.r_row + 1;
      if (c == ALTF || c == ALTC || c == ALTS || c == ALTU || c == ALTH)
         lite_bar_menu( &first, &tmp, &wc, &stop, &c );
      if (c == ALTX)
         quit( first, &stop );
   }
   cls( );
   set_cur( 1, 1 );
   return( 0 );
}


int  init_from_file( HYDROLOGY **list, char *path )
{
HYDROLOGY *a, *b;
int i, rc;
FILE *infile;
char line[100];
struct card_parse crd;

   rc = FALSE;
   if ((infile = fopen( path, "r" )) != NULL) {
      crd.seen5  = FALSE;
      crd.num_31 = 0;
      crd.num_32 = 0;
      for (i=0; i<12; i++)
         crd.user_lai[i] = FALSE;
      crd.seen33 = FALSE;
      crd.newt   = FALSE;
      crd.newr   = FALSE;
      crd.newl   = FALSE;
      crd.neww   = FALSE;
      crd.newd   = FALSE;
      crd.eof    = FALSE;

      fseek( infile, 0L, SEEK_SET );
      for (crd.c_no=0; fgets( line, 90, infile ) != NULL && crd.eof != TRUE;) {
         if (crd.c_no == 0) {
            crd.c_no = 1;
            *list = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
            (*list)->n = (*list)->p = NULL;
            a = *list;
         } else {
            b = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
            a->n = b;
            b->p = a;
            b->n = NULL;
            a = b;
         }
         add_a_line( a, line, &crd );
         if (a->type == 4)
            check_card4_units( a );
      }
      fclose( infile );
      rc = TRUE;
   } else
      rc = FALSE;
   return( rc );
}


void init_all_cards( HYDROLOGY **list )
{
int i;
HYDROLOGY *a, *b;

   for (i=0; i<33; i++) {
      if (i==4 || i==14 || i==15 || i==16 || i==29 || i==30 || i==31)
         continue;
      if (i == 0) {
         *list = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
         (*list)->n = (*list)->p = NULL;
         (*list)->type = i+1;
         a = *list;
      } else {
         b = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
         a->n = b;
         b->p = a;
         b->n = NULL;
         b->type = i+1;
         a = b;
      }
      blank_line( a );
      if (i == 3) {
         a->apd[5] = TRUE;
         format_output( "0", a->line, 5 );
         a->num[5] = (float)0.0;
      }
      if (i == 28) {
         a->apd[0] = TRUE;
         format_output( "0", a->line, 0 );
         a->num[0] = (float)0.0;
      }
      if (i == 32) {
         a->apd[0] = TRUE;
         format_output( "-1", a->line, 0 );
         a->num[0] = (float)-1.0;
         a->num[4] = (float)-1.0;
         a->apd[1] = TRUE;
         format_output( "0", a->line, 1 );
         a->num[1] = (float)0.0;
         a->apd[2] = TRUE;
         format_output( "0", a->line, 2 );
         a->num[2] = (float)0.0;
         a->apd[3] = TRUE;
         format_output( "0", a->line, 3 );
         a->num[3] = (float)0.0;
      }
   }
}


/*
 *   free the linked list and get out with asking if OK.
 */
void quit( HYDROLOGY *first, int *stop )
{
HYDROLOGY *tmp;

   while (first != NULL) {
      tmp = first;
      first = first->n;
      free( tmp );
   }
   *stop = TRUE;
}


void blank_line( HYDROLOGY *a )
{
int i;

   memset( a->line, ' ', 80 );
   a->line[80] = '\0';
   for (i=0; i<10; i++) {
      a->num[i] = (float)0.0;
      a->apd[i] = FALSE;
   }
}


void intro( void )
{
int c;

   c_off( );
   cls( );
   write_to_window( hyd_intro, 0, 0, NORMAL );
   c = getkey( );
   c_on( );
   cls( );
}


void work_screen( HYDROLOGY *tmp, WINDOW_CONTROL wc )
{
   write_to_window( hyd_work, 0, 0, NORMAL );
   show_list( tmp, &wc );
   if (units == ENGLISH)
      fast_write( 63, 1, "English units", NORMAL );
   else
      fast_write( 63, 1, "Metric units ", NORMAL );
}


void show_list( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
int r;
char t[82], s[10];

   scroll_window( 0, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (r=wc->d_row; tmp!=NULL && r<wc->max_rows+wc->d_row; tmp=tmp->n,r++) {
      if (tmp->type >= 1 && tmp->type <=3)
         fast_write( 0, r, tmp->line, NORMAL );
      else {
         if (wc->view == VLEFT)
            strncpy( t, tmp->line, 72 );
         else if (wc->view == VRIGHT)
            strncpy( t, tmp->line+8, 72 );
         t[72] = '\0';
         strcpy( s, itoa( tmp->type, s, 10 ) );
         fast_write( wc->d_col, r, t, NORMAL );
         if (strlen( s ) == 1)
            fast_write( wc->d_col-2, r, s, NORMAL );
         else
            fast_write( wc->d_col-3, r, s, NORMAL );
      }
   }
}


void get_title( HYDROLOGY *tmp, WINDOW_CONTROL wc, int *c )
{
int append, cntinue, cell_r, cell_c;
char t[82];

   pos.f_col = 1;
   cell_r = wc.v_row + wc.d_row;
   cell_c = 0;
   if (*c == UP && wc.r_row == 2)
      show_footer( tit_foot, wc );
   append = tmp->apd[0];
   if (append)
      strcpy( t, tmp->line );
   cntinue = TRUE;
   while (cntinue) {
      field_editor( t, 'A', 80, cell_r, cell_c, append, c, NORMAL, pos );
      strcpy( tmp->line, t );
      if (*t != '\0')
         tmp->apd[0] = TRUE;
      else
         tmp->apd[0] = FALSE;
      switch (*c) {
         case UP        :
         case DOWN      :
         case RTURN     :
         case PGDN      :
         case PGUP      :
         case ALTF      :
         case ALTD      :
         case ALTC      :
         case ALTU      :
         case ALTH      :
            cntinue = FALSE;
            break;
   }  }
}


void link_list_editor( HYDROLOGY **tmp, WINDOW_CONTROL *wc, int c )
{
HYDROLOGY *a, *b;
int i, k, vr, rr;
char t[82], s[10];

   rr = wc->r_row;
   vr = wc->v_row;
   switch (c) {
      case UP :
         if ( (*tmp)->p != NULL) {
            *tmp = (*tmp)->p;
            if (vr > wc->beg_vrow) {
               --vr;
               --rr;
            } else if (vr == wc->beg_vrow) {
               --rr;
               scroll_window( -1, wc->d_row, 0, wc->d_row+wc->max_rows, 79,
                                                     NORMAL );
               if ((*tmp)->type >= 1 && (*tmp)->type <= 3)
                  fast_write( 0, vr+wc->d_row, (*tmp)->line, NORMAL );
               else {
                  i = 0 + 8 * wc->view;
                  strncpy( t, (*tmp)->line+i, 72 );
                  t[72] = '\0';
                  fast_write( wc->d_col, vr+wc->d_row, t, NORMAL );
                  strcpy( s, itoa( (*tmp)->type, s, 10 ) );
                  if (strlen( s ) == 1)
                     fast_write( wc->d_col-2, vr+wc->d_row, s, NORMAL );
                  else
                     fast_write( wc->d_col-3, vr+wc->d_row, s, NORMAL );
               }
            }
         }
         break;
      case DOWN  :
      case RTURN :
         if ((*tmp)->n != NULL) {
            *tmp = (*tmp)->n;
            if (vr + wc->offset < wc->max_rows-1) {
               ++vr;
               ++rr;
            } else if (vr + wc->offset == wc->max_rows - 1) {
               ++rr;
               scroll_window( 1, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79,
                                                     NORMAL );
               if ((*tmp)->type >= 1 && (*tmp)->type <= 3)
                  fast_write( 0, vr+wc->d_row, (*tmp)->line, NORMAL );
               else {
                  i = 0 + 8 * wc->view;
                  strncpy( t, (*tmp)->line+i, 72 );
                  t[72] = '\0';
                  fast_write( wc->d_col, vr+wc->d_row, t, NORMAL );
                  strcpy( s, itoa( (*tmp)->type, s, 10 ) );
                  if (strlen( s ) == 1)
                     fast_write( wc->d_col-2, vr+wc->d_row, s, NORMAL );
                  else
                     fast_write( wc->d_col-3, vr+wc->d_row, s, NORMAL );
               }
            }
         } else if ((*tmp)->n == NULL && vr > 0) {
            --vr;
            scroll_window( 1, wc->d_row, 0, wc->d_row+wc->max_rows-1, 79,
                                                     NORMAL );
         }
         break;
      case PGDN  :
         for (i=0, k=wc->v_row, a=*tmp; a->n != NULL && i < wc->max_rows;
                                                          a=a->n, i++, k++);
         if (k >= wc-> max_rows) {
            b = a;
            for (i=wc->v_row; i>0 && a->p != NULL; i--, a=a->p);
            show_list( a, wc );
            rr = rr + k - vr;
            *tmp = b;
         }
         break;
      case PGUP  :
         if (rr != vr) {
            i = rr - vr;
            if ( i < wc->max_rows) {
               for (a=*tmp; i>0 && a->p!=NULL; i--, a=a->p);
               for (b=a; a->p != NULL; a=a->p);
               rr = vr + wc->max_rows;
            } else {
               for (i=0, a=*tmp; i<wc->max_rows; i++, a=a->p);
               for (b=a, i=vr; i>0 && a->p!=NULL; i--, a=a->p);
            }
            show_list( a, wc );
            rr = rr - wc->max_rows;
            *tmp = b;
         }
         break;
   }
   wc->r_row = rr;
   wc->v_row = vr;
}


int  range_not_ok( char *t, double low, double high )
{
int rc;
double num;

   if (*t == '\0')
      rc = 1;
   else {
      num = atof( t );
      if (num < (low - .00001) || num > (high + .00001))
         rc = 1;
      else
         rc = 0;
   }
   return( rc );
}


void format_output( char *in, char *out, int field )
{
   memset( out+field*8, ' ', 8 );
   strncpy( out+field*8+(8-strlen( in )), in, strlen( in ) );
}


void show_footer( struct screen *p, WINDOW_CONTROL wc )
{
int row;

   row = wc.d_row + wc.max_rows + 1;
   scroll_window( 0, row, 0, row+3, 79, NORMAL );
   while (p->text != NULL && p->row != 24) {
      fast_write( p->col, p->row, p->text, NORMAL );
      p++;
   }
   if (p->text != NULL)
      fast_write( p->col, p->row, p->text, cfg.f_bar );
}


void write_filename( char *string )
{
char line[82];
int j;

   memset( line, 196, 80 );
   line[80] = '\0';
   fast_write( 0, 2, line, NORMAL );
   strcpy( line, string );
   j = strlen( line );
   insert( line, j, 195 );
   insert( line, 0, 180 );
   j += 2;
   j = 39 - (j >> 1);
   fast_write( j, 2, line, NORMAL );
}


void refresh_screen( HYDROLOGY  *a, WINDOW_CONTROL *wc )
{
int i, row;

   for (i=wc->v_row; a->p!=NULL && i>0; a=a->p)
      i--;
   row = wc->d_row;
   scroll_and_show( a, wc, row );
}
