#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "hydfunc.h"
#include "hyddb.h"


#define ENGLISH  0
#define METRIC   1


extern struct c_scheme clr;
extern struct file_position pos;
extern int units;

static SMALL_WINDOW *w_ptr;

FILE *db_index;
char *file_in = "all.ndx";


/*
 *  master routine for creating a custom HYDROLOGY database
 */
int  cligen_database( HYDROLOGY *tmp, WINDOW_CONTROL *wc, char *t, int *ch )
{
int  i;
int  j;
int  k;
int  l;
char line_in[90];
char line_in1[90];
char str[24];
HYDROLOGY *a;
long offset;
FILE *data_file;
double x;

   w_ptr = NULL;
   offset = do_states( ch );

   if (*ch == RTURN) {
      data_file = fopen( "all.out", "rb" );
      if (data_file != NULL) {
         fseek( data_file, offset, SEEK_SET );
         fread( line_in, sizeof(char), 44, data_file );
         fread( line_in, sizeof(char), 44, data_file );

         /*
          * get latitude
          */
         for (i=0,j=6; j<12; i++, j++)
            str[i] = line_in[j];
         str[i] = '\0';
         while (*str == ' ')
            delete( str, 0 );
         for (a=tmp; a->p != NULL; a=a->p);
         for (; a->type != 6; a=a->n);
         set_field_value( a, str, 9, TRUE );

         /*
          * get elevation
          */
         fread( line_in, sizeof(char), 40, data_file );
         for (i=0,j=12; j<17; i++, j++)
            str[i] = line_in[j];
         str[i] = '\0';
         while (*str == ' ')
            delete( str, 0 );
         if (units == ENGLISH)
            set_field_value( a, str, 8, TRUE );
         else {
            x = atof( str ) * .3048;
            ftoa( (float)x, 2, str );
            set_field_value( a, str, 8, TRUE );
         }

         /*
          * get max temp
          */
         fread( line_in, sizeof(char), 82, data_file );
         for (; a != NULL  &&  a->type != 18; a=a->n);
         for (i=0, j=8, l=0; i<12; i++, l++) {
            for (k=0; k<6; k++,j++)
               str[k] = line_in[j];
            str[k] = '\0';
            while (*str == ' ')
               delete( str, 0 );
            if (i==10) {
               a = a->n;
               l = 0;
            }
            if (units == ENGLISH)
               set_field_value( a, str, l, TRUE );
            else {
               x = (atof( str ) - 32.0) * 5.0 / 9.0;
               ftoa( (float)x, 2, str );
               set_field_value( a, str, l, TRUE );
            }
         }

         /*
          * get min temp
          */
         fread( line_in, sizeof(char), 82, data_file );
         a = a->n;
         for (i=0, j=8, l=0; i<12; i++, l++) {
            for (k=0; k<6; k++,j++)
               str[k] = line_in[j];
            str[k] = '\0';
            while (*str == ' ')
               delete( str, 0 );
            if (i==10) {
               a = a->n;
               l = 0;
            }
            if (units == ENGLISH)
               set_field_value( a, str, l, TRUE );
            else {
               x = (atof( str ) - 32.0) * 5.0 / 9.0;
               ftoa( (float)x, 2, str );
               set_field_value( a, str, l, TRUE );
            }
         }

         /*
          * get solar rad
          */
         fread( line_in, sizeof(char), 82, data_file );
         a = a->n;
         for (i=0, j=8, l=0; i<12; i++, l++) {
            for (k=0; k<6; k++,j++)
               str[k] = line_in[j];
            str[k] = '\0';
            while (*str == ' ')
               delete( str, 0 );
            if (i==10) {
               a = a->n;
               l = 0;
            }
            if (units == ENGLISH)
               set_field_value( a, str, l, TRUE );
            else {
               x = atof( str ) * 0.04184;
               ftoa( (float)x, 2, str );
               set_field_value( a, str, l, TRUE );
            }
         }

         /*
          * get wind and dew point
          */
         fread( line_in, sizeof(char), 82, data_file );
         fread( line_in1, sizeof(char), 82, data_file );
         a = a->n;
         for (i=0, j=8, l=0; i<12; i++, l++) {
            for (k=0; k<6; k++,j++)
               str[k] = line_in1[j];
            str[k] = '\0';
            while (*str == ' ')
               delete( str, 0 );
            if (i==10) {
               a = a->n;
               l = 0;
            }
            if (units == ENGLISH)
               set_field_value( a, str, l, TRUE );
            else {
               x = atof( str ) * 1.6093;
               ftoa( (float)x, 1, str );
               set_field_value( a, str, l, TRUE );
            }
         }
         a = a->n;
         for (i=0, j=8, l=0; i<12; i++, l++) {
            for (k=0; k<6; k++,j++)
               str[k] = line_in[j];
            str[k] = '\0';
            while (*str == ' ')
               delete( str, 0 );
            if (i==10) {
               a = a->n;
               l = 0;
            }
            if (units == ENGLISH)
               set_field_value( a, str, l, TRUE );
            else {
               x = (atof( str ) - 32.0) * 5.0 / 9.0;
               ftoa( (float)x, 2, str );
               set_field_value( a, str, l, TRUE );
            }
         }

         refresh_screen( tmp, wc );
      }
   }
   *ch = 0;
   return( 0 );
}

/*********************************************************************/


long do_states( int *ch )
{
int  i;
int  nfiles;
int  display;
int  sel_city;
int  sel_state;
struct dir_struct dir;
STATES *sl;
long offset;
FILE *all_list;
FILE *data;
char str[80];
char scode[20];

   offset = 0L;
   display = pos.display;
   pos.display = FALSE;
   dir.col = 5;
   dir.row = 3;
   dir.wid = 70;
   dir.hgt = 19;
   dir.num_cols = 4;
   dir.num_lines = 14;
   dir.flist_col[0] = dir.col + 2;
   for (i=1; i<4; i++)
      dir.flist_col[i] = dir.flist_col[i-1] + 16;
   window_control( &w_ptr, SAVE, dir.col, dir.row, dir.wid, dir.hgt );
   no_buf_make_window( dir.col, dir.row, dir.wid, dir.hgt, clr.w_outline );
   for (i=0; i<dir.hgt-2; i++)
      hlight_line( dir.col+1, dir.row+1+i, dir.wid-2, clr.w_list );
   fast_write( dir.col+20, dir.row+2, "Hydrology climate data base",
               clr.w_list );

   all_list = fopen( "all.ndx", "rb" );
   data     = fopen( "all.out", "rb" );
   if (all_list == NULL  ||  data == NULL) {
      fast_write( dir.col+20, dir.row+10,
                  "FATAL ERROR: Cannot find \"all.ndx\" file", clr.w_list );
   } else {
      sl = states;
      nfiles = NSTATES;
      c_off( );
      list_states( sl, nfiles, dir );
      sel_state = 0;
      for (*ch = 0; *ch != ESC && *ch != RTURN;) {
         sel_state = select_state( sl, sel_state, dir, ch );
         if (*ch == RTURN)
            sel_city  = select_city( sl, all_list, data, sel_state, ch );
      }
      if (*ch == RTURN) {
         offset = (sl+sel_state)->index;
         fseek( all_list, offset, SEEK_SET );
         for (i=0; i <= sel_city; i++)
            fread( str, sizeof(char), 57, all_list );
         scode[0] = str[49];
         scode[1] = str[50];
         scode[2] = str[51];
         scode[3] = str[52];
         scode[4] = str[53];
         scode[5] = str[54];
         scode[6] = '\0';
         offset = atol( scode );
      }
   }
   fclose( all_list );
   fclose( data );
   c_on( );
   window_control( &w_ptr, RESTORE, dir.col, dir.row, dir.wid, dir.hgt );
   pos.display = display;
   return( offset );
}


void list_states( STATES *sl, int nelem, struct dir_struct dir )
{
int ncols, nlines;

   nlines = nelem / dir.num_cols;
   if (nelem % dir.num_cols)
      ++nlines;
   if (nlines > dir.num_lines)
      nlines = dir.num_lines;
   ncols = nelem / nlines + (nelem % nlines ? 1 : 0);
   if (ncols > dir.num_cols)
      ncols = dir.num_cols;

   scroll_window( 0, dir.row+3, dir.col+2, dir.row+dir.hgt-3,
                                        dir.col+dir.wid-3, clr.w_list );
   write_states( sl, nelem, nlines, ncols, dir );
}


void write_states( STATES *sl, int nelem, int nlines, int ncols,
                 struct dir_struct dir )
{
int i, j, k;
STATES *tmp, *base;

   base = sl;
   for (i = 0; i < nlines; ++i) {
      tmp = base;
      for (j = 0; j < ncols; ++j) {
         fast_write( dir.flist_col[j], i+dir.row+4, tmp->name, clr.w_list );
         tmp += nlines;
         k = tmp - sl;
         if (k >= nelem)
            break;
      }
      ++base;
   }
}


int  select_state( STATES *sl, int old_state, struct dir_struct dir, int *ch )
{
int field;
int good_key;
int r, c, nlines, nst, ncols, prow;

   get_state_boundaries( NSTATES, &nlines, &ncols, &nst, &prow );
   c = old_state / 14 + 1;
   r = old_state % 14 + 1;

   good_key = FALSE;
   field = r + nlines * (c - 1) - 1;
   hlight_line( (c-1)*16+dir.col+2, r+dir.row+3, 15, clr.w_select );
   *ch = getkey( );
   switch (*ch) {
      case UP    :
      case DOWN  :
      case LEFT  :
      case RIGHT :
      case HOME  :
      case END   :
      case PGUP  :
      case PGDN  :
         good_key = TRUE;
         break;
   }
   while (*ch != ESC && *ch != RTURN) {
      if (good_key)
         hlight_line( (c-1)*16+dir.col+2, r+dir.row+3, 15, clr.w_list );
      switch (*ch) {
         case UP :
            if (r > 1)
               --r;
            else if (c != ncols)
               r = nlines;
            else
               r = prow;
            good_key = TRUE;
            break;
         case DOWN :
            if (r < prow)
               ++r;
            else if (r < nlines && c != ncols)
               ++r;
            else
               r = 1;
            good_key = TRUE;
            break;
         case LEFT :
            if (c > 1) {
               if (c > 1)
                  --c;
               else if (r <= prow)
                  c = ncols;
               else
                  c = ncols - 1;
            }
            good_key = TRUE;
            break;
         case RIGHT :
            if (c < ncols) {
               if (c < ncols - 1)
                  ++c;
               else if (c < ncols && r <= prow)
                  ++c;
               else
                  c = 1;
            }
            good_key = TRUE;
            break;
         case HOME  :
            r = 1;
            c = 1;
            good_key = TRUE;
            break;
         case END   :
            r = prow;
            c = ncols;
            good_key = TRUE;
            break;
         case PGUP  :
            r = 1;
            good_key = TRUE;
            break;
         case PGDN  :
            r = c == ncols ? prow : nlines;
            good_key = TRUE;
            break;
      }
      if (good_key) {
         field = r + nlines * (c - 1) - 1;
         hlight_line( (c-1)*16+dir.col+2, r+dir.row+3, 15, clr.w_select );
         good_key = FALSE;
      }
      *ch = getkey( );
      switch (*ch) {
         case UP    :
         case DOWN  :
         case LEFT  :
         case RIGHT :
         case HOME  :
         case END   :
         case PGUP  :
         case PGDN  :
            good_key = TRUE;
            break;
      }
   }
   return( field );
}


int  select_city( STATES *sl, FILE *fp, FILE *data, int sel_state, int *ch )
{
int i;
int j;
int r, c;
int update_name, change_color, draw_page;
int y, yy;
long file_pos;
HELP_WINDOW hw;
char str[80];
char scode[10];
int  state_num;
char **clist;

   file_pos = (sl+sel_state)->index;
   fseek( fp, file_pos, SEEK_SET );
   fread( str, sizeof(char), 57, fp );
   str[55] = '\0';
   scode[0] = str[40];
   scode[1] = str[41];
   scode[2] = '\0';
   state_num = atoi( scode );
   j = 1;
   fread( str, sizeof(char), 57, fp );
   while (!feof( fp )) {
      str[55] = '\0';
      scode[0] = str[40];
      scode[1] = str[41];
      scode[2] = '\0';
      if (atoi( scode ) == state_num)
         j++;
      else
         break;
      fread( str, sizeof(char), 57, fp );
   }
   hw.num_entries = j;

   fseek( fp, file_pos, SEEK_SET );
   clist = (char **)malloc( (j+1) * sizeof(char *) );
   if (clist == NULL)
      return( -1 );
   else {
      for (r=0; r <= j; r++)
         clist[r] = NULL;
   }
   for (r=0; j > 0; j--, r++) {
      fread( str, sizeof(char), 57, fp );
      str[33] = '\0';
      clist[r] = (char *)malloc( sizeof(char) * 34 );
      if (clist[r] == NULL) {
         hw.num_entries = r + 1;
         break;
      }
      strcpy( clist[r], str );
   }


   hw.v_row = 0;        /*  virtual row in a window */
   hw.select = 0;       /*  current position in help arrays */
   hw.dply_col = 2;
   hw.dply_row = 1;
   hw.line_length = 35;
   hw.avail_lines = 13;
   hw.ulft_col = 23;
   hw.ulft_row = 5;
   hw.total_col = 37;
   hw.total_row = 15;
   window_control( &w_ptr, SAVE, hw.ulft_col, hw.ulft_row,
                   hw.total_col, hw.total_row );
   no_buf_make_window( hw.ulft_col, hw.ulft_row, hw.total_col,
                   hw.total_row, clr.w_outline );
   scroll_window( 0, hw.ulft_row+1, hw.ulft_col+1, hw.ulft_row+hw.total_row-2,
                  hw.ulft_col+hw.total_col-2, clr.w_list );
   show_city_list( clist, &hw );

   c = hw.ulft_col + hw.dply_col;
   r = hw.ulft_row + hw.dply_row + hw.v_row;
   change_color = TRUE;
   *ch = 0;
   while (*ch!=RTURN && *ch!=ESC) {
      draw_page = FALSE;
      update_name = FALSE;
      strcpy( str, clist[hw.select] );
      y  = hw.ulft_row + hw.dply_row;
      yy = hw.ulft_row + hw.dply_row + hw.avail_lines - 1;
      switch (*ch) {
         case UP    :
            if (hw.v_row > 0  &&  hw.select > 0) {
               hlight_line( c, r, 33, clr.w_list );
               --hw.v_row;
               --hw.select;
               change_color = TRUE;
            } else if (hw.v_row == 0  &&  hw.select > 0) {
               hlight_line( c, r, 33, clr.w_list );
               --hw.select;
               scroll_window( -1, y, c, yy+1, c+hw.line_length-2, clr.w_list );
               update_name = TRUE;
               change_color = TRUE;
            }
            break;
         case DOWN :
            if (hw.v_row < hw.avail_lines-1 && hw.select < hw.num_entries-1) {
               hlight_line( c, r, 33, clr.w_list );
               ++hw.v_row;
               ++hw.select;
               change_color = TRUE;
            } else if (hw.v_row == hw.avail_lines-1 &&
                                         hw.select < hw.num_entries-1) {
               hlight_line( c, r, 33, clr.w_list );
               ++hw.select;
               scroll_window( 1, y, c, yy, c+hw.line_length-2, clr.w_list );
               update_name = TRUE;
               change_color = TRUE;
            } else if (hw.select == hw.num_entries - 1 && hw.v_row > 0) {
               --hw.v_row;
               scroll_window( 1, y, c, yy, c+hw.line_length-2, clr.w_list );
            }
            break;
         case PGUP :
            if (hw.select > hw.avail_lines-1) {
               hw.select = hw.select - hw.avail_lines;
               if (hw.v_row > hw.select)
                  hw.select = hw.v_row;
               draw_page = TRUE;
            } else if (hw.select - hw.v_row > 0) {
               hw.select = hw.v_row;
               draw_page = TRUE;
            }
            break;
         case PGDN :
            if (hw.select + hw.avail_lines < hw.num_entries) {
               hw.select = hw.select + hw.avail_lines;
               draw_page = TRUE;
            } else if (hw.select + hw.avail_lines - hw.v_row <
                                                         hw.num_entries) {
               hw.select = hw.num_entries - 1;
               draw_page = TRUE;
            }
            if ((hw.num_entries - 1) - hw.select <
                                              hw.avail_lines && draw_page) {
               i = r - hw.v_row;
               scroll_window( 0, i, c, i+hw.avail_lines-1,
                              c+hw.line_length-2, clr.w_list );
            }
            break;
      }
      if (draw_page == TRUE) {
         show_city_list( clist, &hw );
         update_name = TRUE;
         change_color = TRUE;
      }
      r = hw.ulft_row + hw.dply_row + hw.v_row;
      if (update_name)
         fast_write( c, r, clist[hw.select], clr.w_list );
      if (change_color)
         hlight_line( c, r, 33, clr.w_select );
      *ch = getkey( );
      change_color = FALSE;
   }

   if (*ch != RTURN)
      *ch = 0;

   window_control( &w_ptr, RESTORE, hw.ulft_col, hw.ulft_row,
                   hw.total_col, hw.total_row );

   for (r=0; r < hw.num_entries; r++)
      free( clist[r] );
   free( clist );
   return( hw.select );
}


void show_city_list( char **clist, HELP_WINDOW *hw )
{
int row, col, i, j;

   col = hw->ulft_col + hw->dply_col;
   row = hw->ulft_row + hw->dply_row;
   i = 0;
   j = hw->select - hw->v_row;
   for (; i < hw->avail_lines && j<hw->num_entries; i++, j++, row++)
      fast_write( col, row, clist[j], clr.w_list );
}


void get_state_boundaries( int nelem, int *nlines, int *ncols, int *nfiles,
                           int *prow )
{
int lxc;

   /*
    * Have room for only so many files on display screen.
    *  In fact, there is only room for LINES * COLS of files.
    *  Let's say we can display only 6 lines and 5 columns of
    *  files - total of 30 files on screen at one time.  Given
    *  some number of files, we can compute how many lines and
    *  columns are needed to display the file names.
    */

   *nlines = nelem / 4;         /* divide num of files to get num lines */
   if (nelem % 4)               /* only have enough room on screen for  */
      ++*nlines;                /* 5 columns and 6 - 10 lines           */
   *nlines = *nlines > 14 ? 14 : *nlines;
   *ncols = nelem / *nlines + (nelem % *nlines ? 1 : 0); /* round up */
   *ncols = *ncols > 4 ? 4 : *ncols;           /* figure number of cols */

   lxc = *nlines * *ncols;              /* lines times cols = lxc */
   *nfiles = nelem > lxc ? lxc : nelem; /* can only show nfiles on screen */
   *prow = *nlines - (lxc - *nfiles);   /* right most row will be  */
                                        /* partially filled */
}
