typedef struct {
   int  beg_vrow;
   int  max_rows;
   int  d_col;
   int  d_row;
   int  offset;
   int  v_row;
   int  r_row;
   int  field;
   int  view;
} WINDOW_CONTROL;


typedef struct hyd_node {
   char   line[82];
   float  num[10];
   char   apd[10];
   int    type;
   struct hyd_node *n;
   struct hyd_node *p;
} HYDROLOGY;


struct hilo {
   double lo;
   double hi;
};

struct limit_type {
   int field_type[10];
   struct hilo range[10];
   int width[10];
   int max_cells;
};

struct card_parse {
  int c_no;
  int flgnut;
  int flgpen;
  int forest;
  int seen5;
  int isoil;
  int base;
  int acid;
  int num_31, num_32;
  int user_lai[12];
  int seen33;
  int num_33;
  int cnt_33;
  int newt;
  int newr;
  int newl;
  int neww;
  int newd;
  int eof;
  int update_cn2;
  int num_34;
  int num_35;
};


struct OUTBUF {
   char      *fname;
};


typedef struct {
   int  mo, day, jday, irot;
   long gday;
} DATE_TYPE;



typedef struct {
   int dply_col;
   int dply_row;
   int line_length;
   int avail_lines;
   int v_row;
   int select;
   int num_entries;
   int ulft_col;
   int ulft_row;
   int total_col;
   int total_row;
} HELP_WINDOW;


typedef struct {
   int txt_lines;
   int rl;
   int offset;
} LARGE_TEXT_HELP;


typedef struct {
   char *line;
   char *value;
} TABLE_TYPE;


typedef struct {
   char *txt[5];
   char *line;
   char *value;
} TEXT_TYPE;



struct screen {
   unsigned int row;
   unsigned int col;
   unsigned char *text;
};


struct file_position {
   int display;
   int d_row;
   int d_col;
   int color;
   int f_row;
   int f_col;
};


typedef struct small_win {
   int x;
   int y;
   int *buf;
   struct small_win *n;
} SMALL_WINDOW;



struct c_scheme {
   int m_bar;
   int m_alt;
   int m_select;
   int w_outline;
   int w_list;
   int w_select;
};


struct win_vars {
   int wid;
   int hgt;
   int d_col;
   int d_row;
   int fld;
   int max_fld;
   int c;
   int r;
   int f_b;
   int f_clr;
   int b_clr;
};


struct sample_vars {
   int left_bar_c;
   int left_bar_r;
   int left_alt_c;
   int left_alt_r;
   int head_c;
   int head_r;
   int right_bar_c;
   int right_bar_r;
   int right_alt_c;
   int right_alt_r;
   int win_c;
   int win_r;
   int win_wid;
   int win_hgt;
   int list1_c;
   int list1_r;
   int select_c;
   int select_r;
   int list2_c;
   int list2_r;
   int cursor_c;
   int cursor_r;
   int help_tbl_c;
   int help_tbl_r;
   int f_bar_c;
   int f_bar_r;
};


struct temp_c_scheme {
   int m_bar;
   int m_alt;
   int m_select;
   int w_outline;
   int w_list;
   int w_select;
   int cursor;
   int help_tbl;
   int f_bar;
};


struct dir_struct {
   int row, col, wid, hgt;
   int num_cols, num_lines;
   int flist_col[4];
};


typedef struct {
   char *name;
   int  num;
   long index;
} STATES;


typedef struct {
   char line[90];
} CUSTOM_PEST;


/*********************** prototypes in field.c   **********************/
void field_editor( char *, int, int, int, int, int, int *, int,
                   struct file_position );
/**********************************************************************/


/*********************** prototypes in getfns.c  **********************/
void do_dir( void );
int  path_not_ok( char far *, int, int );
int  get_directory( struct OUTBUF *, struct OUTBUF *, char *, int * );
char last_ch( char * );
int  fatal( char *, int );
int  getdrive( void );
void drvpath( char far * );
int  drive( char );
void list_files( struct OUTBUF *, int, struct dir_struct );
void write_list( struct OUTBUF *, int, int, int, struct dir_struct );
void select_file( struct OUTBUF *, int, struct dir_struct, int * );
void get_boundaries( int, int *, int *, int *, int *, int *,
                     struct dir_struct );
int  fname_cmp( struct OUTBUF *, struct OUTBUF * );
/**********************************************************************/


/*********************** prototypes in h4h.c   ************************/
void get_hyd_help( HYDROLOGY **, WINDOW_CONTROL *, char *, int * );
void get_rc_help( HELP_WINDOW *, int *, char * );
void get_satk_help( HELP_WINDOW *, int *, char * );
void get_isoil_help( HELP_WINDOW *, int *, char * );
void get_chs_help( HYDROLOGY *, WINDOW_CONTROL *, HELP_WINDOW *, int *,
                   char * );
void get_wlw_help( HYDROLOGY *, WINDOW_CONTROL *, HELP_WINDOW *, int *,
                   char * );
void set_soil_selection( HYDROLOGY *, WINDOW_CONTROL *, HELP_WINDOW );
void fill_card810( HYDROLOGY *, WINDOW_CONTROL *, HELP_WINDOW );
void show_help_list( HELP_WINDOW *, TABLE_TYPE *, int );
void position_cursor( HELP_WINDOW *, char *, int *, int *, int * );
void master_help( HELP_WINDOW *, TABLE_TYPE *, struct screen *, char *, int * );
void save_and_draw( HELP_WINDOW *, struct screen * );
void get_rot_yr( HELP_WINDOW *hw, DATE_TYPE *date, int *ch, float hi,
                 float lo);
void get_date( HELP_WINDOW *hw, DATE_TYPE *date, int *ch, float hi, float lo );
void write_date( int, int, DATE_TYPE *, int );
void write_irot_date( int, int, DATE_TYPE *, int );
int  day_of_year( int, int );
void month_day( int, int *, int * );
void get_date_help( HYDROLOGY *, WINDOW_CONTROL *, HELP_WINDOW *, int *,
                    char * );
/**********************************************************************/


/*********************** prototypes in hyd1.c  ************************/
int  init_from_file( HYDROLOGY **, char * );
void init_all_cards( HYDROLOGY ** );
void quit( HYDROLOGY *, int * );
void blank_line( HYDROLOGY * );
void intro( void );
void work_screen( HYDROLOGY *, WINDOW_CONTROL );
void show_list( HYDROLOGY *, WINDOW_CONTROL * );
void get_title( HYDROLOGY *, WINDOW_CONTROL, int * );
void link_list_editor( HYDROLOGY **, WINDOW_CONTROL *, int );
int  range_not_ok( char *, double, double );
void format_output( char *, char *, int );
void show_footer( struct screen *, WINDOW_CONTROL );
void write_filename( char * );
void refresh_screen( HYDROLOGY *, WINDOW_CONTROL * );
/**********************************************************************/


/*********************** prototypes in hyd4.c  ************************/
void get_card4_33( HYDROLOGY **, WINDOW_CONTROL *, int * );
void setup_field( HYDROLOGY *, int, int, char * );
void change_min_max_limits( HYDROLOGY *, WINDOW_CONTROL *, int *, int * );
void change_field_info_structs( HYDROLOGY *, WINDOW_CONTROL *, int * );
void check_card4_hbdate( HYDROLOGY *, WINDOW_CONTROL *, int *, char * );
void check_card4_forest( HYDROLOGY * );
void check_card4_iropt( HYDROLOGY *, WINDOW_CONTROL * );
void check_card4_units( HYDROLOGY * );
void check_card4_nut( HYDROLOGY *, WINDOW_CONTROL * );
void check_card5( HYDROLOGY **, WINDOW_CONTROL * );
void check_beg_endgro( HYDROLOGY *, WINDOW_CONTROL * );
void check_card6_rd( HYDROLOGY *, WINDOW_CONTROL *, char * );
void check_card6_cn2( HYDROLOGY *, WINDOW_CONTROL * );
void check_card7( HYDROLOGY *, WINDOW_CONTROL *, int *, int *, char * );
void check_card28( HYDROLOGY *, WINDOW_CONTROL * );
void check_card29_userlai( HYDROLOGY *, WINDOW_CONTROL * );
void check_card30_dates( HYDROLOGY *, WINDOW_CONTROL *, int *, char * );
void check_card31_nolai( HYDROLOGY *, WINDOW_CONTROL * );
void check_card33( HYDROLOGY *, WINDOW_CONTROL *, int *, char * );
void check_card34( HYDROLOGY *, WINDOW_CONTROL *, int *, char * );
void blank_old_horz( HYDROLOGY *, WINDOW_CONTROL * );
void change_card7_footer( HYDROLOGY *, WINDOW_CONTROL *, int, int * );
void change_footer( char *, int, int, int, int );
void scroll_and_show( HYDROLOGY *, WINDOW_CONTROL *, int );
int  get_field_value( HYDROLOGY *, int );
void set_field_value( HYDROLOGY *, char *, int, int );
void get_string_field_value( HYDROLOGY *, char *, int );
void add_remove_c29( HYDROLOGY **, WINDOW_CONTROL *, int * );
void add_remove_diff( HYDROLOGY **, int, int );
void view_lft_rgt( HYDROLOGY *, WINDOW_CONTROL * );
/**********************************************************************/


/*********************** prototypes in pd.c  **************************/
void pd( void );
void lite_bar_menu( HYDROLOGY **, HYDROLOGY **, WINDOW_CONTROL *, int *,
                    int * );
void pull_down( HYDROLOGY **, HYDROLOGY **, WINDOW_CONTROL *, int, int *,
                int * );
void demo( void );
void draw_lite_bar( int, int );
void get_bar_spacing( int, int *, int * );
void draw_lite_head( int, int * );
void draw_lite_alt( int, int * );
void set_colors( int, int, int, int, int );
void change_color_name( struct win_vars * );
void toggle_hilite( struct win_vars );
void update_sample( struct win_vars, struct sample_vars, struct temp_c_scheme );
void make_change_perm( struct temp_c_scheme, int *, int *, int, int, int, int,
                       int );
void init_tmp_color( struct temp_c_scheme * );
void init_win_vars( struct win_vars * );
void init_sample_vars( struct win_vars, struct sample_vars * );
void get_color_name_posn( struct win_vars * );
void setup_set_colors( struct win_vars, struct sample_vars,
                       struct temp_c_scheme );
void decompose_color( int, int *, int *, struct temp_c_scheme );
void compose_color( int, int, int, struct temp_c_scheme * );
void give_current_colors( int, int, struct temp_c_scheme );
int  load_file( HYDROLOGY **, HYDROLOGY **, WINDOW_CONTROL *, char * );
void add_a_line( HYDROLOGY *, char *, struct card_parse * );
int  save_file( HYDROLOGY *, char * );
void stop( HYDROLOGY **, int * );
void help( void );
void help_card20( void );
void help_card21( void );
int  e2m( HYDROLOGY * );
void f2c( HYDROLOGY * );
void m2k( HYDROLOGY * );
void l2Mj( HYDROLOGY * );
int  m2e( HYDROLOGY * );
void c2f( HYDROLOGY * );
void k2m( HYDROLOGY * );
void Mj2l( HYDROLOGY * );
/**********************************************************************/


/*********************** prototypes in screen.c  **********************/
void retrace( int );
int  getkey( void );
void write_to_window( struct screen *, int, int, int );
void hlight_line( int, int, int, int );
void show_file_position( struct file_position, int );
void set_cur( int, int );
void c_off( void );
void c_on( void );
void write_cur( char );
void insert_cursor( void );
void insert( char far *, int, int );
void delete( char far *, int );
void ftoa( float, int, char * );
void scroll_window( int, int, int, int, int, int );
void cls( void );
void get_vcfg( void );
void fast_write( int, int, char far *, int );
void wherexy( int *, int * );
int set_color( int, int );
void show_box( int, int, struct screen *, int );
void no_buf_make_window( int, int, int, int, int );
void no_buf_box( int, int, int, int, int );
void no_buf_clear_window( int, int, int, int );
void window_control( SMALL_WINDOW **, int, int, int, int, int );
void save_window( int far *, int, int, int, int );
void restore_window( int far *, int, int, int, int );
/**********************************************************************/


/********************** prototypes in hydbase.c  **********************/
int  cligen_database( HYDROLOGY *, WINDOW_CONTROL *, char *, int * );
long do_states( int * );
void list_states( STATES *, int, struct dir_struct );
void write_states( STATES *, int, int, int, struct dir_struct );
int  select_state( STATES *, int, struct dir_struct, int * );
int  select_city( STATES *, FILE *, FILE *, int, int * );
void show_city_list( char **, HELP_WINDOW * );
void get_state_boundaries( int, int *, int *, int *, int * );
/**********************************************************************/
