#define VLEFT    0
#define VRIGHT   1

#define ENGLISH  0
#define METRIC   1


struct hilo {
   double lo;
   double hi;
};


struct limit_type {
   int field_type[10];
   struct hilo range[10];
   int width[10];
   int max_cells;
} english_limits[19] = {
   { 'I', 'I', 'I', 'I', 'I', 0, 0, 0, 0, 0,               /* card 4 */
     1582.0, 3000.0,  1582.0, 3000.0,  0.0, 5.0,   1.0, 6.0,  0.0, 1.0,
     0.0, 0.0,        0.0, 0.0,        0.0, 0.0,   0.0, 0.0,  0.0, 0.0,
     4, 4, 1, 1, 1, 0, 0, 0, 0, 0,         4},
   { 'R', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 5 */
     10.0, 1000.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,      0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     7, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'I', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                     /* card 6 */
     1.0, 10.0,  0.0005, 500.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,       0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 7 */
     0.0, 3000.0,  0.0005, 3.0,  0.0, 3000.0,  0.0005, 3.0,  0.0, 3000.0,
     0.0005, 3.0,  0.0, 3000.0,  0.0005, 3.0,  0.0, 3000.0,  0.0005, 3.0,
     7, 5, 7, 5, 7, 5, 7, 5, 7, 5,         9},
   { 'I', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 0,       /* card 8 */
     1.0, 4.0,   .01, 1.0,   0.005, .8,   0.01, 1.0,   0.005, .8,
     0.01, 1.0,  0.005, .8,  0.01, 1.0,   0.005, .8,   0.0, 0.0,
     1, 4, 5, 4, 5, 4, 5, 4, 5, 0,         8},
   { 'I', 'I', 'R', 'R', 'R', 'R', 'R', 0, 0, 0,           /* card  9 */
     1.0, 5.0,    1.0, 4.0,    0.01, 30.0,  0.01, 2.5,  0.0, 500.0,
     0.0, 500.0,  1.0, 100.0,  0.0, 0.0,    0.0, 0.0,   0.0, 0.0,
     1, 1, 5, 5, 5, 5, 5, 0, 0, 0,         6},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 10 */
     1.0, 10000.0,  0.0001, 1.0,    1.0, 10000.0,   0.0001, 1.0,   1.0, 10000.0,
     0.0001, 1.0,   1.0, 10000.0,   0.0001, 1.0,    1.0, 10000.0,  0.0001, 1.0,
     7, 6, 7, 6, 7, 6, 7, 6, 7, 6,         9},
   { 'R', 'R', 'R', 0, 0, 0, 0, 0, 0, 0,                   /* card 11 */
     1.0, 100.0,  .03, 0.5,  0.0001, 1.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,     .0, 0.0,  0.0, 0.0,     0.0, 0.0,  0.0, 0.0,
     4, 5, 5, 0, 0, 0, 0, 0, 0, 0,         2},
   { 'R', 'R', 'R', 'R', 'R', 'I', 'R', 'R', 0, 0,         /* card 12 */
     .01, 1000.0,  .001, 10.0,  .01, 10.0,     .001, 2.0,  .001, 2.0,
     1.0, 2.0,     .01, 10.0,   .01, 100000.0,  0.0, 0.0,   0.0, 0.0,
     7, 4, 4, 4, 4, 1, 4, 8, 0, 0,         7},
   { 'I', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 13 */
     1.0, 50.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I',     /* card 14 */
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3,         9},
   { 'I', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 15 */
     1.0, 9.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     0., 0.,    0., 0.,    0., 0.,    0., 0.,    0., 0.,
     1, 3, 3, 3, 3, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 16 */
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4,         9},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 17 */
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4,         9},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 18 */
     .01, .40,  .01, .40,  .01, .40,  .01, .40,  .01, .40,
     .01, .40,  .01, .40,  .01, .40,  .01, .40,  .01, .40,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'I', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 19 */
     1.0, 9.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     0., 0.,    0., 0.,    0., 0.,    0., 0.,    0., 0.,
     1, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 20 */
     .03, .40,  .03, .40,  .03, .40,  .03, .40,  .03, .40,
     .03, .40,  .03, .40,  .03, .40,  .03, .40,  .03, .40,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',     /* card 21 */
     -99.0, 1.0,  -99.0, 1.0,  -99.0, 1.0,  -99.0, 1.0,  -99.0, 1.0,
     -99.0, 1.0,  -99.0, 1.0,  -99.0, 1.0,  -99.0, 1.0,  -99.0, 1.0,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',     /* card 22 */
     -99.0, 100.0,  -99.0, 100.0,  -99.0, 100.0,  -99.0, 100.0,  -99.0, 100.0,
     -99.0, 100.0,  -99.0, 100.0,  -99.0, 100.0,  -99.0, 100.0,  -99.0, 100.0,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9}
};


struct limit_type  metric_limits[19] = {
   { 'I', 'I', 'I', 'I', 'I', 0, 0, 0, 0, 0,               /* card 4 */
     1582.0, 3000.0,  1582.0, 3000.0,  0.0, 5.0,  1.0, 6.0,  0.0, 1.0,
     0.0, 0.0,        0.0, 0.0,        0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     4, 4, 1, 1, 1, 0, 0, 0, 0, 0,         4},
   { 'R', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 5 */
     10.0, 1000.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,      0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     7, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'I', 'R', 0, 0, 0, 0, 0, 0, 0, 0,                     /* card 6 */
     1.0, 10.0,  0.0002, 200.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,       0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 6, 0, 0, 0, 0, 0, 0, 0, 0,         1},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 7 */
     0.0, 915.0,   0.0005, 3.0,  0.0, 915.0,   0.0005, 3.0,  0.0, 915.0,
     0.0005, 3.0,  0.0, 915.0,   0.0005, 3.0,  0.0, 915.0,   0.0005, 3.0,
     7, 5, 7, 5, 7, 5, 7, 5, 7, 5,         9},
   { 'I', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 0,       /* card 8 */
     1.0, 4.0,   .01, 1.0,   0.005, .8,   0.01, 1.0,   0.005, .8,
     0.01, 1.0,  0.005, .8,  0.01, 1.0,   0.005, .8,   0.0, 0.0,
     1, 4, 5, 4, 5, 4, 5, 4, 5, 0,         8},
   { 'I', 'I', 'R', 'R', 'R', 'R', 'R', 0, 0, 0,           /* card 9 */
     1.0, 5.0,   1.0, 4.0,     0.01, 30.0,  0.01, 2.5,  0.0, 200.0,
     0.0, 200.0,  1.0, 100.0,  0.0, 0.0,   0.0, 0.0,    0.0, 0.0,
     1, 1, 5, 5, 5, 5, 5, 0, 0, 0,         6},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 10 */
     0.3, 3050.0,  0.0001, 1.0,   0.3, 3050.0,  0.0001, 1.0,  0.3, 3050.0,
     0.0001, 1.0,  0.3, 3050.0,   0.0001, 1.0,  0.3, 3050.0,  0.0001, 1.0,
     7, 6, 7, 6, 7, 6, 7, 6, 7, 6,         9},
   { 'R', 'R', 'R', 0, 0, 0, 0, 0, 0, 0,                   /* card 11 */
     1.0, 100.0,  .03, 0.5,  0.0001, 1.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,     .0, 0.0,  0.0, 0.0,     0.0, 0.0,  0.0, 0.0,
     4, 5, 5, 0, 0, 0, 0, 0, 0, 0,         2},
   { 'R', 'R', 'R', 'R', 'R', 'I', 'R', 'R', 0, 0,         /* card 12 */
     .004, 405.0,  .002, 25.4,  .01, 10.0,      .001, 2.0,  .001, 2.0,
     1.0, 2.0,     .02, 25.4,   .01, 100000.0,  0.0, 0.0,   0.0, 0.0,
     7, 4, 4, 4, 4, 1, 4, 8, 0, 0,         7},
   { 'I', 0, 0, 0, 0, 0, 0, 0, 0, 0,                       /* card 13 */
     1.0, 50.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     0.0, 0.0,   0.0, 0.0,  0.0, 0.0,  0.0, 0.0,  0.0, 0.0,
     2, 0, 0, 0, 0, 0, 0, 0, 0, 0,         0},
   { 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I',     /* card 14 */
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,  1.0, 366.0,
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3,         9},
   { 'I', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 15 */
     1.0, 9.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     0., 0.,    0., 0.,    0., 0.,    0., 0.,    0., 0.,
     1, 3, 3, 3, 3, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 16 */
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4,         9},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 17 */
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     4, 4, 4, 4, 4, 4, 4, 4, 4, 4,         9},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 18 */
     .01, .40,  .01, .40,  .01, .40,  .01, .40,  .01, .40,
     .01, .40,  .01, .40,  .01, .40,  .01, .40,  .01, .40,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'I', 'R', 'R', 'R', 'R', 0, 0, 0, 0, 0,               /* card 19 */
     1.0, 9.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,  .01, 1.0,
     0., 0.,    0., 0.,    0., 0.,    0., 0.,    0., 0.,
     1, 4, 4, 4, 4, 0, 0, 0, 0, 0,         4},
   { 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R',     /* card 20 */
     .03, .40,  .03, .40,  .03, .40,  .03, .40,  .03, .40,
     .03, .40,  .03, .40,  .03, .40,  .03, .40,  .03, .40,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',     /* card 21 */
     -99.0, 0.31,  -99.0, 0.31,  -99.0, 0.31,  -99.0, 0.31,  -99.0, 0.31,
     -99.0, 0.31,  -99.0, 0.31,  -99.0, 0.31,  -99.0, 0.31,  -99.0, 0.31,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9},
   { 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N',     /* card 22 */
     -99.0, 30.5,  -99.0, 30.5,  -99.0, 30.5,  -99.0, 30.5,  -99.0, 30.5,
     -99.0, 30.5,  -99.0, 30.5,  -99.0, 30.5,  -99.0, 30.5,  -99.0, 30.5,
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5,         9}
};

typedef struct {
   int  beg_vrow;
   int  max_rows;
   int  d_col;
   int  d_row;
   int  offset;
   int  v_row;
   int  r_row;
   int  field;
   int  view;
} WINDOW_CONTROL;



typedef struct ero_node {
   char   line[82];
   float  num[10];
   char   apd[10];
   int    type;
   struct ero_node *n;
   struct ero_node *p;
}EROSION;


#define   TMP_LINE   0
#define   TMP_NUM    1*82
#define   TMP_APD    TMP_NUM+4*10
#define   TMP_TYPE   TMP_APD+1*10
#define   TMP_N      TMP_TYPE+2
#define   TMP_P      TMP_N+4

#define  WC_BEG_VROW   0
#define  WC_MAX_ROWS   2
#define  WC_D_COL      4
#define  WC_D_ROW      6
#define  WC_OFFSET     8
#define  WC_V_ROW      10
#define  WC_R_ROW      12
#define  WC_FIELD      14
#define  WC_VIEW       16



/* table of pointers - pointer takes 2 bytes. so 10 * 2 = 20 */
#define FOOT_PTRS 20


struct screen byear[] = {
  {20,0,"BYEAR   Enter the last two digits of the year when simulation begins."},
  {21,8,"Range : 1582 - 3000"},
  {0, 0, NULL}
};

struct screen eyear[] = {
  {20,0,"EYEAR   Enter the last two digits of the year when simulation ends."},
  {21,8,"Range : 1582 - 3000"},
  {0, 0, NULL}
};

struct screen eroout[] = {
  {20,0,"EROOUT  Select the level of erosion output desired."},
  {21,8,"Range : 0 - 5"},
  {24,0," F1 = Help"}
};


struct screen flgseq[] = {
  {20,0,"FLGSEQ  This flag determines the execution sequence of the erosion /"},
  {21,8,"sediment submodels."},
  {22,8,"Range : 1 - 6"},
  {24,0," F1 = Help"}
};


struct screen metflg[] = {
  {20,0,"METFLG  0  English units."},
  {21,8,"1  Metric units."},
  {22,8,"Range : 0 - 1"},
  {0, 0, NULL}
};

struct screen sscly[] = {
  {20,0,"SSCLY   Specific surface area of clay particles (m**2/g).  Suggested value"},
  {21,8,"of 20.0 for kaolinite and 800.0 for montmorillonite."},
  {22,8,"Range : 10.0 - 1000.0"},
  {0, 0, NULL}
};

struct screen nptso[] = {
  {20,0,"NPTSO   Number of points for overland flow profile slope."},
  {21,8,"Range : 1 - 10"},
  {0, 0, NULL}
};

struct screen daovre[] = {
  {20,0,"DAOVR   Drainage area (acres) represented by overland flow profile."},
  {21,8,"Range : .0005 - 500.0"},
  {0, 0, NULL}
};

struct screen daovrm[] = {
  {20,0,"DAOVR   Drainage area (hectares) represented by overland flow profile."},
  {21,8,"Range : .0002 - 200.0"},
  {0, 0, NULL}
};

struct screen xov_e[] = {
  {20,0,"XOV     Distance, in feet, from upper end of overland flow profile"},
  {21,8,"to the point where slope is given."},
  {22,8,"Range :    0.0 - 3000.0  "},
  {24,43,"Point =   "}
};

struct screen xov_m[] = {
  {20,0,"XOV     Distance, in meters, from upper end of overland flow profile"},
  {21,8,"to the point where slope is given."},
  {22,8,"Range :    0.0 - 915.0  "},
  {24,43,"Point =   "}
};

struct screen slov_e[] = {
  {20,0,"SLOV    Slope of the overland flow profile at the XOV(), ft/ft."},
  {21,8,"Range : .0005 - 3.0    "},
  {24,43,"Point =   "}
};

struct screen slov_m[] = {
  {20,0,"SLOV    Slope of the overland flow profile at the XOV(), m/m."},
  {21,8,"Range : .0005 - 3.0    "},
  {24,43,"Point =   "}
};

struct screen nxk[] = {
  {20,0,"NXK     Number (1 to 4) of slope segments differentiated by changes in"},
  {21,8,"soil erodibility factor."},
  {22,8,"Range : 1 - 4"},
  {0, 0, NULL}
};

struct screen xsoil[] = {
  {20,0,"XSOIL   Relative horizontal distance from the top of the slope to"},
  {21,8,"the bottom of the segment.  Last (bottom) segment must be 1.0."},
  {22,8,"Range : .01 - 1.0"},
  {0, 0, NULL}
};

struct screen ksoile[] = {
  {20,0,"KSOIL   Soil erodibility factor (ton/acre per English EI) for slope"},
  {21,8,"segement just above XSOIL."},
  {22,8,"Range : .005 - .80 "},
  {0, 0, NULL}
};

struct screen ksoilm[] = {
  {20,0,"KSOIL   Soil erodibility factor for slope"},
  {21,8,"segement just above XSOIL."},
  {22,8,"Range : .005 - .80 "},
  {0, 0, NULL}
};

struct screen nsc[] = {
  {20,0,"NSC     Number of channel segments differentiated by changes in slope."},
  {21,8,"Range : 1 - 5"},
  {0, 0, NULL}
};

struct screen ctlo[] = {
  {20,0,"CTLO    OUTLET CONTROL flag.  Looking downstream, those conditions beyond"},
  {21,8,"the end of the channel that affect erosion or deposition."},
  {22,8,"Range : 1 - 4"},
  {24,0," F1 = Help"}
};

struct screen ctlz[] = {
  {20,0,"CTLZ    Side slope of a cross-section of the OUTLET CONTROL channel,"},
  {21,8,"expressed as a ratio of horizontal to vertical."},
  {22,8,"Range : 1 - 100"},
  {0, 0, NULL}
};

struct screen ctln[] = {
  {20,0,"CTLN    Manning's 'n' for the OUTLET CONTROL channel."},
  {21,8,"Range : .03 - .5"},
  {0, 0, NULL}
};

struct screen ctlsle[] = {
  {20,0,"CTLSL   Slope (ft/ft) of the OUTLET CONTROL channel."},
  {21,8,"Range : .0001 - 1.0"},
  {0, 0, NULL}
};

struct screen ctlslm[] = {
  {20,0,"CTLSL   Slope (m/m) of the OUTLET CONTROL channel."},
  {21,8,"Range : .0001 - 1.0"},
  {0, 0, NULL}
};

struct screen ra[] = {
  {20,0,"RA      Coefficient in the rating equation."},
  {21,8,"Range : .01 - 30.0"},
  {24,0," F1 = Help"}
};

struct screen rn[] = {
  {20,0,"RN      Exponent in the rating equation."},
  {21,8,"Range : .01 - 2.5"},
  {24,0," F1 = Help"}
};

struct screen dachle[] = {
  {20,0,"DACHL   Total drainage area (acres) at the lower end of the channel."},
  {21,8,"Range : 0 - 500"},
  {0, 0, NULL}
};

struct screen dachlm[] = {
  {20,0,"DACHL   Total drainage area (hectares) at the lower end of the channel."},
  {21,8,"Range : 0 - 200"},
  {0, 0, NULL}
};

struct screen dachue[] = {
  {20,0,"DACHU   Drainage area (acres) above upper end of channel."},
  {21,8,"Range : 0 - 500"},
  {0, 0, NULL}
};

struct screen dachum[] = {
  {20,0,"DACHU   Drainage area (hectares) above upper end of channel."},
  {21,8,"Range : 0 - 200"},
  {0, 0, NULL}
};

struct screen ze[] = {
  {20,0,"Z       Side slope (ft/ft) of field channel cross-section, expressed"},
  {21,8,"as horizontal to vertical distance."},
  {22,8,"Range : 1.0 - 100.0"},
  {0, 0, NULL}
};

struct screen zm[] = {
  {20,0,"Z       Side slope (m/m) of field channel cross-section, expressed"},
  {21,8,"as horizontal to vertical distance."},
  {22,8,"Range : 1.0 - 100.0"},
  {0, 0, NULL}
};

struct screen xslpie[] = {
  {20,0,"XSLP(I) Distance (ft) from upper end of the channel to the bottom"},
  {21,8,"of segment I for channel segment slope."},
  {22,8,"Range :     1.0 - 10000  "},
  {24,0,"                                 Channel segment =  "}
};

struct screen xslpim[] = {
  {20,0,"XSLP(I) Distance (m) from upper end of the channel to the bottom"},
  {21,8,"of segment I for channel segment slope."},
  {22,8,"Range :      .3 - 3050   "},
  {24,0,"                                 Channel segment =  "}
};

struct screen sslpie[] = {
  {20,0,"SSLP(I) Slope (ft/ft) of segment directly above XSLP(I)."},
  {21,8,"Range : .0001 - 1.0     "},
  {24,0,"                                 Channel segment =  "}
};

struct screen sslpim[] = {
  {20,0,"SSLP(I) Slope (m/m) of segment directly above XSLP(I)."},
  {21,8,"Range : .0001 - 1.0     "},
  {24,0,"                                 Channel segment =  "}
};

struct screen ctl[] = {
  {20,0,"CTL     Control."},
  {21,8,"1  If pipe outlet control is typical of impoundment type terraces."},
  {22,8,"2  if orifice coefficient (C on card 12) is to be entered."},
  {23,8,"Range : 1 - 2"},
  {0, 0, NULL}
};

struct screen dapnde[] = {
  {20,0,"DAPND   Total drainage area (acres) above the impoundment, generally"},
  {21,8,"the drainage area of the field is same as DACRE in hydrology."},
  {22,8,"Range : .01 - 1000"},
  {0, 0, NULL}
};

struct screen dapndm[] = {
  {20,0,"DAPND   Total drainage area (hectaces) above the impoundment, generally"},
  {21,8,"the drainage area of the field is same as DACRE in hydrology."},
  {22,8,"Range : .004 - 405"},
  {0, 0, NULL}
};

struct screen intakee[] = {
  {20,0,"INTAKE  Saturated soil water intake rate (in/hr) or saturated"},
  {21,8,"conductivity within the inpoundment."},
  {22,8,"Range : .001 - 10"},
  {0, 0, NULL}
};

struct screen intakem[] = {
  {20,0,"INTAKE  Saturated soil water intake rate (cm/hr) or saturated"},
  {21,8,"conductivity within the inpoundment."},
  {22,8,"Range : .002 - 25.4"},
  {0, 0, NULL}
};

struct screen fronte[] = {
  {20,0,"FRONT   Embankment front slope (vertical to horizontal, ft/ft)."},
  {21,8,"Range : .01 - 10.0"},
  {0, 0, NULL}
};

struct screen frontm[] = {
  {20,0,"FRONT   Embankment front slope (vertical to horizontal, m/m)."},
  {21,8,"Range : .01 - 10.0"},
  {0, 0, NULL}
};

struct screen drawe[] = {
  {20,0,"DRAW    Slope (vertical to horizontal, ft/ft) along channel draining"},
  {21,8,"into the impoundment."},
  {22,8,"Range : .001 - 2.0"},
  {0, 0, NULL}
};

struct screen drawm[] = {
  {20,0,"DRAW    Slope (vertical to horizontal, m/m) along channel draining"},
  {21,8,"into the impoundment."},
  {22,8,"Range : .001 - 2.0"},
  {0, 0, NULL}
};

struct screen sidee[] = {
  {20,0,"SIDE    Side slope (vertical to horizontal, ft/ft) of land at impoundment"},
  {21,8,"toward DRAW."},
  {22,8,"Range : .001 - 2.0"},
  {0, 0, NULL}
};

struct screen sidem[] = {
  {20,0,"SIDE    Side slope (vertical to horizontal, m/m) of land at impoundment"},
  {21,8,"toward DRAW."},
  {22,8,"Range : .001 - 2.0"},
  {0, 0, NULL}
};

struct screen diaoe[] = {
  {20,0,"DIAO    Diameter (in) of pipe orifice."},
  {21,8,"Needed only if CTL = 1."},
  {22,8,"Range : .01 - 10"},
  {0, 0, NULL}
};

struct screen diaom[] = {
  {20,0,"DIAO    Diameter (cm) of pipe orifice."},
  {21,8,"Needed only if CTL = 1."},
  {22,8,"Range : .02 - 25.4"},
  {0, 0, NULL}
};

struct screen c[] = {
  {20,0,"C       Orifice coefficient."},
  {21,8,"Needed only if CTL = 2."},
  {22,8,"Range : .01 - 100000"},
  {0, 0, NULL}
};

struct screen nyears[] = {
  {20,0,"NYEARS  Number of years in this rotation."},
  {21,8,"Range : 1 - 50"},
  {0, 0, NULL}
};

struct screen cdate[] = {
  {20,0,"CDATE   The days (Julian) on which sets of parameters take effect."},
  {21,8,"Maximum number of CDATES is 40."},
  {22,8,"Range :   1 - 366                       "},
  {24,20,"year =      Available CDATES =   "}
};

struct screen nxf[] = {
  {20,0,"NXF     Number of overland flow profile segments differentiated by"},
  {21,8,"changes in the overland flow updatable parameters."},
  {22,8,"Range : 1 - 4"},
  {0, 0, NULL}
};

struct screen xfact[] = {
  {20,0,"XFACT   Relative horizontal distance (ratio of distance over total"},
  {21,8,"distance -- SLNGTH, Card 8) from top of overland flow profile to the"},
  {22,8,"bottom of segment."},
  {23,8,"Range : .01 - 1.0"},
  {0, 0, NULL}
};

struct screen cfact[] = {
  {20,0,"CFACT   Soil loss ratio for overland flow profile segment just"},
  {21,8,"above XFACT."},
  {22,8,"Range : .01 - 1.0"},
  {24,13,            "F2 = Copy  year =    seg =    cdate =    "}
};

struct screen pfact[] = {
  {20,0,"PFACT   Contouring factor for overland flow profile segment just"},
  {21,8,"above XFACT."},
  {22,8,"Range : .01 - 1.0"},
  {24,13,            "F2 = Copy  year =    seg =    cdate =    "}
};

struct screen nfact[] = {
  {20,0,"NFACT   Manning's \"n\"  for overland flow profile segment just"},
  {21,8,"above XFACT."},
  {22,8,"Range : .01  - .40"},
  {24,0," F1 = Help   F2 = Copy  year =    seg =    cdate =    "}
};

struct screen nxc[] = {
  {20,0,"NXC     Number of channel profile segments differentiated by changes"},
  {21,8,"in the channel parameters."},
  {22,8,"Range : 1 - 4"},
  {0, 0, NULL}
};

struct screen xchan[] = {
  {20,0,"XCHAN   Relative horizontal distance from top of channel to the bottom"},
  {21,8,"of the segment."},
  {22,8,"Range : .01 - 1.0"},
  {0, 0, NULL}
};

struct screen nchan[] = {
  {20,0,"NCHAN   Manning's \"n\" for channel profile segment just above XCHAN."},
  {21,8,"Range : .03  - .40   "},
  {24,0," F1 = Help   F2 = Copy  year =    seg =    cdate =    "}
};

struct screen dchane[] = {
  {20,0,"DCHAN   Depth (ft) to the nonerodible layer in the channel middle,"},
  {21,8,"for the channel profile segment just above XCHAN."},
  {22,8,"Range : -99.0  -  1.0  "},
  {24,13,            "F2 = Copy  year =    seg =    cdate =    "}
};

struct screen dchanm[] = {
  {20,0,"DCHAN   Depth (m) to the nonerodible layer in the channel middle,"},
  {21,8,"for the channel profile segment just above XCHAN."},
  {22,8,"Range : -99.0  -  0.3  "},
  {24,13,            "F2 = Copy  year =    seg =    cdate =    "}
};

struct screen wchane[] = {
  {20,0,"WCHAN   Top width (ft) of the channel for the channel profile segment"},
  {21,8,"just above XCHAN."},
  {22,8,"Range : -99.0  -  100.0 "},
  {24,13,            "F2 = Copy  year =    seg =    cdate =    "}
};

struct screen wchanm[] = {
  {20,0,"WCHAN   Top width (m) of the channel for the channel profile segment"},
  {21,8,"just above XCHAN."},
  {22,8,"Range : -99.0  -  30.5"},
  {24,13,            "F2 = Copy  year =    seg =    cdate =    "}
};


struct screen *english_list[19][10] = {
 {byear,  eyear,  eroout, flgseq, metflg, NULL,   NULL,  NULL,   NULL,  NULL},
 {sscly,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {nptso,  daovre, NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {xov_e,  slov_e, xov_e,  slov_e, xov_e,  slov_e, xov_e, slov_e, xov_e, slov_e},
 {nxk,    xsoil,  ksoile, xsoil,  ksoile, xsoil,  ksoile,xsoil,  ksoile, NULL},
 {nsc,    ctlo,   ra,     rn,     dachle, dachue, ze,    NULL,   NULL,  NULL},
 {xslpie, sslpie, xslpie, sslpie, xslpie, sslpie, xslpie,sslpie, xslpie,sslpie},
 {ctlz,   ctln,   ctlsle, NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {dapnde, intakee,fronte, drawe,  sidee,  ctl,    diaoe,  c,     NULL,  NULL},
 {nyears, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {cdate,  cdate,  cdate,  cdate,  cdate,  cdate,  cdate, cdate,  cdate, cdate},
 {nxf,    xfact,  xfact,  xfact,  xfact,  NULL,   NULL,  NULL,   NULL,  NULL},
 {cfact,  cfact,  cfact,  cfact,  cfact,  cfact,  cfact, cfact,  cfact, cfact},
 {pfact,  pfact,  pfact,  pfact,  pfact,  pfact,  pfact, pfact,  pfact, pfact},
 {nfact,  nfact,  nfact,  nfact,  nfact,  nfact,  nfact, nfact,  nfact, nfact},
 {nxc,    xchan,  xchan,  xchan,  xchan,  NULL,   NULL,  NULL,   NULL,  NULL},
 {nchan,  nchan,  nchan,  nchan,  nchan,  nchan,  nchan, nchan,  nchan, nchan},
 {dchane, dchane, dchane, dchane, dchane, dchane, dchane,dchane, dchane,dchane},
 {wchane, wchane, wchane, wchane, wchane, wchane, wchane,wchane, wchane,wchane}
};


struct screen *metric_list[19][10] = {
 {byear,  eyear,  eroout, flgseq, metflg, NULL,   NULL,  NULL,   NULL,  NULL},
 {sscly,  NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {nptso,  daovrm, NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {xov_m,  slov_m, xov_m,  slov_m, xov_m,  slov_m, xov_m, slov_m, xov_m, slov_m},
 {nxk,    xsoil,  ksoilm, xsoil,  ksoilm, xsoil,  ksoilm,xsoil,  ksoilm, NULL},
 {nsc,    ctlo,   ra,     rn,     dachlm, dachum, zm,    NULL,   NULL,  NULL},
 {xslpim, sslpim, xslpim, sslpim, xslpim, sslpim, xslpim,sslpim, xslpim,sslpim},
 {ctlz,   ctln,   ctlslm, NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {dapndm, intakem,frontm, drawm,  sidem,  ctl,    diaom, c,      NULL,  NULL},
 {nyears, NULL,   NULL,   NULL,   NULL,   NULL,   NULL,  NULL,   NULL,  NULL},
 {cdate,  cdate,  cdate,  cdate,  cdate,  cdate,  cdate, cdate,  cdate, cdate},
 {nxf,    xfact,  xfact,  xfact,  xfact,  NULL,   NULL,  NULL,   NULL,  NULL},
 {cfact,  cfact,  cfact,  cfact,  cfact,  cfact,  cfact, cfact,  cfact, cfact},
 {pfact,  pfact,  pfact,  pfact,  pfact,  pfact,  pfact, pfact,  pfact, pfact},
 {nfact,  nfact,  nfact,  nfact,  nfact,  nfact,  nfact, nfact,  nfact, nfact},
 {nxc,    xchan,  xchan,  xchan,  xchan,  NULL,   NULL,  NULL,   NULL,  NULL},
 {nchan,  nchan,  nchan,  nchan,  nchan,  nchan,  nchan, nchan,  nchan, nchan},
 {dchanm, dchanm, dchanm, dchanm, dchanm, dchanm, dchanm,dchanm, dchanm,dchanm},
 {wchanm, wchanm, wchanm, wchanm, wchanm, wchanm, wchanm,wchanm, wchanm,wchanm}
};
