#define ENGLISH  0
#define METRIC   1

typedef struct {
   int  beg_vrow;
   int  max_rows;
   int  d_col;
   int  d_row;
   int  offset;
   int  v_row;
   int  r_row;
   int  field;
   int  view;
} WINDOW_CONTROL;


typedef struct ero_node {
   char   line[82];
   float  num[10];
   char   apd[10];
   int    type;
   struct ero_node *n;
   struct ero_node *p;
} EROSION;


typedef struct {
   char *val[3];
} CARD6_INFO;


typedef struct {
   float num[3];
} CARD9_INFO;


typedef struct {
   char *val[2];
} CARD11_INFO;


struct screen mozart_heading[] = {
   {1, 3, "Wolfgang Amedeaus Mozart, 1756 - 1791."},
   {2, 5, "World's Greatest Composer - Ever!"},
   {0, 0, NULL}
};

struct screen flgout_head[] = {
   {1, 15, "Erosion output options"},
   {2, 0, "Ĵ"},
   {0, 0, NULL}
};

TABLE_TYPE flgout_tbl[] = {
   {"0  abbreviated annual summary output.", "0"},
   {"1  detailed annual summary output.", "1"},
   {"2  abbreviated monthly and annual output.", "2"},
   {"3  detailed monthly and annual output.", "3"},
   {"4  abbreviated storm-by-storm and summary output.", "4"},
   {"5  detailed storm-by-storm and summary output.", "5"},
};


struct screen flgseq_head[] = {
   {1, 9, "Execution sequence options"},
   {2, 0, "Ĵ"},
   {0, 0, NULL}
};

TABLE_TYPE flgseq_tbl[] = {
   {"1  overland.", "1"},
   {"2  overland-impoundment.", "2"},
   {"3  overland-channel.", "3"},
   {"4  overland-channel-channel.", "4"},
   {"5  overland-channel-impoundment.", "5"},
   {"6  overland-channel-channel-impoundment.", "6"}
};


struct screen ctlo_head[] = {
  {1, 8, "Condition                                 Control                  Code"},
 {2, 0, "Ĵ"},
 {0, 0, NULL}
};

TEXT_TYPE ctlo_tbl[] = {
   {"For terrace, diversion, or other    Critical depth controls flow at the",
    "channel when depth of flow in       end of the field channel.",
    "outlet channel has no restrict-",
    "ing effect.",
    "",
    "1", "1"},
   {"For a channel with a reach at the   Uniform flow controls depth at the",
    "lower end that sets the depth of    end of the field channel.",
    "flow, i. e. heavy vegetation at",
    "outlet.",
    "",
    "2", "2"},
   {"The model will choose the greater   Same as 2, except Manning's \"n\" for",
    "of (1) or (2).                      the outlet channel is the same as",
    "Note the distinction of \"field\"     that for the lower segment of the",
    "and \"outlet\" channel.               field channel.",
    "",
    "3", "3"},
   {"A control structure such as a       A rating curve controls flow depth",
    "weir, flume, or culvert controls    at the end of the field channel with",
    "flow depth according to a known     critical discharge computed by:",
    "rating curve.                                   RN",
    "                                      Q = RA x Y",
    "4", "4"},
};


struct screen ra_head[] = {
   {1, 2, "Coefficients and exponents for weir flow"},
   {2, 2, "   in channel equations"},
   {3, 0, "Ĵ"},
   {4, 5, "Weir type                     RA       RN"},
   {5, 0, "Ĵ"},
   {0, 0, NULL}
};

TABLE_TYPE ra_tbl[] = {
   {"Rectangular, 1' crest           3.33      1.5", ""},
   {"Rectangular, 2' crest           6.67      1.5", ""},
   {"Rectangular, 3' crest          10.0       1.5", ""},
   {"Rectangular, 4' crest          13.33      1.5", ""},
   {"Cipoletti, 1' crest             3.37      1.5", ""},
   {"Cipoletti, 2' crest             6.73      1.5", ""},
   {"Cipoletti, 3' crest            10.1       1.5", ""},
   {"Cipoletti, 4' crest            13.5       1.5", ""},
   {"V-Notch 22.5 degree (1:5)       0.5       2.5", ""},
   {"V-Notch 45   degree (1:2.6)     1.035     2.5", ""},
   {"V-Notch 60   degree (1:2)       1.443     2.5", ""},
   {"V-Notch 90   degree (1:1)       2.5       2.5", ""},
   {"V-Notch 2:1  side slopes        5.0       2.5", ""},
   {"V-Notch 3:1  side slopes        7.5       2.5", ""},
   {"V-Notch 5:1  side slopes       12.5       2.5", ""},
   {"V-Notch 10:1 side slopes       25.0       2.5", ""}
};

CARD11_INFO c9_info[] = {
   {"3.33",  "1.5"},
   {"6.67",  "1.5"},
   {"10.0",  "1.5"},
   {"13.33", "1.5"},
   {"3.37",  "1.5"},
   {"6.73",  "1.5"},
   {"10.1",  "1.5"},
   {"13.5",  "1.5"},
   {"0.5",   "2.5"},
   {"1.035", "2.5"},
   {"1.443", "2.5"},
   {"2.5",   "2.5"},
   {"5.0",   "2.5"},
   {"7.5",   "2.5"},
   {"12.5",  "2.5"},
   {"25.0",  "2.5"}
};


struct screen over_head[] = {
   {1, 9, "Mannings's \"n\" for overland flow"},
   {2, 0, "Ĵ"},
   {3, 4, "Surface Condition                                            n"},
   {4, 0, "Ĵ"},
                                       {5, 37, ""},
                                       {6, 37, ""},
                                       {7, 37, ""},
                                       {8, 37, ""},
                                       {9, 37, ""},
                                      {10, 37, ""},
                                      {11, 37, ""},
                                      {12, 37, ""},
                                      {13, 37, ""},
                                      {14, 37, ""},
                                      {15, 37, ""},
   {16, 0,"Ĵ"},
   {17, 0,"   F1 = Surface Condition     F2 =  \"n\"      Up/Down = Select       "},
   {18, 0,"   ESC = Exit no value      Return = Return from help with value    "},
   {19, 0,""},
   {0, 0, NULL}
};


TEXT_TYPE over_tbl[] = {
   {"",
    "  Applied to fallow surface",
    "",
    "",
    "",
    "Cornstalk Residue", ""},
   {"",
    "  Disk-harrow incorporated",
    "",
    "",
    "",
    "Cornstalk Residue", ""},
   {"",
    "  Across slope",
    "",
    "",
    "",
    "Small grain (20% to maturity)", ""},
   {"",
    "  Up and Down slope",
    "",
    "",
    "",
    "Small grain (20% to maturity)", ""},
   {"",
    "",
    "",
    "",
    "",
    "Rough surface depressions", ""},
   {"",
    "",
    "",
    "",
    "",
    "Wheat straw mulch", ""},
   {"",
    "",
    "",
    "",
    "",
    "Crushed stone mulch", ""},
   {"",
    "",
    "",
    "",
    "",
    "Grass", ""},
   {"",
    "  roughness elements",
    "",
    "",
    "",
    "Smooth, bare soil;", ""},
   {"",
    "  residue stays in place",
    "  and is not washed away)",
    "",
    "",
    "Corn stalks (assume", ""},
   {"",
    "  residue stays in place",
    "  and is not washed away)",
    "",
    "",
    "Wheat straw (assume", ""},
   {"",
    "  is erect and that flow",
    "  depth does not exceed",
    "  height of grass)",
    "",
    "Grass (assumes that grass", ""},
   {"",
    "  Rows with flow",
    "",
    "",
    "",
    "Small grain (20% to maturity)", ""},
   {"",
    "  Rows across flow",
    "",
    "",
    "",
    "Small grain (20% to maturity)", ""},
   {"",
    "",
    "",
    "",
    "",
    "Sorghum and cotton", ""},
   {"",
    "",
    "",
    "",
    "",
    "Sudangrass", ""},
   {"",
    "",
    "",
    "",
    "",
    "Lespedeza", ""},
   {"",
    "",
    "",
    "",
    "",
    "Lovegrass", ""}
};


TABLE_TYPE cornfallow_tbl[] = {
   {"1 ton/acre              0.020", "0.020"},
   {"2 ton/acre              0.040", "0.040"},
   {"4 ton/acre              0.070", "0.070"}
};

TABLE_TYPE cornfallowm_tbl[] = {
   {"2.25 t/ha               0.020", "0.020"},
   {"4.5  t/ha               0.040", "0.040"},
   {"9    t/ha               0.070", "0.070"}
};


TABLE_TYPE cornharrow_tbl[] = {
   {"1 ton/acre              0.012", "0.012"},
   {"2 ton/acre              0.020", "0.020"},
   {"4 ton/acre              0.023", "0.023"}
};

TABLE_TYPE cornharrowm_tbl[] = {
   {"2.25 t/ha               0.012", "0.012"},
   {"4.5  t/ha               0.020", "0.020"},
   {"9    t/ha               0.023", "0.023"}
};


TABLE_TYPE smallgrain_across_tbl[] = {
   {"Poor stand              0.018", "0.018"},
   {"Moderate stand          0.023", "0.023"},
   {"Good stand              0.032", "0.032"},
   {"Dense stand             0.046", "0.046"}
};


TABLE_TYPE smallgrain_down_tbl[] = {
   {"Poor stand              0.012", "0.012"},
   {"Moderate stand          0.015", "0.015"},
   {"Good stand              0.023", "0.023"},
   {"Dense stand             0.032", "0.032"}
};


TABLE_TYPE depresion_tbl[] = {
   {"4 to 5 inches deep      0.046", "0.046"},
   {"2 to 4 inches deep      0.023", "0.023"},
   {"1 to 2 inches deep      0.014", "0.014"},
   {"No surface depressions  0.010", "0.010"}
};

TABLE_TYPE depresionm_tbl[] = {
   {"10.16 to 12.7  cm deep  0.046", "0.046"},
   {"5.08  to 10.16 cm deep  0.023", "0.023"},
   {"2.54  to 5.08  cm deep  0.014", "0.014"},
   {"No surface depressions  0.010", "0.010"}
};


TABLE_TYPE wheatmulch_tbl[] = {
   {"0.25 ton/acre           0.015", "0.015"},
   {"0.5  ton/acre           0.018", "0.018"},
   {"1    ton/acre           0.032", "0.032"},
   {"2    ton/acre           0.070", "0.070"},
   {"4    ton/acre           0.074", "0.074"}
};

TABLE_TYPE wheatmulchm_tbl[] = {
   {"0.56  t/ha              0.015", "0.015"},
   {"1.125 t/ha              0.018", "0.018"},
   {"2.25  t/ha              0.032", "0.032"},
   {"4.5   t/ha              0.070", "0.070"},
   {"9     t/ha              0.074", "0.074"}
};


TABLE_TYPE crushedmulch_tbl[] = {
   {"15  ton/acre            0.012", "0.012"},
   {"60  ton/acre            0.023", "0.023"},
   {"135 ton/acre            0.046", "0.046"},
   {"240 ton/acre            0.074", "0.074"},
   {"375 ton/acre            0.074", "0.074"}
};

TABLE_TYPE crushedmulchm_tbl[] = {
   {"33.75  t/ha             0.012", "0.012"},
   {"135    t/ha             0.023", "0.023"},
   {"303.75 t/ha             0.046", "0.046"},
   {"540    t/ha             0.074", "0.074"},
   {"843.75 t/ha             0.074", "0.074"}
};


TABLE_TYPE grass_tbl[] = {
   {"Sparse                  0.015", "0.015"},
   {"Poor                    0.023", "0.023"},
   {"Fair                    0.032", "0.032"},
   {"Good                    0.046", "0.046"},
   {"Exellent                0.074", "0.074"},
   {"Dense                   0.150", "0.150"},
   {"Very dense              0.400", "0.400"}
};

int over_cnt[8] = {3, 3, 4, 4, 4, 5, 5, 7};

TABLE_TYPE *over_ary[8] = {
    cornfallow_tbl, cornharrow_tbl, smallgrain_across_tbl, smallgrain_down_tbl,
    depresion_tbl, wheatmulch_tbl, crushedmulch_tbl, grass_tbl};

TABLE_TYPE *overm_ary[8] = {
    cornfallowm_tbl, cornharrowm_tbl, smallgrain_across_tbl, smallgrain_down_tbl,
    depresionm_tbl, wheatmulchm_tbl, crushedmulchm_tbl, grass_tbl};


struct screen chan_head[] = {
   {1, 9, "Mannings's \"n\" for channel flow"},
   {2, 0, "Ĵ"},
   {3, 4, "Surface Condition                  Cover density             n"},
   {4, 0, "Ĵ"},
                                       {5, 37, ""},
                                       {6, 37, ""},
                                       {7, 37, ""},
                                       {8, 37, ""},
                                       {9, 37, ""},
                                      {10, 37, ""},
                                      {11, 37, ""},
                                      {12, 37, ""},
                                      {13, 37, ""},
                                      {14, 37, ""},
                                      {15, 37, ""},
   {16, 0,"Ĵ"},
   {17, 0,"   F1 = Surface Condition     F2 =  \"n\"      Up/Down = Select       "},
   {18, 0,"   ESC = Exit no value      Return = Return from help with value    "},
   {19, 0,""},
   {0, 0, NULL}
};


TEXT_TYPE chan_tbl[] = {
   {"",
    "  roughness elements",
    "",
    "",
    "",
    "Smooth, bare soil;", ""},
   {"",
    "  (assumes residue stays in",
    "   place and is not washed",
    "   away)",
    "",
    "Corn stalks", ""},
   {"",
    "  (assumes residue stays in",
    "   place and is not washed",
    "   away)",
    "",
    "Wheat straw", ""},
   {"",
    "  (assumes that grass is erect",
    "   and that flow depth does not",
    "   exceed height of grass)",
    "",
    "Grass", ""},
   {"",
    "  Rows with flow",
    "",
    "",
    "",
    "Small grain (20% to maturity)", ""},
   {"",
    "  Rows across flow",
    "",
    "",
    "",
    "Small grain (20% to maturity)", ""},
   {"",
    "",
    "",
    "",
    "",
    "Sorghum and cotton", ""},
   {"",
    "",
    "",
    "",
    "",
    "Sudangrass", ""},
   {"",
    "",
    "",
    "",
    "",
    "Lespedeza", ""},
   {"",
    "",
    "",
    "",
    "",
    "Lovegrass", ""}
};


TABLE_TYPE smoothbare_tbl[] = {
   {"Less than 1 in. deep    0.030", "0.030"},
   {"1-2 in. deep            0.033", "0.033"},
   {"2-4 in. deep            0.038", "0.038"},
   {"4-6 in. deep            0.045", "0.045"}
};

TABLE_TYPE smoothbarem_tbl[] = {
   {"Less than 2.54 cm deep  0.030", "0.030"},
   {"2.54 -5.08  cm deep     0.033", "0.033"},
   {"5.08 -10.16 cm deep     0.038", "0.038"},
   {"10.16-15.24 cm deep     0.045", "0.045"}
};


TABLE_TYPE cornstalks_tbl[] = {
   {"1   ton /acre           0.050", "0.050"},
   {"2   tons/acre           0.075", "0.075"},
   {"3   tons/acre           0.100", "0.100"},
   {"4   tons/acre           0.130", "0.130"}
};

TABLE_TYPE cornstalksm_tbl[] = {
   {"2.25 t/ha               0.050", "0.050"},
   {"4.5  t/ha               0.075", "0.075"},
   {"6.75 t/ha               0.100", "0.100"},
   {"9    t/ha               0.130", "0.130"}
};


TABLE_TYPE wheatstraw_tbl[] = {
   {"1   ton /acre           0.060", "0.060"},
   {"1.5 tons/acre           0.100", "0.100"},
   {"2   tons/acre           0.150", "0.150"},
   {"4   tons/acre           0.250", "0.250"}
};

TABLE_TYPE wheatstrawm_tbl[] = {
   {"2.25  t/ha              0.060", "0.060"},
   {"3.375 t/ha              0.100", "0.100"},
   {"4.5   t/ha              0.150", "0.150"},
   {"9     t/ha              0.250", "0.250"}
};


TABLE_TYPE grass_chan_tbl[] = {
   {"Sparse                  0.040", "0.040"},
   {"Poor                    0.050", "0.050"},
   {"Fair                    0.060", "0.060"},
   {"Good                    0.080", "0.080"},
   {"Excellent               0.130", "0.130"},
   {"Dense                   0.200", "0.200"},
   {"Very dense              0.300", "0.300"}
};


TABLE_TYPE smallgrainwith_chan_tbl[] = {
   {"Poor,  7-in. rows       0.130", "0.130"},
   {"Poor, 14-in. rows       0.130", "0.130"},
   {"Good,  7-in. rows       0.300", "0.300"},
   {"Good, 14-in. rows       0.200", "0.200"}
};

TABLE_TYPE smallgrainwithm_chan_tbl[] = {
   {"Poor, 17.75-cm rows     0.130", "0.130"},
   {"Poor, 35.5 -cm rows     0.130", "0.130"},
   {"Good, 17.75-cm rows     0.300", "0.300"},
   {"Good, 35.5 -cm rows     0.200", "0.200"}
};


TABLE_TYPE smallgrainacross_chan_tbl[] = {
   {"Good                    0.300", "0.300"}
};


TABLE_TYPE sorghumcotton_chan_tbl[] = {
   {"Poor                    0.070", "0.070"},
   {"Good                    0.090", "0.090"}
};

TABLE_TYPE sudangrass_chan_tbl[] = {
   {"Good                    0.200", "0.200"}
};

TABLE_TYPE lespedeza_chan_tbl[] = {
   {"Good                    0.100", "0.100"}
};

TABLE_TYPE lovegrass_chan_tbl[] = {
   {"Good                    0.150", "0.150"}
};



int chan_cnt[10] = {4, 4, 4, 7, 4, 1, 2, 1, 1, 1};

TABLE_TYPE *chan_ary[10] = {
    smoothbare_tbl, cornstalks_tbl, wheatstraw_tbl, grass_chan_tbl,
    smallgrainwith_chan_tbl, smallgrainacross_chan_tbl, sorghumcotton_chan_tbl,
    sudangrass_chan_tbl, lespedeza_chan_tbl, lovegrass_chan_tbl};

TABLE_TYPE *chanm_ary[10] = {
    smoothbarem_tbl, cornstalksm_tbl, wheatstrawm_tbl, grass_chan_tbl,
    smallgrainwithm_chan_tbl, smallgrainacross_chan_tbl, sorghumcotton_chan_tbl,
    sudangrass_chan_tbl, lespedeza_chan_tbl, lovegrass_chan_tbl};

