#define MAXNAME 8
#define MAXEXT  3
#define MAXLINE 256
#define MAXPATH 64

#define N_FILES 256
#define FILE_ROW 17


struct OUTBUF {
   char      *fname;
};

/* constants for DOS file-matching routines */
#define FILESPEC        13      /* maximum filespec + NUL */
#define RNBYTES         21      /* bytes reserved for next_fm() calls */

/* file modes (attributes) */
#define READONLY        0x0001
#define HIDDEN          0x0002
#define SYSTEM          0x0004
#define VOLUME          0x0008
#define SUBDIR          0x0010
#define ARCHIVE         0x0020

/* structure definition for DOS file-matching routines */
struct DTA {
        unsigned char reserved[RNBYTES];      /* buffer for next_fm */
        unsigned char attr;           /* file attribute (type) byte */
        unsigned time;               /* time of last modification */
        unsigned date;               /* date of last modification */
        long fsize;                   /* file size in bytes */
        char fname[FILESPEC];         /* file spec (filename.ext + NUL) */
};
