#include <conio.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "screen.h"
#include "extkeys.h"
#include "hydfunc.h"
#include "h4.h"


extern struct vcfg cfg;
extern struct file_position pos;
extern struct screen *(*foot_list)[32][10];
extern struct limit_type (*limits)[32];

extern int units;


void get_card4_33( HYDROLOGY **tmp, WINDOW_CONTROL *wc, int *c )
{
int cntinue, ftype, wid, append, row, col, cell_r;
double high, low, x;
char t[82], s[20];
int min_fields, max_fields;
HYDROLOGY *a;

                /*  can't see some cards if VRIGHT */
   if (wc->view == VRIGHT) {
      if ((*tmp)->type == 29) {
         if ((*tmp)->n->type != 30) {
            if (*c == PGUP)
               *c = UP;
            else if (*c == PGDN)
               *c = DOWN;
            return;
         }
      }
   }
   if ((*tmp)->type > 7 && (*tmp)->type < 18) {
      for (a=*tmp; a->type != 7; a=a->p);
      if (a->apd[1] == FALSE) {
         if (*c == PGUP)
            *c = UP;
         return;
      }
      if (wc->view == VRIGHT && a->apd[0] == TRUE && a->num[0] == (float)1.0) {
         if (*c == PGUP)
            *c = UP;
         return;
      }
   }
/*
   if ((*tmp)->type == 30) {
      if (wc->field == 0 || wc->field == 1) {
         for (a=(*tmp); a->type != 4; a=a->p);
         if (a->num[2] == 0)
            wc->field = 2;
      }
   }
*/
   change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
   cell_r = (*tmp)->type - 4;                  /* make cell_r start at 0 */
   row = wc->v_row + wc->d_row;
   cntinue = TRUE;
   while (cntinue) {
      change_field_info_structs( *tmp, wc, &max_fields );
      show_footer( (*foot_list)[cell_r][wc->field], *wc );
      wid = (*limits)[cell_r].width[wc->field];
      low = (*limits)[cell_r].range[wc->field].lo;
      high = (*limits)[cell_r].range[wc->field].hi;
      ftype = (*limits)[cell_r].field_type[wc->field];
      memset( s, ' ', wid );
      s[wid] = '\0';

        /*  to find the column for a given field
         *  1. start with display column
         *  2. add 8 times field number  - gives the starting column of field
         +  3. add 8 - field width   - adds offset to right justify
         *  4. subtract 8 times wc->view   --  view left and right columns
        */
      col = wc->d_col + wc->field * 8 + 8 - wid - 8 * wc->view;
      pos.f_col = wc->field * 8 + 8 - wid + 1;
      append = (*tmp)->apd[wc->field];
      if (append) {
         setup_field( *tmp, wc->field, wid, t );
         if ((*tmp)->num[wc->field] > (float)high) {
            (*limits)[cell_r].range[wc->field].hi = (*tmp)->num[wc->field];
            high = (*tmp)->num[wc->field];
         } else if ((*tmp)->num[wc->field] < (float)low) {
            (*limits)[cell_r].range[wc->field].lo = (*tmp)->num[wc->field];
            low = (*tmp)->num[wc->field];
         }
      }
      field_editor( t, ftype, wid, row, col, append, c, cfg.hi_i, pos );
      while (*t!='\0' && range_not_ok( t, low, high ) && *c != ALT_F1)
         field_editor( t, ftype, wid, row, col, FALSE, c, cfg.hi_i, pos );
      if (*c == F1) {
         get_hyd_help( tmp, wc, t, c );
         row = wc->v_row + wc->d_row;
      } else if (*c == F2 || *c == F3) {
         if ((*tmp)->type == 29) {
            add_remove_c29( tmp, wc, c );
            change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
            get_string_field_value( *tmp, t, wc->field );
            col = wc->d_col + wc->field * 8 + 8 - wid - 8 * wc->view;
            if ((*tmp)->n->type != 30) {
               if (wc->view == VRIGHT) {
                  *c = UP;
                  return;
               }
            }
         }
      } else if (*c == ALT_F1 && *t != '\0') {
         x = atof( t );
         if (x < low)
            (*limits)[cell_r].range[wc->field].lo = x;
         else if (x > high)
            (*limits)[cell_r].range[wc->field].hi = x;
      }

           /* ************* IMPORTANT ************ IMPORTANT ********** */
           /* let card  7 contain old NOSOHZ in field 7                 */
           /* let card  8 - 10 contain the soil type                    */
           /*           selected from the help table in                 */
           /*           field + 5 (over 20 soil types)                  */
           /* let card 28 contain old number of years to run in field 4 */
           /* let card 28 contain old IROT in field 5                   */
           /* let card 31 contain old NOLAI in field 2                  */
           /* let card 33 contain old codes in field + 4                */
           /* ************* IMPORTANT ************ IMPORTANT ********** */


      if (*t != '\0') {
         fast_write( col, row, s, NORMAL );
         fast_write( col+wid-strlen( t ), row, t, NORMAL );
         set_field_value( *tmp, t, wc->field, TRUE );
      } else
         set_field_value( *tmp, " ", wc->field, FALSE );

      if ((*tmp)->type == 4 && wc->field == 0 && *t != '\0')
         check_card4_hbdate( *tmp, wc, c, t );
/*      if ((*tmp)->type == 4 && wc->field == 2)
         check_card4_iropt( *tmp, wc ); */
/*      if ((*tmp)->type == 4 && wc->field == 3)
         check_card4_nut( *tmp, wc );  */
      if ((*tmp)->type == 4 && wc->field == 6)
         check_card4_units( *tmp );
      if ((*tmp)->type == 4 && wc->field == 9)
         check_card4_forest( *tmp );
      if ((*tmp)->type == 4 && wc->field == 8)
         check_card5( tmp, wc );
/*      if ((*tmp)->type == 4 && wc->field == 9)
         check_beg_endgro( *tmp, wc ); */
      if ((*tmp)->type == 6 && wc->field == 7 && *t != '\0')
         check_card6_rd( *tmp, wc, t );
      if ((*tmp)->type == 6 && wc->field == 4)
         check_card6_cn2( *tmp, wc );
      if ((*tmp)->type == 7)
         check_card7( *tmp, wc, c, &max_fields, t );
      if ((*tmp)->type == 28)
         check_card28( *tmp, wc );
      if ((*tmp)->type == 29 && wc->field == 0 && *t != '\0')
         check_card29_userlai( *tmp, wc );
      if ((*tmp)->type == 29  &&  wc->field > 0  &&  *t != '\0')
         check_card30_dates( *tmp, wc, c, t );
      if ((*tmp)->type == 30  &&  wc->field > 0 && wc->field < 4  &&  *t != '\0')
         check_card30_dates( *tmp, wc, c, t );
      if ((*tmp)->type == 31 && wc->field == 1)
         check_card31_nolai( *tmp, wc );
      if ((*tmp)->type == 33)
         check_card33( *tmp, wc, c, t );
      if ((*tmp)->type == 34)
         check_card34( *tmp, wc, c, t );

      switch (*c) {
         case UP    :
         case DOWN  :
         case PGDN  :
         case PGUP  :
         case ALTF  :
         case ALTD  :
         case ALTU  :
         case ALTC  :
         case ALTS  :
         case ALTH  :
         case ALTX  :
            cntinue = FALSE;
            break;
         case CNTL_LEFT :
         case SHIFT_TAB :
            if (wc->view == VLEFT) {
               if (wc->field == min_fields)
                  wc->field = max_fields;
               else
                  --wc->field;
            } else if (wc->view == VRIGHT) {
               if (wc->field == min_fields) {
                  wc->view = VLEFT;
                  change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
                  wc->field = min_fields;
                  view_lft_rgt( *tmp, wc );
               } else
                  --wc->field;
            }
/*
            if ((*tmp)->type == 30) {
               if (wc->field == 0 || wc->field == 1) {
                  for (a=(*tmp); a->type != 4; a=a->p);
                  if (a->num[2] == 0)
                     wc->field = 3;
               }
            }
*/
            break;
         case CNTL_RGHT :
         case RTURN     :
         case TAB       :
         case ALT_F1    :
            if (wc->view == VLEFT) {
               if (wc->field == max_fields) {
                  if (max_fields >= 8) {
                     wc->view = VRIGHT;
                     change_min_max_limits( *tmp, wc, &min_fields, &max_fields);
                     if (max_fields > 8) {
                        wc->field = max_fields;
                        view_lft_rgt( *tmp, wc );
                     } else {
                        if (*c == RTURN)
                           cntinue = FALSE;
                        wc->view = VLEFT;
                        change_min_max_limits( *tmp, wc, &min_fields, &max_fields);
                        wc->field = min_fields;
                     }
                  } else {
                     wc->field = min_fields;
                     if (*c == RTURN)
                        cntinue = FALSE;
                  }
               } else
                  ++wc->field;
            } else if (wc->view == VRIGHT) {
               if (wc->field == max_fields) {
                  if (*c == RTURN)
                     cntinue = FALSE;
                  wc->view = VLEFT;
                  change_min_max_limits( *tmp, wc, &min_fields, &max_fields );
                  view_lft_rgt( *tmp, wc );
                  wc->field = min_fields;
               } else
                  ++wc->field;
            }
/*
            if ((*tmp)->type == 30) {
               if (*c == RTURN && wc->field == min_fields)
                  wc->field = 0;
               else if (wc->field == 0 || wc->field == 1) {
                  for (a=(*tmp); a->type != 4; a=a->p);
                  if (a->num[2] == 0)
                     wc->field = 2;
               }
            }
*/
            break;
      }
   }
}


void setup_field( HYDROLOGY *tmp, int field, int wid, char *t )
{
int i, j, k;

   for (i=0,j=field*8+8-wid, k=0; i<wid; i++) {
      if (tmp->line[j+i] != ' ') {
         t[k]=tmp->line[j+i];
         k++;
      }
   }
   t[k] = '\0';
}


void change_min_max_limits( HYDROLOGY *tmp, WINDOW_CONTROL *wc,
                            int *min_fields, int *max_fields )
{
HYDROLOGY *a;
int cell_r;

   cell_r = tmp->type - 4;
   *max_fields = (*limits)[cell_r].max_cells;
   *min_fields = wc->view;
   if (wc->field > *max_fields)
      wc->field = *max_fields;
   switch (tmp->type) {
      case 6 :
/*
         for (a=tmp; a->type != 4; a=a->p);
         if (a->apd[2] == TRUE && a->num[2] == 1.0)
            *max_fields = (*limits)[cell_r].max_cells;
         else
            *max_fields = (*limits)[cell_r].max_cells - 2;
*/
         break;
      case 7 :
         if (tmp->apd[1] == FALSE)
            *max_fields = 1;
         else
            *max_fields = (int)tmp->num[1] + 1;
         break;
      case 8  :
      case 9  :
      case 10 :
      case 11 :
      case 12 :
      case 13 :
      case 14 :
      case 15 :
      case 16 :
      case 17 :
         for (a=tmp; a->type != 7; a=a->p);
         if (a->apd[1] == FALSE)
            *max_fields = 0;
         else
            *max_fields = (int)a->num[1] - 1;
         if (wc->field > *max_fields)
            wc->field = *max_fields;
         break;
      case 29 :
         if (tmp->n->type != 30)
            *max_fields = 0;
         else
            *max_fields = 8;
         break;
   }
   if (wc->view == VLEFT && *max_fields > 8)
      *max_fields = 8;
   if (wc->field > *max_fields)
      wc->field = *max_fields;
   else if (wc->field < *min_fields)
      wc->field = *min_fields;
}


void change_field_info_structs( HYDROLOGY *tmp, WINDOW_CONTROL *wc,
                                int *max_fields )
{
HYDROLOGY *a;
int i, j, cell_r, foot_row, foot_col, found;
char t[82], s[20];
double x, y, prev_date, next_date;
float t_hi, t_lo;

   cell_r = tmp->type - 4;
   switch (tmp->type) {
      case 7  :
         if (wc->field > 1) {
            a = tmp->p;
            if (units == ENGLISH ) {
               t_hi = (float)60.0;
               t_lo = (float)1.0;
            } else {
               t_hi = (float)152.4;
               t_lo = (float)2.54;
            }
            if (a->apd[7] == TRUE)
               t_hi = a->num[7];
            for (i=wc->field-1,j=FALSE; i > 1 && j == FALSE; i--) {
               if (tmp->apd[i] == TRUE) {
                  t_lo = tmp->num[i];
                  j = TRUE;
               }
            }
            for (i=wc->field+1,j=FALSE; i <= *max_fields && j == FALSE; i++) {
               if (tmp->apd[i] == TRUE) {
                  t_hi = tmp->num[i];
                  j = TRUE;
               }
            }
            (*limits)[cell_r].range[wc->field].hi = t_hi;
            (*limits)[cell_r].range[wc->field].lo = t_lo;
            if (wc->field == *max_fields)
               (*limits)[cell_r].range[wc->field].lo = t_hi;
         }
         blank_old_horz( tmp, wc );
         if (wc->field > 1)
            change_card7_footer( tmp, wc, cell_r, max_fields );
         break;
      case 8  :
         foot_row = 2;
         foot_col = 51;
         change_footer( " ", cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa( wc->field+1, t, 10 ), cell_r, wc->field,
                                                     foot_row, foot_col );
         /*
          * porosity cannot be less than fc or br15
          */
         x = .3;
         if (tmp->n->apd[wc->field] == TRUE)
            x = tmp->n->num[wc->field];
         else if (tmp->n->n->apd[wc->field] == TRUE)
            x = tmp->n->n->num[wc->field];
         if (x <= .3)
            x = .3;
         memset( t, ' ', 3 );
         t[3] = '\0';
         change_footer( t, cell_r, wc->field, 1, 9 );
         ftoa( (float)x, 2, t );
         change_footer( t, cell_r, wc->field, 1, 9 );
         if (x > .301)
            x = x + 0.001;
         (*limits)[cell_r].range[wc->field].lo = x;
         break;
      case 9  :
         foot_row = 2;
         foot_col = 51;
         change_footer( " ", cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa( wc->field+1, t, 10 ), cell_r, wc->field,
                                                     foot_row, foot_col );

         /*
          * fc cannot be greater than por
          */
         x = .45;
         if (tmp->p->apd[wc->field] == TRUE)
            x = tmp->p->num[wc->field];
         if (x > .45)
            x = .45;
         memset( t, ' ', 3 );
         t[3] = '\0';
         change_footer( t, cell_r, wc->field, 1, 16 );
         ftoa( (float)x, 2, t );
         change_footer( t, cell_r, wc->field, 1, 16 );
         if (x < .45)
            x = x - 0.001;
         (*limits)[cell_r].range[wc->field].hi = x;

         /*
          * fc cannot be less than br15
          */
         x = .1;
         if (tmp->n->apd[wc->field] == TRUE)
            x = tmp->n->num[wc->field];
         if (x <= .1)
            x = .1;
         memset( t, ' ', 3 );
         t[3] = '\0';
         change_footer( t, cell_r, wc->field, 1, 9 );
         ftoa( (float)x, 2, t );
         change_footer( t, cell_r, wc->field, 1, 9 );
         if (x > .1)
            x = x + 0.001;
         (*limits)[cell_r].range[wc->field].lo = x;

         break;
      case 10 :
         foot_row = 3;
         foot_col = 51;
         change_footer( " ", cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa( wc->field+1, t, 10 ), cell_r, wc->field,
                                                     foot_row, foot_col );

         /*
          * br15 cannot be greater than fc
          */
         x = .45;
         if (tmp->p->apd[wc->field] == TRUE)
            x = tmp->p->num[wc->field];
         if (x > .45)
            x = .45;
         memset( t, ' ', 3 );
         t[3] = '\0';
         change_footer( t, cell_r, wc->field, 2, 16 );
         ftoa( (float)x, 2, t );
         change_footer( t, cell_r, wc->field, 2, 16 );
         if (x < .45)
            x = x - 0.001;
         (*limits)[cell_r].range[wc->field].hi = x;

         break;
      case 11 :
      case 12 :
      case 13 :
      case 14 :
      case 15 :
      case 16 :
      case 17 :
         if (tmp->type == 11 || tmp->type == 13 || tmp->type == 14) {
            foot_row = 3;
            foot_col = 51;
         } else {
            foot_row = 2;
            foot_col = 10;
         }
         change_footer( " ", cell_r, wc->field, foot_row, foot_col );
         change_footer( itoa( wc->field+1, t, 10 ), cell_r, wc->field,
                                                     foot_row, foot_col );
         break;
      case 18 :
      case 19 :
      case 20 :
      case 21 :
         if (tmp->type == 18 || tmp->type == 19) {
            x = units == ENGLISH ? 0.0 : -20;
            a = tmp->n->n;
            if (a->apd[wc->field] == TRUE)
               x = a->num[wc->field];
            if (units == ENGLISH) {
               if (x < 0.0)
                  x = 0.0;
            } else {
               if (x < -20.0)
                  x = -20.0;
            }
            memset( t, ' ', 5 );
            t[5] = '\0';
            change_footer( t, cell_r, wc->field, 1, 8 );
            ftoa( (float)x, 1, t );
            for (i=strlen( t ); i<5; i++)
               insert( t, 0, ' ' );
            change_footer( t, cell_r, wc->field, 1, 8 );
            x = x - 0.001;
            (*limits)[cell_r].range[wc->field].lo = x;
         } else {
            x = units == ENGLISH ? 90.0 : 35;
            a = tmp->p->p;
            if (a->apd[wc->field] == TRUE)
               x = a->num[wc->field];
            memset( t, ' ', 5 );
            t[5] = '\0';
            change_footer( t, cell_r, wc->field, 1, 17 );
            ftoa( (float)x, 1, t );
            for (i=strlen( t ); i<5; i++)
               insert( t, 0, ' ' );
            change_footer( t, cell_r, wc->field, 1, 17 );
            x = x + 0.001;
            (*limits)[cell_r].range[wc->field].hi = x;
         }
      case 22 :
      case 23 :
      case 24 :
      case 25 :
      case 26 :
      case 27 :
         memset( t, ' ', 18 );
         t[18] = '\0';
         change_footer( t, cell_r, wc->field, 2, 0 );
         j = wc->field;
         if (tmp->type == 19 || tmp->type == 21 || tmp->type == 23 ||
                                tmp->type == 25 || tmp->type == 27)
            j += 10;
         strcpy( t, "Month = " );
         strcat( t, mon_names[j] );
         foot_col = 9 - strlen( mon_names[j] );
         change_footer( t, cell_r, wc->field, 2, foot_col );
         break;
      case 28 :
         if (wc->field == 0 || wc->field == 1) {
            x = 1582.0;
            y = 2100.0;
            if (wc->field == 0) {
               if (tmp->apd[1] == TRUE)
                  y = tmp->num[1];
            } else {
               if (tmp->apd[0] == TRUE)
                  x = tmp->num[0];
            }
            memset( s, ' ', 11 );
            s[11] = '\0';
            change_footer( s, cell_r, wc->field, 1, 8 );
            ltoa( (long)x, t, 10 );
            strcat( t, " - " );
            ltoa( (long)y, s, 10 );
            strcat( t, s );
            change_footer( t, cell_r, wc->field, 1, 8 );
            (*limits)[cell_r].range[wc->field].lo = x;
            (*limits)[cell_r].range[wc->field].hi = y;
         }
         break;
      case 29 :
         if (wc->field == 0) {
            if (tmp->n->type != 30) {
               change_footer( "0 - 0  ", cell_r, wc->field, 1, 8 );
               x = 0.0;
               y = 0.0;
            } else {
               change_footer( "1 - 90", cell_r, wc->field, 1, 8 );
               x = 1.0;
               y = 90.0;
            }
            (*limits)[cell_r].range[0].lo = x;
            (*limits)[cell_r].range[0].hi = y;
         }
         foot_col = 24;
         if (wc->field == 6)
            foot_row = 4;
         else if (wc->field == 7)
            foot_row = 3;
         else
            foot_row = 2;
         memset( s, ' ', 11 );
         s[11] = '\0';
         if (tmp->n->type != 30)
            change_footer( s, cell_r, wc->field, foot_row, foot_col );
         else
            change_footer( "F3 = Delete", cell_r, wc->field, foot_row,
                           foot_col );
         if (wc->field > 0  &&  tmp->n->type == 30) {
            for (a=tmp->p; a->type != 28; a=a->p);
            prev_date = 1.0;
            next_date = 50366.0;
            if (a->apd[2] == TRUE)
               next_date = a->num[2] * 1000.0 + 366;
            found = FALSE;
            for (a=tmp->p->p; a->type == 29  &&  !found; a=a->p->p) {
               for (i=3; i>0 && !found; i--) {
                  if (a->apd[i] == TRUE) {
                     prev_date = a->num[i] + 1;
                     found = TRUE;
                  }
               }
            }
            found = FALSE;
            for (a=tmp->n->n; a != NULL  && a->type == 29 &&
                              a->n->type == 30  &&  !found; a=a->n->n) {
               if (a->apd[1] == TRUE) {
                  next_date = a->num[1];
                  found = TRUE;
               }
               if (!found && a->apd[3] == TRUE) {
                  next_date = a->num[3];
                  found = TRUE;
               }
               if (!found && a->apd[2] == TRUE) {
                  next_date = a->num[2];
                  found = TRUE;
               }
            }
            switch (wc->field) {
               case 1 :
                  if (tmp->apd[2] == TRUE)
                     next_date = tmp->num[2];
                  break;
               case 2 :
                  if (tmp->apd[1] == TRUE)
                     prev_date = tmp->num[1];
                  if (prev_date < 1001.0)
                     prev_date = 1001.0;
                  if (!found)
                     next_date += 1000.0;
                  break;
               case 3 :
                  if (tmp->apd[1] == TRUE)
                     prev_date = tmp->num[1];
                  if (tmp->apd[2] == TRUE)
                     next_date = tmp->num[2];
                  else {
                     if (!found)
                        next_date += 1000.0;
                  }
                  break;
               case 7 :
                  j = 366;
                  if (tmp->apd[8] == TRUE)
                     j = (int)tmp->num[8];
                  memset( t, ' ', 3 );
                  t[3] = '\0';
                  change_footer( t, cell_r, wc->field, 2, 14 );
                  itoa( j, t, 10 );
                  for (i=strlen( t ); i<3; i++)
                     insert( t, 0, ' ');
                  change_footer( t, cell_r, wc->field, 2, 14 );
                  (*limits)[cell_r].range[wc->field].hi = j;
                  break;
               case 8 :
                  j = 1;
                  if (tmp->apd[7] == TRUE)
                     j = (int)tmp->num[7];
                  memset( t, ' ', 3 );
                  t[3] = '\0';
                  change_footer( t, cell_r, wc->field, 1, 8 );
                  itoa( j, t, 10 );
                  for (i=strlen( t ); i<3; i++)
                     insert( t, 0, ' ' );
                  change_footer( t, cell_r, wc->field, 1, 8 );
                  (*limits)[cell_r].range[wc->field].lo = j;
                  break;
            }
            if (wc->field < 4) {
               change_footer( "              ", cell_r, wc->field, 1, 8 );
               ltoa( (long)prev_date, t, 10 );
               strcat( t, " - " );
               ltoa( (long)next_date, s, 10 );
               strcat( t, s );
               change_footer( t, cell_r, wc->field, 1, 8 );
               (*limits)[cell_r].range[wc->field].lo = prev_date;
               (*limits)[cell_r].range[wc->field].hi = next_date;
            }
         }
         break;

      case 30 :
         if (wc->field > 0  &&  wc->field < 4) {
            for (a=tmp->p; a->type != 28; a=a->p);
            prev_date = 1.0;
            next_date = 50366.0;
            if (a->apd[2] == TRUE)
               next_date = a->num[2] * 1000.0 + 366;
            found = FALSE;
            for (a=tmp->p->p->p; a->type == 29  &&  !found; a=a->p->p) {
               for (i=4; i>1 && !found; i--) {
                  if (a->apd[i] == TRUE) {
                     prev_date = a->num[i] + 1;
                     found = TRUE;
                  }
               }
            }
            found = FALSE;
            for (a=tmp->n; a != NULL && a->n->type == 30 && !found; a=a->n->n) {
               if (a->apd[2] == TRUE) {
                  next_date = a->num[2];
                  found = TRUE;
               }
               if (!found && a->apd[3] == TRUE) {
                  next_date = a->num[3];
                  found = TRUE;
               }
               if (!found && a->apd[1] == TRUE) {
                  next_date = a->num[1];
                  found = TRUE;
               }
            }
            switch (wc->field) {
               case 1 :
                  if (tmp->p->apd[1] == TRUE)
                     prev_date = tmp->p->num[1];
                  if (tmp->apd[2] == TRUE)
                     next_date = tmp->num[2];
                  else if (tmp->p->apd[3] == TRUE)
                     next_date = tmp->p->num[3];
                  else if (tmp->p->apd[2] == TRUE)
                     next_date = tmp->p->num[2];
                  else
                     next_date += 1000.0;
                  break;
               case 2 :
                  if (tmp->apd[1] == TRUE)
                     prev_date = tmp->num[1];
                  else if (tmp->p->apd[1] == TRUE)
                     prev_date = tmp->p->num[1];
                  if (tmp->p->apd[3] == TRUE)
                     next_date = tmp->p->num[3];
                  else if (tmp->p->apd[2] == TRUE)
                     next_date = tmp->p->num[2];
                  else
                     next_date += 1000.0;
                  break;
               case 3 :
                  if (tmp->p->apd[1] == TRUE) {
                     prev_date = tmp->p->num[1] - 7.0;
                     next_date = tmp->p->num[1];
                  }
                  break;
            }
            change_footer( "              ", cell_r, wc->field, 2, 8 );
            ltoa( (long)prev_date, t, 10 );
            strcat( t, " - " );
            ltoa( (long)next_date, s, 10 );
            strcat( t, s );
            change_footer( t, cell_r, wc->field, 2, 8 );
            (*limits)[cell_r].range[wc->field].lo = prev_date;
            (*limits)[cell_r].range[wc->field].hi = next_date;
         }
         break;
      case 32 :
         if (wc->field == 0) {
            x = 0.0;
            y = 1.0;
            if (tmp->p->type != 32)
               y = 0.0;
            else if (tmp->n->type != 32)
               x = 1.0;
            else {
               for (a=tmp->p; a->type == 32 && a->apd[0] == FALSE; a=a->p);
               if (a->type == 32 && a->apd[0] == TRUE)
                  x = a->num[0];
               for (a=tmp->n; a->type == 32 && a->apd[0] == FALSE; a=a->n);
               if (a->type == 32 && a->apd[0] == TRUE)
                  y = a->num[0];
            }
            memset( s, ' ', 16 );
            s[16] = '\0';
            change_footer( s, cell_r, wc->field, 1, 8 );
            ftoa( (float)x, 2, t );
            strcat( t, " - " );
            ftoa( (float)y, 2, s );
            strcat( t, s );
            change_footer( t, cell_r, wc->field, 1, 8 );
            (*limits)[cell_r].range[wc->field].lo = x;
            (*limits)[cell_r].range[wc->field].hi = y;
         }
         break;
      case 33 :
         foot_row = 3;
         for (a=tmp, i=1; a->type > 1; a=a->p) {
            if (a->type == 33)
              i++;
         }
         foot_col = 51;
         strcpy( t, itoa( i, t, 10 ) );
         change_footer( "  ", cell_r, wc->field, foot_row, foot_col );
         change_footer(    t, cell_r, wc->field, foot_row, foot_col );
         break;
      case 34 :
         foot_row = 2;
         for (a=tmp, i=0; a->type > 28; a=a->p) {
            if (a->type == 34)
              i++;
         }
         foot_col = 51;
         strcpy( t, itoa( i, t, 10 ) );
         change_footer( "  ", cell_r, wc->field, foot_row, foot_col );
         change_footer(    t, cell_r, wc->field, foot_row, foot_col );
         break;
      case 35 :
         foot_row = 2;
         for (a=tmp, i=0; a->type > 28; a=a->p) {
            if (a->type == 35)
              i++;
         }
         foot_col = 51;
         strcpy( t, itoa( i, t, 10 ) );
         change_footer( "  ", cell_r, wc->field, foot_row, foot_col );
         change_footer(    t, cell_r, wc->field, foot_row, foot_col );
         break;
   }
   memset( t, ' ', 80 );
   t[80] = '\0';
   fast_write( 0, 24, t, cfg.f_bar );
}


void check_card4_hbdate( HYDROLOGY *tmp, WINDOW_CONTROL *wc, int *c, char *t )
{
int ok, y, d, i, j, leap;
char yr[8], day[8];

   memset( yr, '\0', 8 );
   memset( day, '\0', 8 );
   for (i=strlen( t )-1, j=0; i>=0 && j<3; i--,j++)
      insert( day, 0, t[i] );
   for (; i>=0; i--)
      insert( yr, 0, t[i] );
   d = atoi( day );
   y = atoi( yr );
   leap = (y % 4 == 0) && ((y % 100 != 0) || (y % 400 == 0));
   if (leap) {
      if (d < 0 || d > 366)
         ok = FALSE;
      else
         ok = TRUE;
   } else {
      if (d < 0 || d > 365)
         ok = FALSE;
      else
         ok = TRUE;
   }
   if (ok == FALSE) {
      set_field_value( tmp, " ", wc->field, FALSE );
      *t = '\0';
      *c = 0;
   }
}


void check_card4_units( HYDROLOGY *tmp )
{
   if (tmp->num[6] != units) {
      if (tmp->num[6] == ENGLISH) {
         fast_write( 63, 1, "English units", NORMAL );
         foot_list = &english_list;
         limits = &english_limits;
      } else {
         fast_write( 63, 1, "Metric units ", NORMAL );
         foot_list = &metric_list;
         limits = &metric_limits;
      }
      units = (int)tmp->num[6];
   }
}


void check_card4_forest( HYDROLOGY *tmp )
{
   if (tmp->num[9] == (float)0.0) {
      english_list[2][3] = cona;
      english_limits[2].range[3].lo = 3.3;
      metric_list[2][3] = cona;
      metric_limits[2].range[3].lo = 3.3;
   } else {
      english_list[2][3] = fcona;
      english_limits[2].range[3].lo = 3.0;
      metric_list[2][3] = fcona;
      metric_limits[2].range[3].lo = 3.0;
   }
}


void check_card4_iropt( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
int iropt;
HYDROLOGY *b;

   iropt = get_field_value( tmp, 2 );
   if (iropt == 0) {
      b = tmp;
      while (b != NULL) {
         if (b->type == 30) {
            set_field_value( b, " ", 0, FALSE );
            set_field_value( b, " ", 1, FALSE );
         }
         b = b->n;
      }
      scroll_and_show( tmp, wc, wc->v_row + wc->d_row );
   }
}


/*
 void check_card4_nut( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
 {
 int diff, card_no;
 int nut;
 HYDROLOGY *b;

    b = tmp;
    card_no = 4;
    nut = get_field_value( b, 3 );
    if (nut == 0) {
       while (b->type != 7)
          b = b->n;
       set_field_value( b, " ", 0, FALSE );
       while (b->type != 14)
          b = b->n;
       if (b->n->type != 18) {
          diff = -1;
          b = b->n;
          while (b->type != 18)
             add_remove_diff( &b, diff, 15 );
          scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
       }
    }
 }
*/


void check_card5( HYDROLOGY **tmp, WINDOW_CONTROL *wc )
{
int diff, card_no;
HYDROLOGY *b;

   b = *tmp;
   card_no = 5;
   if (b->num[wc->field] == 0) {
      if (b->n->type == 5) {
         diff = -1;
         b = b->n;
         add_remove_diff( &b, diff, card_no );
         while (b->type == 5 && b != NULL)
            add_remove_diff( &b, diff, card_no );
         scroll_and_show( *tmp, wc,  wc->v_row + wc->d_row );
      }
   } else if (b->num[wc->field] == 1) {
      if (b->n->type != 5) {
         diff = 1;
         add_remove_diff( tmp, diff, card_no );
         add_remove_diff( tmp, diff, card_no );
         scroll_and_show( *tmp, wc,  wc->v_row + wc->d_row );
      }
   }
}


/*
void check_beg_endgro( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
HYDROLOGY *b;
int  change;

   change = FALSE;
   for (b=tmp; b->type != 25; b=b->n);
   if (tmp->apd[9] == TRUE && tmp->num[9] == 3) {
      if (b->p->type != 24) {
          b = b->p;
          add_remove_diff( &b, 1, 24 );
          change = TRUE;
      }
   } else {
      if (b->p->type == 24) {
          b = b->p;
          add_remove_diff( &b, -1, 24 );
          change = TRUE;
      }
   }
   if (change == TRUE)
      scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
}
*/


void check_card6_rd( HYDROLOGY *tmp, WINDOW_CONTROL *wc, char *t )
{
HYDROLOGY *a;
int i;
float rd;

   rd = (float)atof( t );
   a=tmp->n;              /* a points to card 7 */
   if (a->apd[1] != FALSE) {         /* see if number of horizons entered */
      for (i=2; i <= (int)a->num[1]+1; i++) {
         if (a->apd[i] == TRUE)
            if (a->num[i] > rd)    /* if any horizon > rd then set it to 0 */
               set_field_value( a, " ", i, FALSE );
      }
      i = (int)a->num[1] + 1;     /* make sure last horizon is set to rd */
      set_field_value( a, t, i, TRUE );
      scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
   }
}


void check_card6_cn2( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
int total_years, old_years, diff, new_rot, old_rot, cn2, i;
long int last_date;
HYDROLOGY *a;

   if (tmp->apd[4] == TRUE) {
      cn2 = (int)tmp->num[4];
      if (cn2 < 0) {
         for (a=tmp; a->type != 28  &&  a != NULL; a=a->n);
         if (a != NULL  &&  a->apd[2] == TRUE) {
            new_rot = (int)a->num[2];
            for (; a != NULL; a=a->n) {
               if (a->type == 33  &&  (int)a->num[0]  == -1)
                  break;
            }
            if (a->n == NULL) {
               for (;new_rot > 0; new_rot--) {
                  add_remove_diff( &a, 1, 34 );
                  a = a->n;
                  add_remove_diff( &a, 1, 35 );
                  a = a->n;
               }
               for (a=tmp; a->type != 34; a=a->n);
               set_field_value( a, "1", 0, TRUE );
            }
         }
      }
   }
}


void check_card7( HYDROLOGY *tmp, WINDOW_CONTROL *wc, int *c, int *max,
                  char *t )
{
HYDROLOGY *a;
int  isoil;
char tt[10];

   if (wc->field == 0) {
      a = tmp;
      while (a->type != 14)
         a = a->n;
      isoil = get_field_value( tmp, 0 );
      switch (isoil) {
         case 1 :
            if (a->n->type != 17) {
               a = a->n;
               while (a->type != 18)
                  add_remove_diff( &a, -1, 15 );
               a = tmp;
               while (a->type != 14)
                  a = a->n;
               add_remove_diff( &a, 1, 17 );
               scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
            }
            break;
         case 2 :
            if (a->n->type != 15) {
               a = a->n;
               while (a->type != 18)
                  add_remove_diff( &a, -1, 17 );
               a = tmp;
               while (a->type != 14)
                  a = a->n;
               add_remove_diff( &a, 1, 16 );
               add_remove_diff( &a, 1, 15 );
               scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
            }
            break;
         default :
            if (a->n->type != 18) {
               a = a->n;
               while (a->type != 18)
                  add_remove_diff( &a, -1, 15 );
               scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
            }
            break;
      }
   } else if (wc->field == 1) {
      if (tmp->apd[1] == FALSE)
         *max = 1;
      else
         *max = (int)tmp->num[1] + 1;
   } else if (wc->field == *max) {
      if (tmp->p->apd[7] == TRUE && tmp->p->num[7] != tmp->num[*max]) {
         get_string_field_value( tmp->p, tt, 7 );
         set_field_value( tmp, tt, wc->field, TRUE );
         strcpy( t, tt );
         *c = 0;
      }
   }
}


void check_card28( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
int total_years, old_years, diff, new_rot, old_rot, i, check_updates;
int num_34, num_35, show;
long int last_date;
HYDROLOGY *a, *b;

   if (wc->field == 0 || wc->field == 1) {
      if (tmp->apd[0] == TRUE && tmp->apd[1] == TRUE) {
         total_years = (int)(tmp->num[1] - tmp->num[0] + 1);
         if (total_years > 50) total_years = 50;
         if (total_years < 1) total_years = 1;
         for (a=tmp; a->type != 33  &&  a != NULL; a=a->n);
         if (a != NULL) {
            old_years = 0;
            for (; a != NULL; a=a->n) {
               if (a->type == 33)
                  ++old_years;
            }
            diff = total_years - old_years;
            if (diff != 0) {
               for (a=tmp; a->n != NULL; a=a->n);
               if (diff > 0) {
                  a = a->p;
                  add_remove_diff( &a, diff, 33 );
               } else {
                  for (i=0; i>diff; i--) {
                     while (a->n != NULL)
                        a=a->n;
                     for (a=a->p; a->type != 33; a=a->p);
                     add_remove_diff( &a, -1, 33 );
                     while (a->type != 33 && a != NULL)
                        add_remove_diff( &a, -1, 13 );
                  }
               }
               scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
            }
         }
      }
   } else if (wc->field == 2) {
      show = FALSE;
      if (tmp->apd[2] == TRUE) {
         new_rot = (int)tmp->num[2];
         for (a=tmp; a->type != 6; a=a->p);
         if (a->apd[4] == TRUE  &&  (int)a->num[4] < 0  &&  new_rot > 0) {
            for (a=tmp; a != NULL; a=a->n) {
               if (a->type == 33  &&  (int)a->num[0]  == -1)
                  break;
            }
            if (a != NULL  && a->n == NULL) {
               for (;new_rot > 0; new_rot--) {
                  add_remove_diff( &a, 1, 34 );
                  a = a->n;
                  add_remove_diff( &a, 1, 35 );
                  a = a->n;
               }
               for (a=tmp; a->type != 34; a=a->n);
               set_field_value( a, "1", 0, TRUE );
               show = TRUE;
            } else if (a != NULL) {
               num_34 = num_35 = 0;
               for (; a != NULL; a=a->n) {
                  if (a->type == 34)
                     ++num_34;
                  if (a->type == 35)
                     ++num_35;
               }
               if (num_34 != new_rot) {
                  diff = new_rot - num_34;
                  for (a=tmp; a->n != NULL; a=a->n);
                  if (diff < 0) {
                     b = a->p;
                     while (diff < 0) {
                        add_remove_diff( &a, -1, 35 );
                        a = b;
                        b = a->p;
                        add_remove_diff( &a, -1, 34 );
                        a = b;
                        b = a->p;
                        ++diff;
                     }
                     show = TRUE;
                  } else {
                     for (;diff > 0; diff--) {
                        add_remove_diff( &a, 1, 34 );
                        a = a->n;
                        add_remove_diff( &a, 1, 35 );
                        a = a->n;
                     }
                     for (a=tmp; a->type != 34; a=a->n);
                     set_field_value( a, "1", 0, TRUE );
                     show = TRUE;
                  }
               }
            }
         }
         new_rot = (int)tmp->num[2];
         old_rot = (int)tmp->num[5];
         last_date = new_rot * 1000 + 366;
         diff = new_rot - old_rot;
         if (diff < 0) {
            for (a=tmp->n; a->type == 29  && (long)a->num[2] <= last_date; a=a->n->n);
            while (a->type == 29  && a->n->n->type == 29)
               add_remove_diff( &a, -2, 29 );
            show = TRUE;
         }
         if (show == TRUE)
            scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
         tmp->num[5] = new_rot;
      }
   }
}


void check_card29_userlai( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
HYDROLOGY *a;
int crop, found;
char s[10];

   crop = (int)tmp->num[0];
   if (tmp->n->type != 30 || crop < 79)
      return;
   for (a=tmp->p; a->type != 28; a=a->p);
   found = FALSE;
   for (a=a->n; a->n->type == 30 && !found; a=a->n->n) {
      if (crop == (int)a->num[0] && a != tmp)
         found = TRUE;
   }
   if (!found) {
      for (a=tmp; a->n->type == 30; a=a->n->n);
      while (a->type != 33 && !found) {
         if (a->type == 31 && crop == (int)a->num[0])
            found = TRUE;
         a = a->n;
      }
   }
   if (!found) {
      for (a=tmp; a->n->type == 30; a=a->n->n);
      a = a->n;
      while ((a->type == 31 && a->num[0] < crop) || a->type == 32)
         a = a->n;
      a = a->p;
      add_remove_diff( &a, 1, 31 );
      a = a->n;
      itoa( crop, s, 10 );
      set_field_value( a, s, 0, TRUE );
      set_field_value( a, "2", 1, TRUE );
      a->num[2] = 2;
      add_remove_diff( &a, 1, 32 );
      a = a->n;
      set_field_value( a, "0.0", 0, TRUE );
      add_remove_diff( &a, 1, 32 );
      a = a->n;
      set_field_value( a, "1.0", 0, TRUE );
      scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
   }
}


void check_card30_dates( HYDROLOGY *tmp, WINDOW_CONTROL *wc, int *c, char *t )
{
int ok, y, d, i, j;
char yr[8], day[8];

   if (tmp->type == 29) {
      if (wc->field == 4  ||  wc->field == 5)
         return;
   }
   memset( yr, '\0', 8 );
   memset( day, '\0', 8 );
   for (i=strlen( t )-1, j=0; i >= 0  &&  j < 3;  i--,j++)
      insert( day, 0, t[i] );
   for (; i>=0; i--)
      insert( yr, 0, t[i] );
   d = atoi( day );
   y = atoi( yr );
   if (d < 0 || d > 366)
      ok = FALSE;
   else
      ok = TRUE;
   if (ok == FALSE) {
      set_field_value( tmp, " ", wc->field, FALSE );
      *t = '\0';
      *c = 0;
   }
}


void check_card31_nolai( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
int total_lai, old_lai, diff;
int show = FALSE;
HYDROLOGY *a;

   if (wc->field == 1) {
      total_lai = (int)tmp->num[1];
      if (total_lai < 2) {
         total_lai = 2;
         set_field_value( tmp, "2", 1, TRUE );
         show = TRUE;
      }
      old_lai = (int)tmp->num[2];
      diff = total_lai - old_lai;
      if (diff != 0) {
         if (tmp->n->type == 32)
            a = tmp->n;
         else
            a = tmp;
         if (diff > 0) {
            add_remove_diff( &a, diff, 32 );
         } else {
            if (a->n->type == 32)
               a = a->n;
            else
               a = tmp->n;
            add_remove_diff( &a, diff, 32 );
         }
         tmp->num[2] = total_lai;
         show = TRUE;
      }
      if (show == TRUE)
         scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
   }
}


void check_card33( HYDROLOGY *tmp, WINDOW_CONTROL *wc, int *c, char *t )
{
HYDROLOGY *a;

   if (tmp->n == NULL) {
      if (wc->field == 0) {
         if (strcmp( t, "-1" )) {
            strcpy( t, "-1" );
            set_field_value( tmp, t, wc->field, TRUE );
            *c = 0;
         }
      } else if (wc->field == 1) {
         if (strcmp( t, "0" )) {
            strcpy( t, "0" );
            set_field_value( tmp, t, wc->field, TRUE );
            *c = 0;
         }
      } else if (wc->field == 2) {
         if (strcmp( t, "0" )) {
            strcpy( t, "0" );
            set_field_value( tmp, t, wc->field, TRUE );
            *c = 0;
         }
      } else if (wc->field == 3) {
         if (strcmp( t, "0" )) {
            strcpy( t, "0" );
            set_field_value( tmp, t, wc->field, TRUE );
            *c = 0;
         }
      }
   } else {
      if (tmp->num[wc->field] != tmp->num[wc->field+4]) {
         switch (wc->field) {
            case 0 :
               if (tmp->num[0] == 0) {
                  for (a=tmp; a->type != 18 && a != NULL; a=a->n);
                  add_remove_diff( &a, -4, 18 );
               } else {
                  a=tmp;
                  add_remove_diff( &a, 1, 21 );
                  add_remove_diff( &a, 1, 20 );
                  add_remove_diff( &a, 1, 19 );
                  add_remove_diff( &a, 1, 18 );
               }
               break;
            case 1 :
               if (tmp->num[1] == 0) {
                  for (a=tmp; a->type != 22 && a != NULL; a=a->n);
                  if (a != NULL && a->type == 22)
                     add_remove_diff( &a, -2, 22 );
               } else {
                  for (a=tmp; a->n->type < 22; a=a->n);
                  add_remove_diff( &a, 1, 23 );
                  add_remove_diff( &a, 1, 22 );
               }
               break;
            case 2 :
               if (tmp->num[2] == 0) {
                  for (a=tmp; a->type != 24 && a != NULL; a=a->n);
                  if (a != NULL && a->type == 24)
                     add_remove_diff( &a, -2, 24 );
               } else {
                  for (a=tmp; a->n->type < 24; a=a->n);
                  add_remove_diff( &a, 1, 25 );
                  add_remove_diff( &a, 1, 24 );
               }
               break;
            case 3 :
               if (tmp->num[3] == 0) {
                  for (a=tmp; a->type != 26 && a != NULL; a=a->n);
                  if (a != NULL && a->type == 26)
                     add_remove_diff( &a, -2, 26 );
               } else {
                  for (a=tmp; a->n->type < 26; a=a->n);
                  add_remove_diff( &a, 1, 27 );
                  add_remove_diff( &a, 1, 26 );
               }
               break;
         }
         scroll_and_show( tmp, wc,  wc->v_row + wc->d_row );
         tmp->num[wc->field+4] = tmp->num[wc->field];
      }
   }
}


void check_card34( HYDROLOGY *tmp, WINDOW_CONTROL *wc, int *c, char *t )
{

   if (tmp->p->type == 33) {
      if (wc->field == 0) {
         if (strcmp( t, "1" )) {
            strcpy( t, "1" );
            set_field_value( tmp, t, wc->field, TRUE );
            *c = 0;
         }
      }
   }
}


void blank_old_horz( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
int i, j, old_nosohz, new_max, wid, row, col;
HYDROLOGY *a;
char tt[10], s[10];

   old_nosohz = get_field_value( tmp, 7 );
   new_max = get_field_value( tmp, 1 );
   j = new_max - old_nosohz;
   if (j != 0) {
      a = tmp->p;      /* point to card 6 */
      if (a->apd[7] == TRUE) {   /* see if rd has been entered */
         get_string_field_value( a, tt, 7 );
         set_field_value( tmp, tt, new_max+1, TRUE );
      } else
         *tt = '\0';
      if (j < 0) {
         for (i=new_max+2; i < 7; i++)
            set_field_value( tmp, " ", i, FALSE ); /* blank out last old val */
         for (a=tmp->n; a->type < 18; a=a->n) {
            for (i=new_max; i < 5; i++)
               set_field_value( a, " ", i, FALSE ); /* blank out last old val */
         }
         a = tmp;
         scroll_and_show( a, wc,  wc->v_row + wc->d_row );
      } else {
         wid = (*limits)[tmp->type-4].width[new_max+1];
         row = wc->v_row + wc->d_row;
         col = wc->d_col + (new_max+1) * 8 + 8 - wid - 8 * wc->view;
         memset( s, ' ', wid );
         s[wid] = '\0';
         fast_write( col, row, s, NORMAL );
         fast_write( col+wid-strlen( tt ), row, tt, NORMAL );
      }
      tmp->num[7] = new_max;
   }
}


void change_card7_footer( HYDROLOGY *tmp, WINDOW_CONTROL *wc, int cell_r,
                          int *max_fields )
{
float tophorz, bothorz;
int i, j, col, found;
char t[20];
HYDROLOGY *a;

   if (units == ENGLISH)
      tophorz = (float)1.0;
   else
      tophorz = (float)2.54;
   a = tmp->p;    /* set a to card 6 */
   if (a->apd[7] == TRUE)
      bothorz = a->num[7];   /* if rd has been entered set bothorz to rd */
   else {
      if (units == ENGLISH)
         bothorz = (float)60.0;        /* else set bothorz to 60.0 inches */
      else
         bothorz = (float)152.4;
   }
   for (i=wc->field+1,found=FALSE; i<=*max_fields && !found; i++) {
      if (tmp->apd[i] == TRUE) {
         found = TRUE;
         bothorz = tmp->num[i];
      }
   }
   if (wc->field == *max_fields)  /* if bottom layer make sure only */
      tophorz = bothorz;         /* value entered is rd */
   else {
      for (i=wc->field-1,found=FALSE; i>1 && !found; i--) {
         if (tmp->apd[i] == TRUE) {
            found = TRUE;
            tophorz = tmp->num[i];
         }
      }
   }
   j = units == ENGLISH ? 4 : 6;
   memset( t, ' ', j );
   t[j] = '\0';
   change_footer( t, cell_r, wc->field, 1, 8 );
   ftoa( tophorz, 1, t );
   for (i=strlen( t ); i<j; i++)
      insert( t, 0, ' ' );
   change_footer( t, cell_r, wc->field, 1, 8 );
   memset( t, ' ', j );
   t[j] = '\0';
   col = units == ENGLISH ? 15 : 17;
   change_footer( t, cell_r, wc->field, 1, col );
   ftoa( bothorz, 1, t );
   for (i=strlen(t); i<j; i++)
      insert( t, 0, ' ' );
   change_footer( t, cell_r, wc->field, 1, col );

   memset( t, ' ', 1 );
   t[1] = '\0';
   change_footer( t, cell_r, wc->field, 2, 10 );
   change_footer( itoa( wc->field-1, t, 10 ), cell_r, wc->field, 2, 10 );
}


void change_footer( char *t, int type, int field, int foot_num, int col )
{
int i, j;

   j = strlen( t );
   for (i=0; i < j; i++)
     (*foot_list)[type][field][foot_num].text[col+i] = t[i];
}


void scroll_and_show( HYDROLOGY *b, WINDOW_CONTROL *wc, int row )
{
int i, j;
char t[82], s[10];

   scroll_window( 0, row, 0, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (j=row; b != NULL  && j < wc->max_rows + wc->d_row; b=b->n,j++) {
      if (b->type >= 1 && b->type <=3)
         fast_write( 0, j, b->line, NORMAL );
      else {
         i = 0 + 8 * wc->view;
         strncpy( t, b->line+i, 72 );
         t[72] = '\0';
         fast_write( wc->d_col, j, t, NORMAL );
         itoa( b->type, s, 10 );
         if (strlen( s ) == 1)
            fast_write( wc->d_col-2, j, s, NORMAL );
         else
            fast_write( wc->d_col-3, j, s, NORMAL );
      }
   }
}


int  get_field_value( HYDROLOGY *a, int field )
{
   return ( (int)a->num[field] );
}


void set_field_value( HYDROLOGY *a, char *t, int field, int t_or_f )
{
   a->apd[field] = (char)t_or_f;
   format_output( t, a->line, field );
   a->num[field] = (float)atof( t );
}


void get_string_field_value( HYDROLOGY *tmp, char *t, int field )
{
int i;

   for (i=0; i < 8 && (t[i] = tmp->line[field*8 + i]); i++);
   t[i] = '\0';
   while (t[0] && (t[0] == ' '))
      delete( t, 0 );
}


void add_remove_c29( HYDROLOGY **tmp, WINDOW_CONTROL *wc, int *c )
{
int diff, card_no;
HYDROLOGY *b, *x;

   card_no = 29;
   if (*c == F3 && (*tmp)->n->type != 30)
      diff = 0;
   else {
      if (*c == F2 && (*tmp)->n->type != 30) {
         /*
          * EXCEPTION -- add before the 0 card
          *  add card 29 first then add card 30
          */
         x = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
         blank_line( x );
         x->type = 29;
         b = (*tmp)->p;
         x->p = b;
         x->n = *tmp;
         b->n = x;
         (*tmp)->p = x;
         *tmp = (*tmp)->p;

         /*
          * now add card 30
          */
         x = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
         blank_line( x );
         x->type = 30;
         b = (*tmp)->n;
         x->p = (*tmp);
         (*tmp)->n = x;
         x->n = b;
         b->p = x;
      } else {
         if (*c == F2) {
            diff = 1;
            b = (*tmp)->n;
            add_remove_diff( &b, diff, 30 );
            add_remove_diff( &b, diff, 29 );
         } else if (*c == F3) {
            diff = -1;
            add_remove_diff( tmp, diff, 29 );
            add_remove_diff( tmp, diff, 30 );
         }
      }
      scroll_and_show( *tmp, wc,  wc->v_row + wc->d_row );
   }
}


void add_remove_diff( HYDROLOGY **a, int diff, int card_no )
{
HYDROLOGY *b, *c;
int j;

   if (diff < 0) {
      b = (*a)->p;     /* back pointer b one card and remove b->n */
      for (j=diff; j<0; j++) {
         b->n = (*a)->n;
         if ((*a)->n != NULL)
            (*a)->n->p = b;
         free( *a );
         *a=b->n;
      }
   } else if (diff > 0) {
             /* add diff cards to list */
      for (b=*a, j=diff; j>0; j--) {
         c = (HYDROLOGY *)malloc( sizeof(HYDROLOGY) );
         blank_line( c );
         c->type = card_no;
         if (b->n != NULL)
            b->n->p = c;
         c->n = b->n;
         c->p = b;
         b->n = c;
      }
   }
}


void view_lft_rgt( HYDROLOGY *tmp, WINDOW_CONTROL *wc )
{
HYDROLOGY *a;
int row, i;
char t[82];

   for (a=tmp, row=wc->v_row; a->p->type > 3 && row>0; a=a->p, row--);
   row += wc->d_row;
   scroll_window( 0, row, wc->d_col, wc->d_row+wc->max_rows-1, 79, NORMAL );
   for (; a!=NULL && row<wc->d_row+wc->max_rows; a=a->n,row++) {
      i = 0 + 8 * wc->view;
      strncpy( t, a->line+i, 72 );
      t[72] = '\0';
      fast_write( wc->d_col, row, t, NORMAL );
   }
}
