c$DEBUG
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                                                                      C
C  GGGGGGG    LL         EEEEEEEEE      AAA      M       M    SSSSSSS  C
C GGGGGGGGG   LL         EEEEEEEEE     AAAAA     MM     MM   SSSSSSSSS C
C GG     GG   LL         EE           AA   AA    MMM   MMM   SS     SS C
C GG          LL         EE          AA     AA   MMMM MMMM   SS        C
C GG          LL         EEEEEEEE    AA     AA   MM MMM MM   SSSSSSSS  C
C GG   GGG    LL         EEEEEEEE    AAAAAAAAA   MM  M  MM    SSSSSSSS C
C GG   GGGG   LL         EE          AAAAAAAAA   MM     MM          SS C
C GG     GG   LL         EE          AA     AA   MM     MM   SS     SS C
C GGGGGGGGG   LLLLLLLLL  EEEEEEEEE   AA     AA   MM     MM   SSSSSSSSS C
C  GGGGGGG    LLLLLLLLL  EEEEEEEEE   AA     AA   MM     MM    SSSSSSS  C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C MODIFICATIONS/DATES:
C
C
C June 30, 2004:
C   1.  soil water adjustment from chemigation/fertigation was added
C       to sw1, but was not added to st().  st() was not adjusted
C       water added by chemirr.  the do 2222 loop was modified to
C       adjust both sw1 and st() at the same time.  fmd
C
C
C July 18, 2003:
C   1.  frozen soil counter decremented only on days of effective rainfall.
C       consequently, model overpredicted runoff and pesticide loss in runoff
C       long after soil thaw.  frozen soil counter now depends on temp.  fmd
C
C
C**********************************************************************C
C                   G L E A M S  LINKED PROGRAMS                       C
C                                                                      C
C               VERSION 3.0  MAY 1, 1999 TIFTON, GA                    C
C                                                                      C
C                        PROJECT PERSONNEL                             C
C                        -----------------                             C
C   MR. FRANK DAVIS                       DR. W. G. KNISEL             C
C   COMPUTER SPECIALIST                   CONSULTANT                   C
C   USDA-ARS-SEWRL                        1606 RUTLAND ROAD            C
C   P.O. BOX 946                          TIFTON  GA  31794            C
C   TIFTON  GA  31793                                                  C
C   TELEPHONE NO: 912-391-6846            TELEPHONE NO: 229-382-1332   C
C   FAX NO:       912-386-7265            FAX NO:       229-382-2192   C
C   EMAIL: fmd@tifton.cpes.peachnet.edu   EMAIL:  wknisel@planttel.net C
C**********************************************************************C
CIO                                                                  IOC
CIO           SYSTEM DEPENDENT I/O UNIT AND FILE SELECTION           IOC
CIO                                                                  IOC
CIO        PRECIPITATION FILE         -  READ FROM  UNIT 01          IOC
CIO        HYDROLOGY PARAMETERS FILE  -  READ FROM  UNIT 02          IOC
CIO        EROSION PARAMETERS FILE    -  READ FROM  UNIT 03          IOC
CIO        NUTRIENT PARAMETERS FILE   -  READ FROM  UNIT 04          IOC
CIO        PESTICIDE PARAMETERS FILE  -  READ FROM  UNIT 05          IOC
CIO        DUMMY DATA FILE            -  WRITE/READ UNIT 06          IOC
CIO        HYDROLOGY OUTPUT FILE      -  WRITE TO   UNIT 07          IOC
CIO        EROSION OUTPUT FILE        -  WRITE TO   UNIT 08          IOC
CIO        NUTRIENT OUTPUT FILE       -  WRITE TO   UNIT 09          IOC
CIO        PESTICIDE OUTPUT FILE      -  WRITE TO   UNIT 10          IOC
CIO        PASS-MASS OUTPUT FILE      -  WRITE TO   UNIT 11          IOC
CIO        PASS-CONC OUTPUT FILE      -  WRITE TO   UNIT 12          IOC
CIO        TEMPERATURE FILE           -  READ FROM  UNIT 13          IOC
CIO        SELECTED VARIABLE OUT FILE -  WRITE TO   UNIT 14          IOC
CIO        NUTRIENT PASS FILE         -  WRITE TO   UNIT 15          IOC
CIO        NUTRIENT DUMMY FILE        -  WRITE/READ UNIT 16          IOC
CIO                                                                  IOC
CIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOC
      CHARACTER*40  PREFIL,HYDIN,EROIN,nutin,PSTIN,OUTHYD,OUTERO,outnut,
     &              OUTPST,BCKFYL,TEMFYL,pstout
      COMMON /FILE/ PREFIL,HYDIN,EROIN,nutin,PSTIN,OUTHYD,OUTERO,outnut,
     &              OUTPST,BCKFYL,TEMFYL,pstout
       COMMON /HEAD1/ TITLE
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                VERMNT,BCKEND,flgpen
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
       INTEGER HBDATE,HYDOUT,IROPT,FLGGEN,FLGNUT,FLGPST,FLGMET,VERMNT,
     1         bckend, FOREST, BEGGRO, ENDGRO,flgpen
       REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY
       CHARACTER *80 TITLE(3)
       CHARACTER YN
       save
C
C      *****     THIS IS THE TOP OF THE MAIN PROGRAM LOOP     *****
CIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOC
CIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOIOC
C
C *  * LOGICAL UNIT DEFINITIONS FOR THE FILE UNITS
C
      LUN01      =       01
      LUN02      =       02
      LUN03      =       03
      LUN04      =       04
      LUN05      =       25
      LUN06      =       26
      LUN07      =       07
      LUN08      =       08
      LUN09      =       09
      LUN10      =       10
      LUN11      =       11
      LUN12      =       12
      LUN13      =       13
      LUN14      =       14
      LUN15      =       15
      LUN16      =       16
C
C  CALL THE SUBS THAT SET UP THE FILES FOR THE PC
        CALL INTRO( YN )
        CALL FILES( YN )
C * *
C * *
       WRITE (*,5)
5      FORMAT (//////////,20X, 'DATA FILES OPENED, PROGRAM IS RUNNING')
       DO 10 J=1,3
           READ (LUN02,2001)  TITLE(J)
  10   CONTINUE
c * * * * icen is the "19" or "20" in the year for y2k compliance.      y2k
c       READ (LUN02,2000) HBDATE,HYDOUT,flgpen,FLGNUT,FLGPST,FLGGEN,     y2k
       READ (LUN02,2002)icen,hBDATE,HYDOUT,flgpen,FLGNUT,FLGPST,FLGGEN, y2k
     &                   FLGMET,VERMNT,BCKEND,FOREST
       iy2k = 0
       if (icen .le. 0) then                                            y2k
          icen = 19                                                     y2k
          iy2k = 1                                                      y2k
       endif                                                            y2k
       hbdate = icen * 100000 + hbdate                                  y2k
       if (iy2k .ne. 0) then                                            y2k
         WRITE(LUN07,7003) hbdate                                       y2k
         WRITE(*,7003) hbdate                                           y2k
       endif                                                            y2k
C * * * * FLGMET: 0 = ENGLISH; 1 = METRIC
C * * * * VERMNT: 0 = NO MEAN DAILY TEMPS; 1 = YES MEAN DAILY TEMPS
C * * * * BCKEND: 0 = NO FILE FOR BACKEND; 1 = YES FILE FOR BACKEND
       WRITE(LUN07,7000)
       DO 30 J=1,3
          WRITE (LUN07,7002)  TITLE(J)
  30   CONTINUE
       CALL HYDONE
       STOP 'Normal GLEAMS program termination.'
2000   FORMAT(10I8)
2001   FORMAT(A80)
2002   FORMAT(i3,i5,9I8)                                                y2k
7000   FORMAT(23X,'G L E A M S  3.0 HYDROLOGY OUTPUT',/,
     1        23X,'---------------------------------',//)
7002   FORMAT(1X,A80)
7003   FORMAT(/,' *** Y2K COMPLIANCE: 2 DIGIT YEAR READ. *** ',/,       y2k
     &         '    HYDROLOGY BEGIN DATE = ',i8,/)                      y2k
       END
       SUBROUTINE HYDONE
      COMMON /ERYPST/PSTPAS,PSTOUT,NBDATE,PBDATE,PEDATE,NPEST,
     &               APRATE(366),H2OSOL(366),DECAY(366,12),KOC(366),
     &               FOLFRC(366),SOLFRC(366),FOLRES(366),SOLRES(366,12),
     &               WSHFRC(366), WSHTHR   ,METH(366),TOTPST(366),
     &               FOLRSV(366),DEPINC(366),BETA(366),COFTRN(366),
     &               COFUP(366),METPST(366),DEGRAD(366,12),NEWPST(366),
     &               CHMWAT(366)
       COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                VERMNT,BCKEND,flgpen
       COMMON /HYDVAR/ ADD,SUM,TOT,POTET(366),EPP(366),PWU,SPG
c      COMMON /IRRIG/IDAY,NOIRR(366)
       COMMON /IRRIG/IDAY,NOIRR(366), balone(50),begsum,dirr(366),
     &               chtone(50)
       COMMON /IRR/ BASEI(366),TOPI(366),bsi,tpi
       COMMON /HONE/ RD,DACRE,RC,SIA,CHS,WLW,CN2,BST,UL(13),satk(12)
       COMMON /SUMT/ PMO(600),QP(600),WU(600),SEPM(600),SWM(600)
     1               ,TIRR(600),ISNOW
       COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1               R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1               icindx(366),sumlai,acclai,aideal,sfn,
     1               iccrd(366),ioldcp,cdelta(366),chone,wind(366)
       COMMON /BLK1/ EOS,SW1,RAIN,TUL,TU,CONA,ES,EP,MO,IDA,IYR,
     &               NT,UW,JE,J,elev,rlat
       COMMON /PASS/ JDATE,DRAIN, QL,    QPEAK,DEI
       COMMON /PRCP/ SOLOSS,ENRICH,DP,SEP,
     1               AVGTMP,AVGSWC,ACCPEV,POTPEV,ACCSEV,POTSEV,TST(12),
     &               SWPER(13),UP(12),EVP(12),WUP(12),CHMET,solevp,
     &               potevp
       common /optmir/cul(12), csw(12), nul
       COMMON /NUTPST/BD(12),FC(12),CONV(12),FUL(12),SOLPOR(12),
     &                BR15(12),OSW(12),SAT(12),OM(12),KD(366,12),
     &                SOILMS(12),cknit(12)
       COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl, swet
     &                 BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /FLAG / FLGRES(366),NFLG
       COMMON /ANBUDG/ SYR,SYQ,SXSP,TYWU,OTSW,PSW,AIRR
       COMMON /ORGMAT/HYDOM(12)
       COMMON /FLDCAP/FDCPMM(12)
       COMMON /FREEZE/ IFZBEG,IFZEND,NFRZ,NFZDAY
       COMMON /BACK/   IBACK(20), BCKCNT
       COMMON /GDATES/ NMONTH, NYEAR, IEOMY
       COMMON /RTE/ NROUTE
       COMMON /PSTTOT/   NSTRMS,NRNFFS,NPERCS,TPRECP,TRUNFF,TPERCL,
     &                   NSEDS,TSEDS
      COMMON /TEMP/ ATP
C 'LOCAL' VARIABLES USED BY HYDONE - PUT IN COMMON TO AVOID
C STACK LIMITATIONS ON PC. (LOCAL VARIABLES ARE SAVED ON THE STACK)
      COMMON /HHH000/ AFUL,ALAI,APOR,AQ,AR,ATRN,AVESLW,AWU,
     &                BB,B15,CHMIRR,CN1,CN11,CN22,CRITS,C2,C22,C3,C33,
     &                DEF,F,FLCAP,I,IFREZ,II,IRFLG,IY,I1,JJ,JYR,
     &                K,KI,MAXDAT,MII,MINDAT,MOO,NBDAY,NBMO,ND,NDIV,
     &                NEWL,NEWR,NEWT,NN,NORAIN,NPR,nreset,PASS1,
     &                PASS10,PASS11,PASS2,PASS3,PASS4,PASS5,PASS6,PASS7
      COMMON /HHH001/ PASS8,PASS8B,PASS9,PASS9B,PAS10B,PAS11B,PAS12B,
     &                PAS13B,PB,PERCOL,PIN,PIRR,PR,PTRN,P1,P2,P7,QD,
     &                RD2,RIRR,R1,SMQ,SMR,SMX,SM1,SNO,SPR,SP1,SQ,SR,
     &                SSPR,SSXSP,SWMAX,SWMIN,TAFUL,TAPOR,TB15,TEMPF,
     &                TFLCAP,TMWU,TWU,TWV,ULE,UU,UWL,UOB,
     &                V,VB,VRTUSE,VRT1,VRT2,VT,WV,XJ,XN
      COMMON /HHH002/ dratio(12),croph,neww,newd
      COMMON /PSTHYD/ UF(13),WP(12),ADDSEP,SWADJ(12),WIRR,FOLIRR
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
      COMMON /MELT/ XMELT,XMELTM,XMELTY
      common /nuts/ nBYR, nEYR, NUTOUT, FLGROT, NOCROP, ISOIL, flgbal
      common /swc/ wf(12)
      common /prclay/nndp(13),nodp(13)
      common /rotate/ ibyr, ieyr, irot
      COMMON /crmnut/ atrand,aevapd,atranm,aevapm,atrany,aevapy,
     &                ptrand,pevapd,ptranm,pevapm,ptrany,pevapy,
     &                stmtmp,stmswc
      common /solt/ tbg(5),itbg,tbgsum,tswc,tma,dbd,aln,scaled,zl(12),
     &              wft(12), tsc(12), tk4(12)
      COMMON /PNUT/ DF(366),FP(20),FN(20),DEMERG,DHRVST,YP(90),DMY(90),
     &              NF,FNH(20),pC1(90),pC2(90),LEG(90),CNR(90),RNP(90),
     &              pernnl(90),ibegro(366),iendro(366)
      COMMON /NUT/MANAP,MTYPE(366),JDAY,SOLN,SNO3(12),
     &            RATE(366),METAP(366),ICROP,SOILN(12),SOLNH,FERT,
     &            CLABP(12),ORGN(12),AMON(12),METFLG,ATN(366),ANH(366),
     &            DEPIN(366),APHOS(366),AOM(366),frtwat(366),VOLN,SOLP,
     &            PLAB(12),PMINP(12),POTMN(12),CNHKD(12),CPKD(12),
     &            SOILP(12),MFERT(366),CNO3(12),CNH4(12),BETA1,
     &            BETA2,ROOTW,RESDW,YIELD,TN(12),TP(12),ORGP(12),
     &            cPSP(3,12),CSOILP(12),CPMINP(12),fon(12),fop(12),
     &            resdn,resdp,resdue(12),resdwi,aporgn(366),
     &            aporgp(366),ano3(366),nwstyp(366),atsp(366),
     &            sorgp(12),rtn(12)
C * * INTEGERS FOR HYDONE
      INTEGER HBDATE,BEGYR,BEGDAY,HYDOUT,DP5,FLGIYR,FLGND,PSTOUT,
     1          FLGUPD,FLGSEQ,WCHMON,DP,ELEM,FLGTMP,FLGPST,FLGGEN,
     1          PSTPAS,PBDATE,PEDATE,FLGMET,VERMNT,BCKEND,
     1          FOREST, BEGGRO, ENDGRO, flgnut, flgres, flgrot,
     1          flgbal,flgpen
      integer df,pernnl,demerg,dhrvst
C * * REALS FOR SUBROUTINE HYDONE
      REAL U(13),T(13),ST(13),TUF(12),FCAP(12),FCAPM(12)                KH
C      REAL KD,OLDST(12),WP(12),ST(12),UF(12)
      REAL KD,koc,OLDST(12)
      REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY
      REAL ULMET(12),STMET(12),UFMET(12),WPMET(12)
      integer moday(12)
      real nwd(12)
      real h2osf
      CHARACTER yn                                                      pass8b
      save
C * * CHARACTER FOR SUBROUTINE HYDONE
      DATA U1,UB,VL /0.4,3.065,15.0/
      DATA ifol,ircode/2*0/
      data moday/31,28,31,30,31,30,31,31,30,31,30,31/
CCC***THE WEIGHTING FUNCTION MUST BE: SHRUNK TO 3; EXPANDED TO 12; BE VARIABLE;
CCC***AND THE SUM MUST ALWAYS BE 1.0
      ictfrz = 0                                                        soilT
      NBMO  = 1
      solevp= 0.0
      potevp= 0.0
      ADDSEP= 0.0
      WIRR  = 0.0
      PASS5 = 0.0
      pass1b= 0.0
      pass2b= 0.0
      pass5b= 0.0
      BEGYR    =HBDATE/1000
      BEGDAY   =HBDATE-BEGYR*1000
      IDA      =BEGDAY
      ISNOW    =0
      DO 2 I=1,600
         PMO(I)   =0.0
         PMOG(I)  =0.0
         QP(I)    =0.0
         WU(I)    =0.0
         SEPM(I)  =0.0
         TIRR(I)  =0.0
   2     SWM(I)   =0.0
      SMRG     =0.0
      SYRG     =0.0
      AETINT   =0.0
      TINTET   =0.0
      avlint   =0.0
      SW1      =0.0
      TWV      =0.0
      SNO      =0.0
      atrand   =0.0
      atranm   =0.0
      atrany   =0.0
      aevapd   =0.0
      aevapm   =0.0
      aevapy   =0.0
      ptrand   =0.0
      ptranm   =0.0
      ptrany   =0.0
      pevapd   =0.0
      pevapm   =0.0
      pevapy   =0.0
      DP5      =0
      NDIV     =0
      nreset   =0
C * * INITIALIZE THE 366 ARRAYS * *
      DO 3 I = 1, 366
         TC(I,1) = 0.0
         TC(I,2) = 0.0
   3  CONTINUE
      flgnd = i2kyr( begyr )                                            y2k
      IF (FLGGEN .EQ. 2) THEN
         READ (LUN13,1301) (TC(I,1),I=1,FLGND)
         READ (LUN13,1301) (TC(I,2),I=1,FLGND)
         IF (FLGMET .EQ. 0) THEN
            DO 333 I=1,FLGND
               TC(I,1) = (TC(I,1)-32.0)*5.0/9.0
               TC(I,2) = (TC(I,2)-32.0)*5.0/9.0
 333        CONTINUE
         ENDIF
      ELSE IF (VERMNT .EQ. 1) THEN
         READ (LUN13,1301) (TMEAN(I),I=1,FLGND)
         IF (FLGMET .EQ. 0) THEN
            DO 338 I=1,FLGND
               TMEAN(I) = (TMEAN(I)-32.0)*5.0/9.0
 338        CONTINUE
         ENDIF
      ENDIF
      CALL HYDRIN
      CALL SETONE
c * * * * Adjusting rainfall energy for low intensities at high (North  ei
c         and South latitudes, greater than 45 degrees.  The adjustment ei
c         is based on Seppo Rekolainen work in Finland, except that a   ei
c         constant reduction factor is used instead of changing the     ei
c         coefficient and exponent in the equation.  wgk                ei
      if (rlat .ge. 0.0) then                                           ei
         clat = rlat                                                    ei
      else                                                              ei
         clat = - rlat                                                  ei
      endif                                                             ei
      if (clat .gt. 45.0) then                                          ei
         if (clat .gt. 65.0) then                                       ei
            fac = 0.20                                                  ei
         else                                                           ei
            fac =(0.1462*clat)-(0.001693*clat*clat)-2.149               ei
         endif                                                          ei
      else                                                              ei
         fac = 1.0                                                      ei
      endif                                                             ei
      ALAI     =balone(1)
      aideal   =balone(1)
      sumlai   =begsum
      acclai   =begsum
      croph    =chtone(1)
      IF (BEGDAY .gt. 1) then
         NBDAY = BEGDAY-1
         DO 4 I=1,BEGDAY
            CALL UPDATE(I,ALAI,croph,1.0,0.0,0.0)
 4       CONTINUE
      endif
      call calcdr( begday )
      TU    =9.0*(CONA-3.0)**0.42
      IYR   =BEGYR-1
c      JYR   =MOD(IYR,100)*1000                                          y2k
      JYR   =IYR*1000                                                   y2k
      P1    =200.0*((DACRE/640.)**0.7)*((CHS*5280.0)**0.159)
     1       *(WLW**(-0.187))
c * * *  coefficient .824 == .917 * (1/640)**.0166
      P2    =0.824*DACRE**0.0166
      SP1   =1.0+SIA
      SM1   =1.0-SIA
      DO 8 I=1,NS
         UL(I)     = (SOLPOR(I) - BR15(I)) * DLAY(I)
 8    CONTINUE
      TB15        =0.0
      TAFUL       =0.0
      TAPOR       =0.0
      TFLCAP      =0.0
      ULE         =0.0
      DO 10 I=1,NS
         OM(I)    =HYDOM(I)
         ULE      =ULE+UL(I)
         UF(I)    =UL(I)*FUL(I)
         T(I)     =48.0/(2.0*(UL(I)-uf(i))/satk(i)+24.0)
c         T(I)     =48.0/(2.0*UL(I)/satk(i)+24.0)
         IF (T(I).GT.1.0) T(I)=1.0
         TUF(I)   =UF(I) + (BR15(I) * DLAY(I))                          KH
         FCAP(I)  =((UL(I) / DLAY(I)) * FUL(I)) + BR15(I)               KH
C CONVERT UF FROM IN TO MM AND PASS TO INIPST FOR PRINTING
         FDCPMM(I)=UF(I)*25.4
         TB15     =TB15 + (BR15(I) * DLAY(I))
         TAFUL    =TAFUL + (FUL(I) * DLAY(I))
         TAPOR    =TAPOR + (SOLPOR(I) * DLAY(I))
         TFLCAP   =TFLCAP + TUF(I)
         cul(i)   =ule * 25.4 * taful / botlay(i)
  10  CONTINUE
      ulem = ule * 25.4
      tolsw1 = ulem * .02                                               neg sw1
      u(ns+1) = 0.0
      if (rc .lt. satk(ns)) then
         T(ns+1)  = 48.0/(2.0*(.04*12.)/rc+24.0)
         if (t(ns+1) .gt. 1.0) t(ns+1)=1.0
         ST(ns+1) = .14 * 12.
         uf(ns+1) = .14 * 12.
         ul(ns+1) = .18 * 12.
      else
         T(ns+1)  = 48.0/(2.0*((ul(ns)-uf(ns))*12./dlay(ns))/rc+24.0)
         if (t(ns+1) .gt. 1.0) t(ns+1)=1.0
         ST(ns+1) = st(ns)/dlay(ns)*12.
         uf(ns+1) = uf(ns)/dlay(ns)* 12.
         ul(ns+1) = ul(ns)/dlay(ns)* 12.
      endif

      B15      =TB15/RD
      AFUL     =TAFUL/RD
      APOR     =TAPOR/RD
      FLCAP    =TFLCAP/RD
      RD2      =RD*25.4
      C2       =CN2*CN2
      C3       =CN2*C2
      CN1      =-16.911+1.3481*CN2-0.013793*C2+0.00011772*C3
      SMX      =(1000.0/CN1-10.0)*1.2
      VRT1     =SMX/ULE
      CN22     =95.0
      IF (CN2 .GE. 80.) CN22=98.0
      C22      =CN22*CN22
      C33      =CN22*C22
      CN11     =-16.911+1.3481*CN22-0.013793*C22+0.00011772*C33
      VRT2     =((1000.0/CN11-10.0)*1.2)/ULE
      CRITS    =0.1*ULE*25.4
      DO 20 I=1,NS
         SWADJ(I) =0.0
         ST(I)    =UL(I)*BST*FUL(I)
         SW1      =SW1+ST(I)
         OLDST(I) =ST(I)
         WP(I)    =DLAY(I) * BR15(I)
         SWPER(I) =0.0
         osw(I)    =(ST(I) + WP(I)) * 2.54
         nndp(i)  = 0
         nodp(i)  = 0                                                   y
  20  CONTINUE
      V        =ULE-SW1
      vt       =v
      OTSW     =SW1
      SW1      =SW1*25.4
      SWMIN    =SW1
      SWMAX    =SW1
      MINDAT   =JYR+1
      MAXDAT   =JYR+1
      TUL      =ULE*25.4*AFUL
      IF (FLGMET .EQ. 0) THEN
         WRITE(LUN07,3001) DACRE,RD,RC,AFUL,FLCAP,BST,CONA,APOR,CN2,
     1          CHS,WLW,P1,P2,ULE,B15,OTSW,BSI,TPI
c     1          CHS,WLW,P1,P2,ULE,B15,OTSW
         WRITE(LUN07,3002) (UL(I),    I=1,NS)
         WRITE(LUN07,3003) (ST(I),    I=1,NS)
         WRITE(LUN07,3013) (SOLPOR(I),I=1,NS)
         WRITE(LUN07,3014) (FUL(I),   I=1,NS)
         WRITE(LUN07,3016) (FCAP(I),  I=1,NS)                           KH
         WRITE(LUN07,3011) (TUF(I),   I=1,NS)                           KH
         WRITE(LUN07,3012) (BR15(I),  I=1,NS)
         WRITE(LUN07,3015) (WP(I),    I=1,NS)
      ELSE
         DHECT = DACRE/2.471
         RDMET = RD*2.54
         RCMET = RC*2.54
         ULEMET= ULE*2.54
         OSWMET= SW1/10.
         DO 2003 I=1,NS
            ULMET(I) = UL(I) * 2.54
            STMET(I) = ST(I) * 2.54
            UFMET(I) = TUF(I) * 2.54                                    KH
            WPMET(I) = WP(I) * 2.54
 2003    CONTINUE
         WRITE(LUN07,4001) DHECT,RDMET,RCMET,AFUL,FLCAP,BST,CONA,APOR,
     1          CN2,CHS,WLW,P1,P2,ULEMET,B15,OSWMET,BSI,TPI
c     1          CN2,CHS,WLW,P1,P2,ULEMET,B15,OSWMET
         WRITE(LUN07,4002) (ULMET(I), I=1,NS)
         WRITE(LUN07,4003) (STMET(I), I=1,NS)
         WRITE(LUN07,3013) (SOLPOR(I),I=1,NS)
         WRITE(LUN07,4014) (FUL(I),   I=1,NS)
         WRITE(LUN07,4016) (FCAP(I),  I=1,NS)                           KH
         WRITE(LUN07,4011) (UFMET(I), I=1,NS)
         WRITE(LUN07,4012) (BR15(I),  I=1,NS)
         WRITE(LUN07,4015) (WPMET(I), I=1,NS)
      ENDIF
      IF (FOREST .EQ. 0) THEN                                           FOREST
         WRITE(LUN07,3110)
      ELSE IF (FOREST .EQ. 1) THEN
         WRITE(LUN07,3111)
      ELSE IF (FOREST .EQ. 2) THEN
         WRITE(LUN07,3112)
      ELSE IF (FOREST .EQ. 3) THEN
         WRITE(LUN07,3113) beggro, endgro
      ENDIF
      PORWT = SOLPOR(1)
      OM1   = OM(1)
C//////////////////////////////////////////////////////////////////////
C READ THE INITIAL EROSION PARAMETERS                                 /
C//////////////////////////////////////////////////////////////////////
      CALL EROSA(FLGMET,PORWT,OM1)
      call inisol
      IF (FLGNUT .EQ. 1) CALL ININUT
      IF (FLGPST .GE. 1) CALL INIPST(RD2,HBDATE)
      MOO    =  0
      CHMIRR = 0.0
      CHMET  = 0.0
      FOLIRR = 0.0
      TINT   = 0.0
      XMELTM = 0.0
      XMELTY = 0.0
      INTM   = 0.0
      INTY   = 0.0
      THRUFM = 0.0
      THRUFY = 0.0
      INTETM = 0.0
      INTETY = 0.0
      TOTIRR = 0.0
      nul = ns
      sfn    = 1.0                                                      stress f
      irotyr = 1
      itbg   = 1
      m      = 360
      tbgsum = 0.0
      maxdep = 0
      do 25 i=1, 5
         m = m + 1
         tbg(i) = tc(m,1) + (0.1 * (tc(m,2) - tc(m,1)))
         tbgsum = tbgsum + tbg(i)
25    continue
      IF (BCKEND .GT. 0) THEN
         CALL INIBCK
         CALL BCKCON
      ENDIF
C * * YEARLY LOOP,50 YEAR MAXIMUM
      DO 340 IY=1,50
         WRITE (*, 21)IY
21       FORMAT(20X,'BEGINNING YEAR ',I4,' OF SIMULATION')
         AIRR     =0.
         IF (HYDOUT.EQ.1) THEN
            IF (FLGMET .EQ. 0) THEN
               WRITE (LUN07,3000)
            ELSE
               WRITE (LUN07,5000)
            ENDIF
         ENDIF
         IYR      =IYR+1
c        write (*, 1)  iyr,i2kyr(iyr)                                    y2k
c 1      format(i5,' has ',i4, ' days')                                  y2k
         NYEAR    =IYR
         JYR      =JYR+1000
         ND       = i2kyr(iyr)                                          y2k
         NBDATE   =HBDATE + 1
C         IF (FLGGEN .EQ. 1) GO TO 22
         READ (LUN01,1000) (R(I),I=1,ND)
         IF (FLGMET .EQ. 1) THEN
            DO 2001 I=1,ND
               R(I) = R(I)/2.54
 2001       CONTINUE
         ENDIF
         do 28 i=1, 12
            nwd(i) = 0.0
 28      continue
         do 29 i=1, nd
            if (r(i) .gt. 0.) then
               mo = wchmon(jyr+i)
               nwd(mo) = nwd(mo) + 1
            endif
 29      continue
         if (nd .gt. 365) then
            moday(2) = 29
         else
            moday(2) = 28
         endif
         do 31 i=1,12
            wft(i) = nwd(i) / moday(i)
 31      continue
C          GO TO 23
C 22       CALL           (R)
C 23       CONTINUE
C * *  DAILY LOOP
         DO 300 I=1,ND
C  IDAY IS FOR IRRIGATION
C ** INITIALIZE CODES: IRAIN=0; IIR=0
            IRAIN = 0
            IIR   = 0
            IDAY=I
            JDATE    =JYR+I
            CALL ENDDMY( I )
            DO 1111 MII=1,NS+1
               SWPER(MII)=0.
 1111       CONTINUE

cc sum lai for growing crop (icindx(i))
c            sumlai = sumlai + alai
c            acclai = acclai + aideal
            beggro = ibegro(i)
            endgro = iendro(i)
c is crop same one growing yesterday? if not, zero out sum of crop lai
            if (icindx(i) .gt. 2000  .or.  icindx(i) .eq. 0) then
                 if (icindx(i) .eq. 0) then
                    sumlai = 0.0
                    alai   = 0.0
                    aideal = 0.0
                    croph  = 0.0
                 else
                    sumlai = alai
                    acclai = aideal
                 endif
                 call calcdr( i )
                 maxdep = 0
                 if (icindx(i) .gt. 2000) then
                    mii = icindx(i) - 2000
                    if (ioldcp .gt. 0) then
                    if (pernnl(mii).gt.0 .and. pernnl(ioldcp).gt.0) then
                       maxdep = 1
                    endif
                    endif
                 endif
            endif
            NN       =NMONTH+MOO
            IF (IYR.LE.BEGYR.AND.I.LT.BEGDAY) GO TO 270
            RAIN     = 0.0
            QL       =0.0
            UWL      =0.0
            QD       =0.0
            Qxir     =0.0
            IF (VERMNT .EQ. 0) THEN
               CALL SNOW(SNO, I, (TC(I,2)+TC(I,1))/2.0, PIN)
            ELSE IF (VERMNT .EQ. 1) THEN
               CALL SNOW(SNO,I,TMEAN(I),PIN)
            ENDIF
            IF (SNO .GT. 0.0) ISNOW =1
            CALL WADNUT( I, ALAI )
C * * * * New frozen soil begins here, using soil temp., 8/29/95 wgk    soilT
C * * * * Frozen soil changed for Finland                               soilT
C * * * * Checks minimum soil temp in soil layers    2  & 3 for frozen  soilT
            IF (iyr .eq. begyr .and. i .eq. begday) THEN
               ftemp1 = tc(1,1)
            else
c               ftemp1 = amin1 (tsc(2), tsc(3) )
               ftemp1 = tsc(2)
               do 8888 lmno=3,ns
                  if (tsc(lmno) .lt. ftemp1) ftemp1 = tsc(lmno)
 8888          continue
            ENDIF
            IF (ftemp1 .Lt.  0.0) THEN
               ictfrz = ictfrz + 1
               if (ictfrz .gt. nfzday) ictfrz = nfzday
            ELSE
               ictfrz = ictfrz - 1
               if (ictfrz .lt. 0) ictfrz = 0
            ENDIF
C * * * New frozen soil ends here
            IF (REFF .LE. 0.0) GO TO 40
            JJ       =JJ+1
            SMR      =SMR+REFF
            SMRG     =SMRG + GROSSR
            PMO(NN)  =PMO(NN)+REFF
            IF (FLGMET .EQ. 0) THEN
               PMOG(NN) =PMOG(NN) + GROSSR
            ELSE
               PMOG(NN) =PMOG(NN) + GROSSR * 2.54
            ENDIF
            QD       =0.0
            qxir     =0.0
            SUM      =0.0
            DO 30 K=1,NS
               SUM      =SUM+WF(K)*ST(K)/UL(K)
  30        CONTINUE
            IF (Forest .lt. 1) THEN
               if (ictfrz .gt. 0 .or. tsc(1) .lt. 0.) then
                  BBCOEF  =.005
                  VRTUSE  =VRT2
                  noirr(i)=0
               else
                  BBCOEF  =SIA
                  VRTUSE  =VRT1
               endif
            ELSE
               BBCOEF  =SIA
               VRTUSE  =VRT1
            ENDIF
            WV       =ULE*(1.0-SUM)
            WV       =WV*VRTUSE
            TWV      =TWV+WV
            R1       =WV/SP1
            VT       =VT+V
            BB       =BBCOEF*R1
            PB       =REFF-BB
            IF (PB.LE.0.0) GO TO 40
            QD       =PB*PB/(REFF+SM1*R1)
            IF (QD.LT.0.0001) QD=0.0
            QL       =QL+QD
  40        CONTINUE
            IF (V.LT.VL) GO TO 50
            IF (V.LT.VB) GO TO 60
            VB       =V
            GO TO 60
  50        CONTINUE
            VL       =V
  60        CONTINUE
            RAIN     =(REFF-QD)*25.4
            IDA      =I
C ** IF RAINFALL OCCURS, SET IRAIN CODE=1
            IF (REFF .GT. 0.0) IRAIN = 1
C
            IF (IRCODE .EQ. 1 .OR. CHMIRR .GT. 0.0) THEN
               SUMADJ=0.0
               DO 2222 J=1,NS
C                  SW1=SW1+SWADJ(J)*25.4
                  SUMADJ=SUMADJ+SWADJ(J)
                  st(j) = st(j) + swadj(j)
                  swadj(j) = 0.0
2222           CONTINUE
               SW1=SW1+SUMADJ*25.4
            ELSE
               DO 2221 J=1,NS
                  SWADJ(J)=0.0
2221           CONTINUE
            ENDIF
c * * * csw(j) = cumulative soil water by layer.
c              if (noirr(i) .gt. 0) then
               cswj = 0.0
               do 62 j=1,ns
                  cswj = cswj + st(j) * 25.4
                  csw(j) = cswj
62             continue
c            endif
              if (iyr .eq. begyr .and. i .eq. begday) then
                 ftemp = tc(1,1)
              else
                 ftemp = (tsc(1) + tsc(2)) / 2.
              endif
            CALL EVAP(POTET,ALAI,ATRN,PTRN,PIRR,IRFLG,IROPT,ftemp)
            potpev = ptrn
            ES = ES + CHMET * 10.0
            IF (ALAI .GE. 3.0) THEN
               WSHTHR = 0.30
            ELSE
               WSHTHR = 0.10 * ALAI
            ENDIF
            RIRR     =PIRR/25.4
            IF (IRCODE .EQ. 1) THEN
               CHMIRR = RIRR
            ENDIF
C ** IF IRRIGATION OCCURS, SET IIR CODE=1
            IF (RIRR .GT. 0.0) THEN
               IIR = 1
C                WIRR= RIRR
               WIRR= RIRR * 2.54
            ELSE
               WIRR= 0.0
            ENDIF
C IRRIGATION LAYER-BY-LAYER, IF APPLIED IN EVAP
65          UW     = UW/25.4 + CHMET / 2.54
            CHMET = 0.0
            UWL      =UWL+UW
            DO 70 K=1,NS
               U(K)     =0.0
70          CONTINUE
            F        =REFF-QD
c  here
c * * * Assume that if there is frozen soil, there is no irrigation
c      IF (NFRZ .GE. 1 .and. Forest .lt. 1 .or. rirr .le. 0.0) goto 970
        IF (rirr .le. 0.0) goto 970
            if (reff .le. 0.0) then
               WV       =ULE*(1.0-SUM)
               WV       =WV*VRT1
               TWV      =TWV+WV
               R1       =WV/SP1
               VT       =VT+V
            endif
            BB       =sia * R1
            PB       =Rirr - BB
            IF (PB.LE.0.0) GO TO 940
            Qxir     =PB*PB/(Rirr+SM1*r1)
            IF (Qxir.LT.0.0001) Qxir=0.0
            QL       =QL + Qxir
            sw1      =sw1 - qxir*25.4

c * * * Frank's sw1 test... uncomment to use.. april 26, 1999
c            if (sw1 .lt. 0.0) then
c               tempo = 0.0
c               do 941 k=1, ns
c                  tempo = tempo + st(k) * 25.4
c941            continue
c               diff = tempo - sw1
c               if (diff .le. uw) then
c                  uw = uw - diff
c                  if (diff .le. ep) then
c                     ep = ep - diff
c                  else
c                     diff = diff - ep
c                     ep = 0.0
c                     es = es - diff
c                  endif
c                  ATRN     =EP/25.4
c                  sw1 = tempo
c               endif
cc               write(*,2046) sw1,tempo,uw,i,iyr
cc2046           format(' SW1 less than 0 sw1=',3f10.6,2i5)
cc               stop
c            endif
940         CONTINUE                                                    irr ro
            IF (V.LT.VL) GO TO 950
            IF (V.LT.VB) GO TO 960
            VB       =V
            GO TO 960
950         CONTINUE
            VL       =V
960         CONTINUE
            IF (IRFLG .EQ. 1) F=F+RIRR-qxir
970         continue
c to here
            IF (ALAI .le. 0.0 .or. potlai(i) .le. 0.0) then
               SPG  = 0.0
               ubalnc = uw
               do 83 j=1,ns
                  if (ubalnc .gt. st(j)) then
                     u(j) = st(j)
                     ubalnc = ubalnc - u(j)
                  else
                     u(j) = ubalnc
                     ubalnc = 0.0
                     goto 84
                  endif
83             continue
84             continue
               if (ubalnc .gt. 0.0) then
                  u(1) = u(1) + ubalnc
               endif
c               U(1) = UW
               nul = ns
            else
c              SPG  = SPG+EPP(I)/PWU
               SPG  = sumlai/potlai(i)
               do 80 j=1, ns
                  if ((spg .le. dratio(j)) .or. (j .eq. ns)) then
                     nul = j
                     goto 81
                  endif
80             continue
81             continue
               if (forest .gt. 0) then
                  nul = ns
               else if (maxdep .gt. 0) then
                  nul = iccrd(i)
               endif
               U0B  = (UW*ub)/(1.0-EXP(-UB*botlay(nul)))
               sum = 0.0
               uu  = u0b / ub
               do 90 j=1,nul-1
                  if (j .eq. 1) then
                     u(j) = uu * (1 - exp( -ub * botlay(j) ))
                  else
                     u(j) = uu *
     &                (exp( -ub*botlay(j-1) ) - exp( -ub*botlay(j) ))
                  endif
                  sum = sum + u(j)
90             continue
               u(nul) = uw - sum
            endif
            ST(1)  = ST(1)+F-U(1)
            sepout = 0.0
            DEF    = 0.0
            runsep = 0.0
            IF (ST(1) .LT. 0.0) then
               DEF   = -ST(1)
               ST(1) = 0.0
            else IF (ST(1) .ge. UF(1)) then
               sepout = (ST(1)-UF(1))*T(1)
               ST(1)  = ST(1)-sepout
c if more water than porosity then water goes to runoff
               IF (ST(1) .gt. UL(1)) then
                  qd     = qd + ST(1) - UL(1)
                  runsep = st(1) - ul(1)
                  ST(1)  = UL(1)
               endif
               SWPER(1) = sepout
               if (swper(1) .gt. 0.0) nndp(1) = 1
            endif
            DO 180 K=2,NS+1
               sepin  = sepout
               ST(K)  = ST(K) + sepin - U(K)
               sepout = 0.0
               IF (ST(K).LT.0.0) then
                  DEF    = DEF-ST(K)
                  ST(K)  = 0.0
c  else if more water than field capacity then perc it
               else if (ST(K) .ge. UF(K)) then
                  sepout = (ST(K)-UF(K))*T(K)
                  ST(K)  = ST(K) - sepout
c  if all water can't perc out then shove to layer above
                  IF (ST(K) .gt. UL(K)) then
                     sepin = st(k) - ul(k)
                     ST(K)  = UL(K)
                     do 100 j=k-1,1,-1
c  while water is greater than porosity keep shoving it up
                        if (sepin .gt. 0.0) then
                           st(j) = st(j) + sepin
                           swper(j) = swper(j) - sepin
                           if (st(j) .gt. ul(j)) then
                              sepin = st(j) - ul(j)
                              st(j) = ul(j)
                              if (j .eq. 1) then
c  if still have more water at top layer then add it runoff
                                 qd = qd + sepin
                                 runsep = runsep + sepin
                                 sepin = 0.0
                              endif
                           else
                              sepin = 0.0
                              goto 101
                           endif
                        endif
100                  continue
101                  continue
                  endif
                  SWPER(K) = sepout
               endif
               if (swper(k) .gt. 0.0) nndp(k) = 1
 180        CONTINUE
c            sep = sepout
            sep = swper(ns)
            DO 200 K=1,NS
               IF (ST(K).LE.0.0) GO TO 200
               IF (DEF.GT.ST(K)) GO TO 190
               ST(K)    =ST(K)-DEF
               GO TO 210
 190           CONTINUE
               DEF      =DEF-ST(K)
               ST(K)    =0.0
 200        CONTINUE
 210        CONTINUE
            IF (REFF .LE. 0.0 .AND. RIRR .LE. 0.0) GO TO 214
            UP(1)        =OLDST(1)-ST(1)+F-SWPER(1)
            IF (UP(1) .LE. 0.0) UP(1)=0.0
            GO TO 430
 214        UP(1)        =OLDST(1)-ST(1)
C ** NO RAIN AND NO IRRIGATION--NO CODE CHANGE
 430        CONTINUE
            DO 440 K=2,NS
               IF (REFF .GT. 0.0 .OR. RIRR .GT. 0.0) GO TO 450
               UP(K)     =OLDST(K)-ST(K)
               GO TO 440
 450           UP(K)    =OLDST(K)-ST(K)+SWPER(K-1)-SWPER(K)
               IF (UP(K) .LE. 0.0) UP(K)=0.0
 440           CONTINUE
            DO 211 K=1,NS
               OLDST(K) = ST(K)
 211           CONTINUE
            SW1   =SW1-SEP*25.4-runsep*25.4

c * * * fmd, wgk  test for sw1 lt or gt 2% total ul
            tempo = 0.0
            DO 2047 K=1,NS
               tempo = tempo + ST(K) * 25.4
2047        CONTINUE
            diff = tempo - sw1
            if (diff .lt. -tolsw1 .or. diff .gt. tolsw1) then
               write(*,2048) sw1,i,iyr
2048           format(' SW1 not equal st.  sw1=',f10.6,2i5)
               stop
            endif
              if (sw1 .le. -0.05) then                                  wkgoss
                 write(*,2044) sw1
2044             format(' SW1:  negative in hydone.  sw1=',f10.6)
                 stop
              endif
            ql    = ql + runsep
            SXSP  =SXSP+SEP+ADDSEP
c * * * save percolation before sep is zeroed out (if sep < .01 sep = 0)
            percol = sep
            IF (SEP.LT.0.0001) SEP=0.0
            IF (SEP.GT.0.0) DP5=DP5+1
            IF (SW1.GE.SWMIN) GO TO 220
            SWMIN    =SW1
            MINDAT   =JYR+I
 220        CONTINUE
            IF (SW1.LE.SWMAX) GO TO 230
            SWMAX    =SW1
            MAXDAT   =JYR+I
 230        CONTINUE
            V        =(ULEm-SW1)/25.4
            IF (QL.LT.0.0001) GO TO 240
            PR       =P1*QL**P2
            SPR      =SPR+PR
            SSPR     =SSPR+PR*PR
            NPR      =NPR+1
C PASS2 IS THE RUNOFF COMPONENT IN THE HYDROLOGY MODEL
            PASS2    =QL
C PASS3 = PEAK DISCHARGE VARIABLE (HYDROLOGY) EXRAIN = (ERSION MODEL)
            PASS3    =0.991*PR/DACRE
C            QPEAK =   PASS3
            IF (PASS3.GE.0.0001) GO TO 250
 240        CONTINUE
            QL       =0.0
            PASS2    =0.0
            PASS3    =0.0
C            QPEAK    =0.0
 250        CONTINUE
            IF (IRCODE .LT. 1) THEN
               TIRR(NN) =TIRR(NN)+RIRR + CHMIRR
            ELSE IF (IRCODE .EQ. 1) THEN
               TIRR(NN) = TIRR(NN) + RIRR
            ENDIF
            pass1b   = pass1b + REFF + RIRR + CHMIRR
            pass2b   = pass2b + ql
            PASS5b   =PASS5b  + SEP + ADDSEP
            SMQ      =SMQ+QL
            QP(NN)   =QP(NN)+QL
            WU(NN)   =WU(NN)+UWL
            SEPM(NN) =SEPM(NN)+SEP+ADDSEP
            SWM(NN)  =SWM(NN)+SW1/25.4
            NDIV     =NDIV+1
            TMWU     =TMWU+UWL
            IDA      =I+1
            NORAIN   =NORAIN+1
            QPEAK    =PASS3
C PASS5 IS THE PERC OUT OF THE BOTTOM LAYER OR PERC(NS)
            PASS5    =PASS5+SEP+ADDSEP
            PERCOL   =percol+ADDSEP
C CONVERT TEMP C INTO TEMP F FOR THE OUTPUT ONLY.
            IF (VERMNT .EQ. 0) THEN
               PASS6 =PASS6 + ((TC(I,1)+TC(I,2))*0.5 * 1.8 + 32.)
               dailyt = (TC(I,1) + TC(I,2)) * 0.5
            ELSE IF (VERMNT .EQ. 1) THEN
               PASS6 =PASS6 + (TMEAN(I) * 1.8 + 32.)
               dailyt = tmean(I)
            ENDIF
            avgtmp   =((pass6/norain)-32.)/1.8
            PASS7    =PASS7+SW1/RD2+B15
            avgswc   =pass7 / norain
            stmtmp   = pass6/float(norain)
            stmswc   = pass7/float(norain)

            PASS8    = PASS8  + ATRN
            ACCPEV   = ATRN
            atrand   = ATRN
            PASS8B   = PASS8B + ATRN
            PASS9    = PASS9  + PTRN
            PASS9B   = PASS9B + PTRN
            ptrand   = ptrn
            PASS10   = ES     / 25.4
            ACCSEV   = PASS10
            aevapd   = PASS10
            PASS11   = EOS    / 25.4
            pevapd   = PASS11
            solevp   = solevp + es/10.
            potevp   = potevp + eos/10.
            PAS10B   = PAS10B + PASS10
            PAS11B   = PAS11B + PASS11
            PAS12B   = PASS8B + PAS10B
            PAS13B   = PASS9B + PAS11B
            TINT     = TINT   + INTCEP
            TINTET   = PAS12B + TINT
            INTET    = INTCEP + ATRN   + PASS10
C  NO RAIN AND NO IRRIGATION AND NO CHEMIGATION...BY-PASS TO 270
C  IRRIGATION...ADD TO SUM, ZERO EI
            IF (IRFLG.NE.1 .AND. CHMIRR .LE. 0.0) GO TO 255
            AIRR     =AIRR + RIRR + CHMIRR
            PASS4    =0.
            DEI      =0.
255         continue
            PASS1    =REFF+RIRR+CHMIRR
            DRAIN    =PASS1
            IF (REFF.GT.0.) GO TO 256
            PASS4    =0.
            DEI      =0.
            GO TO 257
256         PASS4    =7.87*(REFF-xmelt)**1.51
            pass4 = pass4 * fac                                         ei
            DEI      =PASS4
 257        CONTINUE
C * * CALCULATE THE AVE.TEMP FOR THE PERIOD BETWEEN EVENTS
            IF (REFF .GT. 0.0 .OR. PASS1 .GT. 0.0 .OR.
     &                        CHMIRR .GT. 0.0 .OR. IRFLG .GT. 0) THEN
               PASS6    =PASS6/FLOAT(NORAIN)
               PASS7    =PASS7/FLOAT(NORAIN)
            ENDIF
            TSWC=0.0
            DO 258 KI=1,NS
               TST(KI)=ST(KI) + WP(KI)
               TSWC=TSWC+TST(KI)
 258        CONTINUE
C  PRECIP, IRR, OR BOTH, OR CHEMIGATE..WRITE PASS
            P7=TSWC/RD
            IF (FLGMET .EQ. 1) THEN
               UW      = UW      * 2.54
               PERCOL  = PERCOL  * 2.54
            ENDIF

            REFF  = REFF  + INTCEP                                      FOREST
            PASS1 = PASS1 + INTCEP                                      FOREST
            IF (FLGMET .EQ. 1) THEN
               REFF    = REFF    * 2.54
               PASS1   = PASS1   * 2.54
               PASS2   = PASS2   * 2.54
               PASS5   = PASS5   * 2.54
               PASS6   = (PASS6 - 32.) * 5. / 9.
               PASS7   = PASS7   * 2.54
               PASS8B  = PASS8B  * 2.54
               PASS9B  = PASS9B  * 2.54
               PAS10B  = PAS10B  * 2.54
               PAS11B  = PAS11B  * 2.54
               PAS12B  = PAS12B  * 2.54
               PAS13B  = PAS13B  * 2.54
               RIRR    = RIRR    * 2.54
               CHMIRR  = CHMIRR  * 2.54
               TINT    = TINT    * 2.54                                 FOREST
               TINTET  = TINTET  * 2.54                                 FOREST
            ENDIF

            IF (REFF .LE. 0.0 .AND. IRFLG .LT. 1 .AND.
     &             CHMIRR .LE. 0.0 .AND. IFOL .EQ. 0) GO TO 270
C  NO OUTPUT NEEDED...BY-PASS TO 270
            nreset = 1

c
c *** the flgmet conversion was here--frank oct 23, 2001 -- moved up there
c
            IF (HYDOUT.NE.1) GO TO 270

C  BY-PASS TO 262 IF BOTH PRECIP AND IRR OCCUR

            IF (REFF.GT.0. .AND. IRFLG.EQ.1 ) GO TO 262
C * * IRRIGATION/CHEMIGATION ONLY
            IF (IRFLG .NE. 1 .AND. CHMIRR .LE. 0.0 .AND. IFOL .EQ. 0)
     &          GO TO 268
            IF (IRCODE .EQ. 0 .AND. CHMIRR .GT. 0.0) THEN
               RIRR = CHMIRR
               WRITE(LUN07,3339)JDATE,PASS2,PASS5,PASS6,PASS7,PASS8B,   FOREST
     1                          PASS9B,PAS10B,PAS11B,PAS12B,PAS13B,
     1                          TINT,TINTET,RIRR,CHMIRR
               CHMIRR = 0.0
 3339          FORMAT(2x,I7, 9X,13F8.2,F6.2,'*')                        y2k
            ELSE IF (IFOL .EQ. 1) THEN
               WRITE(LUN07,7009)JDATE,PASS2,PASS5,PASS6,PASS7,PASS8B,   FOREST
     &                           PASS9B,PAS10B,PAS11B,PAS12B,PAS13B,
     &                           TINT,TINTET,FOLIRR
 7009          FORMAT(2x,I7,9X,12F8.2,8X,F6.2,'#')                      y2k
               FOLIRR = 0.0
            ELSE
               WRITE(LUN07,3009)JDATE,PASS2,PASS5,PASS6,PASS7,PASS8B,   FOREST
     1                          PASS9B,PAS10B,PAS11B,PAS12B,PAS13B,
     1                          TINT,TINTET,RIRR
 3009          FORMAT(2x,I7,9X,13F8.2)                                  y2k
            ENDIF
            GO TO 999
C * *  RAIN ONLY
 268        WRITE (LUN07,3008) JDATE,PASS1,PASS2,PASS5,PASS6,PASS7,     FOREST
     1                      PASS8B,PASS9B,PAS10B,PAS11B,PAS12B,PAS13B,
     1                      TINT,TINTET
            GO TO 999
C * * BOTH RAIN AND IRR
262         IF (CHMIRR .LE. 0.0) THEN
               WRITE (LUN07,3010)JDATE,REFF,PASS2,PASS5,PASS6,PASS7,    FOREST
     1                      PASS8B,PASS9B,PAS10B,PAS11B,
     &                      PAS12B, PAS13B,TINT,TINTET,RIRR
 3010          FORMAT(2x,I7,1X,14F8.2)                                  y2k
            ELSE IF (IFOL .EQ. 1) THEN
               WRITE(LUN07,888) JDATE,REFF,PASS2,PASS5,PASS6,PASS7,     FOREST
     &                          PASS8B,PASS9B,PAS10B,PAS11B,PAS12B,
     &                          PAS13B,TINT,TINTET,RIRR,FOLIRR
 888           FORMAT(2x,I7,1X,14F8.2,F6.2,'#')                         y2k
               FOLIRR = 0.0
            ELSE
               RIRR=CHMIRR
               WRITE (LUN07,3310)JDATE,REFF,PASS2,PASS5,PASS6,PASS7,    FOREST
     1                      PASS8B,PASS9B,PAS10B,PAS11B,
     &                      PAS12B, PAS13B,TINT,TINTET,RIRR,CHMIRR
 3310          FORMAT(2x,I7,1X,14F8.2,F6.2,'*')                         y2k
               CHMIRR = 0.0
            ENDIF
 999        CONTINUE
 270        CONTINUE
            IF (FLGMET .EQ. 1) THEN
c               REFF    = REFF    / 2.54
c               PASS8B  = PASS8B  / 2.54
c               PASS9B  = PASS9B  / 2.54
c               PAS10B  = PAS10B  / 2.54
c               PAS11B  = PAS11B  / 2.54
c               PAS12B  = PAS12B  / 2.54
c               PAS13B  = PAS13B  / 2.54
c               TINT    = TINT    / 2.54
c               TINTET  = TINTET  / 2.54
               REFF    = REFF    / 2.54
               PASS1   = PASS1   / 2.54
               PASS2   = PASS2   / 2.54
               PASS5   = PASS5   / 2.54
               PASS6   = PASS6 * 1.8 + 32.
               PASS7   = PASS7   / 2.54
               PASS8B  = PASS8B  / 2.54
               PASS9B  = PASS9B  / 2.54
               PAS10B  = PAS10B  / 2.54
               PAS11B  = PAS11B  / 2.54
               PAS12B  = PAS12B  / 2.54
               PAS13B  = PAS13B  / 2.54
               RIRR    = RIRR    / 2.54
               CHMIRR  = CHMIRR  / 2.54
               TINT    = TINT    / 2.54                                 FOREST
               TINTET  = TINTET  / 2.54                                 FOREST
            ENDIF
            IF (IEOMY .GE. 2) THEN
               NBMO     =NBMO+1
               IF (NDIV .NE. 0) THEN
                  SWM(NN)  =SWM(NN)/FLOAT(NDIV) + TB15                  KH
                  NDIV     =0
               ENDIF
               SYR    = SYR + SMR
               SYQ    = SYQ + SMQ
               TYWU   = TYWU + TMWU
               TMWU   = 0.0
               SMR    = 0.0
               SMQ    = 0.0
               SYRG   = SYRG + SMRG
               SMRG   = 0.0
            ENDIF
C SUB EROSB IS THE DAILY EROSION CALCULATION MODEL
            IF (VERMNT .EQ. 0) THEN
               TEMPC=(TC(I,1)+TC(I,2))/2.
            ELSE IF (VERMNT .EQ. 1) THEN
               TEMPC=TMEAN(I)
            ENDIF
            atp = tempc
            CALL EROSB (SOLOSS,ENRICH,FLGMET,TEMPC,BCKEND)
            CALL CALCET
            CHMIRR = 0.0
            IRCODE = 0
            ADDSEP = 0.0
            IFOL   = 0
            FOLIRR = 0.0
            NROUTE = 0
            DO 1110 J=1,NS
               IF (SWPER(J) .GT. 0.) THEN
                  NROUTE = J
                  GOTO 1112
               ENDIF
1110        CONTINUE
1112        CONTINUE
            IF (drain .GT. 0.0) THEN
               NSTRMS = NSTRMS+1
               TPRECP = TPRECP+drain*2.54
            ENDIF
            IF (SOLOSS .GT. 0.0) THEN
               NSEDS = NSEDS + 1
               TSEDS = TSEDS + ((SOLOSS*48808.98) / 1000.)
            ENDIF
            IF (ql .GT. 0.0) THEN
               NRNFFS = NRNFFS+1
               TRUNFF = TRUNFF+ql*2.54*12.0
            ENDIF
            IF (PERCOL .GT. 0.0) THEN
               NPERCS = NPERCS+1
                 if (flgmet .eq. 0) then
                    TPERCL = TPERCL+PERCOL*2.54
                 else
                    TPERCL = TPERCL+PERCOL
                 endif
            ENDIF
            ADDSEP   = 0.0
ccccccccccccccccccccccccccccccccccccccccccccccccccccc   wgk Aug. 11, 1994
              if (potlai(i) .le. 0.0) then
                 sgrt = 0.0
              else
                 sgrt = sumlai / potlai(i)
              endif
              if (flgnut .eq. 0) then
                 if (icrop .gt. 78) then
                    DM   = 4000.0 * SGRT
                    cv = dm
                 else
                    if (icrop .eq. 0) then
                       dm = 0.0
                    else
                       if (dmy(icrop) .le. 0.0) then
                          DM   = YP(ICROP) * SGRT
                       else
                          DM   = YP(ICROP) * SGRT * DMY(ICROP)
                       endif
                    endif
                    cv = dm * 0.75
                 endif
              else
                 if (icrop .eq. 0) then
                    dm = 0.0
                 else
                    if (dmy(icrop) .le. 0.0) then
                       DM   = YP(ICROP) * SGRT
                    else
                       DM   = YP(ICROP) * SGRT * DMY(ICROP)
                    endif
                 endif
                 cv = resdw + dm * 0.75
              endif
            call soilt(i, cv)
            IF (FLGPST .EQ. 1 .and. jdate .ge. pbdate+1 .and.
     &        jdate.le.pedate)CALL PSTCAL(IRAIN,IIR,CHMIRR,IRCODE,IFOL)
            IF (FLGNUT .EQ. 1 .and. (IYR .Gt. BEGYR .or.
     &        I.GE.BEGDAY)) CALL NUTCAL( FLGpst,pass8,pass9,nul,chmirr)
            if (flgpst .eq. 1 .or. flgnut .eq. 1) call pnout
            IF (nreset .ne. 0 ) then
               nreset   =0
               NORAIN   =0
               DP5      =0
               PASS5    =0.0
               PASS6    =0.0
               TEMPF    =0.0
               PASS7    =0.0
               PASS8    =0.0
               PASS9    =0.0
               solevp   =0.0
               potevp   =0.0
               AVESLW   =0.0
            endif
            IF (BCKEND .GT. 0) THEN
               IF (FLGMET .EQ. 1) THEN
                  XMELT  = XMELT  * 2.54
                  THRUFL = THRUFL * 2.54
                  INTCEP = INTCEP * 2.54
                  INTET  = INTET  * 2.54
                  atrand = atrand * 2.54
                  ptrand = ptrand * 2.54
                  aevapd = aevapd * 2.54
                  pevapd = pevapd * 2.54
               ENDIF
               XMELTM = XMELTM + XMELT
C               INTCM  = INTCM  + INTCEP
               THRUFM = THRUFM + THRUFL
               INTETM = INTETM + INTET
               atranm = atranm + atrand
               ptranm = ptranm + ptrand
               aevapm = aevapm + aevapd
               pevapm = pevapm + pevapd
               IF (IEOMY .GE. 2) THEN
                  XMELTY = XMELTY + XMELTM
                  INTY   = INTY   + INTM
                  THRUFY = THRUFY + THRUFM
                  INTETY = INTETY + INTETM
                  atrany = atrany + atranm
                  ptrany = ptrany + ptranm
                  aevapy = aevapy + aevapm
                  pevapy = pevapy + pevapm
               ENDIF
               CALL BCKCOD
               J = 0
               DO 295 K=1, 20
                  IF (IBACK(K) .LE. 2000) J = 1
                  IF (IBACK(K).gt.10000 .and. iback(k).lt.20000) J = 1
295            CONTINUE
               IF (J .GT. 0) THEN
                  CALL BCKDLY
               ENDIF
               DO 296 K=1, 20
                  IF (IBACK(K).GE.2001 .AND. IBACK(K).LE.3000) J = 1
                  IF (IBACK(K).GE.20000 .AND. IBACK(K).LE.30000) J = 1
296            CONTINUE
               IF (IEOMY .GE. 2) THEN
                  IF (J .GT. 0 .AND. I .NE. ND) THEN
                     CALL BCKMLY
                  ENDIF
                  IF (I .NE. ND) THEN
                     CALL EROEOM
                     XMELTM = 0.0
                     INTM   = 0.0
                     THRUFM = 0.0
                     INTETM = 0.0
                     atranm = 0.0
                     ptranm = 0.0
                     aevapm = 0.0
                     pevapm = 0.0
                  ENDIF
               ENDIF
            ENDIF
c save today's crop code for use tomorrow
            ioldcp = icindx(i)
            if (ioldcp .gt. 2000) ioldcp = ioldcp - 2000
            CALL UPDATE(I,ALAI,croph,SW1,CRITS,h2osf)
            sumlai = sumlai + alai
            acclai = acclai + aideal
            if (icindx(i) .gt. 2000  .or.  icindx(i) .eq. 0) then
               if (icindx(i) .eq. 0) then
                  sumlai = 0.0
                  alai   = 0.0
                  aideal = 0.0
                  croph  = 0.0
               else
                  sumlai = alai
                  acclai = aideal
               endif
            endif
c sum lai for growing crop (icindx(i))
            DO 299 KI=1,NS
               osw(ki)=TST(KI)
 299        CONTINUE
c      READ (*,6660) YN                                                  pass8b
c6660  FORMAT (A1)                                                       pass8b
 300     CONTINUE
         SR     =SR+SYR
         SRG    =SRG+SYRG
         SQ     =SQ+SYQ
         TWU    =TWU+TYWU
         SSXSP  =SSXSP+SXSP
         PSW    =SW1/25.4
c         ALAI   =ALONE
         CALL ANNBUD(IYR,PASS8B,PAS10B)
         TOTIRR =TOTIRR+AIRR
         READ (LUN02,2010) NEWT,NEWR,neww,newd
C * * CHECK FOR THE END OF THE SIMULATION, IF IT IS SET JDATE TO 0 AND
C * * GO TO THE END OF THE PROGRAM
         IF (NEWT.LT.0) THEN
            JDATE  =  0
            GO TO 350
         ENDIF
         IF (BCKEND .GT. 0) THEN
            DO 396 K=1, 20
               IF (IBACK(K).GE.2001 .AND. IBACK(K).LE.3000) J = 1
               IF (IBACK(K).Gt.30000) J = 1
396         CONTINUE
            IF (J .GT. 0) THEN
               CALL BCKMLY
            ENDIF
            CALL EROEOM
            CALL BCKANN
              XMELTM = 0.0
              INTM   = 0.0
              THRUFM = 0.0
              INTETM = 0.0
              atranm = 0.0
              ptranm = 0.0
              aevapm = 0.0
              pevapm = 0.0
         ENDIF
         IF (FLGGEN.EQ.2) THEN
            flgnd = i2kyr( iyr+1 )                                      y2k
            READ (LUN13,1301) (TC(IKJ,1),IKJ=1,FLGND)
            READ (LUN13,1301) (TC(IKJ,2),IKJ=1,FLGND)
            DO 334 IKJ=1,FLGND
               TC(IKJ,1)=(TC(IKJ,1)-32.0)*5./9.
               TC(IKJ,2)=(TC(IKJ,2)-32.0)*5./9.
 334        CONTINUE
         ELSE IF (VERMNT .EQ. 1) THEN
            flgnd = i2kyr( iyr+1 )                                      y2k
            READ (LUN13,1301) (TMEAN(I),I=1,FLGND)
            IF (FLGMET .EQ. 0) THEN
               DO 339 I=1,FLGND
                  TMEAN(I) = (TMEAN(I)-32.0)*5.0/9.0
 339           CONTINUE
            ENDIF
         ENDIF
         IF (NEWT.EQ.1) CALL GETTMP
         IF (NEWR.EQ.1) call getrad
         IF (NEWw.EQ.1) call getwnd
         IF (NEWd.EQ.1) call getdew
C         IF (FLGGEN .EQ. 1) GO TO 315
c         IF (NEWL.EQ.0) GO TO 330
c         CALL GETLAI
c         ALAI     =ALONE
330      CONTINUE
         irotyr = irotyr + 1
         call rdlai( irotyr )
c         IF (NEWT.GT.0.OR.NEWR.GT.0.OR.NEWL.GT.0)
c     1      CALL SETONE
           IF (NEWT.GT.0 .OR. NEWR.GT.0 .or. neww.gt.0 .or. newd.gt.0
     &         .or. irot.ne.1)
     1      CALL SETONE
         PASS8B = 0.0
         PASS9B = 0.0
         PAS10B = 0.0
         PAS11B = 0.0
         PAS12B = 0.0
         PAS13B = 0.0
         TYWU   = 0.0
         SXSP   = 0.0
         SYR    = 0.0
         SYQ    = 0.0
         MOO    = MOO+12
         OTSW   = PSW
         AETINT = AETINT+TINTET                                         FOREST
         TINTET = 0.0                                                   FOREST
         TINT   = 0.0                                                   FOREST
         SYRG   = 0.0                                                   FOREST
         XMELTY = 0.0
         INTY   = 0.0
         THRUFY = 0.0
         INTETY = 0.0
         ALAI   = balone(irotyr)
         aideal = balone(irotyr)
         croph  = chtone(irotyr)
         atrany   =0.0
         ptrany   =0.0
         aevapy   =0.0
         pevapy   =0.0
340   CONTINUE
350   CONTINUE
C      SNMET    =SWMIN
C      SXMET    =SWMAX
C      SWMIN    =SWMIN/25.4
C      SWMAX    =SWMAX/25.4
      XN       =FLOAT(IY)
      XJ       =FLOAT(JJ)
      AR       =SR/XN
      ARG      =SRG/XN                                                  FOREST
      AQ       =SQ/XN
      SSXSP    =SSXSP/XN
      AWU      =TWU/XN
      VT       =VT/XJ
      AETINT   =AETINT/XJ
      AVIR     =TOTIRR/XN
      IF (FLGMET .EQ. 0) THEN
         WRITE (LUN07,3004) AR,AQ,SSXSP,AWU,AVIR
         WRITE (LUN07,3005) VT,V
         WRITE (LUN07,3006) (ST(I),I=1,NS)
C         WRITE (LUN07,3007) SWMIN,MINDAT,SWMAX,MAXDAT
      ELSE
         AR    = AR    * 2.54
         AQ    = AQ    * 2.54
         SSXSP = SSXSP * 2.54
         AWU   = AWU   * 2.54
         AVIR  = AVIR  * 2.54
         DO 2002 I=1,NS
            STMET(I) = ST(I) * 2.54
 2002    CONTINUE
         WRITE (LUN07,4004) AR,AQ,SSXSP,AWU,AVIR
         WRITE (LUN07,4005) VT,V
         WRITE (LUN07,4006) (STMET(I),I=1,NS)
C         WRITE (LUN07,4007) SNMET,MINDAT,SXMET,MAXDAT
      ENDIF
      CALL SUMTAB( BEGYR, NBMO, IY )
      CALL ENDOUT( FLGMET )
      CHMIRR = 0.0
      IRCODE = 0
      IFOL   = 0
      FOLIRR = 0.0
      IF (FLGPST .EQ. 1 .or. flgnut .eq. 1) THEN
         CALL PCPEND( flgpst, flgnut )
         IF (flgpst .GT. 0) CALL PSTEND
         if (flgnut .gt. 0) CALL NUTEND
      ENDIF
      CALL BCKMLY
      CALL BCKANN
      IF (BCKEND .GT. 0) THEN
         WRITE (LUN14,1400)
      ENDIF
      RETURN
1000  FORMAT(10X,10F5.0)
1301  FORMAT(10X,10F5.1)
1400  FORMAT('0000000')                                                 y2k
2000  FORMAT(10I8)
2010  FORMAT(4i8,f8.0)
3000  FORMAT(/,    '   DATE     RAIN-   RUN-    PERC.    AVG.  ',
     1                  '  AVG.    ACT.    POT.     ACT.   POT.  ',
     1                  '   ACT.    POT.    INT.    INT.  IRRIG. ',
     1                  ' CHMGA.',/,
     1                  '             FALL   OFF             TEMP. ',
     1                  '  SOIL W   EP      EP       ES     ES    ',
     1                  '   ET      ET             + ET   APPL.  ',
     1                  ' APPL.',/,
     1                  '  JULIAN      IN     IN      IN       F.  ',
     1                  '   IN/IN   IN      IN       IN     IN    ',
     1                  '   IN      IN      IN      IN      IN   ',
     1                  '   IN',/,
     1                  ' --------- ------- ------- ------- -------',   y2k
     1                  ' ------- ------- ------- ------- -------',
     1                  ' ------- ------- ------- ------- -------',
     1                  ' -------')
3001  FORMAT(/,  19X,'FIELD AREA                  =',F9.3,' ACRES',
     1          /,19X,'ROOTING DEPTH               =',F9.3,' IN',/,
     1            19X,'SATURATED CONDUCTIVITY      =',F9.3,' IN/HR',/,
     1            19X,'AVG. FUL                    =',F9.3,/,
     1            19X,'AVG. FIELD CAPACITY         =',F9.3,' IN/IN',/,
     1            19X,'INITIAL STORAGE FRACTION    =',F9.3,/,
     1            19X,'EVAPORATION COEFFICIENT     =',F9.3,/,
     1            19X,'AVERAGE POROSITY            =',F9.3,' CC/CC',/,
     1            19X,'SCS CURVE NUMBER            =',F9.3,/,
     1            19X,'CHANNEL SLOPE               =',F9.3,' FT/FT',/,
     1            19X,'WATERSHED LEN/WIDTH RATIO   =',F9.3,/,
     1            19X,'PEAK FLOW RATE COEFFICIENT  =',F9.3,/,
     1            19X,'PEAK FLOW RATE EXPONENT     =',F9.3,/,
     1            19X,'UPPER LIMIT OF STORAGE      =',F9.3,' IN',/,
     1            19X,'AVG. 15-BAR WATER CONTENT   =',F9.3,' IN/IN',/,
     1            19X,'INITIAL SOIL WATER STORAGE  =',F9.3,' IN',/,
     1            19X,'FRAC. P.A.W. TO BEGIN IRR.  =',F9.3,/,
     1            19X,'FRAC. P.A.W. TO END IRR.    =',F9.3)
3002  FORMAT(/, 4X,'UPPER LIMIT OF STORAGES, IN',/, 4X,12F10.3)
3003  FORMAT(/, 4X,'INITIAL PLANT AVAILABLE STORAGE, IN',/,
     +         4X,12F10.3,/)
3004  FORMAT(////,31X,'AVERAGE ANNUAL VALUES',/,
     1            27X,'PRECIPITATION     =',F8.3,/,
     1            27X,'PREDICTED RUNOFF  =',F8.3,/,
     1            27X,'DEEP PERCOLATION  =',F8.3,/,
     1            27X,'TOTAL ET          =',F8.3,/,
     1            27X,'IRRIGATION APPLIED=',F8.3)
3005  FORMAT(/,25X,'AVG. AVAL. STORAGE  =',F8.3,' IN',/,
     1            25X,'FINAL AVAL. STORAGE =',F8.3,' IN')
3006  FORMAT(/,4X,'FINAL STORAGE FOR EACH FRACTION',/,4X,12F10.3)
C007   FORMAT(/,19X,'MINIMUM TOTAL STORAGE WAS ',F7.3,' ON ',I6,/,
C    1            19X,'MAXIMUM TOTAL STORAGE WAS ',F7.3,' ON ',I6)
3008  FORMAT(2x,I7,1X,13F8.2)                                           y2k
3011  FORMAT(/, 4X,'FIELD CAPACITY BY LAYER (IN)',/,4X,12F10.3)
3012  FORMAT(/, 4X,'15-BAR WATER CONTENT BY LAYER (IN/IN)',/,4X,
     1       12F10.3)
3013  FORMAT(/, 4X,'POROSITY BY LAYER (CC/CC)',/,4X,12F10.3)
3014  FORMAT(/, 4X,'FUL BY LAYER (IN/IN)',/,4X,12F10.3)
3015  FORMAT(/, 4X,'WATER CONTENT AT WILT. PT. BY LAYER (IN)',/,
     1        4X,12F10.3)
3016  FORMAT(/, 4X,'FEILD CAPACITY BY LAYER (IN/IN)'/,
     +        4X,12F10.3)
3110  FORMAT(/,19X,'FOREST COVER =  NONE')                              FOREST
3111  FORMAT(/,19X,'FOREST COVER =  PINES OR MIXED HARDWOOD-PINE')
3112  FORMAT(/,19X,'FOREST COVER =  SPRUCE-FIR-HEMLOCK')
3113  FORMAT(/,19X,'FOREST COVER =  MIXED HARDWOODS',/,
     1        29X,'BEGGRO = ',I4,5X,'ENDGRO =',I4)

C4000  FORMAT(I6,F6.2,F6.2,F6.2,F6.2,I2,F6.2,F6.2,5F6.3/7F6.3,2X,
C    1       6F6.3/F6.3,2X,7F6.3)
4001  FORMAT(/,  19X,'FIELD AREA                  =',F9.3,' HA',/,
     1            19X,'ROOTING DEPTH               =',F9.3,' CM',/,
     1            19X,'SATURATED CONDUCTIVITY      =',F9.3,' CM/HR',/,
     1            19X,'AVG. FUL                    =',F9.3,/,
     1            19X,'AVG. FIELD CAPACITY         =',F9.3,' CM/CM',/,
     1            19X,'INITIAL STORAGE FRACTION    =',F9.3,/,
     1            19X,'EVAPORATION COEFFICIENT     =',F9.3,/,
     1            19X,'AVERAGE POROSITY            =',F9.3,' CC/CC',/,
     1            19X,'SCS CURVE NUMBER            =',F9.3,/,
     1            19X,'CHANNEL SLOPE               =',F9.3,' M/M',/,
     1            19X,'WATERSHED LEN/WIDTH RATIO   =',F9.3,/,
     1            19X,'PEAK FLOW RATE COEFFICIENT  =',F9.3,/,
     1            19X,'PEAK FLOW RATE EXPONENT     =',F9.3,/,
     1            19X,'UPPER LIMIT OF STORAGE      =',F9.3,' CM',/,
     1            19X,'AVG. 15-BAR WATER CONTENT   =',F9.3,' CM/CM',/,
     1            19X,'INITIAL SOIL WATER STORAGE  =',F9.3,' CM',/,
     1            19X,'FRAC. P.A.W. TO BEGIN IRR.  =',F9.3,/,
     1            19X,'FRAC. P.A.W. TO END IRR.    =',F9.3)
4002  FORMAT(/, 4X,'UPPER LIMIT OF STORAGES, CM',/, 4X,12F10.3)
4003  FORMAT(/, 4X,'INITIAL PLANT AVAILABLE STORAGE, CM',/,
     1           4X,12F10.3,/)
4004  FORMAT(////,33X,'AVERAGE ANNUAL VALUES',/,
     1            25X,'PRECIPITATION     =',F8.3,' CM',/,
     1            25X,'PREDICTED RUNOFF  =',F8.3,' CM',/,
     1            25X,'DEEP PERCOLATION  =',F8.3,' CM',/,
     1            25X,'TOTAL ET          =',F8.3,' CM',/,
     1            25X,'IRRIGATION APPLIED=',F8.3,' CM')
4005  FORMAT(/,25X,'AVG. AVAL. STORAGE  =',F8.3,' CM',/,
     1              25X,'FINAL AVAL. STORAGE =',F8.3,' CM')
4006  FORMAT(/, 4X,'FINAL STORAGE FOR EACH FRACTION',/, 4X,12F10.3)
C007   FORMAT( /,19X,'MINIMUM TOTAL STORAGE WAS ',F7.3,' ON ',I6,/,
C    1            19X,'MAXIMUM TOTAL STORAGE WAS ',F7.3,' ON ',I6)
4011  FORMAT(/, 4X,'FIELD CAPACITY BY LAYER (CM)   ',/,4X,12F10.3)
4012  FORMAT(/, 4X,'15-BAR WATER CONTENT BY LAYER (CM/CM)',/,4X,
     1        12F10.3)
4014  FORMAT(/,4X,'FUL BY LAYER (CM/CM)',/,4X,12F10.3)
4015  FORMAT(/,4X,'WATER CONTENT AT WILT. PT. BY LAYER (CM)',/,
     1        4X,12F10.3)
4016  FORMAT(/, 4X,'FEILD CAPACITY BY LAYER (CM/CM)'/,
     +        4X,12F10.3)
5000  FORMAT(/,    '   DATE     RAIN-   RUN-    PERC.    AVG. ',
     1                  '   AVG.    ACT.    POT.    ACT.    POT. ',
     1                  '   ACT.    POT.    INT     INT    IRRIG.',
     1                  '  CHMGA.',/,
     1                  '             FALL   OFF             TEMP. ',
     1                  '  SOIL W   EP      EP       ES     ES   ',
     1                  '   ET      ET             + ET    APPL. ',
     1                  '  APPL.',/,
     1                  '  JULIAN      CM     CM      CM       C.  ',
     1                  '   CM/CM   CM      CM      CM      CM   ',
     1                  '   CM      CM      CM      CM      CM   ',
     1                  '   CM',/
     1                  ' --------- ------- ------- ------- -------',   y2k
     1                  ' ------- ------- ------- ------- -------',
     1                  ' ------- ------- ------- ------- -------',
     1                  ' -------')
      END

      subroutine calcdr( nday )
      COMMON /HHH002/ dratio(12),croph,neww,newd
      COMMON /LAYERS/ NS, NOSOHZ, BOTHRZ(5), BOTLAY(12), DLAY(12),npl,  swet
     &                BOTMET(12), DLAYM(12), NBOTM(12), ntl, nevap
      COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1              R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1              icindx(366),sumlai,acclai,aideal,sfn,
     1              iccrd(366),ioldcp,cdelta(366),chone,wind(366)
      save
      mynday = nday
      if (mynday .le. 0) mynday = 1
      ntl = iccrd(mynday)
      do 10 i=1, ntl
         dratio(i) =botlay(i) / botlay(ntl)
10    continue
c      botlay(ntl) = 1.0
      dratio(ntl) = 1.0
      return
      end

       SUBROUTINE RICHET(GR,T,U,EO,EP,ET,ES,ES1,ES2,ESX,EOS,PIN,CONA,
     1                   ALAI,FOREST)                                   FOREST
       common /cover/slr
       INTEGER FOREST
       save
       IF (FOREST .EQ. 0) THEN
          EAJ = EXP(-0.4*ALAI)
          if (alai .gt. 1.25) then
             gr = 0.6
          else if (slr .lt. 0.3) then
             gr = 0.5
          else if (slr .lt. 0.5) then
             gr = 0.6
          else if (slr .lt. 0.7) then
             gr = 0.75
          else
             gr = 0.90
          endif
       ELSE
          EAJ = EXP(-0.6*ALAI)                                          FOREST
          gr  = 0.25
       ENDIF
       IF (EAJ.GT.GR) EAJ=GR
       EOS      =EO*EAJ
       IF (ES1.GE.U) GO TO 40
       IF (PIN.GE.ES1) GO TO 10
       ES1      =ES1-PIN
       GO TO 20
  10   CONTINUE
       ES1      =0.0
  20   CONTINUE
       ES1      =ES1+EOS
       IF (ES1.GT.U) GO TO 30
       ES       =EOS
       GO TO 80
  30   CONTINUE
       ES       =EOS-0.4*(ES1-U)
       ES2      =0.6*(ES1-U)
       T        =(ES2/CONA)**2
       GO TO 80
  40   CONTINUE
       IF (PIN.LT.ES2) GO TO 50
       ES1      =U-PIN+ES2
       PIN1     =PIN-ES2
       T        =0.0
       IF (PIN1.GT.U) GO TO 10
       GO TO 20
  50   CONTINUE
       T        =T+1.0
       ES       =CONA*SQRT(T)-ES2
       IF (PIN.GT.0.0) GO TO 60
       IF (ES.GT.EOS) ES=EOS
       GO TO 70
  60   CONTINUE
       ESX      =0.8*PIN
       IF (ESX.LE.ES) ESX=ES+PIN
       IF (ESX.GT.EOS) ESX=EOS
       ES       =ESX
  70   CONTINUE
       ES2      =ES2+ES-PIN
       T        =(ES2/CONA)**2
  80   CONTINUE
       IF (ES.LT.0.0) ES=0.0
       IF (FOREST .EQ. 0) THEN                                          FOREST
          IF (ALAI.GT.3.0) GO TO 90
          EP       =0.333*ALAI*EO
          GO TO 100
  90      CONTINUE
          EP       =EO
 100      CONTINUE
          ET       =ES+EP
          IF (EO.GE.ET) GO TO 110
          ET       =EO
          ES       =ET-EP
       ELSE
          XEAJ = 1.0-(EXP(-0.6*ALAI))                                   FOREST
          EP = XEAJ*EO                                                  FOREST
          ET = ES+EP                                                    FOREST
          IF (EO.GE.ET) GO TO 110                                        FOREST
          ET       =EO                                                  FOREST
          EP       =ET-ES                                               FOREST
       ENDIF
 110   CONTINUE
       RETURN
       END
       SUBROUTINE SNOW(SNO,I,TC1,PIN)
C ********************************************************************
C VARIABLE DISCRIPTION FOR THE SUBROUTINE SNOW:  9/02/86             *
C       SNO                                                          *
C       XMELT SNOWMELT   (INCHES/DAY)                                *
C       TC1   TEMPERATURE (C),FROM TC(I) ARRAY                       *
C       PIN   PRECIPITATION   (INCHES)                               *
C       REFF  EFFECTIVE PRECIPITATION (INCHES),RAINFALL AT THIS PT.  *
C                                                                    *
C                                                                    *
C ********************************************************************
       COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1               PRE(366),ALONE,REFF,TMEAN(366), potlai(366),
     1               icindx(366),sumlai,acclai,aideal,sfn,
     1               iccrd(366),ioldcp,cdelta(366),chone,wind(366)
       COMMON /MELT/ XMELT,XMELTM,XMELTY
       save

       PIN   = 0.0
       XMELT = 0.0
       IF (TC1 .LT. 0.0) THEN
           SNO  = SNO+PRE(I)
           REFF = 0.0
       ELSE
           REFF = PRE(I)
           IF (SNO .GT. 0.00001) THEN
               XMELT = 0.18 * TC1
               IF (XMELT .GT. SNO)  XMELT = SNO
               REFF  = PRE(I) + XMELT
               PIN   = XMELT
               SNO   = SNO - XMELT
           ENDIF
       ENDIF
       RETURN
       END
       SUBROUTINE WADNUT( I, ALAI )                                     FOREST
       COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1               PRE(366),ALONE,REFF,TMEAN(366), potlai(366),
     1               icindx(366),sumlai,acclai,aideal,sfn,
     1               iccrd(366),ioldcp,cdelta(366),chone,wind(366)
      COMMON /FORST/  FOREST, BEGGRO, ENDGRO, THRUFL, INTCEP, nyrfor,
     &                PRORAT, GROSSR, PMOG(600), SMRG, SYRG, TINT,
     &                TINTET, AETINT, ARG, SRG, INTM, INTY, INTET,
     &                INTETM, INTETY, THRUFM, THRUFY, avlint,
     &                cleaf, sleafn, sleafp, wtleaf, woodn, woodp,
     &                wtwood, olddm
       INTEGER FOREST, BEGGRO, ENDGRO
       REAL INTCEP,INTM,INTY,INTET,INTETM,INTETY
       save
       GROSSR = REFF
       THRUFL = 0.0
       INTCEP = 0.0
       IF (REFF .GT. 0.0  .AND.  FOREST .GT. 0) THEN
          IF (PRE(I) .GT. 0.0) THEN
             IF (ALAI .LT. 3.0) THEN
                PRORAT = ALAI / 3.0
             ELSE IF (ALAI .GE. 3.0) THEN
                PRORAT = 1.0
             ENDIF
             IF (FOREST .EQ. 1) THEN
                THRUFL = (0.90 * PRE(I)) - 0.04
             ELSE IF (FOREST .EQ. 2) THEN
                THRUFL = (0.79 * PRE(I)) - 0.05
             ELSE IF (FOREST .EQ. 3  .or.  forest .eq. 4) THEN
                IF (I .GE. BEGGRO  .AND.  I .LE. ENDGRO) THEN
                   THRUFL = (0.94 * PRE(I)) - 0.04
                ELSE
                   THRUFL = (0.97 * PRE(I)) - 0.02
                ENDIF
             ENDIF
             IF (THRUFL .LE. 0.0) THEN
                INTCEP = PRE(I) * PRORAT
             ELSE
                INTCEP = (PRE(I) - THRUFL) * PRORAT
             ENDIF
             REFF = REFF - INTCEP
             IF (REFF .LE. 0.00001) REFF = 0.00001
          ENDIF
          avlint = avlint + intcep
       else
          thrufl = reff
       ENDIF
       RETURN
       END
c                                                                       y2k
c  use algorithm on the nist web site to compute leap year              y2k
c     see:   http://www.nist.gov/y2k/leapyear.htm                       y2k
c                                                                       y2k
c  n = 4 digit year                                                     y2k
c                                                                       y2k
      integer function i2kyr(n)                                         y2k
      if (mod(n,4).eq.0.and.(mod(n,100).ne.0.or.mod(n,400).eq.0)) then  y2k
         i2kyr = 366                                                    y2k
      else                                                              y2k
         i2kyr = 365                                                    y2k
      endif                                                             y2k
      return                                                            y2k
      end                                                               y2k
       SUBROUTINE UPDATE(K,ALAI,croph,TSW,CRITS,h2osf)
       COMMON /BOTH/ ALAMX,TLA,GR,KE,DLAI(366),TC(366,2),RAD(366),
     1               R(366),ALONE,REFF,TMEAN(366), potlai(366),
     1               icindx(366),sumlai,acclai,aideal,sfn,
     1               iccrd(366),ioldcp,cdelta(366),chone,wind(366)
       COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                VERMNT,BCKEND,flgpen
       common /optmir/cul(12), csw(12), nul
       INTEGER HBDATE,HYDOUT,IROPT,FLGGEN,FLGNUT,FLGPST,FLGMET,VERMNT,
     1         bckend,flgpen
       save
       aideal = aideal + dlai(k)
       if (aideal.lt.0.0) aideal=0.0
       IF (DLAI(K).NE.0.0) THEN
          IF (DLAI(K).LT.0.0) then
             ALAI = ALAI+DLAI(K)
             croph = croph + cdelta(k)
          else
             sfw  = 1.
             IF (TSW.LE.CRITS) sfw = tsw / crits
c             ccrits = cul(nul) * .25
c             IF (csw(nul) .LE. ccrits) sfw = csw(nul) / ccrits
             sf   = amin1( sfn, sfw )
             ALAI = ALAI + (DLAI(K)* sf)
             croph = croph + (cdelta(k)*sf)
          endif
       endif
       IF (ALAI.LT.0.0) ALAI=0.0
       if (croph.lt.0.0) croph=0.0

       RETURN
       END
       SUBROUTINE GETRAD
       COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &               LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &               LUN15,LUN16
       COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                VERMNT,BCKEND,flgpen
        COMMON /ONEVAR/A0(2),A1(2),A2(2),ACR,AR,BR,wind1,wind2,wind3,
     &                 dew1,dew2,dew3
       COMMON /FREEZE/ IFZBEG,IFZEND,NFRZ,NFZDAY
       REAL B(12),RADI(12)
       INTEGER FLGMET,HBDATE,HYDOUT,FLGNUT,FLGPST,FLGGEN,VERMNT,BCKEND
       INTEGER flgpen
       save
       READ (LUN02,2000) (RADI(I),I=1,12)
C * *  NEW: CONVERSION OF METRIC MEAN MONTHLY RADIATION TO LANGLEYS/DAY METRAD
       IF (FLGMET .EQ. 1) THEN                                          METRAD
          DO 5 I=1,12                                                   METRAD
              RADI(I) = RADI(I) * 23.9                                  METRAD
   5      CONTINUE                                                      METRAD
       ENDIF                                                            METRAD
       CALL FORFIT(12,RADI,ACR,AR,BR)
       DO 10 I=1,12
           B(I)     =FORFUN(ACR,AR,BR,I,12)
  10   CONTINUE
       IF (FLGMET .EQ. 0) THEN                                          METRAD
          WRITE(LUN07,3001)
          WRITE(LUN07,3000) (B(I),I=1,12)
       ELSE                                                             METRAD
          WRITE(LUN07,3002)                                             METRAD
          WRITE(LUN07,3000) ((B(I)/23.9),I=1,12)                        METRAD
       ENDIF                                                            METRAD
       NFZDAY=0
       IF (NFRZ .EQ. 0 ) RETURN
       FZDAY =35.4-0.154*RADI(12)
       IF (RADI(12) .LT. 230.) NFZDAY=INT(FZDAY)
       WRITE(LUN07,2222) NFZDAY
2222   FORMAT(/,21X,'NO. DAYS OF FROZEN SOIL DURING SNOWMELT:',I4)
       RETURN
2000   FORMAT(10F8.0)
3000   FORMAT(3X,6F12.2)
3001   FORMAT(/,21X,'MONTHLY MEAN RADIATION, LANGLEYS PER DAY')
3002   FORMAT(/,21X,'MONTHLY MEAN RADIATION, MJ/M**2 PER DAY')          METRAD
       END

        SUBROUTINE GETwnd
        COMMON /UNDEF/LUN01,LUN02,LUN03,LUN04,LUN05,LUN06,LUN07,
     &                LUN08,LUN09,LUN10,LUN11,LUN12,LUN13,LUN14,
     &                LUN15,LUN16
        COMMON /ONEVAR/A0(2),A1(2),A2(2),ACR,AR,BR,wind1,wind2,wind3,
     &                 dew1,dew2,dew3
        COMMON /HYDROL/HBDATE,HYDOUT,IROPT,FLGNUT,FLGPST,FLGGEN,FLGMET,
     &                 VERMNT,BCKEND,flgpen
        INTEGER HBDATE,HYDOUT,IROPT,FLGGEN,FLGNUT,FLGPST,FLGMET,VERMNT,
     1          bckend, flgpen
        REAL w(12),windI(12)
        save
        READ (LUN02,2000) (windI(I),I=1,12)
        if (flgpen .gt. 0) then
           if (flgmet .eq. 0) then
              do 10 i=1,12
                 windi(i) = windi(i) * 1.6093
10            continue
           endif
           CALL FORFIT(12,windi,wind1,wind2,wind3)
           DO 20 I=1,12
              w(I)     =FORFUN(wind1,wind2,wind3,I,12)
              if (flgmet .eq. 0) w(i) = w(i) / 1.6093
20         CONTINUE
           if (flgmet .eq. 0) then
              WRITE(LUN07,3001)
           else
              WRITE(LUN07,4001)
           endif
           WRITE(LUN07,3000) (w(I),I=1,12)
        endif
        RETURN
2000    FORMAT(10F8.0)
3000    FORMAT(3X,6F12.2)
3001    FORMAT(/,21X,'MONTHLY MEAN WIND MOVEMENT, MILES PER DAY')
4001    FORMAT(/,21X,'MONTHLY MEAN WIND MOVEMENT, KILOMETERS PER DAY')
        END
