#include  <conio.h>
#include  <ctype.h>
#include  <malloc.h>
#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>

#ifdef toupper
   #undef toupper
#endif

#include  "extkeys.h"
#include  "screen.h"
#include  "nutfunct.h"
#include  "pd.h"


#define  NU_MAIN 5        /* number of main menu options */
#define  NU_SUB  5        /* number of sub menu options  */

struct menu_str{        /* change this if you need more options */
   char *head;
   int  key;
   int  opt_cnt;
   char *opt[NU_SUB];
   int  opt_key[NU_SUB];
};


static  struct menu_str m_menu[NU_MAIN] = {
   {"File",                 /*  first option     */
   ALTF,
   4,
   " Dir    ", " Load   ", " Save   ", " Exit   ", NULL,
    'd',         'l',        's',        'e',       0 },

   {"Utilities",                 /* second option */
   ALTU,
   1,
   " Conversion ", NULL, NULL, NULL, NULL,
   'c',         0,    0,    0,    0 },

   {"Setup",            /* third option */
   ALTS,
   2,
   " Screen  ", " Printer ",  NULL, NULL, NULL,
   's',          'p',         0,    0,    0 },

   {"Output",      /* fourth option */
   ALTO,
   2,
   " Screen  ", " Printer ", NULL, NULL, NULL,
   's',          'p',         0,    0,    0 },

   {"Help",                     /* fifth option */
   ALTH,
   2,
   " Keys   ", " Card 8 ", NULL, NULL, NULL,
   'k',        'c',        0,    0,    0 }
};

char *c_name[] = { "Black", "Blue", "Green", "Cyan", "Red", "Magenta",
   "Brown", "White", "Dark Gray", "Light Blue", "Light Green", "Light Cyan",
   "Light Red", "Light Magenta", "Yellow", "Bright White" };


struct c_scheme clr;
extern struct file_position pos;
extern char fname[40];
extern struct vcfg cfg;
static SMALL_WINDOW *w_ptr;

/*
 *  initialize pulldown menu structures
 */
void pd( void )
{
int bar_posn[NU_MAIN], bar_wdth[NU_MAIN];
int col, row;
struct temp_c_scheme tmpc;
FILE *config_file;

   w_ptr = NULL;
   if ((config_file = fopen( "glms.clr", "rb" )) != NULL) {
      fseek( config_file, 0L, SEEK_SET );
      fread( &tmpc, sizeof(struct temp_c_scheme), 1, config_file );
      fclose( config_file );
      clr.m_bar     = tmpc.m_bar;
      clr.m_alt     = tmpc.m_alt;
      clr.m_select  = tmpc.m_select;
      clr.w_outline = tmpc.w_outline;
      clr.w_list    = tmpc.w_list;
      clr.w_select  = tmpc.w_select;
      cfg.hi_i      = tmpc.cursor;
      cfg.lo_i      = tmpc.help_tbl;
      cfg.f_bar     = tmpc.f_bar;
   } else {
      if (cfg.color == TRUE) {
         clr.m_bar     = set_color( WHITE,   BLUE );
         clr.m_alt     = set_color( L_GREEN, BLUE );
         clr.m_select  = set_color( BLACK,   WHITE );
         clr.w_outline = set_color( MAGENTA, RED );
         clr.w_list    = set_color( WHITE,   BLUE );
         clr.w_select  = set_color( B_WHITE, GREEN );
         cfg.hi_i      = set_color( L_CYAN,  BLUE );
         cfg.lo_i      = set_color( B_WHITE, RED );
         cfg.f_bar     = set_color( YELLOW,  RED );
      } else {
         clr.m_bar     = REVERSE;
         clr.m_alt     = NORMAL;
         clr.m_select  = NORMAL;
         clr.w_outline = REVERSE;
         clr.w_list    = NORMAL;
         clr.w_select  = REVERSE;
         cfg.hi_i      = REVERSE;
         cfg.lo_i      = HI_INTEN;
         cfg.f_bar     = REVERSE;
      }
   }
   col = 0; row = 0;
   draw_lite_bar( col, row );
   col = 1;
   get_bar_spacing( col, (int *)bar_posn, (int *)bar_wdth );
   draw_lite_head( row, bar_posn );
   draw_lite_alt ( row, bar_posn );
   hlight_line(0, 24, 80, cfg.f_bar );
}


/*
 *  user has pressed alt+key for pulldown menu - move through the choices
 */
int  lite_bar_menu( NUTRIENT **first, NUTRIENT **tmp, WINDOW_CONTROL *wc,
                    int *stp, int *ch, char *t )
{
int bar_posn[NU_MAIN], bar_wdth[NU_MAIN];
int i, col, row, bar_opt, found;
int rc = 0;

   c_off( );
   bar_opt = 0;
   found = FALSE;
   col = 1; row = 0;
   get_bar_spacing( col, (int *)bar_posn, (int *)bar_wdth );
   while (*ch != ESC) {
      for (i=0; i<NU_MAIN; i++) {
         if (*ch == m_menu[i].key) {
            found= TRUE;
            bar_opt = i;
         }
      }
      if (*ch == RIGHT) {
         hlight_line( bar_posn[bar_opt], row, bar_wdth[bar_opt], clr.m_bar );
         hlight_line( bar_posn[bar_opt], row, 1, clr.m_alt );
         ++bar_opt;
         if (bar_opt >= NU_MAIN)
            bar_opt = 0;
         found = TRUE;
      } else if (*ch == LEFT) {
         hlight_line( bar_posn[bar_opt], row, bar_wdth[bar_opt], clr.m_bar );
         hlight_line( bar_posn[bar_opt], row, 1, clr.m_alt );
         --bar_opt;
         if (bar_opt < 0)
            bar_opt = NU_MAIN - 1;
         found = TRUE;
      } else if (*ch == RTURN)
         found = TRUE;

      if (found) {
         hlight_line( bar_posn[bar_opt], row, bar_wdth[bar_opt], clr.m_select );
         rc = pull_down( first, tmp, wc, bar_opt, stp, ch, t );
         found = FALSE;
      }
   }
   hlight_line( bar_posn[bar_opt], row, bar_wdth[bar_opt], clr.m_bar );
   hlight_line( bar_posn[bar_opt], row, 1, clr.m_alt );
   c_on( );
   *ch = 0;
   return( rc );
}


/*
 *  show the functions available for each option and execute if needed
 */
int  pull_down( NUTRIENT **first, NUTRIENT **tmp, WINDOW_CONTROL *wc,
                int bar_opt, int *stp, int *ch, char *t )
{
int  i, tx, ty, start, width, nu_opt, w_opt, found;
int  col, row, redraw_screen;
char path[42], line[90];
int rc = 0;

   w_opt = 0;
   found = FALSE;
   redraw_screen = FALSE;
   nu_opt = m_menu[bar_opt].opt_cnt;
   width = strlen( m_menu[bar_opt].opt[0] );
   for (i=0, start=1; i<bar_opt; i++)
      start += strlen( m_menu[i].head ) + 10;
   if (start + width + 2 > 79)
      start = 79 - 2 - width;
   col = start;
   row = 1;

   window_control( &w_ptr, SAVE, col, row, width+2, nu_opt+2 );
   if (w_ptr != NULL) {
      no_buf_make_window( col, row, width+2, nu_opt+2, clr.w_outline );
      tx = col+1; ty = row+1;
      for (i=0; i< nu_opt; i++)
         fast_write( tx, ty+i, m_menu[bar_opt].opt[i], clr.w_list );

      hlight_line( tx, ty, width, clr.w_select );
      *ch = 0;
      while (*ch != ESC && *ch != RIGHT && *ch != LEFT) {
         if (*ch == RTURN)
            found = TRUE;
         else if (*ch == DOWN) {
            hlight_line( tx, ty+w_opt, width, clr.w_list );
            ++w_opt;
            if (w_opt >= nu_opt)
               w_opt = 0;
            hlight_line( tx, ty+w_opt, width, clr.w_select );
         } else if (*ch == UP) {
            hlight_line( tx, ty+w_opt, width, clr.w_list );
            --w_opt;
            if (w_opt < 0)
               w_opt = nu_opt - 1;
            hlight_line( tx, ty+w_opt, width, clr.w_select );
         } else if (isalpha(*ch)) {
            *ch = tolower( *ch );
            for (i=0; i<m_menu[bar_opt].opt_cnt; i++) {
               if (*ch == m_menu[bar_opt].opt_key[i]) {
                  found = TRUE;
                  w_opt = i;
                  break;
               }
            }
         }

         if (found) {
            if (bar_opt == 0 && w_opt == 0)
               do_dir( );
            else if (bar_opt == 0 && w_opt == 1)
               redraw_screen = load_file( first, tmp, wc, path );
            else if (bar_opt == 0 && w_opt == 2)
               redraw_screen = save_file( *first, path );
            else if (bar_opt == 1 && w_opt == 0)
               rc = help_conversion( t );
            else if (bar_opt == 0 && w_opt == 3)
               stop( first, stp );
            else if (bar_opt == 2 && w_opt == 0)
               set_colors( bar_opt, nu_opt, w_opt, col, row );
            else if (bar_opt == 4 && w_opt == 0)
               help( );
            else if (bar_opt == 4 && w_opt == 1)
               help_card8( );
            else
               demo( );
            *ch = ESC;
            found = FALSE;
         } else
            *ch = getkey( );
      }
      window_control( &w_ptr, RESTORE, col, row, width+2, nu_opt+2 );
   }
   if (redraw_screen == TRUE) {
      if (bar_opt == 0 && w_opt == 1) {
         refresh_screen( *tmp, wc );
         memset( line, ' ', 80 );
         line[80] = '\0';
         fast_write( 0, 24, line, cfg.f_bar );
      }
      write_filename( path );
   }
   return( rc );
}


/*
 *  do nothing routine - maybe users will come up w/ idea for useful function
 */
void demo( void )
{
int i, row, col, wid, hgt;

   col = 20;
   row = 10;
   wid = 40;
   hgt = 5;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );
   fast_write( 21, 11, "      Subroutine under Constuction", NORMAL );
   fast_write( 21, 13, "         Press any key to return", NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );
   i = getkey( );
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
}


void draw_lite_bar( int col, int row )
{
   hlight_line( col, row, 80, clr.m_bar );
}


/*
 *  find out length of all pulldown headings so display will be evenly spaced
 */
void get_bar_spacing( int col, int *bar_posn, int *bar_wdth )
{
int i, j;

   for (i=j=0; i< NU_MAIN; i++) {
      *(bar_posn+i) = col+j;
      *(bar_wdth+i) = strlen( m_menu[i].head );
      j += *(bar_wdth+i) + 10;
   }
}


/*
 *  write File, Configure, etc  across pulldown lite bar at top of screen
 */
void draw_lite_head( int row, int bar_posn[] )
{
int i;

   for (i=0; i< NU_MAIN; i++)
      fast_write( *(bar_posn+i), row, m_menu[i].head, clr.m_bar );
}


/*
 *  hilite the key needed to press with the ALT key to activate the menu
 */
void draw_lite_alt( int row, int bar_posn[] )
{
int i;

   for (i=0; i< NU_MAIN; i++)
      hlight_line( *(bar_posn+i), row, 1, clr.m_alt );
}


/*
 *  master funtion to change the screen colors of various fields
 */
void set_colors( int bar_opt, int nu_opt, int w_opt, int pd_col, int pd_row )
{
int bar_posn[NU_MAIN], bar_wdth[NU_MAIN];
int ch, change_sample, hi_lite;
char *fore_blank = "             ";
char *back_blank = "       ";
struct win_vars win;
struct sample_vars spl;
struct temp_c_scheme tmpc;
FILE *config_file;

   init_tmp_color( &tmpc );
   init_win_vars( &win );
   init_sample_vars( win, &spl );
   change_sample = FALSE;

   window_control( &w_ptr, SAVE, win.d_col, win.d_row, win.wid, win.hgt );
   no_buf_make_window( win.d_col, win.d_row, win.wid, win.hgt, clr.w_outline );

   setup_set_colors( win, spl, tmpc );
   give_current_colors( win.d_col, win.d_row, tmpc );

   get_color_name_posn( &win );
   hlight_line( win.c, win.r, FORE_LENGTH, REVERSE );
   ch = getkey( );
   while (ch != ESC && ch != RTURN) {
      switch (ch) {
         case ' '   :
            decompose_color( win.fld, &win.f_clr, &win.b_clr, tmpc );
            change_color_name( &win );
            change_sample = TRUE;
            break;
         case UP    :
            toggle_hilite( win );
            --win.fld;
            if (win.fld < 0)
               win.fld = win.max_fld;
            hi_lite = TRUE;
            break;
         case DOWN  :
            toggle_hilite( win );
            ++win.fld;
            if (win.fld > win.max_fld)
               win.fld = 0;
            hi_lite = TRUE;
            break;
         case LEFT  :
            if (win.f_b == BACKGROUND) {
               hlight_line( win.c, win.r, BACK_LENGTH, NORMAL );
               win.f_b = FOREGROUND;
               hi_lite = TRUE;
            }
            break;
         case RIGHT :
            if (win.f_b == FOREGROUND) {
               hlight_line( win.c, win.r, FORE_LENGTH, NORMAL );
               win.f_b = BACKGROUND;
               hi_lite = TRUE;
            }
            break;
      }
      if (change_sample == TRUE) {
         compose_color( win.fld, win.f_clr, win.b_clr, &tmpc );
         update_sample( win, spl, tmpc );
         change_sample = FALSE;
      }
      if (hi_lite == TRUE) {
         get_color_name_posn( &win );
         if (win.f_b == FOREGROUND)
            hlight_line( win.c, win.r, FORE_LENGTH, REVERSE );
         else if (win.f_b == BACKGROUND)
            hlight_line( win.c, win.r, BACK_LENGTH, REVERSE );
         hi_lite = FALSE;
      }
      ch = getkey( );
   }
   if (ch == RTURN) {
      get_bar_spacing( 1, (int *)bar_posn, (int *)bar_wdth );
      make_change_perm( tmpc, bar_posn, bar_wdth, bar_opt, nu_opt, w_opt,
                                                           pd_col, pd_row );
      if ( (config_file = fopen( "glms.clr", "w" )) != NULL) {
         fwrite( &tmpc, sizeof(struct temp_c_scheme), 1, config_file);
         fclose( config_file );
      }
   }
   window_control( &w_ptr, RESTORE, win.d_col, win.d_row, win.wid, win.hgt );
}


/*
 *  show color name on color help screen
 */
void change_color_name( struct win_vars *win )
{
char *fore_blank = "             ";
char *back_blank = "       ";

   if (win->f_b == FOREGROUND) {
      ++win->f_clr;
      if (win->f_clr > 15)
         win->f_clr = 0;
      fast_write( win->c, win->r,  fore_blank, REVERSE );
      fast_write( win->c, win->r,  c_name[win->f_clr], REVERSE );
   } else if (win->f_b == BACKGROUND) {
      ++win->b_clr;
      if (win->b_clr > 7)
         win->b_clr = 0;
      fast_write( win->c, win->r,  back_blank, REVERSE );
      fast_write( win->c, win->r,  c_name[win->b_clr], REVERSE );
   }
}


/*
 *  turn off hilite in color help screen - cursor no longer on that field
 */
void toggle_hilite( struct win_vars win )
{

   if (win.f_b == FOREGROUND)
      hlight_line( win.c, win.r, FORE_LENGTH, NORMAL );
   else if (win.f_b == BACKGROUND)
      hlight_line( win.c, win.r, BACK_LENGTH, NORMAL );
}


/*
 *  show examples of colors for various fields
 */
void update_sample( struct win_vars win, struct sample_vars spl,
                    struct temp_c_scheme tmpc )
{
   switch (win.fld) {
      case 0 :
         fast_write( spl.left_bar_c,  spl.left_bar_r,  "Test ", tmpc.m_bar );
         fast_write( spl.right_bar_c, spl.right_bar_r, " Test", tmpc.m_bar );
         fast_write( spl.left_alt_c,  spl.left_alt_r,  "T", tmpc.m_alt );
         fast_write( spl.right_alt_c, spl.right_alt_r, "T", tmpc.m_alt );
         break;
      case 1 :
         fast_write( spl.left_alt_c,  spl.left_alt_r,  "T", tmpc.m_alt );
         fast_write( spl.right_alt_c, spl.right_alt_r, "T", tmpc.m_alt );
         break;
      case 2 :
         fast_write( spl.head_c, spl.head_r, "Test", tmpc.m_select );
         break;
      case 3 :
         no_buf_box( spl.win_c, spl.win_r, spl.win_wid, spl.win_hgt,
                                                   tmpc.w_outline );
         break;
      case 4 :
         fast_write( spl.list1_c, spl.list1_r, "  Test  ", tmpc.w_list );
         fast_write( spl.list2_c,  spl.list2_r, "  Test  ", tmpc.w_list );
         break;
      case 5 :
         fast_write( spl.select_c, spl.select_r, "  Test  ", tmpc.w_select );
         break;
      case 6 :
         fast_write( spl.cursor_c, spl.cursor_r,  "99.99..", tmpc.cursor );
         break;
      case 7 :
         fast_write( spl.help_tbl_c, spl.help_tbl_r, " Corn ", tmpc.help_tbl );
         break;
      case 8 :
         fast_write( spl.f_bar_c,  spl.f_bar_r,  " F1 = Test ", tmpc.f_bar );
         break;
   }
}


/*
 *  save color scheme to file
 */
void make_change_perm( struct temp_c_scheme tmpc, int *bar_posn, int *bar_wdth,
                   int bar_opt, int nu_opt, int w_opt, int pd_col, int pd_row )
{
int i, wid, col, row;

   clr.m_bar = tmpc.m_bar;
   clr.m_alt = tmpc.m_alt;
   clr.m_select = tmpc.m_select;
   clr.w_outline = tmpc.w_outline;
   clr.w_list = tmpc.w_list;
   clr.w_select = tmpc.w_select;
   col = 0; row = 0;
   draw_lite_bar( col, row );
   col = 1;
   draw_lite_head( row, bar_posn );
   hlight_line( bar_posn[bar_opt], 0, bar_wdth[bar_opt], clr.m_select );
   wid = strlen( m_menu[bar_opt].opt[0] );
   for (i=0; i< nu_opt; i++)
      hlight_line( pd_col+1, pd_row+1+i, wid, clr.w_list );
   hlight_line( pd_col+1, pd_row+1+w_opt, wid, clr.w_select );
   no_buf_box( pd_col, pd_row, wid+2, nu_opt+2, clr.w_outline );
   cfg.hi_i = tmpc.cursor;
   cfg.lo_i = tmpc.help_tbl;
   cfg.f_bar = tmpc.f_bar;
   hlight_line( 0, 24, 80, cfg.f_bar );
   draw_lite_alt ( row, bar_posn );
}


/*
 *  set up temporary color scheme of various fields
 */
void init_tmp_color( struct temp_c_scheme *tmpc )
{
   tmpc->m_bar = clr.m_bar;
   tmpc->m_alt = clr.m_alt;
   tmpc->m_select = clr.m_select;
   tmpc->w_outline = clr.w_outline;
   tmpc->w_list = clr.w_list;
   tmpc->w_select = clr.w_select;
   tmpc->cursor = cfg.hi_i;
   tmpc->help_tbl = cfg.lo_i;
   tmpc->f_bar = cfg.f_bar;
}


/*
 *  set up color scheme help window variables
 */
void init_win_vars( struct win_vars *win )
{
   win->wid = 69;
   win->hgt = 17;
   win->d_col = 4;
   win->d_row = 7;
   win->fld = 0;
   win->max_fld = 8;
   win->f_b = FOREGROUND;
}


/*
 *  set up row and columns for color samples of various fields
 */
void init_sample_vars( struct win_vars win, struct sample_vars *spl )
{
   spl->left_bar_c   = win.d_col + 53;
   spl->left_bar_r   = win.d_row + 2;
   spl->left_alt_c   = win.d_col + 53;
   spl->left_alt_r   = win.d_row + 2 ;
   spl->head_c       = win.d_col + 58;
   spl->head_r       = win.d_row + 2 ;
   spl->right_bar_c  = win.d_col + 62;
   spl->right_bar_r  = win.d_row + 2;
   spl->right_alt_c  = win.d_col + 63;
   spl->right_alt_r  = win.d_row + 2 ;
   spl->win_c        = win.d_col + 55;
   spl->win_r        = win.d_row + 3;
   spl->win_wid      = 10;
   spl->win_hgt      = 5;
   spl->list1_c      = win.d_col + 56;
   spl->list1_r      = win.d_row + 4;
   spl->select_c     = win.d_col + 56;
   spl->select_r     = win.d_row + 5;
   spl->list2_c      = win.d_col + 56;
   spl->list2_r      = win.d_row + 6;
   spl->cursor_c     = win.d_col + 53;
   spl->cursor_r     = win.d_row + 10;
   spl->help_tbl_c   = win.d_col + 53;
   spl->help_tbl_r   = win.d_row + 11;
   spl->f_bar_c      = win.d_col + 53;
   spl->f_bar_r      = win.d_row + 13;
}


/*
 *  get row and column of cursor in color help screen
 */
void get_color_name_posn( struct win_vars *win )
{
   if (win->f_b == FOREGROUND) {
      win->c = win->d_col + c_posn[win->fld].f_col;
      win->r = win->d_row + c_posn[win->fld].f_row;
   } else if (win->f_b == BACKGROUND) {
      win->c = win->d_col + c_posn[win->fld].b_col;
      win->r = win->d_row + c_posn[win->fld].b_row;
   }
}


/*
 *  show samples of colors of various fields
 */
void setup_set_colors( struct win_vars win, struct sample_vars spl,
                       struct temp_c_scheme tmpc )
{
   write_to_window( set_colors_screen, win.d_col, win.d_row, NORMAL );
   fast_write( spl.left_bar_c,  spl.left_bar_r,  "Test ", tmpc.m_bar );
   fast_write( spl.left_alt_c,  spl.left_alt_r,  "T",     tmpc.m_alt );
   fast_write( spl.head_c,      spl.head_r,      "Test",  tmpc.m_select );
   fast_write( spl.right_bar_c, spl.right_bar_r, " Test", tmpc.m_bar );
   fast_write( spl.right_alt_c, spl.right_alt_r, "T",     tmpc.m_alt );
   no_buf_make_window( spl.win_c, spl.win_r, spl.win_wid, spl.win_hgt,
                       tmpc.w_outline );
   fast_write( spl.list1_c,  spl.list1_r,  "  Test  ", tmpc.w_list );
   fast_write( spl.select_c, spl.select_r, "  Test  ", tmpc.w_select );
   fast_write( spl.list2_c,  spl.list2_r,  "  Test  ", tmpc.w_list );
   fast_write( spl.cursor_c, spl.cursor_r,  "99.99..", tmpc.cursor );
   fast_write( spl.help_tbl_c, spl.help_tbl_r, " Corn ", tmpc.help_tbl );
   fast_write( spl.f_bar_c,  spl.f_bar_r,  " F1 = Test ", tmpc.f_bar );
}


/*
 *  given a color get the foreground and background color
 */
void decompose_color( int field, int *foreground, int *background,
                      struct temp_c_scheme tmpc )
{
   switch (field) {
      case 0 :
         *foreground = tmpc.m_bar & 0xF;
         *background = (tmpc.m_bar & 0xF0) >> 4;
         break;
      case 1 :
         *foreground = tmpc.m_alt & 0xF;
         *background = (tmpc.m_alt & 0xF0) >> 4;
         break;
      case 2 :
         *foreground = tmpc.m_select & 0xF;
         *background = (tmpc.m_select & 0xF0) >> 4;
         break;
      case 3 :
         *foreground= tmpc.w_outline & 0xF;
         *background= (tmpc.w_outline & 0xF0) >> 4;
         break;
      case 4 :
         *foreground= tmpc.w_list & 0xF;
         *background= (tmpc.w_list & 0xF0) >> 4;
         break;
      case 5 :
         *foreground= tmpc.w_select & 0xF;
         *background= (tmpc.w_select & 0xF0) >> 4;
         break;
      case 6 :
         *foreground= tmpc.cursor & 0xF;
         *background= (tmpc.cursor & 0xF0) >> 4;
         break;
      case 7 :
         *foreground= tmpc.help_tbl & 0xF;
         *background= (tmpc.help_tbl & 0xF0) >> 4;
         break;
      case 8 :
         *foreground= tmpc.f_bar & 0xF;
         *background= (tmpc.f_bar & 0xF0) >> 4;
         break;
   }
}


/*
 *  given the foreground and background compose the color
 */
void compose_color( int field, int foreground, int background,
                    struct temp_c_scheme *tmpc )
{
int i;

   i =  (background << 4) | foreground;
   switch (field) {
      case 0 :
         tmpc->m_bar = i;
         break;
      case 1 :
         tmpc->m_alt = i;
         break;
      case 2 :
         tmpc->m_select = i;
         break;
      case 3 :
         tmpc->w_outline = i;
         break;
      case 4 :
         tmpc->w_list = i;
         break;
      case 5 :
         tmpc->w_select = i;
         break;
      case 6 :
         tmpc->cursor = i;
         break;
      case 7 :
         tmpc->help_tbl = i;
         break;
      case 8 :
         tmpc->f_bar = i;
         break;
   }
}


/*
 *  show the names of foreground and background colors of the various fields
 */
void give_current_colors( int c, int r, struct temp_c_scheme tmpc )
{
int i, fore, back;

   for (i=0; i<9; i++) {
      decompose_color( i, &fore, &back, tmpc );
      fast_write( c+c_posn[i].f_col, r+c_posn[i].f_row, c_name[fore], NORMAL );
      fast_write( c+c_posn[i].b_col, r+c_posn[i].b_row, c_name[back], NORMAL );
   }
}


/*
 *  master routine to load a file into the linked list structure
 */
int  load_file( NUTRIENT **first, NUTRIENT **tmp, WINDOW_CONTROL *wc,
                char *path )
{
NUTRIENT *a, *b;
int i, j, rc, display;
FILE *infile;
char tname[42], line[100];
int row, col, wid, hgt;
struct card_parse crd;

   display = pos.display;
   pos.display = FALSE;
   rc = FALSE;
   col = 12;
   row = 6;
   wid = 54;
   hgt = 10;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );

   write_to_window( load_screen, col, row, NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );
   hlight_line( col+2, row+3, 7, (clr.w_list | 0x80) );

   c_on( );
   field_editor( tname, 'A', 30, row+6, col+21, FALSE, &j, clr.w_select, pos );
   while (( (infile = fopen( tname, "r" )) == NULL) && j != ESC) {
      fast_write( col+21, row+6, "ERROR: could not open file.   ",
                  clr.w_select );
      j = getkey( );
      while (j != RTURN && j != ESC)
         j = getkey( );
      if (j != ESC)
         field_editor( tname, 'A', 30, row+6, col+21, FALSE, &j, clr.w_select,
                       pos );
   }

   if (infile != NULL && j != ESC) {
      strcpy( path, tname );
      strcpy( fname, tname );
      for (a=*first; a!=NULL;) {
         b = a;
         a = a->n;
         free( b );
      }
      *first = NULL;

      crd.eof = FALSE;
      fseek( infile, 0L, SEEK_SET );
      for (crd.c_no=0; fgets(line, 90, infile) != NULL && crd.eof != TRUE;) {
         if (crd.c_no == 0) {
            crd.c_no = 1;
            *first = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
            (*first)->n = (*first)->p = NULL;
            a = *first;
         } else {
            b = (NUTRIENT *)malloc( sizeof(NUTRIENT) );
            a->n = b;
            b->p = a;
            b->n = NULL;
            a = b;
         }
         add_a_line( a, line, &crd );
      }
      *tmp = *first;
      wc->field = 0;
      wc->v_row = wc->r_row = 0;
      wc->view  = VLEFT;
      rc = TRUE;
      pos.f_row = 1;
   }
   if (infile != NULL)
      fclose( infile );
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
   pos.display = display;
   return( rc );
}


/*
 *  figure out what line we are on and what the next line should be
 */
void add_a_line( NUTRIENT *a, char *line, struct card_parse *crd )
{
int i, j, fert_type;
char t[20];

   for (i=j=0; line[i] != '\0' && i < 80; i++) {
      if (line[i] == '\n')
         a->line[i] = '\0';
      else {
         a->line[i]=line[i];
         j++;
      }
   }
   if (crd->c_no > 3) {
      if (j<80) {
         for (; (a->line[j] = ' ') && j<80; j++);
         a->line[j] = '\0';
      }
   }
   a->line[j] = '\0';
   a->type = crd->c_no;
   if (crd->c_no <= 3) {
      if (line[0] != '\0' || line[0] != '\n')
         a->apd[0] = TRUE;
      else
         a->apd[0] = FALSE;
   } else {
      for (i=0; i<10; i++) {
         setup_field( a, i, 8, t );
         if (t[0] == '\0') {
            a->apd[i] = FALSE;
            a->num[i] = 0.0;
         } else {
            a->apd[i] = TRUE;
            a->num[i] = atof( t );
         }
      }
   }

   switch (crd->c_no) {
      case 1  :
      case 2  :
      case 3  :
      case 4  :
      case 5  :
         ++crd->c_no;
         break;
      case 6  :
      case 7  :
      case 8  :
      case 9  :
      case 10 :
      case 11 :
      case 12 :
         ++crd->c_no;
         break;
      case 13 :
         if (a->apd[0] == TRUE && a->num[0] > 0)
            crd->c_no = 14;
         else if (a->apd[0] == TRUE && a->num[0] == 0)
            crd->eof = TRUE;
         else
            crd->c_no = 14;
         break;
      case 14 :
         a->num[4] = a->num[0];
         a->num[5] = a->num[1];
         crd->nf   = a->num[0];
         crd->ntil = a->num[1];
         ++crd->c_no;
         break;
      case 15 :
         if (crd->nf > 0)
            crd->c_no = 16;
         else if (crd->ntil > 0)
            crd->c_no = 19;
         else
            crd->c_no = 13;
         break;
      case 16 :
         a->num[4] = a->num[1];
         fert_type = a->num[1];
         if (crd->nf >= 1) {
            if (fert_type == 0)
               crd->c_no = 17;
            else
               crd->c_no = 18;
            --crd->nf;
         } else if (crd->ntil > 0)
            crd->c_no = 19;
         else
            crd->c_no = 13;
         break;
      case 17 :
      case 18 :
         if (crd->nf > 0)
            crd->c_no = 16;
         else if (crd->ntil > 0)
            crd->c_no = 19;
         else
            crd->c_no = 13;
         break;
      case 19 :
         if (crd->ntil >= 1) {
            crd->c_no = 19;
            --crd->ntil;
         }
         if (crd->ntil <= 0)
            crd->c_no = 13;
         break;
   }
}


/*
 *  master function to save a linked list to a file
 */
int  save_file( NUTRIENT *first, char *path )
{
NUTRIENT *p;
int i, j, display;
FILE *outfile;
char tname[42], *p1, *p2, temp[100];
int row, col, wid, hgt, rc;

   display = pos.display;
   pos.display = FALSE;
   rc = FALSE;
   col = 20;
   row = 10;
   wid = 59;
   hgt = 7;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );

   fast_write( col+17, row+1, "Save worksheet to a file", NORMAL );
   fast_write( col+2, row+3, "Enter file name : ", NORMAL );
   fast_write( col+2, row+5,
               "Esc = Cancel    Return = Save    F10 = Recall file name",
               NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );

   c_on( );
   field_editor( tname, 'A', 30, row+3, col+20, FALSE, &j, cfg.hi_i, pos );
   if (j == F10) {
      if (strncmp( fname, "Temporary", (size_t) 9 ) != 0) {
         strcpy( tname, fname );
         field_editor( tname, 'A', 30, row+3, col+20, TRUE, &j, cfg.hi_i,
                                                                 pos );
      }
   }
   while (( (outfile = fopen( tname, "w" )) == NULL) && j != ESC) {
      fast_write( col+20, row+3, "ERROR: could not open file.", NORMAL );
      j = getkey( );
      while (j != RTURN && j != ESC)
         j = getkey( );
      if (j != ESC)
         field_editor( tname, 'A', 30, row+3, col+20, FALSE, &j, cfg.hi_i,
                       pos );
      if (j == F10) {
         if (strncmp( fname, "Temporary", (size_t) 9 ) != 0) {
            strcpy( tname, fname );
            field_editor( tname, 'A', 30, row+3, col+20, TRUE, &j, cfg.hi_i,
                                                                    pos );
         }
      }
   }

   if (outfile != NULL && j != ESC) {
      fseek( outfile, 0L, SEEK_SET );
      for (p=first; p != NULL; p=p->n) {
         strcpy( temp, p->line );
         p1 = p2 = temp;
         for (; *p1 != '\0'; p1++);
         for (--p1; *p1 == ' ' && p1 >= p2; p1--)
            *p1 = '\0';
         fprintf( outfile, "%s\n", temp );
      }
      fclose( outfile );
      rc = TRUE;
      strcpy( path, tname );
      strcpy( fname, tname );
   }
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
   pos.display = display;
   return( rc );
}


/*
 *  ask are you sure? free the linked list and exit editor
 */
void stop( NUTRIENT **first, int *stp )
{
int i, row, col, wid, hgt;
NUTRIENT *a, *b;

   col = 20;
   row = 10;
   wid = 28;
   hgt = 6;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );

   fast_write( col+2, row+2, "Exit Nutrient Worksheet", NORMAL );
   fast_write( col+7, row+4, "<Ok>  <Cancel>", NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );

   i = getkey( );
   while (i != RTURN && i != ESC)
      i = getkey( );
   if (i == RTURN) {
      *stp = TRUE;
      for (a=*first; a!=NULL;) {
         b = a;
         a = a->n;
         free( b );
      }
   }
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
}


/*
 *  show functions of various keys
 */
void help( void )
{
int i, row, col, wid, hgt;

   col = 10;
   row = 2;
   wid = 57;
   hgt = 21;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );
   write_to_window( help_keys, col, row, NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );
   i = getkey( );
   while (i != RTURN && i != ESC)
      i = getkey( );
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
}


/*
 *  display information on card 8
 */
void help_card8( void )
{
int i, row, col, wid, hgt;

   col = 10;
   row = 6;
   wid = 60;
   hgt = 11;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );
   write_to_window( help_card8_info, col, row, NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );
   i = getkey( );
   while (i != RTURN && i != ESC)
      i = getkey( );
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
}


/*
 *  help with conversions
 */
int  help_conversion( char *t )
{
int i, row, col, wid, hgt;
int c;
int display;
float number;

   col = 10;
   row = 6;
   wid = 59;
   hgt = 13;
   window_control( &w_ptr, SAVE, col, row, wid, hgt );
   no_buf_make_window( col, row, wid, hgt, clr.w_outline );
   write_to_window( conversion_screen, col, row, NORMAL );
   for (i=0; i<hgt-2; i++)
      hlight_line( col+1, row+1+i, wid-2, clr.w_list );
   for (i=0; i<8; i++)
      hlight_line( col+4, row+3+i, 8, 7 );

   c_on( );
   display = pos.display;
   pos.display = FALSE;
   i = c = 0;
   while (c != ESC  &&  c != RTURN) {
      field_editor( t, 'R', 8, row+i+3, col+4, FALSE, &c, clr.w_select, pos );
      switch (c) {
         case UP    :
            fast_write( col+4, row+3+i, "        ", NORMAL );
            --i;
            if (i < 0)
               i = 7;
            break;
         case DOWN  :
            fast_write( col+4, row+3+i, "        ", NORMAL );
            ++i;
            if (i == 8)
               i = 0;
            break;
      }
   }
   if (c == RTURN) {
      number = atof( t );
      switch (i) {
         case 0 :
            /*    acres   to hectares    */
            number = number * 2.47;
         break;
         case 1 :
            /*    cm/ha     */
            number = number * 100000.;
         break;
         case 2 :
            /*    inches  */
            number = number * 2.54;
         break;
         case 3 :
         case 4 :
            /*    lbs/1000 gal  */
            number = number * 120.;
         break;
         case 5 :
            /*    lbs/ac  */
            number = number * 1.12;
         break;
         case 6 :
            /*    percent    */
            number = number * 10000.;
         break;
         case 7 :
            /*    T/ac       */
            number = number * 2.24;
         break;
      }
      ftoa( number, 2, t );
   }
   pos.display = display;
   window_control( &w_ptr, RESTORE, col, row, wid, hgt );
   return( c );
}
