%Test Name: SquareShelfTranSSA2dFloatingMeltParamForDJUICE
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);
md.basalforcings=linearbasalforcings(md.basalforcings);
md.basalforcings.deepwater_melting_rate = 50.0;
md.basalforcings.upperwater_melting_rate = 0.0;
md.basalforcings.deepwater_elevation = -500.0;
md.basalforcings.upperwater_elevation = 0.0;
md.basalforcings.groundedice_melting_rate = zeros(md.mesh.numberofvertices, 1)
md.basalforcings.perturbation_melting_rate = ones(md.mesh.numberofvertices, 1);
md.groundingline.migration = 'SubelementMigration';

md.timestepping.interp_forcing=0;
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names     ={'Vx1','Vy1','Vel1','Pressure1','Base1','Surface1','Thickness1','Vx2','Vy2','Vel2','Pressure2','Base2','Surface2','Thickness2','Vx3','Vy3','Vel3','Pressure3','Base3','Surface3','Thickness3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	};
