%Test Name: SquareSheetConstrainedSmbMeltComponentsClim2d
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);

md.timestepping.time_step=0.5;
md.settings.output_frequency=1;
md.timestepping.final_time=6.;

%Set up transient
smb=ones(md.mesh.numberofvertices,1)*3.6;
smb=[ smb smb*-1. ];

md.smb=SMBmeltcomponents();
md.smb.accumulation=[smb; [1.5 3.]];
md.smb.melt=[smb/2; [1.5 3.]];
md.smb.refreeze=[smb; [1.5 3.]];
md.smb.evaporation=[smb/2; [1.5 3.]];
md.transient.isthermal=0;

md.timestepping.cycle_forcing=1;

md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','SmbMassBalance1', ...
	'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','SmbMassBalance2', ...
	'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3','SmbMassBalance3', ...
	'Vx4','Vy4','Vel4','Pressure4','Bed4','Surface4','Thickness4','SmbMassBalance4'};
field_tolerances={1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).SmbMassBalance),...
	(md.results.TransientSolution(4).Vx),...
	(md.results.TransientSolution(4).Vy),...
	(md.results.TransientSolution(4).Vel),...
	(md.results.TransientSolution(4).Pressure),...
	(md.results.TransientSolution(4).Base),...
	(md.results.TransientSolution(4).Surface),...
	(md.results.TransientSolution(4).Thickness),...
	(md.results.TransientSolution(4).SmbMassBalance),...
	(md.results.TransientSolution(8).Vx),...
	(md.results.TransientSolution(8).Vy),...
	(md.results.TransientSolution(8).Vel),...
	(md.results.TransientSolution(8).Pressure),...
	(md.results.TransientSolution(8).Base),...
	(md.results.TransientSolution(8).Surface),...
	(md.results.TransientSolution(8).Thickness),...
	(md.results.TransientSolution(8).SmbMassBalance),...
	(md.results.TransientSolution(12).Vx),...
	(md.results.TransientSolution(12).Vy),...
	(md.results.TransientSolution(12).Vel),...
	(md.results.TransientSolution(12).Pressure),...
	(md.results.TransientSolution(12).Base),...
	(md.results.TransientSolution(12).Surface),...
	(md.results.TransientSolution(12).Thickness),...
	(md.results.TransientSolution(12).SmbMassBalance),...
	};
