%Test Name: SquareSheetConstrainedSmbpddGCM2d
md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',3);

md.timestepping.time_step=0.5;
md.settings.output_frequency=1;
md.timestepping.final_time=6.;

%Set up SMB
md.smb=SMBpddGCM();
md.smb = md.smb.initialize(md);
md.smb.x_grid = linspace(0,1e6,3)';
md.smb.y_grid = linspace(0,1e6,4)';
smbtime = [2,4,5];
Nx = numel(md.smb.x_grid);
Ny = numel(md.smb.y_grid);
Ntime = numel(smbtime);

md.smb.precipitation = [ones(Nx*Ny,Ntime)*0.1; smbtime];
md.smb.temperature = [reshape([1:Nx*Ny*Ntime], Nx*Ny, Ntime)/2-(Nx*Ny)+273.15;smbtime];
%md.smb.temperature = [ones(Nlat*Nlon,Ntime)*3.6; smbtime];

md.transient.isthermal=0;
md.timestepping.cycle_forcing=0;

md.transient.requested_outputs={'default','SmbTemperature', 'SmbPrecipitation','SmbAccumulation','SmbAblation','SmbMeanTemperature'};
%md.verbose = verbose('solution',1);
md=solve(md,'Transient');


t = [md.results.TransientSolution(:).SmbTemperature];
p = [md.results.TransientSolution(:).SmbPrecipitation];
meant = [md.results.TransientSolution(:).SmbMeanTemperature];

%Fields and tolerances to track changes
field_names ={...
   'Temperature1','Precipitation1','Accumulation1',...
   'Ablation1','SmbMeanTemperature1','SmbMassBalance1',...
   'Temperature2','Precipitation2','Accumulation2',...
   'Ablation2','SmbMeanTemperature2','SmbMassBalance2',...
   'Temperature3','Precipitation3','Accumulation3',...
   'Ablation3','SmbMeanTemperature3','SmbMassBalance3',...
   'Temperature4','Precipitation4','Accumulation4',...
   'Ablation4','SmbMeanTemperature4','SmbMassBalance4'};
field_tolerances={...
   1e-13, 1e-11, 1e-13, 1e-13, 1e-13, 1e-13,...
   1e-13, 1e-11, 1e-13, 1e-13, 1e-13, 1e-13,...
   1e-13, 1e-11, 1e-13, 1e-13, 1e-13, 1e-13,...
   1e-13, 1e-11, 1e-13, 1e-13, 1e-13, 1e-13};
field_values={...
   md.results.TransientSolution(1).SmbTemperature, ...
   md.results.TransientSolution(1).SmbPrecipitation,...
   md.results.TransientSolution(1).SmbAccumulation,...
   md.results.TransientSolution(1).SmbAblation,...
   md.results.TransientSolution(1).SmbMeanTemperature,...
   md.results.TransientSolution(1).SmbMassBalance,...
   md.results.TransientSolution(2).SmbTemperature, ...
   md.results.TransientSolution(2).SmbPrecipitation,...
   md.results.TransientSolution(2).SmbAccumulation,...
   md.results.TransientSolution(2).SmbAblation,...
   md.results.TransientSolution(2).SmbMeanTemperature,...
   md.results.TransientSolution(2).SmbMassBalance,...
   md.results.TransientSolution(6).SmbTemperature, ...
   md.results.TransientSolution(6).SmbPrecipitation,...
   md.results.TransientSolution(6).SmbAccumulation,...
   md.results.TransientSolution(6).SmbAblation,...
   md.results.TransientSolution(6).SmbMeanTemperature,...
   md.results.TransientSolution(6).SmbMassBalance,...
   md.results.TransientSolution(11).SmbTemperature, ...
   md.results.TransientSolution(11).SmbPrecipitation,...
   md.results.TransientSolution(11).SmbAccumulation,...
   md.results.TransientSolution(11).SmbAblation,...
   md.results.TransientSolution(11).SmbMeanTemperature,...
   md.results.TransientSolution(11).SmbMassBalance};
