%Test Name: PigTranFrontalforcingsrignot
md=triangle(model(),'../Exp/Pig.exp',10000.);
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=setflowequation(md,'SSA','all');
md.timestepping.time_step=2;
md.timestepping.final_time=50;

%separate domain in 2 basins
idbasin = zeros(md.mesh.numberofelements,1);
iid1    = find(md.mesh.x<=-1.6e6);
for ii=1:md.mesh.numberofelements
    for vertex=1:3
        if any(iid1==md.mesh.elements(ii,vertex)) %one vertex in basin 1
            idbasin(ii) = 1;
        end
    end
    if idbasin(ii)==0 %no vertex was found in basin 1
        idbasin(ii) = 2;
    end
end

%calving and frontalforcings parameters
md.mask.ice_levelset = 1e4*(md.mask.ice_levelset + 0.5);
md.calving=calvingvonmises();
md.frontalforcings=frontalforcingsrignot();
md.frontalforcings.num_basins = 2;
md.frontalforcings.basin_id = idbasin;
md.frontalforcings.subglacial_discharge = 0.1*ones(md.mesh.numberofvertices,1);
md.frontalforcings.thermalforcing = 0.5*ones(md.mesh.numberofvertices,1);
for elem=1:md.mesh.numberofelements
    if idbasin(elem)==2
        md.frontalforcings.thermalforcing(md.mesh.elements(elem,1:3)) = 1.5;
    end
end

md.transient.ismovingfront = 1;
md.levelset.spclevelset = NaN(md.mesh.numberofvertices,1);
md.levelset.migration_max = 1e10;

md.transient.requested_outputs = {'default','CalvingMeltingrate'};
md.cluster=generic('name',oshostname(),'np',2);
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names ={...
   'Vx1' ,'Vy1' ,'Vel1' ,'Pressure1' ,'Bed1' ,'Surface1' ,'Thickness1' ,'MaskIceLevelset1', 'CalvingMeltingrate1',...
   'Vx2' ,'Vy2' ,'Vel2' ,'Pressure2' ,'Bed2' ,'Surface2' ,'Thickness2' ,'MaskIceLevelset2', 'CalvingMeltingrate2',...
   'Vx10','Vy10','Vel10','Pressure10','Bed10','Surface10','Thickness10','MaskIceLevelset10', 'CalvingMeltingrate10',...
   };
field_tolerances={...
   1e-11,2e-11,2e-11,1e-12,2e-11,6e-12,9e-12,1e-12,1e-9,...
   2e-11,1e-11,1e-11,9e-12,2e-1,2e-11,2e-11,1e-11,1e-9,...
   2e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,1e-9,1e-9,...
   };
field_values={...
   (md.results.TransientSolution(1).Vx),...
   (md.results.TransientSolution(1).Vy),...
   (md.results.TransientSolution(1).Vel),...
   (md.results.TransientSolution(1).Pressure),...
   (md.results.TransientSolution(1).Base),...
   (md.results.TransientSolution(1).Surface),...
   (md.results.TransientSolution(1).Thickness),...
   (md.results.TransientSolution(1).MaskIceLevelset),...
   (md.results.TransientSolution(1).CalvingMeltingrate),...
   (md.results.TransientSolution(2).Vx),...
   (md.results.TransientSolution(2).Vy),...
   (md.results.TransientSolution(2).Vel),...
   (md.results.TransientSolution(2).Pressure),...
   (md.results.TransientSolution(2).Base),...
   (md.results.TransientSolution(2).Surface),...
   (md.results.TransientSolution(2).Thickness),...
   (md.results.TransientSolution(2).MaskIceLevelset),...
   (md.results.TransientSolution(2).CalvingMeltingrate),...
   (md.results.TransientSolution(10).Vx),...
   (md.results.TransientSolution(10).Vy),...
   (md.results.TransientSolution(10).Vel),...
   (md.results.TransientSolution(10).Pressure),...
   (md.results.TransientSolution(10).Base),...
   (md.results.TransientSolution(10).Surface),...
   (md.results.TransientSolution(10).Thickness),...
   (md.results.TransientSolution(10).MaskIceLevelset),...
   (md.results.TransientSolution(10).CalvingMeltingrate),...
   };
