/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.CBZip2InputStream;
import installer.Install;
import installer.OperatingSystem;
import installer.Progress;
import installer.TarEntry;
import installer.TarInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class InstallThread
extends Thread {
    private Install installer;
    private Progress progress;
    private String installDir;
    private OperatingSystem.OSTask[] osTasks;
    private int size;
    private Vector components;
    private Vector indicies;
    public static final int DB_eq = 0;
    public static final int DB_record = 1;
    public static final int DB_digi_int = 2;
    public static final int DB_mom_mag = 3;
    public static final int DB_arias = 4;
    public static final int DB_dobry = 5;
    public static final int DB_pga = 6;
    public static final int DB_pgv = 7;
    public static final int DB_mean_per = 8;
    public static final int DB_epi_dist = 9;
    public static final int DB_foc_dist = 10;
    public static final int DB_rup_dist = 11;
    public static final int DB_vs30 = 12;
    public static final int DB_class = 13;
    public static final int DB_foc_mech = 14;
    public static final int DB_location = 15;
    public static final int DB_owner = 16;
    public static final int DB_latitude = 17;
    public static final int DB_longitude = 18;
    public static final int DB_LENGTH = 19;
    private Connection connection = null;
    public static final String url = "jdbc:derby:db";
    private Vector dbvect = new Vector();

    public InstallThread(Install installer, Progress progress, String installDir, OperatingSystem.OSTask[] osTasks, int size, Vector components, Vector indicies) {
        super("Install thread");
        this.installer = installer;
        this.progress = progress;
        this.installDir = installDir;
        this.osTasks = osTasks;
        this.size = size;
        this.components = components;
        this.indicies = indicies;
    }

    @Override
    public void run() {
        this.progress.setMaximum(this.size * 1024 * 2);
        try {
            int i;
            for (i = 0; i < this.components.size(); ++i) {
                String comp = (String)this.components.elementAt(i);
                System.err.println("Installing " + comp);
                this.installComponent(comp);
            }
            for (i = 0; i < this.osTasks.length; ++i) {
                System.err.println("Performing task " + this.osTasks[i].getName());
                this.osTasks[i].perform(this.installDir, this.components);
            }
        }
        catch (FileNotFoundException fnf) {
            this.progress.error("The installer could not create the destination directory.\nMaybe you do not have write permission?");
            return;
        }
        catch (IOException io) {
            this.progress.error(io.toString());
            return;
        }
        try {
            String sqlfile;
            int sqllen = 0;
            String DBloc = this.installDir + File.separator + "programs" + File.separator + "database" + File.separator + "db";
            File f = new File(DBloc);
            boolean newDB = !f.exists();
            this.startdb(newDB);
            for (int j = 0; j < this.components.size(); ++j) {
                sqlfile = this.installer.getProperty("comp." + ((Integer)this.indicies.elementAt(j)).toString() + ".sql");
                if (sqlfile == null) continue;
                String outfile = this.installDir + File.separator + "records" + File.separator + sqlfile;
                BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream("/records/" + sqlfile));
                if (in == null) {
                    throw new FileNotFoundException(sqlfile);
                }
                this.installer.copy(in, outfile, null);
                ((InputStream)in).close();
                this.dbvect.addElement(sqlfile);
                sqllen += this.installer.getIntegerProperty("comp." + ((Integer)this.indicies.elementAt(j)).toString() + ".sqllen");
            }
            this.progress.setMaximum(sqllen * 2);
            this.progress.advance(sqllen);
            String q = "insert into data (eq, record, digi_int, mom_mag, arias, dobry, pga, pgv, mean_per, epi_dist, foc_dist, rup_dist, vs30, class, foc_mech, location, owner, latitude, longitude, change, path, select1, analyze, select2) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            for (int i = 0; i < this.dbvect.size(); ++i) {
                sqlfile = (String)this.dbvect.elementAt(i);
                FileReader fr = new FileReader(this.installDir + File.separator + "records" + File.separator + sqlfile);
                String s = "";
                String[] cur = new String[19];
                int j = 0;
                block14: while (fr.ready()) {
                    char c = (char)fr.read();
                    switch (c) {
                        case '\r': {
                            continue block14;
                        }
                        case '\t': {
                            cur[j] = s;
                            ++j;
                            s = "";
                            continue block14;
                        }
                        case '\n': {
                            cur[j] = s;
                            s = "";
                            j = 0;
                            if (this.countQuery("select count(*) from data where eq=? and record=?", cur[0], cur[1]) > 0) {
                                System.out.println(cur[0] + " - " + cur[1] + ": already in db");
                                continue block14;
                            }
                            this.progress.advance(1);
                            String path = this.installDir + File.separator + "records" + File.separator + cur[0] + File.separator + cur[1];
                            PreparedStatement ps = this.preparedStatement(q);
                            int idx = 1;
                            ps.setObject(idx++, cur[0]);
                            ps.setObject(idx++, cur[1]);
                            ps.setObject(idx++, cur[2]);
                            ps.setObject(idx++, (Object)this.nullify(cur[3]), 12);
                            ps.setObject(idx++, cur[4]);
                            ps.setObject(idx++, cur[5]);
                            ps.setObject(idx++, cur[6]);
                            ps.setObject(idx++, cur[7]);
                            ps.setObject(idx++, cur[8]);
                            ps.setObject(idx++, (Object)this.nullify(cur[9]), 12);
                            ps.setObject(idx++, (Object)this.nullify(cur[10]), 12);
                            ps.setObject(idx++, (Object)this.nullify(cur[11]), 12);
                            ps.setObject(idx++, (Object)this.nullify(cur[12]), 12);
                            ps.setObject(idx++, cur[13]);
                            ps.setObject(idx++, cur[14]);
                            ps.setObject(idx++, cur[15]);
                            ps.setObject(idx++, cur[16]);
                            ps.setObject(idx++, (Object)this.nullify(cur[17]), 12);
                            ps.setObject(idx++, (Object)this.nullify(cur[18]), 12);
                            ps.setObject(idx++, 0);
                            ps.setObject(idx++, path);
                            ps.setObject(idx++, 0);
                            ps.setObject(idx++, 0);
                            ps.setObject(idx++, 0);
                            ps.executeUpdate();
                            ps.close();
                            continue block14;
                        }
                    }
                    s = s + c;
                }
            }
            this.preparedUpdate("update data set mag_srch=cast(cast(mom_mag as decimal(10,4)) as double), epi_srch=cast(cast(epi_dist as decimal(10,4)) as double), foc_srch=cast(cast(foc_dist as decimal(10,4)) as double), rup_srch=cast(cast(rup_dist as decimal(10,4)) as double), vs30_srch=cast(cast(vs30 as decimal(10,4)) as double), lat_srch=cast(cast(latitude as decimal(20,15)) as double), lng_srch=cast(cast(longitude as decimal(20,15)) as double)", new Object[0]);
            this.closedb();
        }
        catch (Exception ex) {
            this.progress.error(ex.toString());
            ex.printStackTrace();
        }
        this.progress.done();
    }

    private void installComponent(String name) throws IOException {
        TarEntry entry;
        BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(name + ".tar.bz2"));
        ((InputStream)in).read();
        ((InputStream)in).read();
        TarInputStream tarInput = new TarInputStream(new CBZip2InputStream(in));
        while ((entry = tarInput.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String fileName = entry.getName();
            String outfile = this.installDir + File.separator + fileName.replace('/', File.separatorChar);
            this.installer.copy(tarInput, outfile, this.progress);
        }
        tarInput.close();
    }

    public void startdb(boolean newDB) throws Exception {
        if (this.connection != null) {
            return;
        }
        System.setProperty("derby.system.home", this.installDir + File.separator + "programs" + File.separator + "database");
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        String connect_url = url;
        if (newDB) {
            connect_url = connect_url + ";create=true";
        }
        this.connection = DriverManager.getConnection(connect_url);
        if (newDB) {
            this.preparedUpdate("create table data (id        integer      not null generated always as identity primary key,eq        varchar(100) not null,record    varchar(100) not null,digi_int  double       not null,mom_mag   varchar(20)          ,arias     double       not null,dobry     double       not null,pga       double       not null,pgv       double       not null,mean_per  double       not null,epi_dist  varchar(20)          ,foc_dist  varchar(20)          ,rup_dist  varchar(20)          ,vs30      varchar(20)          ,class     smallint     not null,foc_mech  smallint     not null,location  varchar(100) not null,owner     varchar(100) not null,latitude  varchar(20)          ,longitude varchar(20)          ,change    smallint     not null,path      varchar(255) not null,select1   smallint     not null,analyze   smallint     not null,select2   smallint     not null,mag_srch  double,epi_srch  double,foc_srch  double,rup_srch  double,vs30_srch double,lat_srch  double,lng_srch  double)", new Object[0]);
            this.preparedUpdate("create table grp (record    integer      not null,name      varchar(100) not null,analyze   smallint     not null)", new Object[0]);
        }
    }

    public int preparedUpdate(String update, Object ... objects) throws SQLException {
        int i;
        PreparedStatement ps = this.connection.prepareStatement(update);
        for (i = 0; i < objects.length; ++i) {
            ps.setObject(i + 1, objects[i]);
        }
        i = ps.executeUpdate();
        ps.close();
        return i;
    }

    public PreparedStatement preparedStatement(String s) throws SQLException {
        return this.connection.prepareStatement(s);
    }

    private int countQuery(String query, Object ... objects) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(query, 1004, 1007);
        for (int i = 0; i < objects.length; ++i) {
            ps.setObject(i + 1, objects[i]);
        }
        ResultSet result = ps.executeQuery();
        result.next();
        int ret = result.getInt(1);
        ps.close();
        return ret;
    }

    public void closedb() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            try {
                DriverManager.getConnection("jdbc:derby:db;shutdown=true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String nullify(String s) {
        if (s.equals("")) {
            return null;
        }
        return s;
    }
}

