/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public abstract class OperatingSystem {
    private static OperatingSystem os;

    public abstract String getInstallDirectory(String var1);

    public OSTask[] getOSTasks(Install installer) {
        return new OSTask[0];
    }

    public void mkdirs(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static OperatingSystem getOperatingSystem() {
        String osName;
        if (os != null) {
            return os;
        }
        os = System.getProperty("mrj.version") != null ? new MacOS() : ((osName = System.getProperty("os.name")).indexOf("Windows") != -1 ? new Windows() : new Unix());
        return os;
    }

    public static class Windows
    extends OperatingSystem {
        @Override
        public String getInstallDirectory(String name) {
            String dir = System.getenv("ProgramFiles");
            if (!new File(dir, name).canWrite()) {
                dir = System.getProperty("user.home");
            }
            return new File(dir, name).getPath();
        }
    }

    public static class MacOS
    extends Unix {
        @Override
        public String getInstallDirectory(String name) {
            return "/Applications/" + name;
        }

        @Override
        public String getExtraClassPath() {
            return "/System/Library/Java/:";
        }
    }

    public static class Unix
    extends OperatingSystem {
        @Override
        public String getInstallDirectory(String name) {
            String dir = "/usr/local/share/";
            if (!new File(dir).canWrite()) {
                dir = System.getProperty("user.home");
            }
            return new File(dir, name.toLowerCase()).getPath();
        }

        public String getExtraClassPath() {
            return "";
        }

        @Override
        public OSTask[] getOSTasks(Install installer) {
            return new OSTask[]{new ScriptOSTask(installer)};
        }

        public void exec(String[] args) throws IOException {
            Process proc = Runtime.getRuntime().exec(args);
            proc.getInputStream().close();
            proc.getOutputStream().close();
            proc.getErrorStream().close();
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public class ScriptOSTask
        extends OSTask {
            public ScriptOSTask(Install installer) {
                super(installer, "unix-script");
            }

            @Override
            public String getDefaultDirectory(Install installer) {
                String dir = "/usr/local/";
                if (!new File(dir).canWrite()) {
                    dir = System.getProperty("user.home");
                }
                return new File(dir, "bin").getPath();
            }

            @Override
            public void perform(String installDir, Vector filesets) throws IOException {
                if (!this.enabled) {
                    return;
                }
                File file = new File(this.directory);
                file.mkdirs();
                String name = this.installer.getProperty("app.jar");
                String script = this.directory + File.separatorChar + name.toLowerCase();
                new File(script).delete();
                FileWriter out = new FileWriter(script);
                out.write("#!/bin/sh\n");
                out.write("# Java heap size, in megabytes\n");
                out.write("JAVA_HEAP_SIZE=128\n");
                out.write("DEFAULT_JAVA_HOME=\"" + System.getProperty("java.home") + "\"\n");
                out.write("if [ \"$JAVA_HOME\" = \"\" ]; then\n");
                out.write("JAVA_HOME=\"$DEFAULT_JAVA_HOME\"\n");
                out.write("fi\n");
                out.write("cd \"" + installDir + "/programs\"\n");
                out.write("exec \"$JAVA_HOME/bin/java\" -mx${JAVA_HEAP_SIZE}m -jar " + name + ".jar\n");
                out.close();
                String[] chmodArgs = new String[]{"chmod", "755", script};
                Unix.this.exec(chmodArgs);
            }
        }
    }

    public static abstract class OSTask {
        protected Install installer;
        protected String name;
        protected String label;
        protected String directory;
        protected boolean enabled;

        public OSTask(Install installer, String name) {
            this.installer = installer;
            this.name = name;
            this.label = installer.getProperty("ostask." + name + ".label");
            this.directory = this.getDefaultDirectory(installer);
            this.enabled = true;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDefaultDirectory(Install installer) {
            return null;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public abstract void perform(String var1, Vector var2) throws IOException;
    }
}

