/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.InstallThread;
import installer.OperatingSystem;
import installer.Progress;
import installer.VariableGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwingInstall
extends JFrame {
    Install installer = new Install();
    OperatingSystem.OSTask[] osTasks = OperatingSystem.getOperatingSystem().getOSTasks(this.installer);
    String appName = this.installer.getProperty("app.name");
    JLabel caption;
    ChooseDirectory chooseDirectory;
    SelectComponents selectComponents;
    SwingProgress progress;
    JButton cancelButton;
    JButton prevButton;
    JButton nextButton;
    Component[] pages;
    int currentPage;
    private static final int PADDING = 12;

    public SwingInstall() {
        this.setTitle(this.appName + " installer");
        JPanel content = new JPanel(new WizardLayout());
        this.setContentPane(content);
        this.caption = new JLabel();
        this.caption.setFont(new Font("SansSerif", 1, 18));
        ActionHandler actionHandler = new ActionHandler();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setRequestFocusEnabled(false);
        this.cancelButton.addActionListener(actionHandler);
        this.prevButton = new JButton("Previous");
        this.prevButton.setRequestFocusEnabled(false);
        this.prevButton.addActionListener(actionHandler);
        this.nextButton = new JButton();
        this.nextButton.setRequestFocusEnabled(false);
        this.nextButton.addActionListener(actionHandler);
        content.add(this.caption);
        content.add(this.cancelButton);
        content.add(this.prevButton);
        content.add(this.nextButton);
        String clazz = OperatingSystem.getOperatingSystem().getClass().getName();
        String completedInfo = "done-" + clazz.substring(clazz.indexOf(36) + 1) + ".html";
        Component[] componentArray = new Component[3];
        this.chooseDirectory = new ChooseDirectory();
        componentArray[0] = this.chooseDirectory;
        this.progress = new SwingProgress();
        componentArray[1] = this.progress;
        componentArray[2] = new TextPanel(completedInfo);
        this.pages = componentArray;
        this.selectComponents = new SelectComponents();
        for (int i = 0; i < this.pages.length; ++i) {
            content.add(this.pages[i]);
        }
        this.pageChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    void install() {
        Vector<String> components = new Vector<String>();
        Vector<Integer> indicies = new Vector<Integer>();
        int size = 0;
        JPanel comp = this.selectComponents.comp;
        Vector ids = this.selectComponents.filesets;
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            if (!((JCheckBox)comp.getComponent(i)).getModel().isSelected()) continue;
            size += this.installer.getIntegerProperty("comp." + ids.elementAt(i) + ".real-size");
            components.addElement(this.installer.getProperty("comp." + ids.elementAt(i) + ".fileset"));
            indicies.addElement(new Integer(i));
        }
        String installDir = this.chooseDirectory.installDir.getText();
        Map osTaskDirs = this.chooseDirectory.osTaskDirs;
        for (OperatingSystem.OSTask osTask : osTaskDirs.keySet()) {
            String dir = ((JTextField)osTaskDirs.get(osTask)).getText();
            if (dir != null && dir.length() != 0) {
                osTask.setEnabled(true);
                osTask.setDirectory(dir);
                continue;
            }
            osTask.setEnabled(false);
        }
        InstallThread thread = new InstallThread(this.installer, this.progress, installDir, this.osTasks, size, components, indicies);
        this.progress.setThread(thread);
        thread.start();
    }

    private void pageChanged() {
        switch (this.currentPage) {
            case 0: {
                this.caption.setText("Specify where " + this.appName + " is to be installed");
                this.nextButton.setText("Next");
                this.prevButton.setEnabled(true);
                break;
            }
            case 1: {
                this.caption.setText("Installing " + this.appName);
                this.nextButton.setText("Finish");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                this.install();
                break;
            }
            case 2: {
                this.caption.setText("Installation complete");
                this.nextButton.setText("Finish");
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(true);
                this.cancelButton.setEnabled(false);
            }
        }
        this.getRootPane().invalidate();
        this.getRootPane().validate();
    }

    class SwingProgress
    extends JPanel
    implements Progress {
        JProgressBar progress;
        InstallThread thread;

        SwingProgress() {
            super(new BorderLayout());
            this.progress = new JProgressBar();
            this.progress.setStringPainted(true);
            this.add("North", this.progress);
        }

        @Override
        public void setMaximum(final int max) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingProgress.this.progress.setMaximum(max);
                    SwingProgress.this.progress.setValue(0);
                }
            });
        }

        @Override
        public void advance(final int value) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingProgress.this.progress.setValue(SwingProgress.this.progress.getValue() + value);
                    }
                });
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ++SwingInstall.this.currentPage;
                    SwingInstall.this.pageChanged();
                }
            });
        }

        @Override
        public void error(final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingInstall.this.dispose();
                    JOptionPane.showMessageDialog(null, message, "Installation aborted", 0);
                    System.exit(1);
                }
            });
        }

        public void setThread(InstallThread thread) {
            this.thread = thread;
        }
    }

    class SelectComponents
    extends JPanel
    implements ActionListener {
        JPanel comp;
        JLabel sizeLabel;
        Vector filesets;

        SelectComponents() {
            super(new BorderLayout());
            this.comp = this.createCompPanel();
            this.add("North", this.comp);
            this.sizeLabel = new JLabel("", 2);
            this.add("South", this.sizeLabel);
            this.updateSize();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateSize();
        }

        private JPanel createCompPanel() {
            this.filesets = new Vector();
            int count = SwingInstall.this.installer.getIntegerProperty("comp.count");
            JPanel panel = new JPanel(new GridLayout(count, 1));
            String osClass = OperatingSystem.getOperatingSystem().getClass().getName();
            osClass = osClass.substring(osClass.indexOf(36) + 1);
            for (int i = 0; i < count; ++i) {
                String os = SwingInstall.this.installer.getProperty("comp." + i + ".os");
                if (os != null && !osClass.equals(os)) continue;
                JCheckBox checkBox = new JCheckBox(SwingInstall.this.installer.getProperty("comp." + i + ".name") + " (" + SwingInstall.this.installer.getProperty("comp." + i + ".disk-size") + "Mb)");
                checkBox.getModel().setSelected(true);
                checkBox.addActionListener(this);
                checkBox.setRequestFocusEnabled(false);
                this.filesets.addElement(new Integer(i));
                panel.add(checkBox);
            }
            Dimension dim = panel.getPreferredSize();
            dim.width = Integer.MAX_VALUE;
            panel.setMaximumSize(dim);
            return panel;
        }

        private void updateSize() {
            int size = 0;
            for (int i = 0; i < this.filesets.size(); ++i) {
                if (!((JCheckBox)this.comp.getComponent(i)).getModel().isSelected()) continue;
                size += SwingInstall.this.installer.getIntegerProperty("comp." + this.filesets.elementAt(i) + ".disk-size");
            }
            this.sizeLabel.setText("Estimated disk usage of selected components: " + size + "Mb");
        }
    }

    class ChooseDirectory
    extends JPanel {
        JTextField installDir;
        Map osTaskDirs;

        ChooseDirectory() {
            super(new BorderLayout());
            this.osTaskDirs = new HashMap();
            JPanel directoryPanel = new JPanel(new VariableGridLayout(2, 3, 12, 12));
            this.installDir = this.addField(directoryPanel, "Install program in:", OperatingSystem.getOperatingSystem().getInstallDirectory(SwingInstall.this.appName));
            for (int i = 0; i < SwingInstall.this.osTasks.length; ++i) {
                OperatingSystem.OSTask osTask = SwingInstall.this.osTasks[i];
                String label = osTask.getLabel();
                if (label == null) continue;
                JTextField field = this.addField(directoryPanel, label, osTask.getDirectory());
                this.osTaskDirs.put(osTask, field);
            }
            this.add("North", directoryPanel);
        }

        private JTextField addField(JPanel directoryPanel, String label, String defaultText) {
            JTextField field = new JTextField(defaultText);
            directoryPanel.add(new JLabel(label, 4));
            Box fieldBox = new Box(1);
            fieldBox.add(Box.createGlue());
            Dimension dim = field.getPreferredSize();
            dim.width = Integer.MAX_VALUE;
            field.setMaximumSize(dim);
            fieldBox.add(field);
            fieldBox.add(Box.createGlue());
            directoryPanel.add(fieldBox);
            JButton choose = new JButton("Choose...");
            choose.setRequestFocusEnabled(false);
            choose.addActionListener(new ActionHandler(field));
            directoryPanel.add(choose);
            return field;
        }

        class ActionHandler
        implements ActionListener {
            JTextField field;

            ActionHandler(JTextField field) {
                this.field = field;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                File directory = new File(this.field.getText());
                JFileChooser chooser = new JFileChooser(directory.getParent());
                chooser.setFileSelectionMode(1);
                chooser.setSelectedFile(directory);
                if (chooser.showOpenDialog(SwingInstall.this) == 0) {
                    this.field.setText(chooser.getSelectedFile().getPath());
                }
            }
        }
    }

    class TextPanel
    extends JPanel {
        TextPanel(String file) {
            super(new BorderLayout());
            JEditorPane text = new JEditorPane();
            try {
                text.setPage(this.getClass().getResource(file));
            }
            catch (Exception e) {
                text.setText("Error loading '" + file + "'");
                e.printStackTrace();
            }
            text.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(text);
            Dimension dim = new Dimension();
            dim.width = 450;
            dim.height = 200;
            scrollPane.setPreferredSize(dim);
            this.add("Center", scrollPane);
        }
    }

    class WizardLayout
    implements LayoutManager {
        WizardLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = new Dimension();
            Dimension captionSize = SwingInstall.this.caption.getPreferredSize();
            dim.width = captionSize.width;
            for (int i = 0; i < SwingInstall.this.pages.length; ++i) {
                Dimension _dim = SwingInstall.this.pages[i].getPreferredSize();
                dim.width = Math.max(_dim.width, dim.width);
                dim.height = Math.max(_dim.height, dim.height);
            }
            dim.width += 24;
            dim.height += 24;
            dim.height += SwingInstall.this.nextButton.getPreferredSize().height;
            dim.height += captionSize.height;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Dimension captionSize = SwingInstall.this.caption.getPreferredSize();
            SwingInstall.this.caption.setBounds(12, 12, captionSize.width, captionSize.height);
            Dimension buttonSize = SwingInstall.this.cancelButton.getPreferredSize();
            buttonSize.width = Math.max(buttonSize.width, SwingInstall.this.prevButton.getPreferredSize().width);
            buttonSize.width = Math.max(buttonSize.width, SwingInstall.this.nextButton.getPreferredSize().width);
            SwingInstall.this.cancelButton.setBounds(12, size.height - buttonSize.height - 12, buttonSize.width, buttonSize.height);
            SwingInstall.this.prevButton.setBounds(size.width - buttonSize.width * 2 - 6 - 12, size.height - buttonSize.height - 12, buttonSize.width, buttonSize.height);
            SwingInstall.this.nextButton.setBounds(size.width - buttonSize.width - 12, size.height - buttonSize.height - 12, buttonSize.width, buttonSize.height);
            Rectangle currentPageBounds = new Rectangle();
            currentPageBounds.x = 12;
            currentPageBounds.y = 24 + captionSize.height;
            currentPageBounds.width = size.width - currentPageBounds.x - 12;
            currentPageBounds.height = size.height - buttonSize.height - currentPageBounds.y - 24;
            for (int i = 0; i < SwingInstall.this.pages.length; ++i) {
                Component page = SwingInstall.this.pages[i];
                page.setBounds(currentPageBounds);
                page.setVisible(i == SwingInstall.this.currentPage);
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            System.exit(0);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SwingInstall.this.cancelButton) {
                System.exit(0);
            } else if (source == SwingInstall.this.prevButton) {
                --SwingInstall.this.currentPage;
                SwingInstall.this.pageChanged();
            } else if (source == SwingInstall.this.nextButton) {
                if (SwingInstall.this.currentPage == SwingInstall.this.pages.length - 1) {
                    System.exit(0);
                } else {
                    ++SwingInstall.this.currentPage;
                    SwingInstall.this.pageChanged();
                }
            }
        }
    }
}

