/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ClobUpdatableReader;
import org.apache.derby.impl.jdbc.ClobUtf8Writer;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;

final class TemporaryClob
implements InternalClob {
    private ConnectionChild conChild;
    private final LOBStreamControl bytes;
    private boolean released = false;
    private final CharToBytePositionCache posCache = new CharToBytePositionCache();

    static InternalClob cloneClobContent(String string, ConnectionChild connectionChild, InternalClob internalClob) throws IOException, SQLException {
        TemporaryClob temporaryClob = new TemporaryClob(connectionChild);
        temporaryClob.copyClobContent(internalClob);
        return temporaryClob;
    }

    static InternalClob cloneClobContent(String string, ConnectionChild connectionChild, InternalClob internalClob, long l) throws IOException, SQLException {
        TemporaryClob temporaryClob = new TemporaryClob(connectionChild);
        temporaryClob.copyClobContent(internalClob, l);
        return temporaryClob;
    }

    TemporaryClob(ConnectionChild connectionChild) {
        if (connectionChild == null) {
            throw new NullPointerException("conChild cannot be <null>");
        }
        this.conChild = connectionChild;
        this.bytes = new LOBStreamControl(connectionChild.getEmbedConnection());
    }

    public synchronized void release() throws IOException {
        if (!this.released) {
            this.released = true;
            this.bytes.free();
        }
    }

    public synchronized InputStream getRawByteStream() throws IOException {
        this.checkIfValid();
        return this.bytes.getInputStream(0L);
    }

    TemporaryClob(String string, ConnectionChild connectionChild) throws IOException, SQLException, StandardException {
        if (connectionChild == null) {
            throw new NullPointerException("conChild cannot be <null>");
        }
        this.conChild = connectionChild;
        this.bytes = new LOBStreamControl(connectionChild.getEmbedConnection(), this.getByteFromString(string));
    }

    public synchronized long getBytePosition(long l) throws IOException {
        long l2;
        this.checkIfValid();
        if (l == this.posCache.getCharPos()) {
            l2 = this.posCache.getBytePos();
        } else {
            long l3 = 0L;
            long l4 = l - 1L;
            if (l > this.posCache.getCharPos()) {
                l3 = this.posCache.getBytePos();
                l4 -= this.posCache.getCharPos() - 1L;
            }
            InputStream inputStream = this.bytes.getInputStream(l3);
            l2 = l3 + UTF8Util.skipFully(new BufferedInputStream(inputStream), l4);
            this.posCache.updateCachedPos(l, l2);
        }
        return l2;
    }

    public synchronized Writer getWriter(long l) throws IOException, SQLException {
        this.checkIfValid();
        if (l < this.posCache.getCharPos()) {
            this.posCache.reset();
        }
        return new ClobUtf8Writer(this, l);
    }

    public synchronized Reader getReader(long l) throws IOException, SQLException {
        long l2;
        this.checkIfValid();
        if (l < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + l);
        }
        ClobUpdatableReader clobUpdatableReader = new ClobUpdatableReader((LOBInputStream)this.getRawByteStream(), this.conChild);
        for (long i = l - 1L; i > 0L; i -= l2) {
            l2 = clobUpdatableReader.skip(i);
            if (l2 > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return clobUpdatableReader;
    }

    public synchronized long getCharLength() throws IOException {
        this.checkIfValid();
        return UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
    }

    public synchronized long getByteLength() throws IOException {
        this.checkIfValid();
        return this.bytes.getLength();
    }

    public synchronized long insertString(String string, long l) throws IOException, SQLException {
        long l2;
        this.checkIfValid();
        if (l < 1L) {
            throw new IllegalArgumentException("Position must be positive: " + l);
        }
        long l3 = this.getBytePosition(l);
        long l4 = this.bytes.getLength();
        byte[] byArray = this.getByteFromString(string);
        if (l3 == l4) {
            try {
                this.bytes.write(byArray, 0, byArray.length, l3);
            }
            catch (StandardException standardException) {
                throw Util.generateCsSQLException(standardException);
            }
        }
        try {
            l2 = this.getBytePosition(l + (long)string.length());
            this.posCache.updateCachedPos(l, l3);
        }
        catch (EOFException eOFException) {
            l2 = l4;
        }
        try {
            this.bytes.replaceBytes(byArray, l3, l2);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
        return string.length();
    }

    public boolean isWritable() {
        return true;
    }

    public synchronized void truncate(long l) throws IOException, SQLException {
        this.checkIfValid();
        try {
            long l2 = UTF8Util.skipFully(new BufferedInputStream(this.getRawByteStream()), l);
            this.bytes.truncate(l2);
            if (l <= this.posCache.getCharPos()) {
                this.posCache.reset();
            }
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private byte[] getByteFromString(String string) {
        byte[] byArray = new byte[3 * string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private void copyClobContent(InternalClob internalClob) throws IOException, SQLException {
        try {
            long l = internalClob.getByteLength();
            this.bytes.copyData(internalClob.getRawByteStream(), l);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private void copyClobContent(InternalClob internalClob, long l) throws IOException, SQLException {
        try {
            long l2 = UTF8Util.skipFully(new BufferedInputStream(internalClob.getRawByteStream()), l);
            this.bytes.copyData(new BufferedInputStream(internalClob.getRawByteStream()), l2);
        }
        catch (StandardException standardException) {
            throw Util.generateCsSQLException(standardException);
        }
    }

    private final void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }

    private static class CharToBytePositionCache {
        private long charPos = 1L;
        private long bytePos = 0L;

        CharToBytePositionCache() {
        }

        long getBytePos() {
            return this.bytePos;
        }

        long getCharPos() {
            return this.charPos;
        }

        void updateCachedPos(long l, long l2) {
            if (l - 1L > l2) {
                throw new IllegalArgumentException("(charPos -1) cannot be greater than bytePos; " + (l - 1L) + " > " + l2);
            }
            this.charPos = l;
            this.bytePos = l2;
        }

        void reset() {
            this.charPos = 1L;
            this.bytePos = 0L;
        }
    }
}

