/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.OperatingSystem;
import installer.Progress;
import installer.SwingInstall;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Install {
    private Properties props = new Properties();
    private byte[] buf;

    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.7") < 0) {
            System.err.println("You are running Java version " + javaVersion + ".");
            System.err.println("This installer requires Java 1.7 or later.");
            System.exit(1);
        }
        if (args.length == 0) {
            new SwingInstall();
        } else {
            System.err.println("Usage:");
            System.err.println("java -jar <installer JAR>");
        }
    }

    public Install() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/installer/install.props");
            this.props.load(in);
            in.close();
        }
        catch (IOException io) {
            System.err.println("Error loading 'install.props':");
            io.printStackTrace();
        }
        this.buf = new byte[32768];
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public int getIntegerProperty(String name) {
        try {
            return Integer.parseInt(this.props.getProperty(name));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void copy(InputStream in, String outfile, Progress progress) throws IOException {
        int count;
        File outFile = new File(outfile);
        OperatingSystem.getOperatingSystem().mkdirs(outFile.getParent());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        while ((count = in.read(this.buf, 0, Math.min(in.available(), this.buf.length))) != -1 && count != 0) {
            out.write(this.buf, 0, count);
            if (progress == null) continue;
            progress.advance(count);
        }
        out.close();
    }
}

