"""OGGM entity tasks.

This module is simply a shortcut to the core functions
"""
# flake8: noqa
from oggm.core.gis import define_glacier_region
from oggm.core.gis import process_dem
from oggm.core.gis import glacier_masks
from oggm.core.gis import simple_glacier_masks
from oggm.core.gis import rasterio_glacier_mask
from oggm.core.gis import rasterio_glacier_exterior_mask
from oggm.core.gis import compute_hypsometry_attributes
from oggm.core.gis import gridded_attributes
from oggm.core.gis import gridded_mb_attributes
from oggm.core.gis import gridded_data_var_to_geotiff
from oggm.core.gis import rgi7g_to_complex
from oggm.core.centerlines import compute_centerlines
from oggm.core.centerlines import compute_downstream_line
from oggm.core.centerlines import compute_downstream_bedshape
from oggm.core.centerlines import catchment_area
from oggm.core.centerlines import catchment_intersections
from oggm.core.centerlines import initialize_flowlines
from oggm.core.centerlines import catchment_width_geom
from oggm.core.centerlines import catchment_width_correction
from oggm.core.centerlines import terminus_width_correction
from oggm.core.centerlines import elevation_band_flowline
from oggm.core.centerlines import fixed_dx_elevation_band_flowline
from oggm.core.climate import process_climate_data
from oggm.core.climate import process_custom_climate_data
from oggm.core.climate import historical_delta_method
from oggm.core.massbalance import mb_calibration_from_scalar_mb
from oggm.core.massbalance import mb_calibration_from_geodetic_mb
from oggm.core.massbalance import mb_calibration_from_wgms_mb
from oggm.core.massbalance import apparent_mb_from_linear_mb
from oggm.core.massbalance import apparent_mb_from_any_mb
from oggm.core.massbalance import perturbate_mb_params
from oggm.core.massbalance import fixed_geometry_mass_balance
from oggm.core.massbalance import compute_ela
from oggm.shop.w5e5 import process_w5e5_data
from oggm.shop.cru import process_cru_data
from oggm.shop.cru import process_dummy_cru_file
from oggm.shop.histalp import process_histalp_data
from oggm.shop.ecmwf import process_ecmwf_data
from oggm.shop.gcm_climate import process_gcm_data
from oggm.shop.gcm_climate import process_cesm_data
from oggm.shop.gcm_climate import process_monthly_isimip_data
from oggm.shop.gcm_climate import process_cmip_data
from oggm.shop.gcm_climate import process_lmr_data
from oggm.shop.gcm_climate import process_modera_data
from oggm.core.inversion import prepare_for_inversion
from oggm.core.inversion import mass_conservation_inversion
from oggm.core.inversion import filter_inversion_output
from oggm.core.inversion import get_inversion_volume
from oggm.core.inversion import compute_velocities
from oggm.core.inversion import compute_inversion_velocities
from oggm.core.inversion import distribute_thickness_per_altitude
from oggm.core.inversion import distribute_thickness_interp
from oggm.core.inversion import find_inversion_calving_from_any_mb
from oggm.core.flowline import init_present_time_glacier
from oggm.core.flowline import flowline_model_run
from oggm.core.flowline import run_random_climate
from oggm.core.flowline import run_from_climate_data
from oggm.core.flowline import run_constant_climate
from oggm.core.flowline import run_with_hydro
from oggm.core.flowline import compute_fl_diagnostics_quantiles
from oggm.core.dynamic_spinup import run_dynamic_spinup
from oggm.core.dynamic_spinup import run_dynamic_melt_f_calibration
from oggm.utils import copy_to_basedir
from oggm.utils import gdir_to_tar
from oggm.utils import merge_consecutive_run_outputs
